﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true" CodeFile="CcowSiteCode.aspx.cs" Inherits="CcowSiteCode" %>
<%@ Register src="controls/BaseControlDropDownList.ascx" tagname="BaseControlDropDownList" tagprefix="UserControl" %>
<%@ Register src="controls/BaseControlTextBox.ascx" tagname="BaseControlTextBox" tagprefix="UserControl" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
    <script type="text/javascript" language="javascript">
        var sentillionDesc = "<% Response.Write(Helpers.SentillionReasonDesc); %>";
        var sentillionCode = "<% Response.Write(Helpers.SentillionReasonCode); %>";
        var contextDesc = "<% Response.Write(Helpers.ContextReasonDesc); %>";
        var contextCode = "<% Response.Write(Helpers.ContextReasonCode); %>";
        var requestStationAction = "<% Response.Write(Helpers.RequestStationAction); %>";
        var confirmAction = "<% Response.Write(Helpers.ConfirmAction); %>";
        var actionQueryField = "<% Response.Write(Helpers.ActionQueryField); %>";
        var vistaQueryField = "<% Response.Write(Helpers.VistaQueryField); %>";
        var reasonQueryField = "<% Response.Write(Helpers.ReasonQueryField); %>";
    </script>

    <asp:Literal runat="Server" ID="DefaultJavascript">

<object id="ContextorControl" data="data:application/x-oleobject;base64,96x4h6lc0xGHJwBgsLXhNwADAADYEwAA2BMAAA=="
	classid="CLSID:8778ACF7-5CA9-11D3-8727-0060B0B5E137" name="ContextorControl" >
</object>

<script type="text/javascript" language="JavaScript" for="window" event="onLoad()">
    startSentillion();
</script>

<script type="text/javascript" language="javascript">

    var foundID = null;
    var action = null;
    var reason = null;

    function startSentillion() {
        appcode = ""
        appname = "CCOWDisplayer#"
        surveyable = true;
        try {
            ContextorControl.Run(appname, appcode, surveyable);
        } catch (errorObject) {
            //The Sentillion components were not found. Show an error and the site selection box.
            action = requestStationAction;
            reason = sentillionCode;
            setTimeout(ContinueToApplication, 50);
            return;
        }
        processContext(ContextorControl.CurrentContext);
    }


    function processContext(contextItems) {
        try {
            var coll = new Enumerator(contextItems);
            if (coll.atEnd()) {
                //The Sentillion components were found but there is no context.
                LogNoContextFound();
                return;
            }
            //The Sentillion components were found and there is context.
            for (; !coll.atEnd() ; coll.moveNext()) {
                var itemName = coll.item().name;
                var itemValue = coll.item().value;
                if (itemName == "user.id.logon.vistalogon") {
                    //We have everything we need to test the user credentials.
                    action = confirmAction;
                    foundID = itemValue;
                    setTimeout(ContinueToApplication, 50);
                    return;
                }
            }
            //The Sentillion components were found but the field we need was not found in the context. Show the station selection box.
            action = requestStationAction;
            reason = contextCode;
            setTimeout(ContinueToApplication, 50);
        } catch (errorObject) {
            addToDisplay(errorObject.message, errorObject.description);
        }
    }

    function GetBaseLocation() {
        var loc = new String(window.location);
        var found = loc.indexOf('?', 0);
        if (found > 0)
            loc = loc.substring(0, found - 1);
        found = loc.indexOf('#');
        if (found > 0)
            loc = loc.substring(0, found - 1);
        return loc;
    }

    function LogNoContextFound() {
        try {
            var loc = GetBaseLocation();
            var req = new XMLHttpRequest();
            req.open("POST", loc);
            req.setRequestHeader("Content-Type", "text/plain;charset=UTF-8");
            req.send("Error: No Context Found");
        }
        catch (x) {
            //if it doesn't make it to the log there's not much we can do - already displaying error to user
        }
    }

    function ContinueToApplication() {
        window.navigate("CprsLaunch.aspx?from=ccowpage" + "&" + actionQueryField + "=" + action + "&" + vistaQueryField + "=" + foundID + "&" + reasonQueryField + "=" + reason);
    }
</script>

    </asp:Literal>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">

     <div class="breadcrumb">
        <asp:Label SkinID="DataLabel" ID = "LabelBreadCrumb" runat="server" Text="Loading..."/>
    </div>
 </asp:Content>

