﻿using System;
using System.Collections;
using System.Resources;
using System.Drawing;  
using System.Data;
using System.Configuration;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.Collections.Specialized;
using System.Reflection;
using System.Text;
using System.ComponentModel; 
using VeteransAffairs.Registries.BusinessManager;
using System.Collections.Generic;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;
using VeteransAffairs.Registries.BusinessAHOBPR;

/// <summary>
/// Summary description for BasePage
/// </summary>
public abstract class BasePage : Page
{
    public Menu MenuHorizontalMenu;
    public Menu MenuLeftNavigation;
    public Label LabelBreadCrumb;
    protected static ResourceManager resources;
    private UserAccountManager _CurrentUser;
    private bool _errorOnSavedReceived;
    public string _redirectAfterSave;
    private Dictionary<string, string> _OnStartupAlertErrorCollection;
    private SessionFacade userSession;
    
    #region Constructor

    public BasePage() 
    {
        resources = new ResourceManager("Portal.strings", Assembly.GetExecutingAssembly());
        this.Load += new EventHandler(BasePage_Load);
        //SuppressSaveSuccessMessage = true;
    }

    public BasePage(bool errorOnSavedReceived)
    {
        _errorOnSavedReceived = errorOnSavedReceived;
        //SuppressSaveSuccessMessage = true;
    }

    #endregion Constructor

    #region Properities
    public UserAccountManager CurrentUser
    {
        get
        {
            return _CurrentUser;
        }
    }
    public Dictionary<string, string> OnStartupAlertErrorCollection
    {
        get
        {
            if (_OnStartupAlertErrorCollection == null)
                _OnStartupAlertErrorCollection = new Dictionary<string, string>();

            return _OnStartupAlertErrorCollection;
        }
    }
    public bool IgnoreCapabilityCheck { get; set; }
    public bool ReadOnly { get; set; }
    public bool BusinessObjectSaveEventReceived { get; set; }
    public bool SuppressSaveSuccessMessage { get; set; }
    public bool IsSaveSuccess { get; set; }

    public SessionFacade UserSession
    {
        get
        {
            if (userSession == null)
            {
                if (Session != null && Session["UserSession"] != null)
                    userSession = Session["UserSession"] as SessionFacade;
                else
                    userSession = new SessionFacade();
            }

            return userSession;
        }
        set
        {
            userSession = value;
            Session["UserSession"] = userSession;
        }
    }
    
    #endregion Properties

    #region Protected Methods
    protected void manager_BOSaveSuccess(object sender, BaseBO.BOSaveSuccessEventArgs e)
    {
        if (!_errorOnSavedReceived)
        {
            BusinessObjectSaveEventReceived = true;//these two flags are reduntant and should be replaced with e.IsSaveSuccess
        }
    }

    protected void BuildMenusAndBreadCrumb()
    {
        try
        {
            //Get menu list based on user access
            string[] pagesAccessibleByUser = ((UserAccountManager)HttpContext.Current.User).GetPagesByCode();

            MenuHorizontalMenu = (Menu)Master.FindControl("MenuHorizontalMenu");
            MenuLeftNavigation = (Menu)Master.FindControl("MenuLeftNavigation");
            LabelBreadCrumb = (Label)Master.FindControl("LabelBreadCrumb");

            int registrantId = UserSession.RegistrantId;
            //Populate left menu and breadcrumb - based on user roles
            MenuBuilder.BuildDynamicNavigationItems(HttpContext.Current.Request.Url.PathAndQuery,
                MenuHorizontalMenu, TopMenuName(), MenuLeftNavigation, MenuItemName(), LabelBreadCrumb, pagesAccessibleByUser,
                registrantId);
        }
        catch (Exception) { }
    }

    protected void MakeControlsReadOnly(ControlCollection controls)
    {
        foreach (Control c in controls)
        {
            if (c is TextBox || c is RadioButton ||
                c is DropDownList || c is CheckBox || c is RadioButtonList || c is CheckBoxList)
            {
                PropertyInfo propertyInfo = c.GetType().GetProperty("Enabled");
                propertyInfo.SetValue(c, false, null);

                //propertyInfo = c.GetType().GetProperty("ForeColor");
                //propertyInfo.SetValue(c, Color.Black , null);
                //propertyInfo = c.GetType().GetProperty("BackColor");
                //propertyInfo.SetValue(c, Color.FromArgb(240, 240, 240, 240), null);
                //propertyInfo = c.GetType().GetProperty("BorderColor");
                //propertyInfo.SetValue(c, Color.LightGray, null);
                //Unit u = new Unit(0);
                //propertyInfo = c.GetType().GetProperty("BorderWidth");
                //propertyInfo.SetValue(c, u, null); 

                if (c is CheckBoxList)
                {
                    //propertyInfo = c.GetType().GetProperty("BackColor");
                    //propertyInfo.SetValue(c.Parent, Color.FromArgb(240, 240, 240, 240), null); 
                    //propertyInfo = c.GetType().GetProperty("BorderStyle");
                    //propertyInfo.SetValue(c, BorderStyle.Groove, null);
                }
            }

            if (c.HasControls())
            {
                
                
                
                MakeControlsReadOnly(c.Controls);
            }
        }
    }



    protected void MakeControlsWriteable(ControlCollection controls)
    {
        foreach (Control c in controls)
        {
            if (c is TextBox || c is RadioButton ||
                c is DropDownList || c is CheckBox || c is RadioButtonList || c is CheckBoxList)
            {
                PropertyInfo propertyInfo = c.GetType().GetProperty("Enabled");
                propertyInfo.SetValue(c, true, null);

                //propertyInfo = c.GetType().GetProperty("ForeColor");
                //propertyInfo.SetValue(c, Color.Black , null);
                //propertyInfo = c.GetType().GetProperty("BackColor");
                //propertyInfo.SetValue(c, Color.FromArgb(240, 240, 240, 240), null);
                //propertyInfo = c.GetType().GetProperty("BorderColor");
                //propertyInfo.SetValue(c, Color.LightGray, null);
                //Unit u = new Unit(0);
                //propertyInfo = c.GetType().GetProperty("BorderWidth");
                //propertyInfo.SetValue(c, u, null); 

                if (c is CheckBoxList)
                {
                    //propertyInfo = c.GetType().GetProperty("BackColor");
                    //propertyInfo.SetValue(c.Parent, Color.FromArgb(240, 240, 240, 240), null); 
                    //propertyInfo = c.GetType().GetProperty("BorderStyle");
                    //propertyInfo.SetValue(c, BorderStyle.Groove, null);
                }
            }

            if (c.HasControls())
            {



                MakeControlsWriteable(c.Controls);
            }
        }
    }
    #endregion Protected Methods

    #region Abstract Methods
    /// <summary>
    /// TopMenuName is the menu item in the top horizontal menu where this page falls under
    /// </summary>
    public abstract string TopMenuName();

    //to do
    //need to spend more time on design
    //menu items should be database driven
    //menu item is mapped to combination of page and business object
    public abstract string MenuItemName();

    /// <summary>
    /// The list of capabilities that a user needs to access this page.  A single page may have more than one
    /// capability associated with it.
    /// </summary>
    public abstract string AppObjectCode();
    
    #endregion Abstract Methods

    #region Public Methods

    /// <summary>
    /// Check if the current user has AHOBPR_REGISTRY_MANAGER role 
    /// </summary>
    /// <returns></returns>
    public bool IsCurrentUserSuperUser()
    {
        return CurrentUser.GetRoles().Contains(AHOBPRShared.GetUserRoleId(AHOBPRGlobal.AhobprUserRoleRegistryManagerCode));
    }

    /// <summary>
    /// Select returns the base application path.
    /// </summary>
    /// <param name="context">Context object</param>
    /// <returns>Returns the base application path.</returns>
    public static string RootPath(HttpContext context)
    {
        string urlSuffix = context.Request.Url.Authority + context.Request.ApplicationPath;
        return context.Request.Url.Scheme + @"://" + urlSuffix + "/";
    }
    /// <summary>
    /// You must pass in a string that uses the QueryStringHelper.DELIMITER as the delimiter.
    /// This will also append the "?" to the beginning of the query string.
    /// </summary>
    /// <param name="queryString"></param>
    /// <returns></returns>
    public static string EncryptQueryString(string queryString)
    {
        //return StringHelpers.EncryptQueryString(queryString);
        string qs = "";
        return qs;
    }
    public static NameValueCollection DecryptQueryString(string queryString)
    {
        //return StringHelpers.DecryptQueryString(queryString);
        NameValueCollection myColl = new NameValueCollection();
        myColl.Add("a", "1");
        return myColl;
    }
    public static string EncryptQueryString(NameValueCollection queryString)
    {        
        //return StringHelpers.EncryptQueryString(queryString);
        string myString = "";
        return myString;
    }
    public string ConvertDateToString(DateTime? date)
    {
        if (!date.HasValue)
            return "";
        else
            return date.GetValueOrDefault().ToShortDateString();
    }
    public void PrepareGridViewForExport(Control gv)
    {
        Hashtable htControls = new Hashtable();

        htControls.Add("LinkButton", "Text");
        htControls.Add("HyperLink", "Text");
        htControls.Add("DropDownList", "SelectedItem");
        htControls.Add("CheckBox", "Checked");

        Literal l = new Literal();

        for (int i = 0; i < gv.Controls.Count; i++)
        {
            if ((null != htControls[gv.Controls[i].GetType().Name]) || 
                (null != htControls[gv.Controls[i].GetType().BaseType.Name]))
            {
                l.Text = GetControlPropertyValue(gv.Controls[i], htControls);
                gv.Controls.Remove(gv.Controls[i]);
                gv.Controls.AddAt(i, l);
            }

            if (gv.Controls[i].HasControls())
            {
                PrepareGridViewForExport(gv.Controls[i]);
            }
        }
    }
    private string GetControlPropertyValue(Control control, Hashtable htControls)
    {
        Type controlType = control.GetType();
        string strControlType = controlType.Name;
        string strReturn = "Error";
        bool bReturn;
        PropertyInfo[] ctrlProps = controlType.GetProperties();
        string ExcelPropertyName = (string)htControls[strControlType];

        if (ExcelPropertyName == null)
        {
            ExcelPropertyName = (string)htControls[control.GetType().BaseType.Name];
            if (ExcelPropertyName == null)
                return strReturn;
        }

        foreach (PropertyInfo ctrlProp in ctrlProps)
        {
            if (ctrlProp.Name == ExcelPropertyName &&
            ctrlProp.PropertyType == typeof(String))
            {
                try
                {
                    strReturn = (string)ctrlProp.GetValue(control, null);
                    break;
                }
                catch
                {
                    strReturn = "";
                }
            }

            if (ctrlProp.Name == ExcelPropertyName &&
                    ctrlProp.PropertyType == typeof(bool))
            {
                try
                {
                    bReturn = (bool)ctrlProp.GetValue(control, null);
                    strReturn = bReturn ? "True" : "False";
                    break;
                }
                catch
                {
                    strReturn = "Error";
                }
            }

            if (ctrlProp.Name == ExcelPropertyName &&
                    ctrlProp.PropertyType == typeof(ListItem))
            {
                try
                {
                    strReturn = ((ListItem)(ctrlProp.GetValue(control, null))).Text;
                    break;
                }
                catch
                {
                    strReturn = "";
                }
            }
        }
        return strReturn;
    }
    public void ExportGridViewToExcel(GridView GridView1, string filename)
    {
        PrepareGridViewForExport(GridView1);
        HtmlForm form = new HtmlForm();
        string attachment = "attachment; filename=" + filename;
        Response.ClearContent();
        Response.AddHeader("content-disposition", attachment);
        Response.ContentType = "application/vnd.ms-excel";
        System.IO.StringWriter sw = new System.IO.StringWriter();
        HtmlTextWriter htw = new HtmlTextWriter(sw);
        form.Controls.Add(GridView1);
        this.Controls.Add(form);
        form.RenderControl(htw);
        //GridView1.RenderControl(htw);
        Response.Write(sw.ToString());
        Response.End();
    }
    
    //Chapter 9: Printing
    public string GetPrintButtonScript(Button btn)
    {        
        StringBuilder printButtonScript = new StringBuilder();

        //Get the postback script.
        string postback = this.Page.ClientScript.GetPostBackEventReference(btn, "");

        //Change target to a new window.  Name the window the current date and time so multiple windows can
        //be opened.
        printButtonScript.Append("var today = new Date();");
        printButtonScript.Append("var newWindowName = today.getFullYear().toString() + today.getMonth().toString() + today.getDate().toString() + today.getHours().toString() + today.getHours().toString() + today.getMinutes().toString() + today.getSeconds().toString() + today.getMilliseconds().toString();");

        printButtonScript.Append("document.forms[0].target = newWindowName;");

        //TODO: Added root path after this was turned in.
        //Show the please wait screen.
        //todo: printButtonScript.Append("window.open('" + RootPath(base.Context) + "/Reports/PleaseWait.html', newWindowName, 'scrollbars=yes,status=no,resizable=yes');");

        //Add the postback script.
        printButtonScript.Append(postback + ";");

        //Reset target back to itself so other controls will post back to this form.
        printButtonScript.Append("document.forms[0].target='_self';");
        //Return false to stop page submitting.
        printButtonScript.Append("return false;" + Environment.NewLine);

        return printButtonScript.ToString();
    }
    #endregion Public Methods

    #region Overrides
    protected override void OnPreInit(EventArgs e)
    {
        this.Theme = "AHOBPR";
        base.OnPreInit(e);
    }
    protected override void OnLoad(EventArgs e)
    {
        //Helpers.SetInputControlsHighlight(this, "highlight");
        base.OnLoad(e);

        if (Session != null && Session["UserSession"] != null)
            userSession = Session["UserSession"] as SessionFacade;
        else
            userSession = new SessionFacade();
    }
    protected override void OnInit(EventArgs e)
    {
        try
        {
            base.OnInit(e);
            CheckCapabilities();

            if (!isQueryStringValid())
            {
                ////to do: redirect to error handling page
                //Response.Write("Invalid QueryString");
                //Response.End();
                //redirect to error handling page
                Response.Redirect("ErrorPage.aspx?eid=qs");
            }

            if (!IsPostBack)
            {
                BuildMenusAndBreadCrumb();
            }
        }
        catch (Exception) { }
    }
    protected override void OnPreRender(EventArgs e)
    {
        
        RenderStartUpMessage(BusinessObjectSaveEventReceived);
        
        base.OnPreRender(e);
    }

    #endregion Overrides
    
    #region Virtual Methods
    /// <summary>
    /// Get whether or not the page requires authentication to access.  Assume true but allow specific pages to override.
    /// </summary>
    protected virtual bool RequiresAuthentication
    {
        get { return true; }
    }
    public virtual void CheckCapabilities()
    {
        if (IgnoreCapabilityCheck == false)
        {            
            //Get user permissions
            _CurrentUser = (UserAccountManager)HttpContext.Current.User;
            if (_CurrentUser.HasAccessToRegistry() == false)
                Response.Redirect("login.aspx");
            else
            {
                Permissions Perm = _CurrentUser.GetPermissions(AppObjectCode());
                if (Perm.NoAccess == true)
                    NoAccessToPage();
                else if (Perm.ReadOnly == true)
                    MakeFormReadOnly(AppObjectCode(), this.Controls);

                if (Perm.NoAccess == false)
                {
                    if (UserSession.SuccessfulLogin != "true")
                    {
                        Helpers.AddActivityToAuditLog(_CurrentUser.UserId.ToString(),
                            "Successful Login", null, AuditLogType.UserLogin, null);
                        UserSession.SuccessfulLogin = "true";
                    }
                }
            }
        }
    }
    protected virtual void NoAccessToPage()
    {     
        //You do not access to the system.
        //If a page has more than one capability you should override this method because a user could
        //have access to one section but not another so you do not want them to get an error
        Response.Redirect("ErrorPage.aspx?eid=100");
        //throw new AccessViolationException("You do not have access to this screen.");
    }
    public virtual void CustomReadOnlyLogic(string capabilityName)
    {
        //Override this method in a page that has custom logic for non standard controls on the screen.
    }

    /// <summary>
    /// The default implementation will make all controls disabled.
    /// If you have more than one capability associated with a page you should override this method
    /// with the special logic for each capability in the page.
    /// </summary>
    /// <param name="capabilityName"></param>
    /// <param name="controls"></param>
    public virtual void MakeFormReadOnly(string capabilityName, ControlCollection controls)
    {
        ReadOnly = true;
        MakeControlsReadOnly(controls);
        CustomReadOnlyLogic(capabilityName);
    }
    #endregion Virtual Methods

    #region Private Methods
    private Boolean isQueryStringValid()
    {
        //this iterates over querysting parameters
        //this will handle known querystring parameters and validate range, if any not valid range throw exception
        //if unknown parameter is found, throw exception

        Boolean _isValid = true;

        //NameObjectCollectionBase.KeysCollection qryString = Request.QueryString.Keys ;
        string[] qryString = Request.QueryString.AllKeys;
        
        foreach (string qryStringKey in qryString)
        {
            switch (qryStringKey)
            {
                case "id":
                    _isValid = Helpers.isInteger(Request.QueryString[qryStringKey]);
                    break;
                case "eid":
                    _isValid = Helpers.isInteger(Request.QueryString[qryStringKey]);
                    break;
                case "sectionId":
                    _isValid = Helpers.isInteger(Request.QueryString[qryStringKey]);
                    break;
                case "subSectionId":
                    _isValid = Helpers.isInteger(Request.QueryString[qryStringKey]);
                    break;
                case "statusId":
                    _isValid = Helpers.isInteger(Request.QueryString[qryStringKey]);
                    break;
                case "registrantId":                   
                    _isValid = Helpers.isInteger(Request.QueryString[qryStringKey]);
                    break;
                case "from":
                    _isValid = Helpers.isString(Request.QueryString[qryStringKey]);
                    break;
                case "action":
                    _isValid = Helpers.isString(Request.QueryString[qryStringKey]);
                    break;
                case "vista":
                    _isValid = Helpers.isString(Request.QueryString[qryStringKey]);
                    break;
                case "reason":
                    _isValid = Helpers.isString(Request.QueryString[qryStringKey]);
                    break;
                case "reportCriteria":
                    _isValid = Helpers.isString(Request.QueryString[qryStringKey]);
                    break;
                case "step":
                    _isValid = Helpers.isInteger(Request.QueryString[qryStringKey]);
                    break;
                case "reportType":
                    _isValid = Helpers.isString(Request.QueryString[qryStringKey]);
                    break;
                case "q9gtw0":
                    _isValid = Helpers.isString(Request.QueryString[qryStringKey]);
                    break;
                case "yiicf":
                    _isValid = Helpers.isString(Request.QueryString[qryStringKey]);
                    break;
                case "xqi4z":
                    _isValid = Helpers.isString(Request.QueryString[qryStringKey]);
                    break;
                case "jbPI0202":
                    _isValid = Helpers.isString(Request.QueryString[qryStringKey]);
                    break;
                case "27trp":
                    _isValid = Helpers.isString(Request.QueryString[qryStringKey]);
                    break;
                case "questionsGroupName":
                    _isValid = Helpers.isString(Request.QueryString[qryStringKey]);
                    break;
                case "bounced":
                    _isValid = Helpers.isString(Request.QueryString[qryStringKey]);
                    break;
                default:
                    _isValid = false;   
                    break;
            }

            if (!_isValid) 
            {
                Logging.LogErrorMessage("Querystring", Request.RawUrl.ToString(), "Invalid querystring parameter value for: " + qryStringKey.ToString());
                break;
            }
        }

        return _isValid;
    }
    private void BasePage_Load(object sender, EventArgs e)
    {
        // Kick the user out if the page requires authentication but the user somehow isn't (like if the auth system has been
        // maliciously bypassed).
        if (RequiresAuthentication && (!User.Identity.IsAuthenticated))
        {
            Response.Redirect("ErrorPage.aspx?eid=404");
        }
    }

    private string CreateStartUpMessage(bool isSaveSuccessMessage)
    {

        string Message = string.Empty;

        if (isSaveSuccessMessage && _OnStartupAlertErrorCollection == null && !SuppressSaveSuccessMessage)
        {
            Message = "Save Successful.";
        }
        else
        {
            if (_OnStartupAlertErrorCollection != null)
            {
                foreach (KeyValuePair<string, string> item in _OnStartupAlertErrorCollection)
                    Message += item.Value + "\\n";
            }

        }

        return Message;
  
    }
    /// <summary>
    /// Renders the massage in javascript alert. Modify if needed for section 508 compliance
    /// </summary>
    private void RenderStartUpMessage(bool IsSaveSuccessMessage)
    {
        StringBuilder sb = new StringBuilder();
        string Message = CreateStartUpMessage(IsSaveSuccessMessage);

        
        //if (Message != string.Empty && !Page.ClientScript.IsStartupScriptRegistered("alertMsg"))
        if (Message != string.Empty)
        {
            HiddenField HiddenFieldShowSaveMessage = this.Master.FindControl("HiddenFieldShowSaveMessage") as HiddenField;
            if (HiddenFieldShowSaveMessage != null)
            {
                HiddenFieldShowSaveMessage.Value = "1";
            }

            HiddenField HiddenFieldSaveMessage = this.Master.FindControl("HiddenFieldSaveMessage") as HiddenField;
            if (HiddenFieldSaveMessage != null)
            {
                HiddenFieldSaveMessage.Value = Message;
            }

            HiddenField HiddenFieldRedirectOnSave = this.Master.FindControl("HiddenFieldRedirectOnSave") as HiddenField;
            if (HiddenFieldRedirectOnSave != null)
            {
                HiddenFieldRedirectOnSave.Value = _redirectAfterSave;
            }
        }
    }

    #endregion Private Methods
}