﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;
using VeteransAffairs.Registries.BusinessAHOBPR;
using AntiXssEnc = Microsoft.Security.Application;

public partial class AdminUserEmailTemplateList : BasePage
{
   // private AHOBPREmailTemplateManager _emailServiceTemplate = new AHOBPREmailTemplateManager();

    public override string MenuItemName()
    {
        return "Clinical Portal User Email";
    }
    public override string AppObjectCode()
    {
        return "AHOBPR REGISTRY MESSAGES";
    }
    public override string TopMenuName()
    {
        return "Administration";
    }

    protected void btnAdd_Click(object sender, EventArgs e)
    {
        Response.Redirect("~/AdminUserEmailTemplateEdit.aspx", false);
        Context.ApplicationInstance.CompleteRequest();
    }

    protected void EmailCommand(object sender, CommandEventArgs e)
    {
        Response.Redirect("~/AdminUserEmailTemplateEdit.aspx?id=" + e.CommandArgument, false);
        Context.ApplicationInstance.CompleteRequest();
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        //gvemail.AllowPaging = true;
        //gvemail.DataSource = _emailServiceTemplate.GetAll();
        //gvemail.DataBind();
    }

    protected void ButtonClear_Click(object sender, EventArgs e)
    {
        TextBoxKeyWords.Text = "";
        DropDownListStatus.SelectedIndex = -1;
        HiddenFieldClearFlag.Value = "1";
    }

    protected void ButtonSearch_Click(object sender, EventArgs e)
    {
        GridViewTemplates.DataBind();
        HiddenFieldClearFlag.Value = "0";
    }

    protected void GridViewTemplates_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if ((e.Row.RowType != DataControlRowType.DataRow))
        {
            return;
        }

        EMAIL_TEMPLATE emailitem = (EMAIL_TEMPLATE)e.Row.DataItem;

        Label lblsubject = (Label)e.Row.FindControl("lblsubject");
        lblsubject.Text = AntiXssEnc.Encoder.HtmlEncode(Server.HtmlDecode(emailitem.SUBJECT));
        
        Label lbltitle = (Label)e.Row.FindControl("lbltitle");
        lbltitle.Text = AntiXssEnc.Encoder.HtmlEncode(Server.HtmlDecode(emailitem.TITLE));
        
    }

    protected void GridViewTemplates_RowEditing(object sender, GridViewEditEventArgs e)
    {
    }
    protected void CheckBoxInclude_CheckedChanged(object sender, EventArgs e)
    {
        GridViewTemplates.DataBind();
    }

    protected void gridViewPageSizeDdlChanged(Object sender, EventArgs e)
    {

        GridViewTemplates.PageSize = int.Parse(gridViewPageSizeDdl.SelectedValue);

    }

    protected void gridView_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        GridViewTemplates.PageIndex = e.NewPageIndex;

    }
}
