﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.Utilities;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;

public partial class AdminRegistryFlags : BasePage
{
    bool _buttonAddDeleteClicked;
    AHOBPRAdminManager _adminManager = new AHOBPRAdminManager();
    AHOBPRRegistrantManager _registrantManager = new AHOBPRRegistrantManager();

    protected void Page_Load(object sender, EventArgs e)
    {
        _buttonAddDeleteClicked = false;
    }

    protected void Page_PreRender(object sender, EventArgs e)
    {
        if (_buttonAddDeleteClicked)
        {
            GridViewRegistryFlags.DataBind();
        }
    }

    protected void ButtonClear_Click(object sender, EventArgs e)
    {
        TextBoxKeyWords.Text = "";
        DropDownListStatus.SelectedIndex = 0;
        DropDownListType.SelectedIndex = 0;
        DropDownListPredefined.SelectedIndex = 0;
    }

    protected void ButtonSearch_Click(object sender, EventArgs e)
    {
        GridViewRegistryFlags.DataBind();
    }

    public override string MenuItemName()
    {
        return "AHOBPR REGISTRY FLAG";
    }
    public override string AppObjectCode()
    {
        return "AHOBPR REGISTRY FLAG";
    }
    public override string TopMenuName()
    {
        return "Administration";
    }

    protected void GridViewRegistryFlags_PreRender(object sender, EventArgs e)
    {
        HookOnFocus(GridViewRegistryFlags);

    }

    protected void GridViewRegistryFlags_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        TextBox textboxRegistryFlagName = null;
        TextBox textboxRegistryFlagDescription = null;
        DropDownList dropdownlistRegistryFlagType = null;
        int registryFlagId = 0;
        int saveStatus = 0;
        UserAccountManager user = (UserAccountManager)HttpContext.Current.User;

        switch (e.CommandName)
        {
            case "ADD":

                textboxRegistryFlagName = GridViewRegistryFlags.FooterRow.FindControl("TextboxRegistryFlagName") as TextBox;
                textboxRegistryFlagDescription = GridViewRegistryFlags.FooterRow.FindControl("TextboxRegistryFlagDescription") as TextBox;
                dropdownlistRegistryFlagType = GridViewRegistryFlags.FooterRow.FindControl("DropdownListRegistryFlagType") as DropDownList;
                break;

            case "EMPTYADD":
                textboxRegistryFlagName = GridViewRegistryFlags.Controls[0].Controls[0].FindControl("TextboxRegistryFlagNameEmpty") as TextBox;
                textboxRegistryFlagDescription = GridViewRegistryFlags.Controls[0].Controls[0].FindControl("TextboxRegistryFlagDescriptionEmpty") as TextBox;
                dropdownlistRegistryFlagType = GridViewRegistryFlags.Controls[0].Controls[0].FindControl("DropdownListRegistryFlagTypeEmpty") as DropDownList;
                break;

            case "DELETE_FLAG":

                registryFlagId = Convert.ToInt32(e.CommandArgument);

                //Add to Audit Log
                string message = _registrantManager.GetRegistryFlagNameById(registryFlagId) + ": Deleted";
                Helpers.AddActivityToAuditLog(user.UserId.ToString(), message,
                    string.Empty, AuditLogType.RegistryFlagAddedEdited, null);

                if (_adminManager.RemoveRegistryFlag(registryFlagId))
                {
                    Alert.ShowDeleteSuccessful();
                }
                else
                {
                    Alert.ShowSaveFailed();
                }

                break;
            case "UPDATE_FLAG":

                registryFlagId = Convert.ToInt32(e.CommandArgument);

                break;
        }
        _buttonAddDeleteClicked = true;

        if (e.CommandName.Contains("ADD"))
        {
            if (dropdownlistRegistryFlagType != null && textboxRegistryFlagName != null && textboxRegistryFlagDescription != null)
            {
                saveStatus = _adminManager.AddRegistryFlag(Convert.ToInt32(dropdownlistRegistryFlagType.SelectedValue), textboxRegistryFlagName.Text, textboxRegistryFlagDescription.Text);
            }

            //Add to Audit Log
            if (textboxRegistryFlagName != null && textboxRegistryFlagName.Text != null)
            {
                string message = textboxRegistryFlagName.Text + ": Added";
                Helpers.AddActivityToAuditLog(user.UserId.ToString(), message,
                    string.Empty, AuditLogType.RegistryFlagAddedEdited, null);
            }

            if (saveStatus == 2)
            {
                Alert.Show("This registry flag already exists!");
            }
            else if (saveStatus == 1)
            {
                Alert.ShowSaveSuccess();
            }
            else
            {
                Alert.ShowSaveFailed();
            }
        }
        else if (e.CommandName == "UPDATE_FLAG")
        {
            STD_REGISTRY_FLAG registryFlag = _adminManager.GetRegistryFlagById(registryFlagId);

            //Add to Audit Log
            string message = registryFlag.REGISTRY_FLAG_NAME + ": Updated";
            Helpers.AddActivityToAuditLog(user.UserId.ToString(), message,
                string.Empty, AuditLogType.RegistryFlagAddedEdited, null);

            if (registryFlag != null)
            {
                registryFlag.SetAsChangeTrackingRoot();
                registryFlag.SetAsUpdateOnSubmit();
                registryFlag.ACTIVE_FLAG = !registryFlag.ACTIVE_FLAG;
                saveStatus = _adminManager.UpdateRegistryFlagActiveFlag(registryFlag);
                if ((saveStatus == 1) && (registryFlag.ACTIVE_FLAG == true))
                {
                    Alert.ShowActivationSuccessful();
                }
                if ((saveStatus == 1) && (registryFlag.ACTIVE_FLAG == false))
                {
                    Alert.ShowDeactivationSuccessful();
                }
                else
                {
                    Alert.ShowSaveFailed();
                }
            }

        }
        AHOBPRGlobal.ViewLookupAll = null;
    }
    protected void GridViewRegistryFlags_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        var index = Convert.ToInt32(e.RowIndex);
        GridViewRegistryFlags.SelectedIndex = index;
        var id = Convert.ToInt32(GridViewRegistryFlags.SelectedValue);

        //RaiseDeleteImagingItemEvent(id);

        GridViewRegistryFlags.SelectedIndex = -1;
        GridViewRegistryFlags.Focus();

         Alert.ShowSaveSuccess();
    }
  
    /// <summary>
    /// This function goes recursively all child controls and sets 
    /// onfocus attribute if the control has one of defined types.
    /// </summary>
    /// <param name="currentControl">the control to hook.</param>
    private void HookOnFocus(Control currentControl)
    {
        //checks if control is one of TextBox, DropDownList, ListBox or Button

        if ((currentControl is TextBox) ||
            (currentControl is DropDownList) ||
            (currentControl is ListBox) ||
            (currentControl is Button) ||
            (currentControl is Table) ||
            (currentControl is GridView))
        {
            WebControl curr = currentControl as WebControl;
            if (curr != null)
            {
                //adds a script which saves active control on receiving focus 
                //in the hidden field __LASTFOCUS.
                curr.Attributes.Add("onfocus", "try{document.getElementById('__LASTFOCUS').value=this.id; } catch(e) {}");
            }
        }

        //checks if the control has children
        if (currentControl != null && currentControl.HasControls())
            //if yes do them all recursively

            foreach (Control CurrentChildControl in currentControl.Controls)
                HookOnFocus(CurrentChildControl);
    }

    protected void gridViewPageSizeDdlChanged(Object sender, EventArgs e)
    {

        GridViewRegistryFlags.PageSize = int.Parse(gridViewPageSizeDdl.SelectedValue);

    }

    protected void gridView_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        GridViewRegistryFlags.PageIndex = e.NewPageIndex;

    }

}