﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Microsoft.Reporting.WebForms;
using VeteransAffairs.Registries.Business.Utilities;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using System.Data;
using System.Collections.Specialized;

public partial class AdminAddFlags : BasePage
{
    //List<ReportParameter> _reportParameters = new List<ReportParameter>();
    private List<STD_GUI_CONTROL_AHOBPR> _dbControls = null;
    private AHOBPRBaseControlManager _baseControlManager = new AHOBPRBaseControlManager();
    private AHOBPRReportManager _reportManager = new AHOBPRReportManager();
   // private AHOBPRLookUpManager _lookupManager = new AHOBPRLookUpManager();
    private AHOBPREmailService _emailService = new AHOBPREmailService();
    //private Boolean _flagSet = false;
    //private AHOBPRRegistrantManager _registrantManager = new AHOBPRRegistrantManager();
      
    public string selectedQuestion = null;

    protected void Page_Load(object sender, EventArgs e)
    {

        UserSession.RegistrantId = 0;
        HiddenFieldTotalRegistrants.Value = "0";

       if (!IsPostBack)
        {
            ShowSelectParameterPanel(true);
            if (Request.QueryString["step"] != null)
            {
                if (Helpers.getIntFromString(Request.QueryString["step"].ToString()) == 2)
                {
                    ShowSelectParameterPanel(false);
                }
            }
            
        }
        LoadBaseControls();

        Page.PreRender += new EventHandler(Page_PreRender);
        //set Location panel names & ToolTips
        UserControlReportLocationAssigned.LocationPanelName = "  Assigned Location  ";
        UserControlReportLocationEvaluation.LocationPanelName = "  AHOBPR Evaluation Location (Most Recent)  ";
        UserControlReportLocationAssigned.LocationPanelToolTip = "Assigned Location is a VISN or Facility that a registrant is assigned to as reported in CDW. The Selection Criteria allows the user to filter with all locations, one VISN, Main Facility, or one Sub-Facility, or Registrants who are not assigned.";
        UserControlReportLocationEvaluation.LocationPanelToolTip = "AHOBPR Evaluation Location is a VISN or Facility where a registrant had their most recent AHOBPR Evaluation as reported in CDW. The Selection Criteria allows the user to filter with all locations, one VISN, Main Facility, or one Sub-Facility, or Registrants who have not had a AHOBPR Evaluation.";

    }

    void Page_PreRender(object sender, EventArgs e)
    {
        if (IsPostBack)
        {
            ReloadBaseControlValue();
        }

    }

    private void ReloadBaseControlValue()
    {
        if (BaseControlListBoxStatus.Visible)
        {
            BaseControlListBoxStatus.DataElementValue = Helpers.ConvertToKeyValuePair(BaseControlListBoxStatus.Text);
        }
        if (BaseControlListBoxState.Visible)
        {
            BaseControlListBoxState.DataElementValue = Helpers.ConvertToKeyValuePair(BaseControlListBoxState.Text);
        }
        
        if (BaseControlListBoxHealthFactor.Visible)
        {
            BaseControlListBoxHealthFactor.DataElementValue = Helpers.ConvertToKeyValuePair(BaseControlListBoxHealthFactor.Text);
        }
        
        if (BaseControlListBoxSubpopulationFlag.Visible)
        {
            BaseControlListBoxSubpopulationFlag.DataElementValue = Helpers.ConvertToKeyValuePair(BaseControlListBoxSubpopulationFlag.Text);
        }

    }

    protected void ButtonNext_Click(object sender, EventArgs e)
    {
        CustomValidatorSelectDataElements.IsValid = true;

        // Validate that at least one value was entered    
        bool notValid = (!CheckBoxHealthFactor.Checked && !CheckBoxState.Checked
                && !CheckBoxRegistrantStatus.Checked && !CheckBoxHealthConcerns.Checked && !CheckBoxRequestToBeSeen.Checked
                && !CheckBoxSubpopulationFlag.Checked && !CheckBoxAdminFlag.Checked && !CheckBoxSeparationType.Checked
                && !CheckBoxSeparationDate.Checked && !CheckBoxDeathFlag.Checked && RadioButtonListDeploymentCountry.SelectedValue == "None"
                && !CheckBoxLocation.Checked && RadioButtonListStartEndDate.SelectedValue == "None" && RadioButtonListDeployStartEndDate.SelectedValue == "None");

       

        if (notValid)
        {
            CustomValidatorSelectDataElements.IsValid = false;
        }
        else
        {
            ShowSelectParameterPanel(false);
            LoadBaseControls();
            ClearInvisibleSearchCriteria();
            ShowGridViewAddFlag(false);
            gridViewPageSizeDdl.Visible = false;
            LabelItemsPerPage.Visible = false;
        }

    }

    protected void ButtonBack_Click(object sender, EventArgs e)
    {
        ClearInvisibleSearchCriteria();
        ShowSelectParameterPanel(true);
        PanelSubmitFlag.Visible = false;
        //clear ViewState 
        ViewState["selectedregistrantids"] = null;
        
    }
        
    protected void ButtonClear_Click(object sender, EventArgs e)
    {
        ClearSearchCriteria();
        ShowGridViewAddFlag(false);
        PanelSubmitFlag.Visible = false;
        gridViewPageSizeDdl.Visible = false;
        LabelItemsPerPage.Visible = false;
    }
    protected void ButtonClearSelection_Click(object sender, EventArgs e)
    {
       Response.Redirect("AdminAddFlags.aspx");
    }
    
    private void LoadBaseControls()
    {
        foreach (STD_GUI_CONTROL_AHOBPR dbItem in GetGuiControls("AHOBPR_ADD_FLAG"))
        {
            Control userControl = PanelParameterAddFlag.FindControl(dbItem.USER_CONTROL_ID);
            if (userControl != null)
            {
                switch (dbItem.BASE_CONTROL_TYPE)
                {
                    case (int)AhobprBaseControlType.ListBox:
                        controls_BaseControlListBox baseControl = (controls_BaseControlListBox)userControl;

                        if (dbItem.LOOKUP_LIST_CATEGORY == "SUBPOPULATION_FLAG_ALL")
                        {
                            baseControl.SessionListBox = UserSession.UserControlSubpopulationFlag;
                            baseControl.PropertyChanged += new System.ComponentModel.PropertyChangedEventHandler(SubpopulationFlagChanged);
                        }
                        else if (dbItem.LOOKUP_LIST_CATEGORY == "REGISTRY_STATUS")
                        {
                            baseControl.SessionListBox = UserSession.UserControlStatus;
                            baseControl.PropertyChanged += new System.ComponentModel.PropertyChangedEventHandler(StatusFlagChanged);
                        }
                        else if (dbItem.LOOKUP_LIST_CATEGORY == "STD_STATE")
                        {
                            baseControl.SessionListBox = UserSession.UserControlState;
                            baseControl.PropertyChanged += new System.ComponentModel.PropertyChangedEventHandler(StateFlagChanged);
                        }
                        else if (dbItem.LOOKUP_LIST_CATEGORY == "HEALTH_FACTOR")
                        {
                            baseControl.SessionListBox = UserSession.UserControlHealthFactor;
                            baseControl.PropertyChanged += new System.ComponentModel.PropertyChangedEventHandler(HealthFactorFlagChanged);
                        }

                        baseControl.LoadControlsFromObject(dbItem.LOOKUP_LIST_CATEGORY, string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP,
                            dbItem.INCLUDE_LABEL, dbItem.DATA_ELEMENT_WIDTH, dbItem.VALIDATION_GROUP, dbItem.REQUIRED);
                        break;
                    case (int)AhobprBaseControlType.DropDownList:
                        controls_BaseControlDropDownList baseControlDropdown = (controls_BaseControlDropDownList)userControl;

                        baseControlDropdown.LoadControlsFromObject(string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP, dbItem.INCLUDE_LABEL, dbItem.LOOKUP_LIST_CATEGORY,
                                                                   dbItem.VALIDATION_GROUP, dbItem.VALIDATION_ERROR_MESSAGE, dbItem.REQUIRED);
                        break;
                    case (int)AhobprBaseControlType.RadioButtonList:
                        controls_BaseControlRadioButtonList baseControlRadioButtonList = (controls_BaseControlRadioButtonList)userControl;

                        baseControlRadioButtonList.LoadControlsFromObject(string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP, dbItem.INCLUDE_LABEL, dbItem.LOOKUP_LIST_CATEGORY);
                        break;
                    case (int)AhobprBaseControlType.TextBox:
                        controls_BaseControlTextBox baseControlTextBox = (controls_BaseControlTextBox)userControl;

                        baseControlTextBox.LoadControlsFromObject(string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP, dbItem.INCLUDE_LABEL, dbItem.DATA_TYPE_MAX_LENGTH, dbItem.DATA_ELEMENT_WIDTH,
                            dbItem.VALIDATION_GROUP, dbItem.VALIDATION_ERROR_MESSAGE, dbItem.VALIDATION_REGULAR_EXPRESSION, dbItem.REQUIRED);
                        break;

                }
            }
        }
    }

    private List<STD_GUI_CONTROL_AHOBPR> GetGuiControls(string controlCategory)
    {
        if (UserSession.GuiControlsAddFlags == null)
        {
            _dbControls = _baseControlManager.SelectGuiControlList(controlCategory).ToList<STD_GUI_CONTROL_AHOBPR>();
            UserSession.GuiControlsAddFlags = _dbControls;
        }
        else
        {
            _dbControls = UserSession.GuiControlsAddFlags;
        }

        return _dbControls;
    }


    protected void ButtonFind_Click(object sender, EventArgs e)
    {
        ViewState["selectedregistrantids"] = null;
        Search();
        PanelSubmitFlag.Visible = (Helpers.getIntFromString(HiddenFieldTotalRegistrants.Value) > 0);
    }

    private void Search()
    {
        if (ValidateCustomValidatorStep2())
        {
            ShowSelectParameterPanel(false);
            ShowGridViewAddFlag(true);
            gridViewPageSizeDdl.Visible = true;
            LabelItemsPerPage.Visible = true;
        }
    }

    private bool ValidateCustomValidatorStep2()
    {
        bool result = true;

        CustomValidatorStep2.IsValid = true;

        // Validate that at least one value was entered    
        if ((string.IsNullOrEmpty(UserControlReportLocationAssigned.FacilityId) || UserControlReportLocationAssigned.FacilityId == "0") && string.IsNullOrEmpty(UserControlReportLocationAssigned.VISN)
                && (string.IsNullOrEmpty(UserControlReportLocationEvaluation.FacilityId) || UserControlReportLocationEvaluation.FacilityId == "0") && string.IsNullOrEmpty(UserControlReportLocationEvaluation.VISN)
                && string.IsNullOrEmpty(UserControlDateRangeFormStartDate.FromDateValue)
                && string.IsNullOrEmpty(UserControlDateRangeFormStartDate.ToDateValue)
                && string.IsNullOrEmpty(UserControlDateRangeFormToDate.FromDateValue)
                && string.IsNullOrEmpty(UserControlDateRangeFormToDate.ToDateValue)
                && string.IsNullOrEmpty(BaseControlListBoxSubpopulationFlag.Text)
                && string.IsNullOrEmpty(UserControlAdminFlagFilter.AdminFlagId)
                && RadioButtonListHealthConcerns.SelectedIndex == 0
                && RadioButtonListRequestToBeSeen.SelectedIndex == 0
                && string.IsNullOrEmpty(BaseControlListBoxStatus.Text)
                && string.IsNullOrEmpty(BaseControlListBoxState.Text)
                && string.IsNullOrEmpty(BaseControlListBoxHealthFactor.Text)
                && string.IsNullOrEmpty(BaseControlDropDownListDeploymentCountryAll.Text)
                && string.IsNullOrEmpty(BaseControlDropDownListDeploymentCountryExposure.Text)
                && string.IsNullOrEmpty(UserControlDateRangeSeparation.ToDateValue)
                && string.IsNullOrEmpty(UserControlDateRangeSeparation.FromDateValue)
                && RadioButtonListDeathFlag.SelectedIndex == 0
                && string.IsNullOrEmpty(BaseControlDropDownListSeparationType.Text)
                && string.IsNullOrEmpty(UserControlStartDeployDate.FromDateValue)
                && string.IsNullOrEmpty(UserControlStartDeployDate.ToDateValue)
                && string.IsNullOrEmpty(UserControlToDateDeployDate.FromDateValue)
                && string.IsNullOrEmpty(UserControlToDateDeployDate.ToDateValue)

            )
        {
            CustomValidatorStep2.IsValid = false;
            result = false;
            ShowGridViewAddFlag(false);
            PanelSubmitFlag.Visible = false;
            gridViewPageSizeDdl.Visible = false;
            LabelItemsPerPage.Visible = false;
        }
        else
        {
            if (CheckBoxAdminFlag.Checked)
            {
                if (UserControlAdminFlagFilter.ValidateCustomValidator() == false)
                {
                    result = false;
                }
            }
            if (UserControlDateRangeFormStartDate.Visible)
            {
                if (UserControlDateRangeFormStartDate.ValidateCustomValidator() == false)
                {
                    result = false;
                }
            }
            if (UserControlDateRangeFormToDate.Visible)
            {
                if (UserControlDateRangeFormToDate.ValidateCustomValidator() == false)
                {
                    result = false;
                }
            }


            if (UserControlStartDeployDate.Visible)
            {
                if (UserControlStartDeployDate.ValidateCustomValidator() == false)
                {
                    result = false;
                }
            }
            if (UserControlToDateDeployDate.Visible)
            {
                if (UserControlToDateDeployDate.ValidateCustomValidator() == false)
                {
                    result = false;
                }
            }
           
            if (RadioButtonListExcludeAdminFlag.Visible)
            {
                if (string.IsNullOrEmpty(UserControlAdminFlagFilter.AdminFlagId) && RadioButtonListExcludeAdminFlag.SelectedValue == "Y")
                {
                    CustomValidatorStep2.ErrorMessage = "Please select an Admin Flag to exclude.";
                    CustomValidatorStep2.IsValid = false;
                    result = false;
                }
            }


            if (result == false)
            {
                ShowGridViewAddFlag(false);
                PanelSubmitFlag.Visible = false;
                gridViewPageSizeDdl.Visible = false;
                LabelItemsPerPage.Visible = false;
            }

        }
        return result;
    }

    private void ShowSelectParameterPanel(bool show)
    {

        PanelSelectParameters.Visible = show;
        PanelParameterAddFlag.Visible = !show;
        if (show)
        {
            ShowGridViewAddFlag(false);
            PanelSubmitFlag.Visible = false;
            gridViewPageSizeDdl.Visible = false;
            LabelItemsPerPage.Visible = false;
        }
        else
        {
            ReportParametersIntialLoad();
        }

    }
    private void ShowGridViewAddFlag(bool show)
    {
        if (show)
        {            
            ShowGridViewAddFlagByIndividual(true, false);
        }
        else
        {
            ShowGridViewAddFlagByIndividual(false, false);
        }
    }

    private void ShowGridViewAddFlagByIndividual(bool show, bool drillDown)
    {
        if (show)
        {
            string assignedLocationType = string.Empty;
            string assignedLocationKey = string.Empty;

            assignedLocationType = UserControlReportLocationAssigned.LocationType;
            assignedLocationKey = UserControlReportLocationAssigned.LocationKey;
           

            //set zero default value for separation type if null 
            int separationTypeValue = (string.IsNullOrEmpty(BaseControlDropDownListSeparationType.Text) ? 0 : Convert.ToInt32(BaseControlDropDownListSeparationType.Text));

            //If Health Concerns blank set to "All"
            if (String.IsNullOrEmpty(RadioButtonListHealthConcerns.Text))
            {
                RadioButtonListHealthConcerns.Text = "All";
            }
            
            //set blank values to null to avoid error on count
            string status = BaseControlListBoxStatus.Text == "" ? null : BaseControlListBoxStatus.Text;
            string state = BaseControlListBoxState.Text == "" ? null : BaseControlListBoxState.Text;
            string dateRangeFormStartDate_FromDateValue = UserControlDateRangeFormStartDate.FromDateValue == "" ? null : UserControlDateRangeFormStartDate.FromDateValue;
            string dateRangeFormStartDate_ToDateValue = UserControlDateRangeFormStartDate.ToDateValue == "" ? null : UserControlDateRangeFormStartDate.ToDateValue;
            string healthFactor = BaseControlListBoxHealthFactor.Text == "" ? null : BaseControlListBoxHealthFactor.Text;
            string dateRangeFormToDate_FromDateValue = UserControlDateRangeFormToDate.FromDateValue == "" ? null : UserControlDateRangeFormToDate.FromDateValue;
            string dateRangeFormToDate_ToDateValue = UserControlDateRangeFormToDate.ToDateValue == "" ? null : UserControlDateRangeFormToDate.ToDateValue;
            string hiddenFieldQuestion = HiddenFieldQuestion.Value == "" ? null : HiddenFieldQuestion.Value;
            string subpopulationFlag = BaseControlListBoxSubpopulationFlag.Text == "" ? null : BaseControlListBoxSubpopulationFlag.Text;
            string adminFlagId = UserControlAdminFlagFilter.AdminFlagId == "" ? null : UserControlAdminFlagFilter.AdminFlagId;
            string deploymentCountryAll = BaseControlDropDownListDeploymentCountryAll.Text == "" ? null : BaseControlDropDownListDeploymentCountryAll.Text;
            string deploymentCountryExposure = BaseControlDropDownListDeploymentCountryExposure.Text == "" ? null : BaseControlDropDownListDeploymentCountryExposure.Text;
            string adminFlagFilter_AdminFlagEnteredDateFrom = UserControlAdminFlagFilter.AdminFlagEnteredDateFrom == "" ? null : UserControlAdminFlagFilter.AdminFlagEnteredDateFrom;
            string adminFlagFilter_AdminFlagEnteredDateTo = UserControlAdminFlagFilter.AdminFlagEnteredDateTo == "" ? null : UserControlAdminFlagFilter.AdminFlagEnteredDateTo;
            string dateRangeSeparation_FromDateValue = UserControlDateRangeSeparation.FromDateValue == "" ? null : UserControlDateRangeSeparation.FromDateValue;
            string dateRangeSeparation_ToDateValue = UserControlDateRangeSeparation.ToDateValue == "" ? null : UserControlDateRangeSeparation.ToDateValue;
            string dateRangeDeployStartDate_FromDateValue = UserControlStartDeployDate.FromDateValue == "" ? null : UserControlStartDeployDate.FromDateValue;
            string dateRangeDeployStartDate_ToDateValue = UserControlStartDeployDate.ToDateValue == "" ? null : UserControlStartDeployDate.ToDateValue;
            string dateRangeDeployToDate_FromDateValue = UserControlToDateDeployDate.FromDateValue == "" ? null : UserControlToDateDeployDate.FromDateValue;
            string dateRangeDeployToDate_ToDateValue = UserControlToDateDeployDate.ToDateValue == "" ? null : UserControlToDateDeployDate.ToDateValue;
                       
            GridViewAddFlag.DataBind();
            int total = _reportManager.GetAddFlagGVCount(status,
                state,
                dateRangeFormStartDate_FromDateValue,
                dateRangeFormStartDate_ToDateValue,
                healthFactor,
                dateRangeFormToDate_FromDateValue,
                dateRangeFormToDate_ToDateValue,
                RadioButtonListHealthConcerns.Text,
                RadioButtonListRequestToBeSeen.Text,
                assignedLocationType,
                assignedLocationKey,
                UserControlReportLocationEvaluation.LocationType,
                UserControlReportLocationEvaluation.LocationKey,
                subpopulationFlag,
                adminFlagId,
                deploymentCountryAll,
                deploymentCountryExposure,
                adminFlagFilter_AdminFlagEnteredDateFrom,
                adminFlagFilter_AdminFlagEnteredDateTo,
                RadioButtonListDeathFlag.Text,
                separationTypeValue,
                dateRangeSeparation_FromDateValue,
                dateRangeSeparation_ToDateValue,
                RadioButtonListExcludeAdminFlag.Text,
                dateRangeDeployStartDate_FromDateValue,
                dateRangeDeployStartDate_ToDateValue,
                dateRangeDeployToDate_FromDateValue,
                dateRangeDeployToDate_ToDateValue);
            LabelNumberOfResultsFound.Text = "Total Number of Results Found: " + total.ToString();
            HiddenFieldTotalRegistrants.Value = total.ToString();

            //If Health Concerns blank set to "All"
            if (String.IsNullOrEmpty(RadioButtonListHealthConcerns.Text))
            {
                RadioButtonListHealthConcerns.Text = "All";
            }
        }
        PanelAddFlag.Visible = show;
    }
  
    protected void GridViewAddFlag_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "Details")
        {
            int index = Convert.ToInt32(e.CommandArgument);
            GridViewAddFlag.SelectedIndex = index;
            UserSession.RegistrantId = GridViewAddFlag.SelectedIndex;
            Response.Redirect("QuestionnaireSummary.aspx?id=" + GridViewAddFlag.SelectedIndex);
        }
    }

    private void ReportParametersIntialLoad()
    {
        //if (Request.QueryString["reportType"].ToString() == "Aggregate")
        //{
        //    PanelLocation.Visible = true;
        //    UserControlReportLocationAssigned.Visible = false;
        //    UserControlReportLocationEvaluation.Visible = false;
        //}
        //else
        //{
            PanelLocation.Visible = false;
            UserControlReportLocationAssigned.Visible = CheckBoxLocation.Checked;
            UserControlReportLocationEvaluation.Visible = CheckBoxLocation.Checked;
       // }
       

        PanelQuestionnaireDate.Visible = (RadioButtonListStartEndDate.SelectedValue == "Questionnaire Start Date"
                                          || RadioButtonListStartEndDate.SelectedValue == "Questionnaire Completed Date");
        PanelDeploymentDates.Visible = (RadioButtonListDeployStartEndDate.SelectedValue == "Deployment Start Date"
                                        || RadioButtonListDeployStartEndDate.SelectedValue == "Deployment End Date");

        
        if (PanelDeploymentDates.Visible)
        {
            UserControlStartDeployDate.Visible = (RadioButtonListDeployStartEndDate.SelectedValue == "Deployment Start Date");
            if (UserControlStartDeployDate.Visible)
            {
                UserControlStartDeployDate.LoadControlsFromObject("Deployment Start Date", false, "The Selection Criteria allows the user to filter for Registrants deployment start date within a date range.", "OnRunReport");
            }

            UserControlToDateDeployDate.Visible = (RadioButtonListDeployStartEndDate.SelectedValue == "Deployment End Date");
            if (UserControlToDateDeployDate.Visible)
            {
                UserControlToDateDeployDate.LoadControlsFromObject("Deployment End Date", false, "The Selection Criteria allows the user to filter for  Registrants deployment end date within a date range.", "OnRunReport");
            }
        }

        if (PanelQuestionnaireDate.Visible)
        {
            UserControlDateRangeFormStartDate.Visible = (RadioButtonListStartEndDate.SelectedValue == "Questionnaire Start Date");
            if (UserControlDateRangeFormStartDate.Visible)
            {
                UserControlDateRangeFormStartDate.LoadControlsFromObject("Questionnaire Start Date", false, "Questionnaire Start Date is when the first questionnaire response is saved.  This data will only be available for registrants in Eligible and Participant status.  The Selection Criteria allows the user to filter for a questionnaire start date within a date range.", "OnRunReport");
            }

            UserControlDateRangeFormToDate.Visible = (RadioButtonListStartEndDate.SelectedValue == "Questionnaire Completed Date");
            if (UserControlDateRangeFormToDate.Visible)
            {
                UserControlDateRangeFormToDate.LoadControlsFromObject("Questionnaire Completed Date", false, "Questionnaire Completed Date is the date the questionnaire is submitted.  This data will only be available for registrants in Participant status.  The Selection Criteria allows the user to filter for a questionnaire completed date within a date range.", "OnRunReport");
            }
        }
        BaseControlListBoxSubpopulationFlag.Visible = CheckBoxSubpopulationFlag.Checked;
        UserControlAdminFlagFilter.Visible = CheckBoxAdminFlag.Checked;
        //only show exclude adminflag when adminflag visible
        PanelExcludeAdminFlag.Visible = CheckBoxAdminFlag.Checked;
        PanelHealthConcerns.Visible = (CheckBoxHealthConcerns.Checked || CheckBoxRequestToBeSeen.Checked);
        if (PanelHealthConcerns.Visible)
        {
            PanelRadioButtonHealthConcerns.Visible = CheckBoxHealthConcerns.Checked;
            PanelRadioButtonRequestToBeSeen.Visible = CheckBoxRequestToBeSeen.Checked;
        }
        
        PanelStatus.Visible = (CheckBoxRegistrantStatus.Checked || CheckBoxState.Checked);
        BaseControlListBoxStatus.Visible = CheckBoxRegistrantStatus.Checked;
        BaseControlListBoxState.Visible = CheckBoxState.Checked;
        PanelHealthFactorDeployment.Visible = (CheckBoxHealthFactor.Checked
                                                || RadioButtonListDeploymentCountry.SelectedValue != "None");
        if (PanelHealthFactorDeployment.Visible)
        {
            BaseControlDropDownListDeploymentCountryAll.Visible = (RadioButtonListDeploymentCountry.SelectedValue == "All Deployments");
            BaseControlDropDownListDeploymentCountryExposure.Visible = (RadioButtonListDeploymentCountry.SelectedValue == "Deployments With Exposure Responses");
            BaseControlListBoxHealthFactor.Visible = CheckBoxHealthFactor.Checked;
        }

        BaseControlDropDownListSeparationType.Visible = CheckBoxSeparationType.Checked;
        UserControlDateRangeSeparation.Visible = CheckBoxSeparationDate.Checked;
        PanelSeparation.Visible = CheckBoxSeparationDate.Checked;
        RadioButtonListDeathFlag.Visible = CheckBoxDeathFlag.Checked;

        PanelDeathFlag.Visible = false;
    }

    private void ClearInvisibleSearchCriteria()
    {
        if (!UserControlReportLocationAssigned.Visible)
        {
            UserControlReportLocationAssigned.ResetLocation();
        }
        if (!UserControlReportLocationEvaluation.Visible)
        {
            UserControlReportLocationEvaluation.ResetLocation();
        }
        
        if (!UserControlDateRangeFormStartDate.Visible)
        {
            UserControlDateRangeFormStartDate.FromDateValue = string.Empty;
            UserControlDateRangeFormStartDate.ToDateValue = string.Empty;
        }
        if (!UserControlDateRangeFormToDate.Visible)
        {
            UserControlDateRangeFormToDate.FromDateValue = string.Empty;
            UserControlDateRangeFormToDate.ToDateValue = string.Empty;
        }
        if (!UserControlStartDeployDate.Visible)
        {
            UserControlStartDeployDate.FromDateValue = string.Empty;
            UserControlStartDeployDate.ToDateValue = string.Empty;
        }
        if (!UserControlToDateDeployDate.Visible)
        {
            UserControlToDateDeployDate.FromDateValue = string.Empty;
            UserControlToDateDeployDate.ToDateValue = string.Empty;
        }
        if (!BaseControlListBoxSubpopulationFlag.Visible)
        {
            BaseControlListBoxSubpopulationFlag.Text = string.Empty;
        }
        if (!UserControlAdminFlagFilter.Visible)
        {
            UserControlAdminFlagFilter.AdminFlagId = string.Empty;
            UserControlAdminFlagFilter.AdminFlagEnteredDateFrom = string.Empty;
            UserControlAdminFlagFilter.AdminFlagEnteredDateTo = string.Empty;
        }
        if (!RadioButtonListHealthConcerns.Visible)
        {
            RadioButtonListHealthConcerns.SelectedIndex = 0;
        }
        
        if (!RadioButtonListRequestToBeSeen.Visible)
        {
            RadioButtonListRequestToBeSeen.SelectedIndex = 0;
        }
        if (!BaseControlListBoxStatus.Visible)
        {
            BaseControlListBoxStatus.Text = string.Empty;
        }
        if (!BaseControlListBoxState.Visible)
        {
            BaseControlListBoxState.Text = string.Empty;
        }
        if (!BaseControlDropDownListDeploymentCountryAll.Visible)
        {
            BaseControlDropDownListDeploymentCountryAll.Text = string.Empty;
        }
        if (!BaseControlDropDownListDeploymentCountryExposure.Visible)
        {
            BaseControlDropDownListDeploymentCountryExposure.Text = string.Empty;
        }
        if (!BaseControlListBoxHealthFactor.Visible)
        {
            BaseControlListBoxHealthFactor.Text = string.Empty;
        }
        if (!RadioButtonListDeathFlag.Visible)
        {
            RadioButtonListDeathFlag.SelectedIndex = 0;
        }
        
        if (!BaseControlDropDownListSeparationType.Visible)
        {
            BaseControlDropDownListSeparationType.Text = string.Empty;
        }
        if (!UserControlDateRangeSeparation.Visible)
        {
            UserControlDateRangeSeparation.FromDateValue = string.Empty;
            UserControlDateRangeSeparation.ToDateValue = string.Empty;
        }
        
        if (!RadioButtonListExcludeAdminFlag.Visible)
        {
            RadioButtonListExcludeAdminFlag.SelectedIndex = 0;
        }
        
    }



    private void ClearSearchCriteria()
    {
        UserControlReportLocationAssigned.ResetLocation();
        UserControlReportLocationEvaluation.ResetLocation();
        UserControlDateRangeFormStartDate.FromDateValue = string.Empty;
        UserControlDateRangeFormStartDate.ToDateValue = string.Empty;
        UserControlDateRangeFormToDate.FromDateValue = string.Empty;
        UserControlDateRangeFormToDate.ToDateValue = string.Empty;
        HiddenFieldQuestion.Value = string.Empty;
        BaseControlListBoxSubpopulationFlag.Text = string.Empty;
        UserControlAdminFlagFilter.AdminFlagId = string.Empty;
        UserControlAdminFlagFilter.AdminFlagEnteredDateFrom = string.Empty;
        UserControlAdminFlagFilter.AdminFlagEnteredDateTo = string.Empty;
        RadioButtonListHealthConcerns.SelectedIndex = 0;
        RadioButtonListRequestToBeSeen.SelectedIndex = 0;
        BaseControlListBoxStatus.Text = string.Empty;
        BaseControlListBoxState.Text = string.Empty;
        BaseControlDropDownListDeploymentCountryAll.Text = string.Empty;
        BaseControlDropDownListDeploymentCountryExposure.Text = string.Empty;
        BaseControlListBoxHealthFactor.Text = string.Empty;
        RadioButtonListDeathFlag.SelectedIndex = 0;
        BaseControlDropDownListSeparationType.Text = string.Empty;
        UserControlDateRangeSeparation.FromDateValue = string.Empty;
        UserControlDateRangeSeparation.ToDateValue = string.Empty;
        RadioButtonListExcludeAdminFlag.SelectedIndex = 0;
        UserControlStartDeployDate.FromDateValue = string.Empty;
        UserControlStartDeployDate.ToDateValue = string.Empty;
        UserControlToDateDeployDate.FromDateValue = string.Empty;
        UserControlToDateDeployDate.ToDateValue = string.Empty;
    }

    protected void QuestionDropDownList_SelectedIndexChanged(object sender, EventArgs e)
    {
        ShowGridViewAddFlag(false);
        gridViewPageSizeDdl.Visible = false;
        LabelItemsPerPage.Visible = false;
        
        
    }


    public override string MenuItemName()
    {
        return "Add Flags";
    }
    public override string AppObjectCode()
    {
        return "AHOBPR ADMIN ADD FLAGS";
    }
    public override string TopMenuName()
    {
        return "Registrants";
    }


    private void AddFlagsToQueueBatch(List<int> registrantList)
    {
        const int emailTemplateId = 3;  //email templateId for Eligibility Review - More Documentation Needed
        int sendMessageType = _emailService.GetMessageType(emailTemplateId);
        AHOBPRQueueManager queueManager = new AHOBPRQueueManager();
        AHOBPREmailTemplateManager emailTemplateManager = new AHOBPREmailTemplateManager();
        int registryFlagId = 0;

        //Add to Audit Log
        UserAccountManager user = (UserAccountManager)HttpContext.Current.User;
        string message = string.IsNullOrEmpty(BaseControlDropDownListAdminFlag.DescriptionText) ? BaseControlDropDownListSubpopFlag.DescriptionText : BaseControlDropDownListAdminFlag.DescriptionText;
        Helpers.AddActivityToAuditLog(user.UserId.ToString(), message,
            string.Empty, AuditLogType.MassFlagSet, registrantList.Count());

        //Add to queue
        int batchSize = Helpers.GetQueueBatchSize();
        int totalBatches = registrantList.Count % batchSize == 0 ? registrantList.Count / batchSize : Convert.ToInt32(registrantList.Count / batchSize) + 1;
        int batchNumber = 0;
        for (int i = 1; i <= totalBatches; i++)
        {
            batchNumber++;
            string registrantIds = Helpers.GetIdBatch(registrantList, batchNumber, batchSize, totalBatches);
            int actualBatchSize = batchNumber < totalBatches ? batchSize : registrantIds.Split(',').Length;

            //Add the admin or Subpopulation flags to queue batch
            if (Convert.ToInt32(DropdownListRegistryFlagType.SelectedValue) == (int)Enums.registryFlagType.adminFlag)
            {
                registryFlagId = Convert.ToInt32(BaseControlDropDownListAdminFlag.Text);

                //sent email only for Eligibility Review - More Documentation Needed
                //Add Email/Notifications to queue batch
                if (Convert.ToInt32(BaseControlDropDownListAdminFlag.Text) == (int)Enums.adminFlag.EligibilityReviewMoreDocumentationNeeded)
                {
                    switch (sendMessageType)
                    {
                        case (int)Enums.messageType.sendBoth:
                            queueManager.AddQueueBatch(registrantIds, (int)Enums.queueType.Email, emailTemplateId, string.Empty, actualBatchSize, null);
                            queueManager.AddQueueBatch(registrantIds, (int)Enums.queueType.Notification, emailTemplateId, string.Empty, actualBatchSize, null);
                            break;
                        case (int)Enums.messageType.sendNotification:
                            queueManager.AddQueueBatch(registrantIds, (int)Enums.queueType.Notification, emailTemplateId, string.Empty, actualBatchSize, null);
                            break;
                        case (int)Enums.messageType.sendEmail:
                            queueManager.AddQueueBatch(registrantIds, (int)Enums.queueType.Email, emailTemplateId, string.Empty, actualBatchSize, null);
                            break;
                    }
                }

            }
            else
            {
                registryFlagId = Convert.ToInt32(BaseControlDropDownListSubpopFlag.Text);
            }
            queueManager.AddQueueBatch(registrantIds, (int)Enums.queueType.Flag, registryFlagId, string.Empty, actualBatchSize, null);

        }
        Alert.Show("Save Successful!");
    }



    protected void GetAllRecords(object sender, EventArgs e)
    {
        IList<SP_GetRegistrantAddFlagResult> registrantListAll = GetRegistrantListSentAll();
        CustomValidatorSelectedRecords.IsValid = (registrantListAll.Count > 0); 
        Boolean setFlagValid = CheckSelectedValues();

        if (registrantListAll.Count > 0 && setFlagValid)
        {
            List<int> registrantList = (from q in registrantListAll
                                        select q.REGISTRANT_ID).ToList();
            AddFlagsToQueueBatch(registrantList);
        }
    }

    protected void GetSelectedRecords(object sender, EventArgs e)
    {
        CustomValidatorSelectedRecords.IsValid = true;
        Boolean setFlagValid = CheckSelectedValues();

        GetSelectedRegistrants();

        if (SelectedRegistrantIds.Count > 0 && setFlagValid)
        {
            AddFlagsToQueueBatch(SelectedRegistrantIds);
        }
        else
        {
            CustomValidatorSelectedRecords.IsValid = false;
        }
    }
    
    protected void DropdownListRegistryFlagType_SelectedIndexChanged(object sender, EventArgs e)
    {

        switch (Convert.ToInt32(DropdownListRegistryFlagType.SelectedValue))
            {
                //Admin Flag - 1
                case (int)Enums.registryFlagType.adminFlag:
                    BaseControlDropDownListAdminFlag.Visible = true;
                    BaseControlDropDownListSubpopFlag.Visible = false;
                    break;
                //Subpopulation Flag - 2
                case (int)Enums.registryFlagType.subpopulationFlag:
                    BaseControlDropDownListAdminFlag.Visible = false;
                    BaseControlDropDownListSubpopFlag.Visible = true;
                    break;
              
            }

       
    }

    private Boolean CheckSelectedValues()
    {
        Boolean validSetFlag = true;

        //verify flag type selected
        if (DropdownListRegistryFlagType.SelectedIndex == 0)
        {
            CustomValidatorSelectFlagType.IsValid = false;
            validSetFlag = false;
        }

        //verify admin flag or Subpopulation Flag selected
        if ((BaseControlDropDownListAdminFlag.Visible == true && string.IsNullOrEmpty(BaseControlDropDownListAdminFlag.Text))
            || (BaseControlDropDownListSubpopFlag.Visible == true && string.IsNullOrEmpty(BaseControlDropDownListSubpopFlag.Text)))
        {
            CustomValidatorSetFlag.IsValid = false;
            validSetFlag = false;
        }
        
        return validSetFlag;
    }

    private List<int> SelectedRegistrantIds
    {
        get
        {
            if (ViewState["selectedregistrantids"] == null)
            {
                ViewState["selectedregistrantids"] = new List<int>();
            }
            return (List<int>)ViewState["selectedregistrantids"];
        }
    }

    protected void GridViewAddFlag_PageIndexChanged(object sender, EventArgs e)
    {
        GetSelectedRegistrants();
    }

    protected void GridViewAddFlag_Sorting(object sender, GridViewSortEventArgs e)
    {
        GetSelectedRegistrants();
    }

    private void GetSelectedRegistrants()
    {
        foreach (GridViewRow row in GridViewAddFlag.Rows)
        {

            if (row.RowType == DataControlRowType.DataRow)
            {

                CheckBox chkRow = (row.Cells[0].FindControl("checkBoxSend") as CheckBox);
                var linkButton = (row.Cells[1].FindControl("LinkButtonRegistrantID") as LinkButton);
                int id = 0;
                if (linkButton != null)
                {
                    id = int.Parse(linkButton.Text);
                }

                if (chkRow != null && chkRow.Checked)
                {
                    if (!IsRegistrantSelected(id))
                    {
                        SelectedRegistrantIds.Add(id);
                    }
                }
                else
                {
                    if (IsRegistrantSelected(id))
                    {
                        SelectedRegistrantIds.Remove(id);
                    }
                }
            }
        }
    }

    private bool IsRegistrantSelected(int registrantId)
    {
        foreach (int id in SelectedRegistrantIds)
        {
            if (id == registrantId)
            {
                return true;
            }
        }
        return false;
    }

    protected void GridViewAddFlag_DataBound(object sender, EventArgs e)
    {
        foreach (GridViewRow row in GridViewAddFlag.Rows)
        {

            if (row.RowType == DataControlRowType.DataRow)
            {
                var foundButton = (row.Cells[1].FindControl("LinkButtonRegistrantID") as LinkButton);
                int id = 0;
                if (foundButton != null)
                {
                    id = int.Parse(foundButton.Text);
                }

                if (IsRegistrantSelected(id))
                {
                    CheckBox chkRow = (row.Cells[0].FindControl("checkBoxSend") as CheckBox);
                    if (chkRow != null)
                    {
                        chkRow.Checked = true;
                    }
                }
            }
        }
    }

    private IList<SP_GetRegistrantAddFlagResult> GetRegistrantListSentAll()
    {
            string assignedLocationType = string.Empty;
            string assignedLocationKey = string.Empty;

            assignedLocationType = UserControlReportLocationAssigned.LocationType;
            assignedLocationKey = UserControlReportLocationAssigned.LocationKey;


            //set zero default value for separation type if null 
            int separationTypeValue = (string.IsNullOrEmpty(BaseControlDropDownListSeparationType.Text) ? 0 : Convert.ToInt32(BaseControlDropDownListSeparationType.Text));

            //If Health Concerns blank set to "All"
            if (String.IsNullOrEmpty(RadioButtonListHealthConcerns.Text))
            {
                RadioButtonListHealthConcerns.Text = "All";
            }

            //set blank values to null to avoid error on count
            string status = BaseControlListBoxStatus.Text == "" ? null : BaseControlListBoxStatus.Text;
            string state = BaseControlListBoxState.Text == "" ? null : BaseControlListBoxState.Text;
            string dateRangeFormStartDate_FromDateValue = UserControlDateRangeFormStartDate.FromDateValue == "" ? null : UserControlDateRangeFormStartDate.FromDateValue;
            string dateRangeFormStartDate_ToDateValue = UserControlDateRangeFormStartDate.ToDateValue == "" ? null : UserControlDateRangeFormStartDate.ToDateValue;
            string healthFactor = BaseControlListBoxHealthFactor.Text == "" ? null : BaseControlListBoxHealthFactor.Text;
            string dateRangeFormToDate_FromDateValue = UserControlDateRangeFormToDate.FromDateValue == "" ? null : UserControlDateRangeFormToDate.FromDateValue;
            string dateRangeFormToDate_ToDateValue = UserControlDateRangeFormToDate.ToDateValue == "" ? null : UserControlDateRangeFormToDate.ToDateValue;
            string hiddenFieldQuestion = HiddenFieldQuestion.Value == "" ? null : HiddenFieldQuestion.Value;
            string subpopulationFlag = BaseControlListBoxSubpopulationFlag.Text == "" ? null : BaseControlListBoxSubpopulationFlag.Text;
            string adminFlagId = UserControlAdminFlagFilter.AdminFlagId == "" ? null : UserControlAdminFlagFilter.AdminFlagId;
            string deploymentCountryAll = BaseControlDropDownListDeploymentCountryAll.Text == "" ? null : BaseControlDropDownListDeploymentCountryAll.Text;
            string deploymentCountryExposure = BaseControlDropDownListDeploymentCountryExposure.Text == "" ? null : BaseControlDropDownListDeploymentCountryExposure.Text;
            string adminFlagFilter_AdminFlagEnteredDateFrom = UserControlAdminFlagFilter.AdminFlagEnteredDateFrom == "" ? null : UserControlAdminFlagFilter.AdminFlagEnteredDateFrom;
            string adminFlagFilter_AdminFlagEnteredDateTo = UserControlAdminFlagFilter.AdminFlagEnteredDateTo == "" ? null : UserControlAdminFlagFilter.AdminFlagEnteredDateTo;
            string dateRangeSeparation_FromDateValue = UserControlDateRangeSeparation.FromDateValue == "" ? null : UserControlDateRangeSeparation.FromDateValue;
            string dateRangeSeparation_ToDateValue = UserControlDateRangeSeparation.ToDateValue == "" ? null : UserControlDateRangeSeparation.ToDateValue;
            string dateRangeDeployStartDate_FromDateValue = UserControlStartDeployDate.FromDateValue == "" ? null : UserControlStartDeployDate.FromDateValue;
            string dateRangeDeployStartDate_ToDateValue = UserControlStartDeployDate.ToDateValue == "" ? null : UserControlStartDeployDate.ToDateValue;
            string dateRangeDeployToDate_FromDateValue = UserControlToDateDeployDate.FromDateValue == "" ? null : UserControlToDateDeployDate.FromDateValue;
            string dateRangeDeployToDate_ToDateValue = UserControlToDateDeployDate.ToDateValue == "" ? null : UserControlToDateDeployDate.ToDateValue;
            string sortExpression = null;
            int maximumRows = 0;
            int startRowIndex = 0;


            IList<SP_GetRegistrantAddFlagResult> registrantList = _reportManager.GetRegistrantAddFlag(status,
                state,
                dateRangeFormStartDate_FromDateValue,
                dateRangeFormStartDate_ToDateValue,
                healthFactor,
                dateRangeFormToDate_FromDateValue,
                dateRangeFormToDate_ToDateValue,
                RadioButtonListHealthConcerns.Text,
                RadioButtonListRequestToBeSeen.Text,
                assignedLocationType,
                assignedLocationKey,
                UserControlReportLocationEvaluation.LocationType,
                UserControlReportLocationEvaluation.LocationKey,
                subpopulationFlag,
                adminFlagId,
                deploymentCountryAll,
                deploymentCountryExposure,
                adminFlagFilter_AdminFlagEnteredDateFrom,
                adminFlagFilter_AdminFlagEnteredDateTo,
                RadioButtonListDeathFlag.Text,
                separationTypeValue,
                dateRangeSeparation_FromDateValue,
                dateRangeSeparation_ToDateValue,
                RadioButtonListExcludeAdminFlag.Text,
                dateRangeDeployStartDate_FromDateValue,
                dateRangeDeployStartDate_ToDateValue,
                dateRangeDeployToDate_FromDateValue,
                dateRangeDeployToDate_ToDateValue,
                sortExpression,
                maximumRows,
                startRowIndex);

            return registrantList;
       
    }

    protected void gridViewPageSizeDdlChanged(Object sender, EventArgs e)
    {

        GridViewAddFlag.PageSize = int.Parse(gridViewPageSizeDdl.SelectedValue);

    }

    protected void gridView_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        GridViewAddFlag.PageIndex = e.NewPageIndex;

    }

    private void SubpopulationFlagChanged(object sender, System.ComponentModel.PropertyChangedEventArgs e)
    {
        if (sender != null)
        {
            controls_BaseControlListBox baseControl = (controls_BaseControlListBox)sender;
            UserSession.UserControlSubpopulationFlag = baseControl.SessionListBox;
        }
    }

    private void StatusFlagChanged(object sender, System.ComponentModel.PropertyChangedEventArgs e)
    {
        if (sender != null)
        {
            controls_BaseControlListBox baseControl = (controls_BaseControlListBox)sender;
            UserSession.UserControlStatus = baseControl.SessionListBox;
        }
    }

    private void StateFlagChanged(object sender, System.ComponentModel.PropertyChangedEventArgs e)
    {
        if (sender != null)
        {
            controls_BaseControlListBox baseControl = (controls_BaseControlListBox)sender;
            UserSession.UserControlState = baseControl.SessionListBox;
        }
    }

    private void HealthFactorFlagChanged(object sender, System.ComponentModel.PropertyChangedEventArgs e)
    {
        if (sender != null)
        {
            controls_BaseControlListBox baseControl = (controls_BaseControlListBox)sender;
            UserSession.UserControlHealthFactor = baseControl.SessionListBox;
        }
    }
}