﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web.Security;
using System.Web.UI.WebControls.WebParts;
using System.Text;
using System.IO;
using System.Reflection;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;

public partial class AdminActionTracking : BasePage
{
    private AHOBPRBaseControlManager _baseControlManager = new AHOBPRBaseControlManager();
    private List<STD_GUI_CONTROL_AHOBPR> _dbAhopbrControls = null;
    //private AHOBPRRegistrantManager _registrantManager = new AHOBPRRegistrantManager();

    #region Protected Members

    protected void Page_Load(object sender, EventArgs e)
    {
        UserSession.ActionTrackingUserId = string.Empty;
        UserSession.ActionTrackingUserFullName = string.Empty;
        UserSession.ActionTrackingUserRoles = string.Empty;

        var master = (this.Master as RegistryMaster);
        if (master != null)
        {
            master.SetDirtyFlag(false);
        }
        LoadBaseControls();
        UserSession.RegistrantId = 0;
        //UserSession.Registrant = null;

        UserControlDateRangeActionDate.FromDateLabel = "From Date (mm/dd/yyyy):<br />";
        UserControlDateRangeActionDate.ToDateLabel = "To Date (mm/dd/yyyy):<br />";
        UserControlDateRangeActionDate.LoadControlsFromObject(string.Empty, false, string.Empty, "SearchUser");


        if (!string.IsNullOrEmpty(UserSession.UserListSortDirection)
            || !string.IsNullOrEmpty(UserSession.UserListSortColumn))
        {
            HiddenFieldSort.Value = UserSession.UserListSortColumn + " " + UserSession.UserListSortDirection;
        }

        
        if (!IsPostBack)
        {
            if (Request.QueryString["from"] == null)
            {
                HideGridView();
            }
            else
            {
                BaseControlTextBoxLastName.Text = UserSession.ActionTrackingFilterLastName;
                BaseControlTextBoxFirstName.Text = UserSession.ActionTrackingFilterFirstName;
                BaseControlDropDownListActionType.Text = UserSession.ActionTrackingFilterActionType;
                BaseControlDropDownListUserRole.Text = UserSession.ActionTrackingFilterUserRole;
                UserControlDateRangeActionDate.FromDateValue = UserSession.ActionTrackingFilterFromDate;
                UserControlDateRangeActionDate.ToDateValue = UserSession.ActionTrackingFilterToDate;
                string pageSize = ConfigurePageSize();
                gridViewPageSizeDdl.SelectedIndex = -1;

                foreach (ListItem item in gridViewPageSizeDdl.Items)
                {

                    if (item.Value == pageSize.Trim())
                    {
                        item.Selected = true;
                        break;
                    }
                }
                SearchUsers();
            }
        }
    }

    private string ConfigurePageSize()
    {
        if (UserSession.ActionTrackingFilterItemPerpage == null)
        {
            UserSession.ActionTrackingFilterItemPerpage = gridViewPageSizeDdl.SelectedValue;
        }
        return UserSession.ActionTrackingFilterItemPerpage;
    }

    protected void ButtonSearch_Click(object sender, EventArgs e)
    {
        HideGridView();
        SearchUsers();
    }

    private void HideGridView()
    {
        gridViewPageSizeDdl.Visible = false;
        LabelItemsPerPage.Visible = false;
        LabelNumberOfUsersFound.Visible = false;
        GridViewUser.Visible = false;
        GridViewAuditLog.Visible = false;
    }
 
    private void SearchUsers()
    {

        // Validate that at least one value was entered    
        if (String.IsNullOrEmpty(BaseControlTextBoxLastName.Text)
            && String.IsNullOrEmpty(BaseControlTextBoxFirstName.Text)
            && string.IsNullOrEmpty(BaseControlDropDownListUserRole.Text)
            && string.IsNullOrEmpty(BaseControlDropDownListActionType.Text)
            && string.IsNullOrEmpty(UserControlDateRangeActionDate.FromDateValue)
            && string.IsNullOrEmpty(UserControlDateRangeActionDate.ToDateValue)
            )
        {
            CustomValidatorSearchCriteria.ErrorMessage = "Please select at least one search criteria.";
            CustomValidatorSearchCriteria.IsValid = false;
        }
        else if (UserControlDateRangeActionDate.ValidateCustomValidator() == false)
        {

        }
        else
        {
            UserSession.ActionTrackingFilterLastName = BaseControlTextBoxLastName.Text;
            UserSession.ActionTrackingFilterFirstName = BaseControlTextBoxFirstName.Text;
            UserSession.ActionTrackingFilterActionType = BaseControlDropDownListActionType.Text;
            UserSession.ActionTrackingFilterUserRole = BaseControlDropDownListUserRole.Text;
            UserSession.ActionTrackingFilterFromDate = UserControlDateRangeActionDate.FromDateValue;
            UserSession.ActionTrackingFilterToDate = UserControlDateRangeActionDate.ToDateValue;
            SearchUsersWithAuditLog();
        }
    }

    protected void ButtonClear_Click(object sender, EventArgs e)
    {
        BaseControlTextBoxLastName.Text = UserSession.ActionTrackingFilterLastName = string.Empty;
        BaseControlTextBoxFirstName.Text = UserSession.ActionTrackingFilterFirstName = string.Empty;
        BaseControlDropDownListActionType.Text = UserSession.ActionTrackingFilterActionType = string.Empty;
        BaseControlDropDownListUserRole.Text = UserSession.ActionTrackingFilterUserRole = string.Empty;
        UserControlDateRangeActionDate.FromDateValue = UserSession.ActionTrackingFilterFromDate = string.Empty;
        UserControlDateRangeActionDate.ToDateValue = UserSession.ActionTrackingFilterToDate = string.Empty;

        UserSession.UserListSortDirection = string.Empty;
        UserSession.UserListSortColumn = string.Empty;
        HiddenFieldSort.Value = string.Empty;
        HideGridView();
    }

            
    #endregion

    #region Abstract Member Implementations

    public override string MenuItemName()
    {
        return "Action Tracking";
    }
    public override string AppObjectCode()
    {
        return "AHOBPR ADMIN LIST USERS";
    }
    public override string TopMenuName()
    {
        return "Administration";
    }

    #endregion

    #region Private Members

    private void SearchUsersWithAuditLog()
    {
        AHOBPRAuditManager manager = new AHOBPRAuditManager();
        gridViewPageSizeDdl.Visible = true;
        LabelItemsPerPage.Visible = true;
        LabelNumberOfUsersFound.Visible = true;

        if (string.IsNullOrEmpty(BaseControlDropDownListActionType.Text)
            && string.IsNullOrEmpty(UserControlDateRangeActionDate.FromDateValue)
            && string.IsNullOrEmpty(UserControlDateRangeActionDate.ToDateValue))
        {
            if (GridViewAuditLog.Visible)
            {
                UserSession.UserListSortDirection = string.Empty;
                UserSession.UserListSortColumn = string.Empty;
            }
            GridViewUser.PageSize = int.Parse(gridViewPageSizeDdl.SelectedValue);
            GridViewUser.Visible = true;
            GridViewAuditLog.Visible = false;
            GridViewUser.DataSource = manager.SearchUsersForActionTracking(BaseControlTextBoxLastName.Text,
                                        BaseControlTextBoxFirstName.Text,
                                        BaseControlDropDownListUserRole.Text, HiddenFieldSort.Value);
            LabelNumberOfUsersFound.Text = "Total Users Found: " + manager.SearchUsersForActionTrackingCount(BaseControlTextBoxLastName.Text,
                                        BaseControlTextBoxFirstName.Text,
                                        BaseControlDropDownListUserRole.Text).ToString();
            GridViewUser.DataBind();
        }
        else
        {
            if (GridViewUser.Visible)
            {
                UserSession.UserListSortDirection = string.Empty;
                UserSession.UserListSortColumn = string.Empty;
            }

            GridViewAuditLog.PageSize = int.Parse(gridViewPageSizeDdl.SelectedValue);
            GridViewUser.Visible = false;
            GridViewAuditLog.Visible = true;
            GridViewAuditLog.DataSource = manager.SearchAuditLog(string.Empty, BaseControlTextBoxLastName.Text,
                                        BaseControlTextBoxFirstName.Text,
                                        BaseControlDropDownListUserRole.Text, BaseControlDropDownListActionType.Text,
                                        UserControlDateRangeActionDate.FromDateValue, 
                                        UserControlDateRangeActionDate.ToDateValue,
                                        HiddenFieldSort.Value);

            LabelNumberOfUsersFound.Text = "Total Records Found: " + manager.SearchAuditLogCount(string.Empty, BaseControlTextBoxLastName.Text,
                                        BaseControlTextBoxFirstName.Text,
                                        BaseControlDropDownListUserRole.Text, BaseControlDropDownListActionType.Text,
                                        UserControlDateRangeActionDate.FromDateValue,
                                        UserControlDateRangeActionDate.ToDateValue).ToString();
            GridViewAuditLog.DataBind();
        }
    }

    private void LoadBaseControls()
    {
        foreach (STD_GUI_CONTROL_AHOBPR dbItem in GetGuiControls("AHOBPR_ACTION_TRACKING"))
        {
            Control userControl = PanelSearchCriteria.FindControl(dbItem.USER_CONTROL_ID);
            if (userControl != null)
            {
                if (dbItem.BASE_CONTROL_TYPE == (int)AhobprBaseControlType.TextBox)
                {
                    controls_BaseControlTextBox baseControl = (controls_BaseControlTextBox)userControl;
                    baseControl.LoadControlsFromObject(string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP,
                        dbItem.INCLUDE_LABEL, dbItem.DATA_TYPE_MAX_LENGTH, dbItem.DATA_ELEMENT_WIDTH,
                        dbItem.VALIDATION_GROUP, dbItem.VALIDATION_ERROR_MESSAGE, dbItem.VALIDATION_REGULAR_EXPRESSION,
                        dbItem.REQUIRED);
                }
                else if (dbItem.BASE_CONTROL_TYPE ==  (int)AhobprBaseControlType.DropDownList)
                {
                    controls_BaseControlDropDownList baseControlDropdown = (controls_BaseControlDropDownList)userControl;

                    baseControlDropdown.LoadControlsFromObject(string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP, dbItem.INCLUDE_LABEL, dbItem.LOOKUP_LIST_CATEGORY,
                                                               dbItem.VALIDATION_GROUP, dbItem.VALIDATION_ERROR_MESSAGE, dbItem.REQUIRED);
                }
          }

        }
    }

    private List<STD_GUI_CONTROL_AHOBPR> GetGuiControls(string controlCategory)
    {
        if (UserSession.GuiControlsActionTracking == null)
        {
            _dbAhopbrControls = _baseControlManager.SelectGuiControlList(controlCategory).ToList<STD_GUI_CONTROL_AHOBPR>();
            UserSession.GuiControlsActionTracking = _dbAhopbrControls;
        }
        else
        {
            _dbAhopbrControls = UserSession.GuiControlsActionTracking;
        }

        return _dbAhopbrControls;
    }

    #endregion
    protected void GridViewUser_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "Details")
        {
            int index = Convert.ToInt32(e.CommandArgument);
            GridViewUser.SelectedIndex = index;
            var foundLabel = (GridViewUser.SelectedRow.FindControl("LabelUserId") as Label);
            if (foundLabel != null)
            {
                UserSession.ActionTrackingUserId = foundLabel.Text;
            }
            foundLabel = (GridViewUser.SelectedRow.FindControl("LabelFullName") as Label);
            if (foundLabel != null)
            {
                UserSession.ActionTrackingUserFullName = foundLabel.Text;
            }
            foundLabel = (GridViewUser.SelectedRow.FindControl("LabelUserRoles") as Label);
            if (foundLabel != null)
            {
                UserSession.ActionTrackingUserRoles = foundLabel.Text;
            }
            Response.Redirect("AdminActionTrackingByUser.aspx");
        }
    }


    protected void gridViewPageSizeDdlChanged(Object sender, EventArgs e)
    {
        UserSession.ActionTrackingFilterItemPerpage = gridViewPageSizeDdl.SelectedValue;
        SearchUsersWithAuditLog();
    }

    protected void GridViewUser_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        GridViewUser.PageIndex = e.NewPageIndex;
        SearchUsersWithAuditLog();
    }

    protected void GridViewUser_Sorting(object sender, GridViewSortEventArgs e)
    {
        SetSortDirection(e.SortExpression);
        SearchUsersWithAuditLog();
    }

    protected void GridViewAuditLog_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        GridViewAuditLog.PageIndex = e.NewPageIndex;
        SearchUsersWithAuditLog();
    }

    protected void GridViewAuditLog_Sorting(object sender, GridViewSortEventArgs e)
    {
        SetSortDirection(e.SortExpression);
        SearchUsersWithAuditLog();
    }

    private void SetSortDirection(String column)
    {
        String sortDirection = "ASC";
        String sortColumn = "";
        if (!string.IsNullOrEmpty(UserSession.UserListSortColumn))
        {
            sortColumn = UserSession.UserListSortColumn;
        }

        if (!String.IsNullOrEmpty(sortColumn))
        {
            if (sortColumn == column)
            {
                String lastDirection = UserSession.UserListSortDirection;
                if (!String.IsNullOrEmpty(lastDirection) && (lastDirection == "ASC"))
                {
                    sortDirection = "DESC";
                }
            }
        }
        UserSession.UserListSortDirection = sortDirection;
        UserSession.UserListSortColumn = column;

        HiddenFieldSort.Value = column + " " + sortDirection;
    }

}