DROP VIEW ADR.APPOINTMENT_REQUEST_LOAD1_VW;

/* Formatted on 4/24/2019 10:52:20 AM (QP5 v5.269.14213.34769) */
CREATE OR REPLACE FORCE VIEW ADR.APPOINTMENT_REQUEST_LOAD1_VW
(
   APPOINTMENT_REQUEST_H_ID,
   APPOINTMENT_REQUEST_ID,
   PERSON_ID,
   TRANSACTION_TYPE_CODE,
   RESPONSE,
   ORIG_RESPONSE,
   RESPONSE_DATE,
   ORIG_RESPONSE_DATE,
   RESPONSE_CHG_DATE,
   ORIG_RESPONSE_CHG_DATE,
   RECORD_CREATED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_DATE,
   RECORD_MODIFIED_BY,
   RECORD_MODIFIED_COUNT
)
AS
   SELECT appointment_request_h_id,
          appointment_request_id,
          person_id,
          transaction_type_code,
          response,
          orig_response,
          response_date,
          orig_response_date,
          response_chg_date,
          orig_response_chg_date,
          record_created_date,
          SUBSTR (record_created_by || '-1928824', 1, 30) record_created_by,
          record_modified_date,
          record_modified_by,
          (  ROW_NUMBER ()
             OVER (PARTITION BY person_id
                   ORDER BY record_modified_date, appointment_request_h_id)
           - 1)
             record_modified_count
     FROM (WITH person_case1
                AS (SELECT person_id, min_person_h_id
                      FROM ADR.CCN_PERS_ENROLLDETR_CASE1_TMP
                           PARTITION (PERS_ENROLLDETR1_TMP_P10))
           SELECT                                          /* use_hash (c ) */
                 p.person_h_id appointment_request_h_id,
                  p.person_id appointment_request_id,
                  p.person_id,
                  CASE
                     WHEN (  (ROW_NUMBER ()
                              OVER (
                                 PARTITION BY p.person_id
                                 ORDER BY record_modified_date, person_h_id))
                           - 1) = 0
                     THEN
                        'I'
                     ELSE
                        'U'
                  END
                     transaction_type_code,
                  appointment_was_requested_ind response,
                  FIRST_VALUE (
                     NVL (appointment_was_requested_ind, 0))
                  IGNORE NULLS
                  OVER (PARTITION BY p.person_id
                        ORDER BY record_modified_date, person_h_id)
                     orig_response,
                  appointment_requested_date response_date,
                  FIRST_VALUE (
                     appointment_requested_date)
                  IGNORE NULLS
                  OVER (PARTITION BY p.person_id
                        ORDER BY record_modified_date, person_h_id)
                     orig_response_date,
                  record_modified_date response_chg_date,
                  FIRST_VALUE (
                     record_modified_date)
                  IGNORE NULLS
                  OVER (PARTITION BY p.person_id
                        ORDER BY record_modified_date, person_h_id)
                     orig_response_chg_date,
                  (CASE
                      WHEN NVL (appointment_was_requested_ind, 3) =
                              LAG (
                                 NVL (appointment_was_requested_ind, 3))
                              OVER (
                                 PARTITION BY p.person_id
                                 ORDER BY record_modified_date, person_h_id)
                      THEN
                         1
                      WHEN NVL (appointment_was_requested_ind, 3) !=
                              LAG (
                                 NVL (appointment_was_requested_ind, 3))
                              OVER (
                                 PARTITION BY p.person_id
                                 ORDER BY record_modified_date, person_h_id)
                      THEN
                         0
                   END)
                     EXCLUSION,
                  ROW_NUMBER ()
                  OVER (PARTITION BY p.person_id
                        ORDER BY record_modified_date, person_h_id)
                     ROWNUMBER,
                  record_created_date,
                  record_created_by,
                  record_modified_date,
                  record_modified_by
             FROM PERSON_H p, person_case1 c
            WHERE     c.person_id = p.person_id
                  AND p.person_h_id >= c.min_person_h_id)
    WHERE (EXCLUSION = 0 OR rownumber = 1);


CREATE OR REPLACE PUBLIC SYNONYM APPOINTMENT_REQUEST_LOAD1_VW FOR ADR.APPOINTMENT_REQUEST_LOAD1_VW;


GRANT SELECT ON ADR.APPOINTMENT_REQUEST_LOAD1_VW TO ADR_R;
DROP VIEW ADR.APPOINTMENT_REQUEST_LOAD2_VW;

/* Formatted on 4/24/2019 10:52:22 AM (QP5 v5.269.14213.34769) */
CREATE OR REPLACE FORCE VIEW ADR.APPOINTMENT_REQUEST_LOAD2_VW
(
   APPOINTMENT_REQUEST_H_ID,
   APPOINTMENT_REQUEST_ID,
   PERSON_ID,
   TRANSACTION_TYPE_CODE,
   RESPONSE,
   ORIG_RESPONSE,
   RESPONSE_DATE,
   ORIG_RESPONSE_DATE,
   RESPONSE_CHG_DATE,
   ORIG_RESPONSE_CHG_DATE,
   RECORD_CREATED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_DATE,
   RECORD_MODIFIED_BY,
   RECORD_MODIFIED_COUNT
)
AS
   SELECT appointment_request_h_id,
          appointment_request_id,
          person_id,
          trans_type_code transaction_type_code,
          response,
          orig_response,
          response_date,
          orig_response_date,
          response_chg_date,
          orig_response_chg_date,
          record_created_date,
          SUBSTR (record_created_by || '-2928824', 1, 30) record_created_by,
          record_modified_date,
          record_modified_by,
          record_modified_count
     FROM (SELECT appointment_request_h_id,
                  appointment_request_id,
                  person_id,
                  trans_type_code,
                  response,
                  orig_response,
                  response_date,
                  orig_response_date,
                  response_chg_date,
                  orig_response_chg_date,
                  record_created_date,
                  record_created_by,
                  record_modified_date,
                  record_modified_by,
                  (  ROW_NUMBER ()
                     OVER (
                        PARTITION BY person_id
                        ORDER BY
                           record_modified_date, appointment_request_h_id)
                   - 1)
                     record_modified_count
             FROM (WITH person_case1
                        AS (SELECT person_id, min_person_h_id
                              FROM ADR.CCN_PERS_ENROLLDETR_CASE2_TMP
                                   PARTITION (PERS_ENROLLDETR2_TMP_P10))
                   SELECT                                   /* use_hash (c) */
                         p.person_h_id appointment_request_h_id,
                          p.person_id appointment_request_id,
                          p.person_id,
                          CASE
                             WHEN (  ROW_NUMBER ()
                                     OVER (
                                        PARTITION BY p.person_id
                                        ORDER BY
                                           record_modified_date, person_h_id)
                                   - 1) = 0
                             THEN
                                'I'
                             ELSE
                                'U'
                          END
                             trans_type_code,
                          appointment_was_requested_ind response,
                          FIRST_VALUE (
                             NVL (appointment_was_requested_ind, 0))
                          IGNORE NULLS
                          OVER (PARTITION BY p.person_id
                                ORDER BY record_modified_date, person_h_id)
                             orig_response,
                          appointment_requested_date response_date,
                          FIRST_VALUE (
                             appointment_requested_date)
                          IGNORE NULLS
                          OVER (PARTITION BY p.person_id
                                ORDER BY record_modified_date, person_h_id)
                             orig_response_date,
                          record_modified_date response_chg_date,
                          FIRST_VALUE (
                             record_modified_date)
                          IGNORE NULLS
                          OVER (PARTITION BY p.person_id
                                ORDER BY record_modified_date, person_h_id)
                             orig_response_chg_date,
                          (CASE
                              WHEN NVL (appointment_was_requested_ind, 3) =
                                      LAG (
                                         NVL (appointment_was_requested_ind,
                                              3))
                                      OVER (
                                         PARTITION BY p.person_id
                                         ORDER BY
                                            record_modified_date, person_h_id)
                              THEN
                                 1
                              WHEN NVL (appointment_was_requested_ind, 3) !=
                                      LAG (
                                         NVL (appointment_was_requested_ind,
                                              3))
                                      OVER (
                                         PARTITION BY p.person_id
                                         ORDER BY
                                            record_modified_date, person_h_id)
                              THEN
                                 0
                           END)
                             EXCLUSION,
                          ROW_NUMBER ()
                          OVER (PARTITION BY p.person_id
                                ORDER BY record_modified_date, person_h_id)
                             ROWNUMBER,
                          record_created_by,
                          record_created_date,
                          record_modified_by,
                          record_modified_date
                     FROM PERSON_H p, person_case1 c
                    WHERE     c.person_id = p.person_id
                          AND p.person_h_id >= c.min_person_h_id)
            WHERE (EXCLUSION = 0 OR rownumber = 1));


CREATE OR REPLACE PUBLIC SYNONYM APPOINTMENT_REQUEST_LOAD2_VW FOR ADR.APPOINTMENT_REQUEST_LOAD2_VW;


GRANT SELECT ON ADR.APPOINTMENT_REQUEST_LOAD2_VW TO ADR_R;
DROP VIEW ADR.ACTIVEAGG_VW;

/* Formatted on 4/24/2019 10:52:23 AM (QP5 v5.269.14213.34769) */
CREATE OR REPLACE FORCE VIEW ADR.ACTIVEAGG_VW
(
   PERID,
   ICN,
   EDIPI,
   SSN,
   LN,
   FN,
   MN,
   SUF,
   DOB,
   DOD,
   GENDER,
   ENR_DTE,
   CV_ELIG,
   ELIG_VERIFIED,
   ENR_CODE,
   PRIORITY,
   ENR_CRE_DTE,
   ADD_TYPE,
   BAI,
   ADDRESS_ID,
   ST1,
   ST2,
   ST3,
   CITY,
   STATE,
   ZIP,
   ZIP4,
   COUNTRY,
   ADT,
   PFA,
   PCF,
   HPN,
   CPN,
   WPN,
   APN,
   TSTART,
   TEND,
   PF_NO,
   PF_NAME,
   VCE,
   SCI,
   SC_PCT,
   SAI,
   SALIST,
   NSCI,
   NLE_ES,
   STA_VISN,
   STA_NO,
   STA_NAME,
   EE_FLAG,
   DISTANCE,
   OPP_FLAG,
   ADR_LON,
   ADR_LAT,
   STA_ST1,
   STA_ST2,
   STA_ST3,
   STA_CITY,
   STA_STATE,
   STA_ZIP,
   STA_ZIP4,
   STA_LON,
   STA_LAT,
   LOC_NAME,
   GEO_DATE,
   SOFTWARE_VER,
   STATUS,
   STATUS_DATE,
   WT_INFO_CONCATTED,
   MAILING_EXCEPTION,
   TIME_COHORT,
   BASIC_ELIG,
   GEO_TIME_FRAME_BEGIN,
   GEO_TIME_FRAME_END,
   WT_RUN_TIME,
   VBA_DOD,
   EVER_GEO_CODED,
   CALC_TYPE,
   DD_BASIC_ELIG,
   DD_NLE_ES,
   VISN,
   URH,
   FIPS,
   MARKET,
   SUBMARKET,
   SECTOR,
   STATE_FIPS,
   S_CLASS_NAME,
   OUTPATIENTRATING,
   PAR_STA_NO,
   PARENTSTATIONCL,
   SH_PAR_STA,
   VA_SITE,
   ST,
   POD,
   SHAR,
   HCC,
   MSCBOC,
   NEWVAMC,
   PCCBOC,
   COCCLASSIFICATIONID,
   VAH,
   CD,
   CONT,
   PROV,
   VACAA_LIST_DATE,
   NLE_ES_DATE,
   COUNTY_NAME,
   MARKET_NAME,
   DATASOURCE,
   DISTRICT,
   STA_DISTRICT_VISN,
   RECORD_CREATED_TS
)
AS
   SELECT PERID,
          ICN,
          EDIPI,
          SSN,
          LN,
          FN,
          MN,
          SUF,
          DOB,
          DOD,
          GENDER,
          ENR_DTE,
          CV_ELIG,
          ELIG_VERIFIED,
          ENR_CODE,
          PRIORITY,
          ENR_CRE_DTE,
          ADD_TYPE,
          BAI,
          ADDRESS_ID,
          ST1,
          ST2,
          ST3,
          CITY,
          STATE,
          ZIP,
          ZIP4,
          COUNTRY,
          ADT,
          PFA,
          PCF,
          HPN,
          CPN,
          WPN,
          APN,
          TSTART,
          TEND,
          PF_NO,
          PF_NAME,
          VCE,
          SCI,
          SC_PCT,
          SAI,
          SALIST,
          NSCI,
          NLE_ES,
          STA_VISN,
          STA_NO,
          STA_NAME,
          EE_FLAG,
          DISTANCE,
          OPP_FLAG,
          ADR_LON,
          ADR_LAT,
          STA_ST1,
          STA_ST2,
          STA_ST3,
          STA_CITY,
          STA_STATE,
          STA_ZIP,
          STA_ZIP4,
          STA_LON,
          STA_LAT,
          LOC_NAME,
          GEO_DATE,
          SOFTWARE_VER,
          STATUS,
          STATUS_DATE,
          WT_INFO_CONCATTED,
          MAILING_EXCEPTION,
          TIME_COHORT,
          BASIC_ELIG,
          GEO_TIME_FRAME_BEGIN,
          GEO_TIME_FRAME_END,
          WT_RUN_TIME,
          VBA_DOD,
          EVER_GEO_CODED,
          CALC_TYPE,
          DD_BASIC_ELIG,
          DD_NLE_ES,
          VISN,
          URH,
          FIPS,
          MARKET,
          SUBMARKET,
          SECTOR,
          STATE_FIPS,
          S_CLASS_NAME,
          OUTPATIENTRATING,
          PAR_STA_NO,
          PARENTSTATIONCL,
          SH_PAR_STA,
          VA_SITE,
          ST,
          POD,
          SHAR,
          HCC,
          MSCBOC,
          NEWVAMC,
          PCCBOC,
          COCCLASSIFICATIONID,
          VAH,
          CD,
          CONT,
          PROV,
          VACAA_LIST_DATE,
          NLE_ES_DATE,
          COUNTY_NAME,
          MARKET_NAME,
          DATASOURCE,
          DISTRICT,
          STA_DISTRICT_VISN,
          s.RECORD_CREATED_TS
     FROM ADR.ACTIVEAGG s,
          (SELECT CASE
                     WHEN LOADING_STATUS = 'YES' THEN CURRENT_ACTIVE_DATE
                     WHEN LOADING_STATUS = 'FAIL' THEN PREVIOUS_ACTIVE_DATE
                     ELSE NULL
                  END
                     active_dt
             FROM ADR.ActiveAGG_TRACKER) t
    WHERE TRUNC (s.RECORD_CREATED_TS) = TRUNC (t.active_dt);


CREATE OR REPLACE PUBLIC SYNONYM ACTIVEAGG_VW FOR ADR.ACTIVEAGG_VW;


GRANT SELECT ON ADR.ACTIVEAGG_VW TO ADR_R;

GRANT SELECT ON ADR.ACTIVEAGG_VW TO EEATUSR;

GRANT SELECT ON ADR.ACTIVEAGG_VW TO EEUSR;
DROP VIEW ADR.CCN_SERVICE_LOG_LOAD_VW;

/* Formatted on 4/24/2019 10:52:25 AM (QP5 v5.269.14213.34769) */
CREATE OR REPLACE FORCE VIEW ADR.CCN_SERVICE_LOG_LOAD_VW
(
   SERVICE_LOG_STAT_ID,
   PERSON_ID,
   FIRST_NAME,
   LAST_NAME,
   MID_NAME,
   SUFFIX,
   DATE_OF_BIRTH,
   DATE_OF_BIRTH_TXT,
   DATE_OF_DEATH,
   BIRTH_SEX,
   MAILING_ADDRESS_H_ID,
   EMAIL,
   VCELIGIBILITY_H_ID,
   HPHONE_NUM,
   CPHONE_NUM,
   TPHONE_NUM,
   VISN_GEO,
   RESI_ADDRESS_H_ID,
   PREFERRED_FACILITY_H_ID,
   GEOCODE_STATION_H_ID,
   ADDR_RECORD_MODIFIED_DATE,
   VCELIGBTY_RECORD_MODIFIED_DATE,
   SVL_RECORD_MODIFIED_DATE,
   VCE,
   PRIORITY_GROUP,
   PRIORITY_GROUP_EFFECT_DATE_TXT
)
AS
   SELECT /*+ use_hash (per addr prf addrh prf) */
          (CASE
              WHEN sl.CCN_SERVICE_LOG_ID IS NULL THEN 0
              WHEN sl.CCN_SERVICE_LOG_ID IS NOT NULL THEN CCN_SERVICE_LOG_ID
           END)
             service_log_stat_id,
          per.person_id,
          per.first_name,
          per.last_name,
          per.middle_name,
          per.suffix,
          per.date_of_birth,
          per.date_of_birth_txt,
          per.death_date_txt,
          per.gender_code,
          addrh.mailing_address_h_id,
          em.email_address,
          per.VCELIGIBILITY_H_ID,
          ph.hphone_num,
          ph.cphone_num,
          ph.tphone_num,
          geot.visn_geo,
          addrh.resi_address_h_id,
          prf.preferred_facility_h_id,
          geot.GEOCODE_STATION_H_ID,
          addr.addr_record_modified_date,
          per.vceligbty_record_modified_date,
          sl.max_record_modified_date svl_record_modified_date,
          per.VCE,
          per.PRIORITY_GROUP,
          per.PRIORITY_GROUP_EFFECT_DATE_TXT
     FROM ADR.CCN_PERSON_SELECTED_STG PARTITION (CCN_PERSEL_STG_P14) per
          INNER JOIN adr.CCN_ADDRESS_STG PARTITION (CCN_ADDRESS_STG_P14) addr
             ON per.person_id = addr.person_id
          LEFT OUTER JOIN ADR.CCN_ADDRESS_H_STG addrh
             ON addrh.person_id = per.person_id
          LEFT OUTER JOIN ADR.CCN_PREFERED_FACILITY_H_STG prf
             ON prf.person_id = per.person_id
          LEFT OUTER JOIN ADR.CCN_EMAIL_STG em
             ON em.person_id = per.person_id
          LEFT OUTER JOIN ADR.CCN_GEOCODE_TRANSMIT_STG geot
             ON geot.person_id = per.person_id
          LEFT OUTER JOIN ADR.CCN_PHONE_STG ph
             ON ph.person_id = per.person_id
          LEFT OUTER JOIN ADR.CCN_SERVLOG_STG sl
             ON sl.person_id || '' = per.person_id;


CREATE OR REPLACE PUBLIC SYNONYM CCN_SERVICE_LOG_LOAD_VW FOR ADR.CCN_SERVICE_LOG_LOAD_VW;


GRANT SELECT ON ADR.CCN_SERVICE_LOG_LOAD_VW TO ADR_R;

GRANT INSERT, SELECT ON ADR.CCN_SERVICE_LOG_LOAD_VW TO ADR_RW;
