DROP FUNCTION ADR.APPOINTMENTREQ_LOAD_PTF_SF;

CREATE OR REPLACE FUNCTION ADR.APPOINTMENTREQ_LOAD_PTF_SF (process_type_i IN NUMBER, dataset_in ADR.APPTREQ_REFCUR_PKG.APPTREQ_SRC_REFCUR)
   RETURN ADR.APPT_REQ_TGT_TAB
    PARALLEL_ENABLE(PARTITION dataset_in BY HASH (person_id)) PIPELINED
IS
   TYPE APPOINTMENT_REQ_SRC_TAB IS TABLE OF ADR.APPOINTMENT_REQUEST_LOAD1_VW%ROWTYPE
      INDEX BY PLS_INTEGER;
    appt_req_src_table   APPOINTMENT_REQ_SRC_TAB;

TYPE APPOINTMENT_REQ_SRC2_TAB IS TABLE OF ADR.APPOINTMENT_REQUEST_LOAD2_VW%ROWTYPE
      INDEX BY PLS_INTEGER;
    appt_req_src2_table   APPOINTMENT_REQ_SRC2_TAB;

BEGIN
    IF process_type_i = 1 THEN
        -- Process data for case 1 dataset
        LOOP

        FETCH dataset_in BULK COLLECT INTO appt_req_src_table;
        EXIT WHEN appt_req_src_table.COUNT = 0;

        FOR I IN 1 .. appt_req_src_table.COUNT
            LOOP
            PIPE ROW (ADR.APPT_REQ_TGT_REC(
                appt_req_src_table(I).appointment_request_h_id,
                appt_req_src_table(I).appointment_request_id,
                appt_req_src_table(I).person_id,
                appt_req_src_table(I).transaction_type_code,
                appt_req_src_table(I).response,
                appt_req_src_table(I).orig_response,
                appt_req_src_table(I).response_date,
                appt_req_src_table(I).orig_response_date,
                appt_req_src_table(I).response_chg_date,
                appt_req_src_table(I).orig_response_chg_date,
                appt_req_src_table(I).record_created_by,
                appt_req_src_table(I).record_created_date,
                appt_req_src_table(I).record_modified_by,
                appt_req_src_table(I).record_modified_date,
                appt_req_src_table(I).record_modified_count
                )  );

            END LOOP;
        END LOOP;

        RETURN;

    -- Process data for case 2 dataset
    ELSIF process_type_i = 2 THEN
        LOOP
        FETCH dataset_in BULK COLLECT INTO appt_req_src2_table;
        EXIT WHEN appt_req_src2_table.COUNT = 0;

        FOR I IN 1 .. appt_req_src2_table.COUNT
            LOOP
            PIPE ROW (ADR.APPT_REQ_TGT_REC(
                appt_req_src2_table(I).appointment_request_h_id,
                appt_req_src2_table(I).appointment_request_id,
                appt_req_src2_table(I).person_id,
                appt_req_src2_table(I).transaction_type_code,
                appt_req_src2_table(I).response,
                appt_req_src2_table(I).orig_response,
                appt_req_src2_table(I).response_date,
                appt_req_src2_table(I).orig_response_date,
                appt_req_src2_table(I).response_chg_date,
                appt_req_src2_table(I).orig_response_chg_date,
                appt_req_src2_table(I).record_created_by,
                appt_req_src2_table(I).record_created_date,
                appt_req_src2_table(I).record_modified_by,
                appt_req_src2_table(I).record_modified_date,
                appt_req_src2_table(I).record_modified_count
                )  );

            END LOOP;
        END LOOP;

   RETURN;

   END IF;

END;
/


CREATE OR REPLACE PUBLIC SYNONYM APPOINTMENTREQ_LOAD_PTF_SF FOR ADR.APPOINTMENTREQ_LOAD_PTF_SF;
