unit uRegExPatternMatch;

interface

uses
  RegularExpressions;

type
  TPatternMatchType = (tpmEMail, tpmIPAddress, tpmDateFormatA, tpmDateFormatB);

const
  PATTERN_MATCH_NAME: array [TPatternMatchType] of string = (
    'E-Mail',
    'IP-Address',
    'Date Format A - mm-dd-yyyy',
    'Date Format B - dd-mm-yyyy');

function IsPatternMatch(aString: string; aPatternMatchType: TPatternMatchType): boolean;

implementation

const
  REGEX_EMAIL =
    '^((?>[a-zA-Z\d!#$%&''*+\-/=?^_`{|}~]+\x20*' +
    '|"((?=[\x01-\x7f])[^"\\]|\\[\x01-\x7f])*"\' +
    'x20*)*(?<angle><))?((?!\.)(?>\.?[a-zA-Z\d!' +
    '#$%&''*+\-/=?^_`{|}~]+)+|"((?=[\x01-\x7f])' +
    '[^"\\]|\\[\x01-\x7f])*")@(((?!-)[a-zA-Z\d\' +
    '-]+(?<!-)\.)+[a-zA-Z]{2,}|\[(((?(?<!\[)\.)' +
    '(25[0-5]|2[0-4]\d|[01]?\d?\d)){4}|[a-zA-Z\' +
    'd\-]*[a-zA-Z\d]:((?=[\x01-\x7f])[^\\\[\]]|' +
    '\\[\x01-\x7f])+)\])(?(angle)>)$';

  REGEX_IP =
    '\b(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\' +
    '.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.' +
    '(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.' +
    '(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\b';

  REGEX_DATE_FORMAT_A =
    '^(0[1-9]|1[012])[- /.](0[1-9]|[12][0-9]|3[' +
    '01])[- /.](19|20)\d\d$';

  REGEX_DATE_FORMAT_B =
    '^(0[1-9]|[12][0-9]|3[01])[- /.](0[1-9]|1[01' +
    '2])[- /.](19|20)\d\d$';

function IsPatternMatch(aString: string; aPatternMatchType: TPatternMatchType): boolean;
begin
  try
    case aPatternMatchType of
      tpmEMail:
        Result := TRegEx.IsMatch(aString, REGEX_EMAIL);
      tpmIPAddress:
        Result := TRegEx.IsMatch(aString, REGEX_IP);
      tpmDateFormatA:
        Result := TRegEx.IsMatch(aString, REGEX_DATE_FORMAT_A);
      tpmDateFormatB:
        Result := TRegEx.IsMatch(aString, REGEX_DATE_FORMAT_B);
    else
      Result := False;
    end;
  except
    Result := False; // No false positives allowed!
  end;
end;

end.
