unit oPCSPrescriber;

interface

uses
  System.Classes,
  System.SysUtils;

type
  TPCSPrescriber = class(TObject)
    private
      FIEN: string;

      FDetoxNumber: string;
      FDEA: string;
      FVANumber: string;
      FSubjectAlternateName: string;

      FAllowScheduleVNarc: boolean;
      FAllowScheduleIVNarc: boolean;
      FAuthorizedToWrite: boolean;
      FAllowScheduleIINarc: boolean;
      FAllowScheduleIIINarc: boolean;
      FAllowScheduleIINonNarc: boolean;
      FAllowScheduleIIINonNarc: boolean;

      FUseForInpatient: boolean;

      FDEAExpirationDate: string;

      function getIENS: string;

      procedure SetAllowScheduleIIINarc(const Value: boolean);
      procedure SetAllowScheduleIIINonNarc(const Value: boolean);
      procedure SetAllowScheduleIINarc(const Value: boolean);
      procedure SetAllowScheduleIINonNarc(const Value: boolean);
      procedure SetAllowScheduleIVNarc(const Value: boolean);
      procedure SetAllowScheduleVNarc(const Value: boolean);
      procedure SetUseForInpatient(const Value: boolean);
      procedure SetAuthorizedToWrite(const Value: boolean);
      procedure SetDEA(const Value: string);
      procedure SetDEAExpirationDate(const Value: string);
      procedure SetDetoxNumber(const Value: string);
      procedure SetSubjectAlternateName(const Value: string);
      procedure SetVANumber(const Value: string);
    public
      constructor Create(aIEN: string);
      destructor Destroy; override;

      function ToString: string; override;

      property IEN: string read FIEN;
      property IENS: string read getIENS;
      property AuthorizedToWrite: boolean read FAuthorizedToWrite write SetAuthorizedToWrite;
      property SubjectAlternateName: string read FSubjectAlternateName write SetSubjectAlternateName;
      property DEA: string read FDEA write SetDEA;
      property VANumber: string read FVANumber write SetVANumber;
      property DetoxNumber: string read FDetoxNumber write SetDetoxNumber;
      property DEAExpirationDate: string read FDEAExpirationDate write SetDEAExpirationDate;
      property AllowScheduleIINarc: boolean read FAllowScheduleIINarc write SetAllowScheduleIINarc;
      property AllowScheduleIINonNarc: boolean read FAllowScheduleIINonNarc write SetAllowScheduleIINonNarc;
      property AllowScheduleIIINarc: boolean read FAllowScheduleIIINarc write SetAllowScheduleIIINarc;
      property AllowScheduleIIINonNarc: boolean read FAllowScheduleIIINonNarc write SetAllowScheduleIIINonNarc;
      property AllowScheduleIVNarc: boolean read FAllowScheduleIVNarc write SetAllowScheduleIVNarc;
      property AllowScheduleVNarc: boolean read FAllowScheduleVNarc write SetAllowScheduleVNarc;

      property UseForInpatient: boolean read FUseForInpatient write SetUseForInpatient;

  end;

implementation

{ TPCSPrescriber }

constructor TPCSPrescriber.Create(aIEN: string);
begin
  inherited Create;
  FIEN := aIEN;
end;

destructor TPCSPrescriber.Destroy;
begin
  inherited;
end;

function TPCSPrescriber.getIENS: string;
begin
  Result := Format('%s,', [FIEN]);
end;

procedure TPCSPrescriber.SetAllowScheduleIIINarc(const Value: boolean);
begin
  FAllowScheduleIIINarc := Value;
end;

procedure TPCSPrescriber.SetAllowScheduleIIINonNarc(const Value: boolean);
begin
  FAllowScheduleIIINonNarc := Value;
end;

procedure TPCSPrescriber.SetAllowScheduleIINarc(const Value: boolean);
begin
  FAllowScheduleIINarc := Value;
end;

procedure TPCSPrescriber.SetAllowScheduleIINonNarc(const Value: boolean);
begin
  FAllowScheduleIINonNarc := Value;
end;

procedure TPCSPrescriber.SetAllowScheduleIVNarc(const Value: boolean);
begin
  FAllowScheduleIVNarc := Value;
end;

procedure TPCSPrescriber.SetAllowScheduleVNarc(const Value: boolean);
begin
  FAllowScheduleVNarc := Value;
end;

procedure TPCSPrescriber.SetUseForInpatient(const Value: boolean);
begin
  FUseForInpatient := Value;
end;

procedure TPCSPrescriber.SetAuthorizedToWrite(const Value: boolean);
begin
  FAuthorizedToWrite := Value;
end;

procedure TPCSPrescriber.SetDEA(const Value: string);
begin
  FDEA := Value;
end;

procedure TPCSPrescriber.SetDEAExpirationDate(const Value: string);
begin
  FDEAExpirationDate := Value;
end;

procedure TPCSPrescriber.SetDetoxNumber(const Value: string);
begin
  FDetoxNumber := Value;
end;

procedure TPCSPrescriber.SetSubjectAlternateName(const Value: string);
begin
  FSubjectAlternateName := Value;
end;

procedure TPCSPrescriber.SetVANumber(const Value: string);
begin
  FVANumber := Value;
end;

function TPCSPrescriber.ToString: string;
begin
  with TStringList.Create do
    try
      Add(inherited ToString);
      Add(Format('%s: %s', ['Authorized To Write Orders', BoolToStr(FAuthorizedToWrite, True)]));
      Add(Format('%s: %s', ['Subject Altername Name (SAN)', FSubjectAlternateName]));
      Add(Format('%s: %s', ['DEA', FDEA]));
      Add(Format('%s: %s', ['VA #', FVANumber]));
      Add(Format('%s: %s', ['Detox #', FDetoxNumber]));
      Add(Format('%s: %s', ['DEA Expiration Date', FDEAExpirationDate]));
      Add(Format('%s: %s', ['Authorized for Schedule II Narcotic', BoolToStr(FAllowScheduleIINarc, True)]));
      Add(Format('%s: %s', ['Authorized for Schedule II Non-Narcotic', BoolToStr(FAllowScheduleIINonNarc, True)]));
      Add(Format('%s: %s', ['Authorized for Schedule III Narcotic', BoolToStr(FAllowScheduleIIINarc, True)]));
      Add(Format('%s: %s', ['Authorized for Schedule III Non-Narcotic', BoolToStr(FAllowScheduleIIINonNarc, True)]));
      Add(Format('%s: %s', ['Authorized for Schedule IV Narcotic', BoolToStr(FAllowScheduleIVNarc, True)]));
      Add(Format('%s: %s', ['Authorized for Schedule V Narcotic', BoolToStr(FAllowScheduleVNarc, True)]));
      Result := Text;
    finally
      Free;
    end;
end;

end.
