unit fMain;

interface

uses
  System.Variants,
  System.Character,
  System.Classes,
  System.SysUtils,
  System.Actions,
  System.StrUtils,
  System.UITypes,
  Vcl.Graphics,
  Vcl.Controls,
  Vcl.Forms,
  Vcl.Dialogs,
  Vcl.StdCtrls,
  Vcl.ExtCtrls,
  Vcl.ComCtrls,
  Vcl.Menus,
  Vcl.ActnList,
  Winapi.Messages,
  Winapi.Windows,
  Diaccess,
  Fmcntrls,
  Fmcmpnts,
  FmlookupPlus,
  Trpcb,
  oPCSPrescriber, Vcl.StdActns, File200;

type
  TfrmMain = class(TForm)
    pnlTop: TPanel;
    pnlMain: TPanel;
    edtServer: TEdit;
    edtFacilityDEANum: TEdit;
    edtPort: TEdit;
    lblServer: TLabel;
    lblPortNumber: TLabel;
    lblDeaExpirationDate: TLabel;
    lblDEANumber: TLabel;
    lblDetoxMaintNumber: TLabel;
    lblVANumber: TLabel;
    lblSANExample: TLabel;
    lblFacilityDEANumber: TLabel;
    lblAccessCode: TLabel;
    lblVerifyCode: TLabel;
    lblDisUsered: TLabel;
    lblTerminationDate: TLabel;
    lblSchedules: TLabel;
    btnGetServerInfo: TButton;
    btnConnect: TButton;
    btnExit: TButton;
    btnSelectPrescriber: TButton;
    btnUpdate: TButton;
    fmFinderPrescriber: TFMFinder;
    fmListerNewPersonDivision: TFMLister;
    fmGetsPrescriber: TFMGets;
    fmGetsActiveUser: TFMGets;
    fmFiler: TFMFiler;
    fmValidator: TFMValidator;
    fmListerNewPerson: TFMLister;
    fmlblSubjectAlternativeName: TFMLabel;
    fmedtAltName: TFMEdit;
    fmedtAccessCode: TFMEdit;
    fmedtVerifyCode: TFMEdit;
    fmedtDISUSERed: TFMEdit;
    fmedtTerminationDate: TFMEdit;
    fmedtVANumber: TFMEdit;
    fmedtProviderName: TFMEdit;
    fmedtDetoxMaintNumber: TFMEdit;
    fmedtDeaExpirationDate: TFMEdit;
    fmcbxScheduleV: TFMCheckBox;
    fmcbxScheduleIV: TFMCheckBox;
    fmcbxScheduleIINonNarcotic: TFMCheckBox;
    fmcbxScheduleIINarcotic: TFMCheckBox;
    fmcbxScheduleIIINonNarcotic: TFMCheckBox;
    fmcbxScheduleIIINarcotic: TFMCheckBox;
    fmcbxAuthorizedToWriteOrders: TFMCheckBox;
    RPCBroker: TRPCBroker;
    mmMain: TMainMenu;
    mmMainFile: TMenuItem;
    mmMainFileExit: TMenuItem;
    mmMainHelp: TMenuItem;
    mmMainHelpAbout: TMenuItem;
    memUtility: TMemo;
    acList: TActionList;
    acAbout: TAction;
    acConnectDisconnect: TAction;
    acGetServerInfo: TAction;
    acExit: TAction;
    acSelectPrescriber: TAction;
    acClearMainPanel: TAction;
    acUpdate: TAction;
    acAllSchedules: TAction;
    bvlControlPanel: TBevel;
    bvlSchedules: TBevel;
    cbxAllSchedules: TCheckBox;
    cboDeaNumber: TComboBox;
    fmcbxUseInpatient: TFMCheckBox;
    fmedtDeaNumber: TFMEdit;
    lblCurrenDEA: TLabel;
    fmValidator8991: TFMValidator;
    fmFiler8991: TFMFiler;
    fmGetsPrescriber8991: TFMGets;
    Label1: TLabel;
    pnlDOJ1: TPanel;
    lblDOJ1: TLabel;
    lblDetoxMaintNumberDOJ: TLabel;
    lblDeaExpirationDateDOJ: TLabel;
    Panel1: TPanel;
    lblDOJ2: TLabel;
    chkScheduleIINarcoticDOJ: TCheckBox;
    chkScheduleIINonNarcoticDOJ: TCheckBox;
    chkScheduleIIINarcoticDOJ: TCheckBox;
    chkScheduleIIINonNarcoticDOJ: TCheckBox;
    chkScheduleIVDOJ: TCheckBox;
    chkScheduleVDOJ: TCheckBox;
    btnCopy: TButton;
    btnRemove: TButton;
    lblInpatientWarning: TLabel;
    EditDelete1: TEditDelete;
    lblProviderNameDOJ: TLabel;
    btnAdd: TButton;
    lblDEASuffix: TLabel;
    edtDEASuffix: TEdit;
    btnEdit: TButton;
    fmlblProviderType: TFMLabel;

    procedure FormCreate(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);

    procedure acConnectDisconnectExecute(Sender: TObject);
    procedure acAboutExecute(Sender: TObject);
    procedure acGetServerInfoExecute(Sender: TObject);
    procedure acExitExecute(Sender: TObject);
    procedure acSelectPrescriberExecute(Sender: TObject);
    procedure acClearMainPanelExecute(Sender: TObject);
    procedure acUpdateExecute(Sender: TObject);
    procedure acAllSchedulesExecute(Sender: TObject);

    procedure fmedtAltNameExit(Sender: TObject);
    procedure fmcbxScheduleClick(Sender: TObject);
    procedure cboDeaNumberChange(Sender: TObject);
    procedure fmcbxUseInpatientClick(Sender: TObject);
    procedure btnRemoveClick(Sender: TObject);
    procedure btnCopyClick(Sender: TObject);
    procedure btnAddClick(Sender: TObject);
    procedure UpperCaseChange(Sender: TObject);

    procedure CheckDetoxNumber(Sender: TObject; var Key: Word;
      Shift: TShiftState);

    procedure btnEditClick(Sender: TObject);
  private
    fCurrentPrescriber: TPCSPrescriber;
    foPrescriberDEAList: TStringList;
    flValidateOnClickUseInpatientOrder: Boolean;
    fcCopyDOJInformation: String;

    procedure CheckInpatientWarning();
    procedure updateControlsOnSelect(tlAddRequest: Boolean; tnIndex: Integer);
    function getCurrentInformation(tnIndex: Integer; tnConst: Integer): string;
    function FMDateTime2TDateTime(aValue: string): TDateTime;
    function IsActiveUser: Boolean;
    function HoldsVistAKey(AKeyName: string): Boolean;
    function DisplayWarning: Boolean;
    function EditVANumber: Boolean;

    function GetFacilityVANum(IENS: string): string;
    function GetValueFromVistA(InputStr: string): string;

    procedure ApplicationException(Sender: TObject; E: Exception);
    procedure InitializeData(aPCSPrescriber: TPCSPrescriber; tcDUZ: string);
    procedure UpdateDEAList(tcDUZ: String);
    procedure UpdateDEAComboBox(tcDUZ: String);
    procedure UpdateRCPVariables();
    procedure UpdateDOJControls(tlAddRequest: Boolean; tcDEA: String;
      var tcInfo: String; var tcError: String);
    function DeciphorDOJ(tcDOJ: String; tnConst: Integer): string;
    function BuildDOJAddress(tcDOJ: String): string;
    procedure BlankDOJFields();

    procedure setEnable(toEdit: TEdit; tlEnable: Boolean);
    function GetLastName(tcName: String): String;
    function CheckDEADuplicates(): Boolean;
    function BuildAddString(): String;
    function DeciphorCheckBox(toCheckBox: TCheckBox): String;
    function CountValidDEANumbers(): Integer;
    function CheckDEAFormat(tcDEA: String): Boolean;
  end;

const
  CRLF = #13 + #10;

  ADD_DEA = '<Add new DEA #>';
  DEA = 1;
  SUFFIX = 2;
  STATE = 3;
  DETOX = 4;
  EXPIRATION = 5;
  NPIENS = 6;
  DNIENS = 7; // IENS number to use
  SCHEDULE_II_NARCOTIC = 8;
  SCHEDULE_II_NON_NARCOTIC = 9;
  SCHEDULE_III_NARCOTIC = 10;
  SCHEDULE_III_NON_NARCOTIC = 11;
  SCHEDULE_IV = 12;
  SCHEDULE_V = 13;
  INPATIENT = 14;

  DOJ_PROVIDER_NAME = 1;
  DOJ_ADDRESS1 = 2;
  DOJ_ADDRESS2 = 3;
  DOJ_ADDRESS3 = 4;
  DOJ_CITY = 5;
  DOJ_STATE = 6;
  DOJ_STATE_POINTER = 7;
  DOJ_ZIP_CODE = 8;
  DOJ_ACTIVITY_CODE = 9;
  DOJ_TYPE = 10;
  DOJ_DEA_NUMBER = 11;
  DOJ_EXPIRATION_DATE = 12;
  DOJ_PROCESSED_DATE = 13;
  DOJ_DETOX_NUMBER = 14;
  DOJ_SCHDEULE_II_NARCOTIC = 15;
  DOJ_SCHEDULE_II_NON_NARCOTIC = 16;
  DOJ_SCHEDULE_III_NARCOTIC = 17;
  DOJ_SCHEDULE_III_NON_NARCOTIC = 18;
  DOJ_SCHEDULE_IV = 19;
  DOJ_SCHEDULE_V = 20;

  DOJ_EMPTY = '<empty>';
  DOJ_INSTITUTION = 'INSTITUTIONAL';

  DEA_SUFFIX_MIN = 3;
  DEA_SUFFIX_MAX = 10;

  // From the help documentation on IENS.
  IENS_ADD = '+1';

  PROVIDER_TYPES = ',FULL TIME,PART TIME,C & A,FEE BASIS,HOUSE STAFF,';
  PROVIDER_TYPES_VA = ',FULL TIME,PART TIME,HOUSE STAFF,';

var
  frmMain: TfrmMain;
  fmlkupPrescriber: TFMLookUpPlus;

implementation

uses
  VAUtils,
  fWarning,
  fVistAAbout,
  RpcConf1,
  MFunStr,
  oPKIEncryption;

{$R *.dfm}

procedure TfrmMain.FormCreate(Sender: TObject);
var
  i: Integer;
begin
  flValidateOnClickUseInpatientOrder := False;

  Font := Screen.IconFont;
  for i := 0 to ParamCount do
    if (Pos('P=', UpperCase(ParamStr(i))) = 1) then
      edtPort.Text := Copy(ParamStr(i), 3, Length(ParamStr(i)))
    else if (Pos('S=', UpperCase(ParamStr(i))) = 1) then
      edtServer.Text := Copy(ParamStr(i), 3, Length(ParamStr(i)));

  Self.ShowHint := True;
  Application.OnException := ApplicationException;
  Application.ShowHint := True;
  pnlTop.DoubleBuffered := True;
  pnlMain.DoubleBuffered := True;
  acClearMainPanel.Execute;

  fmlkupPrescriber := TFMLookUpPlus.Create(frmMain);
  fmlkupPrescriber.FMLister := fmListerNewPerson;
  fmlkupPrescriber.HelpContext := 0;

end;

procedure TfrmMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
var
  lcMessage: String;
begin
  if (lblInpatientWarning.Visible) then
  begin
    lcMessage := Trim(lblInpatientWarning.Caption);

    ShowMsg(lcMessage, smiError, smbOK);
    CanClose := False;
  end
  else
  begin
    FreeAndNil(fCurrentPrescriber);
    CanClose := True;
  end;
end;

procedure TfrmMain.acAboutExecute(Sender: TObject);
begin
  TfrmVistAAbout.Execute;
end;

procedure TfrmMain.acAllSchedulesExecute(Sender: TObject);

  procedure DoCheck(aFMcbx: TFMCheckBox);
  begin
    if not aFMcbx.Checked then
    begin
      aFMcbx.Checked := True;
      aFMcbx.AutoValidate;
    end;
  end;

begin
  // Send these items thru the above method so we don't over check and uncheck them
  if cbxAllSchedules.Checked then
  begin
    DoCheck(fmcbxScheduleV);
    DoCheck(fmcbxScheduleIV);
    DoCheck(fmcbxScheduleIINonNarcotic);
    DoCheck(fmcbxScheduleIINarcotic);
    DoCheck(fmcbxScheduleIIINonNarcotic);
    DoCheck(fmcbxScheduleIIINarcotic);
  end;
end;

procedure TfrmMain.acClearMainPanelExecute(Sender: TObject);
var
  i: Integer;
  CurrObject: TControl;
begin
  for i := 0 to pnlMain.ControlCount - 1 do
  begin
    CurrObject := pnlMain.Controls[i];
    if CurrObject is TFMCheckBox then
      TFMCheckBox(CurrObject).Checked := False
    else if CurrObject is TFMEdit then
      TFMEdit(CurrObject).Text := '';

    // If no prescriber or Broker connection, disable the control as well
    if (CurrObject is TControl) then
    begin
      TControl(CurrObject).Enabled :=
        (Assigned(fCurrentPrescriber) and RPCBroker.Connected);
    end;
  end;

  // Always gets cleared manually here, not FM Components
  edtFacilityDEANum.Text := '';

  // Enabled depends on Broker Status
  acSelectPrescriber.Enabled := RPCBroker.Connected;
  btnSelectPrescriber.Enabled := RPCBroker.Connected;
end;

procedure TfrmMain.acConnectDisconnectExecute(Sender: TObject);
var
  aPKIEncryptionEngine: IPKIEncryptionEngine;
  aMessage: string;
begin
  if RPCBroker.Connected then
  begin
    RPCBroker.Connected := False;
    FreeAndNil(fCurrentPrescriber);
    acClearMainPanel.Execute;
    acConnectDisconnect.Caption := '&Connect';
    Exit;
  end;

  if ((edtServer.Text = '') or (edtPort.Text = '')) then
  begin
    ShowMsg('Please select a Server and Port combination before trying to connect.',
      'Information', smiInfo, smbOK);
    Exit;
  end;

  try
    RPCBroker.Server := edtServer.Text;
    RPCBroker.ListenerPort := StrToInt(edtPort.Text);

    RPCBroker.ClearParameters := True;
    RPCBroker.Connected := True;

    if (not RPCBroker.Connected) then
      raise EPKIEncryptionError.Create(DLG_89802042);

    if ((Trim(RPCBroker.SSOiSECID) = '') Or
      (Trim(RPCBroker.SSOiLogonName) = '')) Then
      raise EPKIEncryptionError.Create
        ('This application requires 2 Factor Authentication. You must login using PIV card.'
        + CRLF + CRLF + 'SSOiSECID: ' + RPCBroker.SSOiSECID + CRLF +
        'SSOiLogonName: ' + RPCBroker.SSOiLogonName);

    if not RPCBroker.CreateContext('PSO DEA EDIT DATA') then
      raise EPKIEncryptionError.Create(DLG_89802043);

    if HoldsVistAKey('ORES') then
      raise EPKIEncryptionError.Create(DLG_89802044);

    if (not HoldsVistAKey('XUEPCSEDIT')) then
      raise EPKIEncryptionError.Create(DLG_89802045);

    NewPKIEncryptionEngine(RPCBroker, aPKIEncryptionEngine);

    if not IsDigitalSignatureAvailable(aPKIEncryptionEngine, aMessage) then
      raise Exception.Create(aMessage)
    else if VerifyPKIPin(aPKIEncryptionEngine) <> prOK then
      raise EPKIEncryptionError.Create(DLG_89802009);

    // We are connected and ready to run the app
    acConnectDisconnect.Caption := '&Disconnect';
    fmValidator.IENS := '';
    fmValidator8991.IENS := '';
    FreeAndNil(fCurrentPrescriber);
    acClearMainPanel.Execute;
  except
    on E: Exception do
    begin
      RPCBroker.Connected := False;
      ShowMsg('Error: ' + E.Message, 'Error', smiError, smbOK);
      fmValidator.IENS := '';
      fmValidator8991.IENS := '';
      FreeAndNil(fCurrentPrescriber);
      acClearMainPanel.Execute;
      acConnectDisconnect.Caption := '&Connect';
    end;
  end;
end;

procedure TfrmMain.acExitExecute(Sender: TObject);
begin
  Close;
end;

procedure TfrmMain.acGetServerInfoExecute(Sender: TObject);
var
  aServer: string;
  aPort: string;
begin
  if GetServerInfo(aServer, aPort) <> MrCancel then
  begin
    edtServer.Text := aServer;
    edtPort.Text := aPort;
  end;
end;

procedure TfrmMain.acSelectPrescriberExecute(Sender: TObject);
var
  AddRecord: Boolean;
begin
  flValidateOnClickUseInpatientOrder := False;

  FreeAndNil(fCurrentPrescriber);
  fmValidator.IENS := '';
  BlankDOJFields();
  edtDEASuffix.Text := '';
  cboDeaNumber.Items.Clear;

  acClearMainPanel.Execute;
  fmlkupPrescriber.AllowNew := False;

  if fmlkupPrescriber.Execute(AddRecord) then
    try
      fCurrentPrescriber := TPCSPrescriber.Create
        (fmlkupPrescriber.RecordNumber);

      setEnable(edtFacilityDEANum, False);
      setEnable(fmedtVANumber, False);

      fmGetsActiveUser.IENS := fCurrentPrescriber.IENS;
      fmGetsActiveUser.GetandFill; // I think the issue happens in here!

      if IsActiveUser then
      begin
        acClearMainPanel.Execute;
        InitializeData(fCurrentPrescriber, fmlkupPrescriber.RecordNumber);
        fmValidator.IENS := fCurrentPrescriber.IENS;

        flValidateOnClickUseInpatientOrder := True;
        btnEdit.Enabled := EditVANumber;
      end
      else
      begin
        FreeAndNil(fCurrentPrescriber);
        fmValidator.IENS := '';
      end;
    except
      on E: Exception do
      begin
        ShowMsg(E.Message, 'Error Loading Record.', smiError, smbOK);
        FreeAndNil(fCurrentPrescriber);
        fmValidator.IENS := '';
        acClearMainPanel.Execute;
      end;
    end
  else
    ShowMsg('No record selected.', 'Information', smiInfo, smbOK);
end;

procedure TfrmMain.acUpdateExecute(Sender: TObject);
var
  i: Integer;
  aChangeList: TStringList;
  lcCurrentDEA: string;

  procedure AddTextChange(fmedt: TFMEdit; aOriginalValue: string;
    tcCurrentDEA: string);
  begin
    if (AnsiCompareStr(fmedt.FMCtrlInternal, aOriginalValue) <> 0) then
    begin
      aChangeList.Add(Format('`%s^`%s^%s^%s^%s^%s', [fCurrentPrescriber.IEN,
        RPCBroker.User.DUZ, fmedt.FMField, aOriginalValue, fmedt.FMCtrlInternal,
        tcCurrentDEA]));

      OutputDebugString(Pchar(Format('`%s^`%s^%s^%s^%s^%s',
        [fCurrentPrescriber.IEN, RPCBroker.User.DUZ, fmedt.FMField,
        aOriginalValue, fmedt.FMCtrlInternal, tcCurrentDEA]) + chr(13) +
        chr(10)));
    end;

  end;

  procedure AddBooleanChange(fmcbx: TFMCheckBox; aOriginalValue: Boolean;
    tcCurrentDEA: string);
  begin
    if not(fmcbx.Checked = aOriginalValue) then
    begin
      aChangeList.Add(Format('`%s^`%s^%s^%s^%s^%s', [fCurrentPrescriber.IEN,
        RPCBroker.User.DUZ, fmcbx.FMField, BoolToStr(aOriginalValue, True),
        BoolToStr(fmcbx.Checked, True), tcCurrentDEA]));

      OutputDebugString(Pchar(Format('`%s^`%s^%s^%s^%s^%s',
        [fCurrentPrescriber.IEN, RPCBroker.User.DUZ, fmcbx.FMField,
        BoolToStr(aOriginalValue, True), BoolToStr(fmcbx.Checked, True),
        tcCurrentDEA]) + chr(13) + chr(10)));
    end;
  end;

begin

  lcCurrentDEA := getCurrentInformation(cboDeaNumber.ItemIndex, DEA);
  if (lcCurrentDEA = '') then
  begin
    ShowMsg(ADD_DEA + ' is currently selected.', 'Error', smiError, smbOK);
    Exit;
  end;

  // Build list of before and after for changed values
  try
    aChangeList := TStringList.Create;
    AddTextChange(fmedtAltName, fCurrentPrescriber.SubjectAlternateName,
      lcCurrentDEA);

    AddTextChange(fmedtDeaNumber, fCurrentPrescriber.DEA, lcCurrentDEA);

    AddTextChange(fmedtVANumber, fCurrentPrescriber.VANumber, lcCurrentDEA);
    AddTextChange(fmedtDetoxMaintNumber, fCurrentPrescriber.DetoxNumber,
      lcCurrentDEA);
    AddTextChange(fmedtDeaExpirationDate, fCurrentPrescriber.DEAExpirationDate,
      lcCurrentDEA);

    AddBooleanChange(fmcbxAuthorizedToWriteOrders,
      fCurrentPrescriber.AuthorizedToWrite, lcCurrentDEA);
    AddBooleanChange(fmcbxScheduleV, fCurrentPrescriber.AllowScheduleVNarc,
      lcCurrentDEA);
    AddBooleanChange(fmcbxScheduleIV, fCurrentPrescriber.AllowScheduleIVNarc,
      lcCurrentDEA);
    AddBooleanChange(fmcbxScheduleIINonNarcotic,
      fCurrentPrescriber.AllowScheduleIINonNarc, lcCurrentDEA);
    AddBooleanChange(fmcbxScheduleIINarcotic,
      fCurrentPrescriber.AllowScheduleIINarc, lcCurrentDEA);
    AddBooleanChange(fmcbxScheduleIIINonNarcotic,
      fCurrentPrescriber.AllowScheduleIIINonNarc, lcCurrentDEA);
    AddBooleanChange(fmcbxScheduleIIINarcotic,
      fCurrentPrescriber.AllowScheduleIIINarc, lcCurrentDEA);

    AddBooleanChange(fmcbxUseInpatient, fCurrentPrescriber.UseForInpatient,
      lcCurrentDEA);

    if aChangeList.Count > 0 then
      try
        fmFiler.Update;
        fmFiler8991.Update;

        with RPCBroker do
        begin
          RemoteProcedure := 'PSO DEA EDIT';
          Param[0].PType := list;
          for i := 0 to aChangeList.Count - 1 do
            Param[0].Mult[IntToStr(i)] := aChangeList[i];
          Call;
        end;

        // Get a fresh copy of the data from the components
        InitializeData(fCurrentPrescriber, fmlkupPrescriber.RecordNumber);
        ShowMsg('Update Completed', 'Information', smiInfo, smbOK);
      except
        on E: Exception do
          ShowMsg('Error updating record: ' + E.Message, 'Error',
            smiError, smbOK);
      end
    else
      ShowMsg('No updates found', 'Information', smiInfo, smbOK);
  finally
    FreeAndNil(aChangeList);
  end;

  // Refresh the list.
  UpdateDEAList(fmlkupPrescriber.RecordNumber);
  UpdateDEAComboBox(fmlkupPrescriber.RecordNumber);

end;

procedure TfrmMain.ApplicationException(Sender: TObject; E: Exception);
begin
  ShowMsg(E.Message, 'Error', smiError, smbOK);
  Close;
end;

procedure TfrmMain.btnAddClick(Sender: TObject);
var
  lcAddString: String;
  lcResult: String;
  llOkay: Boolean;
  lcMessage: String;
begin
  if (Not CheckDEADuplicates) then
    Exit;

  lcAddString := BuildAddString();

  with RPCBroker do
    try
      RemoteProcedure := 'PSO DEA ADD DEA';

      Param[0].Value := lcAddString;
      Param[0].PType := Literal;
      Param[1].Value := Piece(fCurrentPrescriber.IENS, ',', 1);
      Param[1].PType := Literal;

      Call;
      lcResult := Results[0];

      llOkay := (Piece(lcResult, '^', 1) <> '0');
      if (llOkay) then
      begin
        llOkay := (Piece(lcResult, '^', 3) <> '0');
        if (Not llOkay) then
        begin
          lcMessage := Piece(lcResult, '^', 4);
        end;
      end
      else
      begin
        lcMessage := Piece(lcResult, '^', 2);
      end;

      if (llOkay) then
      begin
        ShowMsg('DEA # added and now selectable from the Prescriber DEA # dropdown list.',
          smiInfo, smbOK);
      end
      else
      begin
        ShowMsg('Unable to add this DEA #: ' + lcMessage, smiError, smbOK);
      end;

    except
      on loErr: Exception do
      begin
        ShowMsg('Error in with the RPC of PSO DEA ADD DEA: ' + loErr.Message,
          smiError, smbOK);
      end;

    end;

  // Refresh the list.
  UpdateDEAList(fmlkupPrescriber.RecordNumber);
  UpdateDEAComboBox(fmlkupPrescriber.RecordNumber);

end;

function TfrmMain.BuildAddString(): String;
var
  lcResult: string;
  lcDEA: String;
  lcSuffix: String;
begin

  lcResult := '';
  Result := lcResult;
  if (fcCopyDOJInformation = '') then
    Exit;

  lcResult := lcResult + DeciphorDOJ(fcCopyDOJInformation,
    DOJ_PROVIDER_NAME) + '^';

  lcResult := lcResult + DeciphorDOJ(fcCopyDOJInformation, DOJ_ADDRESS1) + '^';
  lcResult := lcResult + DeciphorDOJ(fcCopyDOJInformation, DOJ_ADDRESS2) + '^';
  lcResult := lcResult + DeciphorDOJ(fcCopyDOJInformation, DOJ_ADDRESS3) + '^';

  lcResult := lcResult + DeciphorDOJ(fcCopyDOJInformation, DOJ_CITY) + '^';
  lcResult := lcResult + DeciphorDOJ(fcCopyDOJInformation, DOJ_STATE) + '^';
  lcResult := lcResult + DeciphorDOJ(fcCopyDOJInformation,
    DOJ_STATE_POINTER) + '^';
  lcResult := lcResult + DeciphorDOJ(fcCopyDOJInformation, DOJ_ZIP_CODE) + '^';

  lcResult := lcResult + DeciphorDOJ(fcCopyDOJInformation,
    DOJ_ACTIVITY_CODE) + '^';
  lcResult := lcResult + DeciphorDOJ(fcCopyDOJInformation, DOJ_TYPE) + '^';

  lcDEA := Trim(fmedtDeaNumber.Text);
  // Do not append the suffix to the DEA variable.
  lcSuffix := Trim(edtDEASuffix.Text);

  lcResult := lcResult + lcDEA + '^';

  lcResult := lcResult + Trim(fmedtDeaExpirationDate.Text) + '^';

  lcResult := lcResult + DeciphorDOJ(fcCopyDOJInformation,
    DOJ_PROCESSED_DATE) + '^';

  lcResult := lcResult + Trim(fmedtDetoxMaintNumber.Text) + '^';

  lcResult := lcResult + DeciphorCheckBox(fmcbxScheduleIINarcotic) + '^';
  lcResult := lcResult + DeciphorCheckBox(fmcbxScheduleIINonNarcotic) + '^';
  lcResult := lcResult + DeciphorCheckBox(fmcbxScheduleIIINarcotic) + '^';
  lcResult := lcResult + DeciphorCheckBox(fmcbxScheduleIIINonNarcotic) + '^';
  lcResult := lcResult + DeciphorCheckBox(fmcbxScheduleIV) + '^';
  lcResult := lcResult + DeciphorCheckBox(fmcbxScheduleV) + '^';

  lcResult := lcResult + DeciphorCheckBox(fmcbxUseInpatient) + '^';

  lcResult := lcResult + Trim(edtDEASuffix.Text);

  Result := lcResult;

end;

function TfrmMain.DeciphorCheckBox(toCheckBox: TCheckBox): String;
begin
  if (toCheckBox.Checked) then
    Result := 'YES'
  else
    Result := 'NO';
end;

function TfrmMain.CheckDEADuplicates(): Boolean;
var
  lcDEA, lcSuffix, lcResult, lcFirst: String;
  lnLen: Integer;

begin
  Result := True;

  lcDEA := Trim(fmedtDeaNumber.Text);
  lcSuffix := Trim(edtDEASuffix.Text);

  if (edtDEASuffix.Enabled) then
  begin
    lnLen := Length(lcSuffix);
    if ((lnLen < DEA_SUFFIX_MIN) OR (lnLen > DEA_SUFFIX_MAX)) then
    begin
      ShowMsg('As this is an institutional DEA number, you must enter a unique '
        + lblDEASuffix.Caption + ' between ' + IntToStr(DEA_SUFFIX_MIN) +
        ' and ' + IntToStr(DEA_SUFFIX_MAX) + ' characters in length.',
        smiError, smbOK);

      Result := False;
      Exit;
    end;
  end;

  with RPCBroker do
    try
      RemoteProcedure := 'PSO DEA DUP CHECK';

      Param[0].Value := lcDEA;
      Param[0].PType := Literal;
      Param[1].Value := lcSuffix;
      Param[1].PType := Literal;

      Call;
      lcResult := Results[0];
      lcFirst := Piece(lcResult, '^', 1);

      Result := (lcFirst <> '0');
      if (Not Result) then
      begin
        ShowMsg(Piece(lcResult, '^', 2), smiError, smbOK);
      end;

    except
      on loErr: Exception do
      begin
        ShowMsg('Error in CheckDEADuplicates: ' + loErr.Message,
          smiError, smbOK);
        Result := False;
      end;

    end;

end;

procedure TfrmMain.btnCopyClick(Sender: TObject);
var
  lcDEA: String;
  lcCaption: String;
  lcProvider: String;
  lcDOJProvider: String;

  lcProviderLastName: String;
  lcDOJProviderLastName: String;
  lcError: String;

  lcInstitution: String;
  llInstitution: Boolean;
  lcMessage: String;
  llExit: Boolean;
begin

  lcDEA := Trim(fmedtDeaNumber.Text);
  if Not CheckDEAFormat(lcDEA) then
    Exit;

  UpdateDOJControls(False, lcDEA, fcCopyDOJInformation, lcError);
  lcProvider := Trim(fmedtProviderName.Text);
  lcDOJProvider := DeciphorDOJ(fcCopyDOJInformation, DOJ_PROVIDER_NAME);
  lcInstitution := UpperCase(Trim(DeciphorDOJ(fcCopyDOJInformation, DOJ_TYPE)));
  llInstitution := (lcInstitution = DOJ_INSTITUTION);

  lcProviderLastName := GetLastName(lcProvider);
  lcDOJProviderLastName := GetLastName(lcDOJProvider);

  llExit := False;

  if (lcDOJProvider = DOJ_EMPTY) then
  begin
    ShowMsg(lcDEA + ' is invalid. Please check the number entered:' + CRLF +
      CRLF + lcError, smiError, smbOK);
    llExit := True;
  end
  else if (llInstitution) then
  begin
    lcMessage := 'DOJ Name: ' + lcDOJProvider + CRLF + 'Vista Name: ' +
      lcProvider + CRLF + CRLF +
      'The names don''t match as this is an institutional DEA #.' + CRLF + CRLF
      + 'Do you really want to continue?';

    if (ShowMsg(lcMessage, smiQuestion, smbYesNo) <> smrYes) then
      llExit := True;
  end
  else if (lcDOJProviderLastName <> lcProviderLastName) then
  begin
    lcMessage := lcDEA + '  is associated with ' + lcDOJProvider +
      '. Last Names do not match.' + CRLF + CRLF + 'Do you wish to continue?';

    if (ShowMsg(lcMessage, smiQuestion, smbYesNo) <> smrYes) then
      llExit := True;
  end;

  if (llExit) then
  begin
    btnAdd.Enabled := False;
    edtDEASuffix.Enabled := False;
    BlankDOJFields;

    Exit;
  end;

  btnCopy.Enabled := False;
  btnAdd.Enabled := True;

  fmcbxUseInpatient.Enabled := Not llInstitution;
  // If a non-institutional DEA and the provider has no DEA # yet.
  fmcbxUseInpatient.Checked := ((fmcbxUseInpatient.Enabled) And
    (CountValidDEANumbers = 0));

  setEnable(edtDEASuffix, llInstitution);

  lcCaption := Trim(lblDetoxMaintNumberDOJ.Caption);
  if (lcCaption <> DOJ_EMPTY) then
    fmedtDetoxMaintNumber.Text := lcCaption;

  lcCaption := Trim(lblDeaExpirationDateDOJ.Caption);
  if (lcCaption <> DOJ_EMPTY) then
    fmedtDeaExpirationDate.Text := lcCaption;

  fmcbxScheduleV.Checked := chkScheduleVDOJ.Checked;
  fmcbxScheduleIV.Checked := chkScheduleIVDOJ.Checked;
  fmcbxScheduleIINonNarcotic.Checked := chkScheduleIINonNarcoticDOJ.Checked;
  fmcbxScheduleIINarcotic.Checked := chkScheduleIINarcoticDOJ.Checked;
  fmcbxScheduleIIINonNarcotic.Checked := chkScheduleIIINonNarcoticDOJ.Checked;
  fmcbxScheduleIIINarcotic.Checked := chkScheduleIIINarcoticDOJ.Checked;
end;

function TfrmMain.CheckDEAFormat(tcDEA: String): Boolean;
var
  i: Integer;
  c: Char;
  lcMessage: String;
begin
  lcMessage :=
    'Enter the DEA number in the format of 2 letters followed by 7 numbers.';

  if (Length(tcDEA) <> 9) then
  begin
    ShowMsg(lcMessage, smiError, smbOK);
    Result := False;
    Exit;
  end;

  for i := 1 to 2 do
  begin
    c := tcDEA[i];
    if Not(c.IsLetter) then
    begin
      ShowMsg(lcMessage, smiError, smbOK);
      Result := False;
      Exit;
    end;
  end;

  for i := 3 to 9 do
  begin
    c := tcDEA[i];
    if Not(c.IsDigit) then
    begin
      ShowMsg(lcMessage, smiError, smbOK);
      Result := False;
      Exit;
    end;
  end;

  Result := True;
end;

procedure TfrmMain.BlankDOJFields();
begin
  lblProviderNameDOJ.Caption := '';
  lblDetoxMaintNumberDOJ.Caption := '';
  lblDeaExpirationDateDOJ.Caption := '';
  chkScheduleIINarcoticDOJ.Checked := False;
  chkScheduleIINonNarcoticDOJ.Checked := False;
  chkScheduleIIINarcoticDOJ.Checked := False;
  chkScheduleIIINonNarcoticDOJ.Checked := False;
  chkScheduleIVDOJ.Checked := False;
  chkScheduleVDOJ.Checked := False;
end;

procedure TfrmMain.btnEditClick(Sender: TObject);
var
  loForm: TfrmFile200;
begin
  loForm := TfrmFile200.Create(frmMain, RPCBroker, fCurrentPrescriber,
    fmedtVANumber);
  loForm.ShowModal();

  FreeAndNil(loForm);
end;

// Assumes that the format is LastName, FirstName
function TfrmMain.GetLastName(tcName: String): String;
var
  lnPos: Integer;
begin
  Result := Trim(tcName);

  lnPos := Pos(',', tcName);
  if (lnPos > 1) then
    Result := Trim(Copy(tcName, 1, lnPos - 1));

end;

procedure TfrmMain.setEnable(toEdit: TEdit; tlEnable: Boolean);
begin
  if (tlEnable) then
  begin
    toEdit.Color := clWhite;
    toEdit.ReadOnly := False;
    toEdit.Enabled := True;
    toEdit.TabStop := True;
  end
  else
  begin
    toEdit.Color := cl3DLight;
    toEdit.ReadOnly := True;
    toEdit.Enabled := False;
    toEdit.TabStop := False;
  end;

end;

procedure TfrmMain.btnRemoveClick(Sender: TObject);
var
  lcResult, lcFirst: String;
  lcDEA, lcNPIENS: String;
  llSuccess: Boolean;
  lnIndex: Integer;
  lcDetox, lcDeleteMsg: String;
  lcVANumber: String;
begin

  lcDetox := Trim(fmedtDetoxMaintNumber.Text);
  if (lcDetox <> '') then
  begin
    lcDeleteMsg := 'This DEA # contains Detox # ' + lcDetox +
      '. To maintain the Detox #, please add it to another DEA # on the providers profile.'
      + CRLF + CRLF + 'Do you want to continue the deletion process?';

    if (ShowMsg(lcDeleteMsg, 'Confirm', smiQuestion, smbYesNo) <> smrYes) then
      Exit;
  end;

  lcVANumber := Trim(fmedtVANumber.Text);
  // There is always 1 with the Add DEA option. So 2 means only one DEA #.
  if ((lcVANumber = '') And (cboDeaNumber.Items.Count = 2)) then
  begin
    lcDeleteMsg :=
      'This is the only DEA number on file for this provider. The provider will no longer be able to prescribe controlled substances at the VA.'
      + CRLF + CRLF + 'Do you want to continue the deletion process?';

    if (ShowMsg(lcDeleteMsg, 'Confirm', smiQuestion, smbYesNo) <> smrYes) then
      Exit;
  end;

  lcDEA := fmedtDeaNumber.Text;
  lnIndex := cboDeaNumber.ItemIndex;
  // We must use the NPIEN - NEW PERSON FILE #200 INTERNAL ENTRY NUMBER
  // Also, the number will be in the format of #,######,##, and
  // we want the 2nd number.
  lcNPIENS := Piece(getCurrentInformation(lnIndex, NPIENS), ',', 2);

  if (ShowMsg('Do you wish to remove the current DEA # of ' + lcDEA + '?' + CRLF
    + CRLF + 'Removing the DEA number does not affect previously written prescriptions.',
    'Confirm', smiQuestion, smbYesNo) = smrYes) then
  begin
    with RPCBroker do
      try
        RemoteProcedure := 'PSO DEA REMOVE DEA';

        Param[0].Value := lcNPIENS;
        Param[0].PType := Literal;
        Param[1].Value := lcDEA;
        Param[1].PType := Literal;

        Call;
        lcResult := Results[0];
        lcFirst := Piece(lcResult, '^', 1);
        llSuccess := (lcFirst = '1');

        if (llSuccess) then
        begin
          ShowMsg(lcDEA + ' was deleted.', 'Success', smiInfo, smbOK);
          // Refresh the list.
          UpdateDEAList(fmlkupPrescriber.RecordNumber);
          UpdateDEAComboBox(fmlkupPrescriber.RecordNumber);
        end
        else
        begin
          ShowMsg('Unable to delete ' + lcDEA + ' (NPIENS: ' + lcNPIENS + ').',
            'Error', smiError, smbOK);
        end;

      except
        on loErr: Exception do
        begin
          ShowMsg('There was an error in deleting: ' + loErr.Message, 'Error',
            smiError, smbOK);
        end;

      end;

  end;
end;

function TfrmMain.HoldsVistAKey(AKeyName: string): Boolean;
begin
  with RPCBroker do
    try
      RemoteProcedure := 'XUS KEY CHECK';
      Param[0].Value := AKeyName;
      Param[0].PType := Literal;
      Call;
      Result := (AnsiCompareText(Results[0], '1') = 0);
    except
      Result := False;
    end;
end;

function TfrmMain.EditVANumber: Boolean;
var
  lcValue: string;
begin

  lcValue := ',' + Trim(fmlblProviderType.Caption) + ',';

  Result := (PROVIDER_TYPES_VA.Contains(lcValue));
end;

function TfrmMain.DisplayWarning: Boolean;
var
  lcResult: string;
  lcFirst: string;
begin
  with RPCBroker do
    try
      RemoteProcedure := 'PSO DEA MBM';
      Call;
      lcResult := Results[0];
      lcFirst := Piece(lcResult, '^', 1);

      Result := (lcFirst <> '1');
    except
      on E: Exception do
      begin
        Result := True;
      end;

    end;

end;

function TfrmMain.IsActiveUser: Boolean;
var
  aTerminationDate: TDateTime;
begin
  Result := False;
  with TStringList.Create do
    try
      if fmedtAccessCode.Text = '' then
        Add('  - has NO ACCESS CODE');

      if fmedtVerifyCode.Text = '' then
        Add('  - has NO VERIFY CODE');

      if fmedtDISUSERed.Text = 'YES' then
        Add('  - is DISUSERed');

      if fmedtTerminationDate.FMCtrlInternal <> '' then
      begin
        aTerminationDate := FMDateTime2TDateTime
          (fmedtTerminationDate.FMCtrlInternal);
        if (Now >= aTerminationDate) then
          Add(Format('  - was terminated as of %s',
            [FormatDateTime('MMM D, YYYY', aTerminationDate)]));
      end;

      if ((Count > 0) And (DisplayWarning)) then
      begin
        Insert(0, 'This is NOT an active prescriber.');
        Insert(1, '');
        Insert(2, 'This prescriber:');
        Add('');
        Add('Press Yes to continue processing with inactive prescriber. Press No to select a different prescriber.');
        Result := ShowMsg(Text, 'Confirm', smiQuestion, smbYesNo) = smrYes;
      end
      else
        Result := True;
      Free;
    except
      on E: Exception do
      begin
        ShowMsg(E.Message, 'Error', smiError, smbOK);
        Free;
      end;
    end;
end;

function TfrmMain.FMDateTime2TDateTime(aValue: string): TDateTime;
var
  y, m, d: Word;
begin
  y := (1700 + StrToInt(Copy(aValue, 1, 3)));
  m := StrToInt(Copy(aValue, 4, 2));
  d := StrToInt(Copy(aValue, 6, 2));
  Result := EncodeDate(y, m, d) + EncodeTime(0, 0, 0, 0);
end;

procedure TfrmMain.fmedtAltNameExit(Sender: TObject);
var
  Bad: Boolean;
  Name: string;
  PartStr: string;
  Mesg: string;
  AtPos: Integer;
begin
  Bad := False;

  name := fmedtAltName.Text;
  AtPos := Pos('@', name);
  if not(AtPos > 0) then
  begin
    Bad := True;
  end
  else if not(Pos('.', fmedtAltName.Text) < AtPos) then
  begin
    Bad := True;
  end
  else
  begin
    PartStr := Copy(fmedtAltName.Text, AtPos + 1, Length(fmedtAltName.Text));
    if not(Pos('.', PartStr) > 1) then
    begin
      Bad := True;
    end;
  end;
  if Bad then
  begin
    Mesg := 'This is the user''s primary work e-mail address' + #10#13;
    Mesg := Mesg + 'It must be in the format' + #10#13#10#13;
    Mesg := Mesg + 'first.last@agency.type,' + #10#13#10#13;
    Mesg := Mesg + '(e.g., john.public@DOMAIN)' + #10#13#10#13#10#13;
    Mesg := Mesg + 'where first.last are first and last names' + #10#13;
    Mesg := Mesg + '(and the last name may followed by a numeric digit).';
    ShowMsg(Mesg, 'Information', smiInfo, smbOK);
    fmedtAltName.Text := fCurrentPrescriber.SubjectAlternateName;
  end;

end;

procedure TfrmMain.UpperCaseChange(Sender: TObject);
var
  loEdit: TEdit;
  lnSelect: Integer;
  loEvent: TNotifyEvent;
begin

  loEdit := Sender As TEdit;

  loEvent := loEdit.OnChange;
  loEdit.OnChange := nil;

  lnSelect := loEdit.SelStart;
  loEdit.Text := UpperCase(loEdit.Text);

  if (lnSelect > Length(loEdit.Text)) then
    loEdit.SelStart := Length(loEdit.Text)
  else
    loEdit.SelStart := lnSelect;

  loEdit.OnChange := loEvent;

end;

procedure TfrmMain.CheckDetoxNumber(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var
  loEdit: TEdit;
  loEvent: TNotifyEvent;
  i, lnCount, lnTrack: Integer;
  lcLine, lcDetox: String;
  lcCurrentDEA, lcDetoxDEA: String;
begin

  loEdit := Sender As TEdit;
  if (Not loEdit.Enabled) then
    Exit;

  loEvent := loEdit.OnChange;
  loEdit.OnChange := nil;

  lcDetoxDEA := '';
  lcCurrentDEA := Trim(fmedtDeaNumber.Text);

  lnCount := foPrescriberDEAList.Count;
  lnTrack := 0;
  for i := 0 to lnCount - 1 do
  begin
    lcLine := foPrescriberDEAList[i];
    if (lcLine <> ADD_DEA) then
    begin
      lcDetox := getCurrentInformation(i, DETOX);

      if (Length(lcDetox) > 0) then
      begin
        lnTrack := lnTrack + 1;
        if (lcDetoxDEA = '') then
          lcDetoxDEA := getCurrentInformation(i, DEA);
      end;
    end;
  end;

  if ((lnTrack > 0) And (lcDetoxDEA <> lcCurrentDEA)) then
  begin
    loEdit.Text := '';
    ShowMsg('Detox # has already been set for another DEA # with this provider.',
      smiError, smbOK);
  end;

  loEdit.OnChange := loEvent;

end;

procedure TfrmMain.InitializeData(aPCSPrescriber: TPCSPrescriber;
  tcDUZ: string);
var
  i: Integer;
  CurrObject: TObject;

begin
  edtFacilityDEANum.Text := GetFacilityVANum(aPCSPrescriber.IENS);
  fmGetsPrescriber.IENS := aPCSPrescriber.IENS;
  fmGetsPrescriber.GetandFill;

  // Why is this needed? The checkbox can't process a boolean???
  for i := 0 to pnlMain.ControlCount - 1 do
  begin
    CurrObject := pnlMain.Controls[i];
    if CurrObject is TFMCheckBox then
      TFMCheckBox(CurrObject).Checked :=
        (TFMCheckBox(CurrObject).FMCtrlInternal = '1');
  end;

  UpdateDEAList(tcDUZ);
  UpdateDEAComboBox(tcDUZ);

end;

procedure TfrmMain.UpdateDEAComboBox(tcDUZ: String);
var
  i: Integer;
  lnCount: Integer;
  lcDEA, lcState, lcLine: string;

begin
  cboDeaNumber.Items.Clear;
  lnCount := foPrescriberDEAList.Count;

  if (lnCount = 0) then
  begin
    cboDeaNumber.Items.Add('Error reading the DUZ # of ' + tcDUZ + '.');
  end
  else
  begin
    for i := 0 to lnCount - 1 do
    begin
      lcLine := foPrescriberDEAList[i];
      if (lcLine = ADD_DEA) then
      begin
        cboDeaNumber.Items.Add(lcLine);
      end
      else
      begin
        lcDEA := getCurrentInformation(i, DEA);
        lcState := getCurrentInformation(i, STATE);

        cboDeaNumber.Items.Add(lcDEA + ' ' + lcState);
      end;

    end;
  end;

  // Select the first item.
  cboDeaNumber.ItemIndex := 0;
  cboDeaNumberChange(nil);

end;

procedure TfrmMain.UpdateDEAList(tcDUZ: String);
var
  loDEAList: TStrings;

begin
  with RPCBroker do
    try
      RemoteProcedure := 'PSO DEA DEALIST';
      Param[0].Value := tcDUZ;
      Param[0].PType := Literal;
      Call;
      loDEAList := Results;
    except
      loDEAList := TStringList.Create;
      loDEAList.Clear;
    end;

  // For some odd reason, TStrings does not maintain the data, and it
  // gets reset. So I'm using TStringList to store the data.
  foPrescriberDEAList := TStringList.Create;
  if (loDEAList.Count > 0) then
  begin
    if (Not ContainsText(LowerCase(loDEAList[0]), 'invalid')) then
    begin
      foPrescriberDEAList.Assign(loDEAList);
    end;
  end;

  foPrescriberDEAList.Add(ADD_DEA);

end;

procedure TfrmMain.cboDeaNumberChange(Sender: TObject);
var
  lnIndex: Integer;
  llAddRequest: Boolean;
  lcInstitution: String;
  llInstitution: Boolean;
  lcDOJ, lcError: String;
begin
  flValidateOnClickUseInpatientOrder := False;

  lnIndex := cboDeaNumber.ItemIndex;
  llAddRequest := (foPrescriberDEAList[lnIndex] = ADD_DEA);

  if (Not llAddRequest) then
  begin
    fmValidator8991.IENS := getCurrentInformation(lnIndex, DNIENS);

    fmGetsPrescriber8991.IENS := getCurrentInformation(lnIndex, DNIENS);
    fmGetsPrescriber8991.GetandFill;
  end
  else
  begin
    // This applies to Providers with no initial DEA #s and the copy feature.
    // For some reason, if you don't set the IENS number
    // of the text fields (not the check boxes), the Validator.IENS complains
    // that it has not been initialized.
    // And you can set fmValidator8991.IENS and fmGetsPrescriber8991.IENS to IENS_ADD and
    // run GetAndFill. Same error. Or if you have selected a previous DEA #,
    // these components remember the previous IENS. Weird.

    fmedtDeaNumber.IENS := IENS_ADD;
    fmedtDetoxMaintNumber.IENS := IENS_ADD;
    fmedtDeaExpirationDate.IENS := IENS_ADD;
  end;
  // Otherwise, nothing is loaded as the IENS number is +1
  // and existing values remain.

  updateControlsOnSelect(llAddRequest, lnIndex);
  UpdateRCPVariables();
  UpdateDOJControls(llAddRequest, getCurrentInformation(lnIndex, DEA),
    lcDOJ, lcError);
  CheckInpatientWarning();

  lcInstitution := UpperCase(Trim(DeciphorDOJ(lcDOJ, DOJ_TYPE)));
  llInstitution := (lcInstitution = DOJ_INSTITUTION);
  fmcbxUseInpatient.Enabled := Not llInstitution;

  flValidateOnClickUseInpatientOrder := True;

end;

procedure TfrmMain.UpdateDOJControls(tlAddRequest: Boolean; tcDEA: String;
  var tcInfo: String; var tcError: String);
var
  loDOJInfo: TStrings;
  lcDOJ: String;
  lcSuccess: String;

begin
  tcInfo := '';
  tcError := '';

  if ((tlAddRequest) Or (tcDEA = '')) then
    Exit;

  lcDOJ := '';

  with RPCBroker do
    try
      RemoteProcedure := 'PSO DEA DEADOJ';
      Param[0].Value := Piece(tcDEA, '-', 1);
      Param[0].PType := Literal;
      Call;
      loDOJInfo := Results;
    except
      loDOJInfo := TStringList.Create;
      loDOJInfo.Clear;
    end;

  if (loDOJInfo.Count > 0) then
  begin
    lcSuccess := Trim(Piece(loDOJInfo[0], U, 1));
    if ((lcSuccess = '1') And (loDOJInfo.Count > 1)) then
      lcDOJ := loDOJInfo[1]
    else
      tcError := Trim(Piece(loDOJInfo[0], U, 2));
  end;

  chkScheduleIINarcoticDOJ.Checked :=
    (DeciphorDOJ(lcDOJ, DOJ_SCHDEULE_II_NARCOTIC) = '1');
  chkScheduleIINonNarcoticDOJ.Checked :=
    (DeciphorDOJ(lcDOJ, DOJ_SCHEDULE_II_NON_NARCOTIC) = '1');
  chkScheduleIIINarcoticDOJ.Checked :=
    (DeciphorDOJ(lcDOJ, DOJ_SCHEDULE_III_NARCOTIC) = '1');
  chkScheduleIIINonNarcoticDOJ.Checked :=
    (DeciphorDOJ(lcDOJ, DOJ_SCHEDULE_III_NON_NARCOTIC) = '1');
  chkScheduleIVDOJ.Checked := (DeciphorDOJ(lcDOJ, DOJ_SCHEDULE_IV) = '1');
  chkScheduleVDOJ.Checked := (DeciphorDOJ(lcDOJ, DOJ_SCHEDULE_V) = '1');

  lblProviderNameDOJ.Caption := DeciphorDOJ(lcDOJ, DOJ_PROVIDER_NAME) + CRLF +
    CRLF + BuildDOJAddress(lcDOJ);

  lblDetoxMaintNumberDOJ.Caption := DeciphorDOJ(lcDOJ, DOJ_DETOX_NUMBER);
  lblDeaExpirationDateDOJ.Caption := DeciphorDOJ(lcDOJ, DOJ_EXPIRATION_DATE);

  tcInfo := lcDOJ;
end;

function TfrmMain.BuildDOJAddress(tcDOJ: String): string;
var
  lcResult: String;
  lcAdd1, lcAdd2, lcAdd3: String;
begin

  lcResult := '';
  lcAdd1 := DeciphorDOJ(tcDOJ, DOJ_ADDRESS1);
  lcAdd2 := DeciphorDOJ(tcDOJ, DOJ_ADDRESS2);
  lcAdd3 := DeciphorDOJ(tcDOJ, DOJ_ADDRESS3);
  if (lcAdd1 <> '') then
  begin
    lcResult := lcResult + lcAdd1 + CRLF;
  end;
  if (lcAdd2 <> '') then
  begin
    lcResult := lcResult + lcAdd2 + CRLF;
  end;

  if (lcAdd3 <> '') then
  begin
    lcResult := lcResult + lcAdd3 + CRLF;
  end;

  lcResult := lcResult + DeciphorDOJ(tcDOJ, DOJ_CITY) + ', ' +
    DeciphorDOJ(tcDOJ, DOJ_STATE) + ' ' + DeciphorDOJ(tcDOJ, DOJ_ZIP_CODE);

  Result := lcResult;

end;

function TfrmMain.DeciphorDOJ(tcDOJ: String; tnConst: Integer): string;
var
  lcResult, lcTemp: string;
  loDate: TDateTime;
begin

  lcResult := '';

  if ((tnConst >= DOJ_SCHDEULE_II_NARCOTIC) And (tnConst <= DOJ_SCHEDULE_V))
  then
  begin
    lcTemp := UpperCase(Trim(Piece(tcDOJ, U, tnConst)));
    if (lcTemp = 'YES') then
      lcResult := '1'
    else
      lcResult := '0';
  end
  else if (tnConst = DOJ_EXPIRATION_DATE) then
  begin
    lcResult := Trim(Piece(tcDOJ, U, tnConst));
    if (Length(lcResult) = 8) then
    begin
      loDate := StrToDate(Copy(lcResult, 5, 2) + '/' + Copy(lcResult, 7, 2) +
        '/' + Copy(lcResult, 1, 4));
      lcResult := FormatDateTime('mmm d, yyyy', loDate);
    end
    else if (Length(lcResult) = 0) then
    begin
      lcResult := DOJ_EMPTY;
    end;
  end
  else
  begin
    lcResult := Trim(Piece(tcDOJ, U, tnConst));
    if (lcResult = '') then
      lcResult := DOJ_EMPTY;
  end;

  // Trim is already done in the above code.
  Result := lcResult;
end;

procedure TfrmMain.updateControlsOnSelect(tlAddRequest: Boolean;
  tnIndex: Integer);
var
  lcDEA: string;
begin

  edtDEASuffix.Text := '';
  fmcbxUseInpatient.Enabled := True;

  if (tlAddRequest) then
  begin
    fmedtDeaNumber.Text := '';
    fmedtDetoxMaintNumber.Text := getCurrentInformation(tnIndex, DETOX);

    fmedtDeaExpirationDate.Text := getCurrentInformation(tnIndex, EXPIRATION);

    fmcbxScheduleIINarcotic.Checked :=
      (getCurrentInformation(tnIndex, SCHEDULE_II_NARCOTIC) = '1');
    fmcbxScheduleIINonNarcotic.Checked :=
      (getCurrentInformation(tnIndex, SCHEDULE_II_NON_NARCOTIC) = '1');
    fmcbxScheduleIIINarcotic.Checked :=
      (getCurrentInformation(tnIndex, SCHEDULE_III_NARCOTIC) = '1');
    fmcbxScheduleIIINonNarcotic.Checked :=
      (getCurrentInformation(tnIndex, SCHEDULE_III_NON_NARCOTIC) = '1');
    fmcbxScheduleIV.Checked :=
      (getCurrentInformation(tnIndex, SCHEDULE_IV) = '1');
    fmcbxScheduleV.Checked :=
      (getCurrentInformation(tnIndex, SCHEDULE_V) = '1');

    fmcbxUseInpatient.Checked :=
      (getCurrentInformation(tnIndex, INPATIENT) = '1');

    // DOJ components
    BlankDOJFields();

    setEnable(fmedtDeaNumber, True);

    btnCopy.Enabled := True;

    btnRemove.Enabled := False;
    btnUpdate.Enabled := False;
  end
  else
  begin
    setEnable(fmedtDeaNumber, False);

    btnCopy.Enabled := False;

    btnRemove.Enabled := True;
    btnUpdate.Enabled := True;

    lcDEA := getCurrentInformation(tnIndex, DEA);
    // If contains a suffix, then user can not set the Inpatient Orders.
    fmcbxUseInpatient.Enabled := Not ContainsText(lcDEA, '-');
  end;

  btnAdd.Enabled := False;

  setEnable(edtDEASuffix, False);

end;

function TfrmMain.getCurrentInformation(tnIndex: Integer;
  tnConst: Integer): string;
var
  lcResult, lcSuffix, lcIndex, lcTemp: string;
  llAddRequest: Boolean;
begin

  lcResult := '';
  lcIndex := foPrescriberDEAList[tnIndex];
  llAddRequest := (lcIndex = ADD_DEA);

  if (Not llAddRequest) then
  begin
    if (tnConst = DEA) then
    begin
      lcResult := Trim(Piece(lcIndex, U, DEA));
      lcSuffix := Trim(Piece(lcIndex, U, SUFFIX));
      if (Length(lcSuffix) > 0) then
        lcResult := lcResult + '-' + lcSuffix;
    end
    else if (((tnConst >= SCHEDULE_II_NARCOTIC) And (tnConst <= SCHEDULE_V)) OR
      (tnConst = INPATIENT)) then
    begin
      lcTemp := UpperCase(Trim(Piece(lcIndex, U, tnConst)));
      if (lcTemp = 'YES') then
        lcResult := '1'
      else
        lcResult := '0';
    end
    else
    begin
      lcResult := Trim(Piece(lcIndex, U, tnConst));
    end;

  end;

  if ((llAddRequest) And (tnConst = DNIENS)) then
  begin
    // From the help documentation on IENS.
    if (lcResult = '') then
      lcResult := IENS_ADD;
  end;

  Result := lcResult;
end;

procedure TfrmMain.UpdateRCPVariables();
begin

  with fCurrentPrescriber do
  begin
    AuthorizedToWrite := fmcbxAuthorizedToWriteOrders.Checked;
    SubjectAlternateName := fmedtAltName.FMCtrlInternal;

    DEA := fmedtDeaNumber.FMCtrlInternal;

    VANumber := fmedtVANumber.FMCtrlInternal;
    DetoxNumber := fmedtDetoxMaintNumber.FMCtrlInternal;
    DEAExpirationDate := fmedtDeaExpirationDate.FMCtrlInternal;

    // A blank from fileman is used as False
    AllowScheduleIINarc := fmcbxScheduleIINarcotic.Checked;
    AllowScheduleIINonNarc := fmcbxScheduleIINonNarcotic.Checked;
    AllowScheduleIIINarc := fmcbxScheduleIIINarcotic.Checked;
    AllowScheduleIIINonNarc := fmcbxScheduleIIINonNarcotic.Checked;
    AllowScheduleIVNarc := fmcbxScheduleIV.Checked;
    AllowScheduleVNarc := fmcbxScheduleV.Checked;

    UseForInpatient := fmcbxUseInpatient.Checked;
  end;

end;

procedure TfrmMain.fmcbxScheduleClick(Sender: TObject);
// If we uncheck even one of the schedules then we need to make sure that the all checkbox is off
begin
  if not TFMCheckBox(Sender).Checked then
    cbxAllSchedules.Checked := False;
end;

procedure TfrmMain.fmcbxUseInpatientClick(Sender: TObject);
var
  i, lnCount: Integer;
  lcDEA, lcCurrentDEA, lcLine: String;
  llInpatientUse, llOkay: Boolean;
  loCheckBox: TFMCheckBox;

begin
  // Geesh, there's not other way around this. Click is fired anytime
  // the checkbox value is changed, not just when clicked.
  if (Not flValidateOnClickUseInpatientOrder) Then
    Exit;

  lcCurrentDEA := Trim(fmedtDeaNumber.Text);

  loCheckBox := (Sender As TFMCheckBox);
  // Remember, this event is also fired when the checkbox.checked is
  // changed programmatically.
  if (loCheckBox.Enabled) then
  begin
    if ((Not loCheckBox.Checked) And (CountValidDEANumbers <= 1) And
      (lcCurrentDEA <> '')) then
    begin
      // Prevents recursion from happening. You must change the TCheckBox
      // before the dialog box, by the way, to give time for the click
      // event to be fired.
      flValidateOnClickUseInpatientOrder := False;
      loCheckBox.Checked := True;

      ShowMsg('DEA# ' + lcDEA + ' is the only one and must remain selected.',
        smiError, smbOK);

      flValidateOnClickUseInpatientOrder := True;
      Exit;
    end;
  end;

  llOkay := True;
  lnCount := foPrescriberDEAList.Count;

  for i := 0 to lnCount - 1 do
  begin
    lcLine := foPrescriberDEAList[i];
    if (lcLine <> ADD_DEA) then
    begin
      lcDEA := getCurrentInformation(i, DEA);
      llInpatientUse := getCurrentInformation(i, INPATIENT) = '1';

      if (llInpatientUse) then
      begin
        llOkay := (lcCurrentDEA = lcDEA);
        break;
      end;
    end;

  end;

  if (Not llOkay) then
  begin
    // Prevents recursion from happening. You must change the TCheckBox
    // before the dialog box, by the way, to give time for the click
    // event to be fired.
    flValidateOnClickUseInpatientOrder := False;
    loCheckBox.Checked := False;

    ShowMsg('DEA# ' + lcDEA +
      ' has already selected ''Use for Inpatient Orders?''', smiError, smbOK);

    flValidateOnClickUseInpatientOrder := True;
  end;

end;

function TfrmMain.CountValidDEANumbers(): Integer;
var
  i, lnCount, lnDEACount: Integer;
  lcDEA, lcLine: String;
begin

  lnCount := foPrescriberDEAList.Count;
  lnDEACount := 0;

  for i := 0 to lnCount - 1 do
  begin
    lcLine := foPrescriberDEAList[i];
    if (lcLine <> ADD_DEA) then
    begin
      lcDEA := getCurrentInformation(i, DEA);
      if (Pos('-', lcDEA) = 0) then
      begin
        lnDEACount := lnDEACount + 1;
      end;
    end;

  end;

  Result := lnDEACount;
end;

procedure TfrmMain.CheckInpatientWarning();
var
  i, lnCount: Integer;
  lcLine: String;
  llInpatientUse: Boolean;
  lcDEA: String;
begin
  lnCount := foPrescriberDEAList.Count;
  // Since there might only be the ADD_DEA option, set to true.
  llInpatientUse := True;

  for i := 0 to lnCount - 1 do
  begin
    lcLine := foPrescriberDEAList[i];
    // In this loop, I can't query the DOJ files for institutional DEA. Well, maybe I could,
    // but it would be convoluted. And all institutional DEA #s have a dash and suffix.
    lcDEA := getCurrentInformation(i, DEA);
    if ((lcLine <> ADD_DEA) And (Pos('-', lcDEA) = 0)) then
    begin
      llInpatientUse := (getCurrentInformation(i, INPATIENT) = '1');

      // Once the checked DEA has been found, then exit.
      if (llInpatientUse) then
        break;
    end;

  end;

  lblInpatientWarning.Visible := Not llInpatientUse;
  btnSelectPrescriber.Enabled := llInpatientUse;
end;

function TfrmMain.GetFacilityVANum(IENS: string): string;
var
  Ival: Integer;
  aFacilityIen: string;
begin
  Result := '';
  memUtility.Clear;
  fmListerNewPersonDivision.IENS := ',' + IENS;

  fmListerNewPersonDivision.GetList(memUtility.Lines);
  aFacilityIen := '';
  for Ival := 1 to memUtility.Lines.Count do
  begin
    if Pos(' 1', memUtility.Lines[Ival - 1]) > 0 then
    begin
      aFacilityIen := memUtility.Lines[Ival - 1];
      aFacilityIen := Copy(aFacilityIen, 1, Length(aFacilityIen) - 2);
    end;
  end;
  if (aFacilityIen = '') and (memUtility.Lines.Count = 1) then
  begin
    aFacilityIen := memUtility.Lines[0];
    if Pos(' 0', aFacilityIen) > 0 then
      aFacilityIen := Copy(aFacilityIen, 1, Length(aFacilityIen) - 2);
  end;
  if not(aFacilityIen = '') then
  begin
    while Copy(aFacilityIen, Length(aFacilityIen), 1) = ' ' do
      aFacilityIen := Copy(aFacilityIen, 1, Length(aFacilityIen) - 1);
    Result := Piece(GetValueFromVistA('$G(^DIC(4,' + aFacilityIen +
      ',"DEA"))'), '^');
    if not(Result = '') then
      Exit;
  end;
  // No Division or Couldn't get Facility DEA Number for Division
  aFacilityIen := GetValueFromVistA('$G(junk,$$SITE^VASITE())');
  aFacilityIen := Piece(aFacilityIen, '^');
  if not(aFacilityIen = '') then
  begin
    Result := Piece(GetValueFromVistA('$G(^DIC(4,' + aFacilityIen +
      ',"DEA"))'), '^')
  end;
end;

function TfrmMain.GetValueFromVistA(InputStr: string): string;
begin
  with RPCBroker do
    try
      RemoteProcedure := 'XWB GET VARIABLE VALUE';
      Param[0].Value := InputStr;
      Param[0].PType := Reference;
      Call;
      if (Results.Count > 0) then
        Result := Results[0]
      else
        Result := '';
    except
      Result := '';
    end;
end;

end.
