unit File200;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants,
  System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Fmcntrls, Fmcmpnts,
  Diaccess, oPCSPrescriber, Trpcb, VAUtils;

type
  TfrmFile200 = class(TForm)
    fmedtVANumber: TFMEdit;
    lblVANumber: TLabel;
    fmcbxScheduleIINarcotic: TFMCheckBox;
    fmcbxScheduleIINonNarcotic: TFMCheckBox;
    fmcbxScheduleIIINarcotic: TFMCheckBox;
    fmcbxScheduleIIINonNarcotic: TFMCheckBox;
    fmcbxScheduleIV: TFMCheckBox;
    fmcbxScheduleV: TFMCheckBox;
    fmFiler: TFMFiler;
    fmGetsPrescriber: TFMGets;
    fmValidator: TFMValidator;
    btnUpdate: TButton;
    procedure btnUpdateClick(Sender: TObject);
  private
    faChangeList: TStringList;
    fCurrentPrescriber: TPCSPrescriber;
    fRPCBroker: TRPCBroker;

    fVANumber: String;
    fAllowScheduleIINarc: Boolean;
    fAllowScheduleIINonNarc: Boolean;
    fAllowScheduleIIINarc: Boolean;
    fAllowScheduleIIINonNarc: Boolean;
    fAllowScheduleIVNarc: Boolean;
    fAllowScheduleVNarc: Boolean;
    fFmedtVANumber: TFMEdit;

    procedure AddBooleanChange(fmcbx: TFMCheckBox; aOriginalValue: Boolean);
    procedure AddTextChange(fmedt: TFMEdit; aOriginalValue: string);

  public

    constructor Create(AOwner: TComponent; toRPCBroker: TRPCBroker;
      toCurrentPrescriber: TPCSPrescriber; tofmedtVANumber: TFMEdit);
  end;

var
  frmFile200: TfrmFile200;

implementation

{$R *.dfm}

constructor TfrmFile200.Create(AOwner: TComponent; toRPCBroker: TRPCBroker;
  toCurrentPrescriber: TPCSPrescriber; tofmedtVANumber: TFMEdit);
begin
  inherited Create(AOwner);

  faChangeList := TStringList.Create;

  fRPCBroker := toRPCBroker;
  fCurrentPrescriber := toCurrentPrescriber;
  fFmedtVANumber := tofmedtVANumber;

  fmFiler.RPCBroker := fRPCBroker;
  fmGetsPrescriber.RPCBroker := fRPCBroker;
  fmValidator.RPCBroker := fRPCBroker;

  fmGetsPrescriber.IENS := fCurrentPrescriber.IENS;
  fmGetsPrescriber.GetandFill;

  fVANumber := fmedtVANumber.FMCtrlInternal;

  fAllowScheduleIINarc := fmcbxScheduleIINarcotic.Checked;
  fAllowScheduleIINonNarc := fmcbxScheduleIINonNarcotic.Checked;
  fAllowScheduleIIINarc := fmcbxScheduleIIINarcotic.Checked;
  fAllowScheduleIIINonNarc := fmcbxScheduleIIINonNarcotic.Checked;
  fAllowScheduleIVNarc := fmcbxScheduleIV.Checked;
  fAllowScheduleVNarc := fmcbxScheduleV.Checked;

end;

procedure TfrmFile200.btnUpdateClick(Sender: TObject);
var
  i: Integer;
begin

  AddTextChange(fmedtVANumber, fVANumber);

  AddBooleanChange(fmcbxScheduleV, fAllowScheduleVNarc);
  AddBooleanChange(fmcbxScheduleIV, fAllowScheduleIVNarc);
  AddBooleanChange(fmcbxScheduleIINonNarcotic, fAllowScheduleIINonNarc);
  AddBooleanChange(fmcbxScheduleIINarcotic, fAllowScheduleIINarc);
  AddBooleanChange(fmcbxScheduleIIINonNarcotic, fAllowScheduleIIINonNarc);
  AddBooleanChange(fmcbxScheduleIIINarcotic, fAllowScheduleIIINarc);

  if (faChangeList.Count > 0) then
    try
      fmFiler.Update;

      fFmedtVANumber.Text := fmedtVANumber.Text;

      with fRPCBroker do
      begin
        RemoteProcedure := 'PSO DEA EDIT';
        Param[0].PType := list;
        for i := 0 to faChangeList.Count - 1 do
          Param[0].Mult[IntToStr(i)] := faChangeList[i];
        Call;
      end;

      ShowMsg('Update Completed', 'Information', smiInfo, smbOK);
    except
      on E: Exception do
        ShowMsg('Error updating record: ' + E.Message, 'Error',
          smiError, smbOK);
    end
  else
    ShowMsg('No updates found', 'Information', smiInfo, smbOK);

  FreeAndNil(faChangeList);

  ModalResult := mrOk;
end;

procedure TfrmFile200.AddTextChange(fmedt: TFMEdit; aOriginalValue: string);
begin
  if (AnsiCompareStr(fmedt.FMCtrlInternal, aOriginalValue) <> 0) then
  begin
    faChangeList.Add(Format('`%s^`%s^%s^%s^%s', [fCurrentPrescriber.IEN,
      fRPCBroker.User.DUZ, fmedt.FMField, aOriginalValue,
      fmedt.FMCtrlInternal]));

    OutputDebugString(Pchar(Format('`%s^`%s^%s^%s^%s', [fCurrentPrescriber.IEN,
      fRPCBroker.User.DUZ, fmedt.FMField, aOriginalValue, fmedt.FMCtrlInternal])
      + chr(13) + chr(10)));
  end;

end;

procedure TfrmFile200.AddBooleanChange(fmcbx: TFMCheckBox;
  aOriginalValue: Boolean);
begin
  if not(fmcbx.Checked = aOriginalValue) then
  begin
    faChangeList.Add(Format('`%s^`%s^%s^%s^%s', [fCurrentPrescriber.IEN,
      fRPCBroker.User.DUZ, fmcbx.FMField, BoolToStr(aOriginalValue, True),
      BoolToStr(fmcbx.Checked, True)]));

    OutputDebugString(Pchar(Format('`%s^`%s^%s^%s^%s', [fCurrentPrescriber.IEN,
      fRPCBroker.User.DUZ, fmcbx.FMField, BoolToStr(aOriginalValue, True),
      BoolToStr(fmcbx.Checked, True)]) + chr(13) + chr(10)));
  end;
end;

end.
