KMPVVTCM ;SP/JML - Collect Cache Metrics for the VistA Timed Collection Monitor ;Sep 18, 2018@15:16
 ;;4.0;CAPACITY MANAGEMENT;*10003*;3/1/2018;Build 38
 ; *10003* - Changes by OSEHRA/Sam Habiel (c) Sam Habiel 2018
 ;           Licensed under Apache 2.0.
 ;
 ;
RUN ; Collect metrics per configured interval and store in ^KMPTMP("KMPV","VTCM","DLY" -- CALLED VIA CACHE TASK MANAGER
 ;
 ;-----------------------------------------------------------------------
 ;  NOTE:  this routine is written to be tasked off daily at prior to 5 minutes past midnight via the Cache Task Manager on each node.
 ;
 ; ^KMPTMP("KMPV","VTCM","DLY"... storage of data for current day
 ; ^KMPTMP("KMPV","VTCM","TRANSMIT",$J)............. temporary storage for daily VTCM data to be transmitted
 ;   Data in "TRANSMIT" node is deleted upon transmission
 ;   Data in "DLY" node:
 ;    "DLY" Data marked with message number upon transmission - deleted upon Acknowledgement of receipt from server.
 ;    IF DATA MORE THAN 7 DAYS OLD SEND ERROR MESSAGE TO CPE GROUP AND DELETE DATA
 ;    IF DATA MORE THAN 1 DAY OLD SEND WARNING MESSAGE TO CPE GROUP AND SEND DATA
 ;    IF DATA 1 DAY OLD SEND DATA
 ;    
 ;-----------------------------------------------------------------------
 ;
 N KMPVARR,KMPVBLK,KMPVCHKH,KMPVDASH,KMPVDATA,KMPVHANG,KMPVH,KMPVHOUR,KMPVHRSEC,KMPVHTIME,KMPVMEM,KMPVMET,KMPVMETS,KMPVMIN
 N KMPVNODE,KMPVOSET,KMPVROUT,KMPVSMH,KMPVSINT,KMPVSLOT,KMPVSTOP,Y
 ; ALWAYS - verify data is not building past configured number of days - if so for any reason, delete it
 D PURGEDLY^KMPVCBG("VTCM")
 ; Quit if monitor is not turned on
 Q:$$GETVAL^KMPVCCFG("VTCM","ONOFF",8969)'="ON"
 ; Check environment
 I $$PROD^KMPVCCFG'="Prod",$$GETVAL^KMPVCCFG("VTCM","ALLOW TEST SYSTEM",8969,"I")'=1 Q
 S U="^"
 D GETENV^%ZOSV S KMPVNODE=$P(Y,U,3)_":"_$P($P(Y,U,4),":",2) ;  IA 10097
 ;
 S KMPVSTOP=0,KMPVCHKH=+$H
 F  D  Q:KMPVSTOP
 .I $$GETVAL^KMPVCCFG("VTCM","ONOFF",8969)'="ON" S KMPVSTOP=1 Q  ; RUN FLAG SET TO 0
 .S KMPVH=$H
 .I KMPVH>KMPVCHKH SET KMPVSTOP=1 Q
 .S KMPVSINT=$$GETVAL^KMPVCCFG("VTCM","COLLECTION INTERVAL",8969)
 .S KMPVHANG=KMPVSINT*60
 .; Get metrics
 .D KMPVVTCM^%ZOSVKSD(.KMPVMETS)
 .M KMPVDASH=KMPVMETS("KMPVDASH"),KMPVROUT=KMPVMETS("KMPVROUT")
 .M KMPVSMH=KMPVMETS("KMPVSMH"),KMPVMEM=KMPVMETS("KMPVMEM")
 .D BLKCOL^%ZOSVKSD(.KMPVBLK)
 .;
 .; Create metric string
 .; p1:GloRefs^p2:GloRefsPerSec^p3:GloSets^p4:LogicalReads^p5:DiskReads^p6:DiskWrites^p7:Processes^p8:RtnCommands
 .; p9:RtnLines^p10:RouRefs^p11:CSPSessions^p12:CacheEfficiency^p13:ECPAppSrvRate^p14:ECPDataSrvRate^p15:JournalEntries
 .; p16:ApplicationErrors^p17:TotalSMHMemUsed^p18:SMHPagesUsed^p19:ConfiguredSMHMemory^
 .; p20:total Shared Memory Heap available (including pages, smt, genstrtab^
 .; p21:pages total available Shared Memory Heap pages (in bytes)^
 .; p22:smt total available memory in SMT table^
 .; p23:genstrtab total available memory in General String Table^
 .; p24:BlkColSamples^p25:BlkCollisions
 .S KMPVMET=KMPVDASH("GloRefs")_U_KMPVDASH("GloRefsPerSec")_U_KMPVDASH("GloSets")
 .S KMPVMET=KMPVMET_U_KMPVDASH("LogicalReads")_U_KMPVDASH("DiskReads")_U_KMPVDASH("DiskWrites")
 .S KMPVMET=KMPVMET_U_KMPVDASH("Processes")_U_KMPVROUT("RtnCommands")_U_KMPVROUT("RtnLines")_U_KMPVDASH("RouRefs")
 .S KMPVMET=KMPVMET_U_KMPVDASH("CSPSessions")_U_KMPVDASH("CacheEfficiency")
 .S KMPVMET=KMPVMET_U_KMPVDASH("ECPAppSrvRate")_U_KMPVDASH("ECPDataSrvRate")
 .S KMPVMET=KMPVMET_U_KMPVDASH("JournalEntries")_U_KMPVDASH("ApplicationErrors")
 .S KMPVMET=KMPVMET_U_$P(KMPVSMH,",")_U_$P(KMPVSMH,",",2)_U_$P(KMPVSMH,",",3)
 .S KMPVMET=KMPVMET_U_$P(KMPVMEM,",")_U_$P(KMPVMEM,",",2)_U_$P(KMPVMEM,",",3)_U_$P(KMPVMEM,",",4)
 .S KMPVMET=KMPVMET_U_$P(KMPVBLK,",")_U_$P(KMPVBLK,",",2)_U_$P(KMPVBLK,",",3)  ; *10003* - added extra piece here.
 .;
 .; *10003* - If outside of the VA, just write to a file directly
 .I '$$VA^KMPLOG D
 ..N H S H="GloRefs^GloRefsPerSec^GloSets^LogicalReads^DiskReads^DiskWrites^Processes^RtnCommands^"
 ..S H=H_"RtnLines^RouRefs^CSPSessions^CacheEfficiency^ECPAppSrvRate^ECPDataSrvRate^JournalEntries^"
 ..S H=H_"ApplicationErrors^TotalSMHMemUsed^SMHPagesUsed^ConfiguredSMHMemory^"
 ..S H=H_"SHMHeapAvail^SMHHeapPages^SMTMemTotal^strtabTotal^blksamples/CS Total^blkcoll/CS fails^CS latch (ns)"
 ..D HEAD^KMPLOG(H,"KMPV","VTCM",1)
 ..D EN^KMPLOG("KMPVMET","KMPV","VTCM","A",1)
 .E  D  ; /*10003*
 ..S KMPVHTIME=$$SLOT^KMPVCCFG(KMPVH,KMPVSINT,"HOROLOG")
 ..S ^KMPTMP("KMPV","VTCM","DLY",+KMPVH,KMPVNODE,KMPVHTIME)=KMPVMET
 .;
 .H KMPVHANG
 Q
 ;
 ;
SEND ; Format and send data to CPE once a day -- TASKED VIA TASKMAN
 I '$$VA^KMPLOG QUIT  ; *10003*
 N KMPVCFG,KMPVDATA,KMPVDOM,KMPVFMDAY,KMPVHDAY,KMPVHLAST,KMPVHOUR,KMPVHSTRT,KMPVHTODAY,KMPVHYDAY
 N KMPVKEEP,KMPVLAST,KMPVLN,KMPVNODE,KMPVRT,KMPVSINF,KMPVSITE,KMPVWD
 N %H
 K ^KMPTMP("KMPV","VTCM","TRANSMIT",$J)
 S KMPVHSTRT=$H,KMPVHTODAY=+KMPVHSTRT,KMPVSITE=$$SITE^VASITE ;  IA 10112
 S KMPVHYDAY=+$H-1
 S KMPVLAST=$$GETVAL^KMPVCCFG("VTCM","LAST START TIME",8969,"I")
 I KMPVLAST'="" D
 .S X=KMPVLAST D H^%DTC S KMPVHLAST=%H
 .I KMPVHLAST<KMPVHYDAY D CANMESS^KMPVCBG("JOBLATE","VTCM",KMPVSITE,(KMPVHYDAY-KMPVHLAST))
 ;
 S KMPVKEEP=$$GETVAL^KMPVCCFG("VTCM","DAYS TO KEEP DATA",8969)
 S KMPVSINF=$$SITEINFO^KMPVCCFG()
 S KMPVHDAY=""
 F  S KMPVHDAY=$O(^KMPTMP("KMPV","VTCM","DLY",KMPVHDAY)) Q:KMPVHDAY=""!(KMPVHDAY>KMPVHYDAY)  D
 .; IF OLDER THAN 7 DAYS AND NOT MARKED AS SENT SEND ERROR MESSAGE, KILL NODE AND GO TO NEXT DAY
 .I KMPVHDAY<(KMPVHTODAY-KMPVKEEP) D  Q
 ..D CANMESS^KMPVCBG("DELETE","VTCM",KMPVSITE,KMPVHDAY) K ^KMPTMP("KMPV","VTCM","DLY",KMPVHDAY)
 .S KMPVFMDAY=+$$HTFM^XLFDT(KMPVHDAY,1)
 .S KMPVWD=$$WORKDAY^XUWORKDY(KMPVFMDAY) ; IA#10046
 .; RETRANSMISSION FLAG: GREATER THAN ZERO MEANS MESSAGE WAS SENT TO CPE BUT ACK MESSAGE NOT YET REC'D
 .S KMPVRT=$S(+$G(^KMPTMP("KMPV","VTCM","DLY",KMPVHDAY))>0:"YES",1:"NO")
 .; IF BETWEEN 1 AND 7 DAYS OLD AND NOT TRANSMITTED SEND WARNING MESSAGE AND ATTEMPT TO TRANSMIT AGAIN
 .I KMPVHDAY<(KMPVHTODAY-1) D CANMESS^KMPVCBG("TRANWARN","VTCM",KMPVSITE,KMPVHDAY)
 .K ^KMPTMP("KMPV","VTCM","TRANSMIT",$J)
 .S KMPVLN=1
 .S ^KMPTMP("KMPV","VTCM","TRANSMIT",$J,KMPVLN)="SYSTEM ID="_KMPVSINF,KMPVLN=KMPVLN+1
 .S ^KMPTMP("KMPV","VTCM","TRANSMIT",$J,KMPVLN)="UPDATE CONFIG="_KMPVHDAY_U_KMPVWD_"^DAILY",KMPVLN=KMPVLN+1
 .S ^KMPTMP("KMPV","VTCM","TRANSMIT",$J,KMPVLN)="SYSTEM CONFIG="_$$SYSCFG^KMPVCCFG(),KMPVLN=KMPVLN+1
 .S ^KMPTMP("KMPV","VTCM","TRANSMIT",$J,KMPVLN)="MONITOR CONFIG="_$$CFGSTR^KMPVCCFG("VTCM"),KMPVLN=KMPVLN+1
 .S ^KMPTMP("KMPV","VTCM","TRANSMIT",$J,KMPVLN)="RETRANSMISSION="_KMPVRT,KMPVLN=KMPVLN+1
 .S KMPVNODE=""
 .F  S KMPVNODE=$O(^KMPTMP("KMPV","VTCM","DLY",KMPVHDAY,KMPVNODE)) Q:KMPVNODE=""  D
 ..S KMPVHOUR=""
 ..F  S KMPVHOUR=$O(^KMPTMP("KMPV","VTCM","DLY",KMPVHDAY,KMPVNODE,KMPVHOUR)) Q:KMPVHOUR=""  D
 ...S KMPVDATA=$G(^KMPTMP("KMPV","VTCM","DLY",KMPVHDAY,KMPVNODE,KMPVHOUR))
 ...S ^KMPTMP("KMPV","VTCM","TRANSMIT",$J,KMPVLN)="VTCM DATA="_KMPVNODE_U_KMPVHOUR_U_KMPVDATA,KMPVLN=KMPVLN+1
 .D TRANSMIT
 D STRSTP^KMPVCCFG("VTCM",KMPVHSTRT)
 Q
 ;
TRANSMIT ; Transmit data
 ; quit if no data to transmit.
 Q:'$D(^KMPTMP("KMPV","VTCM","TRANSMIT",$J))
 N KMPVEMAIL,X,XMSUB,XMTEXT,XMY,XMZ
 ; send data via mail message.
 S XMTEXT="^KMPTMP(""KMPV"",""VTCM"",""TRANSMIT"","_$J_","
 S XMSUB="VTCM DAILY DATA"
 S KMPVEMAIL=$$GETVAL^KMPVCCFG("VTCM","NATIONAL DATA EMAIL ADDRESS",8969) I KMPVEMAIL'="" S XMY(KMPVEMAIL)=""
 D ^XMD
 ; RECORD SUCCESS/FAILURE -- SEND MESSAGE IF FAILURE
 I +$G(XMZ)>0 D
 .S ^KMPTMP("KMPV","VTCM","DLY",KMPVHDAY)=XMZ
 E  D CANMESS^KMPVCBG("FAILTRAN","VTCM",KMPVSITE,KMPVHDAY)
 K ^KMPTMP("KMPV","VTCM","TRANSMIT",$J)
 Q
 ;
