KMPVCCFG ;SP/JML - VSM configuration functions -- APIs for data access ;2018-07-24
 ;;4.0;CAPACITY MANAGEMENT;*10003*;
 ;
 ; *10003* changes (c) Sam Habiel 2018
 ;
 ;  ACCESSOR FUNCTIONS
 ;
CFGARR(KMPVMKEY,KMPVCFG,KMPVFLAG) ; Return configuration by monitor in array
 K KMPVCFG S U="^"
 N KMPVIEN,KMPV0,KMPV1,KMPV2,KMPV3
 I $D(^KMPV(8969,"B",KMPVMKEY)) S KMPVIEN=$O(^KMPV(8969,"B",KMPVMKEY,""))
 Q:$G(KMPVIEN)=""
 S KMPV0=$G(^KMPV(8969,KMPVIEN,0)),KMPV1=$G(^KMPV(8969,KMPVIEN,1))
 S KMPV2=$G(^KMPV(8969,KMPVIEN,2)),KMPV3=$G(^KMPV(8969,KMPVIEN,3))
 S KMPVCFG("ONOFF")=$$GETVAL(KMPVMKEY,"ONOFF",8969,$G(KMPVFLAG)),KMPVCFG("VERSION")=$P(KMPV0,U,4)
 S KMPVCFG("VERSION INSTALL DATE")=$P(KMPV0,U,5),KMPVCFG("DAYS TO KEEP DATA")=$P(KMPV1,U)
 S KMPVCFG("COLLECTION INTERVAL")=$P(KMPV1,U,2),KMPVCFG("CACHE DAILY TASK")=$P(KMPV1,U,3)
 S KMPVCFG("ALLOW TEST SYSTEM")=$$GETVAL(KMPVMKEY,"ALLOW TEST SYSTEM",8969,$G(KMPVFLAG)),KMPVCFG("TASKMAN SCHEDULE FREQUENCY")=$P(KMPV1,U,5)
 S KMPVCFG("TASKMAN SCHEDULE START")=$P(KMPV1,U,6),KMPVCFG("TASKMAN OPTION")=$P(KMPV1,U,7)
 S KMPVCFG("LAST START TIME")=$P(KMPV2,U),KMPVCFG("LAST STOP TIME")=$P(KMPV2,U,2)
 S KMPVCFG("LAST RUN TIME")=$P(KMPV2,U,3),KMPVCFG("NATIONAL DATA EMAIL ADDRESS")=$P(KMPV3,U)
 S KMPVCFG("NATIONAL SUPPORT EMAIL ADDRESS")=$P(KMPV3,U,2)
 S KMPVCFG("VSM CFG EMAIL ADDRESS")=$P(KMPV3,U,3),KMPVCFG("LOCAL SUPPORT EMAIL ADDRESS")=$P(KMPV3,U,4)
 Q
 ;
GETDEF(KMPVMKEY,KMPVDEF,KMPVFLAG) ; Return default configuration in array
 K KMPVDEF S U="^"
 N KMPVIEN,KMPV0,KMPV1
 I $D(^KMPV(8969.02,"B",KMPVMKEY)) S KMPVIEN=$O(^KMPV(8969.02,"B",KMPVMKEY,""))
 Q:$G(KMPVIEN)=""
 S KMPV0=$G(^KMPV(8969.02,KMPVIEN,0)),KMPV1=$G(^KMPV(8969.02,KMPVIEN,1))
 S KMPVDEF("DAYS TO KEEP DATA")=$P(KMPV0,U,2),KMPVDEF("COLLECTION INTERVAL")=$P(KMPV0,U,3)
 S KMPVDEF("CACHE DAILY TASK")=$P(KMPV0,U,4),KMPVDEF("ALLOW TEST SYSTEM")=$P(KMPV0,U,5)
 S KMPVDEF("TASKMAN SCHEDULE FREQUENCY")=$P(KMPV0,U,6),KMPVDEF("TASKMAN SCHEDULE START")=$P(KMPV0,U,7)
 S KMPVDEF("TASKMAN OPTION")=$P(KMPV0,U,8),KMPVDEF("NATIONAL DATA EMAIL ADDRESS")=$P(KMPV1,U)
 S KMPVDEF("NATIONAL SUPPORT EMAIL ADDRESS")=$P(KMPV1,U,2),KMPVDEF("VSM CFG EMAIL ADDRESS")=$P(KMPV1,U,3)
 Q
 ;
CFGSTR(KMPVMKEY,KMPVFLAG) ; Return configuration in "^" delimited string
 S U="^"
 N KMPVIEN,KMPV0,KMPV1,KMPV2,KMPV3,KMPVCFG
 I $D(^KMPV(8969,"B",KMPVMKEY)) S KMPVIEN=$O(^KMPV(8969,"B",KMPVMKEY,""))
 Q:$G(KMPVIEN)="" ""
 S KMPVCFG=""
 S KMPV0=$G(^KMPV(8969,KMPVIEN,0)),KMPV1=$G(^KMPV(8969,KMPVIEN,1))
 ; MONITOR KEY^ONOFF^VERSION^VERSION INSTALL DATE^DAYS TO KEEP DATA^COLLECTION INTERVAL^SCHEDULE FREQUENCY^SCHEDULE START^ALLOW TEST
 ; ^CACHE DAILY TASK^TASKMAN TASK
 S KMPVCFG=KMPVMKEY_U_$$GETVAL(KMPVMKEY,"ONOFF",8969,$G(KMPVFLAG))_U_$P(KMPV0,U,4)_U_$P(KMPV0,U,5)_U_$P(KMPV1,U,1)_U_$P(KMPV1,U,2)_U
 S KMPVCFG=KMPVCFG_$P(KMPV1,U,5)_U_$P(KMPV1,U,6)_U_$$GETVAL(KMPVMKEY,"ALLOW TEST SYSTEM",8969,$G(KMPVFLAG))_U
 S KMPVCFG=KMPVCFG_$P(KMPV1,U,3)_U_$P(KMPV1,U,7)
 Q KMPVCFG
 ;
GETVAL(KMPVMKEY,KMPVFLD,KMPVFILE,KMPVFLAG) ; retrieve value from VSM CONFIGURATION or VSM MONITOR DEFAULTS files
 N KMPVIEN
 I KMPVFILE=8969,$D(^KMPV(8969,"B",KMPVMKEY)) S KMPVIEN=$O(^KMPV(8969,"B",KMPVMKEY,""))
 I KMPVFILE=8969.02,$D(^KMPV(8969.02,"B",KMPVMKEY)) S KMPVIEN=$O(^KMPV(8969.02,"B",KMPVMKEY,""))
 Q:$G(KMPVIEN)="" ""
 Q $$GET1^DIQ(KMPVFILE,KMPVIEN,KMPVFLD,$G(KMPVFLAG))
 ;
 ; SETTER FUNCTIONS
 ;
SETONE(KMPVMKEY,KMPVFNAM,KMPVNVAL,KMPVERR) ; set a value into the VSM CONFIGURATION file
 K KMPVERR,KMPVEARR
 N KMPVIEN,KMPVEARR,KMPVOVAL,KMPVSTAT,KMPVUP
 N FDA
 S KMPVSTAT=0,KMPVLOG=+$G(KMPVLOG)
 S KMPVOVAL=$$GETVAL(KMPVMKEY,KMPVFNAM,8969)
 I KMPVOVAL=KMPVNVAL Q KMPVSTAT
 I $D(^KMPV(8969,"B",KMPVMKEY)) S KMPVIEN=$O(^KMPV(8969,"B",KMPVMKEY,""))
 I $G(KMPVIEN)="" S KMPVSTAT="1^MONITOR TYPE NOT CONFIGURED" Q KMPVSTAT
 S KMPVFNUM=$$FLDNUM^DILFD(8969,KMPVFNAM)
 I +KMPVFNUM=0 S KMPVSTAT="1^FIELD NAME '"_KMPVFNAM_"' DOES NOT EXIST" Q KMPVSTAT
 S FDA($J,8969,KMPVIEN_",",KMPVFNUM)=KMPVNVAL
 D FILE^DIE("ET","FDA($J)","KMPVEARR")
 I $D(KMPVEARR) D  Q KMPVSTAT
 .M KMPVERR=KMPVEARR
 .S KMPVSTAT="1^FILING ERROR"
 Q KMPVSTAT
 ;
SETVALS(KMPVMKEY,KMPVFVAL,KMPVERR,KMPVLOG) ; set multiple values into the VSM CONFIGURATION file
 ; KMPVFVAL(FieldName)=FieldValue,  KMPVERR: Output array if errors
 K KMPVERR,KMPVEARR
 N KMPVDATA,KMPVIEN,KMVEARR,KMPVFNAM,KMPVFNUM,KMPVSTAT
 N FDA
 S KMPVSTAT=0,KMPVLOG=+$G(KMPVLOG)
 I $D(^KMPV(8969,"B",KMPVMKEY)) S KMPVIEN=$O(^KMPV(8969,"B",KMPVMKEY,""))
 I $G(KMPVIEN)="" S KMPVSTAT="1^MONITOR TYPE NOT CONFIGURED" Q KMPVSTAT
 ;  get field numbers and set FDA array
 S KMPVFNAM=""
 F  S KMPVFNAM=$O(KMPVFVAL(KMPVFNAM)) Q:KMPVFNAM=""  D
 .S KMPVFNUM=$$FLDNUM^DILFD(8969,KMPVFNAM)
 .I KMPVFNUM>0 S FDA($J,8969,KMPVIEN_",",KMPVFNUM)=KMPVFVAL(KMPVFNAM)
 .E  S KMPVEARR(KMPVFNAM)=""
 ; If field name does not exist set error array and quit
 I $D(KMPVEARR) D  Q KMPVSTAT
 .S KMPVSTAT="1^FIELD NAME DOES NOT EXIST"
 .M KMPVERR=KMPVEARR
 D FILE^DIE("ET","FDA($J)","KMPVEARR")
 ; If filing errors set error array
 I $D(KMPVEARR) D  Q KMPVSTAT
 .M KMPVERR=KMPVEARR
 .S KMPVSTAT="1^FILING ERROR"
 Q KMPVSTAT
 ;
 ; OTHER FUNCTIONS
 ;
RESTCFG(KMPVMKEY) ; Restore default configuration to VSM CONFIGURATION file
 N KMPVSTAT
 D GETDEF(KMPVMKEY,.KMPVDEF)
 S KMPVSTAT=$$SETVALS(KMPVMKEY,.KMPVDEF,.KMPVERR)
 D CFGMSG^KMPVCBG()
 Q KMPVSTAT
 ;
STRSTP(KMPVMKEY,KMPVSTIME) ; Record run time values
 Q:KMPVMKEY=""
 Q:KMPVSTIME=""
 N %,%H,X,KMPVETFM,KMPVFVAL,KMPVSTAT,KMPVSTFM,KMPVTDIFF
 S %H=KMPVSTIME D YMD^%DTC S KMPVSTFM=X_%
 S %H=$H D YMD^%DTC S KMPVETFM=X_%
 S KMPVTDIFF=$$FMDIFF^XLFDT(KMPVETFM,KMPVSTFM,2)
 S KMPVFVAL("LAST START TIME")=KMPVSTFM
 S KMPVFVAL("LAST STOP TIME")=KMPVETFM
 S KMPVFVAL("LAST RUN TIME")=KMPVTDIFF
 S KMPVSTAT=$$SETVALS(KMPVMKEY,.KMPVFVAL,.KMPVEARR,1)
 Q
 ;
SYSCFG() ; Return system configuration values
 Q $$VERSION^%ZOSV(1)_"^"_$$OS^%ZOSV_"^"_$$VERSION^%ZOSV(0)_"^"_$$PROD() ; IA 10097
 ;
MONSTAT(KMPVTEXT) ; Return status information for all configured monitors
 K KMPVTEXT
 N KMPVBGD,KMPVCDAYS,KMPVCOMP,KMPVDDAYS,KMPVDLY,KMPVENT,KMPVI,KMPVML,KMPVMKEY,KMPVOPT,KMPVTASK,Y
 ;
 D MONLIST^KMPVCBG(.KMPVML)
 S KMPVMKEY=""
 F  S KMPVMKEY=$O(KMPVML(KMPVMKEY)) Q:KMPVMKEY=""  D
 .D CFGARR(KMPVMKEY,.KMPVCFG)
 .S KMPVDLY=$O(^KMPTMP("KMPV",KMPVMKEY,"DLY",""))
 .S KMPVDDAYS=$S(KMPVDLY="":0,1:+$H-KMPVDLY)
 .S KMPVCOMP=$O(^KMPTMP("KMPV",KMPVMKEY,"COMPRESS",""))
 .S KMPVCDAYS=$S(KMPVCOMP="":0,1:+$H-KMPVCOMP)
 .S KMPVOPT=$$GETVAL^KMPVCCFG(KMPVMKEY,"TASKMAN OPTION",8969)
 .D OPTSTAT^XUTMOPT(KMPVOPT,.KMPVBGD)
 .S KMPVTEXT(KMPVMKEY,"ONOFF")=KMPVCFG("ONOFF")
 .S KMPVTEXT(KMPVMKEY,"LAST START TIME")=KMPVCFG("LAST START TIME")
 .S KMPVTEXT(KMPVMKEY,"LAST RUN TIME")=KMPVCFG("LAST RUN TIME")
 .S KMPVTEXT(KMPVMKEY,"DAILY NODE DAYS")=KMPVDDAYS
 .S KMPVTEXT(KMPVMKEY,"COMPRESS NODE DAYS")=KMPVCDAYS
 .S KMPVTEXT(KMPVMKEY,"OPTION SCHEDULE FILE ENTRIES")=$G(KMPVBGD)
 .S KMPVI=""
 .F  S KMPVI=$O(KMPVBGD(KMPVI)) Q:KMPVI=""  D
 ..S KMPVENT=$G(KMPVBGD(KMPVI))
 ..S KMPVTASK=+$P(KMPVENT,"^")
 ..S Y=$P(KMPVENT,"^",2) D DD^%DT
 ..S KMPVTEXT(KMPVMKEY,"BGTask",KMPVTASK,"SCHEDULED TIME")=Y
 ..S KMPVTEXT(KMPVMKEY,"BGTask",KMPVTASK,"RESCHEDULE FREQUENCY")=$P(KMPVENT,"^",3)
 ..S KMPVTEXT(KMPVMKEY,"BGTask",KMPVTASK,"QUEUEING FLAG")=$P(KMPVENT,"^",4)
 Q
 ;
USERNAME(KMPVDUZ) ; Return users name from DUZ
 N KMPVNAME,KMPVOUT
 ; IA 10060 for lookup into NEW PERSON file
 I +KMPVDUZ'>0 Q ""
 D FIND^DIC(200,"","","A",KMPVDUZ,"","","","","KMPVOUT")
 S KMPVNAME=$G(KMPVOUT("DILIST",1,1))
 Q KMPVNAME
 ;
PROD() ; Return "Prod" if production, "Test" otherwise
 N KMPVPROD
 S KMPVPROD=$$PROD^XUPROD() ; IA 4440
 S KMPVPROD=$S(KMPVPROD=1:"Prod",1:"Test")
 Q KMPVPROD
 ;
SITEINFO() ;
 N KMPVPROD,KMPVDOM,KMPVSITE,KMPVSCD,KMPVSINF
 S KMPVPROD=$$PROD^KMPVCCFG()
 S KMPVDOM=$P($$NETNAME^XMXUTIL(.5),"@",2) ;IA 2734
 S KMPVSITE=$$SITE^VASITE ;  IA 10112
 D GETENV^%ZOSV S KMPVSCD=$P(Y,U,1) ;  IA 10097
 S KMPVSINF=$P(KMPVSITE,U,2)_"^"_$P(KMPVSITE,U,3)_"^"_KMPVDOM_"^"_KMPVPROD_"^"_KMPVSCD
 Q KMPVSINF
 ;
SLOT(KMPTIME,KMPSINT,KMPTFORM) ;
 ; NOTE: code in %ZOSVKR similar. All other VSM monitors call here.
 N X,%T,%H,KMPSSEC,KMPSEC,X,KMPSLOT,KMPSTIME
 S KMPSSEC=KMPSINT*60
 I KMPTFORM="HOROLOG" D
 .S KMPSEC=$P(KMPTIME,",",2)
 I KMPTFORM="FILEMAN" D
 .S X=KMPTIME D H^%DTC S KMPSEC=%T
 .I KMPSEC>86399 S KMPSEC=86399
 S KMPSLOT=KMPSEC\KMPSSEC
 S KMPSTIME=KMPSLOT*KMPSSEC
 Q KMPSTIME
 ;
ISBENODE(KMPNODE) ;
 I +$SY=47 QUIT 1  ; *10003* - ISBENODE has no meaning for GT.M systems
 N RET,KMPINST,KMPNTYP
 S RET=0
 Q:$P(KMPNODE,":",2)="" -1
 S KMPINST=$P(KMPNODE,":",2)
 I $E(KMPINST,7,9)="SVR" S RET=1
 Q RET
