KMPVBETR ;SP/JML - VBEM Nightly compression and transmission;5/1/2017;
 ;;4.0;CAPACITY MANAGEMENT;;3/1/2018
 ;
 ;
EN ;  Format and send data to CPE once a day -- TASKED VIA TASKMAN
 ;-----------------------------------------------------------------------
 ; ^KMPTMP("KMPV","VBEM","TRANSMIT",$J)............. temporary storage for daily VBEM data to be transmitted
 ; ^KMPTMP("KMPV","VBEM","COMPRESS",KMPHDAY)........ temporary storage for compressed data prior to transmission
 ; Data in "DLY" node is deleted upon compression
 ; Data in "TRANSMIT" node is deleted upon transmission
 ; Data in "COMPRESS" node:
 ;    IF DATA MORE THAN 7 DAYS OLD SEND ERROR MESSAGE TO CPE GROUP AND DELETE DATA
 ;    IF DATA MORE THAN 1 DAY OLD SEND WARNING MESSAGE TO CPE GROUP AND SEND DATA
 ;    IF DATA 1 DAY OLD SEND DATA
 ;-----------------------------------------------------------------------
 ;
 N KMPVCFG,KMPVDATA,KMPVFMDAY,KMPVHDAY,KMPVHLAST,KMPVHSTRT,KMPVHTODAY,KMPVHYDAY,KMPVI,KMPVJ,KMPVJTOT
 N KMPVKEEP,KMPVLAST,KMPVLN,KMPVNODE,KMPVOPT,KMPVRT,KMPVSINF,KMPVSITE,KMPVTIME,KMPVUTOT,KMPVWD
 N %H,ZTREQ,ZTSTOP
 ; ALWAYS - verify data is not building past configured number of days - if so for any reason, delete it
 D PURGEDLY^KMPVCBG("VBEM")
 ;
 K ^KMPTMP("KMPV","VBEM","TRANSMIT",$J) S U="^"
 S KMPVHSTRT=$H,KMPVHTODAY=+KMPVHSTRT,KMPVSITE=$$SITE^VASITE  ; IA 10112
 S KMPVHYDAY=+$H-1
 S KMPVLAST=$$GETVAL^KMPVCCFG("VBEM","LAST START TIME",8969,"I")
 I KMPVLAST'="" D
 .S X=KMPVLAST D H^%DTC S KMPVHLAST=%H
 .I KMPVHLAST<KMPVHYDAY,KMPVHLAST'="" D CANMESS^KMPVCBG("JOBLATE","VBEM",KMPVSITE,(KMPVHYDAY-KMPVHLAST))
 ;
 S KMPVKEEP=$$GETVAL^KMPVCCFG("VBEM","DAYS TO KEEP DATA",8969)
 S KMPVSINF=$$SITEINFO^KMPVCCFG()
 ;
 ; COMPRESS DATA - REMOVE $J SPECIFICITY - KILL 'DLY' NODE
 S KMPVHDAY=""
 F  S KMPVHDAY=$O(^KMPTMP("KMPV","VBEM","DLY",KMPVHDAY)) Q:(KMPVHDAY="")!(KMPVHDAY>KMPVHYDAY)  D
 .S KMPVNODE=""
 .F  S KMPVNODE=$O(^KMPTMP("KMPV","VBEM","DLY",KMPVHDAY,KMPVNODE)) Q:KMPVNODE=""  D
 ..S KMPVTIME=""
 ..F  S KMPVTIME=$O(^KMPTMP("KMPV","VBEM","DLY",KMPVHDAY,KMPVNODE,KMPVTIME)) Q:KMPVTIME=""  D
 ...S KMPVOPT=""
 ...F  S KMPVOPT=$O(^KMPTMP("KMPV","VBEM","DLY",KMPVHDAY,KMPVNODE,KMPVTIME,KMPVOPT)) Q:KMPVOPT=""  D
 ....S KMPVJ="",KMPVDATA="",KMPVJTOT="",KMPVUTOT=0
 ....F  S KMPVJ=$O(^KMPTMP("KMPV","VBEM","DLY",KMPVHDAY,KMPVNODE,KMPVTIME,KMPVOPT,KMPVJ)) Q:KMPVJ=""  D
 .....S KMPVDATA=$G(^KMPTMP("KMPV","VBEM","DLY",KMPVHDAY,KMPVNODE,KMPVTIME,KMPVOPT,KMPVJ))
 .....F KMPVI=1:1:6 S $P(KMPVJTOT,"^",KMPVI)=$P(KMPVDATA,"^",KMPVI)+$P(KMPVJTOT,"^",KMPVI)
 .....S KMPVUTOT=KMPVUTOT+1
 ....S ^KMPTMP("KMPV","VBEM","COMPRESS",KMPVHDAY,KMPVNODE,KMPVOPT,KMPVTIME)=KMPVJTOT_"^"_KMPVUTOT
 .K ^KMPTMP("KMPV","VBEM","DLY",KMPVHDAY)  ; Kill 'daily' node once all data compiled in 'compress' node
 .I $$S^%ZTLOAD G TASKSTOP
 ;
 ; PROCESS 'COMPRESS' NODE FOR TRANSMISSION
 S KMPVHDAY=""
 F  S KMPVHDAY=$O(^KMPTMP("KMPV","VBEM","COMPRESS",KMPVHDAY)) Q:KMPVHDAY=""  D
 .; IF OLDER THAN 'X' DAYS AND NOT MARKED AS SENT SEND ERROR MESSAGE, KILL NODE AND GO TO NEXT DAY
 .I KMPVHDAY<(KMPVHTODAY-KMPVKEEP) D  Q
 ..D CANMESS^KMPVCBG("DELETE","VBEM",KMPVSITE,KMPVHDAY)
 ..K ^KMPTMP("KMPV","VBEM","COMPRESS",KMPVHDAY),^KMPTMP("KMPV","VBEM","DLY",KMPVHDAY)
 .S KMPVFMDAY=+$$HTFM^XLFDT(KMPVHDAY,1)
 .S KMPVWD=$$WORKDAY^XUWORKDY(KMPVFMDAY)  ; IA #10046
 .; RETRANSMISSION FLAG: GREATER THAN ZERO MEANS MESSAGE WAS SENT TO CPE BUT ACK MESSAGE NOT YET REC'D
 .S KMPVRT=$S(+$G(^KMPTMP("KMPV","VBEM","COMPRESS",KMPVHDAY))>0:"YES",1:"NO")
 .; IF BETWEEN 1 AND 7 DAYS OLD AND NOT TRANSMITTED SEND WARNING MESSAGE AND ATTEMPT TO TRANSMIT AGAIN
 .I KMPVHDAY<(KMPVHTODAY-1) D CANMESS^KMPVCBG("TRANWARN","VBEM",KMPVSITE,KMPVHDAY)
 .K ^KMPTMP("KMPV","VBEM","TRANSMIT",$J)
 .S KMPVLN=1
 .S ^KMPTMP("KMPV","VBEM","TRANSMIT",$J,KMPVLN)="SYSTEM ID="_KMPVSINF,KMPVLN=KMPVLN+1
 .S ^KMPTMP("KMPV","VBEM","TRANSMIT",$J,KMPVLN)="UPDATE CONFIG="_KMPVHDAY_U_KMPVWD_"^DAILY",KMPVLN=KMPVLN+1
 .S ^KMPTMP("KMPV","VBEM","TRANSMIT",$J,KMPVLN)="SYSTEM CONFIG="_$$SYSCFG^KMPVCCFG(),KMPVLN=KMPVLN+1
 .S ^KMPTMP("KMPV","VBEM","TRANSMIT",$J,KMPVLN)="MONITOR CONFIG="_$$CFGSTR^KMPVCCFG("VBEM"),KMPVLN=KMPVLN+1
 .S ^KMPTMP("KMPV","VBEM","TRANSMIT",$J,KMPVLN)="RETRANSMISSION="_KMPVRT,KMPVLN=KMPVLN+1
 .S KMPVNODE=""
 .F  S KMPVNODE=$O(^KMPTMP("KMPV","VBEM","COMPRESS",KMPVHDAY,KMPVNODE)) Q:KMPVNODE=""  D
 ..S KMPVOPT=""
 ..F  S KMPVOPT=$O(^KMPTMP("KMPV","VBEM","COMPRESS",KMPVHDAY,KMPVNODE,KMPVOPT)) Q:KMPVOPT=""  D
 ...S KMPVTIME=""
 ...F  S KMPVTIME=$O(^KMPTMP("KMPV","VBEM","COMPRESS",KMPVHDAY,KMPVNODE,KMPVOPT,KMPVTIME)) Q:KMPVTIME=""  D
 ....S KMPVDATA=$G(^KMPTMP("KMPV","VBEM","COMPRESS",KMPVHDAY,KMPVNODE,KMPVOPT,KMPVTIME))
 ....S ^KMPTMP("KMPV","VBEM","TRANSMIT",$J,KMPVLN)="VBEM DATA="_KMPVNODE_U_KMPVOPT_U_KMPVTIME_U_KMPVDATA,KMPVLN=KMPVLN+1
 .D TRANSMIT
 .I $$S^%ZTLOAD G TASKSTOP
 D STRSTP^KMPVCCFG("VBEM",KMPVHSTRT)
 ;  Let TaskMan know the job is complete
 S ZTREQ="@"
 Q
 ;
TRANSMIT ; Transmit data
 ; quit if no data to transmit.
 Q:'$D(^KMPTMP("KMPV","VBEM","TRANSMIT",$J))
 N KMPVEMAIL,X,XMSUB,XMTEXT,XMY,XMZ
 ; send packman message.
 S XMTEXT="^KMPTMP(""KMPV"",""VBEM"",""TRANSMIT"","_$J_","
 S XMSUB="VBEM DAILY DATA"
 S KMPVEMAIL=$$GETVAL^KMPVCCFG("VBEM","NATIONAL DATA EMAIL ADDRESS",8969) I KMPVEMAIL'="" S XMY(KMPVEMAIL)=""
 D ^XMD
 ; RECORD SUCCESS/FAILURE -- SEND MESSAGE IF FAILURE
 I +$G(XMZ)>0 D
 .S ^KMPTMP("KMPV","VBEM","COMPRESS",KMPVHDAY)=XMZ
 E  D CANMESS^KMPVCBG("FAILTRAN","VBEM",KMPVSITE,KMPVHDAY)
 K ^KMPTMP("KMPV","VBEM","TRANSMIT",$J)
 Q
 ;
TASKSTOP ; Clean-up code if task Stopped via TaskMan
 D STRSTP^KMPVCCFG("VBEM",KMPVHSTRT)
 ;  Let TaskMan know the job is complete
 S ZTREQ="@"
 S ZTSTOP=1
 Q
