XLFSHANT ; OSE/SMH - SHA secure hash routines tests ;2018-06-12  3:08 PM
 ;;8.0;KERNEL;**10003**;Jul 10, 1995;Build 9
 ;=============================
 ;Tests
 ;Test vectors from http://www.di-mgt.com.au/sha_testvectors.html
 ;Format is msg:message:reps
 ;Followed by hash:hash length:HASH
 ;=============================
TEST I $T(^%ut)="" QUIT
 W $$CJ^XLFSTR("Testing w/ openssl plug-in",$G(IOM,80),"=")
 D EN^%ut($t(+0),3)
 n %utNoOpenssl s %utNoOpenssl=1
 I +$SY=47,$ZV["Darwin" QUIT  ; Darwin doesn't have all the command line sha programs.
 W !!
 W $$CJ^XLFSTR("Testing s/ openssl plug-in",$G(IOM,80),"=")
 D EN^%ut($t(+0),3)
 QUIT
 ;
T1 ; @TEST $$SHAN w/ null string
 N DATA S DATA=$T(TDATA1+1),DATA=$P(DATA,";;",2)
 N STR,REPS
 S STR=$P(DATA,":",2),REPS=$P(DATA,":",3)
 ;
 N L160 S L160=$T(TDATA1+2),L160=$P(L160,";;",2)
 N H160 S H160=$P(L160,":",2)
 N R160 S R160=$P(L160,":",3),R160=$TR(R160," ")
 D CHKEQ^%ut(R160,$$SHAN^XLFSHAN(H160,STR))
 ;
 N L224 S L224=$T(TDATA1+3),L224=$P(L224,";;",2)
 N H224 S H224=$P(L224,":",2)
 N R224 S R224=$P(L224,":",3),R224=$TR(R224," ")
 D CHKEQ^%ut(R224,$$SHAN^XLFSHAN(H224,STR))
 ;
 N L256 S L256=$T(TDATA1+4),L256=$P(L256,";;",2)
 N H256 S H256=$P(L256,":",2)
 N R256 S R256=$P(L256,":",3),R256=$TR(R256," ")
 D CHKEQ^%ut(R256,$$SHAN^XLFSHAN(H256,STR))
 ;
 N L384 S L384=$T(TDATA1+5),L384=$P(L384,";;",2)
 N H384 S H384=$P(L384,":",2)
 N R384 S R384=$P(L384,":",3),R384=$TR(R384," ")
 D CHKEQ^%ut(R384,$$SHAN^XLFSHAN(H384,STR))
 ;
 N L512 S L512=$T(TDATA1+6),L512=$P(L512,";;",2)
 N H512 S H512=$P(L512,":",2)
 N R512 S R512=$P(L512,":",3),R512=$TR(R512," ")
 D CHKEQ^%ut(R512,$$SHAN^XLFSHAN(H512,STR))
 ;
 QUIT
 ;
TDATA1 ; @DATA
 ;;msg::1
 ;;hash:160:DA39A3EE 5E6B4B0D 3255BFEF 95601890 AFD80709
 ;;hash:224:D14A028C 2A3A2BC9 476102BB 288234C4 15A2B01F 828EA62A C5B3E42F
 ;;hash:256:E3B0C442 98FC1C14 9AFBF4C8 996FB924 27AE41E4 649B934C A495991B 7852B855
 ;;hash:384:38B060A7 51AC9638 4CD9327E B1B1E36A 21FDB711 14BE0743 4C0CC7BF 63F6E1DA 274EDEBF E76F65FB D51AD2F1 4898B95B
 ;;hash:512:CF83E135 7EEFB8BD F1542850 D66D8007 D620E405 0B5715DC 83F4A921 D36CE9CE 47D0D13C 5D85F2B0 FF8318D2 877EEC2F 63B931BD 47417A81 A538327A F927DA3E
 ;;-1
 ;
T2 ; @TEST $$SHAN w/ string of abc
 N DATA S DATA=$T(TDATA2+1),DATA=$P(DATA,";;",2)
 N STR,REPS
 S STR=$P(DATA,":",2),REPS=$P(DATA,":",3)
 ;
 N L160 S L160=$T(TDATA2+2),L160=$P(L160,";;",2)
 N H160 S H160=$P(L160,":",2)
 N R160 S R160=$P(L160,":",3),R160=$TR(R160," ")
 D CHKEQ^%ut(R160,$$SHAN^XLFSHAN(H160,STR))
 ;
 N L224 S L224=$T(TDATA2+3),L224=$P(L224,";;",2)
 N H224 S H224=$P(L224,":",2)
 N R224 S R224=$P(L224,":",3),R224=$TR(R224," ")
 D CHKEQ^%ut(R224,$$SHAN^XLFSHAN(H224,STR))
 ;
 N L256 S L256=$T(TDATA2+4),L256=$P(L256,";;",2)
 N H256 S H256=$P(L256,":",2)
 N R256 S R256=$P(L256,":",3),R256=$TR(R256," ")
 D CHKEQ^%ut(R256,$$SHAN^XLFSHAN(H256,STR))
 ;
 N L384 S L384=$T(TDATA2+5),L384=$P(L384,";;",2)
 N H384 S H384=$P(L384,":",2)
 N R384 S R384=$P(L384,":",3),R384=$TR(R384," ")
 D CHKEQ^%ut(R384,$$SHAN^XLFSHAN(H384,STR))
 ;
 N L512 S L512=$T(TDATA2+6),L512=$P(L512,";;",2)
 N H512 S H512=$P(L512,":",2)
 N R512 S R512=$P(L512,":",3),R512=$TR(R512," ")
 D CHKEQ^%ut(R512,$$SHAN^XLFSHAN(H512,STR))
 QUIT
 ;
TDATA2 ; @DATA
 ;;msg:abc:1
 ;;hash:160:A9993E36 4706816A BA3E2571 7850C26C 9CD0D89D
 ;;hash:224:23097D22 3405D822 8642A477 BDA255B3 2AADBCE4 BDA0B3F7 E36C9DA7
 ;;hash:256:BA7816BF 8F01CFEA 414140DE 5DAE2223 B00361A3 96177A9C B410FF61 F20015AD
 ;;hash:384:CB00753F 45A35E8B B5A03D69 9AC65007 272C32AB 0EDED163 1A8B605A 43FF5BED 8086072B A1E7CC23 58BAECA1 34C825A7
 ;;hash:512:DDAF35A1 93617ABA CC417349 AE204131 12E6FA4E 89A97EA2 0A9EEEE6 4B55D39A 2192992A 274FC1A8 36BA3C23 A3FEEBBD 454D4423 643CE80E 2A9AC94F A54CA49F
 ;;-1
 ;
T3 ; @TEST $$SHAN w/ long string
 N DATA S DATA=$T(TDATA3+1),DATA=$P(DATA,";;",2)
 N STR,REPS
 S STR=$P(DATA,":",2),REPS=$P(DATA,":",3)
 ;
 N L160 S L160=$T(TDATA3+2),L160=$P(L160,";;",2)
 N H160 S H160=$P(L160,":",2)
 N R160 S R160=$P(L160,":",3),R160=$TR(R160," ")
 D CHKEQ^%ut(R160,$$SHAN^XLFSHAN(H160,STR))
 ;
 N L224 S L224=$T(TDATA3+3),L224=$P(L224,";;",2)
 N H224 S H224=$P(L224,":",2)
 N R224 S R224=$P(L224,":",3),R224=$TR(R224," ")
 D CHKEQ^%ut(R224,$$SHAN^XLFSHAN(H224,STR))
 ;
 N L256 S L256=$T(TDATA3+4),L256=$P(L256,";;",2)
 N H256 S H256=$P(L256,":",2)
 N R256 S R256=$P(L256,":",3),R256=$TR(R256," ")
 D CHKEQ^%ut(R256,$$SHAN^XLFSHAN(H256,STR))
 ;
 N L384 S L384=$T(TDATA3+5),L384=$P(L384,";;",2)
 N H384 S H384=$P(L384,":",2)
 N R384 S R384=$P(L384,":",3),R384=$TR(R384," ")
 D CHKEQ^%ut(R384,$$SHAN^XLFSHAN(H384,STR))
 ;
 N L512 S L512=$T(TDATA3+6),L512=$P(L512,";;",2)
 N H512 S H512=$P(L512,":",2)
 N R512 S R512=$P(L512,":",3),R512=$TR(R512," ")
 D CHKEQ^%ut(R512,$$SHAN^XLFSHAN(H512,STR))
 QUIT
 ;
TDATA3 ; @DATA
 ;;msg:abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq:1
 ;;hash:160:84983E44 1C3BD26E BAAE4AA1 F95129E5 E54670F1
 ;;hash:224:75388B16 512776CC 5DBA5DA1 FD890150 B0C6455C B4F58B19 52522525
 ;;hash:256:248D6A61 D20638B8 E5C02693 0C3E6039 A33CE459 64FF2167 F6ECEDD4 19DB06C1
 ;;hash:384:3391FDDD FC8DC739 3707A65B 1B470939 7CF8B1D1 62AF05AB FE8F450D E5F36BC6 B0455A85 20BC4E6F 5FE95B1F E3C8452B
 ;;hash:512:204A8FC6 DDA82F0A 0CED7BEB 8E08A416 57C16EF4 68B228A8 279BE331 A703C335 96FD15C1 3B1B07F9 AA1D3BEA 57789CA0 31AD85C7 A71DD703 54EC6312 38CA3445
 ;;-1
 ;
T4 ; @TEST $$SHAN w/ even longer string
 N DATA S DATA=$T(TDATA4+1),DATA=$P(DATA,";;",2)
 N STR,REPS
 S STR=$P(DATA,":",2),REPS=$P(DATA,":",3)
 ;
 N L160 S L160=$T(TDATA4+2),L160=$P(L160,";;",2)
 N H160 S H160=$P(L160,":",2)
 N R160 S R160=$P(L160,":",3),R160=$TR(R160," ")
 D CHKEQ^%ut(R160,$$SHAN^XLFSHAN(H160,STR))
 ;
 N L224 S L224=$T(TDATA4+3),L224=$P(L224,";;",2)
 N H224 S H224=$P(L224,":",2)
 N R224 S R224=$P(L224,":",3),R224=$TR(R224," ")
 D CHKEQ^%ut(R224,$$SHAN^XLFSHAN(H224,STR))
 ;
 N L256 S L256=$T(TDATA4+4),L256=$P(L256,";;",2)
 N H256 S H256=$P(L256,":",2)
 N R256 S R256=$P(L256,":",3),R256=$TR(R256," ")
 D CHKEQ^%ut(R256,$$SHAN^XLFSHAN(H256,STR))
 ;
 N L384 S L384=$T(TDATA4+5),L384=$P(L384,";;",2)
 N H384 S H384=$P(L384,":",2)
 N R384 S R384=$P(L384,":",3),R384=$TR(R384," ")
 D CHKEQ^%ut(R384,$$SHAN^XLFSHAN(H384,STR))
 ;
 N L512 S L512=$T(TDATA4+6),L512=$P(L512,";;",2)
 N H512 S H512=$P(L512,":",2)
 N R512 S R512=$P(L512,":",3),R512=$TR(R512," ")
 D CHKEQ^%ut(R512,$$SHAN^XLFSHAN(H512,STR))
 QUIT
 ;
TDATA4 ; @DATA
 ;;msg:abcdefghbcdefghicdefghijdefghijkefghijklfghijklmghijklmnhijklmnoijklmnopjklmnopqklmnopqrlmnopqrsmnopqrstnopqrstu:1
 ;;hash:160:A49B2446 A02C645B F419F995 B6709125 3A04A259
 ;;hash:224:C97CA9A5 59850CE9 7A04A96D EF6D99A9 E0E0E2AB 14E6B8DF 265FC0B3
 ;;hash:256:CF5B16A7 78AF8380 036CE59E 7B049237 0B249B11 E8F07A51 AFAC4503 7AFEE9D1
 ;;hash:384:09330C33 F71147E8 3D192FC7 82CD1B47 53111B17 3B3B05D2 2FA08086 E3B0F712 FCC7C71A 557E2DB9 66C3E9FA 91746039
 ;;hash:512:8E959B75 DAE313DA 8CF4F728 14FC143F 8F7779C6 EB9F7FA1 7299AEAD B6889018 501D289E 4900F7E4 331B99DE C4B5433A C7D329EE B6DD2654 5E96E55B 874BE909
 ;;-1
T5 ; @TEST $$LSHAN w/ 1MiB str of 'a'
 N DATA S DATA=$T(TDATA5+1),DATA=$P(DATA,";;",2)
 N STR,REPS
 S STR=$P(DATA,":",2),REPS=$P(DATA,":",3)
 N NBLOCKS
 D TMPLOAD^XLFSHAN("XLFMSG",1024,STR,REPS,.NBLOCKS)
 ;
 N L160 S L160=$T(TDATA5+2),L160=$P(L160,";;",2)
 N H160 S H160=$P(L160,":",2)
 N R160 S R160=$P(L160,":",3),R160=$TR(R160," ")
 D CHKEQ^%ut(R160,$$LSHAN^XLFSHAN(H160,"XLFMSG",NBLOCKS))
 ;
 N L224 S L224=$T(TDATA5+3),L224=$P(L224,";;",2)
 N H224 S H224=$P(L224,":",2)
 N R224 S R224=$P(L224,":",3),R224=$TR(R224," ")
 D CHKEQ^%ut(R224,$$LSHAN^XLFSHAN(H224,"XLFMSG",NBLOCKS))
 ;
 N L256 S L256=$T(TDATA5+4),L256=$P(L256,";;",2)
 N H256 S H256=$P(L256,":",2)
 N R256 S R256=$P(L256,":",3),R256=$TR(R256," ")
 D CHKEQ^%ut(R256,$$LSHAN^XLFSHAN(H256,"XLFMSG",NBLOCKS))
 ;
 N L384 S L384=$T(TDATA5+5),L384=$P(L384,";;",2)
 N H384 S H384=$P(L384,":",2)
 N R384 S R384=$P(L384,":",3),R384=$TR(R384," ")
 D CHKEQ^%ut(R384,$$LSHAN^XLFSHAN(H384,"XLFMSG",NBLOCKS))
 ;
 N L512 S L512=$T(TDATA5+6),L512=$P(L512,";;",2)
 N H512 S H512=$P(L512,":",2)
 N R512 S R512=$P(L512,":",3),R512=$TR(R512," ")
 D CHKEQ^%ut(R512,$$LSHAN^XLFSHAN(H512,"XLFMSG",NBLOCKS))
 QUIT
 ;
TDATA5 ; @DATA
 ;;msg:a:1000000
 ;;hash:160:34AA973C D4C4DAA4 F61EEB2B DBAD2731 6534016F
 ;;hash:224:20794655 980C91D8 BBB4C1EA 97618A4B F03F4258 1948B2EE 4EE7AD67
 ;;hash:256:CDC76E5C 9914FB92 81A1C7E2 84D73E67 F1809A48 A497200E 046D39CC C7112CD0
 ;;hash:384:9D0E1809 716474CB 086E834E 310A4A1C ED149E9C 00F24852 7972CEC5 704C2A5B 07B8B3DC 38ECC4EB AE97DDD8 7F3D8985
 ;;hash:512:E718483D 0CE76964 4E2E42C7 BC15B463 8E1F98B1 3B204428 5632A803 AFA973EB DE0FF244 877EA60A 4CB0432C E577C31B EB009C5C 2C49AA2E 4EADB217 AD8CC09B
 ;;-1
 ;
 ;=============================
TROU ; @TEST $$ROUTINE^XLFSHAN
 N H S H=$$ROUTINE^XLFSHAN(256,$T(+0))
 D CHKEQ^%ut($L(H),64)
 QUIT
 ;
TGLO ; @TEST $$GLOBAL^XLFSHAN
 N H S H=$$GLOBAL^XLFSHAN(256,200,1)
 D CHKEQ^%ut($L(H),64)
 QUIT
 ;
TFILE ; @TEST $$FILE^XLFSHAN
 N H S H=$$FILE^XLFSHAN(256,811.5,1)
 D CHKEQ^%ut($L(H),64)
 QUIT
 ;
THOST ; @TEST $$HOSTFILE^XLFSHAN
 N D S D=$$DEFDIR^%ZISH
 N POP
 D OPEN^%ZISH("F1",D,"test_file.txt","W") Q:POP
 U IO
 N X S $P(X,"a",1024)="a"
 N I F I=1:1:1024 W X
 D CLOSE^%ZISH("F1")
 N H S H=$$HOSTFILE^XLFSHAN(256,D,"test_file.txt")
 D CHKEQ^%ut($L(H),64)
 N % S %=$$DEL1^%ZISH(D_"test_file.txt")
 QUIT
