KMPVVHLM ;SP/JML - Collecthl7 Metrics for the VistA HL7 Monitor ;5/1/2017
 ;;4.0;CAPACITY MANAGEMENT;;3/1/2018
 ;
 ;
 ;
RUN ; Collect metrics per configured interval and store in ^KMPTMP("KMPV","VHLM","DLY" -- CALLED VIA CACHE TASK MANAGER
 ;
 ;-----------------------------------------------------------------------
 ;  NOTE:  this routine is written to be tasked off daily at 2:00 AM via the VistA Task Manager.
 ;
 ; ^KMPTMP("KMPV","VHLM","DLY"... storage of data for current day
 ; ^KMPTMP("KMPV","VHLM","TRANSMIT",$J)............. temporary storage for daily VTCM data to be transmitted
 ;   Data in "TRANSMIT" node is deleted upon transmission
 ;   Data in "DLY" node:
 ;    "DLY" Data marked with message number upon transmission - deleted upon Acknowledgement of receipt from server.
 ;    IF DATA MORE THAN 7 DAYS OLD SEND ERROR MESSAGE TO CPE GROUP AND DELETE DATA
 ;    IF DATA MORE THAN 1 DAY OLD SEND WARNING MESSAGE TO CPE GROUP AND SEND DATA
 ;    IF DATA 1 DAY OLD SEND DATA
 ;
 ;-----------------------------------------------------------------------
 ; Data Read IAs
 ; 6877 - Read access to HL7 MESSAGE TEXT file for capacity planning
 ; 6878 - Read access to FILE 773 for capacity planning
 ; 6882 - Read access to HLO MESSAGE BODY file for capacity planning
 ; 6883 - Read access to HLO MESSAGES file for capacity planning
 ;
 N KMPVTEST,KMPSINT,KMPDAY,KMPVNODE,Y,KMPMT,KMPVHSTRT
 S KMPVHSTRT=$H
 ; ALWAYS - verify data is not building past configured number of days - if so for any reason, delete it
 D PURGEDLY^KMPVCBG("VHLM") ;
 ; Quit if monitor is not turned on
 Q:$$GETVAL^KMPVCCFG("VHLM","ONOFF",8969)'="ON"
 ; Check environment
 S KMPVTEST=$$GETVAL^KMPVCCFG("VHLM","ALLOW TEST SYSTEM",8969,"I")
 I $$PROD^KMPVCCFG'="Prod",KMPVTEST'=1 Q
 S U="^"
 D GETENV^%ZOSV S KMPVNODE=$P(Y,U,3)_":"_$P($P(Y,U,4),":",2) ;  IA 10097
 ; Quit if not BE node or if Allow Test System is NO
 I $$ISBENODE^KMPVCCFG(KMPVNODE)=0&(KMPVTEST=0) Q
 ;
 S KMPDAY=$$DT^XLFDT-1
 D COLLECT(KMPDAY)
 D STRSTP^KMPVCCFG("VHLM",KMPVHSTRT)
 Q
 ;
COLLECT(KMPDAY) ;
 S KMPSINT=$$GETVAL^KMPVCCFG("VHLM","COLLECTION INTERVAL",8969)
 D AGGRAGAT(KMPDAY)
 D PREPARE
 Q
 ;
 ;
AGGRAGAT(KMPDAY) ;
 N KMPSTIME,KMPMDT,KMPEND,KMPI772,KMPI773,KMPMA0,KMPMSH,KMPMAS,KMPMAP,K7720,K772S,KMPDTTM,KMPTRAN,KMPPRI,KMPHTYP,KMPIEN,KMPLL,KMPSPROT,KMPEPROT,KMPAA,KMPHDAY
 N KMPMTYP,KMPETYP,KMPD1,KMPSAPP,KMPRAPP,KMPSSITE,KMPRSITE,KMPNS,KMPTCHAR,KMPTEVTS,KMPTTIME,KMPPTCA,KMPTAA,KMPTSENT,KMPCDAT,KMPDATA,KMPI,KMPSYNC,KMPTCA
 ;
 S X=KMPDAY D H^%DTC S KMPHDAY=%H
 K ^KMPTMP("KMPV","VHLM","DLY",KMPHDAY)
 S KMPMDT=KMPDAY-.000001
 S KMPEND=KMPDAY+.999999
 F  S KMPMDT=$O(^HL(772,"B",KMPMDT)) Q:KMPMDT=""!(KMPMDT>KMPEND)  D
 .S KMPI772=0
 .F  S KMPI772=$O(^HL(772,"B",KMPMDT,KMPI772)) Q:KMPI772=""  D
 ..S KMPI773=""
 ..F  S KMPI773=$O(^HLMA("B",KMPI772,KMPI773)) Q:KMPI773=""  D
 ...S KMPMA0=$G(^HLMA(KMPI773,0)),KMPMSH=$G(^HLMA(KMPI773,"MSH",1,0))
 ...S KMPMAS=$G(^HLMA(KMPI773,"S")),KMPMAP=$G(^HLMA(KMPI773,"P"))
 ...S K7720=$G(^HL(772,KMPI772,0)),K772S=$G(^HL(772,KMPI772,"S"))
 ...Q:$P(KMPMA0,"^",6)'=KMPI773  ; Has parent, Local,parent will be counted
 ...S KMPDTTM=$P(K7720,U)
 ...S KMPTRAN=$P(KMPMA0,U,3)
 ...S KMPPRI=$P(KMPMA0,U,4)
 ...S KMPHTYP=$P(KMPMA0,U,5) I KMPHTYP="" S KMPHTYP=$P(K7720,U,14)
 ...S KMPLL="",KMPIEN=$P(KMPMA0,U,7) I KMPIEN'="" S KMPLL=$P($G(^HLCS(870,KMPIEN,0)),U)
 ...S KMPIEN=$P(KMPMA0,U,8),KMPSPROT=$$GET1^DIQ(101,KMPIEN,.01,"","","")
 ...S KMPIEN=$P(K7720,U,10),KMPEPROT=$$GET1^DIQ(101,KMPIEN,.01,"","","")
 ...S KMPIEN=$P(KMPMA0,U,13),KMPMTYP="" I KMPIEN'="" S KMPMTYP=$P($G(^HL(771.2,KMPIEN,0)),U)
 ...S KMPIEN=$P(KMPMA0,U,14),KMPETYP="" I KMPIEN'="" S KMPETYP=$P($G(^HL(779.001,KMPIEN,0)),U)
 ...; parse out site info with correct delimiters
 ...S KMPD1=$E(KMPMSH,4),KMPDELS=$P(KMPMSH,KMPD1,2),KMPD2=$E(KMPDELS,1)
 ...S KMPSAPP=$P(KMPMSH,KMPD1,3),KMPRAPP=$P(KMPMSH,KMPD1,5)
 ...S KMPSEND=$P(KMPMSH,KMPD1,4),KMPSNUM=$P(KMPSEND,KMPD2),KMPSFQDN=$P(KMPSEND,KMPD2,2),KMPSDNS=$P(KMPSEND,KMPD2,3)
 ...S KMPSSITE=KMPSNUM_"~"_KMPSFQDN_"~"_KMPSDNS
 ...S KMPREC=$P(KMPMSH,KMPD1,6),KMPRNUM=$P(KMPREC,KMPD2),KMPRFQDN=$P(KMPREC,KMPD2,2),KMPRDNS=$P(KMPREC,KMPD2,3)
 ...S KMPRSITE=KMPRNUM_"~"_KMPRFQDN_"~"_KMPRDNS
 ...;
 ...S KMPAA=$P(KMPMSH,KMPD1,16),KMPSYNC=$S(KMPAA="AL":"SYNC",1:"ASYNC")
 ...S KMPNS=$P(K7720,U,13),KMPTCHAR=$P(K772S,U)+$L(KMPMSH)
 ...S KMPTEVTS=$P(K772S,U,2),KMPTTIME=$P(K772S,U,3)
 ...S (KMPTCA,KMPTAA)=""
 ...S KMPTSENT=$P(KMPMAS,U,3)
 ...I KMPTSENT'="" D
 ....S KMPTCA=$P(KMPMAS,U,4),KMPTAA=$P(KMPMAS,U,5)
 ....S KMPTCA=$$FMDIFF^XLFDT(KMPTCA,KMPTSENT,2)
 ....S KMPTAA=$$FMDIFF^XLFDT(KMPTAA,KMPTSENT,2)
 ...S KMPCDAT=1_U_KMPTCHAR_U_KMPTEVTS_U_KMPTTIME_U_KMPTCA_U_KMPTAA
 ...; GET SLOT TIME
 ...S KMPSTIME=$$SLOT^KMPVCCFG(KMPMDT,KMPSINT,"FILEMAN")
 ...; Can't be null
 ...F KMPVAR="KMPTRAN","KMPPRI","KMPHTYP","KMPLL","KMPSPROT","KMPEPROT","KMPMTYP","KMPETYP","KMPSAPP","KMPRAPP","KMPSSITE","KMPRSITE" I @KMPVAR="" S @KMPVAR="X"
 ...; SET DATA
 ...I KMPSYNC="ASYNC" D
 ....S KMPDATA=$G(^KMPTMP("KMPV","VHLM","DLY",KMPHDAY,"ASYNC",KMPSTIME,KMPTRAN,KMPPRI,KMPHTYP,KMPLL,KMPSPROT,KMPEPROT,KMPMTYP,KMPETYP,KMPSAPP,KMPRAPP,KMPSSITE,KMPRSITE))
 ....F KMPI=1:1:4 S $P(KMPDATA,U,KMPI)=$P(KMPDATA,U,KMPI)+$P(KMPCDAT,U,KMPI)
 ....S ^KMPTMP("KMPV","VHLM","DLY",KMPHDAY,"ASYNC",KMPSTIME,KMPTRAN,KMPPRI,KMPHTYP,KMPLL,KMPSPROT,KMPEPROT,KMPMTYP,KMPETYP,KMPSAPP,KMPRAPP,KMPSSITE,KMPRSITE)=KMPDATA
 ...I KMPSYNC="SYNC" D
 ....S KMPDATA=$G(^KMPTMP("KMPV","VHLM","DLY",KMPHDAY,"SYNC",KMPSTIME,KMPTRAN,KMPPRI,KMPHTYP,KMPLL,KMPSPROT,KMPEPROT,KMPMTYP,KMPETYP,KMPSAPP,KMPRAPP,KMPSSITE,KMPRSITE))
 ....F KMPI=1:1:6 S $P(KMPDATA,U,KMPI)=$P(KMPDATA,U,KMPI)+$P(KMPCDAT,U,KMPI)
 ....S ^KMPTMP("KMPV","VHLM","DLY",KMPHDAY,"SYNC",KMPSTIME,KMPTRAN,KMPPRI,KMPHTYP,KMPLL,KMPSPROT,KMPEPROT,KMPMTYP,KMPETYP,KMPSAPP,KMPRAPP,KMPSSITE,KMPRSITE)=KMPDATA
 ; Aggragate HLO data
 N KI,KMPADT,KMPAMEVT,KMPAMTYP,KMPD1,KMPD2,KMPDELS,KMPDIR,KMPHLA,KMPHLA0,KMPHLB,KMPHLB0,KMPMLEN,KMPMSH,KMPQUE,KMPRDNS,KMPREC,KMPRFQDN,KMPRNUM,KMPSDNS
 N KMPSEND,KMPSFQDN,KMPSNUM,KMPTLEN,KMPTYP,KMPVAR
 S KMPMDT=KMPDAY-.000001
 S KMPEND=KMPDAY+.999999
 F  S KMPMDT=$O(^HLA("B",KMPMDT)) Q:KMPMDT=""!(KMPMDT>KMPEND)  D
 .S KMPHLA=0
 .F  S KMPHLA=$O(^HLA("B",KMPMDT,KMPHLA)) Q:KMPHLA=""  D
 ..S KMPHLB=""
 ..F  S KMPHLB=$O(^HLB("C",KMPHLA,KMPHLB)) Q:KMPHLB=""  D
 ...S KMPHLA0=$G(^HLA(KMPHLA,0))
 ...S KMPHLB0=$G(^HLB(KMPHLB,0))
 ...;
 ...S KMPMLEN=0,KI=0 ; CALCULATE TOTAL LENGTH OF MESSAGE BODY
 ...F  S KI=$O(^HLA(KMPHLA,1,KI)) Q:KI=""  S KMPMLEN=KMPMLEN+$L(^HLA(KMPHLA,1,KI,0))
 ...S KMPMSH=^HLB(KMPHLB,1)_^HLB(KMPHLB,2)
 ...S KMPTLEN=KMPMLEN+$L(KMPMSH)
 ...; fields from HLA - (required)
 ...S KMPADT=$P(KMPHLA0,"^"),KMPAMTYP=$P(KMPHLA0,"^",3),KMPAMEVT=$P(KMPHLA0,"^",4)
 ...; fields from HLB
 ...S KMPTYP=$S($P(KMPHLB0,"^",3)="":"PRIME",1:"ACK")
 ...S KMPDIR=$P(KMPHLB0,"^",4),KMPLL=$P(KMPHLB0,"^",5),KMPQUE=$P(KMPHLB0,"^",6)
 ...; fields from MSH Header
 ...S KMPD1=$E(KMPMSH,4),KMPDELS=$P(KMPMSH,KMPD1,2),KMPD2=$E(KMPDELS,1)
 ...S KMPSAPP=$P(KMPMSH,KMPD1,3),KMPRAPP=$P(KMPMSH,KMPD1,5)
 ...; parse out site info with correct delimiters
 ...S KMPSEND=$P(KMPMSH,KMPD1,4),KMPSNUM=$P(KMPSEND,KMPD2),KMPSFQDN=$P(KMPSEND,KMPD2,2),KMPSDNS=$P(KMPSEND,KMPD2,3)
 ...S KMPSSITE=KMPSNUM_"~"_KMPSFQDN_"~"_KMPSDNS
 ...S KMPREC=$P(KMPMSH,KMPD1,6),KMPRNUM=$P(KMPREC,KMPD2),KMPRFQDN=$P(KMPREC,KMPD2,2),KMPRDNS=$P(KMPREC,KMPD2,3)
 ...S KMPRSITE=KMPRNUM_"~"_KMPRFQDN_"~"_KMPRDNS
 ...S KMPAA=$P(KMPMSH,KMPD1,16),KMPSYNC=$S(KMPAA="AL":"SYNCH",1:"ASYNC")
 ...; GET SLOT TIME
 ...S KMPSTIME=$$SLOT^KMPVCCFG(KMPADT,KMPSINT,"FILEMAN")
 ...; can't be null
 ...F KMPVAR="KMPSYNC","KMPTYP","KMPDIR","KMPAMTYP","KMPAMEVT","KMPLL","KMPQUE","KMPSAPP","KMPSSITE","KMPRAPP","KMPRSITE" I @KMPVAR="" S @KMPVAR="X"
 ...S KMPCDAT=1_U_KMPTLEN
 ...S KMPDATA=$G(^KMPTMP("KMPV","VHLM","DLY",KMPHDAY,"HLO",KMPSTIME,KMPSYNC,KMPTYP,KMPDIR,KMPAMTYP,KMPAMEVT,KMPLL,KMPQUE,KMPSAPP,KMPSSITE,KMPRAPP,KMPRSITE))
 ...F KMPI=1:1:2 S $P(KMPDATA,U,KMPI)=$P(KMPDATA,U,KMPI)+$P(KMPCDAT,U,KMPI)
 ...S ^KMPTMP("KMPV","VHLM","DLY",KMPHDAY,"HLO",KMPSTIME,KMPSYNC,KMPTYP,KMPDIR,KMPAMTYP,KMPAMEVT,KMPLL,KMPQUE,KMPSAPP,KMPSSITE,KMPRAPP,KMPRSITE)=KMPCDAT
 Q
PREPARE ; PUT DATA INTO FORM FOR SENDING
 ;
 N K1,K2,K3,K4,K5,K6,K7,K8,K9,K10,K11,K12,K13,KMPLNST,KMPTMP
 N KMPVHSTRT,KMPVHTODAY,KMPVSITE,KMPVLAST,X,KMPVHLAST,KMPVKEEP,KMPVSINF,KMPVHDAY,KMPVHYDAY,KMPVFMDAY,KMPVWD,KMPVRT,KMPVLN,KMPSET
 ;
 N %H
 K ^KMPTMP("KMPV","VHLM","TRANSMIT",$J)
 I $G(KMPVHSTRT)="" S KMPVHSTRT=$H
 S KMPVHTODAY=+KMPVHSTRT,KMPVSITE=$$SITE^VASITE ;  IA 10112
 S KMPVHYDAY=+$H-1
 S KMPVLAST=$$GETVAL^KMPVCCFG("VHLM","LAST START TIME",8969,"I")
 I KMPVLAST'="" D
 .S X=KMPVLAST D H^%DTC S KMPVHLAST=%H
 .I KMPVHLAST<KMPVHYDAY D CANMESS^KMPVCBG("JOBLATE","VHLM",KMPVSITE,(KMPVHYDAY-KMPVHLAST))
 ;
 S KMPVKEEP=$$GETVAL^KMPVCCFG("VHLM","DAYS TO KEEP DATA",8969)
 S KMPVSINF=$$SITEINFO^KMPVCCFG()
 S KMPVHDAY=""
 F  S KMPVHDAY=$O(^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY)) Q:KMPVHDAY=""!(KMPVHDAY>KMPVHYDAY)  D
 .; IF OLDER THAN 7 DAYS AND NOT MARKED AS SENT SEND ERROR MESSAGE, KILL NODE AND GO TO NEXT DAY
 .I KMPVHDAY<(KMPVHTODAY-KMPVKEEP) D  Q
 ..D CANMESS^KMPVCBG("DELETE","VHLM",KMPVSITE,KMPVHDAY) K ^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY)
 .S KMPVFMDAY=+$$HTFM^XLFDT(KMPVHDAY,1)
 .S KMPVWD=$$WORKDAY^XUWORKDY(KMPVFMDAY) ; IA#10046
 .; RETRANSMISSION FLAG: GREATER THAN ZERO MEANS MESSAGE WAS SENT TO CPE BUT ACK MESSAGE NOT YET REC'D
 .S KMPVRT=$S(+$G(^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY))>0:"YES",1:"NO")
 .; IF BETWEEN 1 AND 7 DAYS OLD AND NOT TRANSMITTED SEND WARNING MESSAGE AND ATTEMPT TO TRANSMIT AGAIN
 .I KMPVHDAY<(KMPVHTODAY-1) D CANMESS^KMPVCBG("TRANWARN","VHLM",KMPVSITE,KMPVHDAY)
 .;
 .; PREPARE HEADER NODES
 .S KMPTMP(1)="SYSTEM ID="_KMPVSINF
 .S KMPTMP(2)="UPDATE CONFIG="_KMPVHDAY_U_KMPVWD_"^DAILY"
 .S KMPTMP(3)="SYSTEM CONFIG="_$$SYSCFG^KMPVCCFG()
 .S KMPTMP(4)="MONITOR CONFIG="_$$CFGSTR^KMPVCCFG("VHLM")
 .S KMPTMP(5)="RETRANSMISSION="_KMPVRT
 .S KMPLNST=7
 .K ^KMPTMP("KMPV","VHLM","TRANSMIT",$J)
 .S KMPVLN=KMPLNST ; SET HEADER NODES ONLY IF THERE IS DATA
 .S K1=""
 .F  S K1=$O(^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY,"ASYNC",K1)) Q:K1=""  D
 ..S K2=""
 ..F  S K2=$O(^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY,"ASYNC",K1,K2)) Q:K2=""  D
 ...S K3=""
 ...F  S K3=$O(^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY,"ASYNC",K1,K2,K3)) Q:K3=""  D
 ....S K4=""
 ....F  S K4=$O(^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY,"ASYNC",K1,K2,K3,K4)) Q:K4=""  D
 .....S K5=""
 .....F  S K5=$O(^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY,"ASYNC",K1,K2,K3,K4,K5)) Q:K5=""  D
 ......S K6=""
 ......F  S K6=$O(^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY,"ASYNC",K1,K2,K3,K4,K5,K6)) Q:K6=""  D
 .......S K7=""
 .......F  S K7=$O(^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY,"ASYNC",K1,K2,K3,K4,K5,K6,K7)) Q:K7=""  D
 ........S K8=""
 ........F  S K8=$O(^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY,"ASYNC",K1,K2,K3,K4,K5,K6,K7,K8)) Q:K8=""  D
 .........S K9=""
 .........F  S K9=$O(^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY,"ASYNC",K1,K2,K3,K4,K5,K6,K7,K8,K9)) Q:K9=""  D
 ..........S K10=""
 ..........F  S K10=$O(^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY,"ASYNC",K1,K2,K3,K4,K5,K6,K7,K8,K9,K10)) Q:K10=""  D
 ...........S K11=""
 ...........F  S K11=$O(^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY,"ASYNC",K1,K2,K3,K4,K5,K6,K7,K8,K9,K10,K11)) Q:K11=""  D
 ............S K12=""
 ............F  S K12=$O(^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY,"ASYNC",K1,K2,K3,K4,K5,K6,K7,K8,K9,K10,K11,K12)) Q:K12=""  D
 .............S K13=""
 .............F  S K13=$O(^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY,"ASYNC",K1,K2,K3,K4,K5,K6,K7,K8,K9,K10,K11,K12,K13)) Q:K13=""  D
 ..............S KMPDATA=$G(^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY,"ASYNC",K1,K2,K3,K4,K5,K6,K7,K8,K9,K10,K11,K12,K13))
 ..............S KMPSET=K1_U_K2_U_K3_U_K4_U_K5_U_K6_U_K7_U_K8_U_K9_U_K10_U_K11_U_K12_U_K13_U_KMPDATA
 ..............S ^KMPTMP("KMPV","VHLM","TRANSMIT",$J,"ASYNC",KMPVLN)="VHLM DATA="_KMPSET,KMPVLN=KMPVLN+1
 .I $D(^KMPTMP("KMPV","VHLM","TRANSMIT",$J,"ASYNC")) D
 ..M ^KMPTMP("KMPV","VHLM","TRANSMIT",$J,"ASYNC")=KMPTMP
 ..S ^KMPTMP("KMPV","VHLM","TRANSMIT",$J,"ASYNC",6)="MESSAGE TYPE=ASYNC"
 ..D TRANSMIT("ASYNC")
 .;
 .K ^KMPTMP("KMPV","VHLM","TRANSMIT",$J)
 .S KMPVLN=KMPLNST
 .S K1=""
 .F  S K1=$O(^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY,"SYNC",K1)) Q:K1=""  D
 ..S K2=""
 ..F  S K2=$O(^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY,"SYNC",K1,K2)) Q:K2=""  D
 ...S K3=""
 ...F  S K3=$O(^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY,"SYNC",K1,K2,K3)) Q:K3=""  D
 ....S K4=""
 ....F  S K4=$O(^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY,"SYNC",K1,K2,K3,K4)) Q:K4=""  D
 .....S K5=""
 .....F  S K5=$O(^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY,"SYNC",K1,K2,K3,K4,K5)) Q:K5=""  D
 ......S K6=""
 ......F  S K6=$O(^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY,"SYNC",K1,K2,K3,K4,K5,K6)) Q:K6=""  D
 .......S K7=""
 .......F  S K7=$O(^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY,"SYNC",K1,K2,K3,K4,K5,K6,K7)) Q:K7=""  D
 ........S K8=""
 ........F  S K8=$O(^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY,"SYNC",K1,K2,K3,K4,K5,K6,K7,K8)) Q:K8=""  D
 .........S K9=""
 .........F  S K9=$O(^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY,"SYNC",K1,K2,K3,K4,K5,K6,K7,K8,K9)) Q:K9=""  D
 ..........S K10=""
 ..........F  S K10=$O(^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY,"SYNC",K1,K2,K3,K4,K5,K6,K7,K8,K9,K10)) Q:K10=""  D
 ...........S K11=""
 ...........F  S K11=$O(^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY,"SYNC",K1,K2,K3,K4,K5,K6,K7,K8,K9,K10,K11)) Q:K11=""  D
 ............S K12=""
 ............F  S K12=$O(^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY,"SYNC",K1,K2,K3,K4,K5,K6,K7,K8,K9,K10,K11,K12)) Q:K12=""  D
 .............S K13=""
 .............F  S K13=$O(^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY,"SYNC",K1,K2,K3,K4,K5,K6,K7,K8,K9,K10,K11,K12,K13)) Q:K13=""  D
 ..............S KMPDATA=$G(^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY,"SYNC",K1,K2,K3,K4,K5,K6,K7,K8,K9,K10,K11,K12,K13))
 ..............S KMPSET=K1_U_K2_U_K3_U_K4_U_K5_U_K6_U_K7_U_K8_U_K9_U_K10_U_K11_U_K12_U_K13_U_KMPDATA
 ..............S ^KMPTMP("KMPV","VHLM","TRANSMIT",$J,"SYNC",KMPVLN)="VHLM DATA="_KMPSET,KMPVLN=KMPVLN+1
 .I $D(^KMPTMP("KMPV","VHLM","TRANSMIT",$J,"SYNC")) D
 ..M ^KMPTMP("KMPV","VHLM","TRANSMIT",$J,"SYNC")=KMPTMP
 ..S ^KMPTMP("KMPV","VHLM","TRANSMIT",$J,"SYNC",6)="MESSAGE TYPE=SYNC"
 ..D TRANSMIT("SYNC")
 .;
 .K ^KMPTMP("KMPV","VHLM","TRANSMIT",$J)
 .S KMPVLN=KMPLNST
 .S K1=""
 .F  S K1=$O(^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY,"HLO",K1)) Q:K1=""  D
 ..S K2=""
 ..F  S K2=$O(^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY,"HLO",K1,K2)) Q:K2=""  D
 ...S K3=""
 ...F  S K3=$O(^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY,"HLO",K1,K2,K3)) Q:K3=""  D
 ....S K4=""
 ....F  S K4=$O(^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY,"HLO",K1,K2,K3,K4)) Q:K4=""  D
 .....S K5=""
 .....F  S K5=$O(^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY,"HLO",K1,K2,K3,K4,K5)) Q:K5=""  D
 ......S K6=""
 ......F  S K6=$O(^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY,"HLO",K1,K2,K3,K4,K5,K6)) Q:K6=""  D
 .......S K7=""
 .......F  S K7=$O(^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY,"HLO",K1,K2,K3,K4,K5,K6,K7)) Q:K7=""  D
 ........S K8=""
 ........F  S K8=$O(^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY,"HLO",K1,K2,K3,K4,K5,K6,K7,K8)) Q:K8=""  D
 .........S K9=""
 .........F  S K9=$O(^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY,"HLO",K1,K2,K3,K4,K5,K6,K7,K8,K9)) Q:K9=""  D
 ..........S K10=""
 ..........F  S K10=$O(^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY,"HLO",K1,K2,K3,K4,K5,K6,K7,K8,K9,K10)) Q:K10=""  D
 ...........S K11=""
 ...........F  S K11=$O(^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY,"HLO",K1,K2,K3,K4,K5,K6,K7,K8,K9,K10,K11)) Q:K11=""  D
 ............S K12=""
 ............F  S K12=$O(^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY,"HLO",K1,K2,K3,K4,K5,K6,K7,K8,K9,K10,K11,K12)) Q:K12=""  D
 .............S KMPDATA=$G(^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY,"HLO",K1,K2,K3,K4,K5,K6,K7,K8,K9,K10,K11,K12))
 .............S KMPSET=K1_U_K2_U_K3_U_K4_U_K5_U_K6_U_K7_U_K8_U_K9_U_K10_U_K11_U_K12_U_KMPDATA
 .............S ^KMPTMP("KMPV","VHLM","TRANSMIT",$J,"HLO",KMPVLN)="VHLM DATA="_KMPSET,KMPVLN=KMPVLN+1
 .I $D(^KMPTMP("KMPV","VHLM","TRANSMIT",$J,"HLO")) D
 ..M ^KMPTMP("KMPV","VHLM","TRANSMIT",$J,"HLO")=KMPTMP
 ..S ^KMPTMP("KMPV","VHLM","TRANSMIT",$J,"HLO",6)="MESSAGE TYPE=HLO"
 ..D TRANSMIT("HLO")
 Q
 ; DATA STRINGS
 ; ASYNC: KMPSTIME,KMPTRAN,KMPPRI,KMPHTYP,KMPLL,KMPSPROT,KMPEPROT,KMPMTYP,KMPETYP,KMPSAPP,KMPRAPP,   X    ,    X   ,NumMsgs,TotChar,NumEvents,TransTime,CATime,AATime
 ;  KMPDATA = NumMsgs^TotChar^NumEvents^TransTime
 ;  SYNC: KMPSTIME,KMPTRAN,KMPPRI,KMPHTYP,KMPLL,KMPSPROT,KMPEPROT,KMPMTYP,KMPETYP,KMPSAPP,KMPRAPP,KMPSSITE,KMPRSITE,NumMsgs,TotChar,NumEvents,TransTime,CATime,AATimE
 ;   KMPDATA = NumMsgs^TotChar^NumEvents^TransTime^CATime^AATime
 ;   HLO: KMPSTIME,KMPSYNC,KMPTYP,KMPDIR,KMPAMTYP,KMPAMEVT,KMPLL,KMPQUE,KMPSAPP,KMPSSITE,KMPRAPP,KMPRSITE,NumMsgs,TotChar
 ;   KMPDATA=NumMsgs^TotChar
 Q
TRANSMIT(KMPMT) ;
 ; quit if no data to transmit.
 Q:'$D(^KMPTMP("KMPV","VHLM","TRANSMIT",$J))
 N KMPVEMAIL,X,XMSUB,XMTEXT,XMY,XMZ
 ; send data via mail message.
 S XMTEXT="^KMPTMP(""KMPV"",""VHLM"",""TRANSMIT"","_$J_","""_KMPMT_""","
 S XMSUB="VHLM DAILY DATA"
 S KMPVEMAIL=$$GETVAL^KMPVCCFG("VHLM","NATIONAL DATA EMAIL ADDRESS",8969) I KMPVEMAIL'="" S XMY(KMPVEMAIL)=""
 D ^XMD
 ; RECORD SUCCESS/FAILURE -- SEND MESSAGE IF FAILURE
 I +$G(XMZ)>0 D
 .S ^KMPTMP("KMPV","VHLM","DLY",KMPVHDAY,KMPMT)=XMZ
 E  D CANMESS^KMPVCBG("FAILTRAN","VHLM",KMPVSITE,KMPVHDAY)
 K ^KMPTMP("KMPV","VHLM","TRANSMIT",$J)
 Q
 ;
