DSIO8 ;DSS/KAR - DSIO EDUCATION RPCs;08/26/2016 16:00
 ;;3.0;MATERNITY TRACKER;;Feb 02, 2017;Build 1
 ;Originally Submitted to OSEHRA 2/21/2017 by DSS, Inc. 
 ;Authored by DSS, Inc. 2014-2017
 ;
 ;
 ;
 Q
 ;
SAVE(RET,IEN,DESC,CAT,TYPE,URL,CODE,SYS,DEL) ; RPC: DSIO SAVE EDUCATION ITEM
 ;
 ;  INPUT:
 ;    IEN:  IEN OF RECORD TO UPDATE OR DELETE, ELSE BLANK FOR NEW RECORD
 ;   DESC:  ENTER DESCRIPTION - REQUIRED
 ;    CAT:  CATEGORY IN WHICH MATERIAL FALLS
 ;   TYPE:  (D)ISCUSSION, (L)INC, (P)RINTED, (E)NROLLMENT, (O)THER - REQUIRED
 ;    URL:  WEB LINK
 ;   CODE:  CODE NUMBER
 ;    SYS:  CODING SYSTEM (L)OINC, (S)NOMED, (N)ONE - REQUIRED
 ;    DEL:  0 = SAVE 1 = DELETE - OPTIONAL (DEFAULTS TO 0 - SAVE)
 ;
 ; OUTPUT:
 ;   1^SUCCESS OR -1^ERROR MESSAGE
 ;
 N FLAG,J,I,DSIOFDA,IENS,ERR
 S RET=-1,FLAG=0
 S IEN=+$G(IEN),CAT=$G(CAT),URL=$G(URL),CODE=$G(CODE),DEL=$G(DEL)
 I IEN,'$$FIND1^DIC(19641.8,,"A",IEN) S RET="-1^This record does not exist." Q
 ; *** DELETE A RECORD
 I IEN,DEL=1 D  Q:$D(ERR)
 . ; HAVE IEN OF EDUCATION ITEM FROM INPUT PARAMETER
 . ; CHECK IF THIS IEN IS POINTED TO IN THE DSIO MCC CHECKLIST(19641.7)
 . ; OR DSIO MCC PATIENT CHECKLIST (19641.76) FILES
 . S J=0 F  S J=$O(^DSIO(19641.7,"C",IEN,J)) Q:'J  D
 . . I $D(^DSIO(19641.7,"C",IEN,J)) D
 . . . S FLAG=1,RET="-1^Cannot delete this item since it is linked to the DSIO MCC CHECKLIST."
 . Q:FLAG
 . S J=0 F  S J=$O(^DSIO(19641.76,"D",IEN,J)) Q:'J  D
 . . S I=0 F  S I=$O(^DSIO(19641.76,"D",IEN,J,I)) Q:'I  D
 . . . I $D(^DSIO(19641.76,"D",IEN,J,I)) D
 . . . . S FLAG=1,RET="-1^Cannot delete this item since it is linked to the DSIO MCC PATIENT CHECKLIST."
 . Q:FLAG
 . S DSIOFDA(19641.8,IEN_",",.01)="@"
 . D UPDATE^DIE("E","DSIOFDA","IENS","ERR") K DSIOFDA
 . I $D(ERR) S RET="-1^"_$G(ERR("DIERR",1,"TEXT",1)) Q
 . S FLAG=1,RET="1^Successfully deleted record."
 Q:FLAG  Q:IEN'=""&(DEL=1)
 S DESC=$G(DESC) I DESC']"" S RET="-1^Description not specified." Q
 S TYPE=$G(TYPE) I TYPE']"" S RET="-1^Type not specified." Q
 S SYS=$G(SYS) I SYS']"" S RET="-1^System not specified." Q
 S DESC=$$TITLE^XLFSTR(DESC),CAT=$$TITLE^XLFSTR(CAT)
 I DEL'=1 S DEL=0
 I DEL=0,IEN D  Q
 . S IENS=IEN_","
 . S DSIOFDA(19641.8,IENS,.01)=DESC
 . S DSIOFDA(19641.8,IENS,1)=CAT
 . S DSIOFDA(19641.8,IENS,3)=TYPE
 . S DSIOFDA(19641.8,IENS,4)=URL
 . S DSIOFDA(19641.8,IENS,5)=CODE
 . S DSIOFDA(19641.8,IENS,6)=SYS
 . D FILE^DIE("E","DSIOFDA","ERR") K IENS,DSIOFDA
 . I $D(ERR) S RET="-1^"_$G(ERR("DIERR",1,"TEXT",1)) Q
 . S FLAG=1,RET="1^Successfully updated record."
 Q:FLAG
 I 'DEL,'IEN D
 . S IENS="+1,"
 . S DSIOFDA(19641.8,IENS,.01)=DESC
 . S DSIOFDA(19641.8,IENS,1)=CAT
 . S DSIOFDA(19641.8,IENS,3)=TYPE
 . S DSIOFDA(19641.8,IENS,4)=URL
 . S DSIOFDA(19641.8,IENS,5)=CODE
 . S DSIOFDA(19641.8,IENS,6)=SYS
 . K IENS D UPDATE^DIE("E","DSIOFDA","IENS","ERR") K DSIOFDA
 . I $D(ERR) S RET="-1^"_$G(ERR("DIERR",1,"TEXT",1)) Q
 . S RET=$G(IENS(1))_"^Success"
 Q
 ;
GET(RET,PSIZE,PAGE,CAT,TYPE,IEN,FLG) ; RPC: DSIO GET EDUCATION ITEMS
 ;
 ;  INPUT:
 ;  PSIZE: NUMBER OF ITEMS TO RETURN
 ;   PAGE: NUMBER OF PAGES
 ;    CAT: CATEGORY INTO WHICH MATERIAL FALLS
 ;   TYPE: (D)ISCUSSION, (L)INC, (P)RINTED MATERIAL, (E)NROLLMENT, (O)THER
 ;    IEN: IEN OF RECORD TO GET, ELSE BLANK FOR ARRAY OF PAGES
 ;    FLG: SORT - 0=BY TYPE, 1=BY DESCRIPTION, 2=BY CATEGORY, (DEFAULT IS TYPE)
 ; OUTPUT:
 ;   RET(0)    = NUMBER OF ITEMS
 ;   RET(1..n) = IEN ^ DESCRIPTION ^ CATEGORY ^ TYPE ^ URL ^ CODE ^ CODING SYSTEM
 ;     OR -1^ERROR MESSAGE
 ;
 N FILE,CNT,J,DESC,CAT1,TYPE1,URL,CODE,SYS,ARR
 N TS,RCT,STRT,END D S^DSIO2($G(PSIZE)_","_$G(PAGE))
 S RET=$NA(^TMP("DSIO8",$J)) K @RET S @RET@(0)=0
 S CAT=$$UP^XLFSTR($G(CAT)),TYPE=$E($$UP^XLFSTR($G(TYPE))),IEN=+$G(IEN)
 S FLG=+$G(FLG) I FLG<0!(FLG>2) S FLG=0
 S FILE=19641.8,CNT=1
 ;
 ; *** RETRIEVE A SPECIFIC RECORD
 I IEN D  Q
 . I $$GET1^DIQ(FILE,IEN_",",.01)="" S @RET@(1)="-1^This record does not exist." Q
 . S @RET@(0)=1
 . S @RET@(1)=IEN_U_$$GET1^DIQ(FILE,IEN_",",.01)_U_$$GET1^DIQ(FILE,IEN_",",1)_U_$$GET1^DIQ(FILE,IEN_",",3)
 . S @RET@(1)=@RET@(1)_U_$$GET1^DIQ(FILE,IEN_",",4)_U_$$GET1^DIQ(FILE,IEN_",",5)_U_$$GET1^DIQ(FILE,IEN_",",6)
 ;
 ; *** RETRIEVE LIST OF RECORDS
 ;
 I FLG=0 D  ; TYPE
 . S J="" F  S J=$O(^DSIO(FILE,"T",J)) Q:J=""  D
 . . I $L(TYPE) Q:J'=TYPE
 . . S IEN=0 F  S IEN=$O(^DSIO(FILE,"T",J,IEN)) Q:'IEN  D
 . . . S DESC=$P($G(^DSIO(19641.8,IEN,0)),U)
 . . . S CAT1=$$GET1^DIQ(FILE,IEN_",",1) I $L(CAT) Q:$$UP^XLFSTR(CAT1)'=CAT
 . . . S TYPE1=$$GET1^DIQ(FILE,IEN_",",3)
 . . . S URL=$$GET1^DIQ(FILE,IEN_",",4)
 . . . S CODE=$$GET1^DIQ(FILE,IEN_",",5)
 . . . S SYS=$$GET1^DIQ(FILE,IEN_",",6)
 . . . S ARR(CNT)=IEN_U_DESC_U_CAT1_U_TYPE1_U_URL_U_CODE_U_SYS,CNT=CNT+1
 ;
 I FLG=1 D  ; DESCRIPTION
 . S J="" F  S J=$O(^DSIO(FILE,"B",J)) Q:J=""  D
 . . S IEN=0 F  S IEN=$O(^DSIO(FILE,"B",J,IEN)) Q:'IEN  D
 . . . I $L(TYPE) Q:$$GET1^DIQ(FILE,IEN_",",3,"I")'=TYPE
 . . . S DESC=$P($G(^DSIO(FILE,IEN,0)),U)
 . . . S CAT1=$$GET1^DIQ(FILE,IEN_",",1) I $L(CAT) Q:$$UP^XLFSTR(CAT1)'=CAT
 . . . S TYPE1=$$GET1^DIQ(FILE,IEN_",",3)
 . . . S URL=$$GET1^DIQ(FILE,IEN_",",4)
 . . . S CODE=$$GET1^DIQ(FILE,IEN_",",5)
 . . . S SYS=$$GET1^DIQ(FILE,IEN_",",6)
 . . . S ARR(CNT)=IEN_U_DESC_U_CAT1_U_TYPE1_U_URL_U_CODE_U_SYS,CNT=CNT+1
 ;
 I FLG=2 D  ; CATEGORY
 . S J="" F  S J=$O(^DSIO(FILE,"C",J)) Q:J=""  D
 . . I $L(CAT) Q:$$UP^XLFSTR(J)'=CAT
 . . S IEN=0 F  S IEN=$O(^DSIO(FILE,"C",J,IEN)) Q:'IEN  D
 . . . I $L(TYPE) Q:$$GET1^DIQ(FILE,IEN_",",3,"I")'=TYPE
 . . . S DESC=$P($G(^DSIO(FILE,IEN,0)),U)
 . . . S CAT1=$$GET1^DIQ(FILE,IEN_",",1)
 . . . S TYPE1=$$GET1^DIQ(FILE,IEN_",",3)
 . . . S URL=$$GET1^DIQ(FILE,IEN_",",4)
 . . . S CODE=$$GET1^DIQ(FILE,IEN_",",5)
 . . . S SYS=$$GET1^DIQ(FILE,IEN_",",6)
 . . . S ARR(CNT)=IEN_U_DESC_U_CAT1_U_TYPE1_U_URL_U_CODE_U_SYS,CNT=CNT+1
 ;
 S (TS,RCT,CNT)=0 F  S CNT=$O(ARR(CNT)) Q:'CNT  D
 . S TS=TS+1 I STRT'="",TS'>STRT Q
 . S RCT=RCT+1 I END'="",RCT>END Q
 . S @RET@(RCT)=ARR(CNT)
 S:$G(TS) @RET@(0)=TS
 Q
 ;
SAVPTED(RET,DFN,IEN,COMPLON,EDUCIEN,CAT,DESC,TYPE,URL,CODE,CODESYS) ; RPC: DSIO SAVE PATIENT EDUCATION
 ;
 ;   INPUT:
 ;     DFN: PATIENT DFN - REQUIRED
 ;     IEN: IEN OF RECORD TO UPDATE, ELSE BLANK FOR NEW RECORD
 ; COMPLON: DATE COMPLETED - REQUIRED
 ; EDUCIEN: POINTER TO DSIO EDUCATION FILE (19641.8)
 ;     CAT: CATEGORY IN WHICH MATERIAL FALLS
 ;    DESC: ENTER DESCRIPTION
 ;    TYPE: (D)ISCUSSION, (L)INC, (P)RINTED, (E)NROLLMENT, (O)THER
 ;     URL: WEB LINK
 ;    CODE: CODE NUMBER
 ; CODESYS: CODING SYSTEM (L)OINC, (S)NOMED, (N)ONE
 ;
 ;  OUTPUT:
 ;     "IEN^SUCCESS" OR "-1^ERROR MESSAGE" OR "1^SUCCESSFULLY UPDATED RECORD"
 ;
 N DSIOFDA,IENS,ERR S RET=0
 S DFN=+$G(DFN),IEN=+$G(IEN),COMPLON=$$DT^DSIO2($G(COMPLON)),EDUCIEN=+$G(EDUCIEN)
 S CAT=$G(CAT),DESC=$G(DESC),TYPE=$G(TYPE),URL=$G(URL),CODE=$G(CODE),CODESYS=$G(CODESYS)
 I 'DFN!('$D(^DPT(DFN))) S RET="-1^Must have a valid patient DFN." Q
 I COMPLON="" S RET="-1^Must have a COMPLETED ON DATE." Q
 I 'EDUCIEN D  Q:+RET<0
 . I DESC="" S RET="-1^Must have a DESCRIPTION if not using DSIO EDUCATION ITEM." Q
 . I TYPE="" S RET="-1^Must have a TYPE if not using DSIO EDUCATION ITEM." Q
 . I CODESYS="" S RET="-1^Must have a CODE SYSTEM if not using DSIO EDUCATION ITEM."
 I EDUCIEN,$G(^DSIO(19641.8,EDUCIEN,0))="" S RET="-1^This DSIO EDUCATION RECORD does not exist." Q
 ;
 I EDUCIEN D     ; GRAB FROM 19641.8
 . S CAT=$$GET1^DIQ(19641.8,EDUCIEN_",",1)
 . S DESC=$$GET1^DIQ(19641.8,EDUCIEN_",",.01)
 . S TYPE=$$GET1^DIQ(19641.8,EDUCIEN_",",3,"I")
 . S URL=$$GET1^DIQ(19641.8,EDUCIEN_",",4)
 . S CODE=$$GET1^DIQ(19641.8,EDUCIEN_",",5)
 . S CODESYS=$$GET1^DIQ(19641.8,EDUCIEN_",",6,"I")
 ;
 I IEN D  Q      ; UPDATE TO FILE
 . S IENS=IEN_","
 . S DSIOFDA(19641.81,IENS,.01)="`"_DFN
 . S DSIOFDA(19641.81,IENS,2)="`"_DUZ
 . S DSIOFDA(19641.81,IENS,3)=COMPLON
 . S DSIOFDA(19641.81,IENS,4)=$S(EDUCIEN:"`"_EDUCIEN,1:"")
 . S DSIOFDA(19641.81,IENS,5)=CAT
 . S DSIOFDA(19641.81,IENS,10)=DESC
 . S DSIOFDA(19641.81,IENS,11)=TYPE
 . S DSIOFDA(19641.81,IENS,12)=URL
 . S DSIOFDA(19641.81,IENS,13)=CODE
 . S DSIOFDA(19641.81,IENS,14)=CODESYS
 . D UPDATE^DIE("E","DSIOFDA",,"ERR")
 . I $D(ERR) S RET="-1^"_$G(ERR("DIERR",1,"TEXT",1)) Q
 . S RET="1^Successfully updated record."
 ;
 S IENS="+1,"
 S DSIOFDA(19641.81,IENS,.01)="`"_DFN
 S DSIOFDA(19641.81,IENS,2)="`"_DUZ
 S DSIOFDA(19641.81,IENS,3)=COMPLON
 S DSIOFDA(19641.81,IENS,4)=$S(EDUCIEN:"`"_EDUCIEN,1:"")
 S DSIOFDA(19641.81,IENS,5)=CAT
 S DSIOFDA(19641.81,IENS,10)=DESC
 S DSIOFDA(19641.81,IENS,11)=TYPE
 S DSIOFDA(19641.81,IENS,12)=URL
 S DSIOFDA(19641.81,IENS,13)=CODE
 S DSIOFDA(19641.81,IENS,14)=CODESYS
 K IENS D UPDATE^DIE("E","DSIOFDA","IENS","ERR")
 I $D(ERR) S RET="-1^"_$G(ERR("DIERR",1,"TEXT",1)) Q
 S RET=$G(IENS(1))_"^Success"
 Q
 ;
GETPTED(RET,DFN,IEN,PSIZE,PAGE,FROM,TODA,TYPE) ; RPC: DSIO GET PATIENT EDUCATION
 ;
 ;  INPUT:
 ;    DFN: PATIENT DFN - REQUIRED
 ;    IEN: IEN OF RECORD TO GET, ELSE BLANK FOR ARRAY OF PAGES
 ;  PSIZE: NUMBER OF ITEMS PER PAGE
 ;   PAGE: NUMBER OF PAGES
 ;   FROM: DATE TO START SEARCH
 ;   TODA: DATE TO END SEARCH
 ;   TYPE: (D)ISCUSSION, (L)INC, (P)RINTED MATERIAL, (E)NROLLMENT, (O)THER
 ; OUTPUT:
 ;   RET(0)    = NUMBER OF ITEMS
 ;   RET(1..n) = IEN ^ COMPLETED ON ^ CATEGORY ^ DESCRIPTION ^ TYPE ^ URL ^ CODE ^ CODING SYSTEM ^ USER
 ;           OR -1^ERROR MESSAGE
 ;
 N FILE,CNT,DATE
 N TS,RCT,STRT,END D S^DSIO2($G(PSIZE)_","_$G(PAGE))
 S RET=$NA(^TMP("DSIO8",$J)) K @RET S @RET@(0)=0
 S DFN=+$G(DFN),IEN=+$G(IEN)
 S FROM=$$DT^DSIO2($G(FROM)),TODA=$$DT^DSIO2($G(TODA)),TYPE=$E($$UP^XLFSTR($G(TYPE)))
 S FILE=19641.81,CNT=1
 ;
 ; *** RETRIEVE A SPECIFIC RECORD
 I IEN D  Q
 . I $$GET1^DIQ(FILE,IEN_",",.01)="" S @RET@(1)="-1^This record does not exist." Q
 . S @RET@(0)=1
 . S @RET@(1)=IEN_U_$$GET1^DIQ(FILE,IEN_",",3,"I")_U_$$GET1^DIQ(FILE,IEN_",",5)_U_$$GET1^DIQ(FILE,IEN_",",10)
 . S @RET@(1)=@RET@(1)_U_$$GET1^DIQ(FILE,IEN_",",11)_U_$$GET1^DIQ(FILE,IEN_",",12)_U_$$GET1^DIQ(FILE,IEN_",",13)
 . S @RET@(1)=@RET@(1)_U_$$GET1^DIQ(FILE,IEN_",",14)_U_$$GET1^DIQ(200,$$GET1^DIQ(FILE,IEN_",",2)_",",.01)
 ;
 I 'DFN!('$D(^DPT(DFN))) S @RET@(1)="-1^Must have a valid patient DFN." Q
 ;
 ; *** GET ALL RECORDS OF SPECIFIC PATIENT AND PUT IN ARR()
 S (TS,RCT,IEN)=0,CNT=1 F  S IEN=$O(^DSIO(FILE,"B",DFN,IEN)) Q:'IEN  D
 . I $L(TYPE) Q:$$GET1^DIQ(FILE,IEN_",",11,"I")'=TYPE
 . S DATE=$$GET1^DIQ(FILE,IEN_",",3,"I")
 . I $L(FROM) Q:DATE<FROM
 . I $L(TODA) Q:DATE>TODA
 . S TS=TS+1 I STRT'="",TS'>STRT Q
 . S RCT=RCT+1 I END'="",RCT>END Q
 . S @RET@(CNT)=IEN_U_$$GET1^DIQ(FILE,IEN_",",3,"I")_U_$$GET1^DIQ(FILE,IEN_",",5)_U_$$GET1^DIQ(FILE,IEN_",",10)
 . S @RET@(CNT)=@RET@(CNT)_U_$$GET1^DIQ(FILE,IEN_",",11)_U_$$GET1^DIQ(FILE,IEN_",",12)_U_$$GET1^DIQ(FILE,IEN_",",13)
 . S @RET@(CNT)=@RET@(CNT)_U_$$GET1^DIQ(FILE,IEN_",",14)_U_$$GET1^DIQ(200,$$GET1^DIQ(FILE,IEN_",",2)_",",.01)
 . S CNT=CNT+1
 S:$G(TS) @RET@(0)=TS
 Q
 ;
GETCAT(RET) ; RPC: DSIO GET EDUC CATEGORY LIST
 ; This RPC will produce an alphabetized list of category names
 ; from the DSIO EDUCATION and the DSIO PATIENT EDUCATION files.
 N CAT
 S RET=$NA(^TMP("DSIO8",$J)) K @RET S @RET@(0)=""
 S CAT="" F  S CAT=$O(^DSIO(19641.8,"C",CAT)) Q:CAT=""  D
 . S @RET@(CAT)=$$GET1^DIQ(19641.8,$O(^DSIO(19641.8,"C",CAT,""))_",",1)
 S CAT="" F  S CAT=$O(^DSIO(19641.81,"C",CAT)) Q:CAT=""  D
 . S @RET@(CAT)=$$GET1^DIQ(19641.8,$O(^DSIO(19641.81,"C",CAT,""))_",",5)
 K:$O(@RET@(""),-1)'=0 @RET@(0)
 Q
