# Introduction 
A list of notes for a patient in the right hand side of CPRS is supposed to
contain the Local Name of the note; VHA Enterprise Title. Due to an error in
the code, the retrieved VHA Enterprise Title is either not display or displayed
incorrectly. This patch fixes this so that the correct VHA Enterprise Title is
always displayed.  

# Detailed Description 

Bug assigned: CR I17755863FY18 
## Problem 
Each local note name is associated with an VHA Enterprise Title.  Viewers of
the notes in CPRS and other applications are supposed to be able to see both
titles (the local and VHA Enterprise Title) separated by a semicolon.  The RPC
that gets the notes is TIU DOCUMENTS BY CONTEXT which calls CONTEXT^TIUSRVLO.
Due to a bug in RESOLVE^TIUSRVLO, the wrong variable for the IEN of the VHA Enterprise Title is used.

## Resolution 
Currently RESOLVE+10 says:
```
 I +$G(^TIU(8925.1,+DA,15)) D
 . N TIUD15 S TIUD15=$G(^TIU(8925.1,+DA,15))
```

```
It's supposed to say:
 I +$G(^TIU(8925.1,+TIUR0,15)) D
 . N TIUD15 S TIUD15=$G(^TIU(8925.1,+TIUR0,15))
```

DA refers to the internal entry number of 8925, not the internal entry number
for 8925.1. That's the problem.

## Options Affected
Notes listing in CPRS

## Testing Instructions on a FOIA instance
The first few steps in a FOIA instance create a new title whose actual VHA
Enterprise Title is known; there are no titles to use in FOIA that reflect
regular patient care notes. That's why the first few steps are necessary.

TIU IRM MAINTENANCE MENU > TIUF DOCUMENT DEFINITION MGR > TIUFC CREATE DDEFS MGR

 - Navigate to Progress Notes (Next Level, 2)
 - Create a Document Class for "HOSPITAL NOTES". Make sure to change the
   Inactive to Active
 - Navigate to HOSPITAL NOTES (just created above)
 - Create a Title to create a title called "PHYSICIAN NOTE". Link to VHA
   Enterprise Standard Title "E & M CLINICAL NOTE". Change Inactive to Active.

At this point, go to CPRS using a user that has an electornic signature, and
create a note using CPRS and sign. Notice that when saved, that note is
displayed without the second semicolon piece.

After applying the patch, restart CPRS, and view the same note list again. This
time, you will see the second semicolon piece.


# Package Components
PACKAGE: TIU*1.0*10001     Dec 12, 2017 9:23 pm                   PAGE 1
-------------------------------------------------------------------------------
TYPE: SINGLE PACKAGE                               TRACK NATIONALLY: YES
NATIONAL PACKAGE: TEXT INTEGRATION UTILITIES     ALPHA/BETA TESTING: NO

DESCRIPTION:
This build fixes CR I17755863FY18.
 
A list of notes for a patient in the right hand side of CPRS is supposed 
to contain the Local Name of the note; VHA Enterprise Title. Due to an 
error in the code, the retrieved VHA Enterprise Title is either not 
display or displayed incorrectly.

ENVIRONMENT CHECK:                               DELETE ENV ROUTINE: 
 PRE-INIT ROUTINE:                          DELETE PRE-INIT ROUTINE: 
POST-INIT ROUTINE:                         DELETE POST-INIT ROUTINE: 
PRE-TRANSPORT RTN: 

ROUTINE:                                       ACTION:
   TIUSRVLO                                       SEND TO SITE

REQUIRED BUILDS:                               ACTION:
   TIU*1.0*268                                    Don't install, remove global

# Installation Instructions
## Pre-Install Instructions
None.

## Install Instructions
 Installation time should be less than 2 minutes.

 1. Choose the PackMan message containing this patch. Alternately, load the
    patch from a file from the KIDS Installation menu using Load a Distribution [XPD LOAD DISTRIBUTION]
  
 2. Choose the INSTALL/CHECK MESSAGE PackMan option. 
  
 3. From Kernel Installation and Distribution System Menu, select the 
    Installation Menu. From this menu, you may elect to use the following 
    options.  When prompted for the INSTALL NAME, enter the patch
    TIU*1.0*10001:
  
       a. Backup a Transport Global - This option will create a backup
          message of any routines exported with this patch. It will not
          backup other changes such as DDs or templates.
  
       b. Compare Transport Global to Current System - This option will
          allow you to view all changes that will be made when this patch
          is installed. It compares all components of this patch's
          routines, DDs, templates, etc.).
  
       c. Verify Checksums in Transport Global - This option will allow you
          to ensure the integrity of the routines that are in the transport
          global.
  
 4. From the Installation Menu, select the Install Package(s) option 
    and choose the patch to install.
  
 5. When prompted 'Want KIDS to Rebuild Menu Trees Upon Completion of 
    Install? NO//', respond NO.
  
 6. When prompted 'Want KIDS to INHIBIT LOGONs during the install? 
    NO//', respond NO.
  
 7. When prompted 'Want to DISABLE Scheduled Options, Menu Options, and
    Protocols? NO//' , respond NO.
  
 8. If prompted 'Delay Install (Minutes): (0 - 60): 0//' respond 0.

 9. In Device, type ';P-OTHER;999999'.

Here's an example install transcript:

```
OSEHRA>D ^XUP

Setting up programmer environment
This is a TEST account.

Terminal Type set to: C-VT220

Select OPTION NAME: XPD MAIN       Kernel Installation & Distribution System


          Edits and Distribution ...
          Utilities ...
          Installation ...
          Patch Monitor Main Menu ...

Select Kernel Installation & Distribution System <TEST ACCOUNT> Option: INStalla
tion


   1      Load a Distribution
   2      Verify Checksums in Transport Global
   3      Print Transport Global
   4      Compare Transport Global to Current System
   5      Backup a Transport Global
   6      Install Package(s)
          Restart Install of Package(s)
          Unload a Distribution

Select Installation <TEST ACCOUNT> Option: 1  Load a Distribution
Enter a Host File: /tmp/TIU_1-0_10001T2.KID

KIDS Distribution saved on Dec 13, 2017@15:36:44
Comment: T2 - TIU*1.0*10001

This Distribution contains Transport Globals for the following Package(s):
   TIU*1.0*10001
Distribution OK!

Want to Continue with Load? YES// 
Loading Distribution...

   TIU*1.0*10001
Use INSTALL NAME: TIU*1.0*10001 to install this Distribution.



   1      Load a Distribution
   2      Verify Checksums in Transport Global
   3      Print Transport Global
   4      Compare Transport Global to Current System
   5      Backup a Transport Global
   6      Install Package(s)
          Restart Install of Package(s)
          Unload a Distribution

Select Installation <TEST ACCOUNT> Option: 6  Install Package(s)
Select INSTALL NAME:    TIU*1.0*10001     Loaded from Distribution    12/13/17@1
7:09:59
     => T2 - TIU*1.0*10001  ;Created on Dec 13, 2017@15:36:44

This Distribution was loaded on Dec 13, 2017@17:09:59 with header of 
   T2 - TIU*1.0*10001  ;Created on Dec 13, 2017@15:36:44
   It consisted of the following Install(s):
  TIU*1.0*10001
Checking Install for Package TIU*1.0*10001

Install Questions for TIU*1.0*10001



Want KIDS to INHIBIT LOGONs during the install? NO// 
Want to DISABLE Scheduled Options, Menu Options, and Protocols? NO// 

Enter the Device you want to print the Install messages.
You can queue the install by enter a 'Q' at the device prompt.
Enter a '^' to abort the install.

DEVICE: HOME// ;p-other;9999;  TELNET

 
 Install Started for TIU*1.0*10001 : 
               Dec 13, 2017@17:10:14
 
Build Distribution Date: Dec 13, 2017
 
 Installing Routines:..
               Dec 13, 2017@17:10:14
 
 Updating Routine file......
 
 Updating KIDS files.......
 
 TIU*1.0*10001 Installed. 
               Dec 13, 2017@17:10:14
 
 Not a VA primary domain
 
 NO Install Message sent 


   1      Load a Distribution
   2      Verify Checksums in Transport Global
   3      Print Transport Global
   4      Compare Transport Global to Current System
   5      Backup a Transport Global
   6      Install Package(s)
          Restart Install of Package(s)
          Unload a Distribution
```

## Post-install instructions
None.

# Checksums
```
Checksums shown are NEW Checksums
The following routines are included in this patch.  The second line of each
of these routines now looks like:
 ;;1.0;TEXT INTEGRATION UTILITIES;**[Patch List]**;Jun 20, 1997;Build 2

                 Checksums
Routine         Old         New        Patch List
TIUSRVLO        n/a      90781882    **1,15,19,63,108,122,181,194,211,
                                       268,10001**

List of preceding patches: 268
Sites should use CHECK1^XTSUMBLD to verify checksums.
```
# Documentation
No documentation is supplied beyond this document.

# Test Sites
None
