package gov.va.med.authentication.kernel.sspi.authentication.manageable;

import java.util.HashMap;
import weblogic.management.utils.InvalidCursorException;

/**
 * Manages lists (eg. lists of users) returned by manageable
 * sample authenticator.
 *
 * 
 * @author VHIT Security and Other Common Services (S&OCS)
 * @version 1.1.0.002
 */

/*package*/ final class KaajeeListManager
{
  /**
   * All lists must implement this interface
   */
  /*package*/ interface List
  {
    /**
     * Does the list have a current element?
     *
     * @return a boolean indicating if the list has a current element
     *
     * @throws IllegalStateException if the list does not have a current element.
     */
    public boolean haveCurrent();

    /**
     * Get the current element's name (eg. a user or group name)
     *
     * @return a String containing the current element's name
     *
     * @throws IllegalStateException if the list does not have a current element.
     */
    public String getCurrentName();

    /**
     * Advance the list to the next element.
     *
     * @throws IllegalStateException if the list does not have a current element.
     */
    public void advance();

    /**
     * Terminate the list, freeing up any resources held on behalf of the list.
     * This closes the list regardless of whether or not the list has been
     * completely traversed.  This allows the customer to partially traverse
     * the list without leaking memory or resources.
     */
    public void close();
  }

  // Holds a list of the current lists that have been handed out by
  // the manageable sample authenticator.  Each list is assigned a
  // unique (withing the provider) String cursor.
  // Map the cursor to its corresponding list.
  private HashMap currentLists = new HashMap();

  // Each list needs a unique cursor.  Keep a counter that is incremented
  // whenever a new list is created.  Use that counter to generate the list's
  // cursor name.
  private int cursorIndex = 0;

  /**
   * Add a list to the list of lists.
   *
   * @param list the List to add.
   *
   * @return a String containing the cursor assigned to this list.
   */
  /*package*/ synchronized String registerList(List list)
  {
    String cursor = "Cursor" + cursorIndex;
    cursorIndex++;
    currentLists.put(cursor, list);
	//System.out.println("listUsers  cursor  " + list + " :"+ cursor);
	return cursor;
  }

  /**
   * Find a list given its cursor.
   *
   * @param cursor a String containing the cursor (name) assigned to the list.
   *
   * @return a List containing the list for that cursor.
   *
   * @throws InvalidCursorException if an invalid cursor (or a cursor for a
   * list that's already been closed) is passed in.
   */
  /*package*/ List getList(String cursor)    throws InvalidCursorException
  {
	//  System.out.println("List Manager   getList       ");
    Utils.checkVal(cursor);
    if (!currentLists.containsKey(cursor)) {
      throw new InvalidCursorException("Cursor \"" + cursor + "\" is not valid");
    }
   // System.out.println("listUsers  cursor  " + list + " :"+ cursor);
	List l = (List)currentLists.get(cursor);
	//while(l.haveCurrent()){
						//System.out.println("currentLists.getCurrentName()    :"+l.getCurrentName());
						//l.advance();
	//}
    return (List)(currentLists.get(cursor));
  }

  /**
   * Close and remove a list given its cursor.
   *
   * @param cursor a String containing the cursor (name) assigned to the list.
   *
   * @throws InvalidCursorException if an invalid cursor (or a cursor for a
   * list that's already been closed) is passed in.
   */
  /*package*/ void unregisterList(String cursor)
    throws InvalidCursorException
  {
    getList(cursor).close();
    currentLists.remove(cursor);
  }
}
