package gov.va.med.authentication.kernel.sspi.authentication.manageable;

/**
 * Miscellaneous utilities for the manageable sample authenticator
 * @author VHIT Security and Other Common Services (S&OCS)
 * @version 1.1.0.002
 */

final class Utils
{
  /**
   * Checks that a value (username, groupname, password, etc.) is valid.
   *
   * The manageable sample authenticator places some restrictions on user names,
   * group names and passwords.  This method enforces those restrictions.
   *
   * @param val A String containing the value to validate.
   *
   * @throws IllegalArgumentException if the name is not valid.
   */
  /*package*/ static void checkVal(String val)
  {
    if (val == null) {
      throw new IllegalArgumentException("value must not be null");
    }
    if (val.indexOf(",") >= 0) {
      throw new IllegalArgumentException("value must not contain \",\":\"" + val + "\"");
    }
    if (val.length() != val.trim().length()) {
      throw new IllegalArgumentException("value must not begin or end with whitespace:\"" + val + "\"");
    }
    if (val.length() == 0) {
      throw new IllegalArgumentException("value must not be empty");
    }
  }
}
