package gov.va.med.authentication.kernel.sspi.authentication.manageable;

import java.util.Iterator;

/**
 * Used to return a list of the groups immediately containing
 * a member.  That is, if group1 contains user1, and group2
 * contains group1, then only group1 will be listed for user1.
 *
 * 
 * @author VHIT Security and Other Common Services (S&OCS)
 * @version 1.1.0.002
 */

/*package*/ 
class KaajeeMemberGroupsList implements KaajeeListManager.List
{
  // An Iterator of String listing the member's immediate groups' names
  private Iterator i;

  // The name of the current group on the list.
  private String current;

  /**
   * The constructor.
   *
   * @param groups an Iterator of String containing the member's groups' names.
   */
  /*package*/ KaajeeMemberGroupsList(Iterator groups)
  {
    i = groups;
    current = null;
    _advance();
  }

  /**
   * Does the list have a current element?
   *
   * @return a boolean indicating if the list has a current element
   *
   * @throws IllegalStateException if the list does not have a current element.
   */
  public boolean haveCurrent()
  {
    return (current != null);
  }

  /**
   * Get the current group's name.
   *
   * @return a String containing the current group's name
   *
   * @throws IllegalStateException if the list does not have a current element.
   */
  public String getCurrentName()
  {
    checkNotDone();
    return current;
  }

  /**
   * Advance the list to the next element.
   *
   * @throws IllegalStateException if the list does not have a current element.
   */
  public void advance()
  {
    checkNotDone();
    _advance();
  }

  /**
   * Terminate the list, freeing up any resources held on behalf of the list.
   * This closes the list regardless of whether or not the list has been
   * completely traversed.  This allows the customer to partially traverse
   * the list without leaking memory or resources.
   */
  public void close()
  {
    current = null;
  }

  /**
   * A utility to check that the list has a current element.
   *
   * @throws IllegalStateException if the list does not have a current element.
   */
  private void checkNotDone()
  {
    if (!haveCurrent()) {
      throw new IllegalStateException("List out of elements");
    }
  }

  /**
   * A utility to advance the list to the next element.
   */
  private void _advance()
  {
    current = (i.hasNext()) ? (String)i.next() : null;
  }
}
