<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="/tags/struts-logic" prefix="logic" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/fw" prefix="fw" %>
<%@ taglib uri="/tags/authz" prefix="auth" %>
<%@ page import='gov.va.med.esr.common.model.lookup.Capability' %>

<c:set var="recordLocked" scope="page"><bean-el:message key="label.recordLocked"/></c:set>
<c:set var="contextPath" scope="page"><%=request.getContextPath()%></c:set>

<c:if test="${veteranHeaderBean != null && veteranHeaderBean.anyDataPresent == 'true'}">
  <table class="conPanelHeadTable" style="border: 1px solid #000000;" id="tableVeteranHeader" cellSpacing="0" cellPadding="0" width="100%" border="0">
    <c:if test="${veteranHeaderBean.sensitiveRecord == 'true'}">
    <tr>
      <td>
        <table cellSpacing="0" cellPadding="0" width="100%" border="0">
          <tr>
              <td width="1%" nowrap class="sensitiveHeader" style="padding: 3"><bean-el:message key="header.sensitiveRecord"/></td>
          </tr>
        </table>
      </td>
    </tr>
    </c:if>

<!-- FDD -->
 
 <c:if test="${veteranHeaderBean.futureDischargeDate != null}">  
    <tr>
      <td>
        <table cellSpacing="0" cellPadding="0" width="100%" border="0">
          <tr>
              <td width="1%" nowrap class="futureDischargeDateHeader" style="padding: 3">
				<c:set var="fstr1" value="${veteranHeaderBean.futureDischargeDate}"/>
				<%
				String fstr1 = (String) pageContext.getAttribute("fstr1");
				%>              
              	<bean-el:message key="header.futureDischargeDate"/><%= org.owasp.esapi.ESAPI.encoder().encodeForHTML(fstr1) %></td>
          </tr>
        </table>
      </td>
    </tr>
 </c:if>

    <c:if test="${veteranHeaderBean.line1DataPresent == 'true'}">
    <tr>
      <td>
        <table cellSpacing="0" cellPadding="0" width="100%" border="0">
          <tr>
			<auth:authorize ifAnyGranted="<%=Capability.MERGE_VETERAN%>">  
            <c:if test="${veteranHeaderBean.dataMergePending == 'true'}">
              <td width="1%" nowrap class="conPanelHeadCenter" style="text-align:center; padding: 0px 4px 0px 0px">
				<c:set var="mstr1" value="${veteranHeaderBean.mergInfoID}"/>
				<%
				String mstr1 = (String) pageContext.getAttribute("mstr1");
				%>
				<a href="/esr/person/personMergeWorklist.do?methodName=SELECT+PERSON&amp;selectedPersonMergeInfoId=<%= org.owasp.esapi.ESAPI.encoder().encodeForHTML(mstr1) %>">  <bean-el:message key="header.dataMergePending"/> </a>
              </td>
            </c:if>
			</auth:authorize>	
			  
			<auth:authorize ifAnyGranted="<%=Capability.MANAGE_WORKLIST%>">				
            <c:if test="${veteranHeaderBean.openCases == 'true'}">
              <td width="1%" nowrap class="conPanelHeadCenter" style="text-align:center; padding: 0px 4px 0px 0px">
                <html-el:link forward="viewOpenItems.display"><bean-el:message key="link.name.openWorkItems"/></html-el:link>
              </td>
            </c:if>
			</auth:authorize>  
				
            <c:if test="${veteranHeaderBean.personLockReason != null}">
              <td width="1%" nowrap style="text-align:center; padding: 4px 4px 0px 4px">
                <html-el:img alt="${recordLocked}" style="vertical-align: middle;" border="0" src="${contextPath}/images/lock.gif" width="12" height="15"/>
                <span class="conPanelHeadLabelRight" style="padding: 0px 0px 0px 0px"><bean-el:message key="header.lockReason"/>:</span>
				<c:set var="pstr1" value="${veteranHeaderBean.personLockReason}"/>
				<%
				String pstr1 = (String) pageContext.getAttribute("pstr1");
				%>
				<span class="conPanelHeadCenter" style="padding: 0px 4px 0px 0px"><%= org.owasp.esapi.ESAPI.encoder().encodeForHTML(pstr1) %></span>                
              </td>
            </c:if>
          </tr>
        </table>
      </td>
    </tr>
    </c:if>
    <c:if test="${veteranHeaderBean.line2DataPresent == 'true'}">
    <tr>
      <td>
        <table cellSpacing="0" cellPadding="0" width="100%" border="0">
          <tr>
             <c:if test="${veteranHeaderBean.sensitiveRecord}">
              <td width="1%" nowrap style="text-align:center">
                <span class="conPanelHeadLabelRight" style="padding: 3px 0px 3px 4px"><c:out value=""/></span>
                <span class="conPanelHeadCenter" style="padding: 3px 4px 3px 0px"><bean-el:message key="header.sensitiveRecord"/></span>
              </td>
            </c:if>
            
            
              <td width="1%" nowrap style="text-align:center">
                <span class="conPanelHeadLabelRight" style="padding: 3px 0px 3px 4px"><bean-el:message key="header.memberId"/>:</span>
				<c:set var="mistr1" value="${veteranHeaderBean.memberId}"/>
				<%
				String mistr1 = (String) pageContext.getAttribute("mistr1");
				%>
				<span class="conPanelHeadCenter" style="padding: 3px 4px 3px 0px"><c:if test="${veteranHeaderBean.memberId != null && veteranHeaderBean.memberId != ''}"><%= org.owasp.esapi.ESAPI.encoder().encodeForHTML(mistr1) %></c:if></span>                
              </td>
            
            <c:if test="${veteranHeaderBean.name != null}">
              <td width="1%" nowrap style="text-align:center">
                <span class="conPanelHeadLabelRight" style="padding: 3px 0px 3px 4px"><bean-el:message key="header.name"/>:</span>
				<c:set var="nstr1" value="${veteranHeaderBean.name}"/>
				<%
				String nstr1 = (String) pageContext.getAttribute("nstr1");
				%>
				<span class="conPanelHeadCenter" style="padding: 3px 4px 3px 0px"><%= org.owasp.esapi.ESAPI.encoder().encodeForHTML(nstr1) %></span>
              </td>
            </c:if>
            <c:if test="${veteranHeaderBean.ssn != null}">
              <td width="1%" nowrap style="text-align:center">
                <span class="conPanelHeadLabelRight" style="padding: 3px 0px 3px 4px"><bean-el:message key="header.ssn"/>:</span>
				<c:set var="sstr1" value="${veteranHeaderBean.ssn}"/>
				<%
				String sstr1 = (String) pageContext.getAttribute("sstr1");
				%>
				<span class="conPanelHeadCenter" style="padding: 3px 4px 3px 0px"><%= org.owasp.esapi.ESAPI.encoder().encodeForHTML(sstr1) %></span>
              </td>
            </c:if>
            <c:if test="${veteranHeaderBean.dob != null}">
              <td width="1%" nowrap style="text-align:center">
                <span class="conPanelHeadLabelRight" style="padding: 3px 0px 3px 4px"><bean-el:message key="header.dob"/>:</span>
				<c:set var="dstr1" value="${veteranHeaderBean.dob}"/>
				<%
				String dstr1 = (String) pageContext.getAttribute("dstr1");
				%>
				<span class="conPanelHeadCenter" style="padding: 3px 4px 3px 0px"><%= org.owasp.esapi.ESAPI.encoder().encodeForHTML(dstr1) %></span>
              </td>
            </c:if>
            <c:if test="${veteranHeaderBean.dod != null}">
              <td width="1%" nowrap style="text-align:center">
                <span class="conPanelHeadLabelRight" style="padding: 3px 0px 3px 4px"><bean-el:message key="header.dod"/>:</span>
				<c:set var="dostr1" value="${veteranHeaderBean.dod}"/>
				<%
				String dostr1 = (String) pageContext.getAttribute("dostr1");
				%>
				<span class="conPanelHeadCenter" style="padding: 3px 4px 3px 0px"><%= org.owasp.esapi.ESAPI.encoder().encodeForHTML(dostr1) %></span>
              </td>
            </c:if>
            <c:if test="${veteranHeaderBean.status != null}">
              <td width="1%" nowrap style="text-align:center">
                <span class="conPanelHeadLabelRight" style="padding: 3px 0px 3px 4px"><bean-el:message key="header.enrollmentStatus"/>:</span>
				<c:set var="ststr1" value="${veteranHeaderBean.status}"/>
				<%
				String ststr1 = (String) pageContext.getAttribute("ststr1");
				%>
				<span class="conPanelHeadCenter" style="padding: 3px 4px 3px 0px"><%= org.owasp.esapi.ESAPI.encoder().encodeForHTML(ststr1) %></span>
              </td>
            </c:if>
          </tr>
        </table>
      </td>
    </tr>
    </c:if>
  </table>
</c:if>

