<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/fw" prefix="fw" %>
<%@ taglib uri="/tags/esr-core" prefix="esrcore" %>
<%@ taglib uri="/tags/authz" prefix="auth" %>
<%@ page import='gov.va.med.esr.common.model.lookup.Capability' %>

<c:set var="viewParsedMessage" value="false"/>
<c:set var="viewRawMessage" value="false"/>
<auth:authorize ifAnyGranted="<%=Capability.VIEW_PARSED_MESSAGE.getName()%>"> 
	<c:set var="viewParsedMessage" value="true"/>   	
</auth:authorize>
<auth:authorize ifAnyGranted="<%=Capability.VIEW_RAW_MESSAGE.getName()%>"> 
	<c:set var="viewRawMessage" value="true"/>   	
</auth:authorize>

<c:if test="${fromEE == 'true'}">
	<jsp:include page="/tiles/common/veteranHeader.jsp"/>
	<c:if test="${veteranHeaderBean != null && veteranHeaderBean.anyDataPresent == 'true'}">
		<jsp:include page="/tiles/common/menu.jsp"/>
		<c:set var="eligibilityImage" scope="page">on</c:set>
		<c:set var="eligibilityText" scope="page" value="${selectedTabText}${eligibilityText}"/>
	</c:if> 
</c:if>

<html-el:form action="/ccnMessageDetail" method="post">
<%@ include file="/admin/csrfgentoken.jsp"%>
<c:if test="${selectedCCNMessage != null}">
	<c:set var="messageId" value="${selectedCCNMessage.entityKey.keyValueAsString}"/>
</c:if>
<c:if test="${selectedCCNTraits != null}">
	<c:set var="ssnText" value="${selectedCCNTraits.ssn}"/>
</c:if>
<table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShell" role="presentation">
<tr>
    <td width="100%">
    	<table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableBody" role="presentation">
	   <tr>
	     <td>
	    	<table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead" role="presentation">
		 <tr> 
			<td class="moduleBlueBox"><img alt=""  src="../images/spacer.gif" width="28" height="23"/></td>
			<td width="80%" class="moduleHeadline"><bean-el:message key="title.ccnMessage.detail" /></td>
			<c:choose>
				<c:when test = "${fromEE == true}">
					<td nowrap class="moduleBlueLink" style="padding: 1 8 1 8"><fw:link action="contractorMessageAction?methodName=findFromEE"><bean-el:message key="label.message.backToMessageLog"/></fw:link></td>
				</c:when>
				<c:otherwise>
					<td nowrap class="moduleBlueLink" style="padding: 1 8 1 8"><fw:link action="contractorMessageAction?methodName=FIND"><bean-el:message key="label.message.backToMessageLog"/></fw:link></td>
				</c:otherwise>
			</c:choose>
			<td><img alt=""  src="../images/spacer.gif" width="5"/></td>		
		 </tr>
    		</table>
	     </td>
	    </tr>
                  
	    <tr><td class="moduleValue">
	     
	     	<c:choose>
	     	<c:when test="${selectedCCNMessage != null}">
		    <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableBody" role="presentation">
		      <tr>
			 <td width="45%" class="moduleLabel"><bean-el:message key="label.CCNMessage.sentTo" />:</td>
			 <td width="55%" class="moduleValue" nowrap><esrcore:displayValue name="selectedCCNMessage" property="comment"/></td>
		     </tr>
		      <tr>
			 <td width="45%" class="moduleLabel"><bean-el:message key="label.message.transmissionDate" />:</td>
			 <td width="55%" class="moduleValue" nowrap><esrcore:displayDate name="selectedCCNMessage" dateProperty="transmissionDate" displayTime="true" nullText=""/></td>
		      </tr>
		     <tr>
			 <td width="45%" class="moduleLabel"><bean-el:message key="label.CCNMessage.status" />:</td>
			 <td width="55%" class="moduleValue" nowrap><esrcore:displayValue name="selectedCCNMessage" property="transmissionStatusType.name"/></td>
		     </tr>
		      <tr>
			 <td class="moduleLabel"><bean-el:message key="label.CCNMessage.type" />:</td>
			 <td class="moduleValue"><esrcore:displayValue name="selectedCCNMessage" property="transmissionType.name"/></td>
		      </tr>
		      <tr>
			<td class="moduleLabel"><bean-el:message key="label.CCNMessage.requestedDate" />:</td>
			<td class="moduleValue" nowrap><esrcore:displayDate name="selectedCCNMessage" dateProperty="modifiedOn" displayTime="true" nullText=""/></td>
		      </tr>
		      <tr>
			<td class="moduleLabel"><bean-el:message key="label.CCNMessage.requestingUser" />:</td>
			<td class="moduleValue" nowrap>
				<esrcore:displayLookupValue name="selectedCCNMessage" lookupType="gov.va.med.esr.common.model.security.ESRUserPrincipalImpl" property="createdBy.name" /></td>
		      </tr>
		      <tr>
			<td class="moduleLabel"><bean-el:message key="label.CCNMessage.ICN" />:</td>
			<td class="moduleValue"><esrcore:displayValue name="selectedCCNMessage" property="person.VPIDValue"/></td>
		      </tr>
		      <tr>
			<td class="moduleLabel"><bean-el:message key="label.CCNMessage.memberId" />:</td>
			<td class="moduleValue"><esrcore:displayValue name="selectedCCNMessage" property="edipi"/></td>
		      </tr>
		      <tr>
		      	<td class="moduleLabel"><bean-el:message key="label.CCNMessage.SSN" />:</td>
		      	<td class="moduleValue"><c:out value="${ssnText}" /></td>
		      </tr>
		      <tr>
			<td class="moduleLabel"><bean-el:message key="label.CCNMessage.veteranName" />:</td>
			<td class="moduleValue"><esrcore:displayValue name="selectedCCNMessage" property="fullName"/></td>
		      </tr>
		    <tr>
			<td class="moduleLabel"><bean-el:message key="label.CCNMessage.birthSex" />:</td>
			<td class="moduleValue"><esrcore:displayValue name="selectedCCNMessage" property="birthSex"/></td>
      		</tr>
      		<tr>
			<td class="moduleLabel"><bean-el:message key="label.CCNMessage.dateOfBirth" />:</td>
			<td class="moduleValue"><esrcore:displayValue name="selectedCCNMessage" property="dateOfBirth"/></td>
      		</tr>
      		<tr>
			<td class="moduleLabel"><bean-el:message key="label.CCNMessage.dod" />:</td>
			<td class="moduleValue"><esrcore:displayValue name="selectedCCNMessage" property="dateOfDeath" nullText=""/></td>
      		</tr>
      		<tr>
			<td class="moduleLabel"><bean-el:message key="label.CCNMessage.resAddress" />:</td>
			<td class="moduleValue"><esrcore:displayValue name="selectedCCNMessage" property="residentialAddress"/></td>
      		</tr>
      		<tr>
			<td class="moduleLabel"><esrcore:displayValue name="selectedCCNMessage" property="mailingAddress.type.description" nullText=""/> Mailing Address:</td>
			<td class="moduleValue"><esrcore:displayValue name="selectedCCNMessage" property="mailingAddress"/></td>
      		</tr>
      		<tr>
			<td class="moduleLabel"><bean-el:message key="label.CCNMessage.badAddInd" />:</td>
			<td class="moduleValue"><esrcore:displayValue name="selectedCCNMessage" property="mailingAddress.badAddressReason.code" nullText=""/></td>
      		</tr>
      		<tr>
			<td class="moduleLabel"><bean-el:message key="label.CCNMessage.persEmail" />:</td>
			<td class="moduleValue"><esrcore:displayValue name="selectedCCNMessage" property="email"/></td>
      		</tr>
      		<tr>
			<td class="moduleLabel"><bean-el:message key="label.CCNMessage.homePhone" />:</td>
			<td class="moduleValue"><esrcore:displayValue name="selectedCCNMessage" property="homePhone"/></td>
      		</tr>
      		<tr>
			<td class="moduleLabel"><bean-el:message key="label.CCNMessage.cellPhone" />:</td>
			<td class="moduleValue"><esrcore:displayValue name="selectedCCNMessage" property="cellPhone"/></td>
      		</tr>
      		<tr>
			<td class="moduleLabel"><bean-el:message key="label.CCNMessage.tempPhone" />:</td>
			<td class="moduleValue"><esrcore:displayValue name="selectedCCNMessage" property="tempPhone"/></td>
      		</tr>
      		<tr>
			<td class="moduleLabel"><bean-el:message key="label.CCNMessage.prefFacility" />:</td>
			<td class="moduleValue"><esrcore:displayValue name="selectedCCNMessage" property="historicPreferredFacility.facility.siteNumberAndName" nullText=""/></td>
      		</tr>
      		<tr>
			<td class="moduleLabel"><bean-el:message key="label.CCNMessage.ccElig" />:</td>
			<td class="moduleValue"><esrcore:displayValue name="selectedCCNMessage" property="historicCCEligibility.vceStatusType.description" nullText=""/></td>
      		</tr>
      		<tr>
			<td class="moduleLabel"><bean-el:message key="label.CCNMessage.ccDet" />:</td>
			<td class="moduleValue"><esrcore:displayValue name="selectedCCNMessage" property="historicCCEligibility.modifiedOn" nullText=""/></td>
      		</tr>
      		<tr>
			<td class="moduleLabel"><bean-el:message key="label.CCNMessage.closeVisn" />:</td>
			<td class="moduleValue"><esrcore:displayValue name="selectedCCNMessage" property="visnGeo"/></td>
      		</tr>
      		<tr>
			<td class="moduleLabel"><bean-el:message key="label.CCNMessage.closeStationNum" />:</td>
			<td class="moduleValue"><esrcore:displayValue name="selectedCCNMessage" property="geoStation.stationNumber" nullText=""/></td>
      		</tr>
      		<tr>
			<td class="moduleLabel"><bean-el:message key="label.CCNMessage.closeStationName" />:</td>
			<td class="moduleValue"><esrcore:displayValue name="selectedCCNMessage" property="geoStation.stationName" nullText=""/></td>
      		</tr>
      		
      		
		    </table>
	      	</c:when>
	      	<c:otherwise>
	      		<bean-el:message key="label.noDataAvailable" />
	      	</c:otherwise>
	      	</c:choose>
	      
	  </td></tr>
	</table>
    </td>
</tr>
</table>
</html-el:form>
