<%@ page import="gov.va.med.esr.ui.financials.action.FinancialsOverviewAction"%>
<%@ page contentType="text/html;charset=UTF-8" %>
<%@ taglib uri="/tags/struts-bean" prefix="bean" %>
<%@ taglib uri="/tags/struts-html" prefix="html" %>
<%@ taglib uri="/tags/struts-logic" prefix="logic" %>
<%@ taglib uri="/tags/displaytag" prefix="display" %>
<%@ taglib uri="/tags/esr-core" prefix="esrcore" %>
<%@ taglib uri="/tags/valuelist" prefix="vlh" %>
<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/fw" prefix="fw" %>
<%@ taglib uri="/tags/authz" prefix="auth" %>
<%@ page import='gov.va.med.esr.common.model.lookup.Capability' %>

<c:set var="expandableSectionCollapsed" scope="page"><bean-el:message key="label.expandableSectionCollapsed"/></c:set>
<c:set var="expandableSectionExpanded" scope="page"><bean-el:message key="label.expandableSectionExpanded"/></c:set>


<script>
function onLoadInit()
{
}


</script>
>


<c:set var="addIncomeTest" value ="false"/>
<c:set var="editIncomeTest" value ="false"/>
<c:set var="addIncomeTestCode"><%=Capability.ADD_INCOME_TEST.getName()%></c:set>
<c:set var="editIncomeTestCode"><%=Capability.EDIT_INCOME_TEST.getName()%></c:set>

<c:set var="yesLabel"><bean-el:message key="label.yes"/></c:set>
<c:set var="noLabel"><bean-el:message key="label.no"/></c:set>

<auth:authorize ifAnyGranted="${addIncomeTestCode},${editIncomeTestCode}">
<c:set var="addIncomeTest" value ="true"/>
</auth:authorize>
<auth:authorize ifAnyGranted="${editIncomeTestCode}">
<c:set var="editIncomeTest" value ="true"/>
</auth:authorize>

<%-- Person Locked Check --%>
<c:set var="appData" value="${AppData}" scope="session"/>
<c:set var="personKey" value="SelectedPerson"/>
<c:set var="personLocked" value="${appData[personKey].personLocked}"/>
<c:if test="${personLocked}">
  <c:set var="addIncomeTest" value="false"/>
  <c:set var="editIncomeTest" value="false"/>
</c:if>

<table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShell" role="presentation">
<html-el:form action="/financialsOverview" method="post">
  <%@ include file="/admin/csrfgentoken.jsp" %>
  <tr>
    <td>
      <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTable" role="presentation">
        <%-- Financials Overview Header --%>
        <tr>
          <td>
            <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead" role="presentation">
              <tr>
                <td class="moduleBlueBox"><img alt=""  src="../images/spacer.gif" width="28" height="23"/></td>
                <td nowrap style="padding-left: 7"><bean-el:message key="title.financials.overview"/></td>
                <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
              </tr>
            </table>
          </td>
        </tr>

        <tr>
          <td>
            <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
              <c:set var="incomeYearSelectAYearLabel"><bean-el:message key="label.incomeYear.selectAYear"/></c:set>
              <tr style="padding:20 0 20 0">
                <td style="padding:0 5 0 10" nowrap class="moduleLabel"><fw:label property="incomeYear" forId="incomeYearSelId"><bean-el:message key="label.incomeYear.selectAYear"/>:</fw:label></th>
                <td class="moduleValue">
                  <html-el:select title="${incomeYearSelectAYearLabel}" styleClass="moduleEdit initfocus" styleId="incomeYearSelId" property="incomeYear" >
					<esrcore:options collection="<%= FinancialsOverviewAction.VALID_INCOME_YEAR_LIST_SESSION_KEY %>" property="value" labelProperty="label"/>
                  </html-el:select>
                </td>
                <td style="padding:0 0 0 15"><img alt=""  src="../images/buttonEndLeft.gif"/></td>
                <td><html-el:submit property="methodName" style="width:70; vertical-align: top;" styleClass="buttonText"><bean:message key="button.viewData"/></html-el:submit></td>
                <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
                <!--  change td wind="100%" to 10% -->
                <td width="10%"><img alt=""  src="../images/spacer.gif"></td>

                <!-- new button for print1010EZ and 1010EZR form -->
                <td style="padding:0 0 0 15"><img alt=""  src="../images/buttonEndLeft.gif"/></td>
                <td><html-el:submit property="methodName" style="width:90; vertical-align: top;" styleClass="buttonText"><bean:message key="button.print1010EZ"/></html-el:submit></td>
                <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
                <td width="10%"><img alt=""  src="../images/spacer.gif"></td>

                <td style="padding:0 0 0 15"><img alt=""  src="../images/buttonEndLeft.gif"/></td>
                <td><html-el:submit property="methodName" style="width:90; vertical-align: top;" styleClass="buttonText"><bean:message key="button.print1010EZR"/></html-el:submit></td>
                <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
                <td width="100%"><img alt=""  src="../images/spacer.gif"></td>

              </tr>
            </table>
          </td>
        </tr>

        <%-- Financial Assessment --%>
        <tr>
          <td>
            <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellLowTableHead" role="presentation">
              <tr>
                <td class="moduleBrownBox"><img alt=""  src="../images/spacer.gif" width="29" height="1"/></td>
                <td>&nbsp;</td>
                <td class="moduleLabel" nowrap>
                  <fw:link href="." onclick="expandOrCollapse(finAssessBlock, finAssessImage, finAssessHiddenId); return false">
                    <html-el:img alt="${expandableSectionExpanded}" align="center" border="0" styleId="finAssessImage" src="../images/redArrowDown.gif"/><c:choose><c:when test="${FinancialsForm.isCurrentIncomeTest == 'true'}"><bean:message key="title.overview"/></c:when><c:otherwise><bean:message key="title.overview.previous"/></c:otherwise></c:choose>
                  </fw:link>
                  <fw:label property="finAssessHiddenId" forId="finAssessHiddenId"><span style="display:none">finAssessHiddenId</span></fw:label>
                  <input name="finAssessHiddenId" id="finAssessHiddenId" type="hidden" value="false"/>
                </td>
                <td align="left" nowrap>&nbsp;(<bean:message key="title.incomeyear"/>
                  <esrcore:displayValue name="FinancialsForm" property="incomeYear"/>)
                </td>
                <td width="100%"><img alt=""  src="../images/spacer.gif"></td>

                <%-- TODO: Change html-el links to fw:links --%>
				<%-- Verify that user has permissions to add or edit incometest --%>
				<c:if test="${(FinancialsForm.incometest != null && editIncomeTest == true) || (FinancialsForm.incometest == null && addIncomeTest == true)}">
                	<td nowrap class="moduleBlueLink" style="padding: 1 8 1 8"><html-el:link action="financialsDependentOverview?methodName=DEPENDENTS"><bean-el:message key="link.button.viewEditDeps"/></html-el:link></td>
					<td><img alt=""  src="../images/spacer.gif" width="5"/></td>
					<td nowrap class="moduleBlueLink" style="padding: 1 8 1 8"><html-el:link action="financialDetailsEdit?methodName=DISPLAY"><bean-el:message key="link.button.viewEditFinancials"/></html-el:link></td>
					<td><img alt=""  src="../images/spacer.gif" width="5"/></td>
				</c:if>
				<td nowrap class="moduleBlueLink" style="padding: 1 8 1 8">
					<fw:link action="/financialsHistory?methodName=DISPLAY&amp;history=viewHistoricalFinancials">
						<bean-el:message key="label.viewHistory"/>
					</fw:link>
				</td>

              </tr>
            </table>
          </td>
        </tr>

      <c:choose>
      <c:when test="${FinancialsForm.incometest != null}">
        <tr>
          <td>
            <div id="finAssessBlock" style="display:block">
            <table width="100%" border="0" cellpadding="0" cellspacing="0" role="presentation">
              <tr>
                <td valign="top" class="darkLabel" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.financials.disclose"/>:</th>
                <td class="darkValue" valign="top" nowrap><esrcore:displayValue name="FinancialsForm" property="incometest.discloseFinancialInformation"/></td>
                <td class="darkValue" width="50%"><img alt=""  src="../images/spacer.gif"></td>
                <td class="darkLabel" valign="top" class="label" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.financials.agreedeductible"/>:</th>
                <td class="darkValue" valign="top" nowrap><esrcore:displayValue name="FinancialsForm" property="incometest.agreesToPayDeductible"/></td>
                <td class="darkValue" width="50%"><img alt=""  src="../images/spacer.gif"></td>
              </tr>
              <tr>
                <td class="label" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.financials.primarytesttype"/>:</th>
                <td class="value" valign="top" nowrap><esrcore:displayValue name="FinancialsForm" property="incometest.primaryTestType.description"/></td>
                <td class="label">&nbsp;</td>
                <td class="label" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.financials.testeffdate"/>:</th>
                <td class="value" valign="top" nowrap><esrcore:displayValue name="FinancialsForm" property="incometest.effectiveDate"/></td>
                <td class="label">&nbsp;</td>
              </tr>
              <tr>
                <td valign="top" class="darkLabel" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.financials.testdeterminedstatus"/>:</th>
                <td class="darkValue" valign="top" nowrap><esrcore:displayValue name="FinancialsForm" property="testDeterminedStatus"/></td>
                <td class="darkValue" width="50%"><img alt=""  src="../images/spacer.gif"></td>
                <td class="darkLabel" valign="top" class="label" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.financials.teststatus"/>:</th>
                <td class="darkValue" valign="top" nowrap><esrcore:displayValue name="FinancialsForm" property="testStatus"/></td>
                <td class="darkValue" width="50%"><img alt=""  src="../images/spacer.gif"></td>
              </tr>
              <tr>
			  	<c:set var="reportSite" value="${FinancialsForm.incometest.siteConductingTest.stationNumber}" />
				<c:set var="reportSiteName" value="${FinancialsForm.incometest.siteConductingTest.name}" />


                <td class="label" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.financials.siteconductingtest"/>:</th>
                <td class="value" valign="top"><c:out value="${reportSiteName}" />
                	<c:if test="${reportSite != null}">
						(# <c:out value="${reportSite}" /> )
					</c:if>
				</td>
                <td class="label">&nbsp;</td>
                <td class="label" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.financials.datetestcompleted"/>:</th>
                <td class="value" valign="top" nowrap><esrcore:displayValue name="FinancialsForm" property="incometest.completedDate"/></td>
                <td class="label">&nbsp;</td>
              </tr>
              <tr>
                <td valign="top" class="darkLabel" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.financials.cad"/>:</th>
                <td class="darkValue" valign="top" nowrap><esrcore:displayValue name="FinancialsForm" property="incometest.cadAdjusted"/></td>
                <td class="darkValue" width="50%"><img alt=""  src="../images/spacer.gif"></td>
                <td class="darkLabel" valign="top" class="label" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.financials.adjudicationdate"/>:</th>
                <td class="darkValue" valign="top" nowrap><esrcore:displayValue name="FinancialsForm" property="incometest.adjudicationDate"/></td>
                <td class="darkValue" width="50%"><img alt=""  src="../images/spacer.gif"></td>
              </tr>
              <tr>
                <td class="label" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.financials.rxcopaystatus"/>:</th>
                <td class="value" valign="top" nowrap><esrcore:displayValue name="FinancialsForm" property="rxCopayStatus"/></td>
                <td class="label">&nbsp;</td>
                <td class="label" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.financials.longtermcarestatus"/>:</th>
                <td class="value" valign="top" nowrap><esrcore:displayValue name="FinancialsForm" property="ltcCopayStatus"/></td>
                <td class="label">&nbsp;</td>
              </tr>
              <tr>
                <td valign="top" class="darkLabel" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.financials.hardshipgranted"/>:</th>
                <td class="darkValue" valign="top" nowrap><esrcore:displayValue name="FinancialsForm" property="incometest.hardship.hardshipGranted"/></td>
                <td class="darkValue" width="50%"><img alt=""  src="../images/spacer.gif"></td>
                <td class="darkLabel" valign="top" class="label" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.financials.sourceoffinancialinfo"/>:</th>
                <td class="darkValue" valign="top" nowrap><esrcore:displayValue name="FinancialsForm" property="incometest.source.description"/></td>
                <td class="darkValue" width="50%"><img alt=""  src="../images/spacer.gif"></td>
              </tr>
              <tr>
                <td class="label" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.financials.noinpatientdays"/>:</th>
                <td class="value" valign="top" nowrap><esrcore:displayValue name="FinancialsForm" property="totalInpatientDays"/></td>
                <td class="label">&nbsp;</td>
                <td class="label" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.financials.nooutpatientdays"/>:</th>
                <td class="value" valign="top" nowrap><esrcore:displayValue name="FinancialsForm" property="totalOutpatientVisits"/></td>
                <td class="label">&nbsp;</td>
              </tr>
              <tr>
                <td valign="top" class="darkLabel" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.financials.marriedlastcalyear"/>:</th>
                <td class="darkValue" valign="top" nowrap><esrcore:displayValue name="FinancialsForm" property="financialStatement.marriedLastCalendarYear"/></td>
                <td class="darkValue" width="50%"><img alt=""  src="../images/spacer.gif"></td>
              <c:choose>
              <c:when test="${FinancialsForm.canFinancialsBeAdded == 'true'}">
                <td class="darkLabel" valign="top" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.financials.dependents.total"/></th>
                <td class="darkValue" valign="top" nowrap><esrcore:displayValue name="FinancialsForm" property="incometest.totalNumberOfDependents"/></td>
                <td class="darkValue" width="50%"><img alt=""  src="../images/spacer.gif"></td>
              </c:when>
              <c:otherwise>
                <td class="darkLabel" valign="top" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.financials.pg8indicator"/>:</td>
                <td class="darkValue" valign="top" nowrap><esrcore:displayValue name="FinancialsForm" property="incometest.pg8RelaxationIndicator"/></td>
                <td class="darkValue" width="50%"><img alt=""  src="../images/spacer.gif"></td>
              </c:otherwise>
              </c:choose>
              </tr>
              <c:if test="${FinancialsForm.canFinancialsBeAdded == 'true'}">
              <tr>
                <td class="label" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.financials.pg8indicator"/>:</td>
                <td class="value" valign="top" nowrap><esrcore:displayValue name="FinancialsForm" property="incometest.pg8RelaxationIndicator"/></td>
                <td class="label">&nbsp;</td>
                <td class="label" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.financials.btfinancialind"/>:</td>
                <td class="value" style="text-align: left" nowrap><esrcore:displayValue name="FinancialsForm" property="btFinancialInd"/></td>
  				<td class="label">&nbsp;</td>
              </tr>
              </c:if>
              <c:if test="${FinancialsForm.canFinancialsBeAdded == 'false'}">
              <tr>
              <td class="label" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.financials.btfinancialind"/>:</td>
              <td class="value" style="text-align: left" nowrap><esrcore:displayValue name="FinancialsForm" property="btFinancialInd"/></td>
  				<td class="label"></td>
  				<td class="label" style="text-align: left; padding-left: 10" ><img alt=""  src="../images/spacer.gif"></td>
  				<td class="label"></td>
  				<td class="label" style="text-align: left; padding-left: 10"><img alt=""  src="../images/spacer.gif"></td>
              </tr>
              </c:if>
            </table>
            </div>
          </td>
        </tr>

      <%-- Dependent Information --%>
            <c:if test="${FinancialsForm.canFinancialsBeAdded == 'true'||FinancialsForm.canFinancialsBeAdded == 'false'}">
        <tr>
          <td>
            <%-- TODO: Check if # of dependents is 0 and display "no data" and disable expand/collapse --%>
            <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellLowTableHead" role="presentation">
              <tr>
                <td class="moduleBrownBox"><img alt=""  src="../images/spacer.gif" width="29" height="1"/></td>
                <td>&nbsp;</td>
                <td class="moduleLabel" nowrap>
                  <fw:link href="." onclick="expandOrCollapse(depBlock, depImage, depHiddenId); return false">
                    <html-el:img alt="${expandableSectionCollapsed}" align="center" border="0" styleId="depImage" src="../images/redArrowRight.gif"/><bean-el:message key="title.dependents"/>
                  </fw:link>
                  <input name="depHiddenId" id="depHiddenId" type="hidden" value="false"/>
                </td>
                <td nowrap>
                  &nbsp;(<c:out value="${vlDepend.valueListInfo.totalNumberOfEntries}"/> &nbsp;<bean:message key="label.financials.total"/>)
                </td>
                <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
              </tr>
            </table>
          </td>
        </tr>
        <tr>
          <td>
            <div id="depBlock" class="expandCollapseBody">
                 <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
       <c:choose>
        <c:when test="${vlDepend==null ||vlDepend.valueListInfo==null ||vlDepend.valueListInfo.totalNumberOfEntries == 0}">
          <tr>
            <td class="darkValue" style="padding:10 0 10 10; text-align: left"><bean-el:message key="label.noDataAvailable"/></td>
          </tr>
        </c:when>
        <c:otherwise>
          <tr valign="top" width="100%">
            <td vAlign="top" align="center">
              <div id="dependentLink" style="border-width:0px;">
                <table id="dependentResult" align="center" width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleTable" role="presentation">
                  <vlh:root id="dependentTableId" value="vlDepend" url="?" includeParameters="*" configName="valueListConfigBeanLookAndFeel">
                    <tr>
                      <td colspan="5">
                        <table class="pagelinks">
                          <tr>
                            <td width="45%"><img alt=""  src="../images/spacer.gif"></td>
                            <td width="5%" nowrap="true">
				                          <span class="pagebanner"><c:out value="${vlDepend.valueListInfo.totalNumberOfEntries}"/> Total
				                          - Page (<c:out value="${vlDepend.valueListInfo.pagingPage}"/> of <c:out value="${vlDepend.valueListInfo.totalNumberOfPages}"/>).
				                          &nbsp;</span>
                            </td>
                            <td width="5%">
                              <c:choose>
                                <c:when test="${vlDepend.valueListInfo.totalNumberOfPages > 1}">
                                  <vlh:paging attributes="class=\"pagelinks\"" pages="10"><c:out value="${pagedependentTableId}"/>&nbsp;</vlh:paging>
                                </c:when>
                                <c:otherwise>
                                  &nbsp;
                                </c:otherwise>
                              </c:choose>
                            </td>
                            <td width="45%"><img alt=""  src="../images/spacer.gif"></td>
                          </tr>
                        </table>
                      </td>
                    </tr>
                    <tr vAlign="top">
                      <td vAlign="top" align="center">
        <tr>
        <td>
 			<table summary="List of Spouse and Dependent for the Income Year" rules="all" class="TableDisplay" role="presentation">
                <tr>
                  <vlh:row bean="relationFinancialInfoBean">
                	<vlh:column property="ssn" title="SSN"  sortable="asc" attributes="align=\"left\" scope='col'" default="">
                    	<vlh:attribute name="scope">row</vlh:attribute>
                      	<esrcore:displayValue name="relationFinancialInfoBean" property="ssn" nullText=""/>
                    </vlh:column>
                    <vlh:column property="name" title="Name" sortable="asc" attributes="align=\"left\" scope='col'" default="">
                      	<esrcore:displayValue name="relationFinancialInfoBean" property="name" nullText=""/>
                    </vlh:column>
                    <vlh:column property="relationship" title="Relationship" sortable="asc" attributes="align=\"left\" scope='col'" default="">
                      	<esrcore:displayValue name="relationFinancialInfoBean" property="relationship" nullText=""/>
                    </vlh:column>
                    <vlh:column property="dependencyFactors" title="Dependency Factors" sortable="asc" attributes="align=\"left\" scope='col'" default="">
                      	<esrcore:displayValue name="relationFinancialInfoBean" property="dependencyFactors" nullText=""/>
                    </vlh:column>
                  </vlh:row>
                </tr>
        	</table>
        	</td>
       </tr>
		</vlh:root>
       </table>
<!-- module shell table body-->
</td>
</tr>
        </c:otherwise>
      </c:choose>
</table>
            <!--
              <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
                <tr width="100%" vAlign="top">
                  <td width="100%" vAlign="top" align="center" colspan="2">
                    <display:table name="FinancialsForm.dependentInfoList" id="tblf01" class="TableDisplay" rules="all" pagesize="10" requestURI="/esr/financials/financialsOverview.do?methodName=Financials">
                      <display:column property="ssn" title="SSN" headerClass="DataHeader" sortable="true" />
                      <display:column property="name" title="Name" headerClass="DataHeader" sortable="true" />
                      <display:column property="relationship" title="Relationship" headerClass="DataHeader" sortable="true" />
                      <display:column property="dependencyFactors" title="Dependency Factors" headerClass="DataHeader" sortable="true" />
                    </display:table>
                  </td>
                </tr>
              </table>
            --></div>
          </td>
        </tr>
      </c:if>

        <%-- Financial Summary --%>
        <tr>
          <td>
            <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellLowTableHead" role="presentation">
              <tr>
                <td class="moduleBrownBox"><img alt=""  src="../images/spacer.gif" width="29" height="1"/></td>
                <td>&nbsp;</td>
                <td class="moduleLabel" nowrap>
                  <fw:link href="." onclick="expandOrCollapse(finSumBlock, finSumImage, finSumHiddenId); return false">
                    <html-el:img alt="${expandableSectionExpanded}" align="center" border="0" styleId="finSumImage" src="../images/redArrowDown.gif"/><bean-el:message key="title.finSummary"/>
                  </fw:link>
                  <input name="finSumHiddenId" id="finSumHiddenId" type="hidden" value="false"/>
                </td>
                <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
              </tr>
            </table>
          </td>
        </tr>
        <tr>
          <td>
            <div id="finSumBlock" style="display:block">
              <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
                <tr>
                  <td valign="top" class="darkLabel" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.financials.totalincome"/>:</th>
                  <td class="darkValue" valign="top" nowrap><esrcore:displayCurrency name="FinancialsForm" currencyProperty="incometest.totalIncome"/></td>
                  <td class="darkValue" width="50%"><img alt=""  src="../images/spacer.gif"></td>
                  <td class="darkLabel" valign="top" class="label" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.financials.netIncome"/>:</th>
                  <td class="darkValue" valign="top" nowrap><esrcore:displayCurrency name="FinancialsForm" currencyProperty="incometest.netIncome"/></td>
                  <td class="darkValue" width="50%"><img alt=""  src="../images/spacer.gif"></td>
                </tr>
                <tr>
                  <td class="label" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.financials.deductibleexpenses"/>:</th>
		  		  <td class="value" valign="top" nowrap><esrcore:displayCurrency name="FinancialsForm" currencyProperty="incometest.deductibleExpenses"/></td>
                  <td class="label">&nbsp;</td>
                  <td class="label" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.expense.adjustedMedical"/>:</th>
                  <td class="value" valign="top" nowrap><esrcore:displayCurrency name="FinancialsForm" currencyProperty="ajustedMedicalExp"/></td>
                  <td class="label">&nbsp;</td>
                </tr>
                <tr>
		  		  <td class="darkLabel" valign="top" class="label" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.financials.networth"/>:</th>
		  		  <td class="darkValue" valign="top" nowrap><esrcore:displayCurrency name="FinancialsForm" currencyProperty="incometest.netWorth"/></td>
		  		  <td class="darkValue" width="50%"><img alt=""  src="../images/spacer.gif"></td>
		  		  <td class="darkLabel" valign="top" class="label" style="text-align: left; padding-left: 10" nowrap>&nbsp;</th>
                  <td class="darkValue" valign="top" nowrap>&nbsp;</td>
                  <td class="darkValue" width="50%"><img alt=""  src="../images/spacer.gif"></td>
                </tr>
              </table>
            </div>
          </td>
        </tr>

        <%-- Financial Details --%>
      <c:if test="${FinancialsForm.canFinancialsBeAdded == 'false'}">
        <tr>
          <td>
            <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellLowTableHead" role="presentation">
              <tr>
                <td class="moduleBrownBox"><img alt=""  src="../images/spacer.gif" width="29" height="1"/></td>
                <td class="expandCollapseLink" align="left" style="padding: 4 7" onClick="expandOrCollapse(finDetBlock, finDetImage, finDetHiddenId); return false"><img alt=""  name="finDetImage" src="../images/redArrowRight.gif"/></td>
                <td class="expandCollapseLink" align="left" nowrap onClick="expandOrCollapse(finDetBlock, finDetImage, finDetHiddenId); return false">
                  <bean-el:message key="title.finDetails"/>
                  <input name="finDetHiddenId" id="finDetHiddenId" type="hidden" value="false"/>
                </td>
                <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
              </tr>
            </table>
          </td>
        </tr>
        <tr>
          <td>
            <div id="finDetBlock" class="expandCollapseBody">
              <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
              <%-- Make the following tables into parts of the Financial Summary module and not their own independent modules --%>
                <tr>
                  <td colspan="6">
                    <table width="100%" border="0" cellspacing="0" cellpadding="0" role="presentation">
                      <tr>
                        <td>
                          <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellLowTableHead" role="presentation">
                            <tr>
                              <td class="moduleBrownBox">&nbsp;</td>
                              <td width="650" class="moduleHeadline">Income</td>
                            </tr>
                          </table>
                 <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
       <c:choose>
        <c:when test="${vlIncome==null ||vlIncome.valueListInfo==null ||vlIncome.valueListInfo.totalNumberOfEntries == 0}">
          <tr>
            <td class="darkValue" style="padding:10 0 10 10; text-align: left"><bean-el:message key="label.noDataAvailable"/></td>
          </tr>
        </c:when>
        <c:otherwise>
          <tr valign="top" width="100%">
            <td vAlign="top" align="center">
              <div id="incomeLink" style="border-width:0px;">
                <table id="incomeResult" align="center" width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleTable" role="presentation">
                  <vlh:root id="incomeTableId" value="vlIncome" url="?" includeParameters="*" configName="valueListConfigBeanLookAndFeel">
                    <tr>
                      <td colspan="5">
                        <table class="pagelinks">
                          <tr>
                            <td width="45%"><img alt=""  src="../images/spacer.gif"></td>
                            <td width="5%" nowrap="true">
				                          <span class="pagebanner"><c:out value="${vlIncome.valueListInfo.totalNumberOfEntries}"/> Total
				                          - Page (<c:out value="${vlIncome.valueListInfo.pagingPage}"/> of <c:out value="${vlIncome.valueListInfo.totalNumberOfPages}"/>).
				                          &nbsp;</span>
                            </td>
                            <td width="5%">
                              <c:choose>
                                <c:when test="${vlIncome.valueListInfo.totalNumberOfPages > 1}">
                                  <vlh:paging attributes="class=\"pagelinks\"" pages="10"><c:out value="${pageincomeTableId}"/>&nbsp;</vlh:paging>
                                </c:when>
                                <c:otherwise>
                                  &nbsp;
                                </c:otherwise>
                              </c:choose>
                            </td>
                            <td width="45%"><img alt=""  src="../images/spacer.gif"></td>
                          </tr>
                        </table>
                      </td>
                    </tr>
                    <tr vAlign="top">
                      <td vAlign="top" align="center">
        <tr>
        <td>
 			<table summary="List of Income for the Income Year" rules="all" class="TableDisplay" role="presentation">
                <tr>
                  <vlh:row bean="financialInfoBean">
                	<vlh:column property="source" title="Name" sortable="asc" attributes="align=\"left\" scope='col'" default="">
                    	<vlh:attribute name="scope">row</vlh:attribute>
                      	<esrcore:displayValue name="financialInfoBean" property="source" nullText=""/>
                    </vlh:column>
                	<vlh:column property="amount" title="Amount" sortable="asc" attributes="align=\"left\" scope='col'" default="">
                      	<esrcore:displayValue name="financialInfoBean" property="amount" nullText=""/>
                    </vlh:column>
                    <vlh:column property="type" title="Income Source" sortable="asc" attributes="align=\"left\" scope='col'" default="">
                      	<esrcore:displayValue name="financialInfoBean" property="type" nullText=""/>
                    </vlh:column>
                  </vlh:row>
                </tr>
        	</table>
        	</td>
       </tr>
		</vlh:root>
       </table>
<!-- module shell table body-->
</td>
</tr>
        </c:otherwise>
      </c:choose>
</table>
                          <!--

                          <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
                            <tr width="100%" vAlign="top">
                              <td width="100%" vAlign="top" align="center" colspan="2">
                                <display:table name="FinancialsForm.incomes" id="tblf01" class="TableDisplay" rules="all" pagesize="10" requestURI="/esr/financials/financialsOverview.do?methodName=Financials">
                                  <display:column property="source" title="Name" headerClass="DataHeader" sortable="true" />
                                  <display:column property="amount" title="Amount" headerClass="DataHeader" sortable="true" />
                                  <display:column property="type" title="Income Source" headerClass="DataHeader" sortable="true" />
                                </display:table>
                              </td>
                            </tr>
                          </table>
                        --></td>
                      </tr>
                      <tr width="100%">
                        <td width="100%">
                          <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellLowTableHead" role="presentation">
                            <tr>
                              <td class="moduleBrownBox">&nbsp;</td>
                              <td width="650" class="moduleHeadline">Expense</td>
                            </tr>
                          </table>
                 <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
       <c:choose>
        <c:when test="${vlExpense==null ||vlExpense.valueListInfo==null ||vlExpense.valueListInfo.totalNumberOfEntries == 0}">
          <tr>
            <td class="darkValue" style="padding:10 0 10 10; text-align: left"><bean-el:message key="label.noDataAvailable"/></td>
          </tr>
        </c:when>
        <c:otherwise>
          <tr valign="top" width="100%">
            <td vAlign="top" align="center">
              <div id="expenseLink" style="border-width:0px;">
                <table id="expenseResult" align="center" width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleTable" role="presentation">
                  <vlh:root id="expenseTableId" value="vlExpense" url="?" includeParameters="*" configName="valueListConfigBeanLookAndFeel">
                    <tr>
                      <td colspan="5">
                        <table class="pagelinks">
                          <tr>
                            <td width="45%"><img alt=""  src="../images/spacer.gif"></td>
                            <td width="5%" nowrap="true">
				                          <span class="pagebanner"><c:out value="${vlExpense.valueListInfo.totalNumberOfEntries}"/> Total
				                          - Page (<c:out value="${vlExpense.valueListInfo.pagingPage}"/> of <c:out value="${vlExpense.valueListInfo.totalNumberOfPages}"/>).
				                          &nbsp;</span>
                            </td>
                            <td width="5%">
                              <c:choose>
                                <c:when test="${vlExpense.valueListInfo.totalNumberOfPages > 1}">
                                  <vlh:paging attributes="class=\"pagelinks\"" pages="10"><c:out value="${pageexpenseTableId}"/>&nbsp;</vlh:paging>
                                </c:when>
                                <c:otherwise>
                                  &nbsp;
                                </c:otherwise>
                              </c:choose>
                            </td>
                            <td width="45%"><img alt=""  src="../images/spacer.gif"></td>
                          </tr>
                        </table>
                      </td>
                    </tr>
                    <tr vAlign="top">
                      <td vAlign="top" align="center">
        <tr>
        <td>
 			<table summary="List of Expense for the Income Year" rules="all" class="TableDisplay" role="presentation">
                <tr>
                  <vlh:row bean="financialInfoBean">
                	<vlh:column property="source" title="Name" sortable="asc" attributes="align=\"left\" scope='col'" default="">
                    	<vlh:attribute name="scope">row</vlh:attribute>
                      	<esrcore:displayValue name="financialInfoBean" property="source" nullText=""/>
                    </vlh:column>
                	<vlh:column property="amount" title="Amount" sortable="asc" attributes="align=\"left\" scope='col'" default="">
                      	<esrcore:displayValue name="financialInfoBean" property="amount" nullText=""/>
                    </vlh:column>
                    <vlh:column property="type" title="Expense Type" sortable="asc" attributes="align=\"left\" scope='col'" default="">
                      	<esrcore:displayValue name="financialInfoBean" property="type" nullText=""/>
                    </vlh:column>
                  </vlh:row>
                </tr>
        	</table>
        	</td>
       </tr>
		</vlh:root>
       </table>
<!-- module shell table body-->
</td>
</tr>
        </c:otherwise>
      </c:choose>
</table>
                          <!--
                          <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
                            <tr width="100%" vAlign="top">
                              <td width="100%" vAlign="top" align="center"  colspan="2">
                                <display:table name="FinancialsForm.expenses" id="tblf02" class="TableDisplay" rules="all" pagesize="10" requestURI="/esr/financials/financialsOverview.do?methodName=Financials">
                                  <display:column property="source" title="Name" headerClass="DataHeader" sortable="true" />
                                  <display:column property="amount" title="Amount" headerClass="DataHeader" sortable="true" />
                                  <display:column property="type" title="Expense Type" headerClass="DataHeader" sortable="true" />
                                </display:table>
                              </td>
                            </tr>
                          </table>
                        --></td>
                      </tr>
                      <tr width="100%">
                        <td width="100%">
                          <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellLowTableHead" role="presentation">
                            <tr>
                              <td class="moduleBrownBox">&nbsp;</td>
                              <td width="650" class="moduleHeadline">Asset</td>
                            </tr>
                          </table>
                 <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
       <c:choose>
        <c:when test="${vlAsset==null ||vlAsset.valueListInfo==null ||vlAsset.valueListInfo.totalNumberOfEntries == 0}">
          <tr>
            <td class="darkValue" style="padding:10 0 10 10; text-align: left"><bean-el:message key="label.noDataAvailable"/></td>
          </tr>
        </c:when>
        <c:otherwise>
          <tr valign="top" width="100%">
            <td vAlign="top" align="center">
              <div id="assetLink" style="border-width:0px;">
                <table id="assetResult" align="center" width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleTable" role="presentation">
                  <vlh:root id="assetTableId" value="vlAsset" url="?" includeParameters="*" configName="valueListConfigBeanLookAndFeel">
                    <tr>
                      <td colspan="5">
                        <table class="pagelinks">
                          <tr>
                            <td width="45%"><img alt=""  src="../images/spacer.gif"></td>
                            <td width="5%" nowrap="true">
				                          <span class="pagebanner"><c:out value="${vlAsset.valueListInfo.totalNumberOfEntries}"/> Total
				                          - Page (<c:out value="${vlAsset.valueListInfo.pagingPage}"/> of <c:out value="${vlAsset.valueListInfo.totalNumberOfPages}"/>).
				                          &nbsp;</span>
                            </td>
                            <td width="5%">
                              <c:choose>
                                <c:when test="${vlAsset.valueListInfo.totalNumberOfPages > 1}">
                                  <vlh:paging attributes="class=\"pagelinks\"" pages="10"><c:out value="${pageassetTableId}"/>&nbsp;</vlh:paging>
                                </c:when>
                                <c:otherwise>
                                  &nbsp;
                                </c:otherwise>
                              </c:choose>
                            </td>
                            <td width="45%"><img alt=""  src="../images/spacer.gif"></td>
                          </tr>
                        </table>
                      </td>
                    </tr>
                    <tr vAlign="top">
                      <td vAlign="top" align="center">
        <tr>
        <td>
 			<table summary="List of Asset for the Income Year" rules="all" class="TableDisplay" role="presentation">
                <tr>
                  <vlh:row bean="financialInfoBean">
                	<vlh:column property="source" title="Name" sortable="asc" attributes="align=\"left\" scope='col'" default="">
                    	<vlh:attribute name="scope">row</vlh:attribute>
                      	<esrcore:displayValue name="financialInfoBean" property="source" nullText=""/>
                    </vlh:column>
                	<vlh:column property="amount" title="Amount" sortable="asc" attributes="align=\"left\" scope='col'" default="">
                      	<esrcore:displayValue name="financialInfoBean" property="amount" nullText=""/>
                    </vlh:column>
                    <vlh:column property="type" title="Asset Type" sortable="asc" attributes="align=\"left\" scope='col'" default="">
                      	<esrcore:displayValue name="financialInfoBean" property="type" nullText=""/>
                    </vlh:column>
                  </vlh:row>
                </tr>
        	</table>
        	</td>
       </tr>
		</vlh:root>
       </table>
<!-- module shell table body-->
</td>
</tr>
        </c:otherwise>
      </c:choose>
</table>
                          <!--
                          <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
                            <tr width="100%" vAlign="top">
                              <td width="100%" vAlign="top" align="center"  colspan="2">
                                <display:table name="FinancialsForm.assets" id="tblf03" class="TableDisplay" rules="all" pagesize="10" requestURI="/esr/financials/financialsOverview.do?methodName=Financials">
                                  <display:column property="source" title="Name" headerClass="DataHeader" sortable="true" />
                                  <display:column property="amount" title="Amount" headerClass="DataHeader" sortable="true" />
                                  <display:column property="type" title="Asset Type" headerClass="DataHeader" sortable="true" />
                                </display:table>
                              </td>
                            </tr>
                          </table>
                        --></td>
                      </tr>
                      <tr width="100%">
                        <td width="100%">
                          <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellLowTableHead" role="presentation">
                            <tr>
                              <td class="moduleBrownBox">&nbsp;</td>
                              <td width="650" class="moduleHeadline">Debts</td>
                            </tr>
                          </table>
                 <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
       <c:choose>
        <c:when test="${vlDebt==null ||vlDebt.valueListInfo==null ||vlDebt.valueListInfo.totalNumberOfEntries == 0}">
          <tr>
            <td class="darkValue" style="padding:10 0 10 10; text-align: left"><bean-el:message key="label.noDataAvailable"/></td>
          </tr>
        </c:when>
        <c:otherwise>
          <tr valign="top" width="100%">
            <td vAlign="top" align="center">
              <div id="debtLink" style="border-width:0px;">
                <table id="debtResult" align="center" width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleTable" role="presentation">
                  <vlh:root id="debtTableId" value="vlDebt" url="?" includeParameters="*" configName="valueListConfigBeanLookAndFeel">
                    <tr>
                      <td colspan="5">
                        <table class="pagelinks">
                          <tr>
                            <td width="45%"><img alt=""  src="../images/spacer.gif"></td>
                            <td width="5%" nowrap="true">
				                          <span class="pagebanner"><c:out value="${vlDebt.valueListInfo.totalNumberOfEntries}"/> Total
				                          - Page (<c:out value="${vlDebt.valueListInfo.pagingPage}"/> of <c:out value="${vlDebt.valueListInfo.totalNumberOfPages}"/>).
				                          &nbsp;</span>
                            </td>
                            <td width="5%">
                              <c:choose>
                                <c:when test="${vlDebt.valueListInfo.totalNumberOfPages > 1}">
                                  <vlh:paging attributes="class=\"pagelinks\"" pages="10"><c:out value="${pagedebtTableId}"/>&nbsp;</vlh:paging>
                                </c:when>
                                <c:otherwise>
                                  &nbsp;
                                </c:otherwise>
                              </c:choose>
                            </td>
                            <td width="45%"><img alt=""  src="../images/spacer.gif"></td>
                          </tr>
                        </table>
                      </td>
                    </tr>
                    <tr vAlign="top">
                      <td vAlign="top" align="center">
        <tr>
        <td>
 			<table summary="List of Debt for the Income Year" rules="all" class="TableDisplay" role="presentation">
                <tr>
                  <vlh:row bean="financialInfoBean">
                	<vlh:column property="source" title="Name" sortable="asc" attributes="align=\"left\" scope='col'" default="">
                    	<vlh:attribute name="scope">row</vlh:attribute>
                      	<esrcore:displayValue name="financialInfoBean" property="source" nullText=""/>
                    </vlh:column>
                	<vlh:column property="amount" title="Amount" sortable="asc" attributes="align=\"left\" scope='col'" default="">
                      	<esrcore:displayValue name="financialInfoBean" property="amount" nullText=""/>
                    </vlh:column>
                  </vlh:row>
                </tr>
        	</table>
        	</td>
       </tr>
		</vlh:root>
       </table>
<!-- module shell table body-->
</td>
</tr>
        </c:otherwise>
      </c:choose>
</table>
                          <!--
                          <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
                            <tr width="100%" vAlign="top">
                              <td width="100%" vAlign="top" align="center"  colspan="2">
                                <display:table name="FinancialsForm.debts" id="tblf03" class="TableDisplay" rules="all" pagesize="10" requestURI="/esr/financials/financialsOvervew.do?methodName=Financials">
                                  <display:column property="source" title="Name" headerClass="DataHeader" sortable="true" />
                                  <display:column property="amount" title="Amount" headerClass="DataHeader" sortable="true" />
                                </display:table>
                              </td>
                            </tr>
                          </table>
                        --></td>
                      </tr>
                    </table>
                  </td>
                </tr>
              </table>
            </div>
          </td>
        </tr>
      </c:if >



        <%-- GMT Address --%>
        <tr>
          <td>
            <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellLowTableHead" role="presentation">
              <tr>
                <td class="moduleBrownBox"><img alt=""  src="../images/spacer.gif" width="29" height="1"/></td>
                <td>&nbsp;</td>
                <td class="moduleLabel" nowrap>
                  <fw:link href="." onclick="expandOrCollapse(gmtBlock, gmtImage, gmtHiddenId); return false">
                    <html-el:img alt="${expandableSectionCollapsed}" align="center" border="0" styleId="gmtImage" src="../images/redArrowRight.gif"/><bean-el:message key="title.gmt"/>
                  </fw:link>
                  <input name="gmtHiddenId" id="gmtHiddenId" type="hidden" value="false"/>
                </td>
                <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
              </tr>
            </table>
          </td>
        </tr>
        <tr>
          <td>
            <div id="gmtBlock" style="display:none">
              <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
                <tr>
                  <td>
                    <%-- TODO: Use the Address JSP formatter instead of displaying 1 address element at a time.  --%>
                    <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role = "presentation">
                      <tr>
                        <td width="165" class="value"><esrcore:displayValue name="FinancialsForm" property="incometest.gmtAddress.line1"/></td>
                      </tr>
                      <tr>
                        <td width="165" class="value"><esrcore:displayValue name="FinancialsForm" property="incometest.gmtAddress.city"/>
                        </td>
                      </tr>
                      <tr>
                        <td width="165" class="value"><esrcore:displayValue name="FinancialsForm" property="incometest.gmtAddress.state"/>&nbsp;
                          <esrcore:displayValue name="FinancialsForm" property="incometest.gmtAddress.zipCode"/></td>
                      </tr>
                      <tr>
                        <td width="165" class="value"><esrcore:displayValue name="FinancialsForm" property="incometest.gmtAddress.country"/></td>
                      </tr>
                    </table>
                  </td>
                </tr>
              </table>
            </div>
          </td>
        </tr>

        <%-- Hardship --%>
        <tr>
          <td>
            <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellLowTableHead" role="presentation">
              <tr>
                <td class="moduleBrownBox"><img alt=""  src="../images/spacer.gif" width="29" height="1"/></td>
                <td>&nbsp;</td>
                <td class="moduleLabel" nowrap>
                  <fw:link href="." onclick="expandOrCollapse(hardshipBlock, hardshipImage, hardshipHiddenId); return false">
                    <html-el:img alt="${expandableSectionCollapsed}" align="center" border="0" styleId="hardshipImage" src="../images/redArrowRight.gif"/><bean-el:message key="title.hardship"/>
                  </fw:link>
                  <input name="hardshipHiddenId" id="hardshipHiddenId" type="hidden" value="false"/>
                </td>
                <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
              </tr>
            </table>
          </td>
        </tr>
        <tr>
          <td>
            <div id="hardshipBlock" style="display:none">
              <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
                <tr>
                  <td>
                    <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role = "presentation">
                      <tr>
                        <td valign="top" class="darkLabel" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.financials.hardship.reason"/>:</th>
                        <td class="darkValue" valign="top" nowrap><esrcore:displayValue name="FinancialsForm" property="incometest.hardship.reason"/></td>
                        <td class="darkValue" width="50%"><img alt=""  src="../images/spacer.gif"></td>
                        <td class="darkLabel" valign="top" class="label" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.financials.hardship.sitegrantinghardship"/>:</th>
                        <td class="darkValue" valign="top" nowrap><esrcore:displayValue name="FinancialsForm" property="incometest.hardship.siteGrantingHardship.stationNumber"/></td>
                        <td class="darkValue" width="50%"><img alt=""  src="../images/spacer.gif"></td>
                      </tr>
                      <tr>
                        <td class="label" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.financials.hardship.effectivedate"/>:</th>
                        <td class="value" valign="top" nowrap><esrcore:displayValue name="FinancialsForm" property="incometest.hardship.effectiveDate"/></td>
                        <td class="label">&nbsp;</td>
                        <td class="label" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.financials.hardship.reviewdate"/>:</th>
                        <td class="value" valign="top" nowrap><esrcore:displayValue name="FinancialsForm" property="incometest.hardship.reviewDate"/></td>
                        <td class="label">&nbsp;</td>
                      </tr>
                    </table>
                  </td>
                </tr>
              </table>
            </div>
          </td>
        </tr>

        <%-- Income Verification --%>
        <tr>
          <td>
            <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellLowTableHead" role="presentation">
              <tr>
                <td class="moduleBrownBox"><img alt=""  src="../images/spacer.gif" width="29" height="1"/></td>
                <td>&nbsp;</td>
                <td class="moduleLabel" nowrap>
                  <fw:link href="." onclick="expandOrCollapse(ivmBlock, ivmImage, ivmHiddenId); return false">
                    <html-el:img alt="${expandableSectionCollapsed}" align="center" border="0" styleId="ivmImage" src="../images/redArrowRight.gif"/><bean-el:message key="title.incomeverification"/>
                  </fw:link>
                  <input name="ivmHiddenId" id="ivmHiddenId" type="hidden" value="false"/>
                </td>
                <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
              </tr>
            </table>
          </td>
        </tr>
        <tr>
          <td>
            <div id="ivmBlock" style="display:none">
              <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
                <tr>
                  <td>
                    <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
                      <tr>
                        <td valign="top" class="darkLabel" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.financials.incomeverification.status"/>:</th>
                        <td class="darkValue" valign="top" nowrap><esrcore:displayValue name="FinancialsForm" property="incometest.incomeVerificationStatus"/></td>
                        <td class="darkValue" width="50%"><img alt=""  src="../images/spacer.gif"></td>
                        <td class="darkLabel" valign="top" class="label" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.financials.incomeverification.statusdate"/>:</th>
                        <td class="darkValue" valign="top" nowrap><esrcore:displayValue name="FinancialsForm" property="incometest.incomeVerificationStatusDate"/></td>
                        <td class="darkValue" width="50%"><img alt=""  src="../images/spacer.gif"></td>
                      </tr>
                      <tr>
                        <td class="label" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.financials.incomeverification.dateivmmtcompleted"/>:</th>
                        <td class="value" valign="top" nowrap><esrcore:displayValue name="FinancialsForm" property="incometest.IVMTestCompletionDate"/></td>
                        <td class="label">&nbsp;</td>
                        <td class="label" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.financials.ivmconversiondate"/>:</th>
                        <td class="value" valign="top" nowrap><esrcore:displayValue name="FinancialsForm" property="incometest.ivmConversionDate"/></td>
                        <td class="label">&nbsp;</td>
                      </tr>
                    </table>
                  </td>
                </tr>
              </table>
            </div>
          </td>
        </tr>

      <logic:notEmpty name="FinancialsForm" property="incometest.statuses">
	  <logic:iterate id="incomeTestStatus" name="FinancialsForm" property="incometest.statuses" type="gov.va.med.esr.common.model.financials.IncomeTestStatus">

        <%-- Income Test Statuses --%>
        <tr>
          <td>
            <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellLowTableHead" role="presentation">
              <tr>
                <td class="moduleBrownBox"><img alt=""  src="../images/spacer.gif" width="29" height="1"/></td>
                <td>&nbsp;</td>
                <td class="moduleLabel" nowrap>
                  <fw:link href="." onclick="expandOrCollapse(testBlock${incomeTestStatus.type.code}, testImage${incomeTestStatus.type.code}, testHiddenId${incomeTestStatus.type.code}); return false">
                    <html-el:img alt="${expandableSectionCollapsed}" align="center" border="0" styleId="testImage${incomeTestStatus.type.code}" src="../images/redArrowRight.gif"/><esrcore:displayValue name="incomeTestStatus" property="type.description"/>
                  </fw:link>
                  <input name="testHiddenId<c:out value="${incomeTestStatus.type.code}"/>" id="testHiddenId<c:out value="${incomeTestStatus.type.code}"/>" type="hidden" value="false"/>
                </td>
                <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
              </tr>
            </table>
          </td>
        </tr>
        <tr>
          <td>
            <div id="testBlock<c:out value="${incomeTestStatus.type.code}"/>" style="display:none">
              <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
                <tr>
                  <td>
                    <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role = "presentation">
                      <tr>
                        <td valign="top" class="darkLabel" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.teststatus.status"/>:</th>
                        <td class="darkValue" valign="top" nowrap><esrcore:displayValue name="incomeTestStatus" property="status.description"/></td>
                        <td class="darkValue" width="50%"><img alt=""  src="../images/spacer.gif"></td>
                        <td class="darkLabel" valign="top" class="label" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.financials.testdeterminedstatus"/>:</th>
                        <td class="darkValue" valign="top" nowrap><esrcore:displayValue name="incomeTestStatus" property="determinedStatus.description"/></td>
                        <td class="darkValue" width="50%"><img alt=""  src="../images/spacer.gif"></td>
                      </tr>
                      <tr>
                        <td class="label" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.teststatus.effectivedate"/>:</th>
                        <td class="value" valign="top" nowrap><esrcore:displayValue name="FinancialsForm" property="incometest.effectiveDate"/></td>
                        <td class="label">&nbsp;</td>
                        <td class="label" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.teststatus.completeddate"/>:</th>
                        <td class="value" valign="top" nowrap><esrcore:displayValue name="incomeTestStatus" property="completedDate"/></td>
                        <td class="label">&nbsp;</td>
                      </tr>
                    </table>
                  </td>
                </tr>
              </table>
            </div>
          </td>
        </tr>

      </logic:iterate>
      </logic:notEmpty>

<%-- Means Test Authorization (not in scope for I3 R1/R2
        <tr>
          <td>
            <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellLowTableHead" role="presentation">
              <tr>
                <td class="moduleBrownBox"><img alt=""  src="../images/spacer.gif" width="29" height="1"/></td>
                <td>&nbsp;</td>
                <td class="moduleLabel" nowrap>
                  <fw:link href="." onclick="expandOrCollapse(mtBlock, mtImage, mtHiddenId); return false">
                    <html-el:img alt="${expandableSectionCollapsed}" align="center" border="0" styleId="mtImage" src="../images/redArrowRight.gif"/><bean-el:message key="title.meanstest"/>
                  </fw:link>
                  <input name="mtHiddenId" id="mtHiddenId" type="hidden" value="false"/>
                </td>
                <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
              </tr>
            </table>
          </td>
        </tr>
        <tr>
          <td>
            <div id="mtBlock" style="display:none">
              <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
                <tr>
                  <td>
                    <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role = "presentation">
                      <tr>
                        <td valign="top" class="darkLabel" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.financials.authorizationImageNumber"/>:</th>
                        <td class="darkValue" valign="top" nowrap>&nbsp;</td>
                        <td class="darkValue" width="50%"><img alt=""  src="../images/spacer.gif"></td>
                        <td class="darkLabel" valign="top" class="label" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.financials.dateSigned"/>:</th>
                        <td class="darkValue" valign="top" nowrap>&nbsp;</td>
                        <td class="darkValue" width="50%"><img alt=""  src="../images/spacer.gif"></td>
                      </tr>
                      <tr>
                        <td class="label" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.financials.facilitySubmittingImage"/>:</th>
                        <td class="value" valign="top" nowrap>&nbsp;</td>
                        <td class="label">&nbsp;</td>
                        <td class="label" style="text-align: left; padding-left: 10" nowrap>&nbsp;</td>
                        <td class="value" valign="top" nowrap>&nbsp;</td>
                        <td class="label">&nbsp;</td>
                      </tr>
                    </table>
                  </td>
                </tr>
              </table>
            </div>
          </td>
        </tr>
--%>
        <tr>
          <td>
            <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellLowTableHead" role="presentation">
              <tr>
                <td class="moduleBrownBox"><img alt=""  src="../images/spacer.gif" width="29" height="1"/></td>
                <td>&nbsp;</td>
                <td class="moduleLabel" nowrap>
                  <fw:link href="." onclick="expandOrCollapse(thresholdBlock, thresholdImage, thresholdHiddenId); return false">
                    <html-el:img alt="${expandableSectionCollapsed}" align="center" border="0" styleId="thresholdImage" src="../images/redArrowRight.gif"/><bean-el:message key="title.thresholds"/>
                  </fw:link>
                  <input name="thresholdHiddenId" id="thresholdHiddenId" type="hidden" value="false"/>
                </td>
                <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
              </tr>
            </table>
          </td>
        </tr>
        <tr>
          <td>
            <div id="thresholdBlock" style="display:none">
              <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
                <tr>
                  <td>
                    <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role = "presentation">
                      <tr>
                        <td valign="top" class="darkLabel" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.financials.meansTest"/>:</th>
                        <td class="darkValue" valign="top" nowrap><esrcore:displayCurrency name="FinancialsForm" currencyProperty="incometest.thresholdA" /></td>
                        <td class="darkValue" width="50%"><img alt=""  src="../images/spacer.gif"></td>
                        <td class="darkLabel" valign="top" class="label" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.financials.gmt"/>:</th>
                        <td class="darkValue" valign="top" nowrap><esrcore:displayCurrency name="FinancialsForm" currencyProperty="incometest.gmtThresholdAmount" /></td>
                        <td class="darkValue" width="50%"><img alt=""  src="../images/spacer.gif"></td>
                      </tr>
                      <tr>
                        <td class="label" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.financials.netWorthThreshold"/>:</th>
                        <td class="value" valign="top" nowrap><esrcore:displayCurrency name="FinancialsForm" currencyProperty="incometest.networthThreshold" /></td>
                        <td class="label">&nbsp;</td>
                        <td class="label" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.financials.basicPension"/>:</th>
                        <td class="value" valign="top" nowrap><esrcore:displayCurrency name="FinancialsForm" currencyProperty="incometest.pensionThreshold" /></td>
                        <td class="label">&nbsp;</td>
                      </tr>
                      <tr>
                        <td class="darkLabel" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.financials.childIncomeExclusion"/>:</th>
                        <td class="darkValue" valign="top" nowrap><esrcore:displayCurrency name="FinancialsForm" currencyProperty="incometest.childIncomeExclusionThreshold" /></td>
                        <td class="darkLabel">&nbsp;</td>
                        <td class="darkLabel" style="text-align: left; padding-left: 10" nowrap><bean:message key="label.financials.aidAttendance"/>:</th>
                        <td class="darkValue" valign="top" nowrap>&nbsp;</td>
                        <td class="darkLabel">&nbsp;</td>
                      </tr>
                    </table>
                  </td>
                </tr>
              </table>
            </div>
          </td>
        </tr>

      </c:when>
      <c:otherwise>
          <tr>
            <td id="finAssessBlock" class="darkValue" style="padding:10 0 10 10; text-align: left; display:block"><bean-el:message key="label.noIncomeTestDataAvailable"/></th>
          <tr>
      </c:otherwise>
      </c:choose>

	    <%-- Beneficiary Travel --%>
        <tr>
          <td>
            <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellLowTableHead" role="presentation">
              <tr>
                <td class="moduleBrownBox"><img alt=""  src="../images/spacer.gif" width="29" height="1"/></td>
                <td>&nbsp;</td>
                <td class="moduleLabel" nowrap>
                  <fw:link href="." onclick="expandOrCollapse(benTravelBlock, benTravelImage, benTravelHiddenId); return false">
                    <html-el:img alt="${expandableSectionCollapsed}" align="center" border="0" styleId="benTravelImage" src="../images/redArrowRight.gif"/><bean-el:message key="title.beneficiarytravel"/>
                  </fw:link>
                  <input name="benTravelHiddenId" id="benTravelHiddenId" type="hidden" value="false"/>
                </td>
                <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
              </tr>
            </table>
          </td>
        </tr>
        <tr>
          <td>
            <div id="benTravelBlock" style="display :none">
              <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
              <c:choose>
              <c:when test="${FinancialsForm.beneficiaryTravels != null && FinancialsForm.beneficiaryTravelsSize != 0}">
                <tr>
                  <td>
                 <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
       <c:choose>
        <c:when test="${vlBenTravel==null ||vlBenTravel.valueListInfo==null ||vlBenTravel.valueListInfo.totalNumberOfEntries == 0}">
          <tr>
            <td class="darkValue" style="padding:10 0 10 10; text-align: left"><bean-el:message key="label.noDataAvailable"/></td>
          </tr>
        </c:when>
        <c:otherwise>
          <tr valign="top" width="100%">
            <td vAlign="top" align="center">
              <div id="benTravelLink" style="border-width:0px;">
                <table id="benTravelResult" align="center" width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleTable" role="presentation">
                  <vlh:root id="benTravelTableId" value="vlBenTravel" url="?" includeParameters="*" configName="valueListConfigBeanLookAndFeel">
                    <tr>
                      <td colspan="5">
                        <table class="pagelinks">
                          <tr>
                            <td width="45%"><img alt=""  src="../images/spacer.gif"></td>
                            <td width="5%" nowrap="true">
				                          <span class="pagebanner"><c:out value="${vlBenTravel.valueListInfo.totalNumberOfEntries}"/> Total
				                          - Page (<c:out value="${vlBenTravel.valueListInfo.pagingPage}"/> of <c:out value="${vlBenTravel.valueListInfo.totalNumberOfPages}"/>).
				                          &nbsp;</span>
                            </td>
                            <td width="5%">
                              <c:choose>
                                <c:when test="${vlBenTravel.valueListInfo.totalNumberOfPages > 1}">
                                  <vlh:paging attributes="class=\"pagelinks\"" pages="10"><c:out value="${pagebenTravelTableId}"/>&nbsp;</vlh:paging>
                                </c:when>
                                <c:otherwise>
                                  &nbsp;
                                </c:otherwise>
                              </c:choose>
                            </td>
                            <td width="45%"><img alt=""  src="../images/spacer.gif"></td>
                          </tr>
                        </table>
                      </td>
                    </tr>
                    <tr vAlign="top">
                      <td vAlign="top" align="center">
        <tr>
        <td>
 			<table summary="List of Beneficiary Travel for the Income Year" rules="all" class="TableDisplay" role="presentation">
                <tr>
                  <vlh:row bean="beneficiaryTravel">
                	<vlh:column property="facilityVisited.name" title="Site" sortable="asc" attributes="align=\"left\" scope='col'" default="">
                    	<vlh:attribute name="scope">row</vlh:attribute>
                      	<esrcore:displayValue name="beneficiaryTravel" property="facilityVisited.name" nullText=""/>
                    </vlh:column>
                	<vlh:column property="dateCertified" title="Date Certified" sortable="asc" attributes="align=\"left\" scope='col'" default="">
                      	<esrcore:displayValue name="beneficiaryTravel" property="dateCertified" nullText=""/>
                    </vlh:column>
                    <vlh:column property="amountCertified" title="Certified Amount" sortable="asc" attributes="align=\"left\" scope='col'" default="">
                      	<esrcore:displayValue name="beneficiaryTravel" property="amountCertified" nullText=""/>
                    </vlh:column>
                    <vlh:column property="claimDate" title="Claim Date and Time" sortable="asc" attributes="align=\"left\" scope='col'" default="">
                      	<esrcore:displayValue name="beneficiaryTravel" property="claimDate" nullText="" format="MM/dd/yyyy h:mm:ssa"/>
                    </vlh:column>
                    <vlh:column property="eligible" title="Eligible Indicator" sortable="asc" attributes="align=\"left\" scope='col'" default="">
	                  	<c:if test="${beneficiaryTravel.eligible == true}">
	                        <c:out value="${yesLabel}"/>
	                    </c:if>
	                    <c:if test="${beneficiaryTravel.eligible == false}">
		       	          <c:out value="${noLabel}"/>
	                    </c:if>
                    </vlh:column>
                  </vlh:row>
                </tr>
        	</table>
        	</td>
       </tr>
		</vlh:root>
       </table>
<!-- module shell table body-->
</td>
</tr>
        </c:otherwise>
      </c:choose>
</table>
                  <!--
                    <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role = "presentation">
                      <display:table name="FinancialsForm.beneficiaryTravels" id="tblf04" class="TableDisplay" rules="all" pagesize="10" requestURI="/esr/financials/financialsOverview.do?methodName=Financials">
                        <display:column property="facilityVisited.name" title="Site" headerClass="DataHeader" sortable="true" />
                        <display:column property="dateCertified" title="Date Certified" headerClass="DataHeader" sortable="true" />
                        <display:column property="amountCertified" title="Certified Amount" headerClass="DataHeader" sortable="true" />
                        <display:column property="claimDate" title="Claim Date and Time" headerClass="DataHeader" sortable="true" />
                        <display:column title="Eligible Indicator" headerClass="DataHeader" sortable="true">
				                 <c:if test="${tblf04.eligible == true}">
				                        <c:out value="${yesLabel}"/>
                                                 </c:if>
                                                <c:if test="${tblf04.eligible == false}">
					       	          <c:out value="${noLabel}"/>
                                                 </c:if>
                        </display:column>
                      </display:table>
                    </table>
                   --></td>
                 </tr>
               </c:when>
               <c:otherwise>
                 <tr>
                   <td class="darkValue" style="padding:10 0 10 10; text-align: left"><bean-el:message key="label.noDataAvailable"/></td>
                 </tr>
               </c:otherwise>
               </c:choose>
              </table>
            </div>
          </td>
        </tr>

      </table>
    </td>
  </tr>
</html-el:form>
</table>
