<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el"%>
<%@ taglib uri="/tags/struts-bean" prefix="bean"%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="/tags/esr-core" prefix="esrcore"%>
<%@ taglib uri="/tags/fw" prefix="fw"%>

<c:set var="expandableSectionCollapsed" scope="page">
    <bean-el:message key="label.expandableSectionCollapsed" />
</c:set>
<c:set var="mmddyyyyText" scope="page">
    <bean-el:message key="label.mmddyyyy" />
</c:set>
<c:set var="requiredText">
    <bean-el:message key="label.required" />
</c:set>
<c:set var="isAddAPerson" value="false"></c:set>

<script src="../scripts/ESR-Script.js" type="text/javascript"></script>
<script>
function onLoadInit()
{
	processSpouseLivedWithVeteranOnFinDetails(); 
}

function processContributedToSpouseIndOnFinancialDetails(flag, elem)
{
    if(flag == true)
    {
        elem.checked = false;
        var spousalContribution = document.getElementsByName('spouseInfo.contributedToSpouseInd');
        for (var i =0; i<spousalContribution.length; i++){
            spousalContribution[i].value = null;  
        }       
    }   
    else
    { 
        if(elem.id =="idContributedToSpouseInd_y")
        {
            elem.value="y";
        }       
        else if(elem.id =="idContributedToSpouseInd_n")
        {
            elem.value="n";
        } 
    }  
}

function processSpouseLivedWithVeteranOnFinDetails()
{
   var indicator_n = document.getElementById('idSpouseLived_n');
  var block = document.getElementById('spouseLwvBlock');


  if (indicator_n.value != null && indicator_n.checked)
  {
	  block.style.display = "block";
  }
  else
  {
	  block.style.display = "none";    
  }
}
</script>

<c:if test="${financialDetailsForm.allowedToAddFinancials == 'false'}">
    <c:set var="financialsUpdateAllowed" value="false"></c:set>
</c:if>
<c:if test="${financialDetailsForm.allowedToEditFinancials == 'false'}">
    <c:set var="financialsUpdateAllowed" value="false"></c:set>
</c:if>
<html-el:hidden property="sourceOfTest" />

<c:set var="finacialsReadOnlyData" value="false"></c:set>
<c:if test="${financialsUpdateAllowed == 'false'}">
    <c:set var="finacialsReadOnlyData" value="true"></c:set>
</c:if>

<table border="0" width="100%" cellpadding="0" cellspacing="0" class="moduleShellTableBody" role="presentation">
    <c:if test="${financialDetailsForm.askAdjudicationQuestion == 'true'}">
        <tr valign="top">
            <td width="450" class="moduleLabel">
                <bean-el:message key="label.required.prefix" />
                &nbsp;Evaluation of total computed income, MT Threshold, GMT Thresholds, Networth and Networth Threshold determines the
                means test status be GMT Copay Required or MT Copay Required.<br> Do you want to send this for Adjudication? :
            </td>
            <td colspan="2" class="moduleValue" valign="bottom">
                <c:forEach var="item" items="${yesNoList}">
                    <c:set var="itemLabel">
                        <bean-el:message key="${item.label}" />
                    </c:set>
                    <html-el:radio title="Do you want to send this for Adjudication (${itemLabel})" property="sendForAdjudication"
                        styleId="idSendForAdjudication_${item.value}" value="${item.value}" disabled="${finacialsReadOnlyData}" />
                    <fw:label property="sendForAdjudication" forId="idSendForAdjudication_${item.value}">
                        <bean-el:message key="${item.label}" />&nbsp;&nbsp;</fw:label>
                </c:forEach>
            </td>
        </tr>
    </c:if>

    <tr valign="top">
        <td width="450" class="moduleLabel">
            <bean-el:message key="label.required.prefix" />
            &nbsp;Married Last Calendar Year:
        </td>
        <td colspan="2" class="moduleValue">
            <c:forEach var="item" items="${yesNoList}">
                <c:set var="itemLabel">
                    <bean-el:message key="${item.label}" />
                </c:set>
                <html-el:radio title="${requiredText}, Married Last Calendar Year (${itemLabel})" property="marriedLastCalendarYear"
                    styleId="idMarriedLastCalendarYear_${item.value}" value="${item.value}" disabled="${finacialsReadOnlyData}" />
                <fw:label property="marriedLastCalendarYear" forId="idMarriedLastCalendarYear_${item.value}">
                    <bean-el:message key="${item.label}" />&nbsp;&nbsp;</fw:label>
            </c:forEach>
        </td>
    </tr>

    <tr>
        <td colspan="3">
            <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellLowTableHead" role="presentation">
                <tr>
                    <td class="moduleBrownBox">
                        <img alt="" src="../images/spacer.gif" width="29" height="1" />
                    </td>
                    <td style="padding: 7 7" nowrap>
                        <bean:message key="label.incomeTest.title" />
                    </td>
                    <td width="100%">
                        <img alt="" src="../images/spacer.gif">
                    </td>
                    <c:choose>
                        <c:when
                            test="${financialDetailsForm.incomeTestAvaliableInd == 'true' && financialDetailsForm.pendingAdjudication == 'true'}">
                            <td>
                                <img alt="" src="../images/buttonEndLeft.gif" />
                            </td>
                            <td>
                                <html-el:submit property="methodName" style="width:150; vertical-align: top;" styleClass="buttonText">
                                    <bean:message key="button.adjudicateIncomeTest" />
                                </html-el:submit>
                            </td>
                            <td>
                                <img alt="" src="../images/buttonEndRight.gif" />
                            </td>
                            <td style="padding: 0 5 0 0">
                                <img alt="" src="../images/spacer.gif" />
                            </td>
                        </c:when>
                        <c:when
                            test="${financialDetailsForm.incomeTestAvaliableInd == 'false' && financialDetailsForm.allowedToAddFinancials == 'true'}">
                            <td>
                                <img alt="" src="../images/buttonEndLeft.gif" />
                            </td>
                            <td>
                                <html-el:submit property="methodName" style="width:110; vertical-align: top;" styleClass="buttonText">
                                    <bean:message key="button.addIncomeTest" />
                                </html-el:submit>
                            </td>
                            <td>
                                <img alt="" src="../images/buttonEndRight.gif" />
                            </td>
                            <td style="padding: 0 5 0 0">
                                <img alt="" src="../images/spacer.gif" />
                            </td>
                        </c:when>
                        <c:otherwise>
                        </c:otherwise>
                    </c:choose>
                </tr>
            </table>
        </td>
    </tr>

    <c:if test="${financialDetailsForm.incomeTestAvaliableInd == 'true'}">
        <tr>
            <td width="450" class="moduleLabel">
                <fw:label required="true" property="testEffDate" forId="idTestEffDate">Test Effective Date:</fw:label>
            </td>
            <c:choose>
                <c:when test="${financialDetailsForm.newIncomeTestInd == 'false'}">
                    <html-el:hidden property="testEffDate" styleId="idTestEffDate" />
                    <td colspan="2" class="moduleValue">
                        <esrcore:displayValue name="financialDetailsForm" property="testEffDate" />
                    </td>
                </c:when>
                <c:otherwise>
                    <td colspan="2" class="moduleValue">
                        <html-el:text title="${requiredText}, Test Effective Date ${mmddyyyyText}" styleClass="moduleEdit"
                            styleId="idTestEffDate" property="testEffDate" size="20" maxlength="10" readonly="${finacialsReadOnlyData}" />
                        &nbsp;
                        <bean-el:message key="label.mmddyyyy" />
                    </td>
                </c:otherwise>
            </c:choose>
        </tr>
        <tr>
            <td width="450" class="moduleLabel">
                <bean-el:message key="label.required.prefix" />
                &nbsp;Disclose Financial Income:
            </td>
            <td colspan="2" class="moduleValue">
                <c:forEach var="item" items="${yesNoList}">
                    <c:set var="itemLabel">
                        <bean-el:message key="${item.label}" />
                    </c:set>
                    <html-el:radio title="${requiredText}, Disclose Financial Income (${itemLabel})" property="discloseFinIncome"
                        styleId="idDiscloseFinIncome_${item.value}" value="${item.value}" disabled="${finacialsReadOnlyData}" />
                    <fw:label property="discloseFinIncome" forId="idDiscloseFinIncome_${item.value}">
                        <bean-el:message key="${item.label}" />&nbsp;&nbsp;</fw:label>
                </c:forEach>
            </td>

        </tr>
        <tr>
            <td width="450" class="moduleLabel">Agree to Pay Deductible:</td>
            <td colspan="2" class="moduleValue">
                <c:forEach var="item" items="${yesNoList}">
                    <c:set var="itemLabel">
                        <bean-el:message key="${item.label}" />
                    </c:set>
                    <html-el:radio title="${requiredText}, Agree to Pay Deductible (${itemLabel})" property="agreeToPayDeductible"
                        styleId="idAgreeToPayDeductible_${item.value}" value="${item.value}" disabled="${finacialsReadOnlyData}" />
                    <fw:label property="agreeToPayDeductible" forId="idAgreeToPayDeductible_${item.value}">
                        <bean-el:message key="${item.label}" />&nbsp;&nbsp;</fw:label>
                </c:forEach>
            </td>
        </tr>
    </c:if>
</table>
<!-- start of new code -->
<table class="moduleShellTableBody" width="100%">
    <tr>
        <td>
            <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellLowTableHead">
                <tr>
                    <td class="moduleBrownBox">
                        <img alt="" src="../images/spacer.gif" width="29" height="1" />
                    </td>
                    <td style="padding: 7 7" nowrap>
                        <bean:message key="label.dependencyFactors.title" />
                    </td>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <td>
            <table width="692"
                summary="List of Roles and Their Capability Sets and Capabilities. 
                    Use Enter or Space Bar, to expand a link. Continue using table commands to read the next row within expanded link. Within the expanded link, use the up and down arrow keys to read line by line.
                    To return to the expanded link, use the up arrow keys and collapse the link by using Enter or Space Bar. To return to the first level/main expandable link use table commands and then collapse it.
                    Continue using normal table commands to read the rest of the table.">

                <thead>
                    <tr valign="top">
                        <th id="ssn" scope="col" width="145px" class="moduleValue" style="text-align: left; font-weight: bold">SSN</th>
                        <th id="name" scope="col" width="170px" class="moduleValue" style="text-align: left; font-weight: bold">Name</th>
                        <th id="relationship" scope="col" width="182px" class="moduleValue" style="text-align: left; font-weight: bold">Relationship</th>
                        <th id="gender" scope="col" width="195px" class="moduleValue" style="text-align: left; font-weight: bold">Gender</th>
                    </tr>
                </thead>
                <c:if test="${not empty financialDetailsForm.spouseInfo.financialsId}">
                    <tr>
                        <td headers="ssn" width="145" class="moduleValue">
                            <html-el:hidden property="spouseInfo.financialsId" />
                            <html-el:hidden property="spouseInfo.displaySSN" />
                            <html-el:hidden property="spouseInfo.name" />
                            <html-el:hidden property="spouseInfo.relationshipCode" />
                            <html-el:hidden property="spouseInfo.relationship" />
                            <html-el:hidden property="spouseInfo.genderCode" />
                            <html-el:hidden property="spouseInfo.gender" />
                            <html-el:hidden property="spouseInfo.validDependent" />
                            <fw:link href="." onclick="expandOrCollapse(spouseBlock, spouseImage, spouseHiddenId); return false">
                                <html-el:img alt="${expandableSectionCollapsed}" align="center" border="0" styleId="spouseImage"
                                    src="../images/redArrowRight.gif" />

                                <esrcore:displayValue name="financialDetailsForm" property="spouseInfo.displaySSN" />
                            </fw:link>
                            <input name="spouseHiddenId" id="spouseHiddenId" type="hidden" value="false" />
                        </td>
                        <td headers="name" width="170" class="moduleValue">
                            <esrcore:displayValue name="financialDetailsForm" property="spouseInfo.name" />
                        </td>
                        <td headers="relationship" width="182" class="moduleValue">
                            <esrcore:displayValue name="financialDetailsForm" property="spouseInfo.relationship" />
                        </td>
                        <td headers="gender" width="195" class="moduleValue">
                            <esrcore:displayValue name="financialDetailsForm" property="spouseInfo.gender" />
                        </td>
                    </tr>
                    <tr>
                        <td colspan="4">
                          <div id="spouseBlock" class="expandCollapseBody">
                            <table>
                                <tr valign="top">
                                    <td width="311" class="moduleLabel">
                                        <fw:label property="spouseInfo.marriageDate" forId="idSpouseMarriageDate">Date of Marriage:</fw:label>
                                    </td>
                                    <td width="372" class="moduleValue">
                                        <html-el:text title="Date of Marriage" styleClass="moduleEdit" property="spouseInfo.marriageDate"
                                            styleId="idSpouseMarriageDate" size="25" maxlength="10" readonly="${finacialsReadOnlyData}" />
                                    </td>
                                </tr>
                                <tr valign="top">
                                    <td class="moduleLabel">Valid Dependent:</td>
                                    <td class="moduleValue">
                                        <esrcore:displayValue name="financialDetailsForm" property="spouseInfo.validDependent" />
                                    </td>
                                </tr>
                                <tr valign="top">
                                    <td width="311" class="moduleLabel">
                                        <fw:label property="spouseInfo.inactiveDate" forId="idSpouseInactiveDate">Inactive Date:</fw:label>
                                    </td>
                                    <td class="moduleValue">
                                        <html-el:text title="Inactive Date ${mmddyyyyText}" styleClass="moduleEdit"
                                            property="spouseInfo.inactiveDate" styleId="idSpouseInactiveDate" size="25" maxlength="10"
                                            readonly="${finacialsReadOnlyData}" />
                                        &nbsp;
                                        <bean-el:message key="label.mmddyyyy" />
                                    </td>
                                </tr>
                                <tr valign="top">
                                    <td class="moduleLabel">Lived with Veteran Last Calendar Year:</td>
                                    <td colspan="2" class="moduleValue">
                                        <c:forEach var="item" items="${yesNoList}">
                                            <c:set var="itemLabel">
                                                <bean-el:message key="${item.label}" />
                                            </c:set>
                                            <html-el:radio title="Lived with Veteran Last Calendar Year (${itemLabel})"
                                                property="spouseInfo.livedWithVeteran" styleId="idSpouseLived_${item.value}"
                                                value="${item.value}" disabled="${finacialsReadOnlyData}" onclick="processSpouseLivedWithVeteranOnFinDetails();" />
                                            <fw:label property="spouseInfo.livedWithVeteran" forId="idSpouseLived_${item.value}">
                                                <bean-el:message key="${item.label}" />&nbsp;&nbsp;</fw:label>
                                        </c:forEach>
                                    </td>
                                </tr>                                
                                <c:if test="${not empty financialDetailsForm.spouseInfo.contributedToSupport}">                                                
                                <tr valign="top">                                    
                                    <td width="311" class="moduleLabel">
                                        <fw:label property="spouseInfo.contributedToSupport" forId="idSpouseContributedToSupport">Amount Contributed to Spousal Support:</fw:label>
                                    </td>
                                    <td width="380" class="moduleValue">
                                        $
                                        <html-el:text title="Amount Contributed to Spousal Support ($)" styleClass="moduleEdit"
                                            styleId="idSpouseContributedToSupport" property="spouseInfo.contributedToSupport" size="25"
                                            maxlength="10" readonly="true" />
                                    </td>                                    
                                </tr>
                                </c:if>  
                               </table>   
                               
                               <div  id="spouseLwvBlock" class="expandCollapseBody">
                               <table class="moduleShellTableBody">
                                <tr valign="top">
                                 <td style="width: 90px" class="moduleValue">&nbsp;&nbsp;</td>
                                  <td class="moduleLabel" nowrap>Contributed to Spousal Support:</td>
                                  <td colspan="2" class="moduleValue">
                                    <c:forEach var="item" items="${yesNoList}">
                                      <c:set var="itemLabel"><bean-el:message key="${item.label}"/></c:set>
                                      <html-el:radio title="Contributed to Spousal Support (${itemLabel})" styleId="idContributedToSpouseInd_${item.value}" 
                                      property="spouseInfo.contributedToSpouseInd" value="${item.value}" disabled="${finacialsReadOnlyData}" onmousedown="this.__chk = this.checked;" onclick="processContributedToSpouseIndOnFinancialDetails(this.__chk, this);"/>
                                      <fw:label property="spouseInfo.contributedToSpouseInd" forId="idContributedToSpouseInd_${item.value}">
                                      <bean-el:message key="${item.label}" />&nbsp;&nbsp;</fw:label>      
                                    </c:forEach>                                          
                                  </td>
                                </tr>
                                </table>
                                </div>                          
                                 
                             </div> 
                                						
                        </td>
                    </tr>
                </c:if>
                <!-- start of dependent -->
                <%-- begin inactive spouse expand/collapse section --%>
                <c:if test="${not empty financialDetailsForm.spouseFinacialsIdList}">
                    <c:forEach var="spouseInfo" items="${financialDetailsForm.spouseFinacialsIdList}" varStatus="status">

                        <tr valign="top">
                            <td scope="row" width="145" class="moduleValue">
                                <c:set var="counter" value="${status.count - 1}" />
                                <c:set var="hashCode" value="${financialDetailsForm.spouseFinacialsHashCodeList[counter]}" />
                                <c:set var="activeSpouse" value="${financialDetailsForm.spouseActiveList[counter]}" />
                                <c:if test="${not activeSpouse}">
                                    <html-el:hidden property="spouseMarriageDate[${counter}]" />
                                    <html-el:hidden property="spouseInactiveDate[${counter}]" />
                                    <html-el:hidden property="spouseLivedWithPatient[${counter}]" />
                                    <html-el:hidden property="spouseContributedToSupport[${counter}]" />
                                </c:if>

                                <html-el:hidden property="spouseFinacialsId[${counter}]" />
                                <html-el:hidden property="spouseName[${counter}]" />
                                <html-el:hidden property="spouseDisplaySSN[${counter}]" />
                                <html-el:hidden property="spouseRelationshipCode[${counter}]" />
                                <html-el:hidden property="spouseRelationship[${counter}]" />
                                <html-el:hidden property="spouseGenderCode[${counter}]" />
                                <html-el:hidden property="spouseGender[${counter}]" />
                                <html-el:hidden property="spouseValid[${counter}]" />

                                <c:set var="id" value="${financialDetailsForm.spouseFinacialsIdList[counter]}" />
                                <fw:link href="."
                                    onclick="expandOrCollapse(spouseBlock${id}, spouseImage${id}, spouseHiddenId${id}); return false">
                                    <html-el:img alt="${expandableSectionCollapsed}" align="center" border="0" styleId="spouseImage${id}"
                                        src="../images/redArrowRight.gif" />
                                    <c:out value="${financialDetailsForm.spouseDisplaySSNList[counter]}" />
                                </fw:link>
                                <input name="spouseHiddenId<c:out value="${id}"/>" id="spouseHiddenId<c:out value="${id}"/>" type="hidden"
                                    value="false" />
                            </td>
                            <td width="170" class="moduleValue">
                                <c:out value="${financialDetailsForm.spouseNameList[counter]}" />
                            </td>
                            <td width="182" class="moduleValue">
                                <c:out value="${financialDetailsForm.spouseRelationshipList[counter]}" />
                            </td>
                            <td width="195" class="moduleValue">
                                <c:out value="${financialDetailsForm.spouseGenderList[counter]}" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="4">
                                <table id="spouseBlock<c:out value="${id}"/>" class="expandCollapseBody" role="presentation">
                                    <tr valign="top">
                                        <td width="312" class="moduleLabel">
                                            <fw:label property="spouseMarriageDate[${counter}],spouseMarriageDate_${hashCode}"
                                                forId="spouseMarriageDate[${counter}]_id">Date of Marriage:</fw:label>
                                        </td>
                                        <td width="380" class="moduleValue">
                                            <html-el:text title="Date of Marriage" styleClass="moduleEdit"
                                                property="spouseMarriageDate[${counter}]" styleId="spouseMarriageDate[${counter}]_id"
                                                size="25" maxlength="10" readonly="${finacialsReadOnlyData or not activeSpouse}" />
                                        </td>
                                    </tr>
                                    <tr valign="top">
                                        <td class="moduleLabel">Valid Dependent:</td>
                                        <td class="moduleValue">
                                            <c:out value="${financialDetailsForm.spouseValidList[counter]}" />
                                        </td>
                                    </tr>
                                    <tr valign="top">
                                        <td width="311" class="moduleLabel">
                                            <fw:label property="spouseInactiveDate[${counter}],spouseInactiveDate_${hashCode}"
                                                forId="spouseInactiveDate[${counter}]_id">Inactive Date:</fw:label>
                                        </td>
                                        <td width="381" class="moduleValue">
                                            <html-el:text title="Inactive Date ${mmddyyyyText}" styleClass="moduleEdit"
                                                styleId="spouseInactiveDate[${counter}]_id" property="spouseInactiveDate[${counter}]"
                                                size="20" maxlength="10" readonly="${finacialsReadOnlyData or not activeSpouse}" />
                                            &nbsp;
                                            <bean-el:message key="label.mmddyyyy" />
                                        </td>
                                    </tr>
                                    <tr valign="top">
                                        <td class="moduleLabel">Lived with Veteran Last Calendar Year:</td>
                                        <td colspan="2" class="moduleValue">
                                            <c:forEach var="item" items="${yesNoList}">
                                                <c:set var="itemLabel">
                                                    <bean-el:message key="${item.label}" />
                                                </c:set>
                                                <html-el:radio title="Lived with Veteran Last Calendar Year (${itemLabel})"
                                                    property="spouseLivedWithPatient[${counter}]"
                                                    styleId="spouseLivedWithPatient[${counter}]_${item.value}" value="${item.value}"
                                                    disabled="${finacialsReadOnlyData or not activeSpouse}" />
                                                <fw:label property="spouseLivedWithPatient[${counter}],spouseLivedWithPatient_${hashCode}"
                                                    forId="spouseLivedWithPatient[${counter}]_${item.value}">
                                                    <bean-el:message key="${item.label}" />&nbsp;&nbsp;</fw:label>
                                            </c:forEach>
                                        </td>
                                    </tr>
                                    <tr valign="top">
                                        <td width="311" class="moduleLabel">
                                            <fw:label
                                                property="spouseContributedToSupport[${counter}],spouseContributedToSupport_${hashCode}"
                                                forId="spouseContributedToSupport[${counter}]_id">Amount Contributed to Spousal Support:</fw:label>
                                        </td>
                                        <td width="380" class="moduleValue">
                                            $
                                            <html-el:text title="Amount Contributed to Spousal Support ($)" styleClass="moduleEdit"
                                                property="spouseContributedToSupport[${counter}]"
                                                styleId="spouseContributedToSupport[${counter}]_id" size="25" maxlength="10"
                                                readonly="${finacialsReadOnlyData  or not activeSpouse}" />
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </c:forEach>
                </c:if>
                <c:if test="${not empty financialDetailsForm.depFinacialsIdList}">
                    <c:forEach var="depInfo" items="${financialDetailsForm.depFinacialsIdList}" varStatus="status">
                        <tr valign="top">
                            <td scope="row" width="145" class="moduleValue">
                                <c:set var="counter" value="${status.count - 1}" />
                                <c:set var="hashCode" value="${financialDetailsForm.depFinacialsHashcodeList[counter]}" />

                                <html-el:hidden property="depFinacialsId[${counter}]" />
                                <html-el:hidden property="depName[${counter}]" />
                                <html-el:hidden property="depDisplaySSN[${counter}]" />
                                <html-el:hidden property="depRelationshipCode[${counter}]" />
                                <html-el:hidden property="depRelationship[${counter}]" />
                                <html-el:hidden property="depGenderCode[${counter}]" />
                                <html-el:hidden property="depGender[${counter}]" />
                                <html-el:hidden property="depValid[${counter}]" />

                                <c:set var="id" value="${financialDetailsForm.depFinacialsIdList[counter]}" />

                                <fw:link href="." onclick="expandOrCollapse(depBlock${id}, depImage${id}, depHiddenId${id}); return false">
                                    <html-el:img alt="${expandableSectionCollapsed}" align="center" border="0" styleId="depImage${id}"
                                        src="../images/redArrowRight.gif" />
                                    <c:out value="${financialDetailsForm.depDisplaySSNList[counter]}" />
                                </fw:link>
                                <input name="depHiddenId<c:out value="${id}"/>" id="depHiddenId<c:out value="${id}"/>" type="hidden"
                                    value="false" />
                            </td>
                            <td width="170" class="moduleValue">
                                <c:out value="${financialDetailsForm.depNameList[counter]}" />
                            </td>
                            <td width="182" class="moduleValue">
                                <c:out value="${financialDetailsForm.depRelationshipList[counter]}" />
                            </td>
                            <td width="195" class="moduleValue">
                                <c:out value="${financialDetailsForm.depGenderList[counter]}" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="4">

                                <table id="depBlock<c:out value="${id}"/>" class="expandCollapseBody">
                                    <tr valign="top">
                                        <td width="312" class="moduleLabel">
                                            <fw:label property="depEffectiveDate[${counter}],depEffectiveDate_${hashCode}"
                                                forId="depEffectiveDate[${counter}]_id">Dependent Effective Date:</fw:label>
                                        </td>
                                        <td width="380" class="moduleValue">
                                            <html-el:text title="Dependent Effective Date" styleClass="moduleEdit"
                                                property="depEffectiveDate[${counter}]" styleId="depEffectiveDate[${counter}]_id" size="20"
                                                maxlength="10" readonly="${finacialsReadOnlyData}" />
                                        </td>
                                    </tr>
                                    <tr valign="top">
                                        <td class="moduleLabel">Valid Dependent:</td>
                                        <td class="moduleValue">
                                            <c:out value="${financialDetailsForm.depValidList[counter]}" />
                                        </td>
                                    </tr>
                                    <tr valign="top">
                                        <td width="311" class="moduleLabel">
                                            <fw:label property="depInactiveDate[${counter}],depInactiveDate_${hashCode}"
                                                forId="depInactiveDate[${counter}]_id">Inactive Date:</fw:label>
                                        </td>
                                        <td width="381" class="moduleValue">
                                            <html-el:text title="Inactive Date ${mmddyyyyText}" styleClass="moduleEdit"
                                                property="depInactiveDate[${counter}]" styleId="depInactiveDate[${counter}]_id" size="20"
                                                maxlength="10" readonly="${finacialsReadOnlyData}" />
                                            &nbsp;
                                            <bean-el:message key="label.mmddyyyy" />
                                        </td>
                                    </tr>
                                    <tr valign="top">
                                        <td class="moduleLabel">Resided with Veteran Last Calendar Year:</td>
                                        <td colspan="2" class="moduleValue">
                                            <c:forEach var="item" items="${yesNoList}">
                                                <c:set var="itemLabel">
                                                    <bean-el:message key="${item.label}" />
                                                </c:set>
                                                <html-el:radio title="Resided with Veteran Last Calendar Year (${itemLabel})"
                                                    property="depLivedWithPatient[${counter}]"
                                                    styleId="depLivedWithPatient[${counter}]_${item.value}" value="${item.value}"
                                                    disabled="${finacialsReadOnlyData}" />
                                                <fw:label property="depLivedWithPatient[${counter}],depLivedWithPatient_${hashCode}"
                                                    forId="depLivedWithPatient[${counter}]_${item.value}">
                                                    <bean-el:message key="${item.label}" />&nbsp;&nbsp;</fw:label>
                                            </c:forEach>
                                        </td>
                                    </tr>
                                    <tr valign="top">
                                        <td class="moduleLabel">Contributed to Child Support:</td>
                                        <td colspan="2" class="moduleValue">
                                            <c:forEach var="item" items="${yesNoList}">
                                                <c:set var="itemLabel">
                                                    <bean-el:message key="${item.label}" />
                                                </c:set>
                                                <html-el:radio title="Contributed to Child Support (${itemLabel})"
                                                    property="depContributedToSupport[${counter}]"
                                                    styleId="depContributedToSupport[${counter}]_${item.value}" value="${item.value}"
                                                    disabled="${finacialsReadOnlyData}" />
                                                <fw:label property="depContributedToSupport[${counter}],depContributedToSupport_${hashCode}"
                                                    forId="depContributedToSupport[${counter}]_${item.value}">
                                                    <bean-el:message key="${item.label}" />&nbsp;&nbsp;</fw:label>
                                            </c:forEach>
                                        </td>
                                    </tr>                                    
                                     <c:if test="${not empty financialDetailsForm.depAmtContributedList[counter]}">                              
                                    <tr valign="top">
                                        <td width="311" class="moduleLabel">
                                            <fw:label property="depAmtContributed[${counter}],depAmtContributed_${hashCode}"
                                                forId="depAmtContributed[${counter}]_id">Amount Contributed:</fw:label>
                                        </td>
                                        <td width="381" class="moduleValue">
                                            $
                                            <html-el:text title="Amount Contributed ($)" styleClass="moduleEdit"
                                                property="depAmtContributed[${counter}]" styleId="depAmtContributed[${counter}]_id"
                                                size="20" maxlength="10" readonly="true" />
                                        </td>
                                    </tr>                                        
                                    </c:if>                                   
                                    <tr valign="top">
                                        <td class="moduleLabel">Child has Income:</td>
                                        <td colspan="2" class="moduleValue">
                                            <c:forEach var="item" items="${yesNoList}">
                                                <c:set var="itemLabel">
                                                    <bean-el:message key="${item.label}" />
                                                </c:set>
                                                <html-el:radio title="Child has Income (${itemLabel})" property="depHasIncome[${counter}]"
                                                    styleId="depHasIncome[${counter}]_${item.value}" value="${item.value}"
                                                    disabled="${finacialsReadOnlyData}" />
                                                <fw:label property="depHasIncome[${counter}],depHasIncome_${hashCode}"
                                                    forId="depHasIncome[${counter}]_${item.value}">
                                                    <bean-el:message key="${item.label}" />&nbsp;&nbsp;</fw:label>
                                            </c:forEach>
                                        </td>
                                    </tr>
                                    <tr valign="top">
                                        <td class="moduleLabel">Available Income:</td>
                                        <td colspan="2" class="moduleValue">
                                            <c:forEach var="item" items="${yesNoList}">
                                                <c:set var="itemLabel">
                                                    <bean-el:message key="${item.label}" />
                                                </c:set>
                                                <html-el:radio title="Available Income (${itemLabel})"
                                                    property="depIncomeAvailableToPatient[${counter}]"
                                                    styleId="depIncomeAvailableToPatient[${counter}]_${item.value}" value="${item.value}"
                                                    disabled="${finacialsReadOnlyData}" />
                                                <fw:label
                                                    property="depIncomeAvailableToPatient[${counter}],depIncomeAvailableToPatient_${hashCode}"
                                                    forId="depIncomeAvailableToPatient[${counter}]_${item.value}">
                                                    <bean-el:message key="${item.label}" />&nbsp;&nbsp;</fw:label>
                                            </c:forEach>
                                        </td>
                                    </tr>
                                    <tr valign="top">
                                        <td class="moduleLabel">In School:</td>
                                        <td colspan="2" class="moduleValue">
                                            <c:forEach var="item" items="${yesNoList}">
                                                <c:set var="itemLabel">
                                                    <bean-el:message key="${item.label}" />
                                                </c:set>
                                                <html-el:radio title="In School (${itemLabel})" property="depAttendedSchool[${counter}]"
                                                    styleId="depAttendedSchool[${counter}]_${item.value}" value="${item.value}"
                                                    disabled="${finacialsReadOnlyData}" />
                                                <fw:label property="depAttendedSchool[${counter}],depAttendedSchool_${hashCode}"
                                                    forId="depAttendedSchool[${counter}]_${item.value}">
                                                    <bean-el:message key="${item.label}" />&nbsp;&nbsp;</fw:label>
                                            </c:forEach>
                                        </td>
                                    </tr>
                                    <tr valign="top">
                                        <td class="moduleLabel">Incapable of Self Support:</td>
                                        <td colspan="2" class="moduleValue">
                                            <c:forEach var="item" items="${yesNoList}">
                                                <c:set var="itemLabel">
                                                    <bean-el:message key="${item.label}" />
                                                </c:set>
                                                <html-el:radio title="Incapable of Self Support (${itemLabel})"
                                                    property="depIncapableOfSelfSupport[${counter}]"
                                                    styleId="depIncapableOfSelfSupport[${counter}]_${item.value}" value="${item.value}"
                                                    disabled="${finacialsReadOnlyData}" />
                                                <fw:label
                                                    property="depIncapableOfSelfSupport[${counter}],depIncapableOfSelfSupport_${hashCode}"
                                                    forId="depIncapableOfSelfSupport[${counter}]_${item.value}">
                                                    <bean-el:message key="${item.label}" />&nbsp;&nbsp;</fw:label>
                                            </c:forEach>
                                        </td>
                                    </tr>
                                </table>

                            </td>
                        </tr>

                    </c:forEach>
                </c:if>
            </table>
        </td>
    </tr>
</table>
<!-- end of new code -->



<html-el:hidden property="incomeYear" />
<html-el:hidden property="displayName" />
<html-el:hidden property="incomeTestAvaliableInd" />
<html-el:hidden property="newIncomeTestInd" />
<html-el:hidden property="post2005formatInd" />
<html-el:hidden property="adjustedMedicalExpense" />
<html-el:hidden property="pendingAdjudication" />
<html-el:hidden property="addAPerson" />
<%-- html-el:hidden property="sendForAdjudication" / --%>

<c:if test="${financialDetailsForm.post2005formatInd == 'true'}">
    <jsp:include page="post2005Format.jsp" />
</c:if>
<c:if test="${financialDetailsForm.post2005formatInd == 'false'}">
    <jsp:include page="pre2005Format.jsp" />
</c:if>
