																		
<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="/tags/esr-core" prefix="esrcore" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/fw" prefix="fw" %>
<%@ taglib uri="/tags/struts-logic" prefix="logic" %>

<%@ page import='gov.va.med.esr.ui.common.util.JspUtils' %>
<%@ page import='gov.va.med.esr.common.model.lookup.VAFacility' %>
<%@ taglib uri="/tags/authz" prefix="auth" %>
<%@ page import='gov.va.med.esr.common.model.lookup.Capability' %>
<%@ page import='gov.va.med.esr.common.model.lookup.PHDocumentType' %>

<c:set var="expandableSectionCollapsed" scope="page"><bean-el:message key="label.expandableSectionCollapsed"/></c:set>

<c:set var="addAPersonContext" value="false"/>

<!-- set veteran indicator to disable the fields for non veteran -->
<c:set var="nonVeteran" value="false"/>
<c:if test="${eligibilityForm.veteranIndicator == 'n'}">
    <c:set var="nonVeteran" value="true"/>
</c:if>

<!-- check to see if it is "add a person" to display the required field of Eligibility Status Date. -->
<c:if test="${AppData.SelectedPerson != null && AppData.addAPerson != null && AppData.addAPerson == true}">
        <c:set var="addAPersonContext" value="true"/>
</c:if>

<script type="text/javascript">

var methodCounter=0;
var needAgentOrangeExposureLocationWarning = false;
var needRadiationExposureMethodWarning = false;

function onLoadInit()
{

  if (eligibilityForm.nefHiddenId.value == 'true')
  {
    expandOrCollapse(nefBlock, eligibilityForm.nefImage, eligibilityForm.nefHiddenId);
  }
  if (eligibilityForm.rdHiddenId.value == 'true')
  {
    expandOrCollapse(rdBlock, eligibilityForm.rdImage, eligibilityForm.rdHiddenId);
  }
  if (eligibilityForm.voaHiddenId.value == 'true')
  {
    expandOrCollapse(voaBlock, eligibilityForm.voaImage, eligibilityForm.voaHiddenId);
  }
  if (eligibilityForm.nveHiddenId.value == 'true')
  {
    expandOrCollapse(nveBlock, eligibilityForm.nveImage, eligibilityForm.nveHiddenId);
  }
  if (eligibilityForm.powHiddenId.value == 'true')
  {
    expandOrCollapse(powBlock, eligibilityForm.powImage, eligibilityForm.powHiddenId);
  }
  
  processPermanentTotalIndicator();
  processRatedIncompetentIndicator();
  //gerepu Version:4.5.0
  processeligStatusReason();
//gerepu Version:4.5.0-end
  processEligibleForMedicaid('n');
  processIneligibleIndicator();
  processVaPensionIndicator(); 
  processECLVIndicator();
  processECLVEligibility(${eligibilityForm.campLejeuneDisabled});
  processEAddPerson(${AppData.addAPerson});
  checkForOtherVerificationMethod();
  countMethods();
}



function processEligibilityStatus(thisForm)
{
  thisForm.eligibilityStatusDate.value = thisForm.todayDate.value;
  processeligStatusReason();
  
}

 
//function processEligibilityStatus(thisForm, hiddenFieldId, fieldId)
//{
//    var hiddenField = document.getElementById(hiddenFieldId);
//    var selectedOption = document.getElementById(fieldId).options[document.getElementById(fieldId).selectedIndex];
//    //var selectedOption = document.getElementById(fieldId);
//    if ( hiddenField.value != selectedOption.value ) {
//       thisForm.eligibilityStatusDate.value = thisForm.todayDate.value;
        
//    }
    
//}

function displayMessageIfAgentOrangeExposureLocationEmpty(hiddenFieldId, fieldId, msg)
{
  var hiddenField = document.getElementById(hiddenFieldId);
  //var selectedOption = document.getElementById(fieldId).options[document.getElementById(fieldId).selectedIndex];
  //var selectedOption = document.getElementById(fieldId);
  //if ( hiddenField.value != selectedOption.value ) 
  if ( hiddenField.value != fieldId.value ) 
  {
      if (fieldId != null && fieldId.value.length == 0)
        {
          //alert("randy1");
          needAgentOrangeExposureLocationWarning = true;
        }
  }

}

function displayMessageIfRadiationExposureMethodEmpty(hiddenFieldId, fieldId, msg)
{
  var hiddenField = document.getElementById(hiddenFieldId);
  //var selectedOption = document.getElementById(fieldId).options[document.getElementById(fieldId).selectedIndex];
  //var selectedOption = document.getElementById(fieldId);
  
  if ( hiddenField.value != fieldId.value ) 
  {
      if (fieldId != null && fieldId.value.length == 0)
        {
          
          needRadiationExposureMethodWarning = true;
        }
  }

}

function displyWarnings()
{
    var msg_orange_rediation = "Removing the Agent Orange Location will change the Agent Orange Indicator to No. \n \nRemoving the Radiation Exposure Method will change the Radiation Exposure Indicator to No."
    var msg_orange = "Removing the Agent Orange Location will change the Agent Orange Indicator to No."
    var msg_rediation = "Removing the Radiation Exposure Method will change the Radiation Exposure Indicator to No."
    if (needAgentOrangeExposureLocationWarning == true)
    {
         if (needRadiationExposureMethodWarning == true)
         {
             needRadiationExposureMethodWarning = false;
             needAgentOrangeExposureLocationWarning = false;
             return confirm(msg_orange_rediation);
         }       
         else
         {
             needAgentOrangeExposureLocationWarning = false;
             return confirm(msg_orange);
         }
    }
    else 
    {
        if (needRadiationExposureMethodWarning == true)
        {
            needRadiationExposureMethodWarning = false;
            return confirm(msg_rediation);
        }
        else
            return true;         
    }
}

function checkForApplyButtonWarning()
{
    var msg = "If you selected any new values from follwing selection boxes, you will need to press the APPLY button before pressing UPDATE button. (Eligibility Status, Agent Orange Exposure Location, Radiation Exposure Method)"
    return confirm(msg);
    //alert(msg);
     //return true;
}

function processPermanentTotalIndicator()
{
  var permanentTotal_y = document.getElementById('idPermanentTotal_y');
  var permanentTotalEffDate = document.getElementById('idPermanentTotalEffDate');
  var block = document.getElementById('ptBlock');
  var imageElement = document.getElementById('ptArrowImage');

  if (permanentTotal_y.value == null || permanentTotal_y.checked == false)
  {
    permanentTotalEffDate.value = '';
    collapseSection(block, imageElement, null);
  }
  else
  {
    expandSection(block, imageElement, null);
  }
}

function processRatedIncompetentIndicator()
{
    var ratedIncompetent_nd = document.getElementById('idRatedIncompetent_nd');
    var block = document.getElementById('riBlock');
    var imageElement = document.getElementById('riArrowImage');
    var civilDate = document.getElementById('idCivilDate');
    var vaDate = document.getElementById('idVaDate');

    if (ratedIncompetent_nd.value == null || ratedIncompetent_nd.checked)
    {
      civilDate.value = '';
      vaDate.value = '';
      collapseSection(block, imageElement, null);
    }
    else
    {
      expandSection(block, imageElement, null);
    }
}



// code to toggle  the resoon expanation field 
function processeligStatusPendingVerficationReason()
{   var selectBox = document.getElementById('txteligStatusPendingVerficationReason');
    var item1 = selectBox.options[selectBox.selectedIndex].value;    
 	var block = document.getElementById('verficationReasonExpDiv');
    if (item1=='OT')
    {    	block.style.display = "block";     }
    else    {    	block.style.display = "none";    
    document.getElementById('txtVerficaationReasonExp').value = '';
    }
}

// code to toggle  the resoon field 
function processeligStatusReason()
{   var selectBox = document.getElementById('txtEligibilityStatus');
    var item1 = selectBox.options[selectBox.selectedIndex].value;    
 	var block = document.getElementById('verficationReasonDiv');
 	var x = document.getElementsByName("veteranIndicator"); 
    if (x[0].value=='y' && (item1=='P' || item1=='R'))
    {     block.style.display = "block";  }
    else    {    	block.style.display = "none"; 
    var selectBoxReason = document.getElementById('txteligStatusPendingVerficationReason');
    selectBoxReason.options[0].selected = true;    
    }

    processeligStatusPendingVerficationReason();
}

function processIncompetentDates(thisForm)
{
  var ratedIncompetent_y = document.getElementById('idRatedIncompetent_y');
  ratedIncompetent_y.checked = true;
  return true;
}

function processCheckAmount(thisForm)
{
  var checkAmount = thisForm.totalCheckAmount.value;
  if (parseInt(checkAmount) >= 0)
  {
    thisForm.totalMonthlyCheckAmount.value = parseInt(checkAmount) / 12;
  }
  else
  {
    thisForm.totalMonthlyCheckAmount.value = '';
  }
}
function setCheckBoxValue(fieldObject){
    if(fieldObject.checked == false){
        fieldObject.value='off' ;
    }
    else if(fieldObject.checked == true){
        fieldObject.value='on' ;
    }
}
function processMonthlyCheckAmount(thisForm)
{
  var checkAmount = thisForm.totalMonthlyCheckAmount.value;
  if (parseInt(checkAmount) >= 0)
  {
    thisForm.totalCheckAmount.value = parseInt(checkAmount) * 12;
  }
  else
  {
    thisForm.totalCheckAmount.value = '';
  }
}

function addRowForDocType(rowNumber){
    eligibilityForm.activeVOARowID.value = rowNumber;
    //eligibilityForm.submit();
}

function processEligibleForMedicaid(defaultMedicaidUpdateDate)
{
  var indicator_nd = document.getElementById('idEligibleForMedicaid_nd');
  var medicaidUpdateDate = document.getElementById('idMedicaidUpdateDate');
  var block = document.getElementById('emBlock');
  var imageElement = document.getElementById('emArrowImage');

  if (indicator_nd.value == null || indicator_nd.checked)
  {
    medicaidUpdateDate.value = '';
    collapseSection(block, imageElement, null);
  }
  else
  {
    if ((defaultMedicaidUpdateDate != null) && (defaultMedicaidUpdateDate == 'y'))
    {
      // Always populated as today's date when user selects the "Y" or "N" radio buttons
      formatDateTime(null, "MM/dd/yyyy HH:mm", medicaidUpdateDate);
    }
    expandSection(block, imageElement, null);
  }
}

function processIneligibleIndicator()
{
  var ineligibleDate = document.getElementById('idIneligibleDate');
  var block = document.getElementById('ineBlock');
  var imageElement = document.getElementById('ineArrowImage');
  var ineligibleReason = document.getElementById('idIneligibleReason');
  var ineligibleVAROReason = document.getElementById('idIneligibleVAROReason');

  if (ineligibleDate.value == null || ineligibleDate.value == '')
  {
    ineligibleReason.value = '';
    ineligibleVAROReason.value = '';
    collapseSection(block, imageElement, null);
  }
  else
  {
    expandSection(block, imageElement, null);
  }
}

function checkForOtherVerificationMethod() {

    var i = 0;
    eligibilityForm.campLejeuneVerificationComments.disabled=true;  
    for (i = 0; i < eligibilityForm.campLejeuneVerificationMethods.length; i++) {
         if (eligibilityForm.campLejeuneVerificationMethods[i].checked) {
             if (i == "5") 
             {
                 eligibilityForm.campLejeuneVerificationComments.disabled=false;
             }
             else
             {
                 //eligibilityForm.campLejeuneVerificationComments.disabled=true;    
             }
         }
    }
}

function checkForNoVerificationMethods() {
     var checkSelected = false;
     if (methodCounter != 0)
     {
     for (i = 0; i < eligibilityForm.campLejeuneVerificationMethods.length; i++) {
         if (eligibilityForm.campLejeuneVerificationMethods[i].checked) {
             checkSelected = true;
         }
     }
         if (!checkSelected) {
             alert("Once any Camp Lejeune Verified Method has been selected, at least one must remain selected");
             return false;
         }
     }
     return true;
}

function countMethods() {
    var i = 0;
    for (i = 0; i < eligibilityForm.campLejeuneVerificationMethods.length; i++) {
         if (eligibilityForm.campLejeuneVerificationMethods[i].checked) {
         methodCounter++;
         }
    }
}

// Add an event listener to disable the carriage return key from submitting the form
addNoCREventListener();
</script>

<table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShell" role="presentation">
<html-el:form action="/eligibilityEdit" method="post">
  <%@ include file="/admin/csrfgentoken.jsp" %>
  <tr>
    <td>
      <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTable" role="presentation">
        <tr>
          <td>
            <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead" role="presentation">
              <tr>
                <td class="moduleBlueBox"><img alt=""  src="../images/spacer.gif" width="25" height="17"/></td>
                <td nowrap style="padding-left: 7"><bean-el:message key="eligibilityEdit.title"/></td>
                <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
              </tr>
            </table>
          </td>
        </tr>
        <tr width="100%" >
          <td  width="100%">
            <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
              <tr>
                  <td colspan="2">
                    <%@ include file="/tiles/common/instructionalText.jsp" %>
                  </td>
              </tr>
              <tr width="100%">
                <td width="45%" style="padding-top: 10" class="moduleLabel"><fw:label required="true" property="veteranIndicator"><bean-el:message key="label.veteranIndicator"/>:</fw:label></td>
                <td width="55%" style="padding-top: 10" class="moduleValue">
                  <html-el:hidden name="eligibilityForm" property="veteranIndicator"/>
                  <table width="20%" border="0"cellspacing="0" cellpadding="0" role="presentation">
                    <tr>
                    <c:set var="requiredVeteranIndicatorText"><bean-el:message key="label.required"/>, <bean-el:message key="label.veteranIndicator"/></c:set>
                    <c:choose>
                    <c:when test="${eligibilityForm.veteranIndicator == 'y'}">
                      <td title="<c:out value="${requiredVeteranIndicatorText}"/>" class="moduleValue">Yes</td>
                      <td>&nbsp;&nbsp;</td>
                      <td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
                      <td>
                        <html-el:submit property="methodName" style="width:150; vertical-align: top;" styleClass="buttonText initfocus">
                          <bean-el:message key="button.setVeteranIndNo"/>
                        </html-el:submit></td>
                      <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
                      <td width="100%"><img alt=""  src="../images/spacer.gif" width="1" height="1"/></td>
                    </c:when>
                    <c:otherwise>
                      <td title="${requiredVeteranIndicatorText}" class="moduleValue">No</td>
                      <td>&nbsp;&nbsp;</td>
                      <td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
                      <td>
                        <html-el:submit property="methodName" style="width:150; vertical-align: top;" styleClass="buttonText initfocus">
                          <bean-el:message key="button.setVeteranIndYes"/>
                        </html-el:submit></td>
                      <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
                      <td width="100%"><img alt=""  src="../images/spacer.gif" width="1" height="1"/></td>
                    </c:otherwise>
                    </c:choose>
                    </tr>
                  </table>
                </td>
              </tr>
              <tr>
                <td width="45%" class="moduleLabel"><fw:label required="true" property="eligibilityStatus" forId="txtEligibilityStatus"><bean-el:message key="label.eligibilityStatus"/>:</fw:label></td>
                <td width="55%" class="moduleValue">
                     <c:set var="requiredEligibilityStatusText"><bean-el:message key="label.required"/>, <bean-el:message key="label.eligibilityStatus"/></c:set>
                  <html-el:select title="${requiredEligibilityStatusText}" styleClass="moduleEdit" property="eligibilityStatus" styleId="txtEligibilityStatus" onchange="processEligibilityStatus(this.form);" >
                     <html-el:option value=""><bean-el:message key="label.select" /></html-el:option>
                     <esrcore:options collection="gov.va.med.esr.common.model.lookup.EligibilityStatus" property="code" labelProperty="description"/>
                  </html-el:select>
                    
                </td>
              </tr>
              <c:choose>
              <c:when test="${addAPersonContext}">
              <tr>
                <td width="45%" class="moduleLabel"><fw:label required="true" property="eligibilityStatusDate" forId="txtEligibilityStatusDate"><bean-el:message key="label.eligibilityStatusDate"/>:</fw:label></td>
                <td width="55%" class="moduleValue">
                  <c:set var="requiredEligibilityStatusDateText"><bean-el:message key="label.required"/>, <bean-el:message key="label.eligibilityStatusDate"/> <bean-el:message key="label.mmddyyyy"/></c:set>
                  <html-el:text title="${requiredEligibilityStatusDateText}" styleClass="moduleEdit" property="eligibilityStatusDate" styleId="txtEligibilityStatusDate" />&nbsp;<bean-el:message key="label.mmddyyyy"/>
                  <html-el:hidden name="eligibilityForm" property="oldEligibilityStatusDate"/>
                </td>
              </tr>
              </c:when>
              <c:otherwise>
              <tr>
                <td width="45%" class="moduleLabel"><fw:label property="eligibilityStatusDate" forId="txtEligibilityStatusDate"><bean-el:message key="label.eligibilityStatusDate"/>:</fw:label></td>
                <td width="55%" class="moduleValue">
                  <c:set var="eligibilityStatusDateText"><bean-el:message key="label.eligibilityStatusDate"/> <bean-el:message key="label.mmddyyyy"/></c:set>
                  <html-el:text title="${eligibilityStatusDateText}" styleClass="moduleEdit" property="eligibilityStatusDate" styleId="txtEligibilityStatusDate" />&nbsp;<bean-el:message key="label.mmddyyyy"/>
                  <html-el:hidden name="eligibilityForm" property="oldEligibilityStatusDate"/>
                </td>
              </tr>
              </c:otherwise>
              </c:choose>
              <tr>
                <td width="45%" class="moduleLabel"><fw:label property="verificationMethod" forId="txtVerificationMethod"><bean-el:message key="label.verificationMethod"/>:</fw:label></td>
                <td width="55%" class="moduleValue">
                  <c:set var="eligibilityVerificationMethodText"><bean-el:message key="label.verificationMethod"/></c:set>
                  <html-el:text title="${eligibilityVerificationMethodText}" styleClass="moduleEdit" property="verificationMethod" styleId="txtVerificationMethod" maxlength="50" size="57"/>
                </td>
              </tr>
                 
             <!-- --code changes begin garepu Version:4.5.0 -->        
              <tr>
               <td width="100%" colspan="2">
                  <div id="verficationReasonDiv" class="expandCollapseBody">
                  <table width="100%" cellSpacing=0 cellPadding=0 border=0 role="presentation">              
                   <tr>
               <td width="45%" class="moduleLabel" nowrap><fw:label required="true" property="eligStatusPendingVerficationReason" forId="txteligStatusPendingVerficationReason"><bean-el:message key="label.eligStatusPendingVerficationReason"/>:</fw:label></td>
                <td width="55%" class="moduleValue">
                  <c:set var="requiredeligStatusPendingVerficationReasonText"><bean-el:message key="label.required"/>, <bean-el:message key="label.eligStatusPendingVerficationReason"/></c:set>
                  <html-el:select title="${requiredeligStatusPendingVerficationReasonText}" styleClass="moduleEdit" property="eligStatusPendingVerficationReason" styleId="txteligStatusPendingVerficationReason" onchange="processeligStatusPendingVerficationReason();" >
                     <html-el:option value=""><bean-el:message key="label.select" /></html-el:option>
                     <esrcore:options collection="gov.va.med.esr.common.model.lookup.EligibilityStatusPendVerfiReason" property="code" labelProperty="description"/>
                  </html-el:select>   
                </td>
              </tr>
                  </table>
                  </div>
                </td>
             </tr>
              <tr>
                <td width="100%" colspan="2">
                  <div id="verficationReasonExpDiv" class="expandCollapseBody">
                  <table width="100%" cellSpacing=0 cellPadding=0 border=0 role="presentation">              
                   <tr>
                <td width="45%" class="moduleLabel">   
							<fw:label property="eligStatusPendingVerfReasonExplain" required="true" forId="txtVerficaationReasonExp">
							<bean-el:message key="label.eligStatusPendingVerficationReasonExp"/>:</fw:label>
				</td>					  
			   <td width="55%" class="moduleValue">
						                   <c:set var="eligitxtVerficaationReasonExpText"><bean-el:message key="label.eligStatusPendingVerficationReasonExp"/></c:set>
                	  <html-el:textarea title="${eligitxtVerficaationReasonExpText}" styleClass="moduleEdit" property="eligStatusPendingVerfReasonExplain" styleId="txtVerficaationReasonExp" rows="4" cols="60"  />  
                </td>
              </tr>
                  </table>
                  </div>
                </td>
              </tr>
             
            <!-- --code changes end garepu Version:4.5.0 -->        
              <tr>
                <td width="45%" class="moduleLabel"><fw:label property="serviceConnected" forId="txtServiceConnected"><bean-el:message key="label.serviceConnected"/>:</fw:label></td>
                <td width="55%" class="moduleValue">
                  <c:set var="serviceConnectedText"><bean-el:message key="label.serviceConnected"/></c:set>
                  <html-el:text title="${serviceConnectedText} (%)" styleClass="moduleEdit" styleId="txtServiceConnected" maxlength="3" property="serviceConnected" readonly="${nonVeteran}"/> %
                </td>
              </tr>
             
              <tr>
                <td width="45%" class="moduleLabel"><fw:label property="effectiveDateCombinedRating" forId="txtEffDateCombinedRating"><bean-el:message key="label.effectiveDateCombinedRating"/>:</fw:label></td>
                <td width="55%" class="moduleValue">
                  <c:set var="effectiveDateCombinedRatingText"><bean-el:message key="label.effectiveDateCombinedRating"/></c:set>
                  <html-el:text title="${effectiveDateCombinedRatingText}" styleClass="moduleEdit" styleId="txtEffDateCombinedRating" property="effectiveDateCombinedRating" />
                  <html-el:hidden name="eligibilityForm" property="oldEffectiveDateCombinedRating"></html-el:hidden>
                </td>
              </tr>
            <!-- Rated Disabilities -->
            <c:choose>
            <c:when test="${eligibilityForm.veteranIndicator == 'y'}">
            <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
              <tr>
                <td width="45%" class="moduleLabel">
                  <fw:link href="." onclick="expandOrCollapse(rdBlock, rdImage, rdHiddenId); return false">
                    <html-el:img alt="${expandableSectionCollapsed}" align="center" border="0" styleId="rdImage" src="../images/redArrowRight.gif"/><bean-el:message key="label.ratedSCDisabilities"/>
                  </fw:link>&nbsp;
                  <html-el:hidden name="eligibilityForm" property="rdHiddenId"/>
                </td>
                <td width="55%">&nbsp;</td>
              </tr>
              <tr>
                <td colspan="2">
                  <div id=rdBlock class="expandCollapseBody">
                    <table width="100%" align="center" cellSpacing="0" cellPadding="0" border="0" role="presentation">
                      <c:choose>
                      <c:when test="${not empty eligibilityForm.disabilityIdList}">
                        <tr>
                          <td width="40%"><img alt=""  src="../images/spacer.gif"></td>
                          <td class="moduleLabel" style="text-align:left" nowrap>&nbsp;</td>
                          <td class="moduleLabel" style="text-align:left; padding-left: 5px" nowrap>
                            <fw:label property="code"><bean-el:message key="label.code"/></fw:label>
                          </td>
                          <td class="moduleLabel" style="text-align:left; padding-left: 10px" nowrap>
                            <bean-el:message key="label.description"/>
                          </td>
                          <td class="moduleLabel" style="text-align:left; padding-left: 10px" nowrap>
                            <bean-el:message key="label.diagnosticExtremity"/>
                          </td>
                          <td class="moduleLabel" style="text-align:left; padding-left: 10px" nowrap>
                            <fw:label property="percentage"><bean-el:message key="label.SCPersentage"/></fw:label>
                          </td>
                          <td class="moduleLabel" style="text-align:left; padding-left: 10px" nowrap>
                            <fw:label property="originalEffectiveDate"><bean-el:message key="label.originalEffectiveDate"/></fw:label>
                          </td>
                          <td class="moduleLabel" style="text-align:left; padding-left: 10px" nowrap>
                            <fw:label property="currentEffectiveDate"><bean-el:message key="label.currentEffectiveDate"/></fw:label>
                          </td>
                          <td width="40%"><img alt=""  src="../images/spacer.gif"></td>
                        </tr>

                      <c:forEach var="dis" items="${eligibilityForm.disabilityIdList}" varStatus="status">
                      <c:set var="counter" value="${status.count - 1}" />
                        <tr>
                          <td width="40%"><img alt=""  src="../images/spacer.gif"></td>
                          <td class="moduleValue" nowrap>
                            <c:set var="ratedDisabilitySelectedText"><bean-el:message key="label.ratedDisabilities"/></c:set>
                            <html-el:multibox title="${ratedDisabilitySelectedText} ${status.count}" property="selectedDisabilityIndexes" value="${counter}"/>
                          </td>
                          <c:set var="codeText"><bean-el:message key="label.code"/></c:set>
                          <c:choose>
                          <c:when test="${eligibilityForm.disabilityIdList[counter] != null}">
                            <td title="<c:out value="${codeText} ${status.count}"/>" class="moduleValue" nowrap>
                              <c:out value="${eligibilityForm.disabilityCodesList[counter]}" />
                              <html-el:hidden name="eligibilityForm" property="disabilityCodes[${counter}]" />
                            </td>
                          </c:when>
                          <c:otherwise>
                            <td class="moduleValue" nowrap>
                              <html-el:text title="${codeText} ${status.count}" size="5" maxlength="4" styleClass="moduleEditSmall" styleId="disabilityCodesId-${counter}" property="disabilityCodes[${counter}]" onblur="lookupDisability(event)"/>
                            </td>
                          </c:otherwise>
                          </c:choose>
                          <td class="moduleValue" style="padding-left: 10px" nowrap>
                            <c:set var="descriptionText"><bean-el:message key="label.description"/></c:set>
                            <html-el:text title="${descriptionText} ${status.count}" size="33" readonly="true" styleClass="moduleEdit" styleId="disDescription[${counter}]" property="disDescription[${counter}]" />
                          </td>
                          <td class="moduleValue" style="padding-left: 10px" nowrap>
                            <c:set var="diagnosticExtremityText"><bean-el:message key="label.diagnosticExtremity"/></c:set>
                            <html-el:select title="${diagnosticExtremityText} ${status.count}" styleClass="moduleEdit" property="diagnosticExtremity[${counter}]" >
                            <html-el:option value=""></html-el:option>
                              <esrcore:options collection="gov.va.med.esr.common.model.lookup.DiagnosticExtremity" property="code" labelProperty="description"/>
                            </html-el:select>
                          </td>
                          <c:set var="originalEffectiveDateText"><bean-el:message key="label.originalEffectiveDate"/></c:set>
                          <c:set var="currentEffectiveDateText"><bean-el:message key="label.currentEffectiveDate"/></c:set>
                          <td class="moduleValue" style="padding-left: 10px" nowrap><html-el:text title="${serviceConnectedText} ${status.count} (%)" size="5" maxlength="3" styleClass="moduleEdit" property="percentage[${counter}]" /> %</td>
                          <td class="moduleValue" style="padding-left: 10px" nowrap><html-el:text title="${originalEffectiveDateText} ${status.count}" styleClass="moduleEditDate" property="originalEffectiveDate[${counter}]" /></td>
                          <td class="moduleValue" style="padding-left: 10px" nowrap><html-el:text title="${currentEffectiveDateText} ${status.count}" styleClass="moduleEditDate" property="currentEffectiveDate[${counter}]" /></td>
                          <td width="40%"><img alt=""  src="../images/spacer.gif"></td>
                        </tr>
                      </c:forEach>
                      </c:when>
                      <c:otherwise>
                        <tr>
                          <td width="45%" class="moduleLabel"><bean-el:message key="label.noDataAvailable"/>&nbsp;&nbsp;</td>
                          <td width="55%" class="moduleValue">&nbsp;</td>
                        </tr>
                      </c:otherwise>
                      </c:choose>
                      <tr>
                        <td colspan="2"><img alt=""  src="../images/spacer.gif" width="1" height="10"/></td>
                      </tr>
                    </table>
                    <table width="100%" border="0" cellpadding="0" cellspacing="0" role="presentation">
                      <tr>
                        <td width="45%"><img alt=""  src="../images/spacer.gif"/></td>
                        <td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
                        <td><html-el:submit property="methodName" style="width:160; vertical-align: top;" styleClass="buttonText"><bean-el:message key="button.addRatedDisability"/></html-el:submit></td>
                        <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
                        <td width="1%"><img alt=""  src="../images/spacer.gif"/></td>
                        <td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
                        <td><html-el:submit property="methodName" style="width:195; vertical-align: top;" styleClass="buttonText"><bean-el:message key="button.removeAllRatedDisability"/></html-el:submit></td>
                        <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
                        <td width="45%"><img alt=""  src="../images/spacer.gif"/></td>
                      </tr>
                    </table>
                    <table width="100%" border="0"cellspacing="0" cellpadding="0" role="presentation">
                      <tr><td width="100%"><img alt=""  src="../images/spacer.gif" width="1" height="15"/></td></tr>
                    </table>
                  </div>
                </td>
              </tr>
            </table>
            </c:when>
            <c:otherwise>
              <html-el:hidden name="eligibilityForm" property="rdHiddenId" value="false"></html-el:hidden>
            </c:otherwise>
            </c:choose>

            <!-- VOA Attachments  -->
           <jsp:include page="voaAttachment.jsp" flush="true" />
            
            <!-- POW -->
            <jsp:include page="powEpisode.jsp" flush="true" />

            <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
              <tr>
                <c:set var="purpleHeartStatusText"><bean-el:message key="label.purpleHeartStatus"/></c:set>
                <td width="45%" class="moduleLabel"><bean-el:message key="label.purpleHeartStatus"/>:</td>
                <td title="<c:out value="${purpleHeartStatusText}"/>" width="55%" class="moduleValue" nowrap>
                  <esrcore:displayLookupValue name="eligibilityForm" property="phStatus" lookupType="gov.va.med.esr.common.model.lookup.DecorationStatus" lookupProperty="description"/>
                    <html-el:hidden name="eligibilityForm" property="phStatus"/>
                </td>
              </tr>
              <tr>
                <td width="45%" class="moduleLabel"><bean-el:message key="label.aidAttendance"/>:</td>
                <td width="55%" class="moduleValue">
                  <c:forEach var="item" items="${yesNoList}">
                    <c:set var="aidAndAttendanceText"><bean-el:message key="label.aidAttendance"/>&nbsp;(<bean-el:message key="${item.label}" />)</c:set>
                    <html-el:radio title="${aidAndAttendanceText}" property="aidAttendance" value="${item.value}" styleId="txtAidAttendance_${item.value}" disabled="${nonVeteran}" /><fw:label property="aidAttendance" forId="txtAidAttendance_${item.value}"><bean-el:message key="${item.label}" /></fw:label>
                  </c:forEach>
                </td>
              </tr>
              <tr>
                <td width="45%" class="moduleLabel"><bean-el:message key="label.housebound"/>:</td>
                <td width="55%" class="moduleValue">
                  <c:forEach var="item" items="${yesNoList}">
                    <c:set var="houseboundText"><bean-el:message key="label.housebound"/>&nbsp;(<bean-el:message key="${item.label}" />)</c:set>
                    <html-el:radio title="${houseboundText}" property="housebound" value="${item.value}" styleId="txtHousebound_${item.value}" disabled="${nonVeteran}"/><fw:label property="housebound" forId="txtHousebound_${item.value}"><bean-el:message key="${item.label}" /></fw:label>
                  </c:forEach>
                </td>
              </tr>
             </table>
             
              <jsp:include page="pensionGroupData.jsp" flush="true" />
              
             <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
              <tr>
                <td width="45%" class="moduleLabel"><bean-el:message key="label.receivingCompensation"/>:</td>
                <td width="55%" class="moduleValue">
                  <c:forEach var="item" items="${yesNoUnknownList}">
                    <c:set var="receivingCompensationText"><bean-el:message key="label.receivingCompensation"/>&nbsp;(<bean-el:message key="${item.label}" />)</c:set>
                    <html-el:radio title="${receivingCompensationText}" property="isReceivingCompensation" styleId="txtIsReceivingComp_${item.value}" value="${item.value}" disabled="${nonVeteran}"/><fw:label property="isReceivingCompensation" forId="txtIsReceivingComp_${item.value}"><bean-el:message key="${item.label}" /></fw:label>
                  </c:forEach>
                </td>
              </tr>
              <tr>
                <td width="45%" class="moduleLabel"><fw:label property="totalMonthlyCheckAmount" forId="txtTotalMthChkAmt"><bean-el:message key="label.totalMonthlyCheckAmount"/>:</fw:label></td>
                <td width="55%" class="moduleValue">
                  <c:set var="totalMonthlyCheckAmountText"><bean-el:message key="label.totalMonthlyCheckAmount"/></c:set>
                  $<html-el:text title="${totalMonthlyCheckAmountText} ($)" styleClass="moduleEdit" property="totalMonthlyCheckAmount" styleId="txtTotalMthChkAmt" readonly="${nonVeteran}" onkeypress="return validateDollarAmount(event)" onkeyup="processMonthlyCheckAmount(this.form);" onchange="processMonthlyCheckAmount(this.form);" />
                </td>
              </tr>
              <tr>
                <td width="45%" class="moduleLabel"><fw:label property="totalCheckAmount" forId="txtTotalChkAmt"><bean-el:message key="label.totalCheckAmount"/>:</fw:label></td>
                <td width="55%" class="moduleValue">
                  <c:set var="totalCheckAmountText"><bean-el:message key="label.totalCheckAmount"/></c:set>
                  $<html-el:text title="${totalCheckAmountText} ($)" styleClass="moduleEdit" property="totalCheckAmount" styleId="txtTotalChkAmt" readonly="${nonVeteran}" onkeypress="return validateDollarAmount(event)" onkeyup="processCheckAmount(this.form);" onchange="processCheckAmount(this.form);" />
                </td>
              </tr>
              <tr>
                <td width="45%" class="moduleLabel"><bean-el:message key="label.unemployable"/>:</td>
                <td width="55%" class="moduleValue">
                  <c:forEach var="item" items="${yesNoList}">
                    <c:set var="unemployableText"><bean-el:message key="label.unemployable"/>&nbsp;(<bean-el:message key="${item.label}" />)</c:set>
                    <html-el:radio title="${unemployableText}" property="unemployable" styleId="txtUnemployable_${item.value}" disabled="${nonVeteran}" value="${item.value}" /><fw:label property="unemployable" forId="txtUnemployable_${item.value}"><bean-el:message key="${item.label}" /></fw:label>
                  </c:forEach>
                </td>
              </tr>
            </table>

            <!-- Permanent and Total -->
            <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
              <tr>
                <td width="45%" class="moduleLabel" nowrap><html-el:img alt="${expandableSectionCollapsed}" align="center" styleId="ptArrowImage" src="../images/redArrowRight.gif" /><bean-el:message key="label.permanentTotal"/>:</td>
                <td width="55%" class="moduleValue">
                  <c:forEach var="item" items="${yesNoList}">
                    <c:set var="permanentTotalText"><bean-el:message key="label.permanentTotal"/>&nbsp;(<bean-el:message key="${item.label}" />)</c:set>
                    <html-el:radio title="${permanentTotalText}" styleId="idPermanentTotal_${item.value}" name="eligibilityForm" property="permanentTotal" disabled="${nonVeteran}" onclick="processPermanentTotalIndicator()" onKeyPress="processPermanentTotalIndicator()" value="${item.value}" />
                        <fw:label property="permanentTotal" forId="idPermanentTotal_${item.value}"><bean-el:message key="${item.label}"/></fw:label>
                  </c:forEach>
                </td>
              </tr>
            </table>
            <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
              <tr>
                <td width="100%" colspan="2">
                  <div id="ptBlock" class="expandCollapseBody">
                    <table width="100%" cellSpacing=0 cellPadding=0 border=0 role="presentation">
                      <tr>
                        <td width="45%" class="moduleLabel"><fw:label property="permanentTotalEffDate" forId="idPermanentTotalEffDate"><bean-el:message key="label.permanentTotalDate"/>:</fw:label></TD>
                        <td width="55%" class="moduleValue">
                          <c:set var="permanentTotalDateText"><bean-el:message key="label.permanentTotalDate"/> <bean-el:message key="label.mmddyyyy"/></c:set>
                          <html-el:text title="${permanentTotalDateText}" styleClass="moduleEdit" styleId="idPermanentTotalEffDate" property="permanentTotalEffDate" disabled="${nonVeteran}"/><bean-el:message key="label.mmddyyyy"/>
                        </td>
                      </tr>
                    </table>
                  </div>
                </td>
              </tr>
            </table>

            <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
              <tr>
                <td width="45%" class="moduleLabel" nowrap><html-el:img alt="${expandableSectionCollapsed}" align="center" styleId="riArrowImage" src="../images/redArrowRight.gif" /><bean-el:message key="label.ratedIncompetent"/>:</td>
                <td width="55%" class="moduleValue">
                  <c:forEach var="item" items="${yesNoNoDataList}">
                    <c:set var="ratedIncompetentText"><bean-el:message key="label.ratedIncompetent"/>&nbsp;(<bean-el:message key="${item.label}" />)</c:set>
                    <html-el:radio title="${ratedIncompetentText}" styleId="idRatedIncompetent_${item.value}" name="eligibilityForm" property="ratedIncompetent" disabled="${nonVeteran}" onclick="processRatedIncompetentIndicator()" onKeyPress="processRatedIncompetentIndicator()" value="${item.value}" />
                        <fw:label property="ratedIncompetent" forId="idRatedIncompetent_${item.value}"><bean-el:message key="${item.label}" /></fw:label>
                  </c:forEach>
                </td>
               </td>
             </tr>
            </table>

            <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
              <tr>
                <td width="100%" colspan="2">
                  <div id="riBlock" class="expandCollapseBody">
                  <table width="100%" cellSpacing=0 cellPadding=0 border=0 role="presentation">
                    <tr>
                      <td width="45%" class="moduleLabel" ><fw:label property="civilDate" forId="idCivilDate"><bean-el:message key="label.civilDate"/>:</fw:label></td>
                      <td width="55%" class="moduleValue">
                        <c:set var="civilDateText"><bean-el:message key="label.civilDate"/> <bean-el:message key="label.mmddyyyy"/></c:set>
                        <html-el:text title="${civilDateText}" styleClass="moduleEdit" property="civilDate" styleId="idCivilDate" onkeypress="return processIncompetentDates(this.form);" />&nbsp;<bean-el:message key="label.mmddyyyy"/>
                      </td>
                    </tr>
                    <tr>
                      <td width="45%" class="moduleLabel"><fw:label property="vaDate" forId="idVaDate"><bean-el:message key="label.vaDate"/>:</fw:label></td>
                      <td width="55%" class="moduleValue">
                        <c:set var="vaDateText"><bean-el:message key="label.vaDate"/> <bean-el:message key="label.mmddyyyy"/></c:set>
                        <html-el:text title="${vaDateText}" styleClass="moduleEdit" property="vaDate" styleId="idVaDate" onkeypress="return processIncompetentDates(this.form);" />&nbsp;<bean-el:message key="label.mmddyyyy"/>
                      </td>
                    </tr>
                  </table>
                  </div>
                </td>
              </tr>
            </table>

            <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
              <tr>
                <td width="45%" class="moduleLabel" nowrap><html-el:img alt="${expandableSectionCollapsed}" align="center" styleId="emArrowImage" src="../images/redArrowRight.gif" /><bean-el:message key="label.eligibleForMedicaid"/>:</td>
                <td width="55%" class="moduleValue">
                  <c:forEach var="item" items="${yesNoNoDataList}">
                    <c:set var="eligibleForMedicaidText"><bean-el:message key="label.eligibleForMedicaid"/>&nbsp;(<bean-el:message key="${item.label}" />)</c:set>
                    <html-el:radio title="${eligibleForMedicaidText}" styleId="idEligibleForMedicaid_${item.value}" name="eligibilityForm" property="eligibleForMedicaid" disabled="${nonVeteran}" onclick="processEligibleForMedicaid('y')" onKeyPress="processEligibleForMedicaid('y')" value="${item.value}" />
                    <fw:label property="eligibleForMedicaid" forId="idEligibleForMedicaid_${item.value}"><bean-el:message key="${item.label}" /></fw:label>
                  </c:forEach>
                </td>
              </tr>
            </table>
            <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
              <tr>
                <td width="100%" colspan="2">
                  <div id="emBlock" class="expandCollapseBody">
                  <table width="100%" cellSpacing=0 cellPadding=0 border=0 role="presentation">
                    <tr>
                      <td width="45%" class="moduleLabel"><fw:label property="medicaidUpdatedDate" forId="idMedicaidUpdateDate"><bean-el:message key="label.medicaidUpdatedDate"/>:</fw:label></td>
                      <td width="55%" class="moduleValue">
                        <c:set var="medicaidUpdatedDateText"><bean-el:message key="label.medicaidUpdatedDate"/></c:set>
                        <html-el:text title="${medicaidUpdatedDateText}" size="20" styleClass="moduleEdit" styleId="idMedicaidUpdateDate" property="medicaidUpdatedDate" disabled="${nonVeteran}"/>
                        <html-el:hidden name="eligibilityForm" property="todayDate" ></html-el:hidden>
                      </td>
                    </tr>
                  </table>
                  </div>
                </td>
              </tr>
            </table>

            <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
              <tr>
                <c:set var="ineligibleDateText"><bean-el:message key="label.ineligibleDate"/> <bean-el:message key="label.mmddyyyy"/></c:set>
                <td width="45%" class="moduleLabel" nowrap><html-el:img alt="${expandableSectionCollapsed}" align="center" styleId="ineArrowImage" src="../images/redArrowRight.gif"/><fw:label property="ineligibleDate" forId="idIneligibleDate"><bean-el:message key="label.ineligibleDate"/>:</fw:label></td>
                <td width="55%" class="moduleValue"><html-el:text title="${ineligibleDateText}" styleId="idIneligibleDate" styleClass="moduleEdit" name="eligibilityForm" property="ineligibleDate" onchange="processIneligibleIndicator()" onkeydown="processIneligibleIndicator()" onkeyup="processIneligibleIndicator()"/>&nbsp;<bean-el:message key="label.mmddyyyy"/></td>
                <html-el:hidden name="eligibilityForm" property="serviceEntryDate"></html-el:hidden>
              </tr>
            </table>
            <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
              <tr>
                <td width="100%" colspan="2">
                  <div id="ineBlock" class="expandCollapseBody">
                  <table width="100%" cellSpacing=0 cellPadding=0 border=0 role="presentation">
                    <tr>
                      <td width="45%" class="moduleLabel"><fw:label required="true" property="ineligibleReason" forId="idIneligibleReason"><bean-el:message key="label.ineligibleReason"/>:</fw:label></td>
                      <td width="55%" class="moduleValue">
                        <c:set var="ineligibleReasonText"><bean-el:message key="label.required"/>, <bean-el:message key="label.ineligibleReason"/></c:set>
                        <html-el:text title="${ineligibleReasonText}" styleClass="moduleEdit" property="ineligibleReason" styleId="idIneligibleReason" maxlength="40" size="45"/>
                      </td>
                    </tr>
                    <tr>
                      <td width="45%" class="moduleLabel"><fw:label property="ineligibleVARODecision" forId="idIneligibleVAROReason"><bean-el:message key="label.ineligibleVARODecision"/>:</fw:label></td>
                      <td width="55%" class="moduleValue">
                        <c:set var="ineligibleVARODecisionText"><bean-el:message key="label.ineligibleVARODecision"/></c:set>
                        <html-el:text title="${ineligibleVARODecisionText}" styleClass="moduleEdit" property="ineligibleVARODecision" styleId="idIneligibleVAROReason" maxlength="75" size="57"/>
                      </td>
                    </tr>
                  </table>
                  </div>
                </td>
              </tr>
            </table>

            <!-- Other Eligibility Factors -->
            <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
              <tr>
                <td width="45%" class="moduleLabel">
                  <fw:link href="." onclick="expandOrCollapse(nefBlock, nefImage, nefHiddenId); return false">
                    <html-el:img alt="${expandableSectionCollapsed}" align="center" border="0" styleId="nefImage" src="../images/redArrowRight.gif"/><bean-el:message key="label.otherEligibilityFactors"/>
                  </fw:link>&nbsp;
                  <html-el:hidden name="eligibilityForm" property="nefHiddenId"/>
                </td>
                <td width="55%">&nbsp;</td>
              </tr>
              <tr>
                <td colspan="2">
                  <div id=nefBlock class="expandCollapseBody">
                  <table width="100%" cellSpacing=0 cellPadding=0 border=0 role="presentation">
                    <tr>
                      <td width="45%" class="moduleLabel"><fw:label property="dischargeDueDisability" forId="idDischargeDueDisability"><bean-el:message key="label.dischargeDueToDisability"/>:</fw:label></td>
                      <td width="55%" class="moduleValue">
                        <c:forEach var="item" items="${yesNoNoDataList}">
                          <c:set var="dischargeDueToDisabilityText"><bean-el:message key="label.dischargeDueToDisability"/>&nbsp;(<bean-el:message key="${item.label}" />)</c:set>
                          <html-el:radio title="${dischargeDueToDisabilityText}" property="dischargeDueDisability" styleId="idDischargeDueDisability_${item.value}" value="${item.value}" disabled="${nonVeteran}"/>
                          <fw:label property="dischargeDueDisability" forId="idDischargeDueDisability_${item.value}"><bean-el:message key="${item.label}" /></fw:label>
                        </c:forEach>
                      </td>
                    </tr>
                    <tr>
                      <td width="45%" class="moduleLabel"><bean-el:message key="label.disabilityRetirementFromMilitary"/>:</td>
                      <td width="55%" class="moduleValue">
                        <c:forEach var="item" items="${yesNoNoDataList}">
                          <c:set var="disabilityRetirementFromMilitaryText"><bean-el:message key="label.disabilityRetirementFromMilitary"/>&nbsp;(<bean-el:message key="${item.label}" />)</c:set>
                          <html-el:radio title="${disabilityRetirementFromMilitaryText}" property="disabilityRetirementIndicator" styleId="idDisabilityRetirementInd_${item.value}" value="${item.value}" disabled="${nonVeteran}"/>
                          <fw:label property="disabilityRetirementIndicator" forId="idDisabilityRetirementInd_${item.value}"><bean-el:message key="${item.label}" /></fw:label>
                        </c:forEach>
                      </td>
                    </tr>
                    <tr>
                        <td width="45%" class="moduleLabel"><fw:label property="agentOrangeLocation" forId="idAgentOrangeLoc"><bean-el:message key="label.agentOrangeExposureLocation"/>:</fw:label></td>
                        <td width="55%" class="moduleValue">
                        <c:set var="agentOrangeExposureLocationText"><bean-el:message key="label.agentOrangeExposureLocation"/></c:set>
                        <c:set var="agentOrangeLocationRemovedWarning"><bean-el:message key="message.agentOrangeLocationRemoved" /></c:set>
                        <table border="0" cellpadding="0" cellspacing="0" class="moduleShellLowTableBody" role="presentation">
                            <tr>
                                <td>
                                    <html-el:select title="${agentOrangeExposureLocationText}" styleClass="moduleEdit" property="agentOrangeLocation" styleId="idAgentOrangeLoc" disabled="${nonVeteran}" >
                                      <html-el:option styleClass="moduleEdit" value=""><bean-el:message key="label.notExposed" /></html-el:option>
                                      <esrcore:options collection="gov.va.med.esr.common.model.lookup.AgentOrangeExposureLocation" property="code" labelProperty="description"/>
                                    </html-el:select>
                                    
                                    <c:set var="agentOrangeLocationHiddenField" value="agentOrangeLocation_hid"/>
                                    <html-el:hidden property="agentOrangeLocation" styleId="${agentOrangeLocationHiddenField}" /> 
                                               
                                </td>
                                <td>
                                    &nbsp;
                                </td>
                            </tr>
                        </table>
                    </tr>
                    <tr>
                        <td width="45%" class="moduleLabel"><fw:label property="radiationExposureMethod" forId="idRadiationExpMethod"><bean-el:message key="label.radiationExposureMethod"/>:</fw:label></td>
                        <td width="55%" class="moduleValue">
                        <c:set var="radiationExposureMethodText"><bean-el:message key="label.radiationExposureMethod"/></c:set>
                        <c:set var="radiationExposureMethodRemovedWarning"><bean-el:message key="message.radiationExposureMethodRemoved" /></c:set>
                        <table border="0" cellpadding="0" cellspacing="0" class="moduleShellLowTableBody" role="presentation">
                            <tr>
                                <td>
                                    <html-el:select title="${radiationExposureMethodText}" styleClass="moduleEdit" property="radiationExposureMethod" styleId="idRadiationExpMethod" disabled="${nonVeteran}" >
                                      <html-el:option styleClass="moduleEdit" value=""><bean-el:message key="label.notExposed" /></html-el:option>
                                      <esrcore:options collection="gov.va.med.esr.common.model.lookup.RadiationExposureMethod" property="code" labelProperty="description"/>
                                    </html-el:select>
                                    
                                     <c:set var="radiationExposureMethodHiddenField" value="radiationExposureMethod_hid"/>
                                    <html-el:hidden property="radiationExposureMethod" styleId="${radiationExposureMethodHiddenField}" /> 
                                               
                              </td>
                              <td>
                                &nbsp;
                              </td>
                           </tr>
                        </table>
                    </tr>
                    <tr>
                      <td width="45%" class="moduleLabel"><fw:label property="environmentalContaminationExposure" forId="idEnvContaminationExp"><bean-el:message key="label.environmentalContaminationExposure"/>:</fw:label></td>
                      <td width="55%" class="moduleValue">
                        <c:forEach var="item" items="${yesNoList}">
                          <c:set var="environmentalContaminationExposureText"><bean-el:message key="label.environmentalContaminationExposure"/>&nbsp;(<bean-el:message key="${item.label}" />)</c:set>
                          <html-el:radio title="${environmentalContaminationExposureText}" property="environmentalContaminationExposure" value="${item.value}" styleId="idEnvContaminationExp_${item.value}" disabled="${nonVeteran}"/>
                          <fw:label property="environmentalContaminationExposure" forId="idEnvContaminationExp_${item.value}"><bean-el:message key="${item.label}" /></fw:label>
                        </c:forEach>
                      </td>
                    </tr>
 <!--  add stuff -->
 
<%-- add a person flag --%>
<c:set var="isAddAPerson" value="false"></c:set>
<c:set var="disableAPFields" scope="page" value="true"/>

<c:if test="${eligibilityForm.addAPerson == true}">  
    <c:set var="isAddAPerson" value="true"></c:set>
    <c:set var="disableAPFields" value="false"></c:set>
</c:if>
 
<html-el:hidden name="eligibilityForm" property="addAPerson"/>
                    
               <tr>
                <td width="45%" class="moduleLabel"><fw:label property="spinalCordInjury" forId="idSpinalCordInjury"><bean-el:message key="label.spinalCordInjury"/>:</fw:label></td>
                <td width="55%" class="moduleValue">
                   <html-el:select title="${spinalCordInjuryText}" styleClass="moduleEdit" property="spinalCordInjury" styleId="idSpinalCordInjury" 
                      disabled="${disableAPFields}">
                    <esrcore:options collection="gov.va.med.esr.common.model.lookup.SpinalCordInjuryType" property="code" 
                        labelProperty="description"/>
                  </html-el:select>
                 </td>
              </tr>   


               <tr>
               <!-- noseThroatRadiumText -->
                <td width="45%" class="moduleLabel"><bean-el:message key="label.noseThroatRadium"/>:</td>
                <td width="55%" class="moduleValue">
                  <c:forEach var="item" items="${yesNoUnknownList}">
                    <c:set var="noseThroatRadiumText"><bean-el:message key="label.noseThroatRadium"/>&nbsp;(<bean-el:message key="${item.label}" />)</c:set>
                    <html-el:radio title="${noseThroatRadiumText}" property="noseThroatRadium"  value="${item.value}"  styleId="idNoseThroatRadium_${item.value}" disabled="${disableAPFields}" />
                    <fw:label property="noseThroatRadium" forId="idNoseThroatRadium_${item.value}"><bean-el:message key="${item.label}" /></fw:label>
                  </c:forEach>
               </td>
              </tr>
              <!-- CLV -->
              <jsp:include page="campLejeuneEligibility.jsp" flush="true" />
                  </table>
                  </div>
                </td>
              </tr>
            </table>

            <!-- Non-Veteran Eligibility Codes -->
            <jsp:include page="nonVetEligibilityCodes.jsp" flush="true" />

            <!-- Buttons -->
            <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableBody" role="presentation">
              <tr>
                <td width="45%" style="padding: 25 0 25 0"><img alt=""  src="../images/spacer.gif"/></td>
                <td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
                <td><html-el:submit property="methodName" style="width:90; vertical-align: top;" disabled="${isAddAPerson}" 
                    styleClass="buttonText"><bean-el:message key="button.reviewImpact" />
                    </html-el:submit></td>
                <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
                <td width="1%"><img alt=""  src="../images/spacer.gif"/></td>
                <td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
                <td><html-el:submit property="methodName" style="width:95; vertical-align: top;" styleClass="buttonText" onclick="displayMessageIfRadiationExposureMethodEmpty('${radiationExposureMethodHiddenField}',idRadiationExpMethod,'${radiationExposureMethodRemovedWarning}'); displayMessageIfAgentOrangeExposureLocationEmpty('${agentOrangeLocationHiddenField}',idAgentOrangeLoc,'${agentOrangeLocationRemovedWarning}'); return displyWarnings()"><bean-el:message key="button.acceptChanges"/></html-el:submit></td>
                <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
                <td width="1%"><img alt=""  src="../images/spacer.gif"/></td>
                <td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
                <td><html-el:submit property="methodName" style="width:45; vertical-align: top;" styleClass="buttonText"><bean-el:message key="button.cancel"/></html-el:submit></td>
                <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
                <td width="1%"><img alt=""  src="../images/spacer.gif"/></td>
                <td width="80%"><img alt=""  src="../images/spacer.gif"/></td>
              </tr>
            </table>

          </td>
        </tr>
      </table>
    </td>
  </tr>
</html-el:form>
</table>
