<%@ page contentType="text/html;charset=UTF-8" %>
<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/fw" prefix="fw" %>
<%@ taglib uri="/tags/esr-core" prefix="esrcore" %>

<%@ taglib uri="/tags/authz" prefix="auth" %>
<%@ page import='gov.va.med.esr.common.model.lookup.Capability' %>
<%@ page import="gov.va.med.esr.common.model.lookup.CampLejeuneVerificationType" %>
<%@ page import="gov.va.med.esr.common.model.lookup.CampLejeuneChangeSource" %>
<%@ page import="gov.va.med.esr.common.model.lookup.VAFacility" %>
<c:set var="readOnlyEE" scope="request" value="true"/>

  <%-- Person Locked Check --%>
<c:set var="appData" value="${AppData}" scope="session"/>
<c:set var="personKey" value="SelectedPerson"/>
<c:set var="personLocked" value="${appData[personKey].personLocked}"/>
<c:if test="${personLocked}">
  <c:set var="readOnlyEE" scope="request" value="true"/>
</c:if>

<c:set var="CLVRequiredFields" scope="page" value="false" />
<c:choose>
<c:when test="${CLVRequiredFields}">
<c:set var="requiredFlag"><%= Boolean.TRUE.toString() %></c:set>
<c:set var="requiredText"><bean-el:message key="label.required"/>,&nbsp;</c:set>
</c:when>
<c:otherwise>
<c:set var="requiredFlag"><%= Boolean.FALSE.toString() %></c:set>
<c:set var="requiredText"></c:set>
</c:otherwise>
</c:choose>

<c:set var="isCampLejeuneDiabled" value="true"></c:set>
<c:if test="${eligibilityForm.campLejeuneDisabled == 'false' && !readOnlyEE}">
<c:set var="isCampLejeuneDiabled" value="false"></c:set>
</c:if>
<c:set var="isCampLejeuneDiabled" value="false"></c:set>

<c:set var="IndicatorNO"><%=gov.va.med.esr.common.model.lookup.Indicator.NO.getCode()%></c:set>
<c:set var="IndicatorYES"><%=gov.va.med.esr.common.model.lookup.Indicator.YES.getCode()%></c:set>
<esrcore:setLookup var="SortedIndicator" className="gov.va.med.esr.ui.common.beans.SortedIndicator" />

<c:set var="mmddyyyyText" scope="page"><bean-el:message key="label.mmddyyyy"/></c:set>
<c:set var="expandableSectionCollapsed" scope="page"><bean-el:message key="label.expandableSectionCollapsed"/></c:set>
<c:set var="verificationmethod_other" scope="page"><%=CampLejeuneVerificationType.VERIFICATION_OTHER.getName()%></c:set>

<script type="text/javascript" language="JavaScript">
function processEAddPerson(isAddPerson)
{
  var clv_n = document.getElementById('ideclvInd_0');
 var clv_y = document.getElementById('ideclvInd_1');
  if(isAddPerson!=null)
  {
   if(isAddPerson==true)
   {
    clv_n.disabled=false;
    clv_y.disabled=false;
    document.getElementById('ideCDate').style.display='none';
    document.getElementById('ideCSource').style.display='none';
    document.getElementById('ideCSite').style.display='none';
    processECLVIndicator();
    }
   }
}
function processECLVEligibility(isDisabled)
{
    var clv_n = document.getElementById('ideclvInd_0');
    var clv_y = document.getElementById('ideclvInd_1');
    var clvblock = document.getElementById('eclvBlock');
     var clvimageElement = document.getElementById('rieArrowImage');
    if(isDisabled== true)
    {
        if(clv_n!=null && clv_y!=null &&clvblock!=null && clvimageElement!=null)
        {
        collapseSection(clvblock, clvimageElement, null);
        clv_n.disabled=true;
        clv_y.disabled=true;
        }
        
    }
}

function processECLVIndicator()
{
    var clv_n = document.getElementById('ideclvInd_0');
    var clv_y = document.getElementById('ideclvInd_1');
    var block = document.getElementById('eclvBlock');
    var imageElement = document.getElementById('rieArrowImage');
    var verificationMethods = "campLejeuneVerificationMethods";
    var checkVerificationMethod = document.getElementById (verificationMethods).value;
    var comments = document.getElementById('ideComments');
    
    
        if (clv_y!= null && clv_y.checked)
        {
            expandSection(block, imageElement, null);
            verificationMethods.disabled=false;
     }
        else
        {
                collapseSection(block, imageElement, null);
                verificationMethods.disabled=true;
        }
     
    
  
}

</script>

<table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
      <tr>
      <td class="moduleLabel"><fw:label property="campLejeuneInd" forId="idCLV"><html-el:img alt="${expandableSectionCollapsed}" align="center" styleId="rieArrowImage" src="../images/redArrowRight.gif" /><bean-el:message key="label.clvInd" />:</fw:label></td>
       <td width="55%" class="moduleValue">
            <c:set var="clvText"><bean-el:message key="label.clvInd"/></c:set>
            <c:forEach var="item" items="${SortedIndicator}">
            <c:if test="${item.code == IndicatorNO or item.code == IndicatorYES}">
             <html-el:radio title="${clvText} (${item.description})" name="eligibilityForm" property="campLejeuneInd" styleId="ideclvInd_${item.code}" value="${item.code}" onclick="processECLVIndicator()" onKeyPress="processECLVIndicator()" disabled="${readOnlyMS}"/>
             <fw:label property="campLejeuneInd" forId="ideclvInd_${item.code}"><c:out value="${item.description}" />&nbsp;&nbsp;</fw:label>
            </c:if>
            </c:forEach> 
        </td>
       
      </tr>
</table> 

<table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">        
<tr>
    <td width="100%" colspan="2">
    <div id="eclvBlock" class="expandCollapseBody">
    <table width="100%" cellSpacing="0" cellPadding="0" border="0" role="presentation">
  <td class="moduleLabel" style="vertical-align: top"><fw:label property="campLejeuneVerificationMethods" forId="campLejeuneVerificationMethodsTextId"><bean-el:message key="label.clVerificationMethods"/>:</fw:label></td>
  <td class="moduleValue">
    <esrcore:setLookup var="campLejeuneVerificationMethodsList" className="gov.va.med.esr.common.model.lookup.CampLejeuneVerificationType"/>
    <table border="0" cellpadding="0" cellspacing="0" role="presentation">
      <c:forEach var="item" items="${campLejeuneVerificationMethodsList}" varStatus="loopCounter">
        <c:set var="campLejeuneVerificationMethodsText"><bean-el:message key="label.clVerificationMethods"/>&nbsp;(<c:out value="${item.name}"/>)</c:set>
        <tr><td><html-el:multibox title="${campLejeuneVerificationMethodsText}" property="campLejeuneVerificationMethods" styleId="campLejeuneVerificationMethodsTextId${loopCounter.count}" value="${item.code}" onclick="checkForOtherVerificationMethod(); return(checkForNoVerificationMethods())" disabled="${isCampLejeuneDiabled}"/></td><td class="moduleValue" width="99%">
        <fw:label forId="campLejeuneVerificationMethodsTextId${loopCounter.count}" property="campLejeuneVerificationMethods" ><c:out value="${item.name}"/></fw:label></td>
        </tr>
      </c:forEach>
    </table>
  </td>
 
    <tr>
      <td width="45%" class="moduleLabel"><fw:label forId="ideComments" property="campLejeuneVerificationComments"><bean-el:message key="label.clvComments"/>:</fw:label></td>
      <td width="55%" class="moduleValue">
        <c:set var="clvCommentsText"><bean-el:message key="label.clvComments"/> </c:set>
        <html-el:text title="${clvCommentsText}" styleClass="moduleEdit" styleId="ideComments" size="75" maxlength="200" disabled="${isCampLejeuneDiabled}" property="campLejeuneVerificationComments" />
      </td>
    </tr> 
    <tr id="ideCDate">
       <td width="45%" class="moduleLabel"><fw:label forId="idChangeDate" property="campLejeuneChangeDate"><bean-el:message key="label.clvChangeDate"/>:</fw:label></td>
       <td width="55%" class="moduleValue">
         <c:set var="clvChangeDateText"><bean-el:message key="label.clvChangeDate"/> <bean-el:message key="label.mmddyyyy"/></c:set>
         <html-el:text title="${clvChangeDateText}" styleClass="moduleEdit" styleId="idChangeDate" disabled="${isCampLejeuneDiabled}" property="campLejeuneChangeDate" />&nbsp;<bean-el:message key="label.mmddyyyy"/>
       </td>
     </tr>
 
     <tr id="ideCSite">
      <td width="45%" class="moduleLabel"><bean-el:message key="label.clvChangeSite"/>:</td>
      <td width="55%" class="moduleValue">
        <c:set var="changeSiteText"><bean-el:message key="label.clvChangeSite"/></c:set>
        <esrcore:displayValue name="eligibilityForm" property="campLejeuneChangeSite"/>      
      </td>
    </tr>
     <tr id="ideCSource">
      <td width="45%" class="moduleLabel"><bean-el:message key="label.clvChangeSource"/>:</td>
      <td width="55%" class="moduleValue">
        <c:set var="changeSourceText"><bean-el:message key="label.clvChangeSource"/></c:set>
        <esrcore:displayValue name="eligibilityForm" property="campLejeuneChangeSource"/>               
      </td>
    </tr>   
 </table>
 </div>
</td>
</tr>
</table>
     
     
