<%@ taglib uri="/tags/struts-logic" prefix="logic" %>
<%@ taglib uri="/tags/displaytag" prefix="display" %>
<%@ taglib uri="/tags/esr-core" prefix="esrcore" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/fw" prefix="fw" %>

<c:set var="displayRequiredFieldsIndicator" scope="page" value="false"/>
<c:set var="zipCodeLookup" scope="page" value="true"/>

<script src="../scripts/ESR-Script.js" type="text/javascript"></script>

<script>
function selectMedicareType(eltypeOfMedicare, elPartA, elPartB)
{
  if (eltypeOfMedicare.value == "Part A")
  {
    elPartB.style.display="none";
  }
  else
  {
    /* display Part B */
    elPartB.style.display="block";
  }
}

// Perform all page initialization
function onLoadInit()
{
    updateCountryFields();
}
</script>


<table id=tblFinancials cellSpacing=0 cellPadding=0 width=100% border=0 class="moduleShell" role="presentation">
  <html-el:form action="/editMedicare" method="post">
    <%@ include file="/admin/csrfgentoken.jsp" %>
  <html-el:hidden name="insuranceMedicareForm" styleId="idDateOfBirth" property="dateOfBirth"></html-el:hidden>
  <html-el:hidden name="insuranceMedicareForm" styleId="idDateOfDeath" property="dateOfDeath"></html-el:hidden>
  <tr>
    <td>
      <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTable" role="presentation">
        <tr>
          <td>
            <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead" role="presentation">
              <tr>
                <td width="5%" class="moduleBlueBox">&nbsp;</td>
                <td class="moduleHeadline">Update Insurance Carrier - Medicare</TD>
              </tr>
            </table>
          </td>
        </tr>
        <tr>
          <td>
            <%-- Common Fields for Medicare --%>
            <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableBody" role="presentation">
              <tr>
                  <td colspan="2">
                    <%@ include file="/tiles/common/instructionalText.jsp" %>
                  </td>
              </tr>
              <tr>
                <td width="45%" class="moduleLabel"><fw:label property="insCompanyName" forId="medInsCompanyNameTxt"><bean-el:message key="label.ins.insurance" />:</fw:label></td>
                <c:set var="insuranceText"><bean-el:message key="label.ins.insurance"/></c:set>
                <td width="55%" class="moduleValue"><html-el:text title="${insuranceText}" styleClass="moduleEdit" property="insCompanyName" styleId="medInsCompanyNameTxt" size="40" maxlength="30" readonly="true"/> </td>
              </tr>
              <tr>
                <td class="moduleLabel"><fw:label property="typeOfMedicare" forId="medicareType"><bean-el:message key="label.ins.medicare.typeofins" />:</fw:label></td>
                <td class="moduleValue">
                    <table border="0" cellpadding="0" cellspacing="0" class="moduleShellLowTableBody" role="presentation">
                        <tr>
                            <td>
                                <c:set var="typeofinsText"><bean-el:message key="label.ins.medicare.typeofins"/></c:set>
                                <html-el:select title="${typeofinsText}" styleClass="darkValue" property="typeOfMedicare" styleId="medicareType">
                                  <html-el:option value="Part A">Part A</html-el:option>
                                  <html-el:option value="Part A and B">Part A and B</html-el:option>
                                </html-el:select>
                            </td>
                            <td>
                                &nbsp;
                            </td>
                            <td>
                              <table width="10%" border="0" cellpadding="0" cellspacing="0" class="moduleShellLowTableBody" role="presentation">
                                <tr>
                                    <td><img alt=""  src="../images/buttonEndLeft.gif"  border="0"/></td>
                                    <td><html-el:submit property="methodName" style="width:50; vertical-align: top;" styleClass="buttonText"  onclick="selectMedicareType(typeOfMedicare,partA,partB); return false;"><bean-el:message key="button.apply"/></html-el:submit></td>
                                    <td><img alt=""  src="../images/buttonEndRight.gif" border="0"/></td>
                                </tr>
                              </table>
                            </td>
                        </tr>
                    </table>
                </td>
              </tr>
            </table>
          </td>
        </tr>

        <%-- Medicare Part A --%>
        <tr>
          <td>
            <table id=partA width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableBody" role="presentation">
              <tr>
                <td colspan="2" style="padding: 10 0 7 0">
                  <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellLowTableHead" role="presentation">
                    <tr>
                      <td class="moduleBrownBox"><img alt=""  src="../images/spacer.gif" width="29" height="1"/></td>
                      <td style="padding: 7 7" nowrap><bean-el:message key="label.ins.medicarePartA"/></td>
                      <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
                    </tr>
                  </table>
                </td>
              </tr>
              <tr>
                <td width="45%" class="moduleLabel"><html-el:hidden property="insuranceId" /></td>
                <td width="55%" class="moduleValue"></td>
              </tr>
              <tr>
                <td class="moduleLabel"><fw:label required="true" property="medicareClaimNbr" forId="medicareClaimNbrTxt"><bean-el:message key="label.ins.medicare.claimnbr" />:</fw:label></td>
                <c:set var="claimnbrText"><bean-el:message key="label.required" />,&nbsp;<bean-el:message key="label.ins.medicare.claimnbr"/></c:set>
                <td class="moduleValue"><html-el:text title="${claimnbrText}" styleClass="moduleEdit" property="medicareClaimNbr" styleId="medicareClaimNbrTxt" size="40" maxlength="25"/></td>
              </tr>
              <tr>
                <td class="moduleLabel"><fw:label required="true" property="nameOnMedicareCard" forId="nameOnMedicareCardTxt"><bean-el:message key="label.ins.medicare.nameoncard" />:</fw:label></td>
                <c:set var="nameoncardText"><bean-el:message key="label.required" />,&nbsp;<bean-el:message key="label.ins.medicare.nameoncard"/></c:set>
                <td class="moduleValue"><html-el:text title="${nameoncardText}" styleClass="moduleEdit" property="nameOnMedicareCard" styleId="nameOnMedicareCardTxt" size="40" maxlength="35"/></td>
              </tr>
              <tr>
                <td class="moduleLabel"><fw:label property="groupName" forId="medGroupNameTxt"><bean-el:message key="label.ins.groupname" />:</fw:label></td>
                <c:set var="groupnameText"><bean-el:message key="label.ins.groupname"/></c:set>
                <td class="moduleValue"><html-el:text title="${groupnameText}" styleClass="moduleEdit" property="groupName" styleId="medGroupNameTxt" size="25" maxlength="20" readonly="true"/></td>
              </tr>
              <tr>
                <td class="moduleLabel"><fw:label property="groupNumber" forId="medGroupNumberTxt"><bean-el:message key="label.ins.groupnumber" />:</fw:label></td>
                <c:set var="groupnumberText"><bean-el:message key="label.ins.groupnumber"/></c:set>
                <td class="moduleValue"><html-el:text title="${groupnumberText}" styleClass="moduleEdit" property="groupNumber" styleId="medGroupNumberTxt" size="25" maxlength="17" readonly="true"/></td>
              </tr>
              <tr>
                <td class="moduleLabel"><fw:label property="partAEffectiveDate" forId="medPartAEffectiveDateTxt"><bean-el:message key="label.ins.medicare.partaeffectivedate" />:</fw:label></td>
                <c:set var="partaeffectivedateText"><bean-el:message key="label.ins.medicare.partaeffectivedate"/></c:set>
                <td class="moduleValue"><html-el:text title="${partaeffectivedateText}" styleClass="moduleEdit" property="partAEffectiveDate" styleId="medPartAEffectiveDateTxt" size="25" maxlength="25"/></td>
              </tr>
              <tr>
                <td colspan="2"><%@ include file="/tiles/common/addressForm.jsp" %></td>
              </tr>
              <tr>
                <td class="moduleLabel"><fw:label property="phone" forId="carrierPhoneTxt"><bean-el:message key="label.ins.carrierphone" />:</fw:label></td>
                <c:set var="carrierphoneText"><bean-el:message key="label.ins.carrierphone"/></c:set>
                <td class="moduleValue"> <html-el:text title="${carrierphoneText}" styleClass="moduleEdit" property="phone" styleId="carrierPhoneTxt" size="25" maxlength="20" onkeypress="return validatePhone(event)" onchange="formatPhoneNumber(this)"/></td>
              </tr>
              <tr>
                <td class="moduleLabel"><fw:label property="fax" forId="carrierFaxTxt"><bean-el:message key="label.ins.carrierfax" />:</fw:label></td>
                <c:set var="carrierfaxText"><bean-el:message key="label.ins.carrierfax"/></c:set>
                <td class="moduleValue"> <html-el:text title="${carrierfaxText}" styleClass="moduleEdit" property="fax" styleId="carrierFaxTxt" size="25" maxlength="20" onkeypress="return validatePhone(event)" onchange="formatPhoneNumber(this)"/></td>
              </tr>
              <tr>
                <td class="moduleLabel"><fw:label property="sourceOfUpdate" forId="medSourceOfUpdateTxt"><bean-el:message key="label.ins.sourceoflastupdate" />:</fw:label></td>
                <td class="moduleValue">
                <c:set var="sourceoflastupdateText"><bean-el:message key="label.ins.sourceoflastupdate"/></c:set>
                <html-el:select title="${sourceoflastupdateText}" styleClass="darkValue" property="sourceOfUpdate" styleId="medSourceOfUpdateTxt">
                  <html-el:option value=""><bean-el:message key="label.select" /></html-el:option>
                  <esrcore:options collection="gov.va.med.esr.common.model.lookup.InsuranceReportSource" property="code" labelProperty="description"/>
                </html-el:select>
                </td>
              </tr>
              <tr>
                <td class="moduleLabel">&nbsp;</td>
                <td class="moduleValue">&nbsp;</td>
              </tr>
            </table>
          </td>
        </tr>

        <c:choose>
        <c:when test="${insuranceMedicareForm.typeOfMedicare== 'Part A'}">
          <c:set var="partBStyle" value="display:none" />
        </c:when>
        <c:otherwise>
          <c:set var="partBStyle" value="display:block" />
        </c:otherwise>
        </c:choose>

        <%-- Medicare Part B --%>
        <tr id=partB style="<c:out value="${partBStyle}"/>">
          <td>
            <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableBody" role="presentation">
              <tr>
                <td colspan="2" style="padding: 10 0 7 0">
                  <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellLowTableHead" role="presentation">
                    <tr>
                      <td class="moduleBrownBox"><img alt=""  src="../images/spacer.gif" width="29" height="1"/></td>
                      <td style="padding: 7 7" nowrap><bean-el:message key="label.ins.medicarePartB"/></td>
                      <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
                      <td width="50%"><img alt=""  src="../images/spacer.gif"/></td>
                      <td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
                      <td><html-el:submit property="methodName" style="width:110; vertical-align: top;" styleClass="buttonText"><bean-el:message key="button.copyPartAData"/></html-el:submit></td>
                      <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
                      <td width="50%" style="padding:0 5 0 0"><img alt=""  src="../images/spacer.gif"/></td>
                    </tr>
                  </table>
                </td>
              </tr>
              <tr>
                <td width="45%" class="moduleLabel"><html-el:hidden property="partBInsuranceId" /></td>
                <td width="55%" class="moduleValue"></td>
              </tr>
              <tr>
                <td class="moduleLabel"><fw:label required="true" property="partBMedicareClaimNbr" forId="partBMedicareClaimNbrTxt"><bean-el:message key="label.ins.medicare.claimnbr" />:</fw:label></td>
                <td class="moduleValue"><html-el:text title="${claimnbrText}" styleClass="moduleEdit" property="partBMedicareClaimNbr" styleId="partBMedicareClaimNbrTxt" size="40" maxlength="25"/></td>
              </tr>
              <tr>
                <td class="moduleLabel"><fw:label required="true" property="partBNameOnMedicareCard" forId="partBNameOnMedicareCardTxt"><bean-el:message key="label.ins.medicare.nameoncard" />:</fw:label></td>
                <td class="moduleValue"><html-el:text title="${nameoncardText}" styleClass="moduleEdit" property="partBNameOnMedicareCard" styleId="partBNameOnMedicareCardTxt" size="40" maxlength="35"/></td>
              </tr>
              <tr>
                <td class="moduleLabel"><fw:label property="partBGroupName" forId="partBGroupNameTxt"><bean-el:message key="label.ins.groupname" />:</fw:label></td>
                <td class="moduleValue"><html-el:text title="${groupnameText}" styleClass="moduleEdit" property="partBGroupName" styleId="partBGroupNameTxt" size="25" maxlength="20" readonly="true"/></td>
              </tr>
              <tr>
                <td class="moduleLabel"><fw:label property="partBGroupNumber" forId="partBGroupNumberTxt"><bean-el:message key="label.ins.groupnumber" />:</fw:label></td>
                <td class="moduleValue"><html-el:text title="${groupnumberText}" styleClass="moduleEdit" property="partBGroupNumber" styleId="partBGroupNumberTxt" size="25" maxlength="17" readonly="true"/></td>
              </tr>
              <tr>
                <td class="moduleLabel"><fw:label property="partBEffectiveDate" forId="partBEffectiveDateTxt"><bean-el:message key="label.ins.medicare.partbeffectivedate" />:</fw:label></td>
                <c:set var="partbeffectivedateText"><bean-el:message key="label.ins.medicare.partbeffectivedate"/></c:set>
                <td class="moduleValue"><html-el:text title="${partbeffectivedateText}" styleClass="moduleEdit" property="partBEffectiveDate" styleId="partBEffectiveDateTxt" size="25" maxlength="25"/></td>
              </tr>
              <tr>
                <td colspan="2">
                  <%-- 2nd address begin --%>
                  <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableBody" role="presentation">
                    <html-el:hidden styleId="countrySelection2" property="country2" value="${countryUsaConstant}"/>
                    <tr>
                      <td width="45%" class="moduleLabel"><fw:label property="addressLine12" forId="addressLine12Txt"><bean-el:message key="label.addresses.addressLine1" />:</fw:label></td>
                      <td width="55%" class="moduleValue">
                        <c:set var="addressLine1Text"><bean-el:message key="label.addresses.addressLine1"/></c:set>
                        <html-el:text onblur="toUpperCase(this)" title="${addressLine1Text}" property="addressLine12" styleClass="moduleEdit" styleId="addressLine12Txt" size="40" maxlength="35"/>
                      </td>
                    </tr>
                    <tr>
                      <td class="moduleLabel"><fw:label property="addressLine22" forId="addressLine22Txt"><bean-el:message key="label.addresses.addressLine2" />:</fw:label></td>
                      <td class="moduleValue">
                        <c:set var="addressLine2Text"><bean-el:message key="label.addresses.addressLine2"/></c:set>
                        <html-el:text onblur="toUpperCase(this)" title="${addressLine2Text}" property="addressLine22" styleClass="moduleEdit" styleId="addressLine22Txt" size="40" maxlength="30"/>
                      </td>
                    </tr>
                    <tr>
                      <td class="moduleLabel"><fw:label property="addressLine32" forId="addressLine32Txt"><bean-el:message key="label.addresses.addressLine3" />:</fw:label></td>
                      <td class="moduleValue">
                        <c:set var="addressLine3Text"><bean-el:message key="label.addresses.addressLine3"/></c:set>
                        <html-el:text onblur="toUpperCase(this)" title="${addressLine3Text}" property="addressLine32" styleClass="moduleEdit" styleId="addressLine32Txt" size="40" maxlength="30"/>
                      </td>
                    </tr>
                    <tr>
                      <td class="moduleLabel"><fw:label property="zipCode2,zipPlus42" forId="zipCode2Txt"><bean-el:message key="label.addresses.zipCode" />:</fw:label></td>
                      <td id="zipCodeEdit2" class="moduleValue">
                      	<fw:label property="zipCode2,zipPlus42" forId="zipPlus42Txt"><span style="display:none">zipPlus42</span></fw:label>
                        <c:set var="zipCodeBaseText"><bean-el:message key="label.addresses.zipCode"/> (<bean-el:message key="label.addresses.zipCodeBase"/>)</c:set>
                        <c:set var="zipCodeExtensionText"><bean-el:message key="label.addresses.zipCode"/> (<bean-el:message key="label.addresses.zipCodeExtension"/>)</c:set>
                        <html-el:text title="${zipCodeBaseText}" property="zipCode2" styleId="zipCode2Txt" style="width: 257px;" onblur="toUpperCase(this); hideZipCodeSuggestionBoxLeaveSelections(idSuggestionBox2)" onkeypress="return lookupCityStateKeyPress2(this)" onkeyup="lookupCityStateKeyUp2(this)" styleClass="moduleEdit" size="6" maxlength="5" /> - <html-el:text onblur="toUpperCase(this)" title="${zipCodeExtensionText}" property="zipPlus42" styleId="zipPlus42Txt" styleClass="moduleEdit" size="5" maxlength="4" />
                        <br>
                        <select size="10" id="idSuggestionBox2" name="suggestionBox2" style="border: 0px; display: none; position:absolute;" onclick="updateCityState(this, city2, county2, state2);" onblur="this.style.display = 'none';"></select>
                        <html-el:hidden property="prevZip2" />
                      </td>
                    </tr>
                    <tr>
                      <td class="moduleLabel"><fw:label property="city2" forId="idCity2"><bean-el:message key="label.addresses.city" />:</fw:label></td>
                      <td  id="cityEdit2" class="moduleValue">
                        <c:set var="cityText"><bean-el:message key="label.addresses.city"/></c:set>
                        <html-el:text onblur="toUpperCase(this)" title="${cityText}" property="city2" styleId="idCity2" styleClass="moduleEdit" size="40" maxlength="15"/>
                      </td>
                    </tr>
                    <tr>
                      <td  class="moduleLabel"><fw:label property="state2" forId="idState2"><bean-el:message key="label.addresses.state" />:</fw:label></td>
                      <td  id="stateEdit2" class="moduleValue">
                        <c:set var="stateText"><bean-el:message key="label.addresses.state"/></c:set>
                        <html-el:text onblur="toUpperCase(this)" title="${stateText}" styleClass="moduleEdit" styleId="idState2" property="state2" size="40" maxlength="40" />
                      </td>
                    </tr>
                    <tr>
                      <td  class="moduleLabel"><fw:label property="county2" forId="idCounty2"><bean-el:message key="label.addresses.county" />:</fw:label></td>
                      <td  id="countyEdit2" class="moduleValue">
                        <c:set var="countyText"><bean-el:message key="label.addresses.county"/></c:set>
                        <html-el:text onblur="toUpperCase(this)" title="${countyText}" property="county2" styleClass="moduleEdit" styleId="idCounty2" size="40" maxlength="50"/>
                      </td>
                    </tr>
                    <tr>
                      <td style="display:none" class="moduleLabel"><fw:label property="province2" forId="idProvince2"><bean-el:message key="label.addresses.province" />:</fw:label></td>
                      <td style="display:none" class="moduleValue">
                        <c:set var="provinceText"><bean-el:message key="label.addresses.province"/></c:set>
                        <html-el:text onblur="toUpperCase(this)" title="${provinceText}" property="province2" styleClass="moduleEdit" styleId="idProvince2" size="40" maxlength="20"/>
                      </td>
                    </tr>
                    <tr>
                      <td style="display:none" class="moduleLabel"><fw:label property="postalCode2" forId="idPostalCode2"><bean-el:message key="label.addresses.postalCode" />:</fw:label></td>
                      <td style="display:none" class="moduleValue">
                        <c:set var="postalCodeText"><bean-el:message key="label.addresses.postalCode"/></c:set>
                        <html-el:text onblur="toUpperCase(this)" title="${postalCodeText}" property="postalCode2" styleClass="moduleEdit" styleId="idPostalCode2" size="40" maxlength="10"/>
                      </td>
                    </tr>
                  </table>
                  <%-- 2nd address end --%>
                </td>
              </tr>
              <tr>
                <td class="moduleLabel"><fw:label property="partBPhone" forId="idPartBPhone"><bean-el:message key="label.ins.carrierphone" />:</fw:label></td>
                <td class="moduleValue"> <html-el:text title="${carrierphoneText}" styleClass="moduleEdit" property="partBPhone" styleId="idPartBPhone" size="25" maxlength="20" onkeypress="return validatePhone(event)" onchange="formatPhoneNumber(this)"/></td>
              </tr>
              <tr>
                <td class="moduleLabel"><fw:label property="partBFax" forId="idPartBFax"><bean-el:message key="label.ins.carrierfax" />:</fw:label></td>
                <td class="moduleValue"> <html-el:text title="${carrierfaxText}" styleClass="moduleEdit" property="partBFax" styleId="idPartBFax" size="25" maxlength="20" onkeypress="return validatePhone(event)" onchange="formatPhoneNumber(this)"/></td>
              </tr>
              <tr>
                <td class="moduleLabel"><fw:label property="partBSourceOfUpdate" forId="idPartBSourceOfUpdate"><bean-el:message key="label.ins.sourceoflastupdate" />:</fw:label></td>
                <td class="moduleValue">
                <html-el:select title="${sourceoflastupdateText}" styleClass="darkValue" property="partBSourceOfUpdate" styleId="idPartBSourceOfUpdate">
                  <html-el:option value=""><bean-el:message key="label.select" /></html-el:option>
                  <esrcore:options collection="gov.va.med.esr.common.model.lookup.InsuranceReportSource" property="code" labelProperty="description"/>
                </html-el:select>
                </td>
              </tr>
              <tr><td>&nbsp;</td></tr>
            </table>
          </td>
        </tr>
        <tr>
          <td class="moduleShellTableBody">
            <table width="100%" border="0" align="center" cellspacing="0" cellpadding="0" role="presentation">
              <tr>
                <td width="45%"><img alt=""  src="../images/spacer.gif"/></td>
                <td><img alt=""  src="../images/buttonEndLeft.gif" /></td>
                <td><html-el:submit property="methodName" style="width:50; vertical-align: top;" styleClass="buttonText"><bean-el:message key="button.update"/></html-el:submit></td>
                <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
                <td width="1%"><img alt=""  src="../images/spacer.gif"/></td>
                <td><img alt=""  src="../images/buttonEndLeft.gif" /></td>
                <td><html-el:submit property="methodName" style="width:50; vertical-align: top;" styleClass="buttonText"><bean-el:message key="button.delete"/></html-el:submit></td>
                <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
                <td width="1%"><img alt=""  src="../images/spacer.gif"/></td>
                <td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
                <td><html-el:submit property="methodName" style="width:50; vertical-align: top;" styleClass="buttonText"><bean-el:message key="button.cancel"/></html-el:submit></td>
                <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
                <td width="45%"><img alt=""  src="../images/spacer.gif"/></td>
              </tr>
            </table>
            <br>
          </td>
        </tr>
      </table>
    </td>
  </tr>
</html-el:form>
</table>
