<script language="JavaScript" src="../scripts/ESR-Script.js"></script>
<%@ taglib uri="/tags/esr-core" prefix="esrcore" %>
<%@ taglib uri="/tags/fw" prefix="fw" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="/tags/struts-html" prefix="html" %>
<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/valuelist" prefix="vlh" %>
<%@ page import="java.util.ArrayList"%>
<%@ page import="gov.va.med.esr.ui.comms.action.UndeliverableMailBarcodeScanningAction"%>
<%@ page import="gov.va.med.esr.ui.util.NameHelper"%>
<%@ page import="gov.va.med.fw.ui.valuelist.SelectableResult"%>
<%@ page import="gov.va.med.esr.common.model.comms.UndeliverableMailInfo"%>

<c:set var="search" scope="page"><bean-el:message key="button.search"/></c:set>
<c:set var="resultsSize"><%= ((ArrayList)session.getAttribute(UndeliverableMailBarcodeScanningAction.SCANNED_RESULTS_SESSION_KEY)).size() %></c:set>
<c:set var="find" scope="page"><bean-el:message key="button.find"/></c:set>
<c:set var="contextPath" scope="page"><%=request.getContextPath()%></c:set>
<c:set var="barcodeText" scope="page"><bean-el:message key="label.comms.barcode"/></c:set>

<script language="javascript">

// Perform all page initialization
function onLoadInit()
{
}

// Displays a confirmation message for the Update button
function mailConfirmMessage()
{
    return confirmMessage('<bean-el:message key="message.comms.confirmUpdateStatus"/>');
}

// Key press processing for the barcode entry field
function processBarCodeSearchKeyPress()
{
    var fieldSource = window.event.srcElement;
    var keyCode = window.event.keyCode;

    // Enter key
    if (keyCode == 13)
    {
        submitForm(undeliverableMailBarcodeScanningForm, 'methodNameId', '<c:out value="${search}"/>');
        return false;
    }

    // Return true so the last key typed actually gets processed
    return true;
}

</script>

<table width="100%" border="1" cellpadding="0" cellspacing="0" class="moduleShell">
<html-el:form action="/undeliverableMailBarcodeScanning" method="post">
  <%@ include file="/admin/csrfgentoken.jsp" %>
<tr>
  <td>
    <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTable">
      <tr>
        <td>
          <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead">
            <tr>
              <td class="moduleBlueBox"><img alt=""  src="../images/spacer.gif" width="28" height="23"/></td>
              <td nowrap style="padding-left: 7"><bean-el:message key="label.comms.undeliverableMailBarcodeScanning"/></td>
              <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
            </tr>
          </table>
        </td>
      </tr>
 <tr>
              <td style="text-align:left; padding: 7 0 7 5" class="label" nowrap>
                <fw:label property="barcode" forId="txtBarcodeID"><span style="">Barcode Search:</span></fw:label>
        		<html-el:text title="${barcodeText}" styleId="txtBarcodeID" styleClass="moduleEdit initfocus" property="barcode" size="17" maxlength="40" onkeypress="return processBarCodeSearchKeyPress()" />&nbsp;
                <a style="vertical-align: middle" href="javascript:submitForm(undeliverableMailBarcodeScanningForm, 'methodNameId', '<c:out value="${search}"/>');"><html-el:img alt="${find}" border="0" src="${contextPath}/images/magnifyingGlass.gif" width="15" height="15"/></a>
              </td>
              
            </tr>

      <tr>
        <td>
          <table summary="Scan or Enter Bar Code to Search Undeliverable Mails" width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody">
            <thead>
            <tr>
              <th scope="col" style="text-align:left; padding: 7 0 7 5" class="darkLabel"><u><bean-el:message key="label.comms.barcode"/></u></th>
              <th scope="col" style="text-align:left; padding: 7 0 7 5" class="darkLabel"><u><bean-el:message key="label.comms.dateMailed"/></u></th>
              <th scope="col" style="text-align:left; padding: 7 0 7 5" class="darkLabel"><u><bean-el:message key="label.comms.recipientNameAndAddress"/></u></th>
              <th scope="col" style="text-align:left; padding: 7 0 7 5" class="darkLabel"><u><bean-el:message key="label.comms.formNumber"/></u></th>
              <th scope="col" style="text-align:left; padding: 7 0 7 5" class="darkLabel"><u><bean-el:message key="label.comms.returnedByPO"/></u></th>
              <th scope="col" style="text-align:left; padding: 7 0 7 5" class="darkLabel"><u><bean-el:message key="button.editAddress"/></u></th>
            </tr>
            </thead>

            <tbody>
           
            <c:set var="rowColor" value="value" />
            <c:forEach var="selectableResult" items="${undeliverableMailScannedResultsSessionKey}" varStatus="status">
            <c:set var="counter" value="${status.count - 1}" />

            <c:choose>
              <c:when test="${rowColor == 'darkValue'}">
                <c:set var="rowColor" value="value" />
              </c:when>
            <c:otherwise>
              <c:set var="rowColor" value="darkValue" />
            </c:otherwise>
            </c:choose>

            <tr>
              <td scope="row" valign="top" class="<c:out value="${rowColor}"/>" nowrap>
                <esrcore:displayValue name="selectableResult" property="result.commsLogEntry.barcode"/>
              </td>
              <td valign="top" class="<c:out value="${rowColor}"/>" nowrap>
                <esrcore:displayDate name="selectableResult" dateProperty="result.commsLogEntry.mailingDate" displayTime="false"/>
              </td>
              <td valign="top" class="<c:out value="${rowColor}"/>" nowrap>
                <c:if test="${selectableResult.result.commsLogEntry.name != null}">
                  <%= NameHelper.formatNameFirstNameFirst(((UndeliverableMailInfo)((SelectableResult)pageContext.getAttribute("selectableResult")).getResult()).getCommsLogEntry().getName())%>
                </c:if>
                <c:if test="${selectableResult.result.commsLogEntry.name != null && selectableResult.result.commsLogEntry.address != null}">
                  <br>
                </c:if>
                <c:if test="${selectableResult.result.commsLogEntry.address != null}">
                  <esrcore:displayValue name="selectableResult" property="result.commsLogEntry.address" nullText=""/>
                </c:if>
              </td>
              <td valign="top" class="<c:out value="${rowColor}"/>" nowrap>
                <esrcore:displayValue name="selectableResult" property="result.commsLogEntry.template.commsTemplateFormNumber"/> - <esrcore:displayValue name="selectableResult" property="result.commsLogEntry.template.commsTemplateName" nullText=""/>
              </td>
              <td valign="top" class="<c:out value="${rowColor}"/>" nowrap>
                <input type="checkbox" title="Select" name="selected" value="<c:out value="${counter}"/>" <c:out value="${selected[counter]}"/>>
              </td>
              <td valign="top" class="<c:out value="${rowColor}"/>" nowrap>
                <c:choose>
                <c:when test="${selectableResult.result.updatedAddress == null}">
                  <a href="/esr/comms/undeliverableMailEditPermAddressFromScan.do?methodName=DISPLAY&amp;selectedPersonId=<c:out value="${selectableResult.result.commsLogEntry.personId}"/>"><bean-el:message key="button.editAddress"/></a>
                </c:when>
                <c:otherwise>
                  &nbsp;
                </c:otherwise>
                </c:choose>
              </td>
            </tr>
            </c:forEach>
            </tbody>

            <%-- Button Row --%>
            <c:if test="${resultsSize > 0}">
            <tr>
              <td colspan="6" height="50">
                <table width="100%" border="0" cellpadding="0" cellspacing="0">
                  <tr>
                    <td width="45%"><img alt=""  src="../images/spacer.gif"/></td>
                    <td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
                    <td><html-el:submit property="methodName" style="width:50; vertical-align: top;" styleClass="buttonText" onclick="return(mailConfirmMessage())"><bean-el:message key="button.update"/></html-el:submit></td>
                    <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
                    <td width="1%"><img alt=""  src="../images/spacer.gif"/></td>
                    <td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
                    <td><html-el:submit property="methodName" style="width:50; vertical-align: top;" styleClass="buttonText"><bean-el:message key="button.clear"/></html-el:submit></td>
                    <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
                    <td width="45%"><img alt=""  src="../images/spacer.gif"/></td>
                  </tr>
                </table>
              </td>
            </tr>
            </c:if>

            <%--
              Keep this hidden field below the buttons.  Otherwise, a blank will be submitted for
              methodName before the button's methodName which will cause the button lookup to
              fail.
            --%>
            <input id="methodNameId" type="hidden" name="methodName" value="">
          </table>
        </td>
      </tr>
    </table>
  </td>
</tr>
</html-el:form>
</table>
