<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el"%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="/tags/esr-core" prefix="esrcore"%>
<%@ taglib uri="/tags/fw" prefix="fw"%>
<%@ taglib uri="/tags/authz" prefix="auth" %>
<%@ page import='gov.va.med.esr.common.model.lookup.Capability' %>

<auth:authorize ifAnyGranted="<%=Capability.EDIT_CCN_CONTRACTORS.getName()%>">
    <c:set var="editCcnContractors" value="true"/>
</auth:authorize>

<table width="100%" border="0" cellpadding="0" cellspacing="0"
	class="moduleShell">
	<html-el:form action="/manageCcnContractors.do" method="post">
		<%@ include file="/admin/csrfgentoken.jsp"%>
		<tr>
			<td>
				<table width="100%" border="0" cellpadding="0" cellspacing="0"
					class="moduleShellTable">
					<tr>
						<td>
							<table width="100%" border="0" cellpadding="0" cellspacing="0"
								class="moduleShellTableHead">
								<tr>
									<td class="moduleBlueBox"><img width="25" height="17" alt="" src="../images/spacer.gif" /></td>
									<td class="moduleHeadline" nowrap><bean-el:message
											key="label.ccnContractor.mainHeader" /></td>
									<td width="100%"></td>
									<td nowrap class="moduleBlueLink" style="padding: 1 8 1 8">
										<c:if test="${editCcnContractors == true}">  
											<fw:link action="/manageCcnContractors.do?methodName=displayCcnRegionStates"
												module="/admin">
												 <bean-el:message
													key="label.ccnContractor.manageStatesRegions" />
											</fw:link>
										</c:if>
									</td>
									<td><img alt=""  src="../images/spacer.gif" width="5"/></td>																		
									<td nowrap class="moduleBlueLink" style="padding: 1 8 1 8">
                                    <c:if test="${editCcnContractors == true}">    
                                            									
										<fw:link action="/manageCcnContractors.do?methodName=DISPLAY ADD"
											module="/admin">
											<bean-el:message
												key="label.ccnContractor.addNew" />
										</fw:link>

                                    </c:if>										
									</td>
								</tr>
							</table>
						</td>
					</tr>
					<tr>
					<td>
						<table width="100%" border="0" cellspacing="0" cellpadding="0"
							class="moduleShellTableBody">
							<c:set var="rowColor" value="darkValue" />

							<tr>
								<td class="value"  width="100%">
									<table  width="100%" summary="Table for Managing Batch Processes">
										<thead>
											<tr>
												<th scope="col" style="width:40%;text-align: left; padding: 7 0 7 5"
													class="darkLabel"><bean-el:message key="label.name" /></th>
												<th scope="col" style="width:15%;text-align: left; padding: 7 0 7 5"
													class="darkLabel"><bean-el:message
														key="label.ccnContractor.startDate" /></th>
												<th scope="col" style="width:15%;text-align: left; padding: 7 0 7 5"
													class="darkLabel"><bean-el:message
														key="label.ccnContractor.endDate" /></th>
												<th scope="col" style="width:30%;text-align: left; padding: 7 0 7 5"
													class="darkLabel"><bean-el:message
														key="label.ccnContractor.region" /></th>
											</tr>
										</thead>

										<c:if test="${not empty ContractorSet}">
											<tbody>
											<c:set var="rowColor" value="darkValue" />
												<c:forEach var="contractor" items="${ContractorSet}">
																				<c:choose>
									<c:when test="${rowColor == 'darkValue'}">
										<c:set var="rowColor" value="value" />
									</c:when>
									<c:otherwise>
										<c:set var="rowColor" value="darkValue" />
									</c:otherwise>
								</c:choose>
				
													<tr>
														<td class="<c:out value='${rowColor}'/>">
														<fw:link action="/manageCcnContractors?methodName=DISPLAY UPDATE&key=${contractor.key}" >
																 ${contractor.contractorName}
															</fw:link>
														</td>
														<td  class="<c:out value='${rowColor}'/>">${contractor.startDate}</td>
														<td  class="<c:out value='${rowColor}'/>">${contractor.endDate}</td>
														<td  class="<c:out value='${rowColor}'/>">${contractor.regions}</td>
													</tr>
												</c:forEach>
											</tbody>
										</c:if>
									</table>
								</td>
							</tr>

							<tr>
								<td>&nbsp;</td>
							</tr>
						</table>
					</td>
					</tr>
				</table>
			</td>
		</tr>
	</html-el:form>
</table>
