 <%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/esr-core" prefix="esrcore" %>
<%@ taglib uri="/tags/fw" prefix="fw" %>
<%@ page import='gov.va.med.esr.common.model.lookup.Country' %>

<c:set var="countryUsaConstant"><%= Country.CODE_USA.getName() %></c:set>
<c:set var="zipCodeLookup" value="true"/>
<c:set var="countryEditable" value="true"/>

<script>
// Update the appropriate address fields based on a country selection change.
function updateCountryFields()
{
    // Find the country selection field
    countrySelectionField = searchForFieldByFieldName("countrySelection");

    // If we found the field, enable/disable the appropriate fields
    if (countrySelectionField)
    {
        if ((countrySelectionField.value == '<c:out value="${countryUsaConstant}"/>') ||
            (countrySelectionField.value == '') ||
            (countrySelectionField.value == null))
        {
            // Enable United States Fields
            zipCodeLabel.style.display = "block";
            zipCodeEdit.style.display = "block";
            stateLabel.style.display = "block";
            stateEdit.style.display = "block";
            //countyLabel.style.display = "block";
            //countyEdit.style.display = "block";
            provinceLabel.style.display = "none";
            provinceEdit.style.display = "none";
            postalCodeLabel.style.display = "none";
            postalCodeEdit.style.display = "none";
        }
        else
        {
            // Enable International Fields
            zipCodeLabel.style.display = "none";
            zipCodeEdit.style.display = "none";
            stateLabel.style.display = "none";
            stateEdit.style.display = "none";
            //countyLabel.style.display = "none";
            //countyEdit.style.display = "none";
            provinceLabel.style.display = "block";
            provinceEdit.style.display = "block";
            postalCodeLabel.style.display = "block";
            postalCodeEdit.style.display = "block";
        }
    }
}
</script>

<table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableBody" role="presentation">

<c:choose>
<c:when test="${displayRequiredFieldsIndicator}">
<c:set var="requiredFlag"><%= Boolean.TRUE.toString() %></c:set>
<c:set var="requiredText"><bean-el:message key="label.required"/>,&nbsp;</c:set>
</c:when>
<c:otherwise>
<c:set var="requiredFlag"><%= Boolean.FALSE.toString() %></c:set>
<c:set var="requiredText"></c:set>
</c:otherwise>
</c:choose>

<c:choose>
<c:when test="${countryEditable}">
  <tr>
    <td class="moduleLabel"><fw:label required="${requiredFlag}" property="country" forId="countrySelection"><bean-el:message key="label.addresses.country" />:</fw:label></td>
    <td class="moduleValue">
       <c:set var="countryText"><bean-el:message key="label.addresses.country"/></c:set>
       <html-el:select title="${requiredText}${countryText}" styleId="countrySelection" onchange="updateCountryFields()" styleClass="moduleEdit" 
       		property="country" tabindex="21" disabled= "${isAddAPersonButton}">
            <html-el:option value=""><bean-el:message key="label.select" /></html-el:option>
         <esrcore:options collection="gov.va.med.esr.common.model.lookup.Country" property="code" labelProperty="description"/>
       </html-el:select>
    </td>
  </tr>
</c:when>
<c:otherwise>
  <html-el:hidden styleId="countrySelection" property="country"/>
</c:otherwise>
</c:choose>


<tr>
	<td width="45%" class="moduleLabel" id="addressLineLabel"><fw:label forId="txtAddressLine" required="${requiredFlag}" property="addressLine"><bean-el:message 
		key="label.addresses.addressLine" />:</fw:label></td>
	<td width="55%" class="moduleValue" id="addressLineEdit">
		<c:set var="line1Text"><bean-el:message key="label.addresses.addressLine"/></c:set>
		<html-el:text onblur="toUpperCase(this)" title="${requiredText}${line1Text}" property="addressLine1" 
			styleId="txtAddressLine" styleClass="moduleEdit" size="40" maxlength="35" tabindex="22" disabled= "${isAddAPersonButton}"/>
		</td>
</tr>




<tr>
	<td style="display:none" id="zipCodeLabel" class="moduleLabel"><fw:label required="${requiredFlag}" property="zipCode,zipPlus4" forId="txtZipCode">
		<bean-el:message key="label.addresses.zipCode" />:</fw:label>
		<fw:label required="${requiredFlag}" property="zipPlus4" forId="txtZipPlus4"><span style="display:none">zipPlus4</span></fw:label>
	</td>
	<td style="display:none" id="zipCodeEdit" class="moduleValue">
        <c:set var="zipCodeBaseText"><bean-el:message key="label.addresses.zipCode"/> (<bean-el:message key="label.addresses.zipCodeBase"/>)</c:set>
        <c:set var="zipCodeExtensionText"><bean-el:message key="label.addresses.zipCode"/> (<bean-el:message key="label.addresses.zipCodeExtension"/>)</c:set>
        <c:choose>
        <c:when test="${zipCodeLookup}">
            <html-el:text property="zipCode" style="width: 257px;" styleId="txtZipCode" tabindex="24" onblur="toUpperCase(this);"  
            onkeypress="return lookupCityStateKeyPress(this)" onkeyup="lookupCityStateKeyUp(this)" styleClass="moduleEdit" size="6" title="${requiredText}${zipCodeBaseText}" disabled= "${isAddAPersonButton}"/> - <html-el:text onblur="toUpperCase(this)" 
            	property="zipPlus4" styleId="txtZipPlus4" styleClass="moduleEdit" size="5" maxlength="4" title="${zipCodeExtensionText}" tabindex="25" disabled= "${isAddAPersonButton}"/>
        </c:when>
        <c:otherwise>
            <html-el:text onblur="toUpperCase(this)" property="zipCode" styleId="txtZipCode" style="width: 257px;" styleClass="moduleEdit" size="6" 
            	readonly="${readOnlyAddress}" title="${requiredText}${zipCodeBaseText}" tabindex="24" disabled= "${isAddAPersonButton}"/> - <html-el:text onblur="toUpperCase(this)" property="zipPlus4" styleId="txtZipPlus4" styleClass="moduleEdit" size="5" maxlength="4" readonly="${readOnlyAddress}" title="${zipCodeExtensionText}"/>
        </c:otherwise>
        </c:choose>
		<br>
		<select size="10" id="idSuggestionBox" name="suggestionBox" style="border: 0px; display: none; position:absolute;" 
			onclick="updateCityState(this, city, county, state);" 
			onblur="this.style.display = 'none';" 
			onmouseout="this.style.display = 'none';"
			>
		</select>
	    <html-el:hidden property="prevZip" />
	</td>
</tr>
<tr>
	<td class="moduleLabel" id="cityLabel"><fw:label required="${requiredFlag}" property="city" forId="idCity"><bean-el:message key="label.addresses.city" />:</fw:label></td>
	<td class="moduleValue" id="cityEdit">
    <c:set var="cityText"><bean-el:message key="label.addresses.city"/></c:set>
		<html-el:text onblur="toUpperCase(this)" title="${requiredText}${cityText}" property="city" styleId="idCity" 
		styleClass="moduleEdit" size="40" maxlength="15" readonly="${readOnlyAddress}" tabindex="26" disabled= "${isAddAPersonButton}"/>
	</td>
</tr>
<tr>
	<td style="display:none" id="stateLabel" class="moduleLabel"><fw:label required="${requiredFlag}" property="state" forId="idState"><bean-el:message key="label.addresses.state" />:</fw:label></td>
	<td style="display:none" id="stateEdit" class="moduleValue">
    <c:set var="stateText"><bean-el:message key="label.addresses.state"/></c:set>
		<html-el:text onblur="toUpperCase(this)" title="${requiredText}${stateText}" styleClass="moduleEdit" 
			styleId="idState" property="state" size="40" maxlength="40" readonly="${readOnlyAddress}" tabindex="27" disabled= "${isAddAPersonButton}"/>
	    <html-el:hidden property="county" />
	</td>
</tr>


<tr>
	<td style="display:none" id="provinceLabel" class="moduleLabel"><fw:label property="province" forId="idProvince"><bean-el:message key="label.addresses.province" />:</fw:label></td>
	<td style="display:none" id="provinceEdit" class="moduleValue">
    <c:set var="provinceText"><bean-el:message key="label.addresses.province"/></c:set>
		<html-el:text onblur="toUpperCase(this)" title="${provinceText}" property="province" styleClass="moduleEdit" 
		styleId="idProvince" size="40" maxlength="20" readonly="${readOnlyAddress}" tabindex="28" disabled= "${isAddAPersonButton}"/>
	</td>
</tr>
<tr>
	<td style="display:none" id="postalCodeLabel" class="moduleLabel"><fw:label property="postalCode" forId="idPostalCode"><bean-el:message key="label.addresses.postalCode" />:</fw:label></td>
	<td style="display:none" id="postalCodeEdit" class="moduleValue">
    <c:set var="postalCodeText"><bean-el:message key="label.addresses.postalCode"/></c:set>
		<html-el:text onblur="toUpperCase(this)" title="${postalCodeText}" property="postalCode" styleClass="moduleEdit" 
			styleId="idPostalCode" size="40" maxlength="10" readonly="${readOnlyAddress}" tabindex="29" disabled= "${isAddAPersonButton}"/>
	</td>
</tr>
</table>
 