<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/fw" prefix="fw" %>
<%@ taglib uri="/tags/esr-core" prefix="esrcore" %>
<%@ taglib uri="/tags/authz" prefix="auth" %>
<%@ page import='gov.va.med.esr.common.model.lookup.Capability' %>

<%-- Alt Text --%>
<c:set var="overviewText" scope="page"><bean-el:message key="menu.overview"/>&nbsp;<bean-el:message key="label.tab"/></c:set>
<c:set var="myItemsText" scope="page"><bean-el:message key="label.myItems"/>&nbsp;<bean-el:message key="label.tab"/></c:set>
<c:set var="assignedItemsText" scope="page"><bean-el:message key="label.assignedItems"/>&nbsp;<bean-el:message key="label.tab"/></c:set>
<c:set var="unassignedItemsText" scope="page"><bean-el:message key="label.unassignedItems"/>&nbsp;<bean-el:message key="label.tab"/></c:set>
<c:set var="searchItemsText" scope="page"><bean-el:message key="label.searchItems"/>&nbsp;<bean-el:message key="label.tab"/></c:set>
<c:set var="openItemsText" scope="page"><bean-el:message key="label.openItems"/>&nbsp;<bean-el:message key="label.tab"/></c:set>
<c:set var="selectedTabText" scope="page"><bean-el:message key="label.selectedTab"/>,&nbsp;</c:set>
<c:set var="SEARCH_WORKLIST_ITEMS"><%=Capability.SEARCH_WORKLIST_ITEMS.getName() %></c:set>
<c:set var="MANAGE_WORKLIST_ITEMS"><%=Capability.MANAGE_WORKLIST%></c:set>

<c:set var="showSearchWorkItemsTab" value="false"/>
<auth:authorize ifAnyGranted="${SEARCH_WORKLIST_ITEMS}">
<c:set var="showSearchWorkItemsTab" value="true"/>
</auth:authorize>
<c:set var="showWorkItemTabs" value="false"/>
<auth:authorize ifAnyGranted="${MANAGE_WORKLIST_ITEMS}">
<c:set var="showWorkItemTabs" value="true"/>
</auth:authorize>

<script type="text/javascript">
function selectSearchType()
{
  return false;
}
</script>

<%-- Search --%>
<c:if test="${showSearchWorkItemsTab}">
<table border="0" cellpadding="0" cellspacing="0">
<html-el:form action="searchWorkflowItems" method="post">
  <%@ include file="/admin/csrfgentoken.jsp" %>
  <html-el:hidden property="searchType" value="SIMPLE"/>
  <tr>
    <td width="80%"><img alt=""  src="/esr/images/spacer.gif"/></td>
    <td nowrap="true" class="moduleLabel"><fw:label property="searchField" forId="searchFieldId"><bean-el:message key="label.searchCriteria"/>:</fw:label></td>
    <td>
      <html-el:select title="Search Field" styleClass="moduleValue" property="searchField" styleId="searchFieldId" onchange="selectSearchType(); return false;">
      <html-el:option value=""><bean-el:message key="label.select" /></html-el:option>
        <esrcore:options collection="gov.va.med.esr.ui.common.beans.WorkflowSearchType" property="code" labelProperty="description"/>
      </html-el:select>
    </td>
    <td nowrap="true" class="moduleLabel"> <fw:label property="searchField" forId="searchValueId"><bean-el:message key="label.searchValue"/>:</fw:label></td>
    <td id="IDSearchValue" class="moduleValue">
         <html-el:text title="Search Value" styleId="searchValueId" property="searchValue" size="30" maxlength="30" />
    </td>
    <td width="1" style="display:none" class="moduleValue"><html-el:text property="emptyHiddenField" size="1" maxlength="40" /></td>
    <td><img alt=""  width="5" src="/esr/images/spacer.gif"/></td>
    <td><img alt=""  src="/esr/images/buttonEndLeft.gif"/></td>
    <td><html-el:submit property="methodName" style="width:50; vertical-align: top;" styleClass="buttonText"><bean-el:message key="button.find"/></html-el:submit></td>
    <td><img alt=""  src="/esr/images/buttonEndRight.gif"/></td>
  </tr>
</html-el:form>
</table>
</c:if>

<%-- Set images for each tab based on it being selected or not. --%>
<c:choose>
<c:when test="${tabName == 'overview'}">
  <c:set var="overviewImage" scope="page">on</c:set>
  <c:set var="overviewText" scope="page" value="${selectedTabText}${overviewText}"/>
</c:when>
<c:otherwise>
  <c:set var="overviewImage" scope="page">off</c:set>
</c:otherwise>
</c:choose>

<c:choose>
<c:when test="${tabName == 'myCases'}">
  <c:set var="myItemsImage" scope="page">on</c:set>
  <c:set var="myItemsText" scope="page" value="${selectedTabText}${myItemsText}"/>
</c:when>
<c:otherwise>
  <c:set var="myItemsImage" scope="page">off</c:set>
</c:otherwise>
</c:choose>

<c:choose>
<c:when test="${tabName == 'assignedCases'}">
  <c:set var="assignedItemsImage" scope="page">on</c:set>
  <c:set var="assignedItemsText" scope="page" value="${selectedTabText}${assignedItemsText}"/>
</c:when>
<c:otherwise>
  <c:set var="assignedItemsImage" scope="page">off</c:set>
</c:otherwise>
</c:choose>

<c:choose>
<c:when test="${tabName == 'unassignedCases'}">
  <c:set var="unassignedItemsImage" scope="page">on</c:set>
  <c:set var="unassignedItemsText" scope="page" value="${selectedTabText}${unassignedItemsText}"/>
</c:when>
<c:otherwise>
  <c:set var="unassignedItemsImage" scope="page">off</c:set>
</c:otherwise>
</c:choose>

<c:choose>
<c:when test="${tabName == 'searchResults'}">
  <c:set var="searchItemsImage" scope="page">on</c:set>
  <c:set var="searchItemsText" scope="page" value="${selectedTabText}${searchItemsText}"/>
</c:when>
<c:otherwise>
  <c:set var="searchItemsImage" scope="page">off</c:set>
</c:otherwise>
</c:choose>

<%-- Note: Open Cases is only displayed when it is the active tab. --%>
<c:choose>
<c:when test="${tabName == 'openCases'}">
  <c:set var="openItemsImage" scope="page">on</c:set>
  <c:set var="openItemsText" scope="page" value="${selectedTabText}${openItemsText}"/>
</c:when>
<c:otherwise>
  <c:set var="openItemsImage" scope="page">off</c:set>
</c:otherwise>
</c:choose>

<%-- Tabs --%>
<table cellSpacing="0" cellPadding="0" border="0">
  <tr valign="bottom">
    <c:if test="${showWorkItemTabs}">
	<td><html-el:link styleId="es-tabs-worklist-overview" styleClass="tabLink" forward="overviewWorkflowItems.display"><html-el:img alt="${overviewText}" src="/esr/images/tabs_overview_${overviewImage}.gif" border="0"/></html-el:link></td>
        <td><html-el:link styleId="es-tabs-worklist-my" styleClass="tabLink" forward="myCases.display"><html-el:img alt="${myItemsText}" src="/esr/images/tabs_myitems_${myItemsImage}.gif" border="0"/></html-el:link></td>
        <td><html-el:link styleId="es-tabs-worklist-assigned" styleClass="tabLink" forward="assignedCases.display"><html-el:img alt="${assignedItemsText}" src="/esr/images/tabs_assigneditems_${assignedItemsImage}.gif" border="0"/></html-el:link></td>
        <td><html-el:link styleId="es-tabs-worklist-unassigned" styleClass="tabLink" forward="unassignedCases.display"><html-el:img alt="${unassignedItemsText}" src="/esr/images/tabs_unassigneditems_${unassignedItemsImage}.gif" border="0"/></html-el:link></td>	
        <c:if test="${showSearchWorkItemsTab}"><td><html-el:link styleId="es-tabs-worklist-search" styleClass="tabLink" forward="searchWorkflowItems.display"><html-el:img alt="${searchItemsText}" src="/esr/images/tabs_searchItems_${searchItemsImage}.gif" border="0"/></html-el:link></td></c:if>
        <c:if test="${tabName == 'openCases'}"><td><html-el:link styleId="es-tabs-worklist-open" styleClass="tabLink" forward="openCases.display"><html-el:img alt="${openItemsText}" src="/esr/images/tabs_open_items_${openItemsImage}.gif" border="0"/></html-el:link></td></c:if>
	</c:if>	
    <td width="100%" style="border-bottom: 1px solid #000000;"><img alt=""  src="../images/spacer.gif" height="1" width="100%"/></td>
  </tr>
</table>
