<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/esr-core" prefix="esrcore" %>
<%@ taglib uri="/tags/fw" prefix="fw" %>
<%@ page import='gov.va.med.esr.common.model.lookup.Country' %>

<c:set var="countryUsaConstant"><%= Country.CODE_USA.getName() %></c:set>
<script>
// Update the appropriate address fields based on a country selection change.
function updateCountryFields()
{
    // Find the country selection field
    countrySelectionField = searchForFieldByFieldName("countrySelection");

    // If we found the field, enable/disable the appropriate fields
    if (countrySelectionField)
    {
        if ((countrySelectionField.value == '<c:out value="${countryUsaConstant}"/>') ||
            (countrySelectionField.value == '') ||
            (countrySelectionField.value == ' ') ||
            (countrySelectionField.value == null))
        {
            // Enable United States Fields
            zipCodeLabel.style.display = "block";
            zipCodeEdit.style.display = "block";
            stateLabel.style.display = "block";
            stateEdit.style.display = "block";
            countyLabel.style.display = "block";
            countyEdit.style.display = "block";
            provinceLabel.style.display = "none";
            provinceEdit.style.display = "none";
            postalCodeLabel.style.display = "none";
            postalCodeEdit.style.display = "none";
        }
        else
        {
            // Enable International Fields
            zipCodeLabel.style.display = "none";
            zipCodeEdit.style.display = "none";
            stateLabel.style.display = "none";
            stateEdit.style.display = "none";
            countyLabel.style.display = "none";
            countyEdit.style.display = "none";
            provinceLabel.style.display = "block";
            provinceEdit.style.display = "block";
            postalCodeLabel.style.display = "block";
            postalCodeEdit.style.display = "block";
        }
    }
}
</script>

<table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableBody" role="presentation">

<c:choose>
<c:when test="${displayRequiredFieldsIndicator}">
<c:set var="requiredFlag"><%= Boolean.TRUE.toString() %></c:set>
<c:set var="requiredText"><bean-el:message key="label.required"/>,&nbsp;</c:set>
</c:when>
<c:otherwise>
<c:set var="requiredFlag"><%= Boolean.FALSE.toString() %></c:set>
<c:set var="requiredText"></c:set>
</c:otherwise>
</c:choose>

<c:choose>
<c:when test="${countryEditable}">
  <tr>
    <td class="moduleLabel"><fw:label required="${requiredFlag}" property="country" forId="countrySelection"><bean-el:message key="label.addresses.country" />:</fw:label></td>
    <td class="moduleValue">
       <c:set var="countryText"><bean-el:message key="label.addresses.country"/></c:set>
       <html-el:select title="${requiredText}${countryText}" styleId="countrySelection" onchange="updateCountryFields()" styleClass="moduleEdit" property="country" >
           <c:if test="${nullCountryAllowed}">
               <html-el:option value=""><bean-el:message key="label.select" /></html-el:option>
           </c:if>
         <esrcore:options collection="gov.va.med.esr.common.model.lookup.Country" property="code" labelProperty="description"/>
       </html-el:select>
    </td>
  </tr>
</c:when>
<c:otherwise>
  <html-el:hidden styleId="countrySelection" property="country"/>
</c:otherwise>
</c:choose>

<c:choose>
			<c:when test="${pageName == 'addAssociation' && isAddAPerson}" >
				<tr>
					<td width="45%" class="moduleLabel" id="addressLine1Label"><fw:label required="${requiredFlag}" property="addressLine1" forId="addressLine1Id" ><bean-el:message key="label.addresses.addressLine1" />:</fw:label></td>
					<td width="55%" class="moduleValue" id="addressLine1Edit">
    					<c:set var="line1Text"><bean-el:message key="label.addresses.addressLine1"/></c:set>
						<html-el:text onblur="toUpperCase(this)" title="${requiredText}${line1Text}" property="addressLine1" styleId="addressLine1Id" styleClass="moduleEdit" size="40" maxlength="35" readonly="${readOnlyAddress}" onchange="checkAddress('role', 'phoneValue')"/>
					</td>
				</tr>
			</c:when>
			<c:otherwise>
				<tr>
					<td width="45%" class="moduleLabel" id="addressLine1Label"><fw:label required="${requiredFlag}" forId="addressLine1Id" property="addressLine1"><bean-el:message key="label.addresses.addressLine1" />:</fw:label></td>
					<td width="55%" class="moduleValue" id="addressLine1Edit">
						<html-el:hidden  property="selectedAddressType"/>
    					<c:set var="line1Text"><bean-el:message key="label.addresses.addressLine1"/></c:set>
						<html-el:text onblur="toUpperCase(this)" title="${requiredText}${line1Text}" property="addressLine1" styleId="addressLine1Id" styleClass="moduleEdit" size="40" maxlength="35" readonly="${readOnlyAddress}"/>
					</td>
				</tr>
			</c:otherwise>
</c:choose>
<tr>
	<td id="addressLine2Label" class="moduleLabel"><fw:label property="addressLine2" forId="addressLine2Id"><bean-el:message key="label.addresses.addressLine2" />:</fw:label></td>
	<td id="addressLine2Edit" class="moduleValue">
    <c:set var="line2Text"><bean-el:message key="label.addresses.addressLine2"/></c:set>
		<html-el:text onblur="toUpperCase(this)" title="${line2Text}" property="addressLine2" styleId="addressLine2Id" styleClass="moduleEdit" size="40" maxlength="30" readonly="${readOnlyAddress}"/>
	</td>
</tr>
<tr>
	<td id="addressLine3Label" class="moduleLabel"><fw:label property="addressLine3" forId="addressLine3Id"><bean-el:message key="label.addresses.addressLine3" />:</fw:label></td>
	<td id="addressLine3Edit" class="moduleValue">
    <c:set var="line3Text"><bean-el:message key="label.addresses.addressLine3"/></c:set>
		<html-el:text onblur="toUpperCase(this)" title="${line3Text}" property="addressLine3" styleId="addressLine3Id" styleClass="moduleEdit" size="40" maxlength="30" readonly="${readOnlyAddress}"/>
	</td>
</tr>
<tr>
	<td style="display:none" id="zipCodeLabel" class="moduleLabel"><fw:label required="${requiredFlag}" property="zipCode,zipPlus4" forId="zipCodeId"><bean-el:message key="label.addresses.zipCode" />:</fw:label></td>
	<td style="display:none" id="zipCodeEdit" class="moduleValue">
        <c:set var="zipCodeBaseText"><bean-el:message key="label.addresses.zipCode"/> (<bean-el:message key="label.addresses.zipCodeBase"/>)</c:set>
        <c:set var="zipCodeExtensionText"><bean-el:message key="label.addresses.zipCode"/> (<bean-el:message key="label.addresses.zipCodeExtension"/>)</c:set>
        <fw:label property="zipPlus4" forId="zipPlus4Id"><span style="display:none">zipPlus4</span></fw:label>
        <c:choose>
        <c:when test="${zipCodeLookup}">
            <html-el:text property="zipCode" styleId="zipCodeId" style="width: 257px;" onblur="toUpperCase(this); " onkeypress="return lookupCityStateKeyPress(this)" onkeyup="lookupCityStateKeyUp(this)" styleClass="moduleEdit" size="6" title="${requiredText}${zipCodeBaseText}"/> - <html-el:text onblur="toUpperCase(this)" property="zipPlus4" styleClass="moduleEdit" styleId="zipPlus4Id" size="5" maxlength="4" title="${zipCodeExtensionText}"/>
        </c:when>
        <c:otherwise>
            <html-el:text onblur="toUpperCase(this)" styleId="zipCodeId" property="zipCode" style="width: 257px;" styleClass="moduleEdit" size="6" readonly="${readOnlyAddress}" title="${requiredText}${zipCodeBaseText}"/> - <html-el:text onblur="toUpperCase(this)" property="zipPlus4" styleClass="moduleEdit" styleId="zipPlus4Id" size="5" maxlength="4" readonly="${readOnlyAddress}" title="${zipCodeExtensionText}"/>
        </c:otherwise>
        </c:choose>
		<br>
		<fw:label property="suggestionBox" forId="idSuggestionBox"><span style="display:none">suggestionBox</span></fw:label>
		<select size="10" id="idSuggestionBox" name="suggestionBox" style="border: 0px; display: none; position:absolute;" 
		onchange="updateCityState(this, city, county, state);" 
		onmouseout="this.style.display = 'none';"
		onblur="this.style.display = 'none';">
		</select>
	    <html-el:hidden property="prevZip" />
	</td>
</tr>
<tr>
	<td class="moduleLabel" id="cityLabel"><fw:label required="${requiredFlag}" property="city" forId="idCity" ><bean-el:message key="label.addresses.city" />:</fw:label></td>
	<td class="moduleValue" id="cityEdit">
    <c:set var="cityText"><bean-el:message key="label.addresses.city"/></c:set>
		<html-el:text onblur="toUpperCase(this)" title="${requiredText}${cityText}" property="city" styleId="idCity" styleClass="moduleEdit" size="40" maxlength="15" readonly="${readOnlyAddress}"/>
	</td>
</tr>
<tr>
	<td style="display:none" id="stateLabel" class="moduleLabel"><fw:label required="${requiredFlag}" property="state" forId="idState"><bean-el:message key="label.addresses.state" />:</fw:label></td>
	<td style="display:none" id="stateEdit" class="moduleValue">
    <c:set var="stateText"><bean-el:message key="label.addresses.state"/></c:set>
		<html-el:text onblur="toUpperCase(this)" title="${requiredText}${stateText}" styleClass="moduleEdit" styleId="idState" property="state" size="40" maxlength="40" readonly="${readOnlyAddress}"/>
	</td>
</tr>
<tr>
	<td style="display:none" id="countyLabel" class="moduleLabel"><fw:label property="county" forId="idCounty"><bean-el:message key="label.addresses.county" />:</fw:label></td>
	<td style="display:none" id="countyEdit" class="moduleValue">
    <c:set var="countyText"><bean-el:message key="label.addresses.county"/></c:set>
		<html-el:text onblur="toUpperCase(this)" title="${countyText}" property="county" styleClass="moduleEdit" styleId="idCounty" size="40" maxlength="50" readonly="${readOnlyAddress}"/>
	</td>
</tr>
<tr>
	<td style="display:none" id="provinceLabel" class="moduleLabel"><fw:label property="province" forId="idProvince"><bean-el:message key="label.addresses.province" />:</fw:label></td>
	<td style="display:none" id="provinceEdit" class="moduleValue">
    <c:set var="provinceText"><bean-el:message key="label.addresses.province"/></c:set>
		<html-el:text onblur="toUpperCase(this)" title="${provinceText}" property="province" styleId="idProvince" styleClass="moduleEdit" size="40" maxlength="20" readonly="${readOnlyAddress}"/>
	</td>
</tr>
<tr>
	<td style="display:none" id="postalCodeLabel" class="moduleLabel"><fw:label property="postalCode" forId="idPostalCode"><bean-el:message key="label.addresses.postalCode" />:</fw:label></td>
	<td style="display:none" id="postalCodeEdit" class="moduleValue">
    <c:set var="postalCodeText"><bean-el:message key="label.addresses.postalCode"/></c:set>
		<html-el:text onblur="toUpperCase(this)" title="${postalCodeText}" property="postalCode" styleId="idPostalCode" styleClass="moduleEdit" size="40" maxlength="10" readonly="${readOnlyAddress}"/>
	</td>
</tr>
</table>
