<%@ page contentType="text/html;charset=UTF-8" %>
<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/fw" prefix="fw" %>
<%@ taglib uri="/tags/esr-core" prefix="esrcore" %>

<%@ taglib uri="/tags/authz" prefix="auth" %>
<%@ page import='gov.va.med.esr.common.model.lookup.Capability' %>
<%@ page import="gov.va.med.esr.common.model.lookup.MHDataSource" %>
<c:set var="readOnlyMS" scope="request" value="true"/>

<!-- add/edit militray service are not differentiated -->
<auth:authorize ifAnyGranted="<%=Capability.ADD_MILITARY_SERVICE_INFO.getName()%>">
  <c:set var="readOnlyMS" scope="request" value="false"/>
</auth:authorize>
<auth:authorize ifAnyGranted="<%=Capability.EDIT_MILITARY_SERVICE_INFO.getName()%>">
  <c:set var="readOnlyMS" scope="request" value="false"/>
</auth:authorize>

  <%-- Person Locked Check --%>
<c:set var="appData" value="${AppData}" scope="session"/>
<c:set var="personKey" value="SelectedPerson"/>
<c:set var="personLocked" value="${appData[personKey].personLocked}"/>
<c:if test="${personLocked}">
  <c:set var="readOnlyMS" scope="request" value="true"/>
</c:if>

<c:set var="MHRequiredFields" scope="page" value="true" />
<c:choose>
<c:when test="${MHRequiredFields}">
<c:set var="requiredFlag"><%= Boolean.TRUE.toString() %></c:set>
<c:set var="requiredText"><bean-el:message key="label.required"/>,&nbsp;</c:set>
</c:when>
<c:otherwise>
<c:set var="requiredFlag"><%= Boolean.FALSE.toString() %></c:set>
<c:set var="requiredText"></c:set>
</c:otherwise>
</c:choose>

<c:set var="mmddyyyyText" scope="page"><bean-el:message key="label.mmddyyyy"/></c:set>
<c:set var="expandableSectionCollapsed" scope="page"><bean-el:message key="label.expandableSectionCollapsed"/></c:set>
<c:set var="datasource_vadir" scope="page" ><%=MHDataSource.VADIR.getName()%></c:set>
<c:set var="datasource_webhinq" scope="page"><%=MHDataSource.WEBHINQ.getName()%></c:set>
<c:set var="datasource_vba" scope="page" ><%=MHDataSource.VBA.getName()%></c:set>
<c:set var="datasource_other" scope="page"><%=MHDataSource.OTHER.getName()%></c:set>
<c:set var="MOHDataSourcesNotAllowedWarning"><bean-el:message key="message.MOHDataSourcesNotAllowed" /></c:set>

<script type="text/javascript" language="JavaScript">
//var needSourceofChangeWarning = false;

function processMOHIndicator(defaultDocumentReceiptDate)
{

    var moh_nd = document.getElementById('idmohInd_nd');
    var moh_n = document.getElementById('idmohInd_n');
    var moh_y = document.getElementById('idmohInd_y');
    var block = document.getElementById('mohBlock');
    var imageElement = document.getElementById('riArrowImage');
    
    var documentReceiptDate = document.getElementById('idDocumentReceiptDate');
    var dataSource = document.getElementById('idMohDataSource');
    var documentType = document.getElementById('idDocumentType');
    var statusUpdateDate = document.getElementById('idMHLastStatusUpdateDate');
    var status = document.getElementById('idStatus');
    
    if (moh_nd.value == null || moh_nd.checked || moh_n.value == null || moh_n.checked )
    {
        // if ((defaultDocumentReceiptDate != null) && (defaultDocumentReceiptDate == 'y'))
        // {
        //   documentReceiptDate.value = '';
        //   dataSource.options[0].selected = true;
        //   dataSource.selectedIndex = 0;
        //   documentType.options[0].selected = true;
        //   documentType.selectedIndex = 0;
        //   statusUpdateDate.value = '';
        //   status.value = '';
        // }
        collapseSection(block, imageElement, null);
    }
    else  if (moh_y.checked)
    {
        if ((defaultDocumentReceiptDate != null) && (defaultDocumentReceiptDate == 'y'))
        {
            // Always populated as today's date when user selects the "Y" from N or Null
            formatDateTime(null, "MM/dd/yyyy", documentReceiptDate);
        }
        expandSection(block, imageElement, null);
    }
}

function checkDataSourceFields(formObject, datasource_vadir, datasource_webhinq, datasource_vba, datasource_other, msg )
{
    // alert ("old datasource "+ formObject.idOnFileMohDataSource.value + " New datasource "+ formObject.idMohDataSource.value);
    var oldDataSource = document.getElementById('idOnFileMohDataSource');
    var dataSource = document.getElementById('idMohDataSource');
    
    if ( (  formObject.idMohDataSource.value == datasource_vadir || formObject.idMohDataSource.value == datasource_webhinq ) )
    {
        
        if ( formObject.idOnFileMohDataSource.value == null || formObject.idOnFileMohDataSource.value == '')
        {
            dataSource.options[0].selected = true;
            dataSource.selectedIndex = 0;
            needSourceofChangeWarning = true;
            //alert(msg);
            // alert("1. "+ msg);
         }
         else if ( formObject.idOnFileMohDataSource.value == datasource_vba) {
            dataSource.options[2].selected = true;
            dataSource.selectedIndex = 2;
            needSourceofChangeWarning = true;
            //alert(msg);
            // alert("2. "+ msg);
         }
         else if ( formObject.idOnFileMohDataSource.value == datasource_other){
            dataSource.options[1].selected = true;
            dataSource.selectedIndex = 1;
            needSourceofChangeWarning = true;
            //alert(msg);
            // alert("3. "+ msg);
         }
        else  if ( formObject.idMohDataSource.value == datasource_vadir  &&  formObject.idOnFileMohDataSource.value == datasource_webhinq )
        {       
                dataSource.options[3].selected = true;
                dataSource.selectedIndex = 3;  
                needSourceofChangeWarning = true;
                //alert(msg);
                // alert("4. "+ msg);   
        }
        else if (  formObject.idMohDataSource.value == datasource_webhinq  &&  formObject.idOnFileMohDataSource.value == datasource_vadir )
        {       
                dataSource.options[4].selected = true;
                dataSource.selectedIndex = 4;   
                needSourceofChangeWarning = true;
                //alert(msg);
                // alert("5. "+ msg);
         }  
    }       
}
</script>
  
<table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
       <tr>
         <td width="50%" class="moduleLabel" nowrap><html-el:img alt="${expandableSectionCollapsed}" align="center" styleId="riArrowImage" src="../images/redArrowRight.gif" /><bean-el:message key="label.medalOfHonor"/>:</td>
         <td width="50%" class="moduleValue">
           <c:forEach var="item" items="${yesNoNoDataList}">
             <c:set var="medalOfHonorText"><bean-el:message key="label.medalOfHonor"/>&nbsp;(<bean-el:message key="${item.label}" />)</c:set>
             <html-el:radio title="${medalOfHonorText}" styleId="idmohInd_${item.value}" name="militaryServiceInfoForm" property="mohInd" disabled="${readOnlyMS}" onclick="processMOHIndicator('y')" onKeyPress="processMOHIndicator('y')" value="${item.value}" />
             <fw:label property="mohInd" forId="idmohInd_${item.value}"><bean-el:message key="${item.label}"/>&nbsp;&nbsp;</fw:label>
           </c:forEach>
        </td>
        <html-el:hidden name="militaryServiceInfoForm" property="onFileMohInd"/>
        <html-el:hidden name="militaryServiceInfoForm" property="mohHiddenId"/>
      </tr>
</table> 

<table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">        
<tr>
    <td width="100%" colspan="2">
    <div id="mohBlock" class="expandCollapseBody">
    <table width="100%" cellSpacing="0" cellPadding="0" border="0" role="presentation">
    <tr>
      <td width="50%" class="moduleLabel"><fw:label required="true" property="documentType" forId="idDocumentType"><bean-el:message key="label.documentType"/>:</fw:label></td>
      <td width="50%" class="moduleValue">
      <c:set var="documentTypeText"><bean-el:message key="label.documentType"/></c:set>
       <html-el:select title="${requiredText}${documentTypeText}"  styleClass="moduleEdit" styleId="idDocumentType" property="documentType" disabled="${readOnlyMS}">
        <html-el:option value=""><bean-el:message key="label.select" /></html-el:option>
        <esrcore:options collection="gov.va.med.esr.ui.common.beans.UIMHDocumentType" property="code" labelProperty="description"/>
      </html-el:select>
      <html-el:hidden name="militaryServiceInfoForm" property="onFileDocumentType" />
      </td>
    </tr>
     <tr>
       <td width="50%" class="moduleLabel"><fw:label property="documentReceiptDate" forId="idDocumentReceiptDate"><bean-el:message key="label.documentReceiptDate"/>:</fw:label></td>
       <td width="50%" class="moduleValue">
         <c:set var="documentReceiptDateText"><bean-el:message key="label.documentReceiptDate"/> <bean-el:message key="label.mmddyyyy"/></c:set>
         <html-el:text title="${documentReceiptDateText}" styleClass="moduleEdit" styleId="idDocumentReceiptDate" disabled="${readOnlyMS}" property="documentReceiptDate" />&nbsp;<bean-el:message key="label.mmddyyyy"/>
         <html-el:hidden name="militaryServiceInfoForm" property="onFileDocumentReceiptDate" />
       </td>
     </tr>
     <tr>
      <td width="50%" class="moduleLabel"><fw:label required="true" property="dataSource" forId="idMohDataSource"><bean-el:message key="label.dataSource"/>:</fw:label></td>
      <td width="50%" class="moduleValue">
      <c:set var="dataSourceText"><bean-el:message key="label.dataSource"/></c:set>
       <c:set var="MOHDataSourcesNotAllowedWarning"><bean-el:message key="message.MOHDataSourcesNotAllowed" /></c:set>
        <table border="0" cellpadding="0" cellspacing="0" class="moduleShellLowTableBody" role="presentation">
            <tr>
                <td>
                    <html-el:select title="${requiredText}${dataSourceText}" styleClass="moduleEdit" styleId="idMohDataSource" property="dataSource" disabled="${readOnlyMS}" >
                        <html-el:option value=""><bean-el:message key="label.select" /></html-el:option>
                        <esrcore:options collection="gov.va.med.esr.ui.common.beans.UIMHDataSource" property="code" labelProperty="name"/>
                        </html-el:select>
                    <html-el:hidden name="militaryServiceInfoForm" styleId="idOnFileMohDataSource" property="onFileMohDataSource"></html-el:hidden>
                </td>
                <td>
                    &nbsp;
                </td>
            </tr>
        </table>
      </td>
    </tr>
     <tr>
      <td width="50%" class="moduleLabel"><bean-el:message key="label.decorationStatus"/>:</td>
      <td width="50%" class="moduleValue">
        <c:set var="decorationStatusText"><bean-el:message key="label.decorationStatus"/></c:set>
        <esrcore:displayValue name="militaryServiceInfoForm" property="status"/>   
        <html-el:hidden name="militaryServiceInfoForm" styleId="idStatus" property="status"></html-el:hidden>       
      </td>
    </tr>
     <tr>
      <td width="50%" class="moduleLabel"><bean-el:message key="label.statusUpdateDate"/>:</td>
      <td width="50%" class="moduleValue">
        <c:set var="statusUpdateText"><bean-el:message key="label.statusUpdateDate"/></c:set>
        <esrcore:displayValue name="militaryServiceInfoForm" property="mhLastStatusUpdateDate"/>  
        <html-el:hidden name="militaryServiceInfoForm" styleId="idMHLastStatusUpdateDate" property="mhLastStatusUpdateDate"></html-el:hidden>               
      </td>
    </tr>   
 </table>
 </div>
</td>
</tr>
</table>
     
     
