<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/esr-core" prefix="esrcore" %>
<%@ taglib uri="/tags/fw" prefix="fw" %>

<c:set var="expandableSectionCollapsed" scope="page"><bean-el:message key="label.expandableSectionCollapsed"/></c:set>
<c:set var="mmddyyyyText" scope="page"><bean-el:message key="label.mmddyyyy"/></c:set>
<c:set var="requiredText"><bean-el:message key="label.required"/></c:set>

<script src="../scripts/ESR-Script.js" type="text/javascript"></script>
<c:if test="${pageName == 'financialsDependentAdd'}">
<script> 
  function onLoadInit()
  {
    processLivedWithVeteran();    
    processChildIncome();
  }

  function processLivedWithVeteran()
  {
    var indicator_n = document.getElementById('idLivedWithVeteran_n');
    var block = document.getElementById('lwvBlock');
    var imageElement = document.getElementById('lwvArrowImage');

    if (indicator_n.value != null && indicator_n.checked)
    {
      expandSection(block, imageElement, null);
    }
    else
    {
      collapseSection(block, imageElement, null);
    }
  }

 

  function processChildIncome()
  {
    var indicator_y = document.getElementById('idChildHasIncome_y');
    var block = document.getElementById('chiBlock');
    var imageElement = document.getElementById('chiArrowImage');

    if (indicator_y.value != null && indicator_y.checked)
    {
      expandSection(block, imageElement, null);
    }
    else
    {
      collapseSection(block, imageElement, null);
    }
  }
</script>
</c:if>

<table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableBody" role = "presentation">
  <tr>
    <td colspan="2">
      <%@ include file="/tiles/common/instructionalText.jsp" %>
    </td>
  </tr>
  <tr>
  <td width="45%" class="moduleLabel"><fw:label required="true" property="dependentInfo.effectiveDate" forId="idDependentEffDate">Dependent Effective Date:</fw:label></td>
  <td width="55%" class="moduleValue"><html-el:text title="${requiredText}, Dependent Effective Date" styleClass="moduleEdit initfocus" styleId="idDependentEffDate" property="dependentInfo.effectiveDate" size="25" maxlength="25"/></td>
  </tr>
  <tr>
  <td class="moduleLabel"><fw:label property="dependentInfo.inactiveDate" forId="idDependentInactiveDate">Inactive Date:</fw:label></td>
  <td class="moduleValue"><html-el:text title="Inactive Date" styleClass="moduleEdit" property="dependentInfo.inactiveDate" styleId="idDependentInactiveDate" size="25" maxlength="25"/></td>
  </tr>
  <tr>
  <td class="moduleLabel"><fw:label property="dependentInfo.prefix" forId="idPrefix">Prefix:</fw:label></td>
  <td  class="moduleValue"><html-el:text title="Prefix" styleClass="moduleEdit" property="dependentInfo.prefix" styleId="idPrefix" size="25" maxlength="25"/></td>
  </tr>
  <tr>
  <td class="moduleLabel"><fw:label required="true" property="dependentInfo.firstName" forId="idDependentFirstName">First Name:</fw:label></td>
  <td  class="moduleValue"><html-el:text title="${requiredText}, FirstName" styleClass="moduleEdit" property="dependentInfo.firstName" styleId="idDependentFirstName" size="40" maxlength="40"/></td>
  </tr>
  <tr>
  <td class="moduleLabel"><fw:label property="dependentInfo.middleName" forId="idDependentMiddleName">Middle Name:</fw:label></td>
  <td  class="moduleValue"><html-el:text title="Middle Name" styleClass="moduleEdit" property="dependentInfo.middleName" styleId="idDependentMiddleName" size="40" maxlength="40"/></td>
  </tr>
  <tr>
  <td class="moduleLabel"><fw:label required="true" property="dependentInfo.lastName" forId="idDependentLastName">Last Name:</fw:label></td>
  <td  class="moduleValue"><html-el:text title="${requiredText}, Last Name" styleClass="moduleEdit" property="dependentInfo.lastName" styleId="idDependentLastName" size="40" maxlength="40"/></td>
  </tr>
  <tr>
  <td class="moduleLabel"><fw:label property="dependentInfo.suffix" forId="idDependentSuffix">Suffix:</fw:label></td>
  <td  class="moduleValue"><html-el:text title="Suffix" styleClass="moduleEdit" property="dependentInfo.suffix" styleId="idDependentSuffix" size="25" maxlength="25"/></td>
  </tr>
  <tr>
  <td class="moduleLabel"><fw:label property="dependentInfo.ssn" forId="idDependentSSN">SSN:</fw:label></td>
  <td class="moduleValue"><html-el:text title="SSN" styleClass="moduleEdit" property="dependentInfo.ssn" styleId="idDependentSSN" size="25" maxlength="25" onkeypress="return validateSSN(event)" onkeyup="formatSSN(event)" onblur="formatSSN(event)"/></td>
  </tr>
  <tr>
  <td class="moduleLabel"><fw:label property="dependentInfo.pseudoSsn" forId="idDependentPseudoSsn">Pseudo SSN:</fw:label></td>
  <td  class="moduleValue">
    <html-el:hidden property="dependentInfo.pseudoSsn" />
    <esrcore:displayValue name="financialsDependentForm" property="dependentInfo.pseudoSsn"/>
  </td>
  </tr>
    <tr>
      <td width="45%" class="moduleLabel"><fw:label property="dependentInfo.pseudoSsnReason" forId="idDepPseudoSsnReason">Pseudo SSN Reason:</fw:label></td>
      <td width="55%" class="moduleValue">
      <html-el:select title="Pseudo SSN Reason" styleClass="darkValue" styleId="idDepPseudoSsnReason" property="dependentInfo.pseudoSsnReason">
      <html-el:option value=""><bean-el:message key="label.select" /></html-el:option>
      <esrcore:options collection="gov.va.med.esr.common.model.lookup.PseudoSSNReason" property="code" labelProperty="description"/>
      </html-el:select>
    </td>
    </tr>
  </table>

  <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableBody" role = "presentation">
  <tr>
      <td width="45%" class="moduleLabel"><fw:label required="true" property="dependentInfo.relationshipCode" forId="idDepRelationshipCode">Relationship:</fw:label></td>
      <td width="55%" class="moduleValue">
      <html-el:select title="${requiredText}, Relationship" styleClass="darkValue" styleId="idDepRelationshipCode" property="dependentInfo.relationshipCode">
      <html-el:option value=""><bean-el:message key="label.select" /></html-el:option>
      <esrcore:options collection="gov.va.med.esr.ui.common.beans.Relationship" property="code" labelProperty="description"/>
      </html-el:select>
    </td>
  </tr>
  <tr>
  <td class="moduleLabel"><fw:label required="true" property="dependentInfo.dateOfBirth" forId="idDepDateOfBirth">Date of Birth:</fw:label></td>
  <td  class="moduleValue"><html-el:text title="${requiredText}, Date of Birth ${mmddyyyyText}" styleClass="moduleEdit" styleId="idDepDateOfBirth" property="dependentInfo.dateOfBirth" size="25" maxlength="25"/>&nbsp;<bean-el:message key="label.mmddyyyy" /></td>
  </tr>
  </table>

<c:if test="${pageName == 'financialsDependentAdd'}">
  <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableBody" role = "presentation"> 
    <tr>
      <td width="45%" class="moduleLabel" nowrap><html-el:img alt="${expandableSectionCollapsed}" align="center" styleId="lwvArrowImage" src="../images/redArrowRight.gif" />Resided with Veteran Last Calendar Year:</td>
      <td width="55%" class="moduleValue">
        <c:forEach var="item" items="${yesNoList}">
         <c:set var="itemLabel"><bean-el:message key="${item.label}"/></c:set>
          <html-el:radio title="Resided with Veteran Last Calendar Year (${itemLabel})" styleId="idLivedWithVeteran_${item.value}" property="dependentInfo.livedWithVeteran" onclick="processLivedWithVeteran();" value="${item.value}" />
          <fw:label property="dependentInfo.livedWithVeteran" forId="idLivedWithVeteran_${item.value}"><bean-el:message key="${item.label}" /></fw:label>
        </c:forEach>
      </td>
    </tr>
  </table>

  <%-- livedWithVeteran Expand/Collapse Section --%>
  <div id="lwvBlock" class="expandCollapseBody">
    <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableBody" role = "presentation">
      <tr>
        <td>
          <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableBody" role = "presentation">
            <tr>
              <td width="45%" class="moduleLabel" nowrap>Contributed to Child Support:</td>
              <td width="55%" class="moduleValue">
                <c:forEach var="item" items="${yesNoList}">
                  <c:set var="itemLabel"><bean-el:message key="${item.label}"/></c:set>
                  <html-el:radio title="Contributed to Child Support (${itemLabel})" styleId="idContributedToSupport_${item.value}" property="dependentInfo.contributedToSupport"  value="${item.value}" />
                  <fw:label property="dependentInfo.contributedToSupport" forId="idContributedToSupport_${item.value}"><bean-el:message key="${item.label}" /></fw:label>
                </c:forEach>
              </td>
            </tr>
          </table>
        </td>
      </tr>
    </table>
  </div>
  
  <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableBody" role = "presentation">
    <tr>
      <td width="45%" class="moduleLabel" nowrap><html-el:img alt="${expandableSectionCollapsed}" align="center" styleId="chiArrowImage" src="../images/redArrowRight.gif" />Child has Income:</td>
      <td width="55%" class="moduleValue">
        <c:forEach var="item" items="${yesNoList}">
          <c:set var="itemLabel"><bean-el:message key="${item.label}"/></c:set>
          <html-el:radio title="Child has Income (${itemLabel})" styleId="idChildHasIncome_${item.value}" property="dependentInfo.hasIncome" onclick="processChildIncome()" value="${item.value}" />
          <fw:label property="dependentInfo.hasIncome" forId="idChildHasIncome_${item.value}"><bean-el:message key="${item.label}" /></fw:label>
        </c:forEach>
      </td>
    </tr>
  </table>

  <%-- availableIncome Expand/Collapse Section --%>
  <div id="chiBlock" class="expandCollapseBody">
  <table width="100%" border="0" cellpadding="0" cellspacing="0" role = "presentation">
  <tr>
  <td>
      <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableBody" role = "presentation">
        <tr>
          <td width="45%" class="moduleLabel">Available Income:</td>
          <td width="55%" colspan="2" class="moduleValue">
      <c:forEach var="item" items="${yesNoList}">
        <c:set var="itemLabel"><bean-el:message key="${item.label}"/></c:set>
        <html-el:radio title="Available Income (${itemLabel})" property="dependentInfo.incomeAvailableToPatient" styleId="idIncomeAvaiToPatient_${item.value}" value="${item.value}" />
        <fw:label property="dependentInfo.incomeAvailableToPatient" forId="idIncomeAvaiToPatient_${item.value}"><bean-el:message key="${item.label}" /></fw:label>
        </c:forEach>
     </td>
        </tr>
      </table>
    </td>
  </tr>
  </table>
  </div>


  <table border="0" width="100%" cellpadding="0" cellspacing="0" class="moduleShellTableBody" role = "presentation">
    <tr>
    <td width="45%" class="moduleLabel">In School:</td>
        <td width="55%" colspan="2" class="moduleValue">
      <c:forEach var="item" items="${yesNoList}">
        <c:set var="itemLabel"><bean-el:message key="${item.label}"/></c:set>
        <html-el:radio title="In School (${itemLabel})" property="dependentInfo.attendedSchool" styleId="idDepattendedSchool_${item.value}" value="${item.value}" />
        <fw:label property="dependentInfo.attendedSchool" forId="idDepattendedSchool_${item.value}"><bean-el:message key="${item.label}" /></fw:label>
        </c:forEach>
    </td>
    </tr>
    <tr>
    <td class="moduleLabel">Incapable of Self Support:</td>
        <td colspan="2" class="moduleValue">
      <c:forEach var="item" items="${yesNoList}">
        <c:set var="itemLabel"><bean-el:message key="${item.label}"/></c:set>
        <html-el:radio title="Incapable of Self Support (${itemLabel})" property="dependentInfo.incapableOfSelfSupport" styleId="idDepIncapableOfSelfSupport_${item.value}" value="${item.value}" />
        <fw:label property="dependentInfo.incapableOfSelfSupport" forId="idDepIncapableOfSelfSupport_${item.value}"><bean-el:message key="${item.label}" /></fw:label>
        </c:forEach>
    </td>
    </tr>
    <tr>
    <td class="moduleLabel">&nbsp;</td>
    <td class="moduleValue">&nbsp; </td>
    </tr>
  </table>
</c:if>

<c:if test="${pageName == 'financialsDependentEdit'}">
  <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableBody" role = "presentation">
  <tr>
  <td width="45%" class="moduleLabel"><fw:label property="dependentInfo.ssnSourceOfChange" forId="idDepSsnSourceOfChange">SSN Source of Change:</fw:label></td>
  <td width="55%" class="moduleValue">
    <html-el:select styleClass="darkValue" property="dependentInfo.ssnSourceOfChange" styleId="idDepSsnSourceOfChange">
    <html-el:option value=""><bean-el:message key="label.select" /></html-el:option>
    <esrcore:options collection="gov.va.med.esr.common.model.lookup.SSNChangeSource" property="code" labelProperty="description"/>
    </html-el:select>
  </td>
  </tr>
  <tr>
  <td class="moduleLabel"><fw:label property="dependentInfo.ssaVerificationStatus" forId="idDepSsaVerificationStatus">SSA Verification Status:</fw:label></td>
  <td class="moduleValue">
    <html-el:select styleClass="darkValue" property="dependentInfo.ssaVerificationStatus" styleId="idDepSsaVerificationStatus">
    <html-el:option value=""><bean-el:message key="label.select" /></html-el:option>
    <esrcore:options collection="gov.va.med.esr.common.model.lookup.SSAVerificationStatus" property="code" labelProperty="description"/>
    </html-el:select>
  </td>
  </tr>
  <tr>
  <td class="moduleLabel">SSA Verification Date:</td>
  <td class="moduleValue">
    <html-el:hidden property="dependentInfo.ssaVerificationDate" />
        <esrcore:displayValue name="financialsDependentForm" property="dependentInfo.ssaVerificationDate"/>
  </td>
  </tr>
  <tr>
  <td  class="moduleLabel">SSA Message:</td>
  <td class="moduleValue">
    <html-el:hidden property="dependentInfo.ssaMessage" />
    <esrcore:displayValue name="financialsDependentForm" property="dependentInfo.ssaMessage"/>
  </td>
  </tr>
  </table>
</c:if>
