<%@ taglib uri="/tags/esr-core" prefix="esrcore" %>
<%@ taglib uri="/tags/fw" prefix="fw" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ page import='gov.va.med.esr.common.model.lookup.EGTSettingType' %>
<%@ page import='gov.va.med.esr.common.model.lookup.EnrollmentPriorityGroup' %>
<%@ page import='gov.va.med.esr.common.model.lookup.EnrollmentPrioritySubGroup' %>

<c:set var="egtTypeEnrollmentDecisionConstant"><%= EGTSettingType.CODE_ENROLLMENT_DECISION.getName() %></c:set>
<c:set var="egtPriority8Constant"><%= EnrollmentPriorityGroup.GROUP_8.getName() %></c:set>
<c:set var="egtPriority7Constant"><%= EnrollmentPriorityGroup.GROUP_7.getName() %></c:set>
<c:set var="egtSubPriorityCConstant"><%= EnrollmentPrioritySubGroup.SUBGROUP_C.getName() %></c:set>
<c:set var="egtSubPriorityDConstant"><%= EnrollmentPrioritySubGroup.SUBGROUP_D.getName() %></c:set>
<c:set var="mmddyyyyText" scope="page"><bean-el:message key="label.mmddyyyy"/></c:set>

<script language="javascript">
function onLoadInit()
{
    egtPriorityOrEgtTypeSelectionChanged();
}

// Hard codes a value of 'c' and disables the field for EGT sub-priority when EGT Type is
// 'Enrollment Decision' and EGT Priority is '7' or '8'.
function egtPriorityOrEgtTypeSelectionChanged()
{
    if ((egtSettingInfoForm.egtType.value == '<c:out value="${egtTypeEnrollmentDecisionConstant}"/>') &&
        (egtSettingInfoForm.egtPriorityGroup.value == '<c:out value="${egtPriority7Constant}"/>'))
    {
        egtSettingInfoForm.egtPrioritySubGroup.disabled = true;
        egtSettingInfoForm.egtPrioritySubGroup.value = '<c:out value="${egtSubPriorityCConstant}"/>';
        egtSettingInfoForm.egtPrioritySubGroupHidden.value = '<c:out value="${egtSubPriorityCConstant}"/>';
    }
    else if ((egtSettingInfoForm.egtType.value == '<c:out value="${egtTypeEnrollmentDecisionConstant}"/>') &&
         (egtSettingInfoForm.egtPriorityGroup.value == '<c:out value="${egtPriority8Constant}"/>'))
    {
        egtSettingInfoForm.egtPrioritySubGroup.disabled = true;
        egtSettingInfoForm.egtPrioritySubGroup.value = '<c:out value="${egtSubPriorityDConstant}"/>';
        egtSettingInfoForm.egtPrioritySubGroupHidden.value = '<c:out value="${egtSubPriorityDConstant}"/>';
    }
    else
    {
        egtSettingInfoForm.egtPrioritySubGroup.disabled = true;
        egtSettingInfoForm.egtPrioritySubGroup.value = '';
        egtSettingInfoForm.egtPrioritySubGroupHidden.value = egtSettingInfoForm.egtPrioritySubGroup.value;
    }
}

// Displays a confirmation message for the EGT Setting change
function egtSettingConfirmMessage()
{
    return confirmMessage('<bean-el:message key="message.egt.confirmUpdate"/>');
}
</script>

<table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
  <html-el:hidden property="egtSettingId"></html-el:hidden>
  <tr>
    <td width="45%" class="moduleLabel"><fw:label required="true" property="egtType" forId="egtType"><bean-el:message key="label.egt.egtType"/>:</fw:label></td>
    
      <c:choose>
      <c:when test="${screenEditable}">
      <td width="55%" class="moduleValue">
      <c:set var="egtTypeText"><bean-el:message key="label.required" />,&nbsp;<bean-el:message key="label.egt.egtType"/></c:set>
        <html-el:select title="${egtTypeText}" styleId="egtType" onchange="egtPriorityOrEgtTypeSelectionChanged()" styleClass="moduleEdit" property="egtType" disabled="true">
          <html-el:option value=""><bean-el:message key="label.select" /></html-el:option>
          <esrcore:options collection="gov.va.med.esr.common.model.lookup.EGTSettingType" property="code" labelProperty="description"/>
        </html-el:select>
      </c:when>
      <c:otherwise>
      <td title="<bean-el:message key="label.egt.egtType"/>" width="55%" class="moduleValue">
        <esrcore:displayLookupValue lookupType="gov.va.med.esr.common.model.lookup.EGTSettingType" name="egtSettingInfoForm" property="egtType" />
      </c:otherwise>
      </c:choose>
    </td>
  </tr>
  <c:choose>
  <c:when test="${screenEditable}">
  <tr>
    <td class="moduleLabel"><fw:label required="true" property="egtPriorityGroup" forId="egtPriorityGroup"><bean-el:message key="label.egt.egtPriority"/>:</fw:label></td>
    <td class="moduleValue">
        <c:set var="egtPriorityText"><bean-el:message key="label.required" />,&nbsp;<bean-el:message key="label.egt.egtPriority"/></c:set>
        <html-el:select title="${egtPriorityText}" styleId="egtPriorityGroup" onchange="egtPriorityOrEgtTypeSelectionChanged()" styleClass="moduleEdit" property="egtPriorityGroup" >
          <html-el:option value=""><bean-el:message key="label.select" /></html-el:option>
          <esrcore:options collection="gov.va.med.esr.common.model.lookup.EnrollmentPriorityGroup" property="code" labelProperty="code"/>
        </html-el:select>
    </td>
  </tr>
  <tr>
    <td class="moduleLabel"><fw:label property="egtPrioritySubGroup" forId="egtPrioritySubGroup"><bean-el:message key="label.egt.egtSubPriority"/>:</fw:label></td>
    <td class="moduleValue">
        <c:set var="egtSubPriorityText"><bean-el:message key="label.egt.egtSubPriority"/></c:set>
        <html-el:select title="${egtSubPriorityText}" styleId="egtPrioritySubGroup" onchange="egtPriorityOrEgtTypeSelectionChanged()" styleClass="moduleEdit" property="egtPrioritySubGroup" disabled="true">
          <html-el:option value="">&nbsp;</html-el:option>
          <esrcore:options collection="gov.va.med.esr.common.model.lookup.EnrollmentPrioritySubGroup" property="code" labelProperty="description"/>
        </html-el:select>
        <html-el:hidden styleId="egtPrioritySubGroupHidden" property="egtPrioritySubGroupHidden"></html-el:hidden>
    </td>
  </tr>
  </c:when>
  <c:otherwise>
  <tr>
    <td class="moduleLabel"><fw:label property="egtPriorityGroup"><bean-el:message key="label.egt.egtPriority"/>:</fw:label></td>
    <td title ="<bean-el:message key="label.egt.egtPriority"/>" class="moduleValue">
        <esrcore:displayValue name="egtSettingInfoForm" property="egtPriorityGroup"/><esrcore:displayLookupValue lookupType="gov.va.med.esr.common.model.lookup.EnrollmentPrioritySubGroup" name="egtSettingInfoForm" property="egtPrioritySubGroup" lookupProperty="name"/>
    </td>
  </tr>
  </c:otherwise>
  </c:choose>
  <tr>
    <td class="moduleLabel"><fw:label required="true" property="egtEffectiveDate" forId="idEgtEffectiveDate"><bean-el:message key="label.egt.egtEffectiveDate"/>:</fw:label></td>
      <c:choose>
      <c:when test="${screenEditable}">
      <td class="moduleValue">
      <c:set var="egtEffectiveDateText"><bean-el:message key="label.required" />,&nbsp;<bean-el:message key="label.egt.egtEffectiveDate"/>&nbsp;<c:out value="${mmddyyyyText}" /></c:set>
        <html-el:text title="${egtEffectiveDateText}" styleClass="moduleEdit" property="egtEffectiveDate" styleId="idEgtEffectiveDate" size="20" maxlength="10"/>&nbsp;<bean-el:message key="label.mmddyyyy"/>
      </c:when>
      <c:otherwise>
      <td title="<bean-el:message key="label.egt.egtEffectiveDate"/>" class="moduleValue">
        <esrcore:displayDate name="egtSettingInfoForm" dateProperty="egtEffectiveDate" displayTime="false"/>
      </c:otherwise>
      </c:choose>
    </td>
  </tr>
  <tr>
    <td class="moduleLabel"><fw:label property="federalRegisterDate" forId="idFederalRegisterDate"><bean-el:message key="label.egt.federalRegisterDate"/>:</fw:label></td>
      <c:choose>      
      <c:when test="${screenEditable}">
      <td class="moduleValue">
      <c:set var="federalRegisterDateText"><bean-el:message key="label.egt.federalRegisterDate"/>&nbsp;<c:out value="${mmddyyyyText}" /></c:set>
        <html-el:text title="${federalRegisterDateText}" styleClass="moduleEdit" property="federalRegisterDate" styleId="idFederalRegisterDate" size="20" maxlength="10"/>&nbsp;<bean-el:message key="label.mmddyyyy"/>
      </c:when>
      <c:otherwise>
      <td title="<bean-el:message key="label.egt.federalRegisterDate"/>" class="moduleValue">
        <esrcore:displayDate name="egtSettingInfoForm" dateProperty="federalRegisterDate" displayTime="false"/>
      </c:otherwise>
      </c:choose>
    </td>
  </tr>
  <tr>
    <td class="moduleLabel" valign="top"><fw:label property="comments" forId="idComments"><bean-el:message key="label.egt.comments"/>:</fw:label></td>
    
      <c:choose>
      <c:when test="${screenEditable}">
      <td class="moduleValue">
      <c:set var="commentsText"><bean-el:message key="label.egt.comments"/></c:set>
        <html-el:textarea title="${commentsText}" styleClass="moduleEdit" property="comments" styleId="idComments" rows="10" cols="60"/>
      </c:when>
      <c:otherwise>
      <td title="<bean-el:message key="label.egt.comments"/>" class="moduleValue">
        <esrcore:displayValue name="egtSettingInfoForm" property="comments"/>
      </c:otherwise>
      </c:choose>
    </td>
  </tr>
</table>
