<%@ taglib uri="/tags/struts-bean" prefix="bean"%>
<%@ taglib uri="/tags/struts-html" prefix="html"%>
<%@ taglib uri="/tags/struts-logic" prefix="logic"%>
<%@ taglib uri="/tags/struts-tiles" prefix="tiles"%>
<%@ taglib uri="/tags/struts-nested" prefix="nested"%>
<%@ taglib uri="/tags/esr-core" prefix="esrcore"%>
<%@ taglib uri="/tags/valuelist" prefix="vlh"%>
<%@ taglib uri="/tags/fw" prefix="fw" %>
<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el"%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="/tags/authz" prefix="auth" %>
<%@ page import='gov.va.med.esr.common.model.lookup.Capability' %>

<c:set var="selectLabel" value="Select" />
<c:set var="rowColor" value="value" />

<%-- Permissions --%>
<c:set var="viewHealthBenefitsPlans"><%=Capability.VIEW_HEALTH_BENEFITS_PLANS.getName()%></c:set>
<c:set var="assignHealthBenefitsPlans"><%=Capability.ASSIGN_HEALTH_BENEFITS_PLANS.getName()%></c:set>
<c:set var="unAssignHealthBenefitsPlans"><%=Capability.UNASSIGN_HEALTH_BENEFITS_PLANS.getName()%></c:set>

<c:set var="readOnlyUser" value="false" />
<c:set var="assignHbp" value="false" />
<c:set var="unAssignHbp" value="false" />

<auth:authorize ifAnyGranted="${viewHealthBenefitsPlans}">
    <c:set var="readOnlyUser" value="true"/>
</auth:authorize>

<auth:authorize ifAnyGranted="${assignHealthBenefitsPlans}">
    <c:set var="assignHbp" value="true"/>
    <c:set var="readOnlyUser" value="false"/>
</auth:authorize>

<auth:authorize ifAnyGranted="${unAssignHealthBenefitsPlans}">
    <c:set var="unAssignHbp" value="true"/>
    <c:set var="readOnlyUser" value="false"/>
</auth:authorize>


<table width="100%" border="1" cellpadding="0" cellspacing="0"
	class="moduleShell">
	<html-el:form action="/healthBenefitPlan" method="post">
	  <%@ include file="/admin/csrfgentoken.jsp" %>
		<html-el:hidden name="healthBenefitPlanForm" property="readOnly" />
		<%--
		<c:set var="readOnlyUser" value="false" />
		<c:if test="${healthBenefitPlanForm.readOnly == true}">
			<c:set var="readOnlyUser" value="true" />
		</c:if>
		--%>
		
		<tr>
			<td>
			<table width="100%" border="0" cellpadding="0" cellspacing="0"
				class="moduleShellTableHead">
				<tr>
					<td class="moduleBlueBox"><img alt=""
						src="../images/spacer.gif" width="28" height="23" /></td>
					<c:choose>
						<c:when test="${readOnlyUser}">
							<td nowrap class="moduleHeadline" style="padding-left: 7"><bean-el:message
								key="label.hbpAssignedReadOnly" /></td>
						</c:when>
						<c:otherwise>
							<td nowrap class="moduleHeadline" style="padding-left: 7"><bean-el:message
								key="label.hbpAssigned" /></td>
						</c:otherwise>
					</c:choose>
					<td width="100%"><img alt="" src="../images/spacer.gif"></td>
							<td nowrap class="moduleBlueLink" style="padding: 1 8 1 8">
					   <%-- <fw:link action="/healthBenefitPlan.do?methodName=DisplayHealthBenefitPlan" module="/ee"> --%>
						    <fw:link action="/hbpHistory?methodName=DISPLAY&amp;history=viewHistoricalHBP"> 
								<bean-el:message key="healthBenefitPlan.link.displayHistory"/>
							</fw:link></td>
				</tr>
			</table>
			</td>
		</tr>
		<tr>
			<td>
			<table summary="Table of Historical Health Benefit Plans" width="100%" border="0" cellspacing="0" cellpadding="0"
				class="moduleShellTableBody">

				<thead>

					 <c:choose>
                       <c:when test="${not empty healthBenefitPlanForm.assignedHbpCodeList}">
                       <tr>
						<th scope="col" nowrap width="5%" class="moduleLabel"
							style="text-align: left; padding-left: 10"><bean-el:message
							key="label.hbpUnselect" /></th>
						<th scope="col" nowrap width="60%" class="moduleLabel"
							style="text-align: left; padding-left: 15"><bean-el:message
							key="label.hbpDesc" /></th>
						<th scope="col" nowrap width="20%" class="moduleLabel"
							style="text-align: left; padding-left: 15"><bean-el:message
							key="label.lastUpdatedDate" /></th>
						<th scope="col" nowrap width="15%" class="moduleLabel"
							style="text-align: left; padding-left: 5">&nbsp;</th>
                    </tr>
										
				

					<c:forEach var="hbpCode"
						items="${healthBenefitPlanForm.assignedHbpCodeList}"
						varStatus="status">

						<c:set var="counter" value="${status.count - 1}" />
						<c:set var="hbpDesc"
							value="${healthBenefitPlanForm.assignedHbpDescList[counter]}" />
						<c:set var="hbpEditable"
							value="${healthBenefitPlanForm.assignedHbpEditableList[counter]}" />

						<tr>
							
					<%-- the following section of code is to decide if the unselect choice is enabled or  not  --%>
							<c:choose>
							<c:when test="${readOnlyUser}">
								<td scope="row" class="moduleValue" style="padding:5 5 5 15">								
								<html-el:checkbox
									title="${selectLabel} ${hbpDesc}"
									property="assignedHbpInd[${counter}]" disabled="${readOnlyUser}" styleId="assignedHbpInd${counter}" />
								</td>
							</c:when>
							<c:otherwise>
									<c:choose>
									<c:when test="${unAssignHbp}">
										<td scope="row" class="moduleValue" style="padding:5 5 5 15">										
										<html-el:checkbox
											title="${selectLabel} ${hbpDesc}"
											property="assignedHbpInd[${counter}]" disabled="${hbpEditable ||hbpCode=='200'||hbpCode=='203'|| hbpCode=='201' || hbpCode=='202'|| hbpCode=='204'}" styleId="assignedHbpInd${counter}" />
										</td>
									</c:when>
									<c:otherwise>
										<td scope="row" class="moduleValue" style="padding:5 5 5 15">
										<html-el:hidden property="assignedHbpInd[${counter}]" />										
										<html-el:checkbox
											title="${selectLabel} ${hbpDesc}"
											property="assignedHbpInd[${counter}]" disabled="true" styleId="assignedHbpInd${counter}"/>
										</td>
									</c:otherwise>
									</c:choose>
							</c:otherwise>
							</c:choose>
					<%-- the end of the section of code deciding if the unselect choice is enabled or  not --%>

							<td nowrap style="text-align: left;padding:5 5 5 15"
								class="moduleValue"><html-el:hidden
								property="assignedHbpDesc[${counter}]" />
								<fw:label property="assignedHbpInd[${counter}]" forId="assignedHbpInd${counter}">
									<c:out value="${healthBenefitPlanForm.assignedHbpDescList[counter]}" />
								</fw:label>
							</td>

							<td nowrap style="text-align: left;padding:5 5 5 15"
								class="moduleValue""><html-el:hidden
								property="assignedHbpLastUpdatedDate[${counter}]" /> <c:out
								value="${healthBenefitPlanForm.assignedHbpLastUpdatedDateList[counter]}" />
							</td>

							<html-el:hidden	property="assignedHbpCode[${counter}]" /> 
						</tr>

					</c:forEach>
					 </c:when>
                      <c:otherwise>
                            <th scope="col" nowrap width="50%" class="moduleValue"
							style="text-align: left; padding-left: 20"><bean-el:message
							key="label.hbpNoneAssigned" /></th>
                      </c:otherwise>
					</c:choose>
					</thead>
			</table>
			 
			
			<%-- <c:if test="${not readOnlyUser}">  --%>

				<tr>
					<td>

					<table width="100%" border="0" cellpadding="0" cellspacing="0"
						class="moduleShellTableHead">
						<tr>
							<td class="moduleBlueBox"><img alt=""
								src="../images/spacer.gif" width="28" height="23" />
							</td>
							<c:choose>
							   <c:when test="${readOnlyUser}">
								<td nowrap width="100%" class="moduleHeadline" style="padding-left: 7"><bean-el:message
									key="label.hbpAvailableToUser" />
								</td>
							</c:when>
							<c:otherwise>
								<td nowrap width="100%" class="moduleHeadline" style="padding-left: 7"><bean-el:message
									key="label.hbpAvailable" />
								</td>
							</c:otherwise>
							</c:choose>	
							<td witdh="100%"><img alt="" src="../images/spacer.gif" /></td>
						</tr>

						</tr>
					</table>
					</td>
				</tr>
				<tr>
					<td>
					<table summary="List of Available Health Benefit Plans" width="100%" border="0" cellspacing="0" cellpadding="0"
						class="moduleShellTableBody">

						<thead>
                            
							
							<c:choose>
							  <c:when test="${not empty healthBenefitPlanForm.hbpCodeList}">
							  <tr>
								<th scope="col" nowrap width="5%" class="moduleLabel"
									style="text-align: left; padding-left: 10"><bean-el:message
									key="label.hbpSelect" /></th>
								<th scope="col" nowrap width="70%" class="moduleLabel"
									style="text-align: left; padding-left: 15"><bean-el:message
									key="label.hbpDesc" /></th>
							<!-- CCR13059-Commented out to resolve issue of additional blank column  -->
							<!--	<th scope="col" nowrap width="25%" class="moduleLabel"
									style="text-align: left; padding-left: 5">&nbsp;</th> -->
                  
							</tr>
						

							<c:forEach var="avaHbpCode"
								items="${healthBenefitPlanForm.hbpCodeList}"
								varStatus="avaStatus">
								<c:set var="avaCounter" value="${avaStatus.count - 1}" />
								<c:set var="avaHbpDesc"
									value="${healthBenefitPlanForm.hbpDescList[avaCounter]}" />
								<c:set var="avaHbpEditable"
									value="${healthBenefitPlanForm.hbpEditableList[avaCounter]}" />

								<tr>
								
							<%-- the following section of code is to decide if the assign choice is enabled or not --%>
							<c:choose>
							<c:when test="${readOnlyUser}">
								<td scope="row" class="moduleValue" style="padding:5 5 5 15">								
								<html-el:checkbox
											title="${selectLabel} ${avaHbpDesc}"
											property="hbpInd[${avaCounter}]" disabled="${readOnlyUser}" styleId="hbpInd${avaCounter}"/>
								</td>
							</c:when>
							<c:otherwise>
									<c:choose>
									<c:when test="${assignHbp}">
										<td scope="row" class="moduleValue" style="padding:5 5 5 15">										
										<html-el:checkbox
											title="${selectLabel} ${avaHbpDesc}"
											property="hbpInd[${avaCounter}]" disabled="${avaHbpEditable}" styleId="hbpInd${avaCounter}"/>
										</td>
									</c:when>
									<c:otherwise>
										<td scope="row" class="moduleValue" style="padding:5 5 5 15">
										<html-el:hidden property="hbpInd[${avaCounter}]" />																				
										<html-el:checkbox
											title="${selectLabel} ${avaHbpDesc}"
											property="hbpInd[${avaCounter}]" disabled="true" styleId="hbpInd${avaCounter}"/>
										</td>
									</c:otherwise>
									</c:choose>	
							</c:otherwise>
							</c:choose>
							<%-- the end of the section of code deciding if the assign choice is enabled or not --%>			

									<td nowrap style="text-align: left;padding:5 5 5 15"
										class="moduleValue"><html-el:hidden
										property="hbpDesc[${avaCounter}]" /> 
										<fw:label property="hbpInd[${avaCounter}]" forId="hbpInd${avaCounter}">
											<c:out value="${healthBenefitPlanForm.hbpDescList[avaCounter]}" />
										</fw:label>
									</td>
								
							<html-el:hidden	property="hbpCode[${avaCounter}]" /> 
								</tr>

							</c:forEach>
					   </c:when>
                      <c:otherwise>
                            <th nowrap width="50%" class="moduleValue"
							style="text-align: left; padding-left: 20"><bean-el:message
							key="label.hbpNoneAvailable" /></th>
                      </c:otherwise>
					</c:choose>
					</thead>
					</table>
					</td>

				</tr>
		<%--</c:if>  --%>
		<tr>
			<td>
			<table width="100%" border="0" cellpadding="0" cellspacing="0"
				class="moduleShellTableBody">
				<tr>
					<c:choose>
						<c:when test="${readOnlyUser == true}">
							<td width="48%"><img alt="" src="../images/spacer.gif" /></td>
							<td><img alt="" src="../images/buttonEndLeft.gif" /></td>
							<td><html-el:submit property="methodName"
								style="width:50; vertical-align: top;" styleClass="buttonText">
								<bean-el:message key="button.cancel" />
							</html-el:submit></td>
							<td><img alt="" src="../images/buttonEndRight.gif" /></td>
							<td width="48%"><img alt="" src="../images/spacer.gif" /></td>
						</c:when>
						<c:otherwise>
							<td width="45%"><img alt="" src="../images/spacer.gif" /></td>
							<td><img alt="" src="../images/buttonEndLeft.gif" /></td>
							<td><html-el:submit property="methodName"
								style="width:50; vertical-align: top;" styleClass="buttonText">
								<bean-el:message key="button.update" />
							</html-el:submit></td>
							<td><img alt="" src="../images/buttonEndRight.gif" /></td>
							<td width="1%"><img alt="" src="../images/spacer.gif" /></td>
							<td><img alt="" src="../images/buttonEndLeft.gif" /></td>
							<td><html-el:submit property="methodName"
								style="width:50; vertical-align: top;" styleClass="buttonText">
								<bean-el:message key="button.clear" />
							</html-el:submit></td>
							<td><img alt="" src="../images/buttonEndRight.gif" /></td>
							<td width="1%"><img alt="" src="../images/spacer.gif" /></td>
							<td><img alt="" src="../images/buttonEndLeft.gif" /></td>
							<td><html-el:submit property="methodName"
								style="width:50; vertical-align: top;" styleClass="buttonText">
								<bean-el:message key="button.cancel" />
							</html-el:submit></td>
							<td><img alt="" src="../images/buttonEndRight.gif" /></td>
							<td width="45%"><img alt="" src="../images/spacer.gif" /></td>
						</c:otherwise>
					</c:choose>
				</tr>
				<tr>
					<td height="25"></td>
				</tr>
			</table>
			</td>
		</tr>
	</html-el:form>
</table>

