<%@ page contentType="text/html;charset=UTF-8" %>
<%@ taglib uri="/tags/displaytag" prefix="display" %>
<%@ taglib uri="/tags/esr-core" prefix="esrcore" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/fw" prefix="fw" %>

<c:set var="expandableSectionCollapsed" scope="page"><bean-el:message key="label.expandableSectionCollapsed"/></c:set>
<c:set var="isAddAPerson" value="false"></c:set>
<c:if test="${insuranceInfoForm.addAPerson == 'true'}">
    <c:set var="isAddAPerson" value="true"></c:set>
</c:if>

<table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShell" role="presentation">
  <tr>
    <td>
      <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTable" role="presentation">
        <tr>
          <td>
            <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead" role="presentation">
              <tr>
                <td class="moduleBlueBox"><img alt="" src="../images/spacer.gif" width="25" height="17"/></td>
                <td nowrap style="padding-left: 7px"><bean-el:message key="label.ins.facilityInsuraces"/></td>
                <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
              </tr>
            </table>
          </td>
        </tr>
        <tr>
          <td>

            <c:choose>
            <c:when test="${insuranceInfoForm.siteInsurancePresent}">

            <c:forEach var="siteIns" items="${insuranceInfoForm.siteInsurances}">

            <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
              <tr>
                <c:set var="reportSite" value="${siteIns.reportSite.stationNumber}" />
                <c:set var="reportSiteName" value="${siteIns.reportSite.name}" />
               	<c:set var="identifier" value="${siteIns.entityKey.keyValueAsString}" />  
                <c:choose>
                <c:when test="${siteIns.class.name == 'gov.va.med.esr.common.model.insurance.Medicare'}">
                  <c:set var="medicareText"><bean-el:message key="text.medicare"/></c:set>
                  <c:set var="insName" value="${medicareText} ${siteIns.groupName}" />
                </c:when>
                <c:otherwise>
                  <c:set var="insName" value="${siteIns.companyName}" />
                </c:otherwise>
                </c:choose>

                <td nowrap class="moduleLabel" style="padding: 5px; text-align: left;">
                  <fw:link href="." onclick="expandOrCollapse(id${identifier}, imgId${identifier}, hid${identifier}); return false">
                    <html-el:img alt="${expandableSectionCollapsed}" align="center" border="0" styleId="imgId${identifier}" src="../images/redArrowRight.gif"/><c:out value="${insName}" /> - <c:out value="${reportSiteName}" /> (#<c:out value="${reportSite}" />)
                  </fw:link>
                  <input name="hid<c:out value="${identifier}"/>" id="hid<c:out value="${identifier}"/>" type="hidden" value="true"/>
                </td>
              </tr>

            </table>

            <%-- Site Insurance  Expand/Collapse Section --%>
            <div id="id<c:out value="${identifier}"/>" class="expandCollapseBody">
            <table width="100%"  border="0" cellpadding="0" cellspacing="0" class="moduleShellTableBody" role="presentation">
              <tr>
                <td>
                  <table width="100%"  border="0" cellpadding="0" cellspacing="0" class="moduleShellTableBody" role="presentation">
                    <c:choose>
                    <c:when test="${siteIns.class.name == 'gov.va.med.esr.common.model.insurance.Medicare'}">
                    <tr>
                      <td width="170" class="label"><bean-el:message key="label.ins.medicare.claimnbr" />:</td>
                      <td width="220" class="value"><esrcore:displayValue name="siteIns" property="medicareClaimNumber"/></td>
                      <td width="250" class="label"><bean-el:message key="label.ins.medicare.nameoncard" />:</td>
                      <td class="value"><esrcore:displayValue name="siteIns" property="nameOnMedicareCard"/></td>
                    </tr>
                    </c:when>
                    <c:otherwise>
                    <tr>
                      <td width="170" class="label"><bean-el:message bundle="demog" key="label.ins.policynumber"/>:</td>
                      <td width="220" class="value"><esrcore:displayValue name="siteIns" property="policyNumber"/></td>
                      <td width="250" class="label"><bean-el:message bundle="demog" key="label.ins.typeofins"/>:</td>
                      <td class="value"><esrcore:displayValue name="siteIns" property="insurancePlan.planType.description"/></td>
                    </tr>
                    </c:otherwise>
                    </c:choose>

                    <tr>
                      <td width="170" class="darkLabel"><bean-el:message bundle="demog" key="label.ins.groupname"/>:</td>
                      <td width="220" class="darkValue"><esrcore:displayValue name="siteIns" property="groupName"/></td>
                      <td width="250" class="darkLabel"><bean-el:message bundle="demog" key="label.ins.groupnumber"/>:</td>
                      <td class="darkValue"><esrcore:displayValue name="siteIns" property="groupNumber"/></td>
                    </tr>

                    <c:choose>
                    <c:when test="${siteIns.class.name == 'gov.va.med.esr.common.model.insurance.Medicare'}">
                    <tr>
                      <c:choose>
                      <c:when test="${siteIns.partAEffectiveDate != null}">
                      <td width="170" class="label"><bean-el:message bundle="demog" key="label.ins.medicare.partaeffectivedate"/>:</td>
                      <td width="220" class="value"><esrcore:displayValue name="siteIns" property="partAEffectiveDate"/></td>
                      </c:when>
                      <c:when test="${siteIns.partBEffectiveDate != null}">
                      <td width="170" class="label"><bean-el:message bundle="demog" key="label.ins.medicare.partbeffectivedate"/>:</td>
                      <td width="220" class="value"><esrcore:displayValue name="siteIns" property="partBEffectiveDate"/></td>
                      </c:when>
                      <c:otherwise>
                      <td width="170" class="label"><bean-el:message bundle="demog" key="label.ins.medicare.effectivedate"/>:</td>
                      <td width="220" class="value">&nbsp;</td>
                      </c:otherwise>
                      </c:choose>
                      <td width="250" class="label" valign="top" nowrap>&nbsp;</td>
                      <td class="value" valign="top">&nbsp;</td>
                    </tr>
                    </c:when>
                    <c:otherwise>
                    <tr>
                      <td width="170" class="label"><bean-el:message bundle="demog" key="label.ins.nameofinsured"/>:</td>
                      <td width="220" class="value"><esrcore:displayValue name="siteIns" property="subscriber.name"/></td>
                      <td width="250" class="label"><bean-el:message bundle="demog" key="label.ins.insuredrelationshiptovet"/>:</td>
                      <td class="value"><esrcore:displayValue name="siteIns" property="subscriber.relationship"/></td>
                    </tr>
                    <tr>
                      <td width="170" class="darkLabel"><bean-el:message bundle="demog" key="label.ins.effectivedate"/>:</td>
                      <td width="220" class="darkValue"><esrcore:displayValue name="siteIns" property="policyEffectiveDate"/></td>
                      <td width="250" class="darkLabel"><bean-el:message bundle="demog" key="label.ins.planexpdate"/>:</td>
                      <td class="darkValue"><esrcore:displayDate name="siteIns" displayTime="true" dateProperty="policyExpirationDate"/></td>
                    </tr>
                    <tr>
                      <td width="170" class="label"><bean-el:message bundle="demog" key="label.ins.precertrequired"/>:</td>
                      <td width="220" class="value"><esrcore:displayValue name="siteIns" property="insurancePlan.precertificationRequired"/></td>
                      <td width="250" class="label" valign="top" nowrap><bean-el:message key="label.ins.preCertificationPhone" />:</td>
                      <td class="value" valign="top"><esrcore:displayValue name="insurance" property="preCertificationPhone"/></td>
                    </tr>
                    </c:otherwise>
                    </c:choose>

                    <tr>
                      <td width="170" class="darkLabel" valign="top"><bean-el:message bundle="demog" key="label.ins.address"/>:</td>
                      <td width="220" class="darkValue"><esrcore:displayValue name="siteIns" property="address"/></td>
                      <td width="250" class="darkLabel">&nbsp;</td>
                      <td class="darkValue">&nbsp;</td>
                    </tr>
                    <tr>
                      <td width="170" class="label"><bean-el:message bundle="demog" key="label.ins.carrierphone"/>:</td>
                      <td width="220" class="value"><esrcore:displayValue name="siteIns" property="businessPhone"/></td>
                      <td width="250" class="label"><bean-el:message key="label.ins.carrierfax" />:</td>
                      <td class="value"><esrcore:displayValue name="siteIns" property="fax"/></td>
                    </tr>
                  </table>
                </td>
              </tr>
            </table>
            </div>

            </c:forEach>

            </c:when>
            <c:otherwise>
            <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
              <tr>
                <td class="moduleLabel" style="padding:10px 0 10px 10px; text-align: left"><bean-el:message key="label.noDataAvailable"/></td>
              </tr>
            </table>
            </c:otherwise>
            </c:choose>

          </td>
        </tr>
      </table>
    </td>
  </tr>
</table>
  <html-el:hidden name="insuranceInfoForm" property="addAPerson"/>
