<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="/tags/esr-core" prefix="esrcore" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/fw" prefix="fw" %>
<%@ taglib uri="/tags/authz" prefix="auth" %>
<%@ page import='gov.va.med.esr.common.model.lookup.Capability' %>
<%@ page import="gov.va.med.esr.common.model.lookup.SensitivityChangeSource"%>
<%@ page import="gov.va.med.esr.common.model.lookup.VAFacility"%>
<%@ page import="gov.va.med.esr.common.model.lookup.EmploymentStatus" %>
<!-- permission based read only flags -->
<c:set var="roSensitivityFlag" scope="page" value="true"/>
<c:set var="roIdentityTraits" scope="page" value="true"/>
<c:set var="roDemographicInfo" scope="page" value="true"/>
<c:set var="sensitivityFlagVamcConstant"><%= SensitivityChangeSource.CODE_VAMC.getName() %></c:set>
<c:set var="hecFacilityConstant"><%= VAFacility.CODE_HEC.getName() %></c:set>
<c:set var="expandableSectionCollapsed" scope="page"><bean-el:message key="label.expandableSectionCollapsed"/></c:set>
<c:set var="mmddyyyyText" scope="page"><bean-el:message key="label.mmddyyyy"/></c:set>
<c:set var="countryEditable" scope="page" value="true"/>
<c:set var="nullCountryAllowed" scope="page" value="true"/>
<c:set var="zipCodeLookup" scope="page" value="true"/>
<script src="../scripts/ESR-Script.js" type="text/javascript"></script>

<%-- add a person flag --%>
<c:set var="isAddAPerson" value="false"></c:set>
<c:set var="displayAddAPersonRequiredFieldIndicator" scope="page" value="false"/>
<c:if test="${demographicPersonalForm.addAPerson == 'true'}">
    <c:set var="isAddAPerson" value="true"></c:set>
    <c:set var="displayAddAPersonRequiredFieldIndicator" value="true"></c:set>
    <c:set var="displayRequiredFieldsIndicator" scope="page" value="false"/>
</c:if>

<c:if test="${isAddAPerson && (demographicPersonalForm.appointmentRequestResponse == null || demographicPersonalForm.appointmentRequestResponse == '')}">
        <c:set var="displayEditableAppointmentReq" value="true"/>
</c:if>

<c:choose>
<c:when test="${displayAddAPersonRequiredFieldIndicator}">
<c:set var="requiredAddAPersonFlag"><%= Boolean.TRUE.toString() %></c:set>
<c:set var="requiredAddAPersonText"><bean-el:message key="label.required"/>,&nbsp;</c:set>
</c:when>
<c:otherwise>
<c:set var="requiredAddAPersonFlag"><%= Boolean.FALSE.toString() %></c:set>
<c:set var="requiredAddAPersonText"></c:set>
</c:otherwise>
</c:choose>

<auth:authorize ifAnyGranted="<%=Capability.EDIT_PATIENT_SENSITIVITY_FLAG.getName()%>">
  <c:set var="roSensitivityFlag" scope="page" value="false"/>
</auth:authorize>
<auth:authorize ifAnyGranted="<%=Capability.EDIT_IDENTITY_TRAIT_INFO.getName()%>">
  <c:set var="roIdentityTraits" scope="page" value="false"/>
</auth:authorize>
<auth:authorize ifAnyGranted="<%=Capability.EDIT_DEMOGRAPHIC_INFO.getName()%>">
  <c:set var="roDemographicInfo" scope="page" value="false"/>
</auth:authorize>
<!-- end of security related changes -->

<%-- Person Locked Check --%>
<c:set var="appData" value="${AppData}" scope="session"/>
<c:set var="personKey" value="SelectedPerson"/>
<c:set var="personLocked" value="${appData[personKey].personLocked}"/>
<c:if test="${personLocked}">
  <c:set var="roSensitivityFlag" scope="page" value="true"/>
  <c:set var="roIdentityTraits" scope="page" value="true"/>
  <c:set var="roDemographicInfo" scope="page" value="true"/>
</c:if>

<c:if test="${roDemographicInfo}">
  <c:set var="countryEditable" scope="page" value="false"/>
  <c:set var="zipCodeLookup" scope="page" value="false"/>
</c:if>

<c:set var="status_retired" scope="page" ><%=EmploymentStatus.CODE_RETIRED.getName()%></c:set>
<c:set var="status_unemployed" scope="page"><%=EmploymentStatus.CODE_NOT_EMPLOYED.getName()%></c:set>
<c:set var="status_unknown" scope="page"><%=EmploymentStatus.CODE_UNKNOWN.getName()%></c:set>

<c:set var="dodSet" scope="page" value="false" />

<%-- date of death editable flag --%>
<c:if test="${demographicPersonalForm.dodEditableFlag == 'true'}">
    <c:set var="isDODEditable" scope="request" value="true"></c:set>    
</c:if>
<c:if test="${demographicPersonalForm.showAllDeathSourcesFlag == 'true' && demographicPersonalForm.dodEditableFlag == 'true'}">
    <c:set var="showAllSources" scope="request" value="true"></c:set>    
</c:if>

<script type="text/javascript">
  // Perform all page initialization
  function onLoadInit()
  {
    //updateCountryFields();
    updateSensitivitySiteOfChange();
    enableDateOfRetirement(demographicPersonalForm, '<c:out value="${status_retired}"/>');
    dodTextUpdate(false);
}


  // Update the sensitivity flag site of change
  function updateSensitivitySiteOfChange()
  {
    updateSiteOfChange(demographicPersonalForm.sensitivityFlagSourceOfUpdate, '<c:out value="${sensitivityFlagVamcConstant}"/>',
        demographicPersonalForm.sensitivityFlagSiteOfUpdateEdit, demographicPersonalForm.sensitivityFlagSiteOfUpdateEdit2,
        '<c:out value="${hecFacilityConstant}"/>');
  }

function updateAppReqDate()
{
	response = document.getElementById("appReqResponse");
	date = document.getElementById("appReqDate");
	hiddenDate = document.getElementById("appReqDateHidden");
	var now = new Date();
	d = now.getDate();
	m = now.getMonth() +1;
	y = now.getYear();
	//now.format("MM/dd/yyyy");
	
	if(response.value == "1"){		
		date.value = m + '/' + d + '/' + y;		
		hiddenDate.value = m + '/' + d + '/' + y;
	}
	else{
		date.value ='';
		hiddenDate.value ='';
	}
}

function setElementVisible(element, visible) 
{
	if(visible==true) 
		element.style.display='';	
	else  
		element.style.display='none';
}

function dodTextUpdate(fromUI) 
{
	if (fromUI==false)
		{
			element = document.getElementById('deathNotificationSourceNOK')
			if( element != null ) setElementVisible(element,false);
		    
		    element = document.getElementById('deathNotificationSourceBlank')
			if( element != null ) setElementVisible(element,false);
		   
		    element = document.getElementById('deathNotificationSourceDB')
			if( element != null ) setElementVisible(element,true);
		}
	else
		{
		var deathDate = document.getElementById('idDateOfDeath');
		   
		  if( deathDate.value == null || deathDate.value == '')
			   {
				    element = document.getElementById('deathNotificationSourceNOK')
					if( element != null ) setElementVisible(element,false);
				    
				    element = document.getElementById('deathNotificationSourceBlank')
					if( element != null ) setElementVisible(element,true);
				   
				    element = document.getElementById('deathNotificationSourceDB')
					if( element != null ) setElementVisible(element,false);
				    
				}
		  else
			  {
			    alert('Death Notification Source will be set to SPOUSE/NOK/OTHER PERSON');
		   		
		   		element = document.getElementById('deathNotificationSourceDB')
				if( element != null ) setElementVisible(element,false);
			    
			    element = document.getElementById('deathNotificationSourceNOK')
				if( element != null ) setElementVisible(element,true);
			    
			    element = document.getElementById('deathNotificationSourceBlank')
				if( element != null ) setElementVisible(element,false);
			  }
		}
}

</script>

<table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShell">
<html-el:form action="/demographicPersonal" method="post">
  <%@ include file="/admin/csrfgentoken.jsp" %>
<c:set var="viewHistoricalPersonalData" scope="page"><bean-el:message key="text.viewHistoricalPersonalData"/></c:set>
<tr>
<td>
<table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTable">
<tr>
  <td>

    <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead">
      <tr>
        <td class="moduleBlueBox"><img alt=""  src="../images/spacer.gif" width="25" height="17"/></td>
        <td nowrap style="padding-left: 7px"><bean-el:message key="label.personal.personal"/></td>
        <td width="100%"><img alt="" src="../images/spacer.gif"></td>
        <td nowrap class="moduleBlueLink" style="padding: 1px 8px 1px 8px">
          <fw:link styleId="notesId" action="/demographicPersonal?methodName=goto508Notes">
            <bean-el:message key="text.508Notes"/>
          </fw:link> 
        </td>
        <td width="100%"><img alt="" src="../images/spacer.gif"></td>
        <td nowrap class="moduleBlueLink" style="padding: 1px 8px 1px 8px">
          <fw:link action="/demographicPersonalHistory?methodName=DISPLAY&amp;history=viewHistoricalPersonalData">
            <bean-el:message key="text.viewHistoricalPersonalData"/>
          </fw:link>
        </td>
      </tr>
    </table>
  </td>
</tr>
<tr>
<td>
<table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
<tr>
    <td colspan="2">
      <%@ include file="/tiles/common/instructionalText.jsp" %>
    </td>
</tr>
<tr>
  <td width="45%" class="moduleLabel" style="padding-top: 15px"><bean-el:message key="label.personal.sensitivityFlag"/>:</td>
  <td width="55%" class="moduleValue" style="padding-top: 15px">
  	<c:set var="sensitivityFlagYesText"><bean-el:message key="label.personal.sensitivityFlag"/>&nbsp;(<bean-el:message key="label.yes"/>)</c:set>
  	<c:set var="sensitivityFlagNoText"><bean-el:message key="label.personal.sensitivityFlag"/>&nbsp;(<bean-el:message key="label.no"/>)</c:set>
    <html-el:radio title="${sensitivityFlagYesText}" property="sensitivityFlag" value="true" styleId="txtSensitivityFlag_y" disabled="${roSensitivityFlag}"/><fw:label property="sensitivityFlag" forId="txtSensitivityFlag_y"><bean-el:message key="label.yes"/></fw:label>
    <html-el:radio title="${sensitivityFlagNoText}" property="sensitivityFlag" value="false" styleId="txtSensitivityFlag_n" disabled="${roSensitivityFlag}"/><fw:label property="sensitivityFlag" forId="txtSensitivityFlag_n"><bean-el:message key="label.no"/></fw:label>
  </td>
</tr>

<tr>
  <td class="moduleLabel"><fw:label property="sensitivityFlagSourceOfUpdate" forId="sensitivityFlagSourceOfUpdate"><bean-el:message key="label.personal.sensitivityChangeSource"/>:</fw:label></td>
  <td class="moduleValue">
  <c:set var="sensitivityChangeSourceText"><bean-el:message key="label.personal.sensitivityChangeSource"/></c:set>
    <html-el:select title="${sensitivityChangeSourceText}" styleId="sensitivityFlagSourceOfUpdate" onchange="updateSensitivitySiteOfChange()" styleClass="moduleEdit" property="sensitivityFlagSourceOfUpdate" disabled="${roSensitivityFlag}">
      <esrcore:options collection="gov.va.med.esr.common.model.lookup.SensitivityChangeSource" property="code" labelProperty="description"/>
    </html-el:select>
  </td>
</tr>
<tr>
  <td class="moduleLabel"><fw:label property="sensitivityFlagSiteOfUpdate" forId="sensitivityFlagSiteOfUpdateEdit"><bean-el:message key="label.personal.sensitivityChangeSite"/>:</fw:label></td>
  <td class="moduleValue">
  <c:set var="sensitivityChangeSiteText"><bean-el:message key="label.personal.sensitivityChangeSite"/></c:set>
    <html-el:select title="${sensitivityChangeSiteText}" styleId="sensitivityFlagSiteOfUpdateEdit" styleClass="moduleEdit" property="sensitivityFlagSiteOfUpdate" disabled="${roSensitivityFlag}">
      <esrcore:options collection="gov.va.med.esr.common.model.lookup.VAFacility" property="code" labelProperty="description"/>
    </html-el:select>
    <html-el:hidden name="demographicPersonalForm" styleId="sensitivityFlagSiteOfUpdateEdit2" property="sensitivityFlagSiteOfUpdate"></html-el:hidden>
  </td>
</tr>
<tr>
  <td class="moduleLabel"><fw:label property="degree" forId="txtDegree"><bean-el:message key="label.personal.degree"/>:</fw:label></td>
  <c:set var="degreeText"><bean-el:message key="label.personal.degree"/></c:set>
  <td class="moduleValue"><html-el:text title="${degreeText}" styleClass="moduleEdit" property="degree" styleId="txtDegree" size="15" maxlength="10" readonly="${roDemographicInfo}"/></td>
</tr>

<!--  TODO -->

<c:choose>
<c:when test="${isAddAPerson}">
<tr>
<td width="100%" colspan="2">
<table width="100%" border="1" bordercolor="C64044" rules="none" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
<tr>
	<td width="45%" class="moduleLabel"><fw:label property="otherFirstNames" forId="txtOtherFirstNames"><bean-el:message key="label.personal.otherFirstNames" />:</fw:label></td>
	<td width="55%" id="otherFirstNamesEdit" class="moduleValue">
		<c:set var="otherFirstNamesText"><bean-el:message key="label.personal.otherFirstNames"/></c:set>
	<html-el:text title="${otherFirstNamesText}" styleClass="moduleEdit" property="otherFirstNames" styleId="txtOtherFirstNames" size="40" maxlength="40" /></td>
</tr>
<tr>
	<td  class="moduleLabel"><fw:label property="otherLastNames" forId="txtOtherLastNames"><bean-el:message key="label.personal.otherLastNames" />:</fw:label></td>
	<td id="otherLastNamesEdit" class="moduleValue">
		<c:set var="otherLastNamesText"><bean-el:message key="label.personal.otherLastNames"/></c:set>
	<html-el:text title="${otherLastNamesText}" styleClass="moduleEdit" styleId="txtOtherLastNames" property="otherLastNames" size="40" maxlength="40" /></td>
</tr>
<tr>
	<td class="moduleLabel"><fw:label property="otherSsns" forId="txtOtherSsns"><bean-el:message key="label.personal.otherSsns" />:</fw:label></td>
	<td id="otherSsnsEdit" class="moduleValue">
		<c:set var="otherSsnsText"><bean-el:message key="label.personal.otherSsns"/></c:set>
	<html-el:text title="${otherSsnsText}" styleClass="moduleEdit" property="otherSsns" styleId="txtOtherSsns" size="20"
										maxlength="11" onkeypress="return validateSSN(event)" onkeyup="formatSSN(event)"
										onblur="formatSSN(event)" /></td>
</tr>
</table>
</td>
</c:when>

<c:otherwise>
<tr>
  <td class="moduleLabel"><fw:label property="otherNames" forId="txtOtherNames"><bean-el:message key="label.personal.otherNames"/>:</fw:label></td>
  <td title="<bean-el:message key="label.personal.otherNames"/>" class="moduleValue">
    <esrcore:displayValue name="demographicPersonalForm" property="otherNames"/>
    <html-el:hidden name="demographicPersonalForm" styleId="txtOtherNames" property="otherNames"></html-el:hidden>
  </td>
</tr>

<tr>
  <td class="moduleLabel"><fw:label property="otherSsns"><bean-el:message key="label.personal.otherSsns"/>:</fw:label></td>
  <td title="<bean-el:message key="label.personal.otherSsns"/>" class="moduleValue">
    <esrcore:displayValue name="demographicPersonalForm" property="otherSsns"/>
    <html-el:hidden name="demographicPersonalForm" styleId="otherSsns" property="otherSsns"></html-el:hidden>
  </td>
</tr>
</c:otherwise>
</c:choose>
<html-el:hidden name="demographicPersonalForm" styleId="displayEditDOD" property="dodEditableFlag"></html-el:hidden>
<c:choose>
    <c:when test="${showAllSources}">
		<tr>

		  <td class="moduleLabel" nowrap><fw:label property="dateOfDeath" forId="idDateOfDeath"><bean-el:message key="label.personal.dateOfDeath"/>:</fw:label></td>
		  <c:set var="dateOfDeathText"><bean-el:message key="label.personal.dateOfDeath"/>&nbsp;<c:out value="${mmddyyyyText}"/></c:set>
		  <td class="moduleValue"><html-el:text title="${dateOfDeathText}" styleId="idDateOfDeath" styleClass="moduleEdit" property="dateOfDeath" size="20" maxlength="21" readonly="${roDemographicInfo}" 
		      onchange="dodTextUpdate(true)" />&nbsp;<bean-el:message key="label.mmddyyyy"/></td>
		</tr>	
		<tr>
		  <td  class="moduleLabel"  id="deathNotificationSource" >		     
		     <fw:label property="deathNotificationSource" forId="deathNotificationSourceId"><bean-el:message key="label.personal.deathNotificationSource"/>:</fw:label>
		  </td>
		  <td  class="moduleValue"  id="deathNotificationSourceDB" style="display:none">
		 	 <esrcore:displayValue name="demographicPersonalForm" property="deathNotificationSourceDesc"/>
		    <c:set var="deathNotificationSourceText"><bean-el:message key="label.personal.deathNotificationSource"/></c:set>
		 </td>
	   	<td  class="moduleValue" id="deathNotificationSourceNOK" style="display:none">
		    <c:set var="deathNotificationSourceText"><bean-el:message key="label.personal.deathNotificationSource"/></c:set>
		    <bean-el:message key="label.personal.deathNotificationSourceNOK"/>
		    <html-el:hidden name="demographicPersonalForm" styleId="deathNotificationSourceid" property="deathNotificationSource"></html-el:hidden>
		 </td> 
		 <td  class="moduleValue" id="deathNotificationSourceBlank" style="display:none">
		    <html-el:hidden name="demographicPersonalForm" styleId="deathNotificationSourceid" property="deathNotificationSource"></html-el:hidden>
		 </td> 
		</tr>
		<tr>
		  <td class="moduleLabel">
		  	<fw:label property="deathNotificationSite" forId="deathNotificationSiteId" >
		  		<bean-el:message key="label.personal.deathNotificationSite"/>:
		  	</fw:label>
		  </td>
		  <td class="moduleValue">
		    <c:set var="deathNotificationSiteText"><bean-el:message key="label.personal.deathNotificationSite"/></c:set>
		    <html-el:select title="${deathNotificationSiteText}" styleClass="moduleEdit" styleId="deathNotificationSiteId" property="deathNotificationSite" disabled="${roDemographicInfo}">
		      <html-el:option value=""><bean-el:message key="label.select"/></html-el:option>
	        <esrcore:options collection="gov.va.med.esr.ui.common.beans.DeathNotificationSite" property="code" labelProperty="siteNumberAndName"/>
		    </html-el:select>
		</tr>
		<tr>
		  <td class="moduleLabel"><fw:label property="dateOfDeathReport" forId="dateOfDeathReportId" ><bean-el:message key="label.personal.dateOfDeathReport"/>:</fw:label></td>
		  <td title="<bean-el:message key="label.personal.dateOfDeathReport"/>" class="moduleValue">
		    <esrcore:displayValue name="demographicPersonalForm" property="dateOfDeathReport"/>
		    <html-el:hidden name="demographicPersonalForm" styleId="dateOfDeathReportId" property="dateOfDeathReport"></html-el:hidden>
		    <html-el:hidden name="demographicPersonalForm" styleId="dateOfDeathVerificationId" property="dodVerificationIndicator" value="true"></html-el:hidden>
		  </td>
		</tr>	    
    </c:when>
	<c:when test="${isDODEditable}">
		<tr>
		  <td class="moduleLabel" nowrap><fw:label property="dateOfDeath" forId="idDateOfDeath"><bean-el:message key="label.personal.dateOfDeath"/>:</fw:label></td>
		  <c:set var="dateOfDeathText"><bean-el:message key="label.personal.dateOfDeath"/>&nbsp;<c:out value="${mmddyyyyText}"/></c:set>
		  <td class="moduleValue"><html-el:text title="${dateOfDeathText}" styleId="idDateOfDeath" styleClass="moduleEdit" property="dateOfDeath" 
		      onchange="dodTextUpdate(true)" size="20" maxlength="21" readonly="${roDemographicInfo}"/>&nbsp;<bean-el:message key="label.mmddyyyy"/></td>
		</tr>	
		<tr>
		  <td  class="moduleLabel"  id="deathNotificationSource" >		     
		     <fw:label property="deathNotificationSource" forId="deathNotificationSourceId"><bean-el:message key="label.personal.deathNotificationSource"/>:</fw:label>
		  </td>
		  <td  class="moduleValue"  id="deathNotificationSourceDB" >
		 	 <esrcore:displayValue name="demographicPersonalForm" property="deathNotificationSourceDesc"/>
		    <c:set var="deathNotificationSourceText"><bean-el:message key="label.personal.deathNotificationSource"/></c:set>
		 </td>
	   	<td  class="moduleValue" id="deathNotificationSourceNOK" style="display:none">
		    <c:set var="deathNotificationSourceText"><bean-el:message key="label.personal.deathNotificationSource"/></c:set>
		    <bean-el:message key="label.personal.deathNotificationSourceNOK"/>
		    <html-el:hidden name="demographicPersonalForm" styleId="deathNotificationSourceid" property="deathNotificationSource"></html-el:hidden>
		 </td> 
		 <td  class="moduleValue" id="deathNotificationSourceBlank" style="display:none">
		    <html-el:hidden name="demographicPersonalForm" styleId="deathNotificationSourceid" property="deathNotificationSource"></html-el:hidden>
		 </td> 
		</tr>
		<tr>
		  <td class="moduleLabel"><fw:label property="deathNotificationSite" forId="deathNotificationSiteId" ><bean-el:message key="label.personal.deathNotificationSite"/>:</fw:label></td>
		  <td class="moduleValue">
		    <c:set var="deathNotificationSiteText"><bean-el:message key="label.personal.deathNotificationSite"/></c:set>
		    <html-el:select title="${deathNotificationSiteText}" styleClass="moduleEdit" styleId="deathNotificationSiteId" property="deathNotificationSite" disabled="${roDemographicInfo}">
		      <html-el:option value=""><bean-el:message key="label.select"/></html-el:option>
	        <esrcore:options collection="gov.va.med.esr.ui.common.beans.DeathNotificationSite" property="code" labelProperty="siteNumberAndName"/>
		    </html-el:select>
		</tr>
		<tr>
		  <td class="moduleLabel"><fw:label property="dateOfDeathReport" forId="dateOfDeathReportId" ><bean-el:message key="label.personal.dateOfDeathReport"/>:</fw:label></td>
		  <td title="<bean-el:message key="label.personal.dateOfDeathReport"/>" class="moduleValue">
		    <esrcore:displayValue name="demographicPersonalForm" property="dateOfDeathReport"/>
		    <html-el:hidden name="demographicPersonalForm" styleId="dateOfDeathReportId" property="dateOfDeathReport"></html-el:hidden>
		    <html-el:hidden name="demographicPersonalForm" styleId="dateOfDeathVerificationId" property="dodVerificationIndicator" value="true"></html-el:hidden>
		  </td>
		</tr>	    
    </c:when>
    <c:otherwise>    
    	<tr>
		  <td class="moduleLabel" nowrap><fw:label property="dateOfDeath" forId="idDateOfDeath"><bean-el:message key="label.personal.dateOfDeath"/>:</fw:label></td>
		  <c:set var="dateOfDeathText"><bean-el:message key="label.personal.dateOfDeath"/>&nbsp;<c:out value="${mmddyyyyText}"/></c:set>
		  <td class="moduleValue"><esrcore:displayValue name="demographicPersonalForm" property="dateOfDeath" />&nbsp;<bean-el:message key="label.mmddyyyy"/></td>
		</tr>
    	<tr>
    	
		  <td  class="moduleLabel">	        
		     <fw:label property="deathNotificationSource" forId="deathNotificationSourceId"><bean-el:message key="label.personal.deathNotificationSource"/>:</fw:label>
		  </td>
		  <td class="moduleValue">
		    <c:set var="deathNotificationSourceText"><bean-el:message key="label.personal.deathNotificationSource"/></c:set>
		    <esrcore:displayValue  name="demographicPersonalForm" property="deathNotificationSourceDesc" />				    
		</tr>
		<tr>
		  <td class="moduleLabel"><fw:label property="deathNotificationSite" forId="deathNotificationSiteId" ><bean-el:message key="label.personal.deathNotificationSite"/>:</fw:label></td>
		  <td class="moduleValue">
		    <c:set var="deathNotificationSiteText"><bean-el:message key="label.personal.deathNotificationSite"/></c:set>
		    <esrcore:displayValue name="demographicPersonalForm" property="deathNotificationSiteName" />		      
		</tr>
		<tr>
		  <td class="moduleLabel"><fw:label property="dateOfDeathReport" forId="dateOfDeathReportId" ><bean-el:message key="label.personal.dateOfDeathReport"/>:</fw:label></td>
		  <td title="<bean-el:message key="label.personal.dateOfDeathReport"/>" class="moduleValue">
		    <esrcore:displayValue name="demographicPersonalForm" property="dateOfDeathReport"/>
		    <html-el:hidden name="demographicPersonalForm" styleId="dateOfDeathReportId" property="dateOfDeathReport"></html-el:hidden>
		    <html-el:hidden name="demographicPersonalForm" styleId="dateOfDeathVerificationId" property="dodVerificationIndicator" value="false"></html-el:hidden>
		    <html-el:hidden name="demographicPersonalForm" styleId="deathNotificationSiteId_h" property="deathNotificationSite" ></html-el:hidden>
		    <html-el:hidden name="demographicPersonalForm" styleId="deathNotificationSourceId_h" property="deathNotificationSource"></html-el:hidden>
		    <html-el:hidden name="demographicPersonalForm" styleId="dateOfDeathId_h" property="dateOfDeath"></html-el:hidden>
		  </td>
		</tr> 
    </c:otherwise>  
</c:choose> 
 <!-- ---------------------------------------------------------------- -->
 <!-- New PF code to display list of PF with an add button. -->
<jsp:include page="demographicPreferredFacility.jsp" flush="true" />

<!-- ---------------------------------------------------------------- -->

<!-- ---------------------------------------------------------------- -->
 <!-- New PF code to display list of PF with an add button. -->
<jsp:include page="demographicPreferredLanguage.jsp" flush="true" />

<!-- ---------------------------------------------------------------- -->

  <td class="moduleLabel"><fw:label property="claimFolderNumber" forId="claimFolderNumberId" ><bean-el:message key="label.personal.claimFolderNumber"/>:</fw:label></td>

  <td class="moduleValue">
    <table width="20%" border="0" cellpadding="0" cellspacing="0" role="presentation">
      <tr>
        <td>
          <c:set var="claimFolderNumberText"><bean-el:message key="label.personal.claimFolderNumber"/></c:set>
          <html-el:text title="${claimFolderNumberText}" styleClass="moduleEdit" styleId="claimFolderNumberId" property="claimFolderNumber" readonly="${roDemographicInfo}"/>
          <html-el:hidden name="demographicPersonalForm" property="ssn"></html-el:hidden>
        </td>
        <td>&nbsp;&nbsp;</td>
        <c:if test="${not roDemographicInfo}">
          <td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
          <td class="buttonText"><html-el:submit property="methodName" onclick="javascript:copyFieldData(ssn,claimFolderNumber); return false;"
                                                 style="width:70; vertical-align: top;" styleClass="buttonText"><bean-el:message key="button.sameAsSSN"/></html-el:submit></td>
          <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
        </c:if>
        <td width="100%"><img alt=""  src="../images/spacer.gif" width="1" height="1"/></td>
      </tr>
    </table>
  </td>
  <td class="moduleValue">
  </td>
</tr>
<tr>
  <td class="moduleLabel"><fw:label property="claimFolderLocation" forId="claimFolderLocationId"><bean-el:message key="label.personal.claimFolderLocation"/>:</fw:label></td>
  <td class="moduleValue">
    <c:set var="claimFolderLocationText"><bean-el:message key="label.personal.claimFolderLocation"/></c:set>
    <html-el:select title="${claimFolderLocationText}" styleClass="moduleEdit" styleId="claimFolderLocationId" property="claimFolderLocation" disabled="${roDemographicInfo}">
      <html-el:option value="">
        <bean-el:message key="label.select"/>
      </html-el:option>
      <esrcore:options collection="gov.va.med.esr.ui.common.beans.ClaimFolderLocation" property="code" labelProperty="siteNumberAndName"/>
    </html-el:select>
</tr>
<tr>
  <td class="moduleLabel"><fw:label property="emergencyResponse" forId="emergencyResponseTextId"><bean-el:message key="label.addresses.emergencyResponse"/>:</fw:label></td>
  <td class="moduleValue">
    <esrcore:setLookup var="emergencyResponseList" className="gov.va.med.esr.common.model.lookup.EmergencyResponse"/>
    <table border="0" cellpadding="0" cellspacing="0" role="presentation">
      <c:forEach var="item" items="${emergencyResponseList}">
        <c:set var="emergencyResponseText"><bean-el:message key="label.addresses.emergencyResponse"/>&nbsp;(<c:out value="${item.description}"/>)</c:set>
        <tr><td><html-el:multibox title="${emergencyResponseText}" property="emergencyResponse" styleId="emergencyResponseTextId" value="${item.code}" disabled="${roDemographicInfo}"/></td><td class="moduleValue" width="99%"><c:out value="${item.description}"/></td>
        </tr>
      </c:forEach>
    </table>
  </td>
</tr>
<tr>
  <td class="moduleLabel"><fw:label property="userEnrolleeValidthroughDate" forId="userEnrolleeValidthroughDateId" ><bean-el:message key="label.personal.userEnrolleeValidthroughDate"/>:</fw:label></td>
  <td title="<bean-el:message key="label.personal.userEnrolleeValidthroughDate"/>"  class="moduleValue">
    <esrcore:displayValue name="demographicPersonalForm" property="userEnrolleeValidthroughDate"/>
    <html-el:hidden name="demographicPersonalForm" styleId="userEnrolleeValidthroughDateId" property="userEnrolleeValidthroughDate"></html-el:hidden>
  </td>
</tr>
<tr>
  <td class="moduleLabel"><fw:label property="userEnrolleeSite" forId="userEnrolleeSiteId" ><bean-el:message key="label.personal.userEnrolleeSite"/>:</fw:label></td>
  <td title="<bean-el:message key="label.personal.userEnrolleeSite"/>"  class="moduleValue">
    <esrcore:displayValue name="demographicPersonalForm" property="userEnrolleeSite"/>
    <html-el:hidden name="demographicPersonalForm" styleId="userEnrolleeSiteId" property="userEnrolleeSite"></html-el:hidden>
  </td>
</tr>

<c:choose>
<c:when test="${displayEditableAppointmentReq}">

<tr>
  <td class="moduleLabel"><fw:label property="appointmentRequestDate" forId="appReqDate" ><bean-el:message key="label.personal.appointmentRequestDate"/>:</fw:label></td>
  <td title="<bean-el:message key="label.personal.appointmentRequestDate"/>" class="moduleValue">    
    <c:set var="appointmentReqDate"><bean-el:message key="label.personal.appointmentRequestDate"/></c:set>
    <html-el:text styleId="appReqDate" title="${appointmentReqDate}" property="appointmentRequestDate" disabled= "true" styleClass="moduleEdit" />
    <fw:label property="appointmentRequestDate" forId="appReqDateHidden"><span style="display:none">hiddenAppointmentReqDate</span></fw:label>
    <html-el:hidden styleId="appReqDateHidden" name="demographicPersonalForm" property="appointmentRequestDate"></html-el:hidden>
  </td>
</tr>
<tr>
	<td class="moduleLabel"><fw:label required="${requiredAddAPersonFlag}" property="appointmentRequestResponse" forId="appReqResponse"><bean-el:message key="label.personal.appointmentRequestResponse"/>:</fw:label></td>
    <td class="moduleValue">
       <c:set var="appReqText"><bean-el:message key="label.personal.appointmentRequestResponse"/></c:set>
       <html-el:select title="${requiredAddAPersonText}${appReqText}" styleId="appReqResponse" onchange="updateAppReqDate()" styleClass="moduleEdit" 
       		property="appointmentRequestResponse" >
       		<html-el:option value=""><bean-el:message key="label.select"/></html-el:option>            
            <html-el:option value="0">No</html-el:option> 
            <html-el:option value="1">Yes</html-el:option>        
       </html-el:select>
       <html-el:hidden name="demographicPersonalForm" property="appointmentRequestResponse"></html-el:hidden>
    </td>  
</tr>

</c:when>
<c:otherwise>
<tr>
  <td class="moduleLabel"><fw:label property="appointmentRequestDate" forId="appointmentRequestDateTxt"><bean-el:message key="label.personal.appointmentRequestDate"/>:</fw:label></td>
  <td title="<bean-el:message key="label.personal.appointmentRequestDate"/>" class="moduleValue">
    <esrcore:displayValue name="demographicPersonalForm" property="appointmentRequestDate"/>
    <html-el:hidden name="demographicPersonalForm" styleId="appointmentRequestDateTxt" property="appointmentRequestDate"></html-el:hidden>
  </td>
</tr>
<tr>
  <td class="moduleLabel"><fw:label property="appointmentRequestResponse" forId="apptReqResp"><bean-el:message key="label.personal.appointmentRequestResponse"/>:</fw:label></td>
  <td title="<bean-el:message key="label.personal.appointmentRequestResponse"/>" class="moduleValue">
    <esrcore:displayValue name="demographicPersonalForm" property="appointmentRequestResponse"/>
    <html-el:hidden name="demographicPersonalForm" styleId="apptReqResp" property="appointmentRequestResponse"></html-el:hidden>
  </td>
</tr>
</c:otherwise>
</c:choose>

<tr>
  <td class="moduleLabel"><fw:label property="benefitAppliedFor" forId="benefitAppliedForId" ><bean-el:message key="label.personal.benefitAppliedFor"/>:</fw:label></td>
   <td class="moduleValue">
    <c:set var="benefitAppliedForText"><bean-el:message key="label.personal.benefitAppliedFor"/></c:set>
    <html-el:select title="${benefitAppliedForText}" styleId="benefitAppliedForId" styleClass="moduleEdit" property="benefitAppliedFor" disabled="${not isAddAPerson}">
      <html-el:option value=""><bean-el:message key="label.select"/></html-el:option>
      <esrcore:options collection="gov.va.med.esr.common.model.lookup.BenefitType" property="code" labelProperty="name"/>
    </html-el:select>
  </td>
</tr>

<tr>
  <td class="moduleLabel"><fw:label required="${requiredAddAPersonFlag}" property="maritalStatus" forId="maritalStatusId"><bean-el:message key="label.personal.maritalStatus"/>:</fw:label></td>
  <td class="moduleValue">
    <c:set var="maritalStatusText"><bean-el:message key="label.personal.maritalStatus"/></c:set>
    <html-el:select title="${requiredAddAPersonText}${maritalStatusText}" styleClass="moduleEdit" styleId="maritalStatusId" property="maritalStatus" disabled="${editFieldFlag}">
      <html-el:option value=""><bean-el:message key="label.select"/></html-el:option>
      <esrcore:options collection="gov.va.med.esr.ui.common.beans.MaritalStatus" property="code" labelProperty="name"/>
    </html-el:select>
  </td>
</tr>

 <tr>
       <td class="moduleLabel"><fw:label property="religion" forId="religionId">
       <bean-el:message key="label.personal.religion" />:</fw:label></td>
       <td class="moduleValue">
         <c:set var="religionText"><bean-el:message key="label.personal.religion"/></c:set>
         <html-el:select title="${religionText}" styleClass="moduleEdit" property="religion" styleId="religionId" disabled="${not isAddAPerson}" >
         <html-el:option value=""><bean-el:message key="label.select" /></html-el:option>
         <esrcore:options collection="gov.va.med.esr.common.model.lookup.Religion" property="code" labelProperty="name"/>
         </html-el:select>
      </td>
</tr>

<c:choose>
<c:when test="${isAddAPerson}">	
<tr>
	<td class="moduleLabel"><fw:label property="fathersLastName" forId="fathersLastNameId" ><bean-el:message key="label.personal.fathersLastName" />:</fw:label></td>
	<td id="fathersLastNameEdit" class="moduleValue">
		<c:set var="fathersLastNameText"><bean-el:message key="label.personal.fathersLastName"/></c:set>
	<html-el:text title="${fathersLastNameText}" styleClass="moduleEdit" styleId="fathersLastNameId" property="fathersLastName" size="40" maxlength="40" /></td>
</tr>

<tr>
	<td class="moduleLabel"><fw:label property="fathersFirstName" forId="fathersFirstNameId"><bean-el:message key="label.personal.fathersFirstName" />:</fw:label></td>
	<td id="fathersFirstNameEdit" class="moduleValue">
		<c:set var="fathersFirstNameText"><bean-el:message key="label.personal.fathersFirstName"/></c:set>
	<html-el:text title="${fathersFirstNameText}" styleClass="moduleEdit" styleId="fathersFirstNameId" property="fathersFirstName" size="40" maxlength="40"  /></td>
</tr>

<tr>
	<td class="moduleLabel"><fw:label property="mothersLastName" forId="mothersLastNameId"><bean-el:message key="label.personal.mothersLastName" />:</fw:label></td>
	<td id="mothersLastNameEdit" class="moduleValue">
		<c:set var="mothersLastNameText"><bean-el:message key="label.personal.mothersLastName"/></c:set>
	<html-el:text title="${mothersLastNameText}" styleClass="moduleEdit" styleId="mothersLastNameId" property="mothersLastName" size="40" maxlength="40" /></td>
</tr>

<tr>
	<td class="moduleLabel"><fw:label property="mothersFirstName" forId="mothersFirstNameId" ><bean-el:message key="label.personal.mothersFirstName" />:</fw:label></td>
	<td id="mothersFirstNameEdit" class="moduleValue">
		<c:set var="mothersFirstNameText"><bean-el:message key="label.personal.mothersFirstName"/></c:set>
	<html-el:text title="${mothersFirstNameText}" styleClass="moduleEdit" styleId="mothersFirstNameId" property="mothersFirstName" size="40" maxlength="40"  /></td>
</tr>
</c:when>
<c:otherwise>
<tr>
  <td class="moduleLabel"><fw:label property="fathersName" forId="idFathersName" ><bean-el:message key="label.personal.fathersName"/>:</fw:label></td>
  <td title="<bean-el:message key="label.personal.fathersName"/>" class="moduleValue">
    <esrcore:displayValue name="demographicPersonalForm" property="fathersName"/>
    <html-el:hidden name="demographicPersonalForm" styleId="idFathersName" property="fathersName"></html-el:hidden>
  </td>
</tr>

<tr>
  <td class="moduleLabel"><fw:label property="mothersName" forId="idMothersName"><bean-el:message key="label.personal.mothersName"/>:</fw:label></td>
  <td title="<bean-el:message key="label.personal.mothersName"/>" class="moduleValue">
    <esrcore:displayValue name="demographicPersonalForm" property="mothersName"/>
    <html-el:hidden name="demographicPersonalForm" styleId="idMothersName" property="mothersName"></html-el:hidden>
  </td>
</tr>

</c:otherwise>
</c:choose>
<tr>
  <td class="moduleLabel"><fw:label property="employmentStatus" forId="idEmploymentStatus"><bean-el:message key="label.personal.employmentStatus"/>:</fw:label></td>
  <td class="moduleValue">
    <c:set var="employmentStatusText"><bean-el:message key="label.personal.employmentStatus"/></c:set>
    <html-el:select title="${employmentStatusText}" styleClass="moduleEdit" styleId="idEmploymentStatus" property="employmentStatus" disabled="${roDemographicInfo}" onchange="updateEmploymentFields(demographicPersonalForm, ${status_retired})">
      <html-el:option value=""><bean-el:message key="label.select"/></html-el:option>
      <esrcore:options collection="gov.va.med.esr.common.model.lookup.EmploymentStatus" property="code" labelProperty="description"/>
    </html-el:select>
     <fw:label property="onFileEmploymentStatus" forId="idOnFileEmploymentStatus"><span style="display:none">onFileEmploymentStatus</span></fw:label>
     <html-el:hidden name="demographicPersonalForm" styleId="idOnFileEmploymentStatus" property="onFileEmploymentStatus"></html-el:hidden>
   </td>
</tr>

<!--  TODO NotEmployed following fields should be disabled -->
<tr>
        <td width="45%" class="moduleLabel"></td>
        <td width="55%" class="moduleValue"></td>
 </tr>

<tr>
  <td class="moduleLabel"><fw:label property="employerName" forId="idEmployerNameHidden" ><bean-el:message key="label.personal.employerName"/>:</fw:label></td>
  <td id="employerNameEdit" class="moduleValue">
  <c:set var="employerNameText"><bean-el:message key="label.personal.employerName"/></c:set>    
	<html-el:text title="${employerNameText}" styleClass="moduleEdit" styleId="idEmployerNameHidden" property="employerName" size="40" maxlength="40" readonly="${not isAddAPerson}" />
  </td>
  
</tr>

<tr>
  <td class="moduleLabel"><fw:label property="occupation" forId="occupationId"><bean-el:message key="label.personal.occupation"/>:</fw:label></td>
  <td id="occupationEdit" class="moduleValue">
  <c:set var="occupationText"><bean-el:message key="label.personal.occupation"/></c:set>    
	<html-el:text title="${occupationText}" styleClass="moduleEdit" property="occupation" styleId="occupationId" size="40" maxlength="40" readonly="${not isAddAPerson}" />
  </td>
</tr>

<c:choose>
<c:when test="${isAddAPerson}">
<tr>
 <td colspan="2" style="padding-top: 10px"><%@ include file="/tiles/common/addressForm.jsp" %></td>
</tr>
</c:when>
<c:otherwise>
<tr  valign="top">
  <td class="moduleLabel"><fw:label property="employerAddress" forId="idEmployerAddressHidden"><bean-el:message key="label.personal.employerAddress"/>:</fw:label></td>
  <td title="<bean-el:message key="label.personal.employerAddress"/>" class="moduleValue">
    <esrcore:displayValue name="demographicPersonalForm" property="employerAddress"/>
    <html-el:hidden styleId="idEmployerAddressHidden" property="employerAddress"></html-el:hidden>
  </td>
</tr>
</c:otherwise>
</c:choose>
<tr>
  <td class="moduleLabel"><fw:label property="employerPhone" forId="idEmployerPhoneHidden"><bean-el:message key="label.personal.employerPhone"/>:</fw:label></td>
  <td id="employerPhoneEdit" class="moduleValue">
  <c:set var="employerPhoneText"><bean-el:message key="label.personal.employerPhone"/></c:set>    
	<html-el:text title="${employerPhoneText}" styleClass="moduleEdit" styleId="idEmployerPhoneHidden" property="employerPhone" size="40" maxlength="15" readonly="${not isAddAPerson}" />
  </td>
</tr>

<tr>
  <td class="moduleLabel"><fw:label property="dateOfRetirement" forId="idDateOfRetirement"><bean-el:message key="label.personal.dateOfRetirement"/>:</fw:label></td>
  <td  class="moduleValue">
  	<c:set var="dateOfRetirementText"><bean-el:message key="label.personal.dateOfRetirement"/>&nbsp;<c:out value="${mmddyyyyText}"/></c:set>
  	<html-el:text title="${dateOfRetirementText}" styleId="idDateOfRetirement" styleClass="moduleEdit" property="retirementDate" size="20" maxlength="21"/>&nbsp;<bean-el:message key="label.mmddyyyy"/>
  	<html-el:hidden styleId="idDateOfRetirementHidden"   property="retirementDate"></html-el:hidden>	
  </td>
</tr>

<%-- CCR 11008
<c:if test="${isAddAPerson == 'true'}">
<tr>
		<td class="moduleLabel"><fw:label property="needCareDueToInjury"><bean-el:message key="label.personal.needCareDueToInjury"/>:</fw:label></td>
        <td class="moduleValue">
           <c:forEach var="item" items="${yesNoList}">
           <c:set var="needCareDueToInjuryText"><bean-el:message key="label.personal.needCareDueToInjury"/>&nbsp;(<bean-el:message key="${item.label}" />)</c:set>
           <html-el:radio title="${needCareDueToInjuryText}" styleId="idNeedCareDueToInjury_${item.value}" name="demographicPersonalForm" property="needCareDueToInjury" value="${item.value}" disabled="${not isAddAPerson}" /><bean-el:message key="${item.label}" />
           </c:forEach>
       </td>
<tr>

<tr>
		<td class="moduleLabel"><fw:label property="needCareDueToAccident"><bean-el:message key="label.personal.needCareDueToAccident"/>:</fw:label></td>
        <td class="moduleValue">
           <c:forEach var="item" items="${yesNoList}">
           <c:set var="needCareDueToAccidentText"><bean-el:message key="label.personal.needCareDueToAccident"/>&nbsp;(<bean-el:message key="${item.label}" />)</c:set>
           <html-el:radio title="${needCareDueToAccidentText}" styleId="idNeedCareDueToAccident_${item.value}" name="demographicPersonalForm"  property="needCareDueToAccident" value="${item.value}" disabled="${not isAddAPerson}" /><bean-el:message key="${item.label}" />
           </c:forEach>
       </td>
</tr>
</c:if>

--%>



<html-el:hidden name="demographicPersonalForm" property="addAPerson"/>
<tr>
  <td colspan=2 height="50">
    <table width="100%" border="0" cellpadding="0" cellspacing="0">
      <tr>
        <c:choose>
          <c:when test="${roSensitivityFlag && roIdentityTraits && roDemographicInfo }">
            <td width="50%"><img alt=""  src="../images/spacer.gif"/></td>
            <td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
            <td><html-el:submit property="methodName" style="width:50; vertical-align: top;" styleClass="buttonText"><bean-el:message key="button.cancel"/></html-el:submit></td>
            <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
            <td width="50%"><img alt=""  src="../images/spacer.gif"/></td>
          </c:when>
          <c:otherwise>
            		<td width="45%"><img alt=""  src="../images/spacer.gif"/></td>
            		<td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
            		<td><html-el:submit property="methodName" style="width:50; vertical-align: top;" styleClass="buttonText"><bean-el:message key="button.update"/></html-el:submit></td>
            		<td><img alt=""  src="../images/buttonEndRight.gif"/></td>
            		<td width="1%"><img alt=""  src="../images/spacer.gif"/></td>
            		<td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
            		<td><html-el:submit property="methodName" style="width:50; vertical-align: top;" styleClass="buttonText"><bean-el:message key="button.cancel"/></html-el:submit></td>
            		<td><img alt=""  src="../images/buttonEndRight.gif"/></td>
           			<td width="45%"><img alt=""  src="../images/spacer.gif"/></td>
          </c:otherwise>
        </c:choose>
      </tr>
    </table>
  </td>
  </tr>
  <html-el:hidden name="demographicPersonalForm" property="dateOfDeathMVI" /> 
  <html-el:hidden name="demographicPersonalForm" property="deathNotificationSiteDB" /> 
</table>
</td>
</tr>
</table>
</td>
</tr>
<c:if test="${demographicPersonalForm.addAPerson == 'true'}">
		<html-el:hidden name="demographicPersonalForm" property="needCareDueToInjury"/>
		<html-el:hidden name="demographicPersonalForm" property="needCareDueToAccident"/>
</c:if>
</html-el:form>
</table>

<script>
setTimeout(function(){document.getElementById("notesId").focus()},1000);
</script>
