<%@ page import="gov.va.med.esr.common.model.lookup.Capability" %>
<%@ page import="gov.va.med.esr.common.model.lookup.AssociationType"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>

<c:set var="editAddress" value="false"/>
<c:set var="editAssociates" value="false"/>
<c:set var="editContactsPermission" value="false"/>
<c:set var="addContactsPermission" value="false"/>

<auth:authorize ifAnyGranted="<%=Capability.UPDATE_ADDRESS%>">
  <c:set var="editAddress" value="true"/>
</auth:authorize>
<auth:authorize ifAnyGranted="<%=Capability.UPDATE_ASSOCIATES%>">
  <c:set var="editAssociates" value="true"/>
</auth:authorize>
<auth:authorize ifAnyGranted="<%=Capability.EDIT_CONTACT_EXCLUDE_NEXT_OF_KIN.getName()%>">
  <c:set var="editContactsPermission" value="true"/>
</auth:authorize>
<auth:authorize ifAnyGranted="<%=Capability.ADD_CONTACT_EXCLUDE_NEXT_OF_KIN.getName()%>">
  <c:set var="addContactsPermission" value="true"/>
</auth:authorize>

<%-- Person Locked Check --%>
<c:set var="appData" value="${AppData}" scope="session"/>
<c:set var="personKey" value="SelectedPerson"/>
<c:set var="personLocked" value="${appData[personKey].personLocked}"/>
<c:if test="${personLocked}">
  <c:set var="editAddress" value="false"/>
  <c:set var="editAssociates" value="false"/>
  <c:set var="editContactsPermission" value="false"/>
  <c:set var="addContactsPermission" value="false"/>
</c:if>

<table width="100%" border="0" cellpadding="0" cellspacing="0" role="presentation">
  <tr>
    <td>
      <table width="100%" border="0" cellpadding="0" cellspacing="0" role="presentation">

   

        <tr valign="top">
          <td>
            <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShell" role="presentation">
              <tr>
                <td>
                  <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTable" role="presentation">
                    <tr valign="top">
                      <td>
                        <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead" role="presentation">
                          <tr>
                            <td class="moduleBlueBox"><img alt="" src="../images/spacer.gif" width="25" height="17"/></td>
                            <td nowrap class="moduleHeadline">
                            <c:choose>
                            <c:when test="${editAssociates == true}">
                              <a  href="/esr/demographic/displayAssociation.do"><bean-el:message key="text.updateAssociatesLink"/></a>
                            </c:when>
                            <c:otherwise>
                              <bean-el:message key="text.updateAssociatesLink"/>
                            </c:otherwise>
                            </c:choose>
                            </td>
                            <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
                            <c:if test="${addContactsPermission == true}">
                            <td nowrap class="moduleBlueLink" style="padding: 1 8 1 8">
                              <a  href="/esr/demographic/addAssociation.do?methodName=Add Associate"><bean-el:message key="text.addOtherAssociatesLink"/></a>
                            </td>
                            </c:if>
                          </tr>
                        </table>
                      </td>
                    </tr>

                    <tr>
                      <td>
                        <table summary="List of Associates for the Person" width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableBody">
                          <c:choose>
                          <c:when test="${demographicOverviewForm.associationsPresent == true}">
                            <thead>
                            <tr>
                              <th scope="col" width="1%" class="darkValue">&nbsp;</th>
                              <th scope="col" width="20%" class="darkValue"><b><bean-el:message key="label.association.name"/></b></th>
                              <th scope="col" width="10%" class="darkValue"><b><bean-el:message key="label.contact.relationship"/></b></th>
                              <th scope="col" width="10%" class="darkValue"><b><bean-el:message key="label.association.role"/></b></th>
                              <th scope="col" width="1%" class="darkValue">&nbsp;</th>
                            </tr>
                            </thead>

                            <c:set var="powerOfAttorney"><%=AssociationType.CODE_POWER_OF_ATTORNEY.getName()%></c:set>
                            <c:set var="guardianVa"><%=AssociationType.CODE_GUARDIAN_VA.getName()%></c:set>
                            <c:set var="guardianCivil"><%=AssociationType.CODE_GUARDIAN_CIVIL.getName()%></c:set>

                            <auth:authorize ifAnyGranted="<%=Capability.CONTACTS%>">
                            <c:set var="rowColor" value="darkValue"/>
                            <c:forEach var="association" items="${demographicOverviewForm.associations}">
                              <c:choose>
                                <c:when test="${rowColor == 'darkValue'}">
                                  <c:set var="rowColor" value="value"/>
                                </c:when>
                                <c:otherwise>
                                  <c:set var="rowColor" value="darkValue"/>
                                </c:otherwise>
                              </c:choose>
                              <tbody>
                              <tr>
                                <td class="<c:out value='${rowColor}'/>">&nbsp;</td>
                                <td scope="row" valign="top" class="<c:out value="${rowColor}"/>" nowrap>
                                  <c:set var="identifier" value="${association.entityKey.keyValueAsString}"/>
                                  <c:set var="role" value="${association.type.code}"/>

                                  <c:set var="name"><esrcore:displayValue name="association" property="representativeName"/></c:set>
                                  <c:if test="${not empty association.organizationName}">
                                    <c:choose>
                                      <c:when test="${not empty name}">
                                        <c:set var="name"><c:out value="${name}"/> (<c:out value="${association.organizationName}"/>)</c:set>
                                      </c:when>
                                      <c:otherwise>
                                        <c:set var="name"><c:out value="${association.organizationName}"/></c:set>
                                      </c:otherwise>
                                    </c:choose>
                                  </c:if>
                                  <c:choose>
                                    <c:when test="${editContactsPermission && (role == powerOfAttorney || role == guardianVa || role == guardianCivil)}">
                                      <fw:link action="updateAssociation?methodName=DISPLAY" paramId="associateId" paramName="identifier"><c:out value="${name}"/></fw:link>
                                    </c:when>
                                    <c:otherwise>
                                      <c:out value="${name}"/>
                                    </c:otherwise>
                                  </c:choose>
                                </td>
                                <td valign="top" class="<c:out value='${rowColor}'/>">
                                  <c:if test="${not empty association.relationship}">
                                    <c:out value="${association.relationship}"/>
                                  </c:if>
                                </td>
                                <td valign="top" class="<c:out value="${rowColor}"/>">
                                  <c:if test="${not empty association.type.description}">
                                    <c:out value="${association.type.description}"/>
                                  </c:if>
                                </td>
                                <td class="<c:out value="${rowColor}"/>">&nbsp;</td>
                              </tr>
                              </tbody>
                            </c:forEach>
                            </auth:authorize>
                          </c:when>
                          <c:otherwise>
                          <tr>
                            <td class="value" style="text-align: center"><bean:message key="label.noDataAvailable"/></td>
                          <tr>
                          </c:otherwise>
                          </c:choose>
                        </table>
                      </td>
                    </tr>
                  </table>
                </td>
              </tr>
            </table>
          </td>
        </tr>
      </table>
    </td>
  </tr>
</table>
