<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="/tags/esr-core" prefix="esrcore" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/fw" prefix="fw" %>
<%@ page import='gov.va.med.esr.common.model.system.SystemParameter' %>

<c:set var="SSNSSAFrequency"><%= SystemParameter.SSA_SSN_VERIFICATION_FREQUENCY %></c:set>

<table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShell">
<html-el:form action="/systemParameters" method="post">
  <%@ include file="/admin/csrfgentoken.jsp" %>
  <tr>
    <td>
      <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTable">
        <%-- System Parameters Heading --%>
        <tr>
          <td>
            <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead">
              <tr>
                <td class="moduleBlueBox"><img alt=""  src="../images/spacer.gif" width="28" height="23"/></td>
                <td nowrap style="padding-left: 7"><bean-el:message key="label.systemParameters"/> (<bean-el:message key="label.esrVersion"/>: <esrcore:displayValue name="systemParametersForm" property="esrVersion"/>)</td>
                <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
              </tr>
            </table>
          </td>
        </tr>
        <tr>
          <td>
    	    <table summary="Table for System Parameters" width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody">				
			<tr><td style="padding:10 10 10 10"><table width="100%" border="0" cellspacing="0" cellpadding="0">	<%-- --%>
			  <%-- System Parameters List start --%>
              <c:choose>
				  <c:when test="${systemParametersForm.noData == true}">
				  <tr>
					<td class="moduleLabel" style="padding:10 0 10 10; text-align: left"><bean-el:message key="label.noDataAvailable"/></td>
				  </tr>
				  </c:when>
              <c:otherwise>
				  <%-- Table Heading --%>
				  <thead>
				  <tr>
						<th scope="col" width= "30%" class="darkValue" valign="bottom" nowrap style="padding:5 5 5 5"><b>Parameter Name</b></th>
						<th scope="col" width= "10%" class="darkValue" valign="bottom" nowrap style="center;padding:5 5 5 5"><b><bean-el:message key="label.dateType"/></b></th>
						<th scope="col" width=  "5%" class="darkValue" valign="bottom" nowrap style="center;padding:5 5 5 5"><b><bean-el:message key="label.dataLength"/></b></th>
						<th scope="col" width=  "5%" class="darkValue" valign="bottom" nowrap style="center;padding:5 5 5 5"><b><bean-el:message key="label.value"/></b></th>
					    <th scope="col" width= "10%" class="darkValue" valign="bottom" nowrap style="center;padding:5 5 5 5"><b><bean-el:message key="label.dataUnit"/></b></th>			
						<th scope="col" width= "40%" class="darkValue" valign="bottom" wrap style="padding:5 5 5 5"><b><bean-el:message key="label.description"/></b></th>
						<th scope="col" width="100%" class="darkValue" valign="bottom" width="100%"><img alt=""  src="../images/spacer.gif" width="1" height="1" /></th>
				  </tr>
                                  </thead>
                                  
                                  <tbody>
                    <c:set var="rowLabelColor" value="darkLabel" />
                    <c:set var="rowValueColor" value="darkValue" />				  
                    <c:forEach var="sysParameter" items="${systemParametersForm.ids}" varStatus="status">
						
                      <c:choose>
                          <c:when test="${rowLabelColor == 'darkLabel'}">
                            <c:set var="rowLabelColor" value="label" />
                            <c:set var="rowValueColor" value="value" />
                          </c:when>
                          <c:otherwise>
                            <c:set var="rowLabelColor" value="darkLabel" />
                            <c:set var="rowValueColor" value="darkValue" />
                          </c:otherwise>
                      </c:choose>
						
                      <c:set var="counter" value="${status.count - 1}" />
					  <c:set var ="maxlength" value="${systemParametersForm.lengthList[counter]}"/>
					  <c:set var ="sysParName" value="${systemParametersForm.nameList[counter]}"/>
					  <c:set var ="editableFlag" value="${systemParametersForm.editableList[counter]}"/>
						<tr valign="top">
							<td scope="row" style="padding:5 5 5 5;text-align:left" class="<c:out value="${rowLabelColor}"/>">								
								<c:out value="${systemParametersForm.nameList[counter]}"/>								
                            </td>
							<!-- type is read only -->
							<td style="padding:5 5 5 5" class="<c:out value="${rowValueColor}"/>">
								<html-el:hidden property="id[${counter}]" />
								<html-el:hidden property="name[${counter}]" />								
								<html-el:hidden property="typeCode[${counter}]" />		
								<html-el:hidden property="type[${counter}]" />
								<html-el:hidden property="editable[${counter}]" />
								<c:out value="${systemParametersForm.typeList[counter]}"/>
                            </td>							
					
							<td style="padding:5 5 5 5" class="<c:out value="${rowValueColor}"/>">
								<html-el:hidden property="length[${counter}]" />
								<c:out value="${systemParametersForm.lengthList[counter]}"/>
							</td>
							<c:choose>
								<c:when test="${editableFlag == true}">
									<td style="padding:5 5 5 5" class="<c:out value="${rowValueColor}"/>">
									   <fw:label property="value[${counter}]" forId="sysParName${counter}value[${counter}]"><span style="display:none"><c:out value="${systemParametersForm.nameList[counter]}"/></span></fw:label>
							           <html-el:text  title="Value for ${systemParametersForm.nameList[counter]}" property="value[${counter}]"
									   styleId="sysParName${counter}value[${counter}]" styleClass="darkValue" size="10" 
									   maxlength="${maxlength}"/>
				                    </td>
									<td style="padding:5 5 5 5" class="<c:out value="${rowValueColor}"/>">
									  <c:choose>
										<c:when test="${systemParametersForm.nameList[counter] == SSNSSAFrequency}">	
										    <fw:label property="unit[${counter}]" forId="unit[${counter}]_id"><span style="display:none">unit</span></fw:label>		                      
											<html-el:select title="Data Unit for ${systemParametersForm.nameList[counter]}" styleClass="darkValue" styleId="unit[${counter}]_id" property="unit[${counter}]" >
												<html-el:option value=""><bean-el:message key="label.select" /></html-el:option>
												<esrcore:options collection="gov.va.med.esr.ui.common.beans.SSAVerificationFrequencyUnit" property="code" labelProperty="description"/>
											</html-el:select>
										</c:when>
										<c:otherwise>
											<html-el:hidden property="unit[${counter}]" />			              									
											<html-el:hidden property="unitDescription[${counter}]" />
											<c:out value="${systemParametersForm.unitDescriptionList[counter]}"/>											  																						
										  </c:otherwise>
									  </c:choose>
									</td>																				
								</c:when>
								<c:otherwise>
									<td style="padding:5 5 5 5" class="<c:out value="${rowValueColor}"/>">
										<html-el:hidden property="value[${counter}]" />
										<c:out value="${systemParametersForm.valueList[counter]}"/>
									</td>
									<td style="padding:5 5 5 5" class="<c:out value="${rowValueColor}"/>">
										<html-el:hidden property="unit[${counter}]" />			              									
									    <html-el:hidden property="unitDescription[${counter}]" />
									    <c:out value="${systemParametersForm.unitDescriptionList[counter]}"/>											  																						
				                    </td>																																	
								</c:otherwise>
							</c:choose>							
							<td style="padding:5 5 5 5;vertical-align:top" class="<c:out value="${rowValueColor}"/>">
								<html-el:hidden property="description[${counter}]" />
								<c:out value="${systemParametersForm.descriptionList[counter]}"/>
                            </td>
						</tr>
					</c:forEach>				  				  
			  </c:otherwise>
			  </c:choose>	 
			  </tbody>
			<%-- System Parameters List end --%>
			</table>
		  </td>
		</tr>
		<tr>
			<td>
				<%-- Button Section --%>
                  <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableBody">				
                    <tr>
                      <td width="45%"><img alt=""  src="../images/spacer.gif"/></td>
                      <td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
							<script language="javascript">
						       function confirmupdate()
							   {
								   var message = "Are you sure you want to change the value of the parameters?";
								   if(confirm(message))
									   return true;								   
								   else
                                       return false;
							   }
                            </script>
	                  <td><html-el:submit property="methodName" style="width:50; vertical-align: top;" styleClass="buttonText" onclick="return(confirmupdate());return false"><bean-el:message key="button.update"/></html-el:submit></td>
                      <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
                      <td width="1%"><img alt=""  src="../images/spacer.gif"/></td>
                      <td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
	                  <td><html-el:submit property="methodName" style="width:50; vertical-align: top;" styleClass="buttonText"><bean-el:message key="button.reset"/></html-el:submit></td>
                      <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
                      <td width="1%"><img alt=""  src="../images/spacer.gif"/></td>
                      <td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
	                  <td><html-el:submit property="methodName" style="width:50; vertical-align: top;" styleClass="buttonText"><bean-el:message key="button.cancel"/></html-el:submit></td>
                      <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
                      <td width="60%"><img alt=""  src="../images/spacer.gif"/></td>
                    </tr>
					<tr><td>&nbsp;</td></tr>
                  </table>
				</table></td></tr> <%-- --%>					
			</td>
		</tr>				
	  </table>
	</td>
  </tr>
</html-el:form>
</table>