<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/esr-core" prefix="esrcore" %>
<%@ taglib uri="/tags/fw" prefix="fw" %>

<table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShell">
<html-el:form action="/irsReject" method="post">
  <%@ include file="/admin/csrfgentoken.jsp" %>
  <tr>
    <td>
      <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTable">
        <tr>
          <td>
            <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead">
              <tr>
	            <td class="moduleBlueBox">&nbsp;</td>
                <td class="moduleHeadline" nowrap><bean-el:message key="label.irsReject.mainHeader"/></td>
              </tr>
            </table>
          </td>
        </tr>
         <tr>
          <td>
    	    <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody">
              <tr>
                <td>&nbsp;</td>
              </tr>
               <c:set var="rowColor" value="darkValue" />
               <c:choose>
               <c:when test="${submissions != null}">

			<tr><td class="value">
			<table summary="Table for Managing IRS Batch Submissions">
				<thead>
					<tr>
						<th scope="col" style="text-align:left; padding: 7 0 7 5" class="darkLabel"><bean-el:message key="label.irsReject.taxYear"/></th>
						<th scope="col" style="text-align:left; padding: 7 0 7 5" class="darkLabel"><bean-el:message key="label.irsReject.status"/></th>
						<th scope="col" style="text-align:left; padding: 7 0 7 5" class="darkLabel"><bean-el:message key="label.irsReject.errReason"/></th>
						<th scope="col" style="text-align:left; padding: 7 0 7 5" class="darkLabel"><bean-el:message key="label.irsReject.batchType"/></th>
						<th scope="col" style="text-align:left; padding: 7 0 7 5" class="darkLabel"><bean-el:message key="label.irsReject.correctionType"/></th>
						<th scope="col" style="text-align:left; padding: 7 0 7 5" class="darkLabel"><bean-el:message key="label.irsReject.transDate"/></th>
						<th scope="col" style="text-align:left; padding: 7 0 7 5" class="darkLabel"><bean-el:message key="label.irsReject.resubmit"/></th>
					</tr>
				</thead>
				<tbody>
					<c:forEach var="IrsTransmissionLogEntry" items="${submissions}">

						<c:choose>
							<c:when test="${rowColor == 'darkValue'}">
								<c:set var="rowColor" value="value" />
							</c:when>
							<c:otherwise>
								<c:set var="rowColor" value="darkValue" />
							</c:otherwise>
						</c:choose>

						<c:choose>
							<c:when test="${IrsTransmissionLogEntry.correctionInd == 'O'}">
								<c:set var="submitType" value="Original"/>
							</c:when>
							<c:when test="${IrsTransmissionLogEntry.correctionInd == 'C'}">
								<c:set var="submitType" value="Correction"/>
							</c:when>
							<c:when test="${IrsTransmissionLogEntry.correctionInd == 'R'}">
								<c:set var="submitType" value="Replacement"/>
							</c:when>
							<c:otherwise>
								<c:set var="submitType" value="Unknown"/>
							</c:otherwise>
						</c:choose>

						<c:choose>
							<c:when test="${IrsTransmissionLogEntry.batchTypeInd == 'V'}">
								<c:set var="batchType" value="Veterans"/>
							</c:when>
							<c:when test="${IrsTransmissionLogEntry.batchTypeInd == 'B'}">
								<c:set var="batchType" value="Beneficiaries"/>
							</c:when>
							<c:otherwise>
								<c:set var="batchType" value="Unknown"/>
							</c:otherwise>
						</c:choose>

				      <tr>
						<td scope="row" width="10%" align="left" valign="top" class="<c:out value="${rowColor}"/>" nowrap>
							<esrcore:displayValue name="IrsTransmissionLogEntry" property="taxYear"/>
						</td>
						<td align="left" width="10%" valign="top" class="<c:out value="${rowColor}"/>">
							<esrcore:displayValue name="IrsTransmissionLogEntry" property="transmissionStatus.name" />
						</td>
						<td align="left" width="30%" valign="top" class="<c:out value="${rowColor}"/>">
							<esrcore:displayValue name="IrsTransmissionLogEntry" property="errorDescription" />
						</td>
						<td align="left" width="10%" valign="top" class="<c:out value="${rowColor}"/>" nowrap>
							<c:out value="${batchType}"/>
						</td>
						<td align="left" width="10%" valign="top" class="<c:out value="${rowColor}"/>" nowrap>
							<c:out value="${submitType}"/>
						</td>
						<td align="left" width="20%" valign="top" class="<c:out value="${rowColor}"/>" nowrap>
							<esrcore:displayDate name="IrsTransmissionLogEntry" DateProperty="transmissionDate" displayTime="true"/>
						</td>
						<td width="10%" align="left" valign="top" class="<c:out value="${rowColor}"/>" nowrap>
							<fw:link action="irsReject.do?methodName=Resubmit&amp;submissionId=${IrsTransmissionLogEntry.entityKey.keyValue}">
								<bean-el:message key="link.irsReject.resubmit"/>
							</fw:link>
						</td>
						<td>&nbsp;</td>
					</tr>
				</c:forEach>
			</tbody>
			</table>
			</td></tr>
			</c:when>
			<c:otherwise>
					<tr>
						<td class="moduleLabel" style="text-align: left; padding-left: 20">No Failed Batch Transmissions Found</td>
					  </tr>
			</c:otherwise>
			</c:choose>
			            </table>
			        </td>
			      </tr>

					<tr>
                	<td>&nbsp;</td>
              		</tr>
            </table>
    </td>
  </tr>
	</html-el:form>
</table>
