<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="/tags/esr-core" prefix="esrcore" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/valuelist" prefix="vlh" %>
<%@ taglib uri="/tags/fw" prefix="fw" %>
<%@ taglib uri="/tags/authz" prefix="auth" %>
<%@ page import='gov.va.med.esr.common.model.lookup.Capability' %>

<c:set var="mmddyyyyText" scope="page"><bean-el:message key="label.mmddyyyy"/></c:set>
<c:set var="worklistItemsSummary" scope="page"><bean-el:message key="label.worklist.summary"/></c:set>

<c:set var="searchBySSN" scope="page" value="false"/>
<c:set var="closeWorkItems" scope="page" value="false"/>
<c:set var="assignWorkItems" scope="page" value="false"/>
<c:set var="assignWorkItemsToOthers" scope="page" value="false"/>

<c:set var="assignToSelf"><%=Capability.ASSIGN_WORK_ITEMS_TO_SELF.getName()%></c:set>
<c:set var="assignToOthers"><%=Capability.ASSIGN_WORK_ITEMS_TO_OTHERS.getName()%></c:set>
<c:set var="assignToOtherGroups"><%=Capability.TRANSFER_WORK_ITEMS.getName()%></c:set>

<c:set var="permissionToEdit"><%=Capability.EDIT_WORK_ITEMS.getName()%></c:set>
<c:set var="permissionToClose"><%=Capability.CLOSE_WORK_ITEMS.getName()%></c:set>

<auth:authorize access="hasAnyRole(T(gov.va.med.esr.common.model.lookup.Capability).SEARCH_SSN_ONLY.getName())">
  <c:set var="searchBySSN" scope="page" value="true"/>
</auth:authorize>

<auth:authorize access="hasAnyRole(${assignToOthers},${assignToOtherGroups})">
  <c:set var="assignWorkItemsToOthers" scope="page" value="true"/>
</auth:authorize>

<auth:authorize access="hasAnyRole(${assignToSelf},${assignToOthers},${assignToOtherGroups})">
  <c:set var="assignWorkItems" scope="page" value="true"/>
</auth:authorize>

<auth:authorize access="hasAnyRole(${permissionToEdit},${permissionToClose})">
  <c:set var="closeWorkItems" scope="page" value="true"/>
</auth:authorize>


<script>
function showWorklistFilter()
{
	document.getElementById("workflowFilter").style.display="block";
	document.getElementById("showWorklistFilterLink").style.display="none";
	document.getElementById("hideWorklistFilterLink").style.display="block";
	return false;
}
function hideWorklistFilter()
{
	document.getElementById("workflowFilter").style.display="none";
	document.getElementById("showWorklistFilterLink").style.display="block";
	document.getElementById("hideWorklistFilterLink").style.display="none";
	return false;
}
/* Synchronize selections top and bottom selected in a page */
function syncSelections(selectedEl, groupEl) {
    for (var i = 0; i < groupEl.length; i++) {
	    groupEl[i].value=selectedEl.value;
	}
}
function isSelected(groupEl) {
	if (groupEl[0].value =="")
		return false;
	else
		return true;
}
</script>
<table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShell" role="presentation">
<html-el:form action="/worklist" method="post">
  <%@ include file="/admin/csrfgentoken.jsp" %>
    <tr>
     <td>
	   <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTable" role="presentation">
		<!-- Heading Row -->
	    <tr>
	     <td>
          <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead" role="presentation">
           <tr>
		     <td class="moduleBlueBox"><img alt=""  src="../images/spacer.gif" width="28" height="23"/></td>
			 <td nowrap class="moduleHeadline">
			 <c:choose>
				 <c:when test="${tabName == 'myCases'}">
					 <bean-el:message key="worklist.myCases.title"/>
					 <html-el:hidden name="worklistForm" property="returnLink" value= "returnToMyCases"/>
				 </c:when>
				 <c:when test="${tabName == 'assignedCases'}">
					 <bean-el:message key="worklist.assigned.title"/>
 					 <html-el:hidden name="worklistForm" property="returnLink" value= "returnToAssignedCases"/>
				 </c:when>
				 <c:when test="${tabName == 'unassignedCases'}">
					 <bean-el:message key="worklist.unassigned.title"/>
					 <html-el:hidden name="worklistForm" property="returnLink" value= "returnToUnassignedCases"/>
				 </c:when>
				 <c:when test="${tabName == 'searchResults'}">
					 <bean-el:message key="workflowSearchResults.title"/>
					 <html-el:hidden name="worklistForm" property="returnLink" value= "returnToSearch"/>
				 </c:when>
				 <c:when test="${tabName == 'overview'}"><bean-el:message key="workflowOverview.title"/>
 					 <html-el:hidden name="worklistForm" property="returnLink" value= "overview"/>
				 </c:when>
				 <c:when test="${tabName == 'openCases'}">
					 <bean-el:message key="worklist.open.title"/>
		 			 <html-el:hidden name="worklistForm" property="returnLink" value= "returnToOpenCases"/>
				 </c:when>
				 <c:otherwise></c:otherwise>
			 </c:choose>
			 </td>
			 <td width="100%"><img alt=""  src="../images/spacer.gif"/>
			 <c:if test="${tabName == 'myCases' || tabName == 'assignedCases' || tabName == 'unassignedCases'}">
					 <td nowrap class="moduleBlueLink" style="padding: 1 8 1 8">
							<div id="showWorklistFilterLink" style="display:block">
								<fw:link onclick="return(showWorklistFilter());return false" action="none">SHOW WORKLIST FILTER</fw:link>
							</div>
							<div id="hideWorklistFilterLink" style="display:none">
								<fw:link onclick="return(hideWorklistFilter());return false" action="none">HIDE WORKLIST FILTER</fw:link>
							</div>
					 </td>
			  </c:if>
           </tr>
          </table>
	     </td>
	    </tr>
		<!-- set the variables to define the dynamic view for different tabs -->
	    <tr>
		 <td>
		  <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableBody" role="presentation">
			<c:choose>
			 <c:when test="${tabName == 'overview'}">
			 <tr>
			  <td style="padding:10 10 10 10">
			   <table width="100%" border="0" cellpadding="0" cellspacing="0" role="presentation">
				<tr>
				  <td nowrap width="50%" class="moduleLabel"><bean-el:message key="worklist.title"/>:</td>
				  <td nowrap width="5%" class="moduleValue"><esrcore:displayValue name="workItemsSummary" property="myCaseCount"/></td>
				  <td nowrap class="moduleValue" style="color:red;font-weight: bold">(<esrcore:displayValue name="workItemsSummary" property="myOverdueCaseCount"/>) Overdue</td>
				  <td width="100%"><img alt=""  src="../images/spacer.gif"/></td>
				</tr>
				<tr>
				  <td nowrap width="50%" class="moduleLabel"><bean-el:message key="worklist.assigned.title" />:</td>
				  <td nowrap width="5%" class="moduleValue"><esrcore:displayValue name="workItemsSummary" property="assignedCaseCount"/></td>
				  <td nowrap class="moduleValue" style="color:red;font-weight: bold">(<esrcore:displayValue name="workItemsSummary" property="assignedOverdueCaseCount"/>) Overdue</td>
				  <td width="100%"><img alt=""  src="../images/spacer.gif"/></td>
				</tr>
				<tr>
				  <td nowrap width="50%" class="moduleLabel"><bean-el:message key="worklist.unassigned.title" />:</td>
				  <td nowrap width="5%" class="moduleValue"><esrcore:displayValue name="workItemsSummary" property="unassignedCaseCount"/></td>
				  <td nowrap class="moduleValue" style="color:red;font-weight: bold">(<esrcore:displayValue name="workItemsSummary" property="unassignedOverdueCaseCount"/>) Overdue</td>
				  <td width="100%"><img alt=""  src="../images/spacer.gif"/></td>
				</tr>
			   </table>
			  </td>
			 </tr>
			 </c:when>
			 <c:otherwise>
			   <c:choose>
                 <c:when test="${vlhlist == null || vlhlist.valueListInfo.totalNumberOfEntries == 0}">
				   <tr>
					   <td>
						   <%@ include file="workflowFilter.jsp" %>
					   </td>
				   </tr>
                   <tr>
                     <td class="darkValue" style="padding:10 0 10 10; text-align: left"><bean-el:message key="label.noDataAvailable"/></td>
                   </tr>
                 </c:when>
				 <c:when test="${assignWorkItems != true and closeWorkItems != true}">
					 <%@ include file="workflowFilter.jsp" %>
					 <%@ include file="worklistItems.jsp" %>
				 </c:when>
                 <c:otherwise>
   				   <%@ include file="workflowFilter.jsp" %>
   				   <c:set var="actionHeaderSuffix" scope="request" value="top"/>
				   <%@ include file="workflowActionHeader.jsp" %>
		           <%@ include file="worklistItems.jsp" %>
		           <c:set var="actionHeaderSuffix" scope="request" value="bottom"/>
				   <%@ include file="workflowActionHeader.jsp" %>
				 </c:otherwise>
			   </c:choose>
			 </c:otherwise>
			</c:choose>
	      </table>	<!-- module shell table  -->
		 </td>
		</tr>
	   </table>	<!-- module shell table  -->
	   </td>
	</tr>
</html-el:form>
</table>
	<!-- module shell -->
