<%@ taglib uri="/tags/struts-bean" prefix="bean-el" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="/tags/esr-core" prefix="esrcore" %>	
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/fw" prefix="fw" %>
<%@ taglib uri="/tags/authz" prefix="auth" %>
<%@ taglib uri="/tags/encode" prefix="e" %>
<%@ page import='gov.va.med.esr.common.model.lookup.Capability' %>	


<!-- Permissions -->
<c:set var="VIEW_WORKLOAD_HISTORY"><%=Capability.VIEW_WORKLOAD_HISTORY.getName() %></c:set>
<c:set var="VIEW_COMMENT_HISTORY"><%=Capability.VIEW_COMMENT_HISTORY.getName() %></c:set>
<c:set var="VIEW_STATUS_HISTORY"><%=Capability.VIEW_STATUS_HISTORY.getName() %></c:set>
<c:set var="VIEW_ASSIGNMENT_HISTORY"><%=Capability.VIEW_ASSIGNMENT_HISTORY.getName() %></c:set>
<c:set var="VIEW_WORKLOAD"><%=Capability.VIEW_WORKLOAD.getName() %></c:set>
<c:set var="EDIT_WORK_ITEMS"><%=Capability.EDIT_WORK_ITEMS.getName() %></c:set>
<c:set var="workflowAssignedToList" value="${workflowAssignedToList}" />

<c:set var="assignWorkItems" value="false"/>
<c:set var="assignWorkItemsToOthers" value="false"/>
<c:set var="editStatus" value="false"/>
<c:set var="addComments" value="false"/>

<c:set var="assignToSelf"><%=Capability.ASSIGN_WORK_ITEMS_TO_SELF.getName()%></c:set>
<c:set var="assignToOthers"><%=Capability.ASSIGN_WORK_ITEMS_TO_OTHERS.getName()%></c:set>
<c:set var="assignToOtherGroups"><%=Capability.TRANSFER_WORK_ITEMS.getName()%></c:set>

<c:set var="permissionToEdit"><%=Capability.EDIT_WORK_ITEMS.getName()%></c:set>
<c:set var="permissionToClose"><%=Capability.CLOSE_WORK_ITEMS.getName()%></c:set>

<auth:authorize access="hasAnyRole(${assignToSelf})">
  <c:set var="assignWorkItemsToSelf" value="true"/>
</auth:authorize>

<auth:authorize access="hasAnyRole(${assignToOthers},${assignToOtherGroups})">
  <c:set var="assignWorkItemsToOthers" value="true"/>
</auth:authorize>

<auth:authorize access="hasAnyRole(${EDIT_WORK_ITEMS})">
	<c:set var="editStatus" value="true"/>
	<c:set var="addComments" value="true"/>
</auth:authorize>
	
<c:set var="enableUpdate" value="false"/>

<html-el:form action="/workitem" method="post">
  <%@ include file="/admin/csrfgentoken.jsp" %>
<c:set var="workItem" value="${sessionScope.PristineEntity}"/>	
<table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShell" role="presentation">
<tr>
 <td>
   <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTable" role="presentation">
    <tr>
     <td>
      <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead" role="presentation">
       <tr> 
	    <td class="moduleBlueBox"><img alt=""  src="../images/spacer.gif" width="28" height="23"/></td>
		<td nowrap class="moduleHeadline"><bean-el:message key="label.itemDetail.updateSubTitle"/></td>
 	    <td width="100%"><img alt=""  src="../images/spacer.gif"/> 
       </tr>
      </table>
     </td>
    </tr>
    <tr> 
     <td>
      <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
		  <html-el:hidden property="workflowCaseId" />
		  <html-el:hidden property="readOnly"/>
		  <html-el:hidden property="caseGroup"/>
		  <html-el:hidden property="loggedInUserGroup"/>
		  <html-el:hidden property="loggedInUserName"/>
			  
		<!-- Closed case or case from other group is read only -->
		<c:if test="${workItem.open and workItemForm.caseGroup == workItemForm.loggedInUserGroup}">
			<!-- Display Assign to if user permission to do so -->
			<c:if test="${assignWorkItemsToOthers == true or (assignWorkItemsToSelf == true and workItemForm.loggedInUserName != workItemForm.assignedTo)}">				
				<c:set var="enableUpdate" value="true"/>				
			    <tr>
				  <td width="45%" class="moduleLabel"><fw:label property="assignedTo" forId="assignedToId"><bean-el:message key="label.itemDetail.assignedTo"/>:</fw:label></td>				   			  
				  <td width="55%" class="moduleValue">	
				  <c:set var="assignedToText"><bean-el:message key="label.itemDetail.assignedTo" /></c:set>			
						<html-el:select title="${assignedToText}" styleId="assignedToId" styleClass="moduleValue" property="assignedTo">
							<html-el:option value=""><bean-el:message key="label.select" /></html-el:option>
							<esrcore:options collection="workflowAssignedToList" 
								property="code" labelProperty="description"/>
						</html-el:select>						  
				  </td>			
			    </tr>
		    </c:if>
			
		    <!-- comments are editable in editable mode only case is open and current user equals assigned user--> 
			<c:if test="${editStatus == true}">
		    <c:if test="${workItemForm.assignedTo == null or workItemForm.loggedInUserName == workItem.assignment.assignedTo}">
				<c:set var="enableUpdate" value="true"/>				  			  
			    <tr>
				  <td width="45%" class="moduleLabel"><fw:label property="statusValue" forId="statusValueId"><bean-el:message key="label.itemDetail.status"/>:</fw:label></td>				  
				  <td width="55%" class="moduleValue">	
				  <c:set var="statusText"><bean-el:message key="label.itemDetail.status"/></c:set>			
						<html-el:select title="${statusText}" styleId="statusValueId" styleClass="moduleValue" property="statusValue">
							<html-el:option value=""><bean-el:message key="label.select" /></html-el:option>
							<esrcore:options collection="gov.va.med.esr.common.model.lookup.WkfCaseStatusType" 
								property="code" labelProperty="description"/>
						</html-el:select>						  
				  </td>			
			    </tr>	
            </c:if>
			</c:if>
		</c:if>			   
		<c:if test="${addComments == true}">			
		  <c:if test="${workItem.assignment.assignedTo != null or workItemForm.loggedInUserName == workItem.assignment.assignedTo}">			
			<c:set var="enableUpdate" value="true"/>			  			  				   
	        <tr valign="top"> 
			      <td class="moduleLabel" style="padding-left:40;text-align:left">
				     <fw:label property="comment" forId="commentsTextId"><bean-el:message key="label.itemDetail.comments" />:</fw:label></td>   				    
			      <td>&nbsp;</td>
			</tr>
			  
			<tr>
				  <html-el:hidden property="commentId" /> 
			      <td colspan="2" class="moduleValue" style="padding-left:40">
			        <c:set var="commentsText"><bean-el:message key="label.itemDetail.comments" /></c:set>
				    <html-el:textarea title="${commentsText}" name="workItemForm" property="comment" styleId="commentsTextId" cols="100" rows="8"/>
				  </td>
			</tr>
		   </c:if>			    	  
		 </c:if>
		    			   
		   		  
		<!-- Common Button Section -->  
        <tr>
          <td colspan="2" height="50">
            <table width="100%" border="0" cellpadding="0" cellspacing="0" role="presentation">
              <tr>				  
				<c:choose>
					<c:when test="${enableUpdate == true}">				  
						<td width="45%"><img alt=""  src="../images/spacer.gif"/></td>
						<td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
						<td><html-el:submit property="methodName" style="width:50; vertical-align: top;" 
								styleClass="buttonText"><bean-el:message key="button.update"/>
							</html-el:submit>
						</td>												
						<td><img alt=""  src="../images/buttonEndRight.gif"/></td>
						<td width="1%"><img alt=""  src="../images/spacer.gif"/></td>
						<td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
						<td><html-el:submit property="methodName" style="width:50; vertical-align: top;" 
								styleClass="buttonText"><bean-el:message key="button.cancel"/>
							</html-el:submit></td>
						<td><img alt=""  src="../images/buttonEndRight.gif"/></td>
						<td width="45%"><img alt=""  src="../images/spacer.gif"/></td>						
					</c:when>					
					<c:otherwise>
				        <td width="48%"><img alt=""  src="../images/spacer.gif"/></td>
                        <td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
                        <td><html-el:submit property="methodName" style="width:50; vertical-align: top;" styleClass="buttonText"><bean-el:message key="button.cancel"/></html-el:submit></td>
                        <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
                        <td width="48%"><img alt=""  src="../images/spacer.gif"/></td>
					</c:otherwise>
				</c:choose>													
              </tr>
            </table>
          </td>
        </tr>
	  </table>
	 </td>
	</tr>
		    
	<tr>
	     <td>
	      <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead" role="presentation">
	       <tr>
	        <td class="moduleBlueBox"><img alt=""  src="../images/spacer.gif" width="20" height="18"/></td>
	 	    <td nowrap class="moduleHeadline"><bean-el:message key="label.itemDetail.detailSubTitle" /></td>
	 	    <td width="100%"><img alt=""  src="../images/spacer.gif"/> 
	       </tr>
	      </table>
	     </td>
	</tr>
		  
	<tr> 
	     <td>
	      <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
			  <tr>
			    <td width="20%" class="darkLabel"><bean-el:message key="label.itemDetail.itemNumber" />:&nbsp;</td>
			    <td width="30%" class="darkValue"><esrcore:displayValue name="workItem" property="workflowCaseID"/></td>
				<td width="20%" class="darkLabel">&nbsp;</td>
				<td width="30%" class="darkValue">&nbsp;</td>
			  </tr>
			  <tr>
				<td width="20%" class="label"><bean-el:message key="label.itemDetail.status" />:&nbsp;</td>  
			    <td width="30%" class="value"><esrcore:displayValue name="workItem" property="status.statusValue"/></td>
			    <td width="20%" class="label"><bean-el:message key="label.itemDetail.dueDate" />:&nbsp;</td>
			    <td width="30%" class="value"><esrcore:displayValue name="workItem" property="dueDate"/></td>				  
			  </tr>
			  <tr>
			    <td width="20%" class="darkLabel"><bean-el:message key="label.functionalGroup" />:&nbsp;</td>
			    <td width="30%" class="darkValue">
					<esrcore:displayValue name="workItem" property="groupType"/>
                </td>				   
			    <td width="20%" class="darkLabel"><bean-el:message key="label.itemDetail.assignedTo" />:&nbsp;</td>
			    <td width="30%" class="darkValue">
					<esrcore:displayLookupValue 
				      lookupType="gov.va.med.esr.common.model.security.ESRUserPrincipalImpl" 
						 name="workItem" property="assignment.assignedTo" />			      
                </td>
			  </tr>
			  <tr> 
			      <td width="20%" class="label"><bean-el:message key="label.itemDetail.itemType" />:&nbsp;</td>
				  <td colspan="3" class="value">
					  <esrcore:displayValue name="workItem" property="caseType"/>	
					  <c:if test="${not empty workItem.errorMessage}">&nbsp;(<esrcore:displayValue name="workItem" property="errorMessage"/>)</c:if>
				  </td>
              </tr>
		      <tr> 			      
				<td width="20%" class="darkLabel"><bean-el:message key="label.itemDetail.name" />:&nbsp;</td>
				<td width="30%" class="darkValue">
					<a href="/esr/admin/search.do?methodName=SELECT+PERSON&selectedPersonId=<e:forUriComponent value='${workItemForm.personId}'/>"/>
					<c:out value="${workItem.name}"/>
				</td>
				<td width="20%" class="darkLabel"><bean-el:message key="label.itemDetail.ssn" />:&nbsp;</td>
				<td width="30%" class="darkValue"><esrcore:displayValue name="workItem" property="ssn"/></td>
		      </tr>
						
			  <tr> 
			    <td width="20%" class="label"><bean-el:message key="label.itemDetail.facility" />:&nbsp;</td>
				<td colspan="3" class="value"><esrcore:displayValue name="workItem" property="requestSource.facilityName"/></td>
              </tr>

				  <tr> 
					<td width="20%" class="darkLabel"><bean-el:message key="label.itemDetail.createDate" />:&nbsp;</td>
					<td width="30%" class="darkValue"><esrcore:displayValue name="workItem" property="createdOn"/></td>
					<td width="20%" class="darkLabel"><bean-el:message key="label.itemDetail.createdBy" />:&nbsp;</td>
					<td  class="darkValue"><esrcore:displayLookupValue 
						  lookupType="gov.va.med.esr.common.model.security.ESRUserPrincipalImpl" 
							 name="workItem" property="createdBy.name" /></td>	
				  </tr>
				  <tr> 
					<td width="20%" class="label"><bean-el:message key="label.itemDetail.assignedDate" />:&nbsp;</td>
					<td width="30%" class="value"><esrcore:displayValue name="workItem" property="assignment.assignmentDate"/></td>
					<td width="20%" class="label"><bean-el:message key="label.itemDetail.lastAssignor" />:&nbsp;</td>
					<td width="30%" class="value"><esrcore:displayLookupValue 
						  lookupType="gov.va.med.esr.common.model.security.ESRUserPrincipalImpl" 
							 name="workItem" property="assignment.assignedBy" /></td>
				  </tr>					
 		  </table> <!-- module shell table body-->
	 </td>
	</tr>
		 	
	<!-- comments -->
	<auth:authorize access="hasAnyRole(${EDIT_WORK_ITEMS},${VIEW_WORKLOAD},${VIEW_WORKLOAD_HISTORY},${VIEW_COMMENT_HISTORY})">										
	<tr>
	 <td>
            <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead">
		    <tr>
	            <td class="moduleBlueBox"><img alt=""  src="../images/spacer.gif" width="20" height="18"/></td>
		        <td nowrap class="moduleHeadline">Comments</td>
 	            <td width="100%"><img alt=""  src="../images/spacer.gif"/> 
			</tr>
			</table>
	 </td>
	</tr>
					 
	<tr>
	 <td>	
		    <table summary="Details of Comments for the Selected Work Item" width="100%" border="1" cellspacing="0" cellpadding="0" class="moduleShellTableBody">
			    <thead>
			    <tr class="valuelistRow1">
				   <th scope="col" nowrap width="15%" class="valuelistRow1" ><bean-el:message key="label.commentDate" /></th>
				   <th scope="col" nowrap width="15%" class="valuelistRow1"><bean-el:message key="label.commentBy" /></th>
				   <th scope="col" width="70%" class="valuelistRow1"><bean-el:message key="label.comment" /></th>
			    </tr>
				</thead>
				<c:set var="commentTextLabel"><bean-el:message key="label.comment"/></c:set>
				<c:set var="commentDateLabel"><bean-el:message key="label.commentDate"/></c:set>
				<c:set var="commentByLabel"><bean-el:message key="label.commentBy"/></c:set>

			   <tbody>	
               <c:forEach var="comment" items="${workItem.commentsHistoryList}" varStatus="status">
			   <tr class="valuelistRow1">
				   <td scope="row" title="<c:out value="${commentDateLabel} ${status.count}"/>" nowrap >
				   <esrcore:displayDate name="comment" dateProperty="createdOn" displayTime="false" nullText=""/></td>
				   <td title="<c:out value="${commentByLabel} ${status.count}"/>" nowrap >
				   <esrcore:displayLookupValue lookupType="gov.va.med.esr.common.model.security.ESRUserPrincipalImpl" name="comment" property="createdBy.name" />
				   </td>
				   <td title="<c:out value="${commentTextLabel} ${status.count}"/>">
				   <esrcore:displayValue name="comment" property="commentText"/>
				   </td>
			   </tr>
			   </c:forEach>
			   </tbody>
               <tr><td colspan="3">&nbsp;</td></tr>									   
			</table>
	 </td>
	</tr>
    </auth:authorize>				
	<!-- end of comments -->								 
				 
    <!-- status history -->
	<auth:authorize access="hasAnyRole(${EDIT_WORK_ITEMS},${VIEW_WORKLOAD},${VIEW_WORKLOAD_HISTORY},${VIEW_STATUS_HISTORY})">				
	<tr>
	 <td>
            <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead">
		    <tr>
	            <td class="moduleBlueBox"><img alt=""  src="../images/spacer.gif" width="20" height="18"/></td>
		        <td nowrap class="moduleHeadline">Status History</td>
 	            <td width="100%"><img alt=""  src="../images/spacer.gif"/> 
			</tr>
			</table>
			</td></tr>
			<tr><td>
		    <table summary="Details of Statuses for the Selected Work Item" width="100%"  border="1" cellspacing="0" cellpadding="0" class="moduleShellTableBody">
		    <thead>
			   <tr class="valuelistRow1">
				   <th scope="col" nowrap width="15%"><bean-el:message key="label.itemDetail.statusDate"/></th>
				   <th scope="col" nowrap width="85%"><bean-el:message key="label.itemDetail.status"/></th>
			   </tr>
			   </thead>
			   <c:set var="statusDateText"><bean-el:message key="label.itemDetail.statusDate"/></c:set>
				<c:set var="statusText"><bean-el:message key="label.itemDetail.status"/></c:set>
				 <tbody>		
               <c:forEach var="wkfstatus" items="${workItem.statusHistoryList}" varStatus="status">
			   <tr class="valuelistRow1">
				   	<td scope="row" title="<c:out value="${statusDateText} ${status.count}"/>" nowrap>
					<esrcore:displayDate name="wkfstatus" dateProperty="modifiedOn" displayTime="false" nullText=""/>
					</td>
					<td title="<c:out value="${statusText} ${status.count}"/>" nowarp><c:out value="${wkfstatus.statusValue.description}"/></td>
			   </tr>
			   </c:forEach>
			    </tbody>	
	           <tr><td colspan="2">&nbsp;</td></tr>						   				   
			</table>
	 </td>
	</tr>
	</auth:authorize>
    <!-- end of status history -->											 
					 				 
				 
	<!-- assignment history -->
	<auth:authorize access="hasAnyRole(${EDIT_WORK_ITEMS},${VIEW_WORKLOAD},${VIEW_WORKLOAD_HISTORY},${VIEW_ASSIGNMENT_HISTORY})">				
    <tr>
	 <td>				   
            <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead">
		    <tr>
	            <td class="moduleBlueBox"><img alt=""  src="../images/spacer.gif" width="20" height="18"/></td>
		        <td nowrap class="moduleHeadline">Assignment History</td>
 	            <td width="100%"><img alt=""  src="../images/spacer.gif"/> 
			</tr>
			</table>
			</td>
	</tr>

	<tr>
	 <td>					 
		    <table summary="Details of Assignment for the Selected Work Item" width="100%" border="1" cellspacing="0" cellpadding="0" class="moduleShellTableBody">
		    <thead>
			   <tr class="valuelistRow1">
				   <th scope="col" nowrap width="15%"><bean-el:message key="label.itemDetail.assignmentDate"/></th>
				   <th scope="col" nowrap width="15%"><bean-el:message key="label.itemDetail.assignedTo"/></th>
				   <th scope="col" nowrap width="70%"><bean-el:message key="label.itemDetail.assignedBy"/></th>
			   </tr>
			   </thead>	
			   <c:set var="assignmentDateText"><bean-el:message key="label.itemDetail.assignmentDate"/></c:set>
				<c:set var="assignedToText"><bean-el:message key="label.itemDetail.assignedTo"/></c:set>
				<c:set var="assignedByText"><bean-el:message key="label.itemDetail.assignedBy"/></c:set>
				
			<tbody>	
               <c:forEach var="assignment" items="${workItem.assignmentHistoryList}" varStatus="status">               
			   <tr class="valuelistRow1">
				    <td scope="row" title="<c:out value="${assignmentDateText} ${status.count}"/>" nowrap><esrcore:displayDate name="assignment" dateProperty="assignmentDate" displayTime="false" nullText=""/></td>
					<td title="<c:out value="${assignedToText} ${status.count}"/>" nowrap><esrcore:displayLookupValue 
						  lookupType="gov.va.med.esr.common.model.security.ESRUserPrincipalImpl" 
							 name="assignment" property="assignedTo"/>
					</td>
				    <td title="<c:out value="${assignedByText} ${status.count}"/>" nowrap><esrcore:displayLookupValue 
						  lookupType="gov.va.med.esr.common.model.security.ESRUserPrincipalImpl" 
							 name="assignment" property="assignedBy"/>
					</td>
			   </tr>
			   </c:forEach>
			   </tbody>
			   <tr><td colspan="3">&nbsp;</td></tr>				   
			</table>
			</td>
	</tr>
	</auth:authorize>	
   </table>  <!-- shell table -->					   					 					 
  </td>
</tr>
</table> <!-- shell -->
</html-el:form>
