<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/authz" prefix="auth" %>
<%@ page import='gov.va.med.esr.common.model.lookup.Capability' %>

<%-- Default to no permissions --%>
<c:set var="tabOverview" value="false"/>
<c:set var="tabEligibility" value="false"/>
<c:set var="tabDemographics" value="false"/>
<c:set var="tabMilitaryService" value="false"/>
<c:set var="tabFinancials" value="false"/>
<c:set var="tabEnrollment" value="false"/>
<c:set var="tabFacility" value="false"/>
<c:set var="tabCommunications" value="false"/>

<c:set var="overviewText" scope="page"><bean-el:message key="menu.overview"/>&nbsp;<bean-el:message key="label.tab"/></c:set>
<c:set var="eligibilityText" scope="page"><bean-el:message key="menu.eligibility"/>&nbsp;<bean-el:message key="label.tab"/></c:set>
<c:set var="demographicsText" scope="page"><bean-el:message key="menu.demographics"/>&nbsp;<bean-el:message key="label.tab"/></c:set>
<c:set var="militaryServiceText" scope="page"><bean-el:message key="menu.militaryservice"/>&nbsp;<bean-el:message key="label.tab"/></c:set>
<c:set var="financialsText" scope="page"><bean-el:message key="menu.financials"/>&nbsp;<bean-el:message key="label.tab"/></c:set>
<c:set var="enrollmentText" scope="page"><bean-el:message key="menu.enrollment"/>&nbsp;<bean-el:message key="label.tab"/></c:set>
<c:set var="facilityText" scope="page"><bean-el:message key="menu.facility"/>&nbsp;<bean-el:message key="label.tab"/></c:set>
<c:set var="communicationsText" scope="page"><bean-el:message key="menu.communications"/>&nbsp;<bean-el:message key="label.tab"/></c:set>
<c:set var="selectedTabText" scope="page"><bean-el:message key="label.selectedTab"/>,&nbsp;</c:set>

<%-- Re-enable permissions if the user has them --%>
<auth:authorize access="hasAnyRole(T(gov.va.med.esr.common.model.lookup.Capability).SEARCH)">
  <c:set var="tabOverview" value ="true"/>
</auth:authorize>
<auth:authorize access="hasAnyRole(T(gov.va.med.esr.common.model.lookup.Capability).ELIGIBILITY)">
  <c:set var="tabEligibility" value ="true"/>
</auth:authorize>
<auth:authorize access="hasAnyRole(T(gov.va.med.esr.common.model.lookup.Capability).DEMOGRAPHICS)">
  <c:set var="tabDemographics" value ="true"/>
</auth:authorize>
<auth:authorize access="hasAnyRole(T(gov.va.med.esr.common.model.lookup.Capability).MILITARY_SERVICE)">
  <c:set var="tabMilitaryService" value ="true"/>
</auth:authorize>
<auth:authorize access="hasAnyRole(T(gov.va.med.esr.common.model.lookup.Capability).FINANCIALS)">
  <c:set var="tabFinancials" value ="true"/>
</auth:authorize>
<auth:authorize access="hasAnyRole(T(gov.va.med.esr.common.model.lookup.Capability).ENROLLMENT)">
  <c:set var="tabEnrollment" value ="true"/>
</auth:authorize>
<auth:authorize access="hasAnyRole(T(gov.va.med.esr.common.model.lookup.Capability).FACILITIES)">
  <c:set var="tabFacility" value ="true"/>
</auth:authorize>
<auth:authorize access="hasAnyRole(T(gov.va.med.esr.common.model.lookup.Capability).COMMUNICATIONS)">
  <c:set var="tabCommunications" value ="true"/>
</auth:authorize>

<%-- Set color and images for each tab based on it being selected or not. --%>
<c:choose>
<c:when test="${tabName == 'overview'}">
  <c:set var="overviewImage" scope="page">on</c:set>
  <c:set var="overviewText" scope="page" value="${selectedTabText}${overviewText}"/>
</c:when>
<c:otherwise>
  <c:set var="overviewImage" scope="page">off</c:set>
</c:otherwise>
</c:choose>

<c:choose>
<c:when test="${tabName == 'eligibility'}">
  <c:set var="eligibilityImage" scope="page">on</c:set>
  <c:set var="eligibilityText" scope="page" value="${selectedTabText}${eligibilityText}"/>
</c:when>
<c:otherwise>
  <c:set var="eligibilityImage" scope="page">off</c:set>
</c:otherwise>
</c:choose>

<c:choose>
<c:when test="${tabName == 'demographics'}">
  <c:set var="demographicsImage" scope="page">on</c:set>
  <c:set var="demographicsText" scope="page" value="${selectedTabText}${demographicsText}"/>
</c:when>
<c:otherwise>
  <c:set var="demographicsImage" scope="page">off</c:set>
</c:otherwise>
</c:choose>

<c:choose>
<c:when test="${tabName == 'militaryService'}">
  <c:set var="militaryServiceImage" scope="page">on</c:set>
  <c:set var="militaryServiceText" scope="page" value="${selectedTabText}${militaryServiceText}"/>
</c:when>
<c:otherwise>
  <c:set var="militaryServiceImage" scope="page">off</c:set>
</c:otherwise>
</c:choose>

<c:choose>
<c:when test="${tabName == 'financials'}">
  <c:set var="financialsImage" scope="page">on</c:set>
  <c:set var="financialsText" scope="page" value="${selectedTabText}${financialsText}"/>
</c:when>
<c:otherwise>
  <c:set var="financialsImage" scope="page">off</c:set>
</c:otherwise>
</c:choose>

<c:choose>
<c:when test="${tabName == 'enrollment'}">
  <c:set var="enrollmentImage" scope="page">on</c:set>
  <c:set var="enrollmentText" scope="page" value="${selectedTabText}${enrollmentText}"/>
</c:when>
<c:otherwise>
  <c:set var="enrollmentImage" scope="page">off</c:set>
</c:otherwise>
</c:choose>

<c:choose>
<c:when test="${tabName == 'facility'}">
  <c:set var="facilityImage" scope="page">on</c:set>
  <c:set var="facilityText" scope="page" value="${selectedTabText}${facilityText}"/>
</c:when>
<c:otherwise>
  <c:set var="facilityImage" scope="page">off</c:set>
</c:otherwise>
</c:choose>

<c:choose>
<c:when test="${tabName == 'communications'}">
  <c:set var="communicationsImage" scope="page">on</c:set>
  <c:set var="communicationsText" scope="page" value="${selectedTabText}${communicationsText}"/>
</c:when>
<c:otherwise>
  <c:set var="communicationsImage" scope="page">off</c:set>
</c:otherwise>
</c:choose>
<c:set var="skipToMainContent" scope="page"><bean-el:message key="label.skipToMainContent"/></c:set>
<a id="ContentArea"><html-el:img src="/esr/images/spacer.gif" alt="${skipToMainContent}" width="1" height="1" border="0"/></a>
<table cellSpacing="0" cellPadding="0" border="0" >
  <tr valign="bottom">
    <c:if test="${tabOverview == true}"><td ><html-el:link styleId="es-tabs-vet-overview" styleClass="tabLink" href="/esr/admin/overview.do"><html-el:img alt="${overviewText}" src="/esr/images/tabs_overview_${overviewImage}.gif" border="0"/></html-el:link></td></c:if>
    <c:if test="${tabEligibility == true}"><td ><html-el:link styleId="es-tabs-vet-elig" styleClass="tabLink" href="/esr/ee/eligibilityView.display.do"><html-el:img alt="${eligibilityText}" src="/esr/images/tabs_eligibility_${eligibilityImage}.gif" border="0"/></html-el:link></td></c:if>
    <c:if test="${tabDemographics == true}"><td ><html-el:link styleId="es-tabs-vet-dem" styleClass="tabLink" forward="demographic.overview.display"><html-el:img alt="${demographicsText}" src="/esr/images/tabs_demographic_${demographicsImage}.gif" border="0"/></html-el:link></td></c:if>
    <c:if test="${tabMilitaryService == true}"><td ><html-el:link styleId="es-tabs-vet-ms" styleClass="tabLink" forward="mltryService"><html-el:img alt="${militaryServiceText}" src="/esr/images/tabs_militaryservice_${militaryServiceImage}.gif" border="0"/></html-el:link></td></c:if>
    <c:if test="${tabFinancials == true}"><td ><html-el:link styleId="es-tabs-vet-fin" styleClass="tabLink" forward="financials.overview.display"><html-el:img alt="${financialsText}" src="/esr/images/tabs_financials_${financialsImage}.gif" border="0"/></html-el:link></td></c:if>
    <c:if test="${tabEnrollment == true}"><td ><html-el:link styleId="es-tabs-vet-enr" styleClass="tabLink" href="/esr/ee/enrollment.do?methodName=DISPLAY"><html-el:img alt="${enrollmentText}" src="/esr/images/tabs_enrollment_${enrollmentImage}.gif" border="0"/></html-el:link></td></c:if>
    <c:if test="${tabFacility == true}"><td ><html-el:link styleId="es-tabs-vet-fac" styleClass="tabLink" href="/esr/facility/facility.do"><html-el:img alt="${facilityText}" src="/esr/images/tabs_facility_${facilityImage}.gif" border="0"/></html-el:link></td></c:if>
    <c:if test="${tabCommunications == true}"><td ><html-el:link styleId="es-tabs-vet-comms" styleClass="tabLink" forward="commslog.display"><html-el:img alt="${communicationsText}" src="/esr/images/tabs_communications_${communicationsImage}.gif" border="0"/></html-el:link></td></c:if>
    <td width="100%" style="border-bottom: 1px solid #000000;"><img alt="" src="../images/spacer.gif" height="1" width="100%"/></td>
  </tr>
</table>
