<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/valuelist" prefix="vlh" %>
<%@ taglib uri="/tags/fw" prefix="fw" %>
<%@ taglib uri="/tags/esr-core" prefix="esrcore" %>
<%@ taglib uri="/tags/authz" prefix="auth" %>
<%@ page import='gov.va.med.esr.common.model.lookup.Capability' %>
<%@ page import='gov.va.med.fw.util.StringUtils' %>

<c:set var="mmddyyyyText" scope="page"><bean-el:message key="label.mmddyyyy"/></c:set>

<c:choose>
<c:when test="${reportFilterForm.displayFilter}">
  <c:set var="showFilterAttribute" scope="page" value="none"/>
  <c:set var="hideFilterAttribute" scope="page" value="block"/>
</c:when>
<c:otherwise>
  <c:set var="showFilterAttribute" scope="page" value="block"/>
  <c:set var="hideFilterAttribute" scope="page" value="none"/>
</c:otherwise>
</c:choose>

<script type="text/javascript">
// Displays a confirmation message for cancelling the scheduled report
function cancelReportConfirmMessage()
{
    return confirmMessage('<bean-el:message key="message.report.confirmCancel"/>');
}

function showReportFilter()
{
	document.getElementById("reportFilter").style.display="block";
	document.getElementById("showReportFilterLink").style.display="none";
	document.getElementById("hideReportFilterLink").style.display="block";
	return false;
}

function hideReportFilter()
{
	document.getElementById("reportFilter").style.display="none";
	document.getElementById("showReportFilterLink").style.display="block";
	document.getElementById("hideReportFilterLink").style.display="none";
	return false;
}
</script>
<table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShell" role="presentation">
  <html-el:form action="/scheduledReports" method="post">
    <%@ include file="/admin/csrfgentoken.jsp" %>
  <tr>
    <td width="100%">
      <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableBody" role="presentation">
        <tr>
          <td>
            <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead" role="presentation">
              <tr>
                <td class="moduleBlueBox"><img alt="" src="../images/spacer.gif" width="25" height="17"/></td>
                <td class="moduleHeadline" nowrap><bean-el:message key="title.report.scheduledReports" /></td>
                <c:if test="${reportFilterForm.filterApplied}">
                  <td nowrap class="moduleHeadline" style="padding-left: 7px">(<bean-el:message key="label.report.filterApplied"/>)</td>
                </c:if>
                <td width="100%"><img alt=""  src="../images/spacer.gif"/>
                <td class="moduleBlueLink" style="padding: 1px 8px 1px 8px" nowrap><fw:link action="addReportSchedule.do?methodName=displayReportSelection"><bean-el:message key="label.report.scheduleNewReport"/></fw:link></td>
                <td><img alt="" src="../images/spacer.gif" width="1"/></td>
                <td class="moduleBlueLink" style="padding: 1px 8px 1px 8px" nowrap>
                  <div id="showReportFilterLink" style="display:<c:out value="${showFilterAttribute}"/>">
                    <fw:link onclick="return(showReportFilter());return false" action="none"><bean-el:message key="button.report.showReportFilter" /></fw:link>
                  </div>
                  <div id="hideReportFilterLink" style="display:<c:out value="${hideFilterAttribute}"/>">
                    <fw:link onclick="return(hideReportFilter());return false" action="none"><bean-el:message key="button.report.hideReportFilter" /></fw:link>
                  </div>
                </td>
              </tr>
            </table>
          </td>
        </tr>

        <tr>
          <td class="moduleValue">
            <table id="tableResult" align="center" width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleTable" role="presentation">
              <%-- Report Filter Selections --%>
              <tr id="reportFilter" style="display:<c:out value="${hideFilterAttribute}"/>">
                <td style="padding:10px">
                  <table width="100%" border="0" cellpadding="0" cellspacing="0" role="presentation">
                    <tr>
                      <td width="20%" class="moduleLabel"><fw:label property="reportType" forId="reportTypeId">
                        <bean-el:message key="label.report.reportType"/>:</fw:label>
                      </td>
                      <td width="30%" class="moduleValue">
                        <c:set var="reportTypeText"><bean-el:message key="label.report.reportType"/></c:set>
                        <html-el:select title="${reportTypeText}" styleClass="moduleEdit" styleId="reportTypeId" property="reportType" >
                          <html-el:option value=""><bean-el:message key="label.select" /></html-el:option>
                          <esrcore:options collection="reportTypeList" property="code" labelProperty="description"/>
                        </html-el:select>
                      </td>
                      <td width="20%" class="moduleLabel"><fw:label property="fileType" forId="fileTypeId">
                        <bean-el:message key="label.report.fileType"/>:</fw:label>
                      </td>
                      <td width="30%" class="moduleValue">
                        <c:set var="fileTypeText"><bean-el:message key="label.report.fileType"/></c:set>
                        <html-el:select title="${fileTypeText}" styleClass="moduleEdit" styleId="fileTypeId" property="fileType" >
                          <html-el:option value=""><bean-el:message key="label.select" /></html-el:option>
                          <esrcore:options collection="fileTypeList" property="code" labelProperty="description"/>
                        </html-el:select>
                      </td>
                    </tr>

                    <tr>
                      <td width="20%" class="moduleLabel"><fw:label property="reportId" forId="reportId">
                        <bean-el:message key="label.report.reportId"/>:</fw:label>
                      </td>
                      <td width="30%" class="moduleValue">
                        <c:set var="reportIdText"><bean-el:message key="label.report.reportId"/></c:set>
                        <html-el:select title="${reportIdText}" styleClass="moduleEdit" styleId="reportId" property="reportId" >
                          <html-el:option value=""><bean-el:message key="label.select" /></html-el:option>
                          <esrcore:options collection="reportIdList" property="code" labelProperty="code"/>
                        </html-el:select>
                      </td>
                      <td width="20%" class="moduleLabel"><fw:label property="dateFilter" forId="dateFilterId">
                        <bean-el:message key="label.report.scheduledRunDate"/>:</fw:label>
                      </td>
                      <td nowrap="true" width="30%" class="moduleValue">
                        <c:set var="dateRunFromText"><bean-el:message key="label.report.scheduledRunDate"/>,&nbsp;<bean-el:message key="label.from"/>&nbsp;<c:out value="${mmddyyyyText}"/></c:set>
                        <c:set var="dateRunToText"><bean-el:message key="label.report.scheduledRunDate"/>,&nbsp;<bean-el:message key="label.to"/>&nbsp;<c:out value="${mmddyyyyText}"/></c:set>
                        <html-el:text title="${dateRunFromText}" property="dateFrom" styleId="dateFilterId" size="10" maxlength="10"/>&nbsp;-&nbsp;
                        <fw:label property="dateTo" forId="dateToId"><span style="display:none">${dateRunToText}</span></fw:label>
                        <html-el:text title="${dateRunToText}" property="dateTo" styleId="dateToId" size="10" maxlength="10"/>&nbsp;<bean-el:message key="label.dateFormatmmddyyyy"/>
                      </td>
                    </tr>

                    <tr>
                      <td width="20%" class="moduleLabel"><fw:label property="reportTitle" forId="reportTitleId">
                        <bean-el:message key="label.report.reportTitle"/>:</fw:label>
                      </td>
                      <td width="30%" class="moduleValue">
                        <c:set var="reportTitleText"><bean-el:message key="label.report.reportTitle"/></c:set>
                        <html-el:select title="${reportTitleText}" styleClass="moduleEdit" styleId="reportTitleId" property="reportTitle" >
                          <html-el:option value=""><bean-el:message key="label.select" /></html-el:option>
                          <esrcore:options collection="reportTitleList" property="code" labelProperty="description"/>
                        </html-el:select>
                      </td>
                      <td width="20%" class="moduleLabel">&nbsp;</td>
                      <td width="30%" class="moduleValue">&nbsp;</td>
                    </tr>

                    <tr>
                      <td colspan="4" style="text-align: center">
                        <table width="100%" border="0" cellpadding="0" cellspacing="0" role="presentation">
                          <tr>
                            <td width="50%"><img alt="" src="../images/spacer.gif"/></td>
                            <td style="padding-left:10px"><img alt=""  src="../images/buttonEndLeft.gif"/></td>
                            <td>
                              <html-el:submit property="methodName" style="width:80; vertical-align: top;" styleClass="buttonText">
                                <bean-el:message key="button.applyFilter"/>
                              </html-el:submit>
                            </td>
                            <td style="padding-right:5px"><img alt=""  src="../images/buttonEndRight.gif"/></td>
                            <td style="padding-left:5px"><img alt=""  src="../images/buttonEndLeft.gif"/></td>
                            <td>
                              <html-el:submit property="methodName" style="width:80; vertical-align: top;" styleClass="buttonText">
                                <bean-el:message key="button.resetFilter"/>
                              </html-el:submit></td>
                            <td style="padding-right:10px"><img alt=""  src="../images/buttonEndRight.gif"/></td>
                            <td width="50%"><img alt=""  src="../images/spacer.gif"/></td>
                          </tr>
                        </table>
                      </td>
                    </tr>
                  </table>
                </td>
              </tr>

              <c:choose>
              <c:when test="${vlhlist.valueListInfo.totalNumberOfEntries > 0}">
              <vlh:root id="schReportTableId" value="vlhlist" url="?" includeParameters="*" configName="valueListConfigBeanLookAndFeel">
              <vlh:addParam name="checkboxName" value="Select" temp="false"/>
              <tr>
                <td>
                  <table class="pagelinks" cellpadding="0" cellspacing="0" border="0">
                    <tr>
                      <td width="45%"><img alt=""  src="../images/spacer.gif"></td>
                      <td width="5%" height="21" nowrap="true"><span class="pagebanner"><c:out value="${vlhlist.valueListInfo.totalNumberOfEntries}"/> Total - Page (<c:out value="${vlhlist.valueListInfo.pagingPage}"/> of <c:out value="${vlhlist.valueListInfo.totalNumberOfPages}"/>).&nbsp;</span></td>
                      <td width="5%">
                        <c:if test="${vlhlist.valueListInfo.totalNumberOfPages > 1}">
                          <vlh:paging attributes="class=\"pagelinks\"" pages="10"><c:out value="${pageschReportTableId}"/>&nbsp;</vlh:paging>
                        </c:if>
                      </td>
                      <td width="45%"><img alt=""  src="../images/spacer.gif"></td>
                    </tr>
                  </table>
                </td>
              </tr>

              <tr vAlign="top">
                <td vAlign="top" align="center">
                  <table summary="List of Scheduled Reports" rules="all" class="TableDisplay" cellspacing="0" cellpadding="3">
                    <tr>
                      <vlh:row bean="reportSetupLite">
                        <c:set var="counter" value="${(vlhlist.valueListInfo.pagingNumberPer * (vlhlist.valueListInfo.pagingPage-1)) + reportSetupLiteRowNumber + 1}"/>
                        <c:set var="reportIdParam" value="${reportSetupLite.entityKey.keyValueAsString}" scope="request"/>                        
                        <vlh:column title="#" property="id" attributes="class='valuelistRow1' align='left' scope='col'" default="">
                          <vlh:attribute name="style">white-space: nowrap</vlh:attribute>
                          <vlh:attribute name="scope">row</vlh:attribute>
                          <c:out value="${counter}"/>.
                        </vlh:column>
                        <vlh:column titleKey="label.report.reportType" property="report.type.description" sortable="asc" attributes="class='valuelistRow1' align='left' scope='col'" default="">
                            <vlh:attribute name="style">white-space: nowrap</vlh:attribute>
                        </vlh:column>
                        <vlh:column titleKey="label.report.reportId" property="report.code" sortable="asc" attributes="class='valuelistRow1' align='left' nowrap scope='col'" default="">
                            <vlh:attribute name="style">white-space: nowrap</vlh:attribute>
                        </vlh:column>
                        <vlh:column titleKey="label.report.reportTitle" property="report.description" sortable="asc" attributes="class='valuelistRow1' width='100%' align='left' nowrap scope='col'" default="" />
                        <vlh:column titleKey="label.report.fileType" property="fileType.description" sortable="asc" attributes="class='valuelistRow1' align='left' scope='col'" default="">
                          <vlh:attribute name="style">white-space: nowrap</vlh:attribute>
                        </vlh:column>
                        <vlh:column titleKey="label.report.scheduledRunDate" property="dateToGenerate" sortable="asc" attributes="class='valuelistRow1' align='left' nowrap scope='col'" default="">
                          <vlh:attribute name="style">white-space: nowrap</vlh:attribute>
                          <esrcore:displayDate name="reportSetupLite" dateProperty="dateToGenerate" format="MM/dd/yyyy h:mm:ssa"/>
                        </vlh:column>
                        
                        <vlh:column titleKey="label.report.action" attributes="scope='col'">
                          <vlh:attribute name="style">white-space: nowrap</vlh:attribute>                           											                           
                           <auth:authorize access="hasAnyRole(${reportSetupLite.report.type.scheduleRunPermissionCode})">
                          	<fw:link action="/scheduledReports.do?methodName=cancelScheduledReport" paramId="cancelReportId" paramName="reportIdParam" onclick="return(cancelReportConfirmMessage())"><bean-el:message key="label.report.cancelReport" /></fw:link>
                          </auth:authorize>                                            
                        </vlh:column>
                      </vlh:row>
                    </tr>
                  </table>
                </td>
              </tr>

              <tr>
                <td>
                  <table class="pagelinks" cellpadding="0" cellspacing="0" border="0">
                    <tr>
                      <td width="45%"><img alt=""  src="../images/spacer.gif"></td>
                      <td width="5%" height="21" nowrap="true"><span class="pagebanner"><c:out value="${vlhlist.valueListInfo.totalNumberOfEntries}"/> Total - Page (<c:out value="${vlhlist.valueListInfo.pagingPage}"/> of <c:out value="${vlhlist.valueListInfo.totalNumberOfPages}"/>).&nbsp;</span></td>
                      <td width="5%">
                        <c:if test="${vlhlist.valueListInfo.totalNumberOfPages > 1}">
                          <vlh:paging attributes="class=\"pagelinks\"" pages="10"><c:out value="${pageschReportTableId}"/>&nbsp;</vlh:paging>
                        </c:if>
                      </td>
                      <td width="45%"><img alt=""  src="../images/spacer.gif"></td>
                    </tr>
                  </table>
                </td>
              </tr>
              </vlh:root>
              </c:when>
              <c:otherwise>
              <tr>
                <td class="moduleValue">
                  <bean-el:message key="label.noDataAvailable" />
                </td>
              </tr>
              </c:otherwise>
              </c:choose>
            </table>
          </td>
        </tr>
      </table>
    </td>
  </tr>
  </html-el:form>
</table>
