<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="/tags/struts-tiles" prefix="tiles" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>

<%@ taglib uri="/tags/esr-core" prefix="esrcore" %>
<%@ page import="org.apache.struts.Globals" %>
<%@ page import="org.apache.struts.action.ActionMessages" %>

<!-- Import the tile parameters to the pageScopr -->
<tiles:importAttribute name="bundle" ignore="true" scope="request" />
<tiles:importAttribute name="title"  ignore="false" scope="request" />
<tiles:importAttribute name="helpIdName" ignore="true" scope="request" />
<tiles:importAttribute name="breadCrumb" ignore="true" />
<tiles:importAttribute name="pageName" ignore="false" scope="request" />
<tiles:importAttribute name="tabName" ignore="false" scope="request"/>
<tiles:importAttribute name="onLoadMethodName" ignore="true" scope="request"/>
<tiles:importAttribute name="headerTitleKey" ignore="true" scope="request"/>

<!-- If resource bundle name is provided get the message from that resource bundle -->
<c:if test="${not empty bundle}">
    <c:set var="pageTitle"><bean-el:message bundle="${bundle}" key="${title}" /></c:set>
</c:if>

<!-- If resource bundle name is not provided get the message from the default resource bundle -->
<c:if test="${empty bundle}" >
    <c:set var="pageTitle"><bean-el:message key="${title}" /></c:set>
</c:if>

<c:set var="screenHelp" scope="page"><bean-el:message key="header.screenHelp" /></c:set>
<c:set var="contextPath" scope="page"><%=request.getContextPath()%></c:set>

<head>
    <title><c:out value="${pageTitle}" /></title>
    <meta http-equiv="x-ua-compatible" content="IE=5">
    <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
    <meta http-equiv="pragma" content="no-cache">
    <meta http-equiv="cache-control" content="no-cache">
    <meta http-equiv="expires" content="0">

    <link href="../stylesheets/ESR_structure.css" rel="stylesheet" type="text/css">

  <!-- ULTIMATE DROP DOWN MENU Version 4.5 by Brothercake -->
  <!-- http://www.udm4.com/ -->
  <script type="text/javascript" src="../scripts/udm-custom.js"></script>
  <script type="text/javascript" src="../scripts/udm-control.js"></script>
  <script type="text/javascript" src="../scripts/udm-style.js"></script>
</head>

<script language="JavaScript" src="../scripts/ESR-Script.js"></script>
<script language="JavaScript" src="../scripts/RoboHelp_CSH.js"></script>
<!-- <script language="JavaScript" src="scripts/RoboHelp_CSH.js"></script> -->

<body bgcolor="#E8EDF7" onLoad="<c:out value="${onLoadMethodName}"/>">
<% String breadCrumb = (String)pageContext.getAttribute("breadCrumb"); %>
<table width="100%" border="0" cellspacing="0" cellpadding="0">
<tiles:insert attribute="header" />
  <tr>
    <td colspan="4" valign="top" class="conWellBkg" align="center">
      <table class="contentPanel" width="98%" border="0" cellspacing="0" cellpadding="0">
	   <c:if test="${(not empty breadCrumb) or (not empty helpIdName)}">
		<tr>
			<td class="conSubPanelBread" align="left">
		     <c:if test="${not empty breadCrumb}">
		 		   <esrcore:breadCrumb crumbs="<%=breadCrumb%>"/>
		     </c:if>
			</td>
		   <c:if test="${not empty helpIdName}">
		    <td nowrap class="conSubPanelBread" align="right" style="padding-left: 0; padding-right: 10; text-align: right">
        	<a id="es-tabs-help"  class= " helpFocus" href="javascript:ESR_ShowHelp(<bean-el:message key="${helpIdName}"/>)"><html-el:img alt="${screenHelp}" border="0" src="${contextPath}/images/esr_help_small.gif"/></a>
		    </td>
		   </c:if>
		</tr>
	   </c:if>
        <tr>
          <td colspan="2" width="100%" class="conPanelBody">
            <table width="100%" border="0" cellpadding="0" cellspacing="0">
              <html-el:form action="/personMerge" method="post">
              <tr>
                <td style="padding: 10">
                  <table width="100%" border="0" cellpadding="0" cellspacing="0">

                    <tr>
                      <td align="left" valign="top">
                        <%@ include file="/tiles/common/asyncMessage.jsp" %>
                      </td>
                    </tr>
                    <tr>
                      <td align="left" valign="top">
                        <%@ include file="/tiles/common/errorMessage.jsp" %>
                      </td>
                    </tr>
                    <tr>
                      <td align="left" valign="top">
                        <%@ include file="/tiles/common/informationMessage.jsp" %>
                      </td>
                    </tr>

                    <%-- Veteran Header --%>
                    <tr>
                      <td>
                        <tiles:insert attribute="veteranHeader"/>
                      </td>
                    </tr>

                    <tr>
                      <td width="100%"><img alt=""  src="../images/spacer.gif" height="10" /></td>
                    </tr>

                    <%-- Main Menu (Tabs) --%>
                    <tr>
                      <td>
                        <tiles:insert attribute="mainMenu"/>
                      </td>
                    </tr>
                  </table>

                  <a name="ContentArea"/>
                  <table width="100%" style="border-left: 1px solid #000000; border-right: 1px solid #000000; border-bottom: 1px solid #000000;" border="0" cellpadding="0" cellspacing="15">
                    <%-- Tab Specific Content --%>
                    <tr>
                      <td>
                        <tiles:insert attribute="content" />
                      </td>
                    </tr>
                  </table>

                </td>
              </tr>
              <input id="methodNameId" type="hidden" name="methodName" value="">
            </html-el:form>
            </table>
          </td>
        </tr>
      </table>
    </td>
  </tr>
  <tr>
    <tiles:insert attribute="footer" />
  </tr>
</table>

<script type="text/javascript" language="javascript">
getAsyncMessages();
</script>

</body>
