<%@ page contentType="text/html;charset=UTF-8" %>
<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/fw" prefix="fw" %>
<%@ taglib uri="/tags/esr-core" prefix="esrcore" %>
<%@ taglib uri="/tags/authz" prefix="auth" %>
<%@ page import='gov.va.med.esr.common.model.lookup.Capability' %>
<%@ page import="gov.va.med.esr.common.model.lookup.MHDataSource" %>


<c:set var="IndicatorNO"><%=gov.va.med.esr.common.model.lookup.Indicator.NO.getCode()%></c:set>
<c:set var="IndicatorYES"><%=gov.va.med.esr.common.model.lookup.Indicator.YES.getCode()%></c:set>
<c:set var="expandableSectionCollapsed" scope="page">
	<bean-el:message key="label.expandableSectionCollapsed" />
</c:set>

<esrcore:setLookup var="SortedIndicator"
	className="gov.va.med.esr.ui.common.beans.SortedIndicator" />


<c:set var="isAddAPerson" value="false"></c:set>
<c:set var="displayAddAPersonRequiredFieldIndicator" scope="page"
	value="false" />
<c:set var="datasource_vadir" scope="page" ><%=MHDataSource.VADIR.getName()%></c:set>
<c:set var="datasource_webhinq" scope="page"><%=MHDataSource.WEBHINQ.getName()%></c:set>
<c:set var="datasource_vba" scope="page" ><%=MHDataSource.VBA.getName()%></c:set>
<c:set var="datasource_other" scope="page"><%=MHDataSource.OTHER.getName()%></c:set>
<c:if test="${AppData.addAPerson != null && AppData.addAPerson == true}">
        <c:set var="isAddAPerson" value="true"></c:set>
        <c:set var="displayAddAPersonRequiredFieldIndicator" value="true"></c:set>
</c:if>

<c:choose>
<c:when test="${displayAddAPersonRequiredFieldIndicator}">
<c:set var="requiredAddAPersonFlag"><%= Boolean.TRUE.toString() %></c:set>
		<c:set var="requiredAddAPersonText">
			<bean-el:message key="label.required" />,&nbsp;</c:set>
</c:when>
<c:otherwise>
<c:set var="requiredAddAPersonFlag"><%= Boolean.FALSE.toString() %></c:set>
<c:set var="requiredAddAPersonText"></c:set>
</c:otherwise>
</c:choose>


<c:set var="readOnlyMS" scope="request" value="true"/>
<c:set var="requiredText">
	<bean-el:message key="label.required" />
</c:set>
<c:set var="button_deleteOefOifCombatEpisode">
	<bean-el:message key="button.deleteOefOifCombatEpisode" />
</c:set>
<c:set var="button_deleteMilitaryServiceEpisode">
	<bean-el:message key="button.deleteMilitaryServiceEpisode" />
</c:set>
<c:set var="button_deleteConflictEpisode">
	<bean-el:message key="button.deleteConflictEpisode" />
</c:set>

<!-- add/edit militray service are not differentiated -->
<auth:authorize access="hasAnyRole(T(gov.va.med.esr.common.model.lookup.Capability).ADD_MILITARY_SERVICE_INFO.getName())">
  <c:set var="readOnlyMS" scope="request" value="false"/>
</auth:authorize>
<auth:authorize access="hasAnyRole(T(gov.va.med.esr.common.model.lookup.Capability).EDIT_MILITARY_SERVICE_INFO.getName())">
  <c:set var="readOnlyMS" scope="request" value="false"/>
</auth:authorize>

<!-- FDD -->
<c:set var="readOnlyFDDA" scope="request" value="true" />
<c:set var="readOnlyFDDE" scope="request" value="true" />
<!-- add/edit future discharge are not differentiated -->
<auth:authorize
	access="hasAnyRole(T(gov.va.med.esr.common.model.lookup.Capability).ADD_FUTURE_DISCHARGE_DATE.getName())">
	<c:set var="readOnlyFDDA" scope="request" value="false" />
</auth:authorize>
<auth:authorize
	access="hasAnyRole(T(gov.va.med.esr.common.model.lookup.Capability).EDIT_FUTURE_DISCHARGE_DATE.getName())">
	<c:set var="readOnlyFDDE" scope="request" value="false" />
</auth:authorize>



  <%-- Person Locked Check --%>
<c:set var="appData" value="${AppData}" scope="session"/>
<c:set var="personKey" value="SelectedPerson"/>
<c:set var="personLocked" value="${appData[personKey].personLocked}"/>
<c:if test="${personLocked}">
  <c:set var="readOnlyMS" scope="request" value="true"/>
</c:if>

<c:set var="mmddyyyyText" scope="page">
	<bean-el:message key="label.mmddyyyy" />
</c:set>

<%-- start of variables from  newMedalOfHonor.jsp--%>

<c:set var="readOnlyMS" scope="request" value="true"/>

<!-- add/edit militray service are not differentiated -->
<auth:authorize access="hasAnyRole(T(gov.va.med.esr.common.model.lookup.Capability).ADD_MILITARY_SERVICE_INFO.getName())">
  <c:set var="readOnlyMS" scope="request" value="false"/>
</auth:authorize>
<auth:authorize access="hasAnyRole(T(gov.va.med.esr.common.model.lookup.Capability).EDIT_MILITARY_SERVICE_INFO.getName())">
  <c:set var="readOnlyMS" scope="request" value="false"/>
</auth:authorize>

  <%-- Person Locked Check --%>
<c:set var="appData" value="${AppData}" scope="session"/>
<c:set var="personKey" value="SelectedPerson"/>
<c:set var="personLocked" value="${appData[personKey].personLocked}"/>
<c:if test="${personLocked}">
  <c:set var="readOnlyMS" scope="request" value="true"/>
</c:if>

<c:set var="MHRequiredFields" scope="page" value="true" />
<c:choose>
<c:when test="${MHRequiredFields}">
<c:set var="requiredFlag"><%= Boolean.TRUE.toString() %></c:set>
		<c:set var="requiredText">
			<bean-el:message key="label.required" />,&nbsp;</c:set>
</c:when>
<c:otherwise>
<c:set var="requiredFlag"><%= Boolean.FALSE.toString() %></c:set>
<c:set var="requiredText"></c:set>
</c:otherwise>
</c:choose>

<%-- <c:set var="mmddyyyyText" scope="page"><bean-el:message key="label.mmddyyyy"/></c:set>  --%>
<%-- <c:set var="expandableSectionCollapsed" scope="page"><bean-el:message key="label.expandableSectionCollapsed"/></c:set>  --%>
<%-- <c:set var="datasource_vadir" scope="page" ><%=MHDataSource.VADIR.getName()%></c:set>  --%>
<%-- <c:set var="datasource_webhinq" scope="page"><%=MHDataSource.WEBHINQ.getName()%></c:set>   --%>
<%-- <c:set var="datasource_vba" scope="page" ><%=MHDataSource.VBA.getName()%></c:set>  --%>
<%-- <c:set var="datasource_other" scope="page"><%=MHDataSource.OTHER.getName()%></c:set>  --%>
<c:set var="MOHDataSourcesNotAllowedWarning">
	<bean-el:message key="message.MOHDataSourcesNotAllowed" />
</c:set>



<%-- end of variables from newMedalOfHonor.jsp --%>

<script src="../scripts/ESR-Script.js" type="text/javascript"></script>

<script type="text/javascript" language="JavaScript">

var isMSEChanged = false;
var mseSize=0;
var needAgentOrangeExposureLocationWarning = false;
var needRadiationExposureMethodWarning = false;
var needSourceofChangeWarning = false;
var needBranchofServiceWarning = false;
var needDischargeTypeWarning = false;

function onLoadInit()
{   
    processCLVIndicator();
    processCLVEligibility(${militaryServiceInfoForm.campLejeuneDisabled});
    processMOHIndicator('n');
    processAddPerson(${AppData.addAPerson});
    countMethods();
    checkForOtherVerificationMethod();
    processInitialFDDLoad(${militaryServiceInfoForm.numberOfServiceEpisodes});
}

function removeServiceComponent(fieldId,msg)
{
  var field = document.getElementById(fieldId);
  if(field != null && field.value.length > 0)
  {
    //alert(msg);
    needBranchofServiceWarning = true;
    //alert("randy4")
    field.value = "";
  }
}

function checkIfChanged(hiddenFieldId,fieldId,serviceComponentFieldId,msg) {
    var hiddenField = document.getElementById(hiddenFieldId);
    var selectedOption = document.getElementById(fieldId).options[document.getElementById(fieldId).selectedIndex];
    if ( hiddenField.value != selectedOption.value ) {
        removeServiceComponent(serviceComponentFieldId,msg);
        hiddenField.value = selectedOption.value;
    }
}

function checkIfDischargeTypeChanged(hiddenFieldId,fieldId) {
    var hiddenField = document.getElementById(hiddenFieldId);
    var selectedOption = document.getElementById(fieldId).options[document.getElementById(fieldId).selectedIndex];
    if ( hiddenField.value != selectedOption.value ) {
        processMSEChanged();
        hiddenField.value = selectedOption.value;
    }
    
}


function displayMessageIfAgentOrangeExposureLocationEmpty(hiddenFieldId, fieldId, msg)
{
  var hiddenField = document.getElementById(hiddenFieldId);
  //var selectedOption = document.getElementById(fieldId).options[document.getElementById(fieldId).selectedIndex];
  //var selectedOption = document.getElementById(fieldId);
  //if ( hiddenField.value != selectedOption.value ) 
  if ( hiddenField.value != fieldId.value ) 
  {
      if (fieldId != null && fieldId.value.length == 0)
        {
          //alert("randy1");
          needAgentOrangeExposureLocationWarning = true;
        }
  }

}

function displayMessageIfRadiationExposureMethodEmpty(hiddenFieldId, fieldId, msg)
{
  var hiddenField = document.getElementById(hiddenFieldId);
  //var selectedOption = document.getElementById(fieldId).options[document.getElementById(fieldId).selectedIndex];
  //var selectedOption = document.getElementById(fieldId);
  //if ( hiddenField.value != selectedOption.value ) 
  if ( hiddenField.value != fieldId.value ) 
  {
      if (fieldId != null && fieldId.value.length == 0)
        {
          //alert("randy2");
          needRadiationExposureMethodWarning = true;
        }
  }

}

function displyWarnings()
{
    var msg_orange_rediation_dataSource_branchService_dischareType = "Removing the Agent Orange Location will change the Agent Orange Indicator to No. \n \nRemoving the Radiation Exposure Method will change the Radiation Exposure Indicator to No. \n \nMedal Of Honor Data Source must be either VBA or Other From UI. \n \nChanging the Branch of Service will eliminate the Service Component if Service Component is present. \n \nUpdating the Veteran\'s military service will make the Veteran Camp Lejeune ineligible. Are you sure you want to make this change?"
    var msg_orange_rediation_dataSource_branchService = "Removing the Agent Orange Location will change the Agent Orange Indicator to No. \n \nRemoving the Radiation Exposure Method will change the Radiation Exposure Indicator to No. \n \nMedal Of Honor Data Source must be either VBA or Other From UI. \n \nChanging the Branch of Service will eliminate the Service Component if Service Component is present."
    var msg_orange_rediation_dataSource_dischargeType = "Removing the Agent Orange Location will change the Agent Orange Indicator to No. \n \nRemoving the Radiation Exposure Method will change the Radiation Exposure Indicator to No. \n \nMedal Of Honor Data Source must be either VBA or Other From UI. \n \nUpdating the Veteran\'s military service will make the Veteran Camp Lejeune ineligible. Are you sure you want to make this change?"
    var msg_orange_rediation_dataSource = "Removing the Agent Orange Location will change the Agent Orange Indicator to No. \n \nRemoving the Radiation Exposure Method will change the Radiation Exposure Indicator to No. \n \nMedal Of Honor Data Source must be either VBA or Other From UI."
    var msg_orange_rediation_branchService_dischargeType = "Removing the Agent Orange Location will change the Agent Orange Indicator to No. \n \nRemoving the Radiation Exposure Method will change the Radiation Exposure Indicator to No. \n \nChanging the Branch of Service will eliminate the Service Component if Service Component is present. \n \nUpdating the Veteran\'s military service will make the Veteran Camp Lejeune ineligible. Are you sure you want to make this change?"
    var msg_orange_rediation_branchService = "Removing the Agent Orange Location will change the Agent Orange Indicator to No. \n \nRemoving the Radiation Exposure Method will change the Radiation Exposure Indicator to No. \n \nChanging the Branch of Service will eliminate the Service Component if Service Component is present."
    var msg_orange_rediation_dischargeType = "Removing the Agent Orange Location will change the Agent Orange Indicator to No. \n \nRemoving the Radiation Exposure Method will change the Radiation Exposure Indicator to No. \n \nUpdating the Veteran\'s military service will make the Veteran Camp Lejeune ineligible. Are you sure you want to make this change?"
    var msg_orange_rediation = "Removing the Agent Orange Location will change the Agent Orange Indicator to No. \n \nRemoving the Radiation Exposure Method will change the Radiation Exposure Indicator to No."
    var msg_orange_dataSource_branchService_dischargeType = "Removing the Agent Orange Location will change the Agent Orange Indicator to No. \n \nMedal Of Honor Data Source must be either VBA or Other From UI. \n \nChanging the Branch of Service will eliminate the Service Component if Service Component is present. \n \nUpdating the Veteran\'s military service will make the Veteran Camp Lejeune ineligible. Are you sure you want to make this change?"
    var msg_orange_dataSource_branchService = "Removing the Agent Orange Location will change the Agent Orange Indicator to No. \n \nMedal Of Honor Data Source must be either VBA or Other From UI. \n \nChanging the Branch of Service will eliminate the Service Component if Service Component is present."
    var msg_orange_dataSource_dischargeType = "Removing the Agent Orange Location will change the Agent Orange Indicator to No. \n \nMedal Of Honor Data Source must be either VBA or Other From UI. \n \nUpdating the Veteran\'s military service will make the Veteran Camp Lejeune ineligible. Are you sure you want to make this change?"
    var msg_orange_dataSource = "Removing the Agent Orange Location will change the Agent Orange Indicator to No. \n \nMedal Of Honor Data Source must be either VBA or Other From UI."
    var msg_orange_branchService_dischargeType = "Removing the Agent Orange Location will change the Agent Orange Indicator to No. \n \nChanging the Branch of Service will eliminate the Service Component if Service Component is present. \n \nUpdating the Veteran\'s military service will make the Veteran Camp Lejeune ineligible. Are you sure you want to make this change?"
    var msg_orange_branchService = "Removing the Agent Orange Location will change the Agent Orange Indicator to No. \n \nChanging the Branch of Service will eliminate the Service Component if Service Component is present."
    var msg_orange_dischargeType = "Removing the Agent Orange Location will change the Agent Orange Indicator to No. \n \nUpdating the Veteran\'s military service will make the Veteran Camp Lejeune ineligible. Are you sure you want to make this change?"
    var msg_orange = "Removing the Agent Orange Location will change the Agent Orange Indicator to No."
    var msg_rediation_dataSource_branchService_dischargeType = "Removing the Radiation Exposure Method will change the Radiation Exposure Indicator to No. \n \nMedal Of Honor Data Source must be either VBA or Other From UI. \n \nChanging the Branch of Service will eliminate the Service Component if Service Component is present. \n \nUpdating the Veteran\'s military service will make the Veteran Camp Lejeune ineligible. Are you sure you want to make this change?"
    var msg_rediation_dataSource_branchService = "Removing the Radiation Exposure Method will change the Radiation Exposure Indicator to No. \n \nMedal Of Honor Data Source must be either VBA or Other From UI. \n \nChanging the Branch of Service will eliminate the Service Component if Service Component is present."
    var msg_rediation_dataSource_dischargeType = "Removing the Radiation Exposure Method will change the Radiation Exposure Indicator to No. \n \nMedal Of Honor Data Source must be either VBA or Other From UI. \n \nUpdating the Veteran\'s military service will make the Veteran Camp Lejeune ineligible. Are you sure you want to make this change?"
    var msg_rediation_dataSource = "Removing the Radiation Exposure Method will change the Radiation Exposure Indicator to No. \n \nMedal Of Honor Data Source must be either VBA or Other From UI."
    var msg_rediation_branchService_dischargeType = "Removing the Radiation Exposure Method will change the Radiation Exposure Indicator to No. \n \nChanging the Branch of Service will eliminate the Service Component if Service Component is present. \n \nUpdating the Veteran\'s military service will make the Veteran Camp Lejeune ineligible. Are you sure you want to make this change?"
    var msg_rediation_branchService = "Removing the Radiation Exposure Method will change the Radiation Exposure Indicator to No. \n \nChanging the Branch of Service will eliminate the Service Component if Service Component is present."
    var msg_rediation_dischargeType = "Removing the Radiation Exposure Method will change the Radiation Exposure Indicator to No. \n \nUpdating the Veteran\'s military service will make the Veteran Camp Lejeune ineligible. Are you sure you want to make this change?"
    var msg_rediation = "Removing the Radiation Exposure Method will change the Radiation Exposure Indicator to No."
    var msg_dataSource_branchService_dischargeType = "Medal Of Honor Data Source must be either VBA or Other From UI. \n \nChanging the Branch of Service will eliminate the Service Component if Service Component is present. \n \nUpdating the Veteran\'s military service will make the Veteran Camp Lejeune ineligible. Are you sure you want to make this change?"
    var msg_dataSource_branchService = "Medal Of Honor Data Source must be either VBA or Other From UI. \n \nChanging the Branch of Service will eliminate the Service Component if Service Component is present."
    var msg_dataSource_dischargeType = "Medal Of Honor Data Source must be either VBA or Other From UI. \n \nUpdating the Veteran\'s military service will make the Veteran Camp Lejeune ineligible. Are you sure you want to make this change?"
    var msg_dataSource = "Medal Of Honor Data Source must be either VBA or Other From UI."
    var msg_branchService_dischargeType = "Changing the Branch of Service will eliminate the Service Component if Service Component is present. \n \nUpdating the Veteran\'s military service will make the Veteran Camp Lejeune ineligible. Are you sure you want to make this change?"
    var msg_branchService = "Changing the Branch of Service will eliminate the Service Component if Service Component is present."
    var msg_dischargeType = "Updating the Veteran\'s military service will make the Veteran Camp Lejeune ineligible. Are you sure you want to make this change?"
  
        
        //alert("randy6");
    if (needAgentOrangeExposureLocationWarning == true)
    {
       if (needRadiationExposureMethodWarning == true)
       {
          if (needSourceofChangeWarning == true)
          {
             if (needBranchofServiceWarning == true)
             {
                if (needDischargeTypeWarning == true)
                {
                    needAgentOrangeExposureLocationWarning = false;
                    needRadiationExposureMethodWarning = false;
                    needSourceofChangeWarning = false;
                    needBranchofServiceWarning = false;
                    needDischargeTypeWarning = false;
                    return confirm(msg_orange_rediation_dataSource_branchService_dischareType);
                }
                else
                {
                    needAgentOrangeExposureLocationWarning = false;
                    needRadiationExposureMethodWarning = false;
                    needSourceofChangeWarning = false;
                    needBranchofServiceWarning = false;
                    return confirm(msg_orange_rediation_dataSource_branchService);
                }
             }
             else
             {
                if (needDischargeTypeWarning == true)
                {
                    needAgentOrangeExposureLocationWarning = false;
                    needRadiationExposureMethodWarning = false;
                    needSourceofChangeWarning = false;
                    needDischargeTypeWarning = false;
                    return confirm(msg_orange_rediation_dataSource_dischargeType);
                }
                else
                {
                    needAgentOrangeExposureLocationWarning = false;
                    needRadiationExposureMethodWarning = false;
                    needSourceofChangeWarning = false;
                    return confirm(msg_orange_rediation_dataSource); 
                }
             }
          }
          else
          {
             if (needBranchofServiceWarning == true)
             {
                if (needDischargeTypeWarning == true)
                {
                    needAgentOrangeExposureLocationWarning = false;
                    needRadiationExposureMethodWarning = false;
                    needBranchofServiceWarning = false;
                    needDischargeTypeWarning = false;
                    return confirm(msg_orange_rediation_branchService_dischargeType);
                }
                else
                {
                    needAgentOrangeExposureLocationWarning = false;
                    needRadiationExposureMethodWarning = false;
                    needBranchofServiceWarning = false;
                    return confirm(msg_orange_rediation_branchService);
                }
             }
             else
             {
                if (needDischargeTypeWarning == true)
                {
                    needAgentOrangeExposureLocationWarning = false;
                    needRadiationExposureMethodWarning = false;
                    needDischargeTypeWarning = false;
                    return confirm(msg_orange_rediation_dischargeType);
                }
                else
                {
                    needAgentOrangeExposureLocationWarning = false;
                    needRadiationExposureMethodWarning = false;
                    return confirm(msg_orange_rediation);
                }
             }
          }
       }
       else
       {
          if (needSourceofChangeWarning == true)
          {
             if (needBranchofServiceWarning == true)
             {
                if (needDischargeTypeWarning == true)
                {
                    needAgentOrangeExposureLocationWarning = false;
                    needSourceofChangeWarning = false;
                    needBranchofServiceWarning = false;
                    needDischargeTypeWarning = false;
                    return confirm(msg_orange_dataSource_branchService_dischargeType);
                }
                else
                {
                    needAgentOrangeExposureLocationWarning = false;
                    needSourceofChangeWarning = false;
                    needBranchofServiceWarning = false;
                    return confirm(msg_orange_dataSource_branchService);
                }
             }
             else
             {
                if (needDischargeTypeWarning == true)
                {
                    needAgentOrangeExposureLocationWarning = false;
                    needSourceofChangeWarning = false;
                    needDischargeTypeWarning = false;
                    return confirm(msg_orange_dataSource_dischargeType);
                }
                else
                {
                    needAgentOrangeExposureLocationWarning = false;
                    needSourceofChangeWarning = false;
                    return confirm(msg_orange_dataSource); 
                }
             }
          }
          else
          {
             if (needBranchofServiceWarning == true)
             {
                if (needDischargeTypeWarning == true)
                {
                    needAgentOrangeExposureLocationWarning = false;
                    needBranchofServiceWarning = false;
                    needDischargeTypeWarning = false;
                    return confirm(msg_orange_branchService_dischargeType);
                }
                else
                {
                    needAgentOrangeExposureLocationWarning = false;
                    needBranchofServiceWarning = false;
                    return confirm(msg_orange_branchService);
                }
             }
             else
             {
                if (needDischargeTypeWarning == true)
                {
                    needAgentOrangeExposureLocationWarning = false;
                    needDischargeTypeWarning = false;
                    return confirm(msg_orange_dischargeType);
                }
                else
                {
                    needAgentOrangeExposureLocationWarning = false;
                    return confirm(msg_orange); 
                }
             }
          }
       }
    }
    else
    {
       if (needRadiationExposureMethodWarning == true)
       {
          if (needSourceofChangeWarning == true)
          {
             if (needBranchofServiceWarning == true)
             {
                if (needDischargeTypeWarning == true)
                {
                    needRadiationExposureMethodWarning = false;
                    needSourceofChangeWarning = false;
                    needBranchofServiceWarning = false;
                    needDischargeTypeWarning = false;
                    return confirm(msg_rediation_dataSource_branchService_dischargeType);
                }
                else
                {
                    needRadiationExposureMethodWarning = false;
                    needSourceofChangeWarning = false;
                    needBranchofServiceWarning = false;
                    return confirm(msg_rediation_dataSource_branchService);
                }
             }
             else
             {
                if (needDischargeTypeWarning == true)
                {
                    needRadiationExposureMethodWarning = false;
                    needSourceofChangeWarning = false;
                    needDischargeTypeWarning = false;
                    return confirm(msg_rediation_dataSource_dischargeType);
                }
                else
                {
                    needRadiationExposureMethodWarning = false;
                    needSourceofChangeWarning = false;
                    return confirm(msg_rediation_dataSource); 
                }
             }
          }
          else
          {
              if (needBranchofServiceWarning == true)
              {
                 if (needDischargeTypeWarning == true)
                 {
                     needRadiationExposureMethodWarning = false;
                     needBranchofServiceWarning = false;
                     needDischargeTypeWarning = false;
                     return confirm(msg_rediation_branchService_dischargeType);
                 }
                 else
                 {
                     needRadiationExposureMethodWarning = false;
                     needBranchofServiceWarning = false;
                     return confirm(msg_rediation_branchService);
                 }
              }
              else
              {
                 if (needDischargeTypeWarning == true)
                 {
                     needRadiationExposureMethodWarning = false;
                     needDischargeTypeWarning = false;
                     return confirm(msg_rediation_dischargeType);
                 }
                 else
                 {
                     needRadiationExposureMethodWarning = false;
                     return confirm(msg_rediation); 
                 }
              }
          }
       }
       else
       {
           if (needSourceofChangeWarning == true)
           {
              if (needBranchofServiceWarning == true)
              {
                 if (needDischargeTypeWarning == true)
                 {
                     needSourceofChangeWarning = false;
                     needBranchofServiceWarning = false;
                     needDischargeTypeWarning = false;
                     return confirm(msg_dataSource_branchService_dischargeType);
                 }
                 else
                 {
                     needSourceofChangeWarning = false;
                     needBranchofServiceWarning = false;
                     return confirm(msg_dataSource_branchService);
                 }
              }
              else
              {
                 if (needDischargeTypeWarning == true)
                 {
                     needSourceofChangeWarning = false;
                     needDischargeTypeWarning = false;
                     return confirm(msg_dataSource_dischargeType);
                 }
                 else
                 {
                     needSourceofChangeWarning = false;
                     return confirm(msg_dataSource); 
                 }
              }
           }
           else
           {
              if (needBranchofServiceWarning == true)
              {
                 if (needDischargeTypeWarning == true)
                 {
                     needBranchofServiceWarning = false;
                     needDischargeTypeWarning = false;
                     return confirm(msg_branchService_dischargeType);
                 }
                 else
                 {
                     needBranchofServiceWarning = false;
                     return confirm(msg_branchService);
                 }
              }
              else
              {
                 if (needDischargeTypeWarning == true)
                 {
                     needDischargeTypeWarning = false;
                     return confirm(msg_dischargeType);
                 }
                 else
                    return true;  
              }
           }
       }
    }
}


//Displays a message if the field is empty (i.e. the length of it's value is 0)
//function displayMessageIfFieldEmpty(field, msg)
//{
  //if (field != null && field.value.length == 0)
  //{
  //  alert(msg);
  //}
//}

function displayMessageIfFieldEmpty(hiddenFieldId, fieldId, msg)
{
  
  var hiddenField = document.getElementById(hiddenFieldId);
  //var selectedOption = document.getElementById(fieldId).options[document.getElementById(fieldId).selectedIndex];
  //var selectedOption = document.getElementById(fieldId).options[document.getElementById(fieldId)];
  //var selectedOption = document.getElementById(fieldId);
        
        if ( hiddenField.value != fieldId.value ) 
     {
                //alert("randy1")
          if (fieldId != null && fieldId.value.length == 0)
        {
          alert(msg);
          //hiddenFieldId = fieldId.value;
        }
     }
  }  

//function onChangeServiceBranch(hiddenFieldId,fieldId) {
//    var hiddenField = document.getElementById(hiddenFieldId);
//    var field = document.getElementById(fieldId);

//    if ( hiddenField.value != field.value ) {
//        field.value = hiddenField.value;
//    }
//}

function checkForOtherVerificationMethod() {

    var i = 0;
    militaryServiceInfoForm.campLejeuneVerificationComments.disabled=true;  
    for (i = 0; i < militaryServiceInfoForm.campLejeuneVerificationMethods.length; i++) {
         if (militaryServiceInfoForm.campLejeuneVerificationMethods[i].checked) {
             if (i == "5") 
             {
                 militaryServiceInfoForm.campLejeuneVerificationComments.disabled=false;
             }
             else
             {
                 //militaryServiceInfoForm.campLejeuneVerificationComments.disabled=true;    
             }
         }
    }
}

/**
 *Calculates the military service episodes to determine CLE
 *@param size - total number of military service episodes of a veteran 
 *               
 *@return true if the person is eligible for CL-V 
 *        false if the person is not eligible for CL-V
 *
 */

function campLejuneDelMesgWarning(size, addAPersonFlagged)
{
        var flag = new String(addAPersonFlagged).valueOf();
        var  showMessage = true;
        if(flag == "true"){
              showMessage = false;
           } 
     
    if (isMSEChanged == true) {

        var totalServiceDays = 0;
        var i = 0;
        var index = 0;
        var daysServedInCurrentEpisode = 0;
        var clvStartDate = Date.parse("8/1/1953");
        var clvEndDate = Date.parse("12/31/1987");
        var entryDateToTime, separationDateToTime;
        //var clv_n = document.getElementById('idclvInd_0');
        var clv_y = document.getElementById('idclvInd_1');
    
        for (i=0; i<size; i++)
        {
            index = i;
            var dischargeType = "serviceEpisodeDischargeType[" + index + "]";
            var checkDischargeType = document.getElementById(dischargeType).value;
            
            if (checkDischargeType != "2" &&
                checkDischargeType != "4" &&
                checkDischargeType != "5" &&
                checkDischargeType != "6" &&
                checkDischargeType != "8")
            {
                var entryDate = "serviceEpisodeEntryDate[" + index + "]";
                var calcEntryDate = document.getElementById(entryDate).value;
                var separationDate = "serviceEpisodeSeparationDate[" + index + "]";
                var calcSeparationDate = document.getElementById(separationDate).value;

                entryDateToTime = Date.parse(calcEntryDate);
                separationDateToTime = Date.parse(calcSeparationDate);
            
                if(entryDateToTime >= clvStartDate && separationDateToTime <= clvEndDate)
                {
                           daysServedInCurrentEpisode = daysBetweenDates(entryDateToTime, separationDateToTime);
                           totalServiceDays += daysServedInCurrentEpisode;
                }
           
                else if(entryDateToTime >= clvStartDate && entryDateToTime <=clvEndDate && separationDateToTime >= clvEndDate)
                {
                           daysServedInCurrentEpisode = daysBetweenDates(entryDateToTime, clvEndDate);
                           totalServiceDays += daysServedInCurrentEpisode; 
                }
           
                else if(entryDateToTime <= clvStartDate && separationDateToTime <= clvEndDate && separationDateToTime >= clvStartDate)
                {
                           daysServedInCurrentEpisode = daysBetweenDates(clvStartDate, separationDateToTime);
                           totalServiceDays += daysServedInCurrentEpisode;  
                }
                else if(entryDateToTime <= clvStartDate && separationDateToTime >= clvEndDate )
                {
                        daysServedInCurrentEpisode = daysBetweenDates(clvStartDate, clvEndDate);
                        totalServiceDays += daysServedInCurrentEpisode;
                }
                else
                {
                           //do nothing if this else condition is hit
                }
            }
        }
        

        if (totalServiceDays < 30)
        {
             if ((clv_y.checked) && (showMessage == true))
            {
            //var msg = "Updating the Veteran\'s military service will make the Veteran Camp Lejeune ineligible. Are you sure you want to make this change?"
            needDischargeTypeWarning = true;
            //alert("randy3");
            //return confirm(msg);
            }
        }           
        
        
    }
    
    //return true;
}

function campLejuneDelMesgWarningDel(size,delIndex)
{
   //if (isMSEChanged == true) {
        var totalServiceDays = 0;
        var i = 0;
        var index = 0;
        var daysServedInCurrentEpisode = 0;
        var clvStartDate = Date.parse("8/1/1953");
        var clvEndDate = Date.parse("12/31/1987");
        var entryDateToTime, separationDateToTime;
        //var clv_n = document.getElementById('idclvInd_0');
        var clv_y = document.getElementById('idclvInd_1');
    
        for (i=0; i<size; i++)
        {
            index = i;
            if(index==delIndex)
                continue;
            var dischargeType = "serviceEpisodeDischargeType[" + index + "]";
            var checkDischargeType = document.getElementById(dischargeType).value;
            
            if (checkDischargeType != "2" &&
                checkDischargeType != "4" &&
                checkDischargeType != "5" &&
                checkDischargeType != "6" &&
                checkDischargeType != "8")
            {
                var entryDate = "serviceEpisodeEntryDate[" + index + "]";
                var calcEntryDate = document.getElementById(entryDate).value;
                var separationDate = "serviceEpisodeSeparationDate[" + index + "]";
                var calcSeparationDate = document.getElementById(separationDate).value;

                entryDateToTime = Date.parse(calcEntryDate);
                separationDateToTime = Date.parse(calcSeparationDate);
            
                if(entryDateToTime >= clvStartDate && separationDateToTime <= clvEndDate)
                {
                           daysServedInCurrentEpisode = daysBetweenDates(entryDateToTime, separationDateToTime);
                           totalServiceDays += daysServedInCurrentEpisode;
                }
           
                else if(entryDateToTime >= clvStartDate && entryDateToTime <=clvEndDate && separationDateToTime >= clvEndDate)
                {
                           daysServedInCurrentEpisode = daysBetweenDates(entryDateToTime, clvEndDate);
                           totalServiceDays += daysServedInCurrentEpisode; 
                }
           
                else if(entryDateToTime <= clvStartDate && separationDateToTime <= clvEndDate && separationDateToTime >= clvStartDate)
                {
                           daysServedInCurrentEpisode = daysBetweenDates(clvStartDate, separationDateToTime);
                           totalServiceDays += daysServedInCurrentEpisode;  
                }
                else if(entryDateToTime <= clvStartDate && separationDateToTime >= clvEndDate )
                {
                        daysServedInCurrentEpisode = daysBetweenDates(clvStartDate, clvEndDate);
                        totalServiceDays += daysServedInCurrentEpisode;
                }
                else
                {
                           //do nothing if this else condition is hit
                }
            }
        }

        if (totalServiceDays < 30)
        {
             if (clv_y.checked)
            {
            var msg = "Updating the Veteran\'s military service will make the Veteran Camp Lejeune ineligible. Are you sure you want to make this change?"
            return confirm(msg);
            }
        }           
    //}
    
    return true;
}
    
/**
 * Calculates the number of days different between two dates
 * @param date1 the beginning date in milliseconds
 * @param date2 the end date in milliseconds
 * @return the number of days different between two dates
 */
function daysBetweenDates(date1, date2){
    var msInADay = 1000*60*60*24;
    
    //calculates the milliseconds between the two given dates
    var msBetweenDates = date2 - date1;
    
    //converts the millisecond difference back to the number of days different between the dates.
    //this will round down the number.
    
    var daysBetween = Math.floor(msBetweenDates/msInADay);
    
    return daysBetween+1;
} 

function processMSEChanged()
    {
        isMSEChanged = true;
    }
    
function processMOHIndicator(defaultDocumentReceiptDate)
{

    var moh_nd = document.getElementById('idmohInd_nd');
    var moh_n = document.getElementById('idmohInd_n');
    var moh_y = document.getElementById('idmohInd_y');
    var block = document.getElementById('mohBlock');
    var imageElement = document.getElementById('riArrowImage');
    
    var documentReceiptDate = document.getElementById('idDocumentReceiptDate');
    var dataSource = document.getElementById('idMohDataSource');
    var documentType = document.getElementById('idDocumentType');
    var statusUpdateDate = document.getElementById('idMHLastStatusUpdateDate');
    var status = document.getElementById('idStatus');
    
    if (moh_nd.value == null || moh_nd.checked || moh_n.value == null || moh_n.checked )
    {
        // if ((defaultDocumentReceiptDate != null) && (defaultDocumentReceiptDate == 'y'))
        // {
        //   documentReceiptDate.value = '';
        //   dataSource.options[0].selected = true;
        //   dataSource.selectedIndex = 0;
        //   documentType.options[0].selected = true;
        //   documentType.selectedIndex = 0;
        //   statusUpdateDate.value = '';
        //   status.value = '';
        // }
        collapseSection(block, imageElement, null);
    }
    else  if (moh_y.checked)
    {
        if ((defaultDocumentReceiptDate != null) && (defaultDocumentReceiptDate == 'y'))
        {
            // Always populated as today's date when user selects the "Y" from N or Null
            formatDateTime(null, "MM/dd/yyyy", documentReceiptDate);
        }
        expandSection(block, imageElement, null);
    }
}
function processAsteriskMSE(i){
	var separationDateValue = document.getElementById('serviceEpisodeSeparationDate['+i+']_sid').value;
	var futureDischargeDateValue = document.getElementById('serviceEpisodeFutureDischargeDate['+i+']_sid').value;
	if (separationDateValue == ''){
		asteriskFDD(i);
		requireFDD(i);
		if (futureDischargeDateValue == ''){
			asteriskMSE(i);
			requireMSE(i);
		}
	}
	else {
		asteriskMSE(i);
		requireMSE(i);
	}
}

function processAsteriskFDD(i){
	var separationDateValue = document.getElementById('serviceEpisodeSeparationDate['+i+']_sid').value;
	var futureDischargeDateValue = document.getElementById('serviceEpisodeFutureDischargeDate['+i+']_sid').value;
	if (futureDischargeDateValue == ''){
		asteriskMSE(i);
		requireMSE(i);
	}
	else{
		asteriskFDD(i);
		requireFDD(i);
	}
}

function asteriskMSE(i){
	updateAsteriskInd('serviceEpisodeSeparationDate['+i+']_id_StarLabel','serviceEpisodeSeparationDate['+i+']_id_noStarLabel');
    updateAsteriskInd('serviceEpisodeDischargeType['+i+']_id_StarLabel','serviceEpisodeDischargeType['+i+']_id_noStarLabel');
    updateAsteriskInd('serviceEpisodeSourceOfInformation['+i+']_id_noStarLabel','serviceEpisodeSourceOfInformation['+i+']_id_StarLabel');
    updateAsteriskInd('serviceEpisodeOtherExplanation['+i+']_id_noStarLabel','serviceEpisodeOtherExplanation['+i+']_id_StarLabel');
}

function asteriskFDD(i){
	updateAsteriskInd('serviceEpisodeSeparationDate['+i+']_id_noStarLabel','serviceEpisodeSeparationDate['+i+']_id_StarLabel');
    updateAsteriskInd('serviceEpisodeDischargeType['+i+']_id_noStarLabel','serviceEpisodeDischargeType['+i+']_id_StarLabel');
    updateAsteriskInd('serviceEpisodeSourceOfInformation['+i+']_id_StarLabel','serviceEpisodeSourceOfInformation['+i+']_id_noStarLabel');
    updateAsteriskInd('serviceEpisodeOtherExplanation['+i+']_id_StarLabel','serviceEpisodeOtherExplanation['+i+']_id_noStarLabel');
}

function requireMSE(i){
	j=i+1;
    document.getElementById('serviceEpisodeSourceOfInformation['+i+']_sid').title='Source of Information ' + j;
    document.getElementById('serviceEpisodeOtherExplanation['+i+']_sid').title='Other Explanation ' + j;
    document.getElementById('serviceEpisodeSeparationDate['+i+']_sid').title='Required, Service Separation Date ' + j + ' (mm/dd/yyyy)';
    document.getElementById('serviceEpisodeDischargeType['+i+']_sid').title='Required, Discharge Type ' + j;
}

function requireFDD(i){
	j=i+1;
    document.getElementById('serviceEpisodeSourceOfInformation['+i+']_sid').title='Required, Source of Information ' + j;
    document.getElementById('serviceEpisodeOtherExplanation['+i+']_sid').title='Required, Other Explanation ' + j;
    document.getElementById('serviceEpisodeSeparationDate['+i+']_sid').title='Service Separation Date ' + j + ' (mm/dd/yyyy)';
    document.getElementById('serviceEpisodeDischargeType['+i+']_sid').title='Discharge Type ' + j;
}

function processSOI(soiblock, soi){
	var soiValue=document.getElementById(soi).value;
	
	if(soiValue == 'OT'){
		document.getElementById(soiblock).style.display = 'block';
	}else{
		document.getElementById(soiblock).style.display = 'none';
	}
}

function processFD(fddblock, fddArrowId, fddCounter, event){
	
	var keyValue = event.keyCode;
	
	if(keyValue != 13 && keyValue != 9 && keyValue != 40 && keyValue != 37 ){
		return;
	}	
	
	if(document.getElementById(fddblock).style.display == 'none'){
		
		document.getElementById(fddArrowId).click();
		document.getElementById('serviceEpisodeFutureDischargeDate['+fddCounter+']_sid').focus;
	}		
}

function processInitialFDDLoad(count){
	
	var numberOfMSE = parseInt(count);
    
    for (i = 0; i < numberOfMSE; i++) {				
		var fddBlock = document.getElementById('fddBlock_'+i);
		var fddArrowImage = document.getElementById('riArrowImageFD_'+i);
		var serviceFutureDischargeDateValue = document.getElementById('serviceEpisodeFutureDischargeDate['+i+']_sid').value;
		var serviceSourceOfInformationValue = document.getElementById('serviceEpisodeSourceOfInformation['+i+']_sid').value;
		var serviceOtherExplanationValue = document.getElementById('serviceEpisodeOtherExplanation['+i+']_sid').value;
		var separationDateValue = document.getElementById('serviceEpisodeSeparationDate['+i+']_sid').value;
		
		 if (serviceFutureDischargeDateValue != ''||serviceSourceOfInformationValue !=''||serviceOtherExplanationValue !='') {			 
			 expandSection(fddBlock, fddArrowImage, null);
			 if (serviceFutureDischargeDateValue != ''){
				 asteriskFDD(i);
				 requireFDD(i);
			 }
			 if (separationDateValue != ''){
				 asteriskMSE(i);
				 requireMSE(i);
			 }
         }
		 else{			 
			 collapseSection(fddBlock, fddArrowImage, null);
		 }
    }	
}

//function displayMessageIfAgentOrangeExposureLocationEmpty(hiddenFieldId, fieldId, msg)
//{
  //var hiddenField = document.getElementById(hiddenFieldId);
  
 // if ( hiddenField.value != fieldId.value ) 
 // {
      //if (fieldId != null && fieldId.value.length == 0)
        //{
          //alert("randy1");
          //needAgentOrangeExposureLocationWarning = true;
        //}
  //}

//}


//function checkDataSourceFields(formObject, datasource_vadir, datasource_webhinq, datasource_vba, datasource_other, msg )
function checkDataSourceFields(formObject, datasource_vadir, datasource_webhinq, datasource_vba, datasource_other, hiddenFieldId, fieldId, msg )
{
  var hiddenField = document.getElementById(hiddenFieldId);
  if ( hiddenField.value != fieldId.value ) 
  {
    // alert ("old datasource "+ formObject.idOnFileMohDataSource.value + " New datasource "+ formObject.idMohDataSource.value);
    var oldDataSource = document.getElementById('idOnFileMohDataSource');
    var dataSource = document.getElementById('idMohDataSource');
    
    if ( (  formObject.idMohDataSource.value == datasource_vadir || formObject.idMohDataSource.value == datasource_webhinq ) )
    {
        
        if ( formObject.idOnFileMohDataSource.value == null || formObject.idOnFileMohDataSource.value == '')
        {
            dataSource.options[0].selected = true;
            dataSource.selectedIndex = 0;
            needSourceofChangeWarning = true;
            //alert(msg);
            // alert("1. "+ msg);
         }
         else if ( formObject.idOnFileMohDataSource.value == datasource_vba) {
            dataSource.options[2].selected = true;
            dataSource.selectedIndex = 2;
            needSourceofChangeWarning = true;
            //alert(msg);
            // alert("2. "+ msg);
         }
         else if ( formObject.idOnFileMohDataSource.value == datasource_other){
            dataSource.options[1].selected = true;
            dataSource.selectedIndex = 1;
            needSourceofChangeWarning = true;
            //alert(msg);
            // alert("3. "+ msg);
         }
        else  if ( formObject.idMohDataSource.value == datasource_vadir  &&  formObject.idOnFileMohDataSource.value == datasource_webhinq )
        {       
                dataSource.options[3].selected = true;
                dataSource.selectedIndex = 3;  
                needSourceofChangeWarning = true;
                //alert(msg);
                // alert("4. "+ msg);   
        }
        else if (  formObject.idMohDataSource.value == datasource_webhinq  &&  formObject.idOnFileMohDataSource.value == datasource_vadir )
        {       
                dataSource.options[4].selected = true;
                dataSource.selectedIndex = 4;   
                needSourceofChangeWarning = true;
                //alert(msg);
                // alert("5. "+ msg);
         }  
    } 
  }
}

</script>

<c:set var="viewHistoricalMilitaryService" scope="page">
	<bean-el:message key="label.viewHistoricalMilitaryService" />
</c:set>
<c:set var="eliminateServiceComponentWarning" scope="page">
	<bean-el:message key="message.eliminateServiceComponent" />
</c:set>
<c:set var="deleteMseMsg" scope="page">
	<bean-el:message key="message.deleteMilitaryServiceEpisode" />
</c:set>

<html-el:form action="militaryService">
<%@ include file="/admin/csrfgentoken.jsp" %>
<%@ include file="militaryServiceSiteRecords.jsp" %>

<br>
	<table id="tblMilitarySvc" cellSpacing="0" cellPadding="0" width=100%
		border="0" class="moduleShell" role="presentation">

  <tr>
    <td>
				<table width="100%" border="0" cellpadding="0" cellspacing="0"
					class="moduleShellTable" role="presentation">
        <tr>
          <td>
							<table width="100%" border="0" cellpadding="0" cellspacing="0"
								class="moduleShellTableHead" role="presentation">
              <tr>
									<td class="moduleBlueBox"><img alt=""
										src="../images/spacer.gif" width="28" height="23" /></td>
									<td nowrap>&nbsp;<bean-el:message
											key="title.currentMilitaryService" />&nbsp;&nbsp;&nbsp;&nbsp;
									</td>
									<td width="83%" nowrap><img alt=""
										src="../images/spacer.gif" width="1" height="21" /></td>
                <td nowrap class="moduleBlueLink" style="padding: 1 8 1 8">
										<fw:link
											action="/militaryServiceHistory?methodName=DISPLAY&amp;history=viewHistoricalMilitaryService">
                    <bean-el:message key="label.viewHistoricalMilitaryService"/>
                  </fw:link>
                </td>
              </tr>
            </table>
          </td>
        </tr>
        <tr>
						<td><html-el:hidden property="ssn" /> <html-el:hidden
								property="birthDate" /> <html-el:hidden
								property="deletedEpisodeIndex" /> <%-- start of include militaryServiceForm_jsp    --%>
            
             <%-- <jsp:include page="militaryServiceForm.jsp" flush="true" />     --%>
             
							<table width="100%" border="0" cellspacing="0" cellpadding="0"
								class="moduleShellTableBody" role="presentation">
<tr>
									<td colspan="2"><%@ include
											file="/tiles/common/instructionalText.jsp"%>
    </td>
</tr>
<tr>
									<td width="50%" class="moduleLabel"><bean-el:message
											key="label.dischargeDueToDisablility" />:</td>
									<td width="50%" class="moduleValue"><c:set
											var="dischargeDueToDisabilityLabel">
											<bean-el:message key="label.dischargeDueToDisablility" />
										</c:set> <c:forEach var="item" items="${SortedIndicator}">
											<html-el:radio
												title="${dischargeDueToDisabilityLabel} (${item.description})"
												property="dischargeDueToDisability"
												styleId="idDischargeDueToDisability_${item.code}"
												value="${item.code}" disabled="${readOnlyMS}" />
											<fw:label property="dischargeDueToDisability"
												forId="idDischargeDueToDisability_${item.code}">
												<c:out value="${item.description}" />&nbsp;&nbsp;</fw:label>
										</c:forEach></td>
								</tr>
								<tr>
									<td class="moduleLabel"><bean-el:message
											key="label.militaryDisabilityRetirement" />:</td>
									<td class="moduleValue"><c:set
											var="retirementDueToMilitaryDisabilityLabel">
											<bean-el:message key="label.militaryDisabilityRetirement" />
										</c:set> <c:forEach var="item" items="${SortedIndicator}">
											<html-el:radio
												title="${retirementDueToMilitaryDisabilityLabel} (${item.description})"
												property="retirementDueToMilitaryDisability"
												styleId="idRetirementDueToMilitaryDisability_${item.code}"
												value="${item.code}" disabled="${readOnlyMS}" />
											<fw:label property="retirementDueToMilitaryDisability"
												forId="idRetirementDueToMilitaryDisability_${item.code}">
												<c:out value="${item.description}" />&nbsp;&nbsp;</fw:label>
										</c:forEach></td>
								</tr>
								<tr>
									<td class="moduleLabel"><fw:label
											property="agentOrangeExposureLocation"
											forId="idAgentOrangeExposureLocation">
											<bean-el:message key="label.agentOrangeLocation" />:</fw:label></td>
									<td class="moduleValue"><c:set
											var="agentOrangeExposureLocationLabel">
											<bean-el:message key="label.agentOrangeLocation" />
										</c:set> <c:set var="agentOrangeLocationRemovedWarning">
											<bean-el:message key="message.agentOrangeLocationRemoved" />
										</c:set>
										<table border="0" cellpadding="0" cellspacing="0"
											class="moduleShellLowTableBody" role="presentation">
<tr>
												<td><html-el:select
														title="${agentOrangeExposureLocationLabel}"
														styleClass="moduleEdit"
														styleId="idAgentOrangeExposureLocation"
														property="agentOrangeExposureLocation"
														disabled="${readOnlyMS}">
														<html-el:option styleClass="moduleEdit" value="">
															<bean-el:message key="label.notExposed" />
														</html-el:option>
														<esrcore:options styleClass="moduleEdit"
															collection="gov.va.med.esr.common.model.lookup.AgentOrangeExposureLocation"
															property="code" labelProperty="description" />
													</html-el:select> <c:set var="agentOrangeExposureLocationHiddenField"
														value="agentOrangeLocation_hid" /> <html-el:hidden
														property="agentOrangeExposureLocation"
														styleId="${agentOrangeExposureLocationHiddenField}" /></td>
												<td>&nbsp;</td>
            </tr>
										</table></td>
</tr>
<tr>
									<td class="moduleLabel"><fw:label
											property="radiationExposureMethod"
											forId="idRadiationExposureMethod">
											<bean-el:message key="label.radiationExposureMethod" />:</fw:label></td>
									<td class="moduleValue"><c:set
											var="radiationExposureMethodLabel">
											<bean-el:message key="label.radiationExposureMethod" />
										</c:set> <c:set var="radiationExposureMethodRemovedWarning">
											<bean-el:message key="message.radiationExposureMethodRemoved" />
										</c:set>
										<table border="0" cellpadding="0" cellspacing="0"
											class="moduleShellLowTableBody" role="presentation">
            <tr>
												<td><html-el:select
														title="${radiationExposureMethodLabel}"
														styleClass="moduleEdit" property="radiationExposureMethod"
														styleId="idRadiationExposureMethod"
														disabled="${readOnlyMS}">
														<html-el:option styleClass="moduleEdit" value="">
															<bean-el:message key="label.notExposed" />
														</html-el:option>
														<esrcore:options styleClass="moduleEdit"
															collection="gov.va.med.esr.common.model.lookup.RadiationExposureMethod"
															property="code" labelProperty="description" />
													</html-el:select> <c:set var="radiationExposureMethodHiddenField"
														value="radiationExposureMethod_hid" /> <html-el:hidden
														property="radiationExposureMethod"
														styleId="${radiationExposureMethodHiddenField}" /></td>
												<td>&nbsp;</td>
            </tr>
										</table></td>
</tr>
<tr> 
									<td class="moduleLabel"><bean-el:message
											key="label.environmentalContaminants" />:</td>
									<td class="moduleValue"><c:set
											var="environmentalContaminantsLabel">
											<bean-el:message key="label.environmentalContaminants" />
										</c:set> <c:forEach var="item" items="${SortedIndicator}">
											<c:if
												test="${item.code == IndicatorNO or item.code == IndicatorYES}">
												<html-el:radio
													title="${environmentalContaminantsLabel} (${item.description})"
													property="exposedToContaminants"
													styleId="idExposedToContaminants_${item.code}"
													value="${item.code}" disabled="${readOnlyMS}" />
												<fw:label property="exposedToContaminants"
													forId="idExposedToContaminants_${item.code}">
													<c:out value="${item.description}" />&nbsp;&nbsp;</fw:label>
            </c:if>
										</c:forEach></td>
</tr>
							</table> <!-- MOH CCR10803 --> <%-- <jsp:include page="newMedalOfHonor.jsp" flush="true" />  --%>
<%--start of page newMedalOfHonor.jsp --%>

							<table width="100%" border="0" cellspacing="0" cellpadding="0"
								class="moduleShellTableBody" role="presentation">
       <tr>
									<td width="50%" class="moduleLabel" nowrap><html-el:img
											alt="${expandableSectionCollapsed}" align="center"
											styleId="riArrowImage" src="../images/redArrowRight.gif" />
										<bean-el:message key="label.medalOfHonor" />:</td>
									<td width="50%" class="moduleValue"><c:forEach var="item"
											items="${yesNoNoDataList}">
											<c:set var="medalOfHonorText">
												<bean-el:message key="label.medalOfHonor" />&nbsp;(<bean-el:message
													key="${item.label}" />)</c:set>
											<html-el:radio title="${medalOfHonorText}"
												styleId="idmohInd_${item.value}"
												name="militaryServiceInfoForm" property="mohInd"
												disabled="${readOnlyMS}"
												onKeyPress="processMOHIndicator('y')"
												onclick="processMOHIndicator('y')" value="${item.value}" />
											<fw:label property="mohInd" forId="idmohInd_${item.value}">
												<bean-el:message key="${item.label}" />&nbsp;&nbsp;</fw:label>
										</c:forEach></td>
									<html-el:hidden name="militaryServiceInfoForm"
										property="onFileMohInd" />
									<html-el:hidden name="militaryServiceInfoForm"
										property="mohHiddenId" />
      </tr>
</table> 
							<table width="100%" border="0" cellspacing="0" cellpadding="0"
								class="moduleShellTableBody" role="presentation">
<tr>
    <td width="100%" colspan="2">
    <div id="mohBlock" class="expandCollapseBody">
											<table width="100%" cellSpacing="0" cellPadding="0"
												border="0" role="presentation">
    <tr>
													<td width="50%" class="moduleLabel"><fw:label
															required="true" property="documentType"
															forId="idDocumentType">
															<bean-el:message key="label.documentType" />:</fw:label></td>
													<td width="50%" class="moduleValue"><c:set
															var="documentTypeText">
															<bean-el:message key="label.documentType" />
														</c:set> <html-el:select
															title="${requiredText}${documentTypeText}"
															styleClass="moduleEdit" styleId="idDocumentType"
															property="documentType" disabled="${readOnlyMS}">
															<html-el:option value="">
																<bean-el:message key="label.select" />
															</html-el:option>
															<esrcore:options
																collection="gov.va.med.esr.ui.common.beans.UIMHDocumentType"
																property="code" labelProperty="description" />
														</html-el:select> <html-el:hidden name="militaryServiceInfoForm"
															property="onFileDocumentType" /></td>
    </tr>
     <tr>
													<td width="50%" class="moduleLabel"><fw:label
															property="documentReceiptDate"
															forId="idDocumentReceiptDate">
															<bean-el:message key="label.documentReceiptDate" />:</fw:label></td>
													<td width="50%" class="moduleValue"><c:set
															var="documentReceiptDateText">
															<bean-el:message key="label.documentReceiptDate" />
															<bean-el:message key="label.mmddyyyy" />
														</c:set> <html-el:text title="${documentReceiptDateText}"
															styleClass="moduleEdit" styleId="idDocumentReceiptDate"
															disabled="${readOnlyMS}" property="documentReceiptDate" />&nbsp;<bean-el:message
															key="label.mmddyyyy" /> <html-el:hidden
															name="militaryServiceInfoForm"
															property="onFileDocumentReceiptDate" /></td>
     </tr>
     <tr>
													<td width="50%" class="moduleLabel"><fw:label
															required="true" property="dataSource"
															forId="idMohDataSource">
															<bean-el:message key="label.dataSource" />:</fw:label></td>
													<td width="50%" class="moduleValue"><c:set
															var="dataSourceText">
															<bean-el:message key="label.dataSource" />
														</c:set> <c:set var="MOHDataSourcesNotAllowedWarning">
															<bean-el:message key="message.MOHDataSourcesNotAllowed" />
														</c:set>
														<table border="0" cellpadding="0" cellspacing="0"
															class="moduleShellLowTableBody" role="presentation">
            <tr>
																<td><html-el:select
																		title="${requiredText}${dataSourceText}"
																		styleClass="moduleEdit" styleId="idMohDataSource"
																		property="dataSource" disabled="${readOnlyMS}">
																		<html-el:option value="">
																			<bean-el:message key="label.select" />
																		</html-el:option>
																		<esrcore:options
																			collection="gov.va.med.esr.ui.common.beans.UIMHDataSource"
																			property="code" labelProperty="name" />
																	</html-el:select> <html-el:hidden name="militaryServiceInfoForm"
																		styleId="idOnFileMohDataSource"
																		property="onFileMohDataSource"></html-el:hidden> <c:set
																		var="idMohDataSourceHiddenField"
																		value="idMohDataSource_hid" /> <html-el:hidden
																		property="dataSource"
																		styleId="${idMohDataSourceHiddenField}" /></td>
																<td>&nbsp;</td>
            </tr>
														</table></td>
    </tr>
     <tr>
													<td width="50%" class="moduleLabel"><bean-el:message
															key="label.decorationStatus" />:</td>
													<td width="50%" class="moduleValue"><c:set
															var="decorationStatusText">
															<bean-el:message key="label.decorationStatus" />
														</c:set> <esrcore:displayValue name="militaryServiceInfoForm"
															property="status" /> <html-el:hidden
															name="militaryServiceInfoForm" styleId="idStatus"
															property="status"></html-el:hidden></td>
    </tr>
     <tr>
													<td width="50%" class="moduleLabel"><bean-el:message
															key="label.statusUpdateDate" />:</td>
													<td width="50%" class="moduleValue"><c:set
															var="statusUpdateText">
															<bean-el:message key="label.statusUpdateDate" />
														</c:set> <esrcore:displayValue name="militaryServiceInfoForm"
															property="mhLastStatusUpdateDate" /> <html-el:hidden
															name="militaryServiceInfoForm"
															styleId="idMHLastStatusUpdateDate"
															property="mhLastStatusUpdateDate"></html-el:hidden></td>
    </tr>   
 </table>
 </div>
</td>
</tr>
							</table> <%--end of page newMedalOfHonor.jsp --%>

							<table width="100%" border="0" cellspacing="0" cellpadding="0"
								class="moduleShellTableBody" role="presentation">
<tr>
									<td class="moduleLabel"><fw:label property="shad"
											forId="idShad">
											<bean-el:message key="label.SHAD" />:</fw:label></td>
									<td width="50%" class="moduleValue"><c:set var="SHADLabel">
											<bean-el:message key="label.SHAD" />
										</c:set> <c:forEach var="item" items="${SortedIndicator}">
											<c:if
												test="${item.code == IndicatorNO or item.code == IndicatorYES}">
												<html-el:radio title="${SHADLabel} (${item.description})"
													property="shad" styleId="idShad_${item.code}"
													value="${item.code}" disabled="${readOnlyMS}" />
												<fw:label property="shad" forId="idShad_${item.code}">
													<c:out value="${item.description}" />&nbsp;&nbsp;</fw:label>
            </c:if>
										</c:forEach></td>
</tr>
							</table> <jsp:include page="campLejeune.jsp" flush="true" />
							<table width="100%" border="0" cellspacing="0" cellpadding="0"
								class="moduleShellTableBody" role="presentation">
<tr>
									<td class="moduleLabel"><fw:label
											property="filipinoVeteranProof"
											forId="idFilipinoVeteranProof">
											<bean-el:message key="label.filipinoVeteranProof" />:</fw:label></td>
									<td width="50%" class="moduleValue"><c:set
											var="filipinoVeteranProofLabel">
											<bean-el:message key="label.filipinoVeteranProof" />
										</c:set> <html-el:select title="${filipinoVeteranProofLabel}"
											styleClass="moduleEdit" property="filipinoVeteranProof"
											styleId="idFilipinoVeteranProof" disabled="${readOnlyMS}">
											<html-el:option styleClass="moduleEdit" value="">
												<bean-el:message key="label.select" />
											</html-el:option>
											<esrcore:options styleClass="moduleEdit"
												collection="gov.va.med.esr.common.model.lookup.FilipinoVeteranProof"
												property="code" labelProperty="description" />
										</html-el:select></td>
</tr>
<tr>
									<td class="moduleLabel"><bean-el:message
											key="label.combatVeteranEligibilityEndDate" />:</td>
									<td class="moduleValue"><html-el:hidden
											property="eligibilityEndDate" /> <c:out
											value="${militaryServiceInfoForm.eligibilityEndDate}" />&nbsp;
    </td>
</tr>

<tr>
									<td class="moduleLabel"><bean-el:message
											key="label.eligibleForClassIIDental" />:</td>
									<td class="moduleValue"><c:set var="dentalClassIILabel">
											<bean-el:message key="label.eligibleForClassIIDental" />
										</c:set> <c:forEach var="item" items="${SortedIndicator}">
											<c:if
												test="${item.code == IndicatorNO or item.code == IndicatorYES}">
												<html-el:radio
													title="${dentalClassIILabel} (${item.description})"
													property="eligibleForClassIIDental" value="${item.code}"
													styleId="idEligibleForClassIIDental_${item.code}"
													disabled="${readOnlyMS}" />
												<fw:label property="eligibleForClassIIDental"
													forId="idEligibleForClassIIDental_${item.code}">
													<c:out value="${item.description}" />&nbsp;&nbsp;</fw:label>
            </c:if>
										</c:forEach></td>
</tr>

<tr>
									<td class="moduleLabel"><bean-el:message
											key="label.classIIDentalApplicationDueBefore" />:</td>
									<td class="moduleValue"><html-el:hidden
											property="classIIDentalApplicationDueBefore" /> <c:out
											value="${militaryServiceInfoForm.classIIDentalApplicationDueBefore}" />&nbsp;
    </td>
</tr>

							</table> <%--  end  of include militaryServiceForm.jsp   --%>
             
							<table width="100%" border="0" cellspacing="0" cellpadding="0"
								class="moduleShellTableBody" role="presentation">
              <tr>
                <td colspan="2">
										<table width="100%" border="0" cellspacing="0" cellpadding="0"
											class="moduleShellTableHead" role="presentation">
                    <tr>
												<td class="moduleBrownBox"><img alt=""
													src="../images/spacer.gif" width="28" height="23" /></td>
												<td nowrap>&nbsp;<bean-el:message
														key="label.oefOifEpisodes" /></td>
												<td width="10%" nowrap><c:if test="${not readOnlyMS}">
														<table width="20%" border="0" cellspacing="0"
															cellpadding="0" role="presentation">
                          <tr>
																<td width="50%"><img alt=""
																	src="../images/spacer.gif" /></td>
                            <td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
																<td><html-el:submit property="methodName"
																		style="width:170; vertical-align: top;"
																		styleClass="buttonText initfocus">
																		<bean-el:message key="button.addOefOifCombatEpisode" />
																	</html-el:submit></td>
                            <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
																<td width="50%"><img alt=""
																	src="../images/spacer.gif" /></td>
																<td width="1" style="padding: 0 5 0 0"><img alt=""
																	src="../images/spacer.gif" /></td>
                          </tr>
                        </table>
													</c:if></td>
                    </tr>
                  </table>
                </td>
              </tr>
              <c:choose>
									<c:when
										test="${not empty militaryServiceInfoForm.oefOifCombatEpisodeIdList}">
              <tr>
                <td colspan="2">
												<table width="100%" border="0" cellspacing="0"
													cellpadding="0" class="moduleShellTableBody"
													role="presentation">

            <c:set var="rowColor" value="light"/>
													<c:forEach var="oefOifCombatEpisodeId"
														items="${militaryServiceInfoForm.oefOifCombatEpisodeIdList}"
														varStatus="status">
                    <c:choose>
              <c:when test="${rowColor == 'light'}">
                <c:set var="rowColor" value="dark"/>
                <c:set var="rowLabelColor" value="darkLabel"/>
                <c:set var="rowValueColor" value="darkValue"/>
              </c:when>
              <c:otherwise>
                <c:set var="rowColor" value="light"/>
                <c:set var="rowLabelColor" value="label"/>
                <c:set var="rowValueColor" value="value"/>
              </c:otherwise>
                    </c:choose>
                    <c:set var="counter" value="${status.count - 1}" />
														<c:set var="hashCode"
															value="${militaryServiceInfoForm.oefOifCombatEpisodeHashCodeList[counter]}" />
														<html-el:hidden
															property="oefOifCombatEpisodeId[${counter}]" />
														<tr>
															<td class="<c:out value="${rowValueColor}" />"
																colspan="3"><img alt="" src="../images/spacer.gif"
																width="28" height="5" /></td>
														</tr>
														<tr>
															<c:set var="conflictservicelocationLabel">
																<bean-el:message key="label.conflictservicelocation" />
															</c:set>
															<td width="50%"
																class="<c:out value="${rowLabelColor}" />" nowrap><fw:label
																	required="true"
																	property="oefOifCombatEpisodeLocation[${counter}],oefOifCombatEpisodeLocation_${hashCode}"
																	forId="oefOifCombatEpisodeLocation[${counter}]_id">
																	<bean-el:message bundle="military"
																		key="label.conflictservicelocation" />:</fw:label></td>
															<td width="20%"
																class="<c:out value="${rowValueColor}" />"><html-el:select
																	title="${requiredText}, ${conflictservicelocationLabel} ${status.count}"
																	styleId="oefOifCombatEpisodeLocation[${counter}]_id"
																	styleClass="moduleEdit"
																	property="oefOifCombatEpisodeLocation[${counter}]"
																	disabled="${readOnlyMS}">
																	<html-el:option styleClass="moduleEdit" value="">
																		<bean-el:message key="label.select" />
																	</html-el:option>
																	<esrcore:options styleClass="moduleEdit"
																		collection="gov.va.med.esr.ui.common.beans.OEFOIFCombatLocation"
																		property="code" labelProperty="nameAndDateRange" />
																</html-el:select></td>

															<td width="30%"
																class="<c:out value="${rowValueColor}" />" nowrap>
                      <c:if test="${not readOnlyMS}">
																	<table align="left" width="100%" border="0"
																		cellspacing="0" cellpadding="0" role="presentation">
                          <tr>
																			<td width="10%"><img alt=""
																				src="../images/spacer.gif" /></td>
																			<td valign="top"><img alt=""
																				src="../images/buttonEndLeft.gif" /></td>
																			<td><html-el:submit
																					onClick="this.form.deletedEpisodeIndex.value=${counter};this.value='${button_deleteOefOifCombatEpisode}'"
																					property="methodName"
																					style="width:45; vertical-align: top;"
																					styleClass="buttonText">Delete</html-el:submit></td>
																			<td valign="top"><img alt=""
																				src="../images/buttonEndRight.gif" /></td>
																			<td width="90%"><img alt=""
																				src="../images/spacer.gif" /></td>
																			<td width="1" style="padding: 0 5 0 0"><img
																				alt="" src="../images/spacer.gif" /></td>
                          </tr>
                        </table>
                      </c:if>
                      </td>
                      
                    </tr>
                    <tr>
															<c:set var="conflictStartDateLabel">
																<bean-el:message key="label.conflictStartDate" />
															</c:set>
															<td class="<c:out value="${rowLabelColor}" />" nowrap><fw:label
																	required="true"
																	property="CombatEpisode_${hashCode},oefOifCombatEpisodeStartDate[${counter}],oefOifCombatEpisodeStartDate_${hashCode}"
																	forId="oefOifCombatEpisodeStartDate[${counter}]_id">
																	<bean-el:message bundle="military"
																		key="label.conflictStartDate" />:</fw:label></td>
															<td class="<c:out value="${rowValueColor}" />"
																colspan="2"><html-el:text
																	title="${requiredText}, ${conflictStartDateLabel} ${status.count} ${mmddyyyyText}"
																	property="oefOifCombatEpisodeStartDate[${counter}]"
																	styleClass="moduleEdit"
																	styleId="oefOifCombatEpisodeStartDate[${counter}]_id"
																	size="10" maxlength="10" readOnly="${readOnlyMS}" />&nbsp;<bean-el:message
																	key="label.mmddyyyy" /></td>
														</tr>
														<tr>
															<c:set var="conflictEndDateLabel">
																<bean-el:message key="label.conflictEndDate" />
															</c:set>
															<td class="<c:out value="${rowLabelColor}" />" nowrap><fw:label
																	required="true"
																	property="CombatEpisode_${hashCode},oefOifCombatEpisodeEndDate[${counter}],oefOifCombatEpisodeEndDate_${hashCode}"
																	forId="oefOifCombatEpisodeEndDate[${counter}]_id">
																	<bean-el:message bundle="military"
																		key="label.conflictEndDate" />:</fw:label></td>
															<td class="<c:out value="${rowValueColor}" />"
																colspan="2"><html-el:text
																	title="${requiredText}, ${conflictEndDateLabel} ${status.count} ${mmddyyyyText}"
																	property="oefOifCombatEpisodeEndDate[${counter}]"
																	styleClass="moduleEdit"
																	styleId="oefOifCombatEpisodeEndDate[${counter}]_id"
																	size="10" maxlength="10" readOnly="${readOnlyMS}" />&nbsp;<bean-el:message
																	key="label.mmddyyyy" /></td>
                    </tr>
                    <tr>
															<c:set var="combatPayTypeLabel">
																<bean-el:message key="label.combatPayType" />
															</c:set>
															<td class="<c:out value="${rowLabelColor}" />" nowrap><fw:label
																	property="oefOifCombatPayType[${counter}]"
																	forId="oefOifCombatPayType[${counter}]_id">
																	<bean-el:message bundle="military"
																		key="label.combatPayType" />:</fw:label></td>
															<td class="<c:out value="${rowValueColor}" />"
																colspan="2"><html-el:select
																	title="${combatPayTypeLabel} ${status.count}"
																	styleClass="moduleEdit"
																	styleId="oefOifCombatPayType[${counter}]_id"
																	property="oefOifCombatPayType[${counter}]"
																	disabled="${readOnlyMS}">
																	<html-el:option styleClass="moduleEdit" value="">
																		<bean-el:message key="label.select" />
																	</html-el:option>
																	<esrcore:options styleClass="moduleEdit"
																		collection="gov.va.med.esr.common.model.lookup.CombatPayType"
																		property="code" labelProperty="description" />
																</html-el:select></td>
                    </tr>
                    <tr>
															<c:set var="oefOifSourceLabel">
																<bean-el:message key="label.oefOifSource" />
															</c:set>
															<td class="<c:out value="${rowLabelColor}" />" nowrap><fw:label
																	property="oefOifCombatSource[${counter}]"
																	forId="oefOifCombatSource[${counter}]_id">
																	<bean-el:message bundle="military"
																		key="label.oefOifSource" />:</fw:label></td>
															<td class="<c:out value="${rowValueColor}" />"
																colspan="2"><html-el:hidden
																	property="oefOifCombatSource[${counter}]" /> <html-el:text
																	title="${oefOifSourceLabel}  ${status.count}"
																	styleId="oefOifCombatSource[${counter}]_id"
																	property="oefOifCombatSource[${counter}]"
																	readOnly="true" /></td>
                    </tr>
                    <tr>
															<td class="<c:out value="${rowValueColor}" />"
																colspan="3"><img alt="" src="../images/spacer.gif"
																width="28" height="5" /></td>
                    </tr>
                    </c:forEach>
                  </table>
                </td>
              </tr>
              </c:when>
              <c:otherwise>
              <tr>
                <td width="5px" class="moduleValue" nowrap>&nbsp;&nbsp;&nbsp;&nbsp;</td>
											<td width="100%" class="moduleValue"><bean-el:message
													key="label.noDataAvailable" /></td>
              </tr>
              </c:otherwise>
              </c:choose>

              <tr>
                <td colspan="2">
										<table width="100%" border="0" cellspacing="0" cellpadding="0"
											class="moduleShellTableHead" role="presentation">
                    <tr>
												<td class="moduleBrownBox"><img alt=""
													src="../images/spacer.gif" width="28" height="23" /></td>
												<td nowrap>&nbsp;<bean-el:message
														key="label.combatServices" /> - <bean-el:message
														key="label.placeholder" /></td>
												<td width="10%" nowrap><img alt=""
													src="../images/spacer.gif" width="1" height="1" /></td>
                    </tr>
                  </table>
                </td>
              </tr>

              <c:choose>
									<c:when
										test="${not empty militaryServiceInfoForm.combatServiceIdList}">
              <tr>
                <td colspan="2">
												<table width="100%" border="0" cellspacing="0"
													cellpadding="0" class="moduleShellTableBody"
													role="presentation">

            <c:set var="rowColor" value="light"/>
													<c:forEach var="combatServiceId"
														items="${militaryServiceInfoForm.combatServiceIdList}"
														varStatus="status">
                    <c:choose>
              <c:when test="${rowColor == 'light'}">
                <c:set var="rowColor" value="dark"/>
                <c:set var="rowLabelColor" value="darkLabel"/>
                <c:set var="rowValueColor" value="darkValue"/>
              </c:when>
              <c:otherwise>
                <c:set var="rowColor" value="light"/>
                <c:set var="rowLabelColor" value="label"/>
                <c:set var="rowValueColor" value="value"/>
              </c:otherwise>
                    </c:choose>
                    <c:set var="counter" value="${status.count - 1}" />
                    <html-el:hidden property="combatServiceId[${counter}]" />
                    <tr>
															<td class="<c:out value="${rowValueColor}" />"
																colspan="3"><img alt="" src="../images/spacer.gif"
																width="28" height="5" /></td>
                    </tr>
                    <tr>
															<c:set var="combatServiceLocationLabel">
																<bean-el:message key="label.combatServiceLocation" />
															</c:set>
															<td width="50%"
																class="<c:out value="${rowLabelColor}" />" nowrap><fw:label
																	property="combatServiceLocation[${counter}]"
																	forId="combatServiceLocation[${counter}]_id">
																	<bean-el:message bundle="military"
																		key="label.combatServiceLocation" />:</fw:label></td>
															<td width="50%"
																class="<c:out value="${rowValueColor}" />" colspan="2"><html-el:text
																	title="${combatServiceLocationLabel} ${status.count}"
																	styleId="combatServiceLocation[${counter}]_id"
																	property="combatServiceLocation[${counter}]"
																	readOnly="true" /></td>
                    </tr>
                    <tr>
															<c:set var="combatPayStartDateLabel">
																<bean-el:message key="label.combatPayStartDate" />
															</c:set>
															<td class="<c:out value="${rowLabelColor}" />" nowrap><fw:label
																	property="combatPayStartDate[${counter}]"
																	forId="combatPayStartDate[${counter}]_id">
																	<bean-el:message bundle="military"
																		key="label.combatPayStartDate" />:</fw:label></td>
															<td class="<c:out value="${rowValueColor}" />"
																colspan="2"><html-el:text
																	title="${combatPayStartDateLabel} ${status.count}"
																	property="combatPayStartDate[${counter}]"
																	styleId="combatPayStartDate[${counter}]_id"
																	readOnly="true" /></td>
														</tr>
														<tr>
															<c:set var="combatPayEndDateLabel">
																<bean-el:message key="label.combatPayEndDate" />
															</c:set>
															<td class="<c:out value="${rowLabelColor}" />" nowrap><fw:label
																	property="combatPayEndDate[${counter}]"
																	forId="combatPayEndDate[${counter}]_id">
																	<bean-el:message bundle="military"
																		key="label.combatPayEndDate" />:</fw:label></td>
															<td class="<c:out value="${rowValueColor}" />"
																colspan="2"><html-el:text
																	title="${combatPayEndDateLabel} ${status.count}"
																	property="combatPayEndDate[${counter}]"
																	styleId="combatPayEndDate[${counter}]_id"
																	readOnly="true" /></td>
														</tr>
														<tr>
															<c:set var="combatServiceSourceLabel">
																<bean-el:message key="label.combatServiceSource" />
															</c:set>
															<td class="<c:out value="${rowLabelColor}" />" nowrap><fw:label
																	property="combatServiceSource[${counter}]"
																	forId="combatServiceSource[${counter}]_id">
																	<bean-el:message bundle="military"
																		key="label.combatServiceSource" />:</fw:label></td>
															<td class="<c:out value="${rowValueColor}" />"
																colspan="2"><html-el:text
																	title="${combatServiceSourceLabel} ${status.count}"
																	property="combatServiceSource[${counter}]"
																	styleId="combatServiceSource[${counter}]_id"
																	readOnly="true" /></td>
                    </tr>
                    <tr>
															<td class="<c:out value="${rowValueColor}" />"
																colspan="3"><img alt="" src="../images/spacer.gif"
																width="28" height="5" /></td>
                    </tr>

                    </c:forEach>
                  </table>

                </td>
              </tr>
              </c:when>
              <c:otherwise>
                <tr>
                  <td width="5px" class="moduleValue" nowrap>&nbsp;&nbsp;&nbsp;&nbsp;</td>
											<td width="100%" class="moduleValue"><bean-el:message
													key="label.noDataAvailable" /></td>
                </tr>
              </c:otherwise>
              </c:choose>
              <tr>
                <td colspan="2">
										<table width="100%" border="0" cellspacing="0" cellpadding="0"
											class="moduleShellTableHead" role="presentation">
                    <tr>
												<td class="moduleBrownBox"><img alt=""
													src="../images/spacer.gif" width="28" height="23" /></td>
												<td nowrap>&nbsp;<bean-el:message
														key="label.militaryServiceEpisodes" /> - <bean-el:message
														key="label.HEC" /></td>
												<td width="10%" nowrap><c:if test="${not readOnlyMS}">
														<table width="20%" border="0" cellspacing="0"
															cellpadding="0" role="presentation">
                          <tr>
																<td width="50%"><img alt=""
																	src="../images/spacer.gif" /></td>
                            <td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
																<td><html-el:submit property="methodName"
																		style="width:180; vertical-align: top;"
																		styleClass="buttonText">
																		<bean-el:message
																			key="button.addMilitaryServiceEpisode" />
																	</html-el:submit></td>
                            <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
																<td width="50%"><img alt=""
																	src="../images/spacer.gif" /></td>
																<td width="1" style="padding: 0 5 0 0"><img alt=""
																	src="../images/spacer.gif" /></td>
                          </tr>
                        </table>
													</c:if></td>
                    </tr>
                  </table>
                </td>
              </tr>

              <c:choose>
									<c:when
										test="${not empty militaryServiceInfoForm.serviceEpisodeIdList}">
              <tr>
                <td colspan="2">
												<table width="100%" border="0" cellspacing="0"
													cellpadding="0" class="moduleShellTableBody"
													role="presentation">

            <c:set var="rowColor" value="light"/>
													<c:forEach var="serviceEpisode"
														items="${militaryServiceInfoForm.serviceEpisodeIdList}"
														varStatus="status">
                    <c:choose>
                    <c:when test="${status.last}">
                    <c:set var="listSize" value="${status.count}"/>
                    </c:when>
              <c:when test="${rowColor == 'light'}">
                <c:set var="rowColor" value="dark"/>
                <c:set var="rowLabelColor" value="darkLabel"/>
                <c:set var="rowValueColor" value="darkValue"/>
              </c:when>
              <c:otherwise>
                <c:set var="rowColor" value="light"/>
                <c:set var="rowLabelColor" value="label"/>
                <c:set var="rowValueColor" value="value"/>
              </c:otherwise>
                    </c:choose>
                    <c:set var="counter" value="${status.count - 1}" />
														<c:set var="hashCode"
															value="${militaryServiceInfoForm.serviceEpisodeHashCodeList[counter]}" />
                    <html-el:hidden property="serviceEpisodeId[${counter}]" />
                    <tr>
															<td class="<c:out value="${rowValueColor}" />"
																colspan="4"><img alt="" src="../images/spacer.gif"
																width="28" height="5" /></td>
														</tr>
														<tr>
															<c:set var="militaryServiceNumberLabel">
																<bean-el:message key="label.militaryServiceNumber" />
															</c:set>
															<td width="50%"
																class="<c:out value="${rowLabelColor}" />"><fw:label
																	required="false"
																	property="serviceEpisodeMilitaryServiceNumber[${counter}],serviceEpisodeMilitaryServiceNumber_${hashCode}"
																	forId="serviceEpisodeMilitaryServiceNumber[${counter}]_id">
																	<bean-el:message key="label.militaryServiceNumber" />:</fw:label></td>
															<td class="<c:out value="${rowValueColor}" />" nowrap><html-el:text
																	title="${militaryServiceNumberLabel} ${status.count}"
																	property="serviceEpisodeMilitaryServiceNumber[${counter}]"
																	styleClass="moduleEdit"
																	styleId="serviceEpisodeMilitaryServiceNumber[${counter}]_id"
																	size="15" maxlength="15" readOnly="${readOnlyMS||((readOnlyFDDA&&readOnlyFDDE)&&(militaryServiceInfoForm.fddId == militaryServiceInfoForm.serviceEpisodeIdList[counter]))}" /></td>
															<td width="15%"
																class="<c:out value="${rowValueColor}" />" nowrap>
																<c:if
																	test="${serviceEpisode == null || serviceEpisode == ''}">
                        <c:if test="${not readOnlyMS}">
																		<table border="0" cellspacing="0" cellpadding="0"
																			role="presentation">
                          <tr>
																				<td width="50%"><img alt=""
																					src="../images/spacer.gif" /></td>
																				<td><img alt=""
																					src="../images/buttonEndLeft.gif" /></td>
																				<td><html-el:submit property="methodName"
																						onClick="javascript:setField(this.form,'serviceEpisodeMilitaryServiceNumber[${counter}]',ssn); return false;"
																						style="width:70; vertical-align: top;"
																						styleClass="buttonText">
																						<bean-el:message key="label.sameAsSSN" />
																					</html-el:submit></td>
																				<td><img alt=""
																					src="../images/buttonEndRight.gif" /></td>
																				<td width="50%"><img alt=""
																					src="../images/spacer.gif" /></td>
                          </tr>
                        </table>
                        </c:if>
                        </c:if>
                      </td>
                      
															<td width="20%"
																class="<c:out value="${rowValueColor}" />" nowrap>
																<c:if test="${((not readOnlyMS)&&(militaryServiceInfoForm.serviceEpisodeFutureDischargeDateList[counter]==''))
																||((not readOnlyFDDE)&&(militaryServiceInfoForm.serviceEpisodeFutureDischargeDateList[counter]!=''))}">
																	<table align="left" width="100%" border="0"
																		cellspacing="0" cellpadding="0" role="presentation">
                                        <tr>
																			<td width="10%"><img alt=""
																				src="../images/spacer.gif" /></td>
																			<td valign="top"><img alt=""
																				src="../images/buttonEndLeft.gif" /></td>
																			<td><html-el:submit
																					onclick="if (confirm('${deleteMseMsg}') != 1) {return false;};if(campLejuneDelMesgWarningDel(${militaryServiceInfoForm.serviceEpisodeIdListSize},${counter})!=1) {return false;} ; this.form.deletedEpisodeIndex.value=${counter}; this.value='${button_deleteMilitaryServiceEpisode}'"
																					property="methodName"
																					style="width:45; vertical-align: top;"
																					styleClass="buttonText">Delete</html-el:submit></td>
																			<td valign="top"><img alt=""
																				src="../images/buttonEndRight.gif" /></td>
																			<td width="90%"><img alt=""
																				src="../images/spacer.gif" /></td>
																			<td width="1" style="padding: 0 5 0 0"><img
																				alt="" src="../images/spacer.gif" /></td>
                                        </tr>
                                      </table>
                                    </c:if>
                      </td>
                      
                    </tr>
                    <tr>
															<c:set var="branchOfServiceLabel">
																<bean-el:message key="label.branchOfService" />
															</c:set>
															<td class="<c:out value="${rowLabelColor}" />" nowrap><fw:label
																	required="true"
																	property="serviceEpisodeBranchOfService[${counter}],serviceEpisodeBranchOfService_${hashCode}"
																	forId="serviceEpisodeBranchOfService[${counter}]_id">
																	<bean-el:message key="label.branchOfService" />:</fw:label></td>
															<td class="<c:out value="${rowValueColor}" />"
																colspan="3"><c:set
																	var="serviceEpisodeServiceComponentId"
																	value="serviceEpisodeServiceComponent${counter}" /> <html-el:select
																	title="${requiredText}, ${branchOfServiceLabel} ${status.count}"
																	styleClass="moduleEdit"
																	styleId="serviceEpisodeBranchOfService[${counter}]_id"
																	property="serviceEpisodeBranchOfService[${counter}]"
																	disabled="${readOnlyMS}"
                          onchange="removeServiceComponent('${serviceEpisodeServiceComponentId}','${eliminateServiceComponentWarning}')">
																	<html-el:option styleClass="moduleEdit" value="">
																		<bean-el:message key="label.select" />
																	</html-el:option>
																	<esrcore:options styleClass="moduleEdit"
																		collection="gov.va.med.esr.common.model.lookup.ServiceBranch"
																		property="code" labelProperty="description" />
																</html-el:select></td>
                    </tr>
                    <tr>
															<c:set var="serviceEntryDateLabel">
																<bean-el:message key="label.serviceEntryDate" />
															</c:set>
															<td class="<c:out value="${rowLabelColor}" />"><fw:label
																	required="true"
																	property="serviceEpisodeEntryDate[${counter}],serviceEpisodeEntryDate_${hashCode}"
																	forId="serviceEpisodeEntryDate[${counter}]_id">
																	<bean-el:message key="label.serviceEntryDate" />:</fw:label></td>
															<td class="<c:out value="${rowValueColor}" />"
																colspan="3"><html-el:text
																	title="${requiredText}, ${serviceEntryDateLabel} ${status.count} ${mmddyyyyText}"
																	property="serviceEpisodeEntryDate[${counter}]"
																	styleClass="moduleEdit"
																	styleId="serviceEpisodeEntryDate[${counter}]_id"
																	size="10" maxlength="10" readOnly="${readOnlyMS||((readOnlyFDDA&&readOnlyFDDE)&&(militaryServiceInfoForm.fddId == militaryServiceInfoForm.serviceEpisodeIdList[counter]))}"
																	onchange="processMSEChanged()" />&nbsp;<bean-el:message
																	key="label.mmddyyyy" /></td>
                    </tr>
                    <tr>
															<c:set var="futureDischargeDatelabel">
																<bean-el:message key="label.futureDischargeDate" />
															</c:set>
															<td width="50%"
																class="<c:out value="${rowLabelColor}" />"><fw:label
																	required="false"
																	property="serviceEpisodeFutureDischargeDate[${counter}],serviceEpisodeFutureDischargeDate_${hashCode}"
																	forId="serviceEpisodeFutureDischargeDate[${counter}]_id">
																	<html-el:img alt="${expandableSectionCollapsed}"
																		align="center" styleId="riArrowImageFD_${counter}"
																		src="../images/redArrowRight.gif"
																		onclick="expandOrCollapse(fddBlock_${counter},riArrowImageFD_${counter})" />
																	<bean-el:message key="label.futureDischargeDate" />:</fw:label></td>
                      <td class="<c:out value="${rowValueColor}" />" colspan="3">
																<html-el:text
																	title="${futureDischargeDatelabel} ${status.count} ${mmddyyyyText}"
																	property="serviceEpisodeFutureDischargeDate[${counter}]"
																	styleClass="moduleEdit"
																	styleId="serviceEpisodeFutureDischargeDate[${counter}]_sid" 
																	size="10" maxlength="10" 
																	readonly="${(readOnlyFDDA&&readOnlyFDDE)||((militaryServiceInfoForm.fddId != militaryServiceInfoForm.serviceEpisodeIdList[counter])&&(militaryServiceInfoForm.serviceEpisodeIdList[counter]!=''||militaryServiceInfoForm.fddExisting))}"
																	onkeydown="processFD('fddBlock_${counter}','riArrowImageFD_${counter}',${counter},event)"
																	onchange="processMSEChanged();processAsteriskFDD(${counter})" />&nbsp;<bean-el:message
																	key="label.mmddyyyy" />
																<html-el:hidden  property="serviceEpisodeFutureDischargeDateDB[${counter}]"></html-el:hidden>
                      </td>
                    </tr>
														
														<tr id="fddBlock_${counter}">
															<td colspan="9">															
																	<table width="100%" cellSpacing="0" cellPadding="0"
																		border="0" role="presentation">
                    <tr>
																			<c:set var="sourceOfInformationLabel">
																				<bean-el:message key="label.sourceOfInformation" />
																			</c:set>
																			<td width="50%" id="serviceEpisodeSourceOfInformation[${counter}]_id_noStarLabel" style="display='block'"
																				class="<c:out value="${rowLabelColor}" />" nowrap><fw:label
																					required="false"
																					property="serviceEpisodeSourceOfInformation[${counter}],serviceEpisodeSourceOfInformation_${hashCode}"
																					forId="serviceEpisodeSourceOfInformation[${counter}]_id">
																					<bean-el:message bundle="military"
																						key="label.sourceOfInformation" />:</fw:label></td>
																			<td width="50%" id="serviceEpisodeSourceOfInformation[${counter}]_id_StarLabel" style="display='none'"
																				class="<c:out value="${rowLabelColor}" />" nowrap><fw:label
																					required="true"
																					property="serviceEpisodeSourceOfInformation[${counter}],serviceEpisodeSourceOfInformation_${hashCode}"
																					forId="serviceEpisodeSourceOfInformation[${counter}]_id">
																					<bean-el:message bundle="military"
																						key="label.sourceOfInformation" />:</fw:label></td>
                      <td class="<c:out value="${rowValueColor}" />" colspan="3">
																				<html-el:select
																					title="${sourceOfInformationLabel} ${status.count}"
																					property="serviceEpisodeSourceOfInformation[${counter}]"
																					styleClass="moduleEdit"
																					styleId="serviceEpisodeSourceOfInformation[${counter}]_sid"
																					readonly="${(readOnlyFDDA&&readOnlyFDDE)||((militaryServiceInfoForm.fddId != militaryServiceInfoForm.serviceEpisodeIdList[counter])&&(militaryServiceInfoForm.serviceEpisodeIdList[counter]!=''||militaryServiceInfoForm.fddExisting))}"
																					onchange="processSOI('soiBlock_${counter}','serviceEpisodeSourceOfInformation[${counter}]_sid');processMSEChanged();">
																					<html-el:option styleClass="moduleEdit" value="">
																						<bean-el:message key="label.select" />
																					</html-el:option>
																					<esrcore:options styleClass="moduleEdit"
																						collection="gov.va.med.esr.common.model.lookup.FutureDischargeSourceType"
																						property="code" labelProperty="description" />
                        </html-el:select>
																				<html-el:hidden  property="serviceEpisodeSourceOfInformationDB[${counter}]"></html-el:hidden>
																				</td>
																		</tr>
																		
																						<tr id="soiBlock_${counter}" 
																							style="display:${militaryServiceInfoForm.serviceEpisodeSourceOfInformationList[counter]!='OT' ? 'none':'block'}">
																							<c:set var="otherExplanationLabel">
																								<bean-el:message key="label.otherExplanation" />
																							</c:set>
																							<td width="50%" id="serviceEpisodeOtherExplanation[${counter}]_id_noStarLabel" style="display='block'"
																								class="<c:out value="${rowLabelColor}" />"><fw:label
																									required="false"
																									property="serviceEpisodeOtherExplanation[${counter}],serviceEpisodeOtherExplanation_${hashCode}"
																									forId="serviceEpisodeOtherExplanation[${counter}]_id">
																									<bean-el:message key="label.otherExplanation" />:</fw:label></td>
																							<td width="50%" id="serviceEpisodeOtherExplanation[${counter}]_id_StarLabel" style="display='none'"
																								class="<c:out value="${rowLabelColor}" />"><fw:label
																									required="true"
																									property="serviceEpisodeOtherExplanation[${counter}],serviceEpisodeOtherExplanation_${hashCode}"
																									forId="serviceEpisodeOtherExplanation[${counter}]_id">
																									<bean-el:message key="label.otherExplanation" />:</fw:label></td>
																							<td class="<c:out value="${rowValueColor}" />"
																								colspan="3"><html-el:textarea
																									title="${otherExplanationLabel} ${status.count}"
																									property="serviceEpisodeOtherExplanation[${counter}]"
																									styleClass="moduleEdit"
																									styleId="serviceEpisodeOtherExplanation[${counter}]_sid"
																									size="30" maxlength="255"
																									readonly="${(readOnlyFDDA&&readOnlyFDDE)||((militaryServiceInfoForm.fddId != militaryServiceInfoForm.serviceEpisodeIdList[counter])&&(militaryServiceInfoForm.serviceEpisodeIdList[counter]!=''||militaryServiceInfoForm.fddExisting))}"
																									onchange="processMSEChanged()" /></td>
																						</tr>																					
																	</table>
                      </td>
                    </tr>
                  
                    <tr>
															<c:set var="serviceSeperationDateLabel">
																<bean-el:message key="label.serviceSeperationDate" />
															</c:set>
															<td id="serviceEpisodeSeparationDate[${counter}]_id_noStarLabel" style="display='none'" class="<c:out value="${rowLabelColor}" />" nowrap><fw:label
																	required="false"
																	property="serviceEpisodeSeparationDate[${counter}],serviceEpisodeSeparationDate_${hashCode}"
																	forId="serviceEpisodeSeparationDate[${counter}]_id">
																	<bean-el:message key="label.serviceSeperationDate" />:</fw:label></td>
															<td id="serviceEpisodeSeparationDate[${counter}]_id_StarLabel" style="display='block'" class="<c:out value="${rowLabelColor}" />" nowrap><fw:label
																	required="true"
																	property="serviceEpisodeSeparationDate[${counter}],serviceEpisodeSeparationDate_${hashCode}"
																	forId="serviceEpisodeSeparationDate[${counter}]_id">
																	<bean-el:message key="label.serviceSeperationDate" />:</fw:label></td>
															<td class="<c:out value="${rowValueColor}" />"
																colspan="3"><html-el:text
																	title="${requiredText}, ${serviceSeperationDateLabel} ${status.count} ${mmddyyyyText}"
																	property="serviceEpisodeSeparationDate[${counter}]"
																	styleClass="moduleEdit"
																	styleId="serviceEpisodeSeparationDate[${counter}]_sid"
																	size="10" maxlength="10" readOnly="${readOnlyMS}"
																	onchange="processMSEChanged();processAsteriskMSE(${counter})" />&nbsp;<bean-el:message
																	key="label.mmddyyyy" /></td>
														</tr>														
														<tr>
															<c:set var="serviceComponentLabel">
																<bean-el:message key="label.serviceComponent" />
															</c:set>
															<td  class="<c:out value="${rowLabelColor}" />" nowrap><fw:label
																	required="false"
																	property="serviceEpisodeServiceComponent[${counter}],serviceEpisodeServiceComponent_${hashCode}"
																	forId="serviceEpisodeServiceComponent[${counter}]_id">
																	<bean-el:message bundle="military"
																		key="label.serviceComponent" />:</fw:label></td>															
															<td class="<c:out value="${rowValueColor}" />"
																colspan="3"><html-el:select
																	title="${serviceComponentLabel} ${status.count}"
																	styleId="serviceEpisodeServiceComponent[${counter}]_id"
																	styleClass="moduleEdit"
																	property="serviceEpisodeServiceComponent[${counter}]"
																	disabled="${readOnlyMS}">
																	<html-el:option styleClass="moduleEdit" value="">
																		<bean-el:message key="label.select" />
																	</html-el:option>
																	<esrcore:options styleClass="moduleEdit"
																		collection="gov.va.med.esr.common.model.lookup.MilitaryServiceComponent"
																		property="code" labelProperty="description" />
																</html-el:select></td>
														</tr>
														<tr>
															<c:set var="dischargeTypeLabel">
																<bean-el:message key="label.dischargeType" />
															</c:set>
															<td id="serviceEpisodeDischargeType[${counter}]_id_noStarLabel" style="display='none'" class="<c:out value="${rowLabelColor}" />" nowrap><fw:label
																	required="false"
																	property="serviceEpisodeDischargeType[${counter}],serviceEpisodeDischargeType_${hashCode}"
																	forId="serviceEpisodeDischargeType[${counter}]_id">
																	<bean-el:message bundle="military"
																		key="label.dischargeType" />:</fw:label></td>
															<td id="serviceEpisodeDischargeType[${counter}]_id_StarLabel" style="display='block'" class="<c:out value="${rowLabelColor}" />" nowrap><fw:label
																	required="true"
																	property="serviceEpisodeDischargeType[${counter}],serviceEpisodeDischargeType_${hashCode}"
																	forId="serviceEpisodeDischargeType[${counter}]_id">
																	<bean-el:message bundle="military"
																		key="label.dischargeType" />:</fw:label></td>
															<td class="<c:out value="${rowValueColor}" />"
																colspan="3"><html-el:select
																	title="${requiredText}, ${dischargeTypeLabel} ${status.count}"
																	styleClass="moduleEdit"
																	styleId="serviceEpisodeDischargeType[${counter}]_sid"
																	property="serviceEpisodeDischargeType[${counter}]"
																	disabled="${readOnlyMS}" onchange="processMSEChanged()">
																	<html-el:option styleClass="moduleEdit" value="">
																		<bean-el:message key="label.select" />
																	</html-el:option>
																	<esrcore:options styleClass="moduleEdit"
																		collection="gov.va.med.esr.common.model.lookup.DischargeType"
																		property="code" labelProperty="description" />
																</html-el:select></td>
                    </tr>
                    <tr>
															<td class="<c:out value="${rowValueColor}" />"
																colspan="4"><img alt="" src="../images/spacer.gif"
																width="28" height="5" /></td>
														</tr>
                    </c:forEach>
                  </table>
                </td>
              </tr>
              </c:when>
              <c:otherwise>
              <tr>
                <td width="5px" class="moduleValue" nowrap>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
											<td width="100%" class="moduleValue"><bean-el:message
													key="label.noDataAvailable" /></td>
              </tr>
              </c:otherwise>
              </c:choose>
              <tr>
                <td colspan="2">
										<table width="100%" border="0" cellspacing="0" cellpadding="0"
											class="moduleShellTableHead" role="presentation">
                    <tr>
												<td class="moduleBrownBox"><img alt=""
													src="../images/spacer.gif" width="28" height="23" /></td>
												<td nowrap>&nbsp;<bean-el:message
														key="label.conflictEpisodes" /> - <bean-el:message
														key="label.HEC" /></td>
												<td width="10%" nowrap><c:if test="${not readOnlyMS}">
														<table width="20%" border="0" cellspacing="0"
															cellpadding="0" role="presentation">
                          <tr>
																<td width="50%"><img alt=""
																	src="../images/spacer.gif" /></td>
                            <td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
																<td><html-el:submit property="methodName"
																		style="width:135; vertical-align: top;"
																		styleClass="buttonText">
																		<bean-el:message key="button.addConflictEpisode" />
																	</html-el:submit></td>
                            <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
																<td width="50%"><img alt=""
																	src="../images/spacer.gif" /></td>
																<td width="1" style="padding: 0 5 0 0"><img alt=""
																	src="../images/spacer.gif" /></td>
                          </tr>
                        </table>
													</c:if></td>
                    </tr>
                  </table>
                </td>
              </tr>

              <c:choose>
									<c:when
										test="${not empty militaryServiceInfoForm.conflictEpisodeIdList}">
              <tr>
                <td colspan="2">
												<table width="100%" border="0" cellspacing="0"
													cellpadding="0" class="moduleShellTableBody"
													role="presentation">

            <c:set var="rowColor" value="light"/>
													<c:forEach var="conflictEpisodeId"
														items="${militaryServiceInfoForm.conflictEpisodeIdList}"
														varStatus="status">
                    <c:choose>
              <c:when test="${rowColor == 'light'}">
                <c:set var="rowColor" value="dark"/>
                <c:set var="rowLabelColor" value="darkLabel"/>
                <c:set var="rowValueColor" value="darkValue"/>
              </c:when>
              <c:otherwise>
                <c:set var="rowColor" value="light"/>
                <c:set var="rowLabelColor" value="label"/>
                <c:set var="rowValueColor" value="value"/>
              </c:otherwise>
                    </c:choose>
                    <c:set var="counter" value="${status.count - 1}" />
														<c:set var="hashCode"
															value="${militaryServiceInfoForm.conflictEpisodeHashCodeList[counter]}" />
                    <html-el:hidden property="conflictEpisodeId[${counter}]" />
                    <tr>
															<td class="<c:out value="${rowValueColor}" />"
																colspan="3"><img alt="" src="../images/spacer.gif"
																width="28" height="5" /></td>
														</tr>
														<tr>
															<c:set var="conflictservicelocationLabel">
																<bean-el:message key="label.conflictservicelocation" />
															</c:set>
															<td width="50%"
																class="<c:out value="${rowLabelColor}" />" nowrap><fw:label
																	required="true"
																	property="conflictEpisodeLocation[${counter}],conflictEpisodeLocation_${hashCode}"
																	forId="conflictEpisodeLocation[${counter}]_id">
																	<bean-el:message bundle="military"
																		key="label.conflictservicelocation" />:</fw:label></td>
															<td width="20%"
																class="<c:out value="${rowValueColor}" />"><html-el:select
																	title="${requiredText}, ${conflictservicelocationLabel} ${status.count}"
																	styleClass="moduleEdit"
																	property="conflictEpisodeLocation[${counter}]"
																	styleId="conflictEpisodeLocation[${counter}]_id"
																	disabled="${readOnlyMS}">
																	<html-el:option styleClass="moduleEdit" value="">
																		<bean-el:message key="label.select" />
																	</html-el:option>
																	<esrcore:options styleClass="moduleEdit"
																		collection="gov.va.med.esr.ui.common.beans.NonOEFOIFCombatLocation"
																		property="code" labelProperty="nameAndDateRange" />
																</html-el:select></td>
                      
															<td width="30%"
																class="<c:out value="${rowValueColor}" />" nowrap><c:if
																	test="${not readOnlyMS}">
																	<table align="left" width="100%" border="0"
																		cellspacing="0" cellpadding="0" role="presentation">
                                                    <tr>
																			<td width="10%"><img alt=""
																				src="../images/spacer.gif" /></td>
																			<td valign="top"><img alt=""
																				src="../images/buttonEndLeft.gif" /></td>
																			<td><html-el:submit
																					onclick="this.form.deletedEpisodeIndex.value=${counter};this.value='${button_deleteConflictEpisode}'"
																					property="methodName"
																					style="width:45; vertical-align: top;"
																					styleClass="buttonText">Delete</html-el:submit></td>
																			<td valign="top"><img alt=""
																				src="../images/buttonEndRight.gif" /></td>
																			<td width="90%"><img alt=""
																				src="../images/spacer.gif" /></td>
																			<td width="1" style="padding: 0 5 0 0"><img
																				alt="" src="../images/spacer.gif" /></td>
                                                    </tr>
                                                  </table>
																</c:if></td>
                      
                    </tr>
                    <tr>
															<c:set var="conflictStartDateLabel">
																<bean-el:message key="label.conflictStartDate" />
															</c:set>
															<td class="<c:out value="${rowLabelColor}" />" nowrap><fw:label
																	required="true"
																	property="ConflictExperience_${hashCode},conflictEpisodeStartDate[${counter}],conflictEpisodeStartDate_${hashCode}"
																	forId="conflictEpisodeStartDate[${counter}]_id">
																	<bean-el:message bundle="military"
																		key="label.conflictStartDate" />:</fw:label></td>
															<td class="<c:out value="${rowValueColor}" />"
																colspan="2"><html-el:text
																	title="${requiredText}, ${conflictStartDateLabel} ${status.count} ${mmddyyyyText}"
																	property="conflictEpisodeStartDate[${counter}]"
																	styleClass="moduleEdit"
																	styleId="conflictEpisodeStartDate[${counter}]_id"
																	size="10" maxlength="10" readOnly="${readOnlyMS}" />&nbsp;<bean-el:message
																	key="label.mmddyyyy" /></td>
														</tr>
														<tr>
															<c:set var="conflictEndDateLabel">
																<bean-el:message key="label.conflictEndDate" />
															</c:set>
															<td class="<c:out value="${rowLabelColor}" />" nowrap><fw:label
																	required="true"
																	property="ConflictExperience_${hashCode},conflictEpisodeEndDate[${counter}],conflictEpisodeEndDate_${hashCode}"
																	forId="conflictEpisodeEndDate[${counter}]_id">
																	<bean-el:message bundle="military"
																		key="label.conflictEndDate" />:</fw:label></td>
															<td class="<c:out value="${rowValueColor}" />"
																colspan="2"><html-el:text
																	title="${requiredText}, ${conflictEndDateLabel} ${status.count} ${mmddyyyyText}"
																	property="conflictEpisodeEndDate[${counter}]"
																	styleClass="moduleEdit"
																	styleId="conflictEpisodeEndDate[${counter}]_id"
																	size="10" maxlength="10" readOnly="${readOnlyMS}" />&nbsp;<bean-el:message
																	key="label.mmddyyyy" /></td>
                    </tr>
                    <tr>
															<td class="<c:out value="${rowValueColor}" />"
																colspan="3"><img alt="" src="../images/spacer.gif"
																width="28" height="5" /></td>
                    </tr>
                    </c:forEach>
                  </table>
                </td>
              </tr>
              </c:when>
              <c:otherwise>
              <tr>
                <td width="5px" class="moduleValue" nowrap>&nbsp;&nbsp;&nbsp;&nbsp;</td>
											<td width="100%" class="moduleValue"><bean-el:message
													key="label.noDataAvailable" /></td>
              </tr>
              </c:otherwise>
              </c:choose>

              <tr>
          <td colspan="2">
										<table width="100%" border="0" cellspacing="0" cellpadding="0"
											class="moduleShellTableHead" role="presentation">
          <tr>
												<td class="moduleBrownBox"><img alt=""
													src="../images/spacer.gif" width="28" height="23" /></td>
												<td nowrap>&nbsp;<bean-el:message
														key="label.periodOfService" /></td>
												<td width="10%" nowrap><c:if test="${not readOnlyMS}">
														<table width="20%" border="0" cellspacing="0"
															cellpadding="0" role="presentation">
            <tr>
																<td width="100%"><img alt=""
																	src="../images/spacer.gif" width="1" height="1" />&nbsp;&nbsp;</td>
            </tr>
              </table>
													</c:if></td>
          </tr>
        </table>
          </td>
              </tr>
              <tr>
          <td colspan="2">
										<table width="100%" border="0" cellspacing="0" cellpadding="0"
											class="moduleShellTableBody" role="presentation">
											<tr>
												<td class="moduleValue" colspan="3"><img alt=""
													src="../images/spacer.gif" width="28" height="5" /></td>
											</tr>
           <tr>
												<c:set var="periodOfServiceLabel">
													<bean-el:message key="label.periodOfService" />
												</c:set>
												<td width="50%" class="moduleLabel"><fw:label
														property="periodOfService" forId="periodOfServiceId">
														<bean-el:message key="label.HEC" />&nbsp;<bean-el:message
															key="label.periodOfService" />:</fw:label></td>
												<td width="30%" class="moduleValue"><html-el:select
														title="${periodOfServiceLabel}" styleClass="moduleEdit"
														property="periodOfService" styleId="periodOfServiceId"
														disabled="${readOnlyMS}">
														<html-el:option styleClass="moduleEdit" value="">
															<bean-el:message key="label.select" />
														</html-el:option>
														<esrcore:options styleClass="moduleEdit"
															collection="gov.va.med.esr.common.model.lookup.ServicePeriod"
															property="code" labelProperty="nameAndDateRange" />
													</html-el:select></td>
												<td class="moduleValue"><c:if
														test="${(not readOnlyMS) && (appData[personKey].veteran == true)}">
														<table width="50" border="0" cellspacing="0"
															cellpadding="0" class="moduleShellTableBody"
															role="presentation">
                  <tr>
																<td width="50%"><img alt=""
																	src="../images/spacer.gif" /></td>
                    <td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
																<td><html-el:submit property="methodName"
																		style="width:90; vertical-align: top;"
																		styleClass="buttonText">
																		<bean-el:message key="button.calculatePOS" />
																	</html-el:submit></td>
                    <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
																<td width="50%"><img alt=""
																	src="../images/spacer.gif" /></td>
																<td width="1" style="padding: 0 5 0 0"><img alt=""
																	src="../images/spacer.gif" /></td>
                  </tr>
                </table>
													</c:if></td>
											</tr>
											<tr>
												<td class="moduleValue" colspan="3"><img alt=""
													src="../images/spacer.gif" width="28" height="5" /></td>
          </tr>
        </table>
          </td>
          </tr>

              <tr>
									<td class="moduleValue" colspan="3"><c:set
											var="agentOrangeLocationRemovedWarning">
											<bean-el:message key="message.agentOrangeLocationRemoved" />
										</c:set> <c:set var="radiationExposureMethodRemovedWarning">
											<bean-el:message key="message.radiationExposureMethodRemoved" />
										</c:set> <c:set var="MOHDataSourcesNotAllowedWarning">
											<bean-el:message key="message.MOHDataSourcesNotAllowed" />
										</c:set> <br> <br> <c:choose>
                  <c:when test="${readOnlyMS}">
                  <!-- no cancel button is defined in the current screen -->
                  </c:when>
                  <c:otherwise>
												<table width="100%" border="0" align="center"
													cellspacing="0" cellpadding="0" role="presentation">
                    <tr>
														<td width="45%"><img alt=""
															src="../images/spacer.gif" /></td>
                      <td><img alt=""  src="../images/buttonEndLeft.gif" /></td>
                <!-- good one for display check Apply Button warning <td><html-el:submit property="methodName" style="width:50; vertical-align: top;" styleClass="buttonText" onclick="return campLejuneDelMesgWarning(${listSize},${isAddAPerson})"><bean-el:message key="button.update" /></html-el:submit></td>  -->
                <!-- good one for all javascripts on Update button <td><html-el:submit property="methodName" style="width:50; vertical-align: top;" styleClass="buttonText" onclick="checkIfChanged('${serviceEpisodeBranchOfServiceHiddenField}','serviceEpisodeBranchOfService[${counter}]_id','${serviceEpisodeServiceComponentId}','${eliminateServiceComponentWarning}'); checkIfDischargeTypeChanged('${serviceEpisodeDischargeTypeHiddenField}','serviceEpisodeDischargeType[${counter}]_id'); displayMessageIfFieldEmpty(idAgentOrangeExposureLocation,'${agentOrangeLocationRemovedWarning}'); displayMessageIfFieldEmpty(idRadiationExposureMethod,'${radiationExposureMethodRemovedWarning}'); checkDataSourceFields(militaryServiceInfoForm, ${datasource_vadir}, ${datasource_webhinq},  ${datasource_vba}, ${datasource_other}, '${MOHDataSourcesNotAllowedWarning}'); return campLejuneDelMesgWarning(${listSize},${isAddAPerson})"><bean-el:message key="button.update" /></html-el:submit></td>     -->
                <!-- good one for all javascripts on Update button 0709pm_07072015 <td><html-el:submit property="methodName" style="width:50; vertical-align: top;" styleClass="buttonText" onclick="checkIfChanged('${serviceEpisodeBranchOfServiceHiddenField}','serviceEpisodeBranchOfService[${counter}]_id','${serviceEpisodeServiceComponentId}','${eliminateServiceComponentWarning}'); checkIfDischargeTypeChanged('${serviceEpisodeDischargeTypeHiddenField}','serviceEpisodeDischargeType[${counter}]_id'); displayMessageIfFieldEmpty('${agentOrangeExposureLocationHiddenField}', idAgentOrangeExposureLocation, '${agentOrangeLocationRemovedWarning}'); displayMessageIfFieldEmpty('${radiationExposureMethodHiddenField}', idRadiationExposureMethod, '${radiationExposureMethodRemovedWarning}'); checkDataSourceFields(militaryServiceInfoForm, ${datasource_vadir}, ${datasource_webhinq},  ${datasource_vba}, ${datasource_other}, '${MOHDataSourcesNotAllowedWarning}'); return campLejuneDelMesgWarning(${listSize},${isAddAPerson})"><bean-el:message key="button.update" /></html-el:submit></td>   -->
                <!-- good submit for all messages before reverting the code for dischargeType and BranchService  <td><html-el:submit property="methodName" style="width:50; vertical-align: top;" styleClass="buttonText" onclick="checkIfChanged('${serviceEpisodeBranchOfServiceHiddenField}','serviceEpisodeBranchOfService[${counter}]_id','${serviceEpisodeServiceComponentId}','${eliminateServiceComponentWarning}'); checkIfDischargeTypeChanged('${serviceEpisodeDischargeTypeHiddenField}','serviceEpisodeDischargeType[${counter}]_id'); displayMessageIfAgentOrangeExposureLocationEmpty('${agentOrangeExposureLocationHiddenField}', idAgentOrangeExposureLocation, '${agentOrangeLocationRemovedWarning}'); displayMessageIfRadiationExposureMethodEmpty('${radiationExposureMethodHiddenField}', idRadiationExposureMethod, '${radiationExposureMethodRemovedWarning}'); checkDataSourceFields(militaryServiceInfoForm, ${datasource_vadir}, ${datasource_webhinq},  ${datasource_vba}, ${datasource_other}, '${idMohDataSourceHiddenField}', idMohDataSource,'${MOHDataSourcesNotAllowedWarning}'); campLejuneDelMesgWarning(${listSize},${isAddAPerson}); return displyWarnings()"><bean-el:message key="button.update" /></html-el:submit></td>   -->
														<td><html-el:submit property="methodName"
																style="width:50; vertical-align: top;"
																styleClass="buttonText"
																onclick="displayMessageIfAgentOrangeExposureLocationEmpty('${agentOrangeExposureLocationHiddenField}', idAgentOrangeExposureLocation, '${agentOrangeLocationRemovedWarning}'); displayMessageIfRadiationExposureMethodEmpty('${radiationExposureMethodHiddenField}', idRadiationExposureMethod, '${radiationExposureMethodRemovedWarning}'); checkDataSourceFields(militaryServiceInfoForm, ${datasource_vadir}, ${datasource_webhinq},  ${datasource_vba}, ${datasource_other}, '${idMohDataSourceHiddenField}', idMohDataSource,'${MOHDataSourcesNotAllowedWarning}'); campLejuneDelMesgWarning(${listSize},${isAddAPerson}); return displyWarnings()">
																<bean-el:message key="button.update" />
															</html-el:submit></td>
                      
                      <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
                      <td width="1%"><img alt=""  src="../images/spacer.gif"/></td>
                      <td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
														<td><html-el:submit property="methodName"
																style="width:50; vertical-align: top;"
																styleClass="buttonText">
																<bean-el:message key="button.reset" />
															</html-el:submit></td>
                      <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
                      <td width="1%"><img alt=""  src="../images/spacer.gif"/></td>
                      
														<td width="50%"><img alt=""
															src="../images/spacer.gif" /></td>
                      
                      
                    </tr>
                  </table>
                  </c:otherwise>
										</c:choose></td>
								</tr>
								<tr>
									<td colspan="3" class="moduleValue">&nbsp;</td>
              </tr>
							</table></td>
        </tr>
      </table>
    </td>
  </tr>

</table>
</html-el:form>
