<?xml version="1.0" encoding="UTF-8"?>  
<xsl:stylesheet version="1.1" xmlns:esr="urn:esr-vha-gov:internal:hl7-messages" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">	
		<xsl:output method="html"/>
<!--		
	<xsl:variable name="lookupDoc" select="document('hl7Segments.xml')"/>	
	<xsl:key name="hl7" match="segments" use="@name" />
	-->


	<xsl:template match="/">
    <table width="100%">
       <xsl:apply-templates/>
    </table>
	</xsl:template>
	
	<!-- bhs Batch Header Segment -->
	<xsl:template match="esr:bhs">
		<tr><td colspan="2" class="segmentheader">BHS - Batch Header</td></tr>					
		<!-- print the attributes -->
	<!-- 	<xsl:apply-templates/> -->
	</xsl:template>

	<xsl:template match="esr:bhs.1"><tr><th  style="text-align: left" class="moduleLabel">BATCH FIELD SEPARATOR</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:bhs.2"><tr><th  style="text-align: left" class="moduleLabel">BATCH ENCODING CHARACTERS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:bhs.3"><tr><th  style="text-align: left" class="moduleLabel">BATCH SENDING APPLICATION</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:bhs.4"><tr><th  style="text-align: left" class="moduleLabel">BATCH SENDING FACILITY</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:bhs.5"><tr><th  style="text-align: left" class="moduleLabel">BATCH RECEIVING APPLICATION</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:bhs.6"><tr><th  style="text-align: left" class="moduleLabel">BATCH RECEIVING FACILITY</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:bhs.7"><tr><th  style="text-align: left" class="moduleLabel">BATCH CREATION DATE/TIME</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:bhs.8"><tr><th  style="text-align: left" class="moduleLabel">BATCH SECURITY</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:bhs.9"><tr><th  style="text-align: left" class="moduleLabel">BATCH NAME/ID/TYPE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:bhs.10"><tr><th  style="text-align: left" class="moduleLabel">BATCH COMMENT</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:bhs.11"><tr><th  style="text-align: left" class="moduleLabel">BATCH CONTROL ID</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:bhs.12"><tr><th  style="text-align: left" class="moduleLabel">REFERENCE BATCH CONTROL ID</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>

	<!-- BTS – Batch Trailer Segment -->
	<xsl:template match="esr:bts">
		<tr><td colspan="2" class="segmentheader">BTS - Batch Trailer Segment</td></tr>					
		<!-- print the attributes -->
		<xsl:apply-templates/>
	</xsl:template>
			
	<xsl:template match="esr:bts.1"><tr><th  style="text-align: left" class="moduleLabel">BATCH MESSAGE COUNT</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>	
	<xsl:template match="esr:bts.2"><tr><th  style="text-align: left" class="moduleLabel">BATCH COMMENT</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:bts.3"><tr><th  style="text-align: left" class="moduleLabel">BATCH TOTALS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>

	<!--FT1 – Financial Transaction -->
	<xsl:template match="esr:ft1">
		<tr><td colspan="2" class="segmentheader">FT1 - Financial Transaction</td></tr>					
		<!-- print the attributes -->
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="esr:ft1.1"><tr><th  style="text-align: left" class="moduleLabel">SET ID FT1</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:ft1.2"><tr><th  style="text-align: left" class="moduleLabel">TRANSACTION ID</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:ft1.3"><tr><th  style="text-align: left" class="moduleLabel">TRANSACTION BATCH ID</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:ft1.4"><tr><th  style="text-align: left" class="moduleLabel">TRANSACTION DATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:ft1.5"><tr><th  style="text-align: left" class="moduleLabel">TRANSACTION POSTING DATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:ft1.6"><tr><th  style="text-align: left" class="moduleLabel">TRANSACTION TYPE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:ft1.7"><tr><th  style="text-align: left" class="moduleLabel">TRANSACTION CODE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:ft1.8"><tr><th  style="text-align: left" class="moduleLabel">TRANSACTION DESCRIPTION</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:ft1.9"><tr><th  style="text-align: left" class="moduleLabel">TRANSACTION DESCRIPTION (ALT)</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:ft1.10"><tr><th  style="text-align: left" class="moduleLabel">TRANSACTION QUANTITY</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:ft1.11"><tr><th  style="text-align: left" class="moduleLabel">TRANSACTION AMOUNT (EXTENDED)</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:ft1.12"><tr><th  style="text-align: left" class="moduleLabel">TRANSACTION AMOUNT (UNIT)</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:ft1.13"><tr><th  style="text-align: left" class="moduleLabel">DEPARTMENT CODE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:ft1.14"><tr><th  style="text-align: left" class="moduleLabel">INSURANCE PLAN ID</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:ft1.15"><tr><th  style="text-align: left" class="moduleLabel">INSURANCE AMOUNT</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:ft1.16"><tr><th  style="text-align: left" class="moduleLabel">ASSIGNED PATIENT LOCATION</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:ft1.17"><tr><th  style="text-align: left" class="moduleLabel">FEE SCHEDULE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:ft1.18"><tr><th  style="text-align: left" class="moduleLabel">PATIENT TYPE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:ft1.19"><tr><th  style="text-align: left" class="moduleLabel">DIAGNOSIS CODE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:ft1.20"><tr><th  style="text-align: left" class="moduleLabel">PERFORMED BY CODE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:ft1.21"><tr><th  style="text-align: left" class="moduleLabel">ORDERED BY CODE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:ft1.22"><tr><th  style="text-align: left" class="moduleLabel">UNIT COST</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:ft1.23"><tr><th  style="text-align: left" class="moduleLabel">FILTER ORDER NUMBER</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:ft1.24"><tr><th  style="text-align: left" class="moduleLabel">ENTERED BY CODE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:ft1.25"><tr><th  style="text-align: left" class="moduleLabel">PROCEDURE CODE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:ft1.26"><tr><th  style="text-align: left" class="moduleLabel">PROCEDURE CODE MODIFIER</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>

	<!-- IN1 Insurance Segment -->
	<xsl:template match="esr:in1">
		<tr><td colspan="2" class="segmentheader">IN1 - Insurance Segment</td></tr>					
		<!-- print the attributes -->
		<xsl:apply-templates/>
	</xsl:template>
		
	<xsl:template match="esr:in1.1"><tr><th  style="text-align: left" class="moduleLabel">SET ID-IN1</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:in1.2"><tr><th  style="text-align: left" class="moduleLabel">INSURANCE PLAN ID</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:in1.3"><tr><th  style="text-align: left" class="moduleLabel">INSURANCE COMPANY ID</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:in1.4"><tr><th  style="text-align: left" class="moduleLabel">INSURANCE COMPANY NAME</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:in1.5"><tr><th  style="text-align: left" class="moduleLabel">INSURANCE COMPANY ADDRESS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:in1.6"><tr><th  style="text-align: left" class="moduleLabel">INSURANCE CO. CONTACT PERS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:in1.7"><tr><th  style="text-align: left" class="moduleLabel">INSURANCE CO. PHONE NUMBER</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:in1.8"><tr><th  style="text-align: left" class="moduleLabel">GROUP NUMBER</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:in1.9"><tr><th  style="text-align: left" class="moduleLabel">GROUP NAME</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:in1.10"><tr><th  style="text-align: left" class="moduleLabel">INSURED'S GROUP EMP. ID</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:in1.11"><tr><th  style="text-align: left" class="moduleLabel">INSURED'S GROUP EMP. NAME</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:in1.12"><tr><th  style="text-align: left" class="moduleLabel">PLAN EFFECTIVE DATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:in1.13"><tr><th  style="text-align: left" class="moduleLabel">PLAN EXPIRATION DATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:in1.14"><tr><th  style="text-align: left" class="moduleLabel">AUTHORIZATION INFORMATION</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:in1.15"><tr><th  style="text-align: left" class="moduleLabel">PLAN TYPE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:in1.16"><tr><th  style="text-align: left" class="moduleLabel">NAME OF INSURED</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:in1.17"><tr><th  style="text-align: left" class="moduleLabel">INSURED'S RELATION TO PATIENT</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:in1.18"><tr><th  style="text-align: left" class="moduleLabel">INSURED'S DATE OF BIRTH</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:in1.19"><tr><th  style="text-align: left" class="moduleLabel">INSURED'S ADDRESS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:in1.20"><tr><th  style="text-align: left" class="moduleLabel">ASSIGNMENT OF BENEFITS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:in1.21"><tr><th  style="text-align: left" class="moduleLabel">COORDINATION OF BENEFITS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:in1.22"><tr><th  style="text-align: left" class="moduleLabel">CORD. OF BENEFITS PRIORITY</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:in1.23"><tr><th  style="text-align: left" class="moduleLabel">NOTICE OF ADMISSION CODE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:in1.24"><tr><th  style="text-align: left" class="moduleLabel">NOTICE OF ADMISSION DATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:in1.25"><tr><th  style="text-align: left" class="moduleLabel">RPT OF ELIGIBILITY FLAG</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:in1.26"><tr><th  style="text-align: left" class="moduleLabel">RPT OF ELIGIBILITY DATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:in1.27"><tr><th  style="text-align: left" class="moduleLabel">RELEASE OF INFORMATION CODE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:in1.28"><tr><th  style="text-align: left" class="moduleLabel">PRE-ADMIT CERT. (PAC)</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:in1.29"><tr><th  style="text-align: left" class="moduleLabel">VERIFICATION DATE/TIME</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:in1.30"><tr><th  style="text-align: left" class="moduleLabel">VERIFICATION BY</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:in1.31"><tr><th  style="text-align: left" class="moduleLabel">TYPE OF AGREEMENT CODE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:in1.32"><tr><th  style="text-align: left" class="moduleLabel">BILLING STATUS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:in1.33"><tr><th  style="text-align: left" class="moduleLabel">LIFETIME RESERVE DAYS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:in1.34"><tr><th  style="text-align: left" class="moduleLabel">DELAY BEFORE L. R. DAY</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:in1.35"><tr><th  style="text-align: left" class="moduleLabel">COMPANY PLAN CODE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:in1.36"><tr><th  style="text-align: left" class="moduleLabel">POLICY NUMBER</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:in1.37"><tr><th  style="text-align: left" class="moduleLabel">POLICY DEDUCTIBLE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:in1.38"><tr><th  style="text-align: left" class="moduleLabel">POLICY LIMIT – AMOUNT</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:in1.39"><tr><th  style="text-align: left" class="moduleLabel">POLICY LIMIT – DAYS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:in1.40"><tr><th  style="text-align: left" class="moduleLabel">ROOM RATE - SEMI PRIVATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:in1.41"><tr><th  style="text-align: left" class="moduleLabel">ROOM RATE – PRIVATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:in1.42"><tr><th  style="text-align: left" class="moduleLabel">INSURED'S EMPLOYMENT STATUS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:in1.43"><tr><th  style="text-align: left" class="moduleLabel">INSURED'S SEX</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:in1.44"><tr><th  style="text-align: left" class="moduleLabel">INSURED'S EMPLOYER ADDRESS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>

	<!-- MFA – Master File Acknowledgement -->
	<xsl:template match="esr:mfa">
		<tr><td colspan="2" class="segmentheader">MFA - Master File Acknowledgement</td></tr>					
		<!-- print the attributes -->
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="esr:mfa.1"><tr><th  style="text-align: left" class="moduleLabel">RECORD-LEVEL EVENT CODE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:mfa.2"><tr><th  style="text-align: left" class="moduleLabel">MFN CONTROL ID</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:mfa.3"><tr><th  style="text-align: left" class="moduleLabel">EVENT COMPLETION DATE/TIME</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:mfa.4"><tr><th  style="text-align: left" class="moduleLabel">EVENT RETURN CODE AND/OR TEXT</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:mfa.5"><tr><th  style="text-align: left" class="moduleLabel">PRIMARY KEY VALUE-MFA</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:mfa.6"><tr><th  style="text-align: left" class="moduleLabel">PRIMARY KEY VALUE TYPE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>

	<!-- MFE – Master File Entry -->
	<xsl:template match="esr:mfe">
		<tr><td colspan="2" class="segmentheader">MFE - Master File Entry</td></tr>					
		<!-- print the attributes -->
		<xsl:apply-templates/>
	</xsl:template>	

	<xsl:template match="esr:mfe.1"><tr><th  style="text-align: left" class="moduleLabel">RECORD-LEVEL EVENT CODE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:mfe.2"><tr><th  style="text-align: left" class="moduleLabel">MFN CONTROL ID</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:mfe.3"><tr><th  style="text-align: left" class="moduleLabel">EFFECTIVE DATE/TIME</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:mfe.4"><tr><th  style="text-align: left" class="moduleLabel">PRIMARY KEY VALUE – MFE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:mfe.5"><tr><th  style="text-align: left" class="moduleLabel">PRIMARY KEY VALUE TYPE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>

	<!-- MFI – Master File Identification -->
	<xsl:template match="esr:mfi">
		<tr><td colspan="2" class="segmentheader">MFI - Master File Identification</td></tr>					
		<!-- print the attributes -->
		<xsl:apply-templates/>
	</xsl:template>		
	<xsl:template match="esr:mfi.1"><tr><th  style="text-align: left" class="moduleLabel">MASTER FILE IDENTIFIER</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:mfi.2"><tr><th  style="text-align: left" class="moduleLabel">MASTER FILE APPLICATION IDENTIFIER</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:mfi.3"><tr><th  style="text-align: left" class="moduleLabel">FILE-LEVEL EVENT CODE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:mfi.4"><tr><th  style="text-align: left" class="moduleLabel">ENTERED DATE TIME</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:mfi.5"><tr><th  style="text-align: left" class="moduleLabel">EFFECTIVE DATE TIME</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:mfi.6"><tr><th  style="text-align: left" class="moduleLabel">RESPONSE LEVEL CODE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>

	<!-- MSA – Message Acknowledgement -->
	<xsl:template match="esr:msa">
		<tr><td colspan="2" class="segmentheader">MSA - Message Acknowledgement</td></tr>					
		<!-- print the attributes -->
		<xsl:apply-templates/>
	</xsl:template>		

	<xsl:template match="esr:msa.1"><tr><th  style="text-align: left" class="moduleLabel">ACKNOWLEDGMENT CODE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:msa.2"><tr><th  style="text-align: left" class="moduleLabel">MESSAGE CONTROL ID</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:msa.3"><tr><th  style="text-align: left" class="moduleLabel">TEXT MESSAGE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:msa.4"><tr><th  style="text-align: left" class="moduleLabel">EXPECTED SEQUENCE NUMBER</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:msa.5"><tr><th  style="text-align: left" class="moduleLabel">DELAYED ACKNOWLEDGMENT TYPE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:msa.6"><tr><th  style="text-align: left" class="moduleLabel">ERROR CONDITION</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
		
	<!-- MSH Message Header Segment -->
	<xsl:template match="esr:msh">
		<tr><td colspan="2" class="segmentheader">MSH - Message Header</td></tr>					
		<!-- print the attributes -->
		<xsl:apply-templates/>
	</xsl:template>	
	<xsl:template match="esr:msh.3"><tr><th  style="text-align: left" class="moduleLabel">SENDING APPLICATION</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>		
	<xsl:template match="esr:msh.4"><tr><th  style="text-align: left" class="moduleLabel">SENDING FACILITY</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>		
	<xsl:template match="esr:msh.5"><tr><th  style="text-align: left" class="moduleLabel">RECEIVING APPLICATION</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:msh.6"><tr><th  style="text-align: left" class="moduleLabel">RECEIVING FACILITY</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:msh.7"><tr><th  style="text-align: left" class="moduleLabel">DATE/TIME OF MESSAGE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:msh.8"><tr><th  style="text-align: left" class="moduleLabel">SECURITY</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:msh.9"><tr><th  style="text-align: left" class="moduleLabel">MESSAGE TYPE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:msh.10"><tr><th  style="text-align: left" class="moduleLabel">MESSAGE CONTROL ID</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:msh.11"><tr><th  style="text-align: left" class="moduleLabel">PROCESSING ID</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:msh.12"><tr><th  style="text-align: left" class="moduleLabel">VERSION ID</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:msh.13"><tr><th  style="text-align: left" class="moduleLabel">SEQUENCE NUMBER</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:msh.14"><tr><th  style="text-align: left" class="moduleLabel">CONTINUATION POINTER</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:msh.15"><tr><th  style="text-align: left" class="moduleLabel">ACCEPT ACKNOWLEDGMENT TYPE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:msh.16"><tr><th  style="text-align: left" class="moduleLabel">APPLICATION ACKNOWLEDGMENT TYPE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:msh.17"><tr><th  style="text-align: left" class="moduleLabel">COUNTRY CODE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:msh.18"><tr><th  style="text-align: left" class="moduleLabel">CHARACTER SET</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:msh.19"><tr><th  style="text-align: left" class="moduleLabel">PRINCIPAL LANGUAGE OF MESSAGE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:msh.20"><tr><th  style="text-align: left" class="moduleLabel">ALTERNATE CHARACTER SET HANDLING SCHEME</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>			      
		
	<!-- NTE Notes and Comments Segment-->
	<xsl:template match="esr:nte">
		<tr><td colspan="2" class="segmentheader">NTE - Notes and Comments</td></tr>					
		<!-- print the attributes -->
		<xsl:apply-templates/>	      
	</xsl:template>	
	<xsl:template match="esr:nte.1"><tr><th  style="text-align: left" class="moduleLabel">SET ID - NTE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:nte.2"><tr><th  style="text-align: left" class="moduleLabel">SOURCE OF COMMENT</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:nte.3"><tr><th  style="text-align: left" class="moduleLabel">COMMENT</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:nte.4"><tr><th  style="text-align: left" class="moduleLabel">COMMENT TYPE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
			
	<!-- OBX Observation Result Segment-->
	<xsl:template match="esr:obx">
		<tr><td colspan="2" class="segmentheader">OBX - Observation And Result Segment</td></tr>
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="esr:obx.1"><tr><th  style="text-align: left" class="moduleLabel">SET ID  OBX</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:obx.2"><tr><th  style="text-align: left" class="moduleLabel">VALUE TYPE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:obx.3"><tr><th  style="text-align: left" class="moduleLabel">OBSERVATION IDENTIFIER</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:obx.4"><tr><th  style="text-align: left" class="moduleLabel">OBSERVATION SUB ID</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:obx.5"><tr><th  style="text-align: left" class="moduleLabel">OBSERVATION VALUE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:obx.6"><tr><th  style="text-align: left" class="moduleLabel">UNITS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:obx.7"><tr><th  style="text-align: left" class="moduleLabel">REFERENCE RANGES</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:obx.8"><tr><th  style="text-align: left" class="moduleLabel">ABNORMAL FLAGS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:obx.9"><tr><th  style="text-align: left" class="moduleLabel">PROBABILITY</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:obx.10"><tr><th  style="text-align: left" class="moduleLabel">NATURE OF ABNORMAL TEST</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:obx.11"><tr><th  style="text-align: left" class="moduleLabel">OBSERVATION RESULT STATUS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:obx.12"><tr><th  style="text-align: left" class="moduleLabel">DATE LAST OBSERVATION NORMAL VALUES</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:obx.13"><tr><th  style="text-align: left" class="moduleLabel">USER DEFINED ACCESS CHECKS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:obx.14"><tr><th  style="text-align: left" class="moduleLabel">DATE AND TIME OF OBSERVATION</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:obx.15"><tr><th  style="text-align: left" class="moduleLabel">PRODUCER ID</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:obx.16"><tr><th  style="text-align: left" class="moduleLabel">RESPONSIBLE OBSERVER</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:obx.17"><tr><th  style="text-align: left" class="moduleLabel">OBSERVATION METHOD</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	
	<!-- qrd Query Definition Segment -->
	<xsl:template match="esr:qrd">
		<tr><td colspan="2" class="segmentheader">QRD - Query Definition</td></tr>					
		<!-- print the attributes -->
		<xsl:apply-templates/>	      
	</xsl:template>
	
	<xsl:template match="esr:qrd.1"><tr><th  style="text-align: left" class="moduleLabel">QUERY DATE TIME</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:qrd.2"><tr><th  style="text-align: left" class="moduleLabel">QUERY FORMAT CODE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:qrd.3"><tr><th  style="text-align: left" class="moduleLabel">QUERY PRIORITY</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:qrd.4"><tr><th  style="text-align: left" class="moduleLabel">QUERY ID</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:qrd.5"><tr><th  style="text-align: left" class="moduleLabel">DEFERRED RESPONSE TYPE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:qrd.6"><tr><th  style="text-align: left" class="moduleLabel">DEFERRED RESPONSE DATE TIME</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:qrd.7"><tr><th  style="text-align: left" class="moduleLabel">QUANTITY LIMITED REQUEST</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:qrd.8"><tr><th  style="text-align: left" class="moduleLabel">WHO SUBJECT FILTER</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:qrd.9"><tr><th  style="text-align: left" class="moduleLabel">WHAT SUBJECT FILTER</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:qrd.10"><tr><th  style="text-align: left" class="moduleLabel">WHAT DEPARTMENT DATA CODE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:qrd.11"><tr><th  style="text-align: left" class="moduleLabel">WHAT DATA CODE VALUE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:qrd.12"><tr><th  style="text-align: left" class="moduleLabel">QUERY RESULTS LEVEL</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>

<!-- qrd Query Filter Segment -->
	<xsl:template match="esr:qrf">
		<tr><td colspan="2" class="segmentheader">QRF - Query Filter</td></tr>			
		<!-- print the attributes -->
		<xsl:apply-templates/>		      
	</xsl:template>		
		
	<xsl:template match="esr:qrf.1"><tr><th  style="text-align: left" class="moduleLabel">WHERE SUBJECT FILTER</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:qrf.2"><tr><th  style="text-align: left" class="moduleLabel">WHEN DATA START DATE TIME</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:qrf.3"><tr><th  style="text-align: left" class="moduleLabel">WHEN DATA END DATE TIME</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:qrf.4"><tr><th  style="text-align: left" class="moduleLabel">WHAT USER QUALIFIER</th><td class="moduleValue">
		<xsl:apply-templates select="esr:pn.1"/> <xsl:text>,  </xsl:text>  
		<xsl:apply-templates select="esr:pn.2"/>
			<xsl:if test="esr:pn3"> 
				<xsl:text>,  </xsl:text>  
				<xsl:apply-templates select="esr:pn.3"/>
			</xsl:if>	
	</td></tr></xsl:template>
	<xsl:template match="esr:qrf.5"><tr><th  style="text-align: left" class="moduleLabel">OTHER QUERY SUBJECT FILTER</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
				
<!-- msa Message Acknowledgement Segment -->
	<xsl:template match="esr:msa">
		<tr><td colspan="2" class="segmentheader">MSA - Message Acknowledgement</td></tr>			
		<!-- print the attributes -->
		<xsl:apply-templates/>		      
	</xsl:template>		
		
	<xsl:template match="esr:msa.1"><tr><th  style="text-align: left" class="moduleLabel">ACKNOWLEDGMENT CODE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:msa.2"><tr><th  style="text-align: left" class="moduleLabel">MESSAGE CONTROL ID</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:msa.3"><tr><th  style="text-align: left" class="moduleLabel">TEXT MESSAGE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:msa.4"><tr><th  style="text-align: left" class="moduleLabel">EXPECTED SEQUENCE NUMBER</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:msa.5"><tr><th  style="text-align: left" class="moduleLabel">DELAYED ACKNOWLEDGMENT TYPE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:msa.6"><tr><th  style="text-align: left" class="moduleLabel">ERROR CONDITION</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>

<!-- pd1 Patient Demographic  Segment -->
	<xsl:template match="esr:pd1">
		<tr><td colspan="2" class="segmentheader">PD1 - Patient Demographic</td></tr>			
		<!-- print the attributes -->
		<xsl:apply-templates/>		      
	</xsl:template>						
	<xsl:template match="esr:pd1.1"><tr><th  style="text-align: left" class="moduleLabel">SET ID</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:pd1.2"><tr><th  style="text-align: left" class="moduleLabel">LIVING ARRANGEMENT</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:pd1.3"><tr><th  style="text-align: left" class="moduleLabel">CIRN (Master of Record)</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:pd1.4"><tr><th  style="text-align: left" class="moduleLabel">PATIENT PRIMARY CARE PROVIDER NAME and ID No</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>

<!-- msa Message Acknowledgement Segment -->
	<xsl:template match="esr:pid">
		<tr><td colspan="2" class="segmentheader">PID - Patient Identification</td></tr>			
		<!-- print the attributes -->
		<xsl:apply-templates/>		      
	</xsl:template>	
	<xsl:template match="esr:pid.2"><tr><th  style="text-align: left" class="moduleLabel">PRIMARY LONG ID</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>					
	<xsl:template match="esr:pid.1"><tr><th  style="text-align: left" class="moduleLabel">SET ID (PATIENT ID)</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:pid.2"><tr><th  style="text-align: left" class="moduleLabel">PRIMARY LONG ID</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:pid.3"><tr><th  style="text-align: left" class="moduleLabel">PATIENT ID (INTERNAL ID)</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:pid.4"><tr><th  style="text-align: left" class="moduleLabel">ALTERNATE PATIENT ID</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:pid.5"><tr><th  style="text-align: left" class="moduleLabel">PATIENT NAME</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:pid.6"><tr><th  style="text-align: left" class="moduleLabel">MOTHER'S MAIDEN NAME</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:pid.7"><tr><th  style="text-align: left" class="moduleLabel">DATE TIME OF BIRTH</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:pid.8"><tr><th  style="text-align: left" class="moduleLabel">SEX</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:pid.9"><tr><th  style="text-align: left" class="moduleLabel">PATIENT ALIAS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:pid.10"><tr><th  style="text-align: left" class="moduleLabel">RACE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:pid.11"><tr><th  style="text-align: left" class="moduleLabel">PATIENT ADDRESS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:pid.12"><tr><th  style="text-align: left" class="moduleLabel">COUNTY CODE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:pid.13"><tr><th  style="text-align: left" class="moduleLabel">PHONE NUMBER (HOME)</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:pid.14"><tr><th  style="text-align: left" class="moduleLabel">PHONE NUMBER (BUSINESS)</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:pid.15"><tr><th  style="text-align: left" class="moduleLabel">PRIMARY LANGUAGE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:pid.16"><tr><th  style="text-align: left" class="moduleLabel">MARITAL STATUS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:pid.17"><tr><th  style="text-align: left" class="moduleLabel">RELIGION</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:pid.18"><tr><th  style="text-align: left" class="moduleLabel">PATIENT ACCOUNT NUMBER</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:pid.19"><tr><th  style="text-align: left" class="moduleLabel">SSN NUMBER (PATIENT)</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:pid.22"><tr><th  style="text-align: left" class="moduleLabel">ETHNICITY</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:pid.24"><tr><th  style="text-align: left" class="moduleLabel">MULTIPLE BIRTH INDICATOR </th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	
	<!-- RF1 Referral Information Segment-->
	<xsl:template match="esr:rf1">
		<tr><td colspan="2" class="segmentheader">RF1 - Referral Information Segment</td></tr>
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="esr:rf1.1"><tr><th  style="text-align: left" class="moduleLabel">REFERRAL STATUS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:rf1.2"><tr><th  style="text-align: left" class="moduleLabel">REFERRAL PRIORITY</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:rf1.3"><tr><th  style="text-align: left" class="moduleLabel">REFERRAL TYPE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:rf1.4"><tr><th  style="text-align: left" class="moduleLabel">REFERRAL DISPOSITION</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:rf1.5"><tr><th  style="text-align: left" class="moduleLabel">REFERRAL CATEGORY</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:rf1.6"><tr><th  style="text-align: left" class="moduleLabel">ORIGINATING REFERRAL IDENTIFIER</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:rf1.7"><tr><th  style="text-align: left" class="moduleLabel">EFFECTIVE DATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:rf1.8"><tr><th  style="text-align: left" class="moduleLabel">EXPIRATION DATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:rf1.9"><tr><th  style="text-align: left" class="moduleLabel">PROCESS DATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:rf1.10"><tr><th  style="text-align: left" class="moduleLabel">REFERRAL REASON</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:rf1.11"><tr><th  style="text-align: left" class="moduleLabel">EXTERNAL REFERRAL IDENTIFIER</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>

	<!-- ZBT VA Specific Beneficiary Travel Segment-->
	<xsl:template match="esr:zbt">
		<tr><td colspan="2" class="segmentheader">ZBT - VA Specific Beneficiary Travel Segment</td></tr>
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="esr:zbt.1"><tr><th  style="text-align: left" class="moduleLabel">SET ID</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zbt.2"><tr><th  style="text-align: left" class="moduleLabel">DATE CERTIFIED</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zbt.3"><tr><th  style="text-align: left" class="moduleLabel">ELIGIBLE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zbt.4"><tr><th  style="text-align: left" class="moduleLabel">AMOUNT CERTIFIED</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zbt.5"><tr><th  style="text-align: left" class="moduleLabel">MEANS TEST STATUS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zbt.6"><tr><th  style="text-align: left" class="moduleLabel">PRIMARY ELIGIBILITY CODE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zbt.7"><tr><th  style="text-align: left" class="moduleLabel">TRAVEL CLAIM DATE And TIME</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>

	<!-- ZCD VA Specific Catastrophic Disability Segment-->
	<xsl:template match="esr:zcd">
		<tr><td colspan="2" class="segmentheader">ZCD - VA Specific Catastrophic Disability Segment</td></tr>
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="esr:zcd.1"><tr><th  style="text-align: left" class="moduleLabel">SET ID</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zcd.2"><tr><th  style="text-align: left" class="moduleLabel">REVIEW DATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zcd.3"><tr><th  style="text-align: left" class="moduleLabel">DECIDED BY</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zcd.4"><tr><th  style="text-align: left" class="moduleLabel">FACILITY MAKING DETERMINATION</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zcd.5"><tr><th  style="text-align: left" class="moduleLabel">DATE OF DECISION</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zcd.6"><tr><th  style="text-align: left" class="moduleLabel">DETERMINATION METHOD</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zcd.7"><tr><th  style="text-align: left" class="moduleLabel">CD DIAGNOSIS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zcd.8"><tr><th  style="text-align: left" class="moduleLabel">CD PROCEDURE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zcd.9"><tr><th  style="text-align: left" class="moduleLabel">AFFECTED EXTREMITY</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zcd.10"><tr><th  style="text-align: left" class="moduleLabel">CD CONDITION</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zcd.11"><tr><th  style="text-align: left" class="moduleLabel">SCORE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zcd.12"><tr><th  style="text-align: left" class="moduleLabel">CATASTROPHICALLY DISABLED</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zcd.13"><tr><th  style="text-align: left" class="moduleLabel">PERMANENT INDICATOR</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zcd.14"><tr><th  style="text-align: left" class="moduleLabel">DATE VETERAN REQUESTED CD EVALUATION</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zcd.15"><tr><th  style="text-align: left" class="moduleLabel">DATE FACILITY INITIATED REVIEW</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zcd.16"><tr><th  style="text-align: left" class="moduleLabel">DATE VETERAN WAS NOTIFIED</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>

	<!-- ZCT VA Specific Emergency Contact Segment-->
	<xsl:template match="esr:zct">
		<tr><td colspan="2" class="segmentheader">ZCT - VA Specific Emergency Contact Segment</td></tr>
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="esr:zct.1"><tr><th  style="text-align: left" class="moduleLabel">SET ID</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zct.2"><tr><th  style="text-align: left" class="moduleLabel">CONTACT TYPE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zct.3"><tr><th  style="text-align: left" class="moduleLabel">CONTACT NAME</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zct.4"><tr><th  style="text-align: left" class="moduleLabel">CONTACT RELATIONSHIP</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zct.5"><tr><th  style="text-align: left" class="moduleLabel">CONTACT ADDRESS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zct.6"><tr><th  style="text-align: left" class="moduleLabel">CONTACT PHONE NUMBER</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zct.7"><tr><th  style="text-align: left" class="moduleLabel">CONTACT WORK PHONE NUMBER</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zct.8"><tr><th  style="text-align: left" class="moduleLabel">CONTACT ADDRESS SAME AS NOK?</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zct.9"><tr><th  style="text-align: left" class="moduleLabel">CONTACT PERSON SAME AS NOK?</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zct.10"><tr><th  style="text-align: left" class="moduleLabel">CONTACT DATE TIME LAST UPDATED</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>

	<!-- ZDP VA Specific Dependent Information Segment-->
	<xsl:template match="esr:zdp">
		<tr><td colspan="2" class="segmentheader">ZDP - VA Specific Dependent Information Segment</td></tr>
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="esr:zdp.1"><tr><th  style="text-align: left" class="moduleLabel">SET ID</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zdp.2"><tr><th  style="text-align: left" class="moduleLabel">NAME</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zdp.3"><tr><th  style="text-align: left" class="moduleLabel">SEX</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zdp.4"><tr><th  style="text-align: left" class="moduleLabel">DATE OF BIRTH</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zdp.5"><tr><th  style="text-align: left" class="moduleLabel">SOCIAL SECURITY NUMBER</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zdp.6"><tr><th  style="text-align: left" class="moduleLabel">RELATIONSHIP TO PATIENT</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zdp.7"><tr><th  style="text-align: left" class="moduleLabel">INTERNAL ENTRY NUMBER</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zdp.8"><tr><th  style="text-align: left" class="moduleLabel">SPOUSES MAIDEN NAME</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zdp.9"><tr><th  style="text-align: left" class="moduleLabel">DEPENDENT DATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zdp.10"><tr><th  style="text-align: left" class="moduleLabel">PSEUDO SSN Reason (spouse or dependent)</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zdp.11"><tr><th  style="text-align: left" class="moduleLabel">INACTIVATION DATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zdp.12"><tr><th  style="text-align: left" class="moduleLabel">SSN VERIFICATION STATUS(Spouse Dependent)</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zdp.13"><tr><th  style="text-align: left" class="moduleLabel">SPOUSE ADDRESS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zdp.14"><tr><th  style="text-align: left" class="moduleLabel">SPOUSE HOME PHONE NUMBER</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>

	<!-- ZEG VA Specific Enrollment Group Threshold Segment-->
	<xsl:template match="esr:zeg">
		<tr><td colspan="2" class="segmentheader">ZEG - VA Specific Enrollment Group Threshold Segment</td></tr>
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="esr:zeg.1"><tr><th  style="text-align: left" class="moduleLabel">EGT PRIORITY VALUE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zeg.2"><tr><th  style="text-align: left" class="moduleLabel">EFFECTIVE DATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zeg.3"><tr><th  style="text-align: left" class="moduleLabel">EGT TYPE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zeg.4"><tr><th  style="text-align: left" class="moduleLabel">REMARKS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zeg.5"><tr><th  style="text-align: left" class="moduleLabel">DATE AND TIME EGT CHANGED</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zeg.6"><tr><th  style="text-align: left" class="moduleLabel">FEDERAL REGISTER DATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zeg.7"><tr><th  style="text-align: left" class="moduleLabel">ENROLLMENT GROUP SUBGROUP</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>

	<!-- ZEL VA Specific Patient Eligibility Segment-->
	<xsl:template match="esr:zel">
		<tr><td colspan="2" class="segmentheader">ZEL - VA Specific Patient Eligibility Segment</td></tr>
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="esr:zel.1"><tr><th  style="text-align: left" class="moduleLabel">SET ID</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zel.2"><tr><th  style="text-align: left" class="moduleLabel">ELIGIBILITY CODE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zel.3"><tr><th  style="text-align: left" class="moduleLabel">LONG ID</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zel.4"><tr><th  style="text-align: left" class="moduleLabel">SHORT ID</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zel.5"><tr><th  style="text-align: left" class="moduleLabel">DISABILITY RETIREMENT FROM MIL</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zel.6"><tr><th  style="text-align: left" class="moduleLabel">CLAIM FOLDER NUMBER</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zel.7"><tr><th  style="text-align: left" class="moduleLabel">CLAIM FOLDER LOCATION</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zel.8"><tr><th  style="text-align: left" class="moduleLabel">VETERAN?</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zel.9"><tr><th  style="text-align: left" class="moduleLabel">TYPE OF PATIENT</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zel.10"><tr><th  style="text-align: left" class="moduleLabel">ELIGIBLITY STATUS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zel.11"><tr><th  style="text-align: left" class="moduleLabel">ELIGIBILITY STATUS DATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zel.12"><tr><th  style="text-align: left" class="moduleLabel">ELIGIBLILITY INTERIM RESPONSE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zel.13"><tr><th  style="text-align: left" class="moduleLabel">ELIGIBILITY VERIFICATION METHOD</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zel.14"><tr><th  style="text-align: left" class="moduleLabel">RECEIVING A and A BENEFITS?</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zel.15"><tr><th  style="text-align: left" class="moduleLabel">RECEIVING HOUSEBOUND BENEFITS?</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zel.16"><tr><th  style="text-align: left" class="moduleLabel">RECEIVING A VA PENSION?</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zel.17"><tr><th  style="text-align: left" class="moduleLabel">RECEIVING A VA DISABILITY?</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zel.18"><tr><th  style="text-align: left" class="moduleLabel">EXPOSED TO AGENT ORANGE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zel.19"><tr><th  style="text-align: left" class="moduleLabel">RADIATION EXPOSURE INDICATED</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zel.20"><tr><th  style="text-align: left" class="moduleLabel">SW ASIA CONDITIONS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zel.21"><tr><th  style="text-align: left" class="moduleLabel">TOTAL ANNUAL VA CHECK AMOUNT</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zel.22"><tr><th  style="text-align: left" class="moduleLabel">RADIATION EXPOSURE METHOD</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zel.23"><tr><th  style="text-align: left" class="moduleLabel">MST STATUS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zel.24"><tr><th  style="text-align: left" class="moduleLabel">MST STATUS CHANGE DATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zel.25"><tr><th  style="text-align: left" class="moduleLabel">SITE DETERMINING MST STATUS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zel.26"><tr><th  style="text-align: left" class="moduleLabel">AGENT ORANGE REGISTRATION DATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zel.27"><tr><th  style="text-align: left" class="moduleLabel">AGENT ORANGE EXAM DATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zel.28"><tr><th  style="text-align: left" class="moduleLabel">AGENT ORANGE REGISTRATION NUMBER</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zel.29"><tr><th  style="text-align: left" class="moduleLabel">AGENT ORANGE EXPOSURE LOCATION</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zel.30"><tr><th  style="text-align: left" class="moduleLabel">RADIATION REGISTRATION DATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zel.31"><tr><th  style="text-align: left" class="moduleLabel">ENVIRONMENTAL CONTAMINANTS EXAM DATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zel.32"><tr><th  style="text-align: left" class="moduleLabel">ENVIRONMENTAL CONTAMINANTS REGISTRATION DATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zel.33"><tr><th  style="text-align: left" class="moduleLabel">MONETARY BENEFITS DATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zel.34"><tr><th  style="text-align: left" class="moduleLabel">USER ENROLLEE VALID THROUGH</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zel.35"><tr><th  style="text-align: left" class="moduleLabel">USER ENROLLEE SITE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zel.36"><tr><th  style="text-align: left" class="moduleLabel">ELIGIBILITY VERIFCATION SOURCE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zel.37"><tr><th  style="text-align: left" class="moduleLabel">Combat Veteran Eligibility Indicator</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zel.38"><tr><th  style="text-align: left" class="moduleLabel">Combat Veteran Eligibility End Date</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zel.39"><tr><th  style="text-align: left" class="moduleLabel">Discharge Due to Disability</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zel.40"><tr><th  style="text-align: left" class="moduleLabel">PROJ 112 SHAD INDICATOR</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zel.41"><tr><th  style="text-align: left" class="moduleLabel">CAMP LEJEUNE ELIGIBILITY INDICATOR</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zel.42"><tr><th  style="text-align: left" class="moduleLabel">CAMP LEJEUNE DATE REGISTERED</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zel.43"><tr><th  style="text-align: left" class="moduleLabel">CAMP LEJEUNE ELIGIBILITY CHANGE SITE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zel.44"><tr><th  style="text-align: left" class="moduleLabel">CAMP LEJEUNE ELIGIBILITY CHANGE SOURCE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	
	
	<!-- ZE2 VA Specific Pention Data Segment-->
	<xsl:template match="esr:ze2">
		<tr><td colspan="2" class="segmentheader">ZE2 - VA Specific Rated Disabilities Segment</td></tr>
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="esr:ze2.1"><tr><th  style="text-align: left" class="moduleLabel">PENSION DATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:ze2.2"><tr><th  style="text-align: left" class="moduleLabel">PENSION AWARD REASON CODE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>	
	<xsl:template match="esr:ze2.3"><tr><th  style="text-align: left" class="moduleLabel">PENSION TERMINATED REASON</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>	

	<!-- ZEM VA Specific Employment Info Segment-->
	<xsl:template match="esr:zem">
		<tr><td colspan="2" class="segmentheader">ZEM - VA Specific Employment Info Segment</td></tr>
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="esr:zem.1"><tr><th  style="text-align: left" class="moduleLabel">SET ID</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zem.2"><tr><th  style="text-align: left" class="moduleLabel">EMPLOYMENT PERSON</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zem.3"><tr><th  style="text-align: left" class="moduleLabel">EMPLOYMENT STATUS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zem.4"><tr><th  style="text-align: left" class="moduleLabel">EMPLOYER NAME</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zem.5"><tr><th  style="text-align: left" class="moduleLabel">OCCUPATION</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zem.6"><tr><th  style="text-align: left" class="moduleLabel">EMPLOYER ADDRESS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zem.7"><tr><th  style="text-align: left" class="moduleLabel">EMPLOYER PHONE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zem.8"><tr><th  style="text-align: left" class="moduleLabel">GOVERNMENT AGENCY</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zem.9"><tr><th  style="text-align: left" class="moduleLabel">DATE OF RETIREMENT</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	
	<!-- ZEN VA Specific Enrollment Segment-->
	<xsl:template match="esr:zen">
		<tr><td colspan="2" class="segmentheader">ZEN - VA Specific Enrollment Segment</td></tr>
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="esr:zen.1"><tr><th  style="text-align: left" class="moduleLabel">SET ID</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zen.2"><tr><th  style="text-align: left" class="moduleLabel">ENROLLMENT DATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zen.3"><tr><th  style="text-align: left" class="moduleLabel">SOURCE OF ENROLLMENT</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zen.4"><tr><th  style="text-align: left" class="moduleLabel">ENROLLMENT STATUS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zen.5"><tr><th  style="text-align: left" class="moduleLabel">REASON CANCELED/DECLINED</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zen.6"><tr><th  style="text-align: left" class="moduleLabel">CANCELED or DECLINED REMARKS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zen.7"><tr><th  style="text-align: left" class="moduleLabel">FACILITY RECEIVED</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zen.8"><tr><th  style="text-align: left" class="moduleLabel">PREFERRED FACILITY</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zen.9"><tr><th  style="text-align: left" class="moduleLabel">ENROLLMENT PRIORITY</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zen.10"><tr><th  style="text-align: left" class="moduleLabel">EFFECTIVE DATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zen.11"><tr><th  style="text-align: left" class="moduleLabel">ENROLLMENT APPLICATION DATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zen.12"><tr><th  style="text-align: left" class="moduleLabel">ENROLLMENT END DATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zen.13"><tr><th  style="text-align: left" class="moduleLabel">ENROLLMENT SUB GROUP</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zen.14"><tr><th  style="text-align: left" class="moduleLabel">SOURCE DESIGNATION</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zen.15"><tr><th  style="text-align: left" class="moduleLabel">REASON FOR CLOSED APPLICATION</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	
	<!-- ZFE VA Specific Fee Basis Segment-->
	<xsl:template match="esr:zfe">
		<tr><td colspan="2" class="segmentheader">ZFE - VA Specific Fee Basis Segment</td></tr>
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="esr:zfe.1"><tr><th  style="text-align: left" class="moduleLabel">SET ID</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zfe.2"><tr><th  style="text-align: left" class="moduleLabel">TREATMENT CODE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zfe.3"><tr><th  style="text-align: left" class="moduleLabel">FEE BASIS PROGRAM</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zfe.4"><tr><th  style="text-align: left" class="moduleLabel">AUTHORIZATION FROM DATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zfe.5"><tr><th  style="text-align: left" class="moduleLabel">AUTHORIZATION TO DATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>

	<!-- ZGD VA Specific Guardian Segment-->
	<xsl:template match="esr:zgd">
		<tr><td colspan="2" class="segmentheader">ZGD - VA Specific Guardian Segment</td></tr>
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="esr:zgd.1"><tr><th  style="text-align: left" class="moduleLabel">SET ID</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zgd.2"><tr><th  style="text-align: left" class="moduleLabel">GUARDIAN TYPE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zgd.3"><tr><th  style="text-align: left" class="moduleLabel">GUARDIAN NAME</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zgd.4"><tr><th  style="text-align: left" class="moduleLabel">GUARDIAN INSTITUTION</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zgd.5"><tr><th  style="text-align: left" class="moduleLabel">GUARDIAN RELATIONSHIP</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zgd.6"><tr><th  style="text-align: left" class="moduleLabel">GUARDIAN ADDRESS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zgd.7"><tr><th  style="text-align: left" class="moduleLabel">GUARDIAN PHONE NUMBER</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zgd.8"><tr><th  style="text-align: left" class="moduleLabel">DATE RULED INCOMPETENT</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>

	<!-- ZIC VA Specific Income Segment-->
	<xsl:template match="esr:zic">
		<tr><td colspan="2" class="segmentheader">ZIC - VA Specific Income Segment</td></tr>
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="esr:zic.1"><tr><th  style="text-align: left" class="moduleLabel">SET ID</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zic.2"><tr><th  style="text-align: left" class="moduleLabel">INCOME YEAR</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zic.3"><tr><th  style="text-align: left" class="moduleLabel">SOCIAL SECURITY</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zic.4"><tr><th  style="text-align: left" class="moduleLabel">US CIVIL SERVICE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zic.5"><tr><th  style="text-align: left" class="moduleLabel">US RAILROAD RETIREMENT</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zic.6"><tr><th  style="text-align: left" class="moduleLabel">MILITARY RETIREMENT</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zic.7"><tr><th  style="text-align: left" class="moduleLabel">UNEMPLOYMENT COMPENSATION</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zic.8"><tr><th  style="text-align: left" class="moduleLabel">OTHER RETIREMENT</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zic.9"><tr><th  style="text-align: left" class="moduleLabel">EMPLOYMENT INCOME</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zic.10"><tr><th  style="text-align: left" class="moduleLabel">INTEREST, DIVIDEND, ANNUITY</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zic.11"><tr><th  style="text-align: left" class="moduleLabel">WORKERS COMP or BLACK LUNG</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zic.12"><tr><th  style="text-align: left" class="moduleLabel">OTHER INCOME</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zic.13"><tr><th  style="text-align: left" class="moduleLabel">MEDICAL EXPENSES</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zic.14"><tr><th  style="text-align: left" class="moduleLabel">FUNERAL AND BURIAL EXPENSES</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zic.15"><tr><th  style="text-align: left" class="moduleLabel">EDUCATIONAL EXPENSES</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zic.16"><tr><th  style="text-align: left" class="moduleLabel">CASH, AMOUNT IN BANK ACCOUNTS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zic.17"><tr><th  style="text-align: left" class="moduleLabel">STOCKS AND BONDS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zic.18"><tr><th  style="text-align: left" class="moduleLabel">REAL PROPERTY</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zic.19"><tr><th  style="text-align: left" class="moduleLabel">OTHER PROPERTY OR ASSETS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zic.20"><tr><th  style="text-align: left" class="moduleLabel">DEBTS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zic.21"><tr><th  style="text-align: left" class="moduleLabel">DATE INCOME SCREENING COLLECTED</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zic.22"><tr><th  style="text-align: left" class="moduleLabel">SITE CONDUCTING TEST</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zic.23"><tr><th  style="text-align: left" class="moduleLabel">SOURCE OF TEST</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>

	<!-- ZIE VA Specific Patient Ineligible Segment-->
	<xsl:template match="esr:zie">
		<tr><td colspan="2" class="segmentheader">ZIE - VA Specific Patient Ineligible Segment</td></tr>
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="esr:zie.1"><tr><th  style="text-align: left" class="moduleLabel">SET ID</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zie.2"><tr><th  style="text-align: left" class="moduleLabel">INELIGIBLE DATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zie.3"><tr><th  style="text-align: left" class="moduleLabel">INELIGIBLE REASON</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zie.4"><tr><th  style="text-align: left" class="moduleLabel">INELIGIBLE VARO DECISION</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zie.5"><tr><th  style="text-align: left" class="moduleLabel">INELIGIBLE TWX CITY</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zie.6"><tr><th  style="text-align: left" class="moduleLabel">INELIGIBLE TWX SOURCE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zie.7"><tr><th  style="text-align: left" class="moduleLabel">INELIGIBLE TWX STATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>

	<!-- ZIO VA Specific Patient Info Segment-->
	<xsl:template match="esr:zio">
		<tr><td colspan="2" class="segmentheader">ZIO - VA Specific Patient Info Segment</td></tr>
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="esr:zio.1"><tr><th  style="text-align: left" class="moduleLabel">SET ID</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zio.2"><tr><th  style="text-align: left" class="moduleLabel">NUMBER OF INPATIENT DAYS SINCE LAST MEANS TEST</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zio.3"><tr><th  style="text-align: left" class="moduleLabel">NUMBER OF OUTPATIENT DAYS SINCE LAST MEANS TEST</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zio.4"><tr><th  style="text-align: left" class="moduleLabel">DATE OF LAST VISIT</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zio.5"><tr><th  style="text-align: left" class="moduleLabel">APPOINTMENT REQUEST ON 1010EZ.</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zio.6"><tr><th  style="text-align: left" class="moduleLabel">APPOINTMENT REQUEST DATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>

	<!-- ZIR VA Specific Income Relation Segment-->
	<xsl:template match="esr:zir">
		<tr><td colspan="2" class="segmentheader">ZIR - VA Specific Income Relation Segment</td></tr>
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="esr:zir.1"><tr><th  style="text-align: left" class="moduleLabel">SET ID</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zir.2"><tr><th  style="text-align: left" class="moduleLabel">MARRIED LAST CALENDAR YEAR</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zir.3"><tr><th  style="text-align: left" class="moduleLabel">LIVED WITH PATIENT</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zir.4"><tr><th  style="text-align: left" class="moduleLabel">AMOUNT CONTRIBUTED TO SPOUSE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zir.5"><tr><th  style="text-align: left" class="moduleLabel">DEPENDENT CHILDREN</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zir.6"><tr><th  style="text-align: left" class="moduleLabel">INCAPABLE OF SELF SUPPORT</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zir.7"><tr><th  style="text-align: left" class="moduleLabel">CONTRIBUTED TO SUPPORT</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zir.8"><tr><th  style="text-align: left" class="moduleLabel">CHILD HAD INCOME</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zir.9"><tr><th  style="text-align: left" class="moduleLabel">INCOME AVAILABLE TO YOU</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zir.10"><tr><th  style="text-align: left" class="moduleLabel">NUMBER OF DEPENDENT CHILDREN</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zir.11"><tr><th  style="text-align: left" class="moduleLabel">TOTAL DEPENDENTS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zir.12"><tr><th  style="text-align: left" class="moduleLabel">PATIENT INCOME</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zir.13"><tr><th  style="text-align: left" class="moduleLabel">TOTAL DEPENDENTS NOT APPLICABLE FOR MT INDICATORS AS,N,X,U</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zir.14"><tr><th  style="text-align: left" class="moduleLabel">DEPENDENT CHILD SCHOOL INDICATOR</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zir.15"><tr><th  style="text-align: left" class="moduleLabel">CONTRIBUTED TO SPOUSE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	
	<!-- ZIV VA Specific Message Processing Segment-->
	<xsl:template match="esr:ziv">
		<tr><td colspan="2" class="segmentheader">ZIV - VA Specific Message Processing Segment</td></tr>
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="esr:ziv.1"><tr><th  style="text-align: left" class="moduleLabel">SET ID</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:ziv.2"><tr><th  style="text-align: left" class="moduleLabel">INCOME YEAR</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:ziv.3"><tr><th  style="text-align: left" class="moduleLabel">CLIENT ID ERROR MESSAGE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:ziv.4"><tr><th  style="text-align: left" class="moduleLabel">NEW CLIENT SSN</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:ziv.5"><tr><th  style="text-align: left" class="moduleLabel">SPOUSE ID ERROR MESSAGE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:ziv.6"><tr><th  style="text-align: left" class="moduleLabel">NEW SPOUSE SSN</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:ziv.7"><tr><th  style="text-align: left" class="moduleLabel">SPOUSE ID (INTERNAL ENTRY NUMBER)</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:ziv.8"><tr><th  style="text-align: left" class="moduleLabel">IVM CASE STATUS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:ziv.9"><tr><th  style="text-align: left" class="moduleLabel">IVM ID (INTERNAL)</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:ziv.10"><tr><th  style="text-align: left" class="moduleLabel">INSURANCE UPLOAD STATUS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:ziv.11"><tr><th  style="text-align: left" class="moduleLabel">REASON INS. NOT UPLOADED</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:ziv.12"><tr><th  style="text-align: left" class="moduleLabel">CLIENT DATE OF DEATH</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>

	<!-- ZMH VA Specific Military History Segment-->
	<xsl:template match="esr:zmh">
		<tr><td colspan="2" class="segmentheader">ZMH - VA Specific Military History Segment</td></tr>
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="esr:zmh.1"><tr><th  style="text-align: left" class="moduleLabel">SET ID Military History</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zmh.2"><tr><th  style="text-align: left" class="moduleLabel">MILITARY HISTORY TYPE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zmh.3"><tr><th  style="text-align: left" class="moduleLabel">SERVICE INDICATOR</th><td class="moduleValue"><xsl:apply-templates/> </td></tr></xsl:template>
	<xsl:template match="esr:zmh.4"><tr><th  style="text-align: left" class="moduleLabel">SERVICE ENTRY DATE AND SERVICE SEPARATION DATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zmh.5"><tr><th  style="text-align: left" class="moduleLabel">SERVICE COMPONENT</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zmh.8"><tr><th  style="text-align: left" class="moduleLabel">FUTURE DISCHARGE DATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>

	<!-- ZMT VA Specific Means Test Information Segment-->
	<xsl:template match="esr:zmt">
		<tr><td colspan="2" class="segmentheader">ZMT - VA Specific Means Test Information Segment</td></tr>
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="esr:zmt.1"><tr><th  style="text-align: left" class="moduleLabel">SET ID</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zmt.2"><tr><th  style="text-align: left" class="moduleLabel">MEANS TEST DATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zmt.3"><tr><th  style="text-align: left" class="moduleLabel">MEANS TEST STATUS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zmt.4"><tr><th  style="text-align: left" class="moduleLabel">INCOME</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zmt.5"><tr><th  style="text-align: left" class="moduleLabel">NET WORTH</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zmt.6"><tr><th  style="text-align: left" class="moduleLabel">DATE and TIME OF ADJUDICATION</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zmt.7"><tr><th  style="text-align: left" class="moduleLabel">AGREED TO PAY DEDUCTIBLE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zmt.8"><tr><th  style="text-align: left" class="moduleLabel">THRESHOLD A</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zmt.9"><tr><th  style="text-align: left" class="moduleLabel">DEDUCTIBLE EXPENSES</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zmt.10"><tr><th  style="text-align: left" class="moduleLabel">DATE and TIME MT COMPLETED</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zmt.11"><tr><th  style="text-align: left" class="moduleLabel">PREVIOUS YR MT THRESHOLD FLAG</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zmt.12"><tr><th  style="text-align: left" class="moduleLabel">TOTAL DEPENDENTS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zmt.13"><tr><th  style="text-align: left" class="moduleLabel">HARDSHIP</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zmt.14"><tr><th  style="text-align: left" class="moduleLabel">HARDSHIP REVIEW DATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zmt.15"><tr><th  style="text-align: left" class="moduleLabel">DATE VETERAN SIGNED TEST</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zmt.16"><tr><th  style="text-align: left" class="moduleLabel">DECLINES TO GIVE INCOME INFO</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zmt.17"><tr><th  style="text-align: left" class="moduleLabel">TYPE OF TEST</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zmt.18"><tr><th  style="text-align: left" class="moduleLabel">SOURCE OF TEST</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zmt.19"><tr><th  style="text-align: left" class="moduleLabel">PRIMARY TEST?</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zmt.20"><tr><th  style="text-align: left" class="moduleLabel">DATE IVM VERIF. MT COMPLETED</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zmt.21"><tr><th  style="text-align: left" class="moduleLabel">REFUSED TO SIGN</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zmt.22"><tr><th  style="text-align: left" class="moduleLabel">SITE CONDUCTING TEST</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zmt.23"><tr><th  style="text-align: left" class="moduleLabel">HARDSHIP REVIEW SITE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zmt.24"><tr><th  style="text-align: left" class="moduleLabel">HARDSHIP EFFECTIVE DATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zmt.25"><tr><th  style="text-align: left" class="moduleLabel">DATE and TIME TEST LAST EDITED</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zmt.26"><tr><th  style="text-align: left" class="moduleLabel">TEST DETERMINED STATUS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zmt.27"><tr><th  style="text-align: left" class="moduleLabel">Means Test Signature Indicator</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zmt.28"><tr><th  style="text-align: left" class="moduleLabel">GMT Threshold</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zmt.29"><tr><th  style="text-align: left" class="moduleLabel">Hardship Reason</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zmt.30"><tr><th  style="text-align: left" class="moduleLabel">VERSION</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zmt.31"><tr><th  style="text-align: left" class="moduleLabel">BT FINANCIAL INDICATOR</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	
<!-- ZPD – VA Specific Patient Info Segment  -->	
	<xsl:template match="esr:zpd">
		<tr><td colspan="2" class="segmentheader">ZPD - VA Specific Patient Info</td></tr>			
		<!-- print the attributes -->
		<xsl:apply-templates/>		      
	</xsl:template>	

	<xsl:template match="esr:zpd.1"><tr><th  style="text-align: left" class="moduleLabel">SET ID - PATIENT ID</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zpd.2"><tr><th  style="text-align: left" class="moduleLabel">REMARKS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zpd.3"><tr><th  style="text-align: left" class="moduleLabel">PLACE OF BIRTH CITY</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zpd.4"><tr><th  style="text-align: left" class="moduleLabel">PLACE OF BIRTH STATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zpd.5"><tr><th  style="text-align: left" class="moduleLabel">CURRENT MEANS TEST STATUS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zpd.6"><tr><th  style="text-align: left" class="moduleLabel">FATHER'S NAME</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zpd.7"><tr><th  style="text-align: left" class="moduleLabel">MOTHER'S NAME</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zpd.8"><tr><th  style="text-align: left" class="moduleLabel">RATED INCOMPETENT</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zpd.9"><tr><th  style="text-align: left" class="moduleLabel">DATE OF DEATH</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zpd.10"><tr><th  style="text-align: left" class="moduleLabel">COLLATERAL SPONSOR</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zpd.11"><tr><th  style="text-align: left" class="moduleLabel">ACTIVE HEALTH INSURANCE?</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zpd.12"><tr><th  style="text-align: left" class="moduleLabel">ELIGIBLE FOR MEDICAID?</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zpd.13"><tr><th  style="text-align: left" class="moduleLabel">DATE MEDICAID LAST ASKED</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zpd.14"><tr><th  style="text-align: left" class="moduleLabel">RACE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zpd.15"><tr><th  style="text-align: left" class="moduleLabel">RELIGION</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zpd.16"><tr><th  style="text-align: left" class="moduleLabel">HOMELESS INDICATOR</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zpd.17"><tr><th  style="text-align: left" class="moduleLabel">POW STATUS INDICATED?</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zpd.18"><tr><th  style="text-align: left" class="moduleLabel">TYPE OF INSURANCE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zpd.19"><tr><th  style="text-align: left" class="moduleLabel">MEDICATION COPAYMENT EXEMPTION STATUS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zpd.20"><tr><th  style="text-align: left" class="moduleLabel">POW CONFINEMENT LOCATION</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zpd.21"><tr><th  style="text-align: left" class="moduleLabel">PRIMARY CARE TEAM</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zpd.22"><tr><th  style="text-align: left" class="moduleLabel">GI INSURANCE POLICY</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zpd.23"><tr><th  style="text-align: left" class="moduleLabel">AMOUNT OF GI INSURANCE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zpd.24"><tr><th  style="text-align: left" class="moduleLabel">MOST RECENT DATE OF CARE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zpd.25"><tr><th  style="text-align: left" class="moduleLabel">MOST RECENT LOCATION OF CARE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zpd.26"><tr><th  style="text-align: left" class="moduleLabel">2ND MOST RECENT DATE OF CARE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zpd.27"><tr><th  style="text-align: left" class="moduleLabel">2ND MOST RECENT LOCATION OF CARE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zpd.28"><tr><th  style="text-align: left" class="moduleLabel">DATE RULED INCOMPETENT (CIVIL)</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zpd.29"><tr><th  style="text-align: left" class="moduleLabel">DATE RULED INCOMPETENT (VA)</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zpd.30"><tr><th  style="text-align: left" class="moduleLabel">SPINAL CORD INJURY</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zpd.31"><tr><th  style="text-align: left" class="moduleLabel">SOURCE OF DEATH NOTIFICATION</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zpd.32"><tr><th  style="text-align: left" class="moduleLabel">DATETIME OF DEATH NOTIFICATION</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zpd.33"><tr><th  style="text-align: left" class="moduleLabel">FILIPINO VETERAN PROOF</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zpd.34"><tr><th  style="text-align: left" class="moduleLabel">PSEUDO SSN REASON - VETERAN</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zpd.35"><tr><th  style="text-align: left" class="moduleLabel">AGENCY/ALLIED COUNTRY</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>	
	<xsl:template match="esr:zpd.36"><tr><th  style="text-align: left" class="moduleLabel"></th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>	
	<xsl:template match="esr:zpd.37"><tr><th  style="text-align: left" class="moduleLabel"></th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>	
	<xsl:template match="esr:zpd.38"><tr><th  style="text-align: left" class="moduleLabel"></th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>	
	<xsl:template match="esr:zpd.39"><tr><th  style="text-align: left" class="moduleLabel"></th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>	
	<xsl:template match="esr:zpd.40"><tr><th  style="text-align: left" class="moduleLabel">EMERGENCY RESPONSE INDICATOR</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>	
	<xsl:template match="esr:zpd.41"><tr><th  style="text-align: left" class="moduleLabel">VOA ATTACHMENTS INDICATOR</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>	

	<!-- ZRD VA Specific Rated Disabilities Segment-->
	<xsl:template match="esr:zrd">
		<tr><td colspan="2" class="segmentheader">ZRD - VA Specific Rated Disabilities Segment</td></tr>
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="esr:zrd.1"><tr><th  style="text-align: left" class="moduleLabel">SET ID</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zrd.2"><tr><th  style="text-align: left" class="moduleLabel">DISABILITY CONDITION</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zrd.3"><tr><th  style="text-align: left" class="moduleLabel">DISABILITY %</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zrd.4"><tr><th  style="text-align: left" class="moduleLabel">SERVICE CONNECTED RATED DISABILITY</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zrd.5"><tr><th  style="text-align: left" class="moduleLabel">NA</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zrd.6"><tr><th  style="text-align: left" class="moduleLabel">NA</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zrd.7"><tr><th  style="text-align: left" class="moduleLabel">NA</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zrd.8"><tr><th  style="text-align: left" class="moduleLabel">NA</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zrd.9"><tr><th  style="text-align: left" class="moduleLabel">NA</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zrd.10"><tr><th  style="text-align: left" class="moduleLabel">NA</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zrd.11"><tr><th  style="text-align: left" class="moduleLabel">NA</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zrd.12"><tr><th  style="text-align: left" class="moduleLabel">DIAGNOSTIC EXTREMITY (Bilateral Factor)</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zrd.13"><tr><th  style="text-align: left" class="moduleLabel">RATED DISABILITY (Original Effective Date)</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zrd.14"><tr><th  style="text-align: left" class="moduleLabel">RATED DISABILITY (Current Effective Date)</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>

	<!-- ZSP VA Specific Service Period Segment-->
	<xsl:template match="esr:zsp">
		<tr><td colspan="2" class="segmentheader">ZSP - VA Specific Service Period Segment</td></tr>
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="esr:zsp.1"><tr><th  style="text-align: left" class="moduleLabel">SET ID</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zsp.2"><tr><th  style="text-align: left" class="moduleLabel">SERVICE CONNECTED?</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zsp.3"><tr><th  style="text-align: left" class="moduleLabel">SERVICE CONNECTED PERCENTAGE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zsp.4"><tr><th  style="text-align: left" class="moduleLabel">PERIOD OF SERVICE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zsp.5"><tr><th  style="text-align: left" class="moduleLabel">VIETNAM SERVICE INDICATED?</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zsp.6"><tr><th  style="text-align: left" class="moduleLabel">P and T</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zsp.7"><tr><th  style="text-align: left" class="moduleLabel">UNEMPLOYABLE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zsp.8"><tr><th  style="text-align: left" class="moduleLabel">SC AWARD DATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zsp.9"><tr><th  style="text-align: left" class="moduleLabel">SERVICE VERIFICATION DATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zsp.10"><tr><th  style="text-align: left" class="moduleLabel">P and T EFFECTIVE DATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zsp.11"><tr><th  style="text-align: left" class="moduleLabel">COMBINED SC PERCENT EFFECTIVE DATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zsp.12"><tr><th  style="text-align: left" class="moduleLabel">ELIGIBLE FOR CLASS II DENTAL</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zsp.13"><tr><th  style="text-align: left" class="moduleLabel">CLASS II DENTAL APPLICATION DUE BEFORE DATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>

<!-- ZTA – VA Specific Temporary Address Segment -->	
	<xsl:template match="esr:zta">
		<tr><td colspan="2" class="segmentheader">ZTA - VA Specific Temporary Address</td></tr>			
		<!-- print the attributes -->
		<xsl:apply-templates/>		      
	</xsl:template>						
	<xsl:template match="esr:zta.1"><tr><th  style="text-align: left" class="moduleLabel">SET ID - PATIENT ID</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>	
	<xsl:template match="esr:zta.2"><tr><th  style="text-align: left" class="moduleLabel">TEMPORARY ADDRESS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zta.3"><tr><th  style="text-align: left" class="moduleLabel">TEMPORARY ADDRESS START</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zta.4"><tr><th  style="text-align: left" class="moduleLabel">TEMPORARY ADDRESS END</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zta.5"><tr><th  style="text-align: left" class="moduleLabel">TEMPORARY ADDRESS</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zta.6"><tr><th  style="text-align: left" class="moduleLabel">TEMPORARY ADDRESS COUNTY</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zta.7"><tr><th  style="text-align: left" class="moduleLabel">TEMPORARY ADDRESS PHONE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zta.8"><tr><th  style="text-align: left" class="moduleLabel">Temp Address Date/Time Last Updated</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zta.9"><tr><th  style="text-align: left" class="moduleLabel">Temp Address Site of Change</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>

<!-- ZHP VA Specific Health Benefit Plan Segment-->
	<xsl:template match="esr:zhp">
		<tr><td colspan="2" class="segmentheader">ZHP - VA Specific Health Benefit Plan Segment</td></tr>
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="esr:zhp.1"><tr><th  style="text-align: left" class="moduleLabel">SET ID HEALTH BENEFIT PLAN</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zhp.2"><tr><th  style="text-align: left" class="moduleLabel">HEALTH BENEFIT PLAN CODE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zhp.3"><tr><th  style="text-align: left" class="moduleLabel">HEALTH BENEFIT PLAN LAST UPDATED DATE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zhp.4"><tr><th  style="text-align: left" class="moduleLabel">HEALTH BENEFIT PLAN LAST UPDATED BY SOURCE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
	<xsl:template match="esr:zhp.5"><tr><th  style="text-align: left" class="moduleLabel">HEALTH BENEFIT PLAN LAST UPDATED BY SITE</th><td class="moduleValue"><xsl:apply-templates/></td></tr></xsl:template>
</xsl:stylesheet>
